/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Font;
import oracle.dss.graph.pfj.FontCacheElement;

public class FontCache {
    static final int NUM_FONTS = 50;
    static final int NOT_FOUND = -1;
    protected FontCacheElement[] m_fontStuffArray;
    protected int m_nCount;

    private void $init$() {
        this.m_fontStuffArray = null;
        this.m_nCount = 0;
    }

    public FontCache() {
        this.$init$();
        this.m_fontStuffArray = new FontCacheElement[50];
        this.m_nCount = 0;
    }

    public void addToCache(String szFontName, int nFontStyle, int nFontSize, Font font) {
        FontCacheElement fso = new FontCacheElement(szFontName, nFontStyle, nFontSize, font, this.m_nCount);
        int lru = this.m_nCount;
        int lruPos = 49;
        int i = 0;
        while (i < 50) {
            if (this.m_fontStuffArray[i] == null) {
                this.m_fontStuffArray[i] = fso;
                return;
            }
            if (this.m_fontStuffArray[i].m_nCount < lru) {
                lru = this.m_fontStuffArray[i].m_nCount;
                lruPos = i;
            }
            ++i;
        }
        this.m_fontStuffArray[lruPos] = fso;
    }

    public int cachePosition(String szFontName, int nFontStyle, int nFontSize) {
        int pos = -1;
        int i = 0;
        while (i < 50) {
            FontCacheElement fso = this.m_fontStuffArray[i];
            if (fso == null) break;
            if (fso.m_fontSize == nFontSize && fso.m_fontStyle == nFontStyle && fso.m_fontName.equals(szFontName)) {
                pos = i;
                break;
            }
            ++i;
        }
        return pos;
    }

    public Font getFont(String szFontName, int nFontStyle, int nFontSize) {
        Font font;
        int index = this.cachePosition(szFontName, nFontStyle, nFontSize);
        if (this.m_nCount == Integer.MAX_VALUE) {
            int i = 0;
            while (i < 50) {
                if (this.m_fontStuffArray[i] != null && this.m_fontStuffArray[i].m_nCount > 0) {
                    this.m_fontStuffArray[i].m_nCount -= Integer.MAX_VALUE;
                }
                ++i;
            }
            this.m_nCount = 1;
        } else {
            ++this.m_nCount;
        }
        if (index == -1) {
            font = new Font(szFontName, nFontStyle, nFontSize);
            this.addToCache(szFontName, nFontStyle, nFontSize, font);
        } else {
            font = this.m_fontStuffArray[index].m_font;
            this.m_fontStuffArray[index].m_nCount = this.m_nCount;
        }
        return font;
    }
}

