/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.FunnelLabelContainer;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Funnel;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class FunnelSliceLabelContainer {
    protected Perspective m_perspective;
    protected Access m_access;
    protected JChart_2D_Funnel m_chart;
    protected boolean m_lastStageOnly;
    protected double[] m_targetValues;
    protected int m_nTotalGroups;
    protected int m_nTotalSeries;
    protected static final double FONT_GAP = 0.33;
    private TextStyleObj m_textStyles;
    private Vector m_sliceLabels;
    private Vector m_truncatedSliceLabels;
    private double m_SliceLabelMaxWidth;
    private FontMetrics m_sliceLabelFM;
    private VC m_vc;
    private double m_sliceLabelGap;
    private double[] m_slicePercents;
    private int m_nTextFormat;
    private String m_strTextFormatPattern;
    private int[] m_sliceLabelWidths;
    private int m_maxSliceLabelWidth;
    private int m_sliceCount;

    private void $init$() {
        this.m_maxSliceLabelWidth = -1;
    }

    public FunnelSliceLabelContainer(Perspective m_perspective, JChart_2D_Funnel m_chart) {
        this.$init$();
        this.m_perspective = m_perspective;
        this.m_access = m_chart.m_Access;
        this.m_chart = m_chart;
        this.calc_init();
    }

    public void calc_init() {
        this.m_sliceLabels = new Vector();
        this.m_truncatedSliceLabels = new Vector();
        this.m_SliceLabelMaxWidth = 0.0;
        this.m_nTotalGroups = this.m_access.getNumTotalGroups();
        this.m_nTotalSeries = this.m_access.getNumTotalSeries();
        this.m_slicePercents = new double[this.m_nTotalGroups + 1];
        this.m_vc = this.m_perspective.getVC();
        this.m_nTextFormat = this.m_perspective.getFunnelTextFormat();
        this.m_strTextFormatPattern = this.m_perspective.getFunnelTextFormatPattern();
        this.createTextStyle();
        this.m_sliceLabelGap = this.calcStageLabelGap();
        this._calcAllSlicePercents();
        this._getSliceLabels();
        this._calcWidthOfSlices();
        this.m_maxSliceLabelWidth = this._calcMaxSliceLabelWidth();
    }

    public double getActualValue(int g) {
        SeriesEnumerator sEnum = this.m_chart.getResetSeriesEnumerator();
        int s = sEnum.getAbsoluteSeries(0);
        PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
        DatumObj dobj = this.m_chart.getDataValue(s, g);
        double actualValue = dobj.m_fValue;
        return actualValue;
    }

    public double getTargetValue(int g) {
        double targetValue = 0.0;
        if (this.m_lastStageOnly) {
            targetValue = this.m_targetValues[g];
        } else {
            SeriesEnumerator sEnum = this.m_chart.getResetSeriesEnumerator();
            int s = sEnum.getAbsoluteSeries(1);
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            DatumObj dobj = this.m_chart.getDataValue(s, g);
            targetValue = dobj.m_fValue;
        }
        return targetValue;
    }

    public Vector getLabels() {
        return this.m_sliceLabels;
    }

    public TextStyleObj getTextStyleObject() {
        return this.m_textStyles;
    }

    public int[] getSliceWidths() {
        return this.m_sliceLabelWidths;
    }

    public double getSliceLabelGap() {
        return this.m_sliceLabelGap;
    }

    public Vector getTruncatedLabels() {
        return this.m_truncatedSliceLabels;
    }

    public int getMaxSliceLabelWidth() {
        return this.m_maxSliceLabelWidth;
    }

    public FontMetrics getFontMetrics() {
        return this.m_sliceLabelFM;
    }

    public double[] getPercents() {
        return this.m_slicePercents;
    }

    public TextStyleObj getTextStyle() {
        return this.m_textStyles;
    }

    public int[] getLabelWidthArray() {
        return this.m_sliceLabelWidths;
    }

    public int getSliceCount() {
        return this.m_sliceCount;
    }

    public int getFontHeight() {
        return TextStyleObj.getFontHeight(this.m_sliceLabelFM, this.m_perspective.getFontMetricsResolver());
    }

    public int getFirstSliceLabelWidth() {
        return this.m_sliceLabelWidths[0];
    }

    public int getLastSliceLabelWidth() {
        return this.m_sliceLabelWidths[this.m_sliceLabelWidths.length - 1];
    }

    protected void createTextStyle() {
        IdentObj id = this.m_perspective.getFunnelSliceLabel();
        int textRotation = this.m_perspective.getTextRotation(id);
        this.m_textStyles = new TextStyleObj(this.m_perspective.m_fontCache, this.m_perspective.getFontName(id), this.m_perspective.getFontStyle(id), this.m_perspective.getFontSizeAbsolute(id), this.m_perspective.getFontSize(id), this.m_perspective.getFontSizeVC(id), textRotation, 2, this.m_perspective.getTextJustVert(id), false, false, this.m_perspective.getTextWrap(id));
    }

    private FontMetrics _getSliceLabelFontMetrics() {
        if (this.m_sliceLabelFM == null) {
            Graphics graphics = this.m_perspective.getGraphicsContext();
            Font font = this.m_textStyles.getFont(this.m_vc);
            this.m_sliceLabelFM = graphics.getFontMetrics(font);
            return this.m_sliceLabelFM;
        }
        return this.m_sliceLabelFM;
    }

    private void _getSliceLabels() {
        int series = 0;
        FontMetrics fm = this._getSliceLabelFontMetrics();
        GroupsEnumerator gEnum = this.m_chart.getResetGroupsEnumerator();
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            double fSlicePct = this.m_slicePercents[g + 1] / 100.0;
            this._getSliceLabelForValue(series, g, fSlicePct, fm);
        }
    }

    private void _getSliceLabelForValue(int s, int g, double fValue, FontMetrics fm) {
        String str;
        if (this.m_perspective.isNumberFormatCallBack()) {
            this.m_perspective.getNumberFormatCallBack().setState(6, s, g, -1, -3);
            str = this.m_perspective.getNumberFormatCallBack().toString(fValue);
        } else {
            str = TDGNumberFormat.toString(this.m_perspective, this.m_nTextFormat, fValue, this.m_strTextFormatPattern);
        }
        this.m_sliceLabels.addElement(str);
        this.m_truncatedSliceLabels.addElement(str);
    }

    private double _getGroupPercent(int g) {
        double percent = 0.0;
        if (!this.m_lastStageOnly) {
            boolean isPercentMeasure = (Boolean)this.m_perspective.getFromLook(Perspective.s_identObjGlobal, Attr.FunnelPercentMeasure);
            if (isPercentMeasure) {
                SeriesEnumerator sEnum = this.m_chart.getResetSeriesEnumerator();
                int s = sEnum.getAbsoluteSeries(0);
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                DatumObj dobj = this.m_chart.getDataValue(s, g);
                percent = dobj.m_fValue;
                return percent;
            }
        }
        double fValue1 = this.getActualValue(g);
        double fValue2 = this.getTargetValue(g);
        if (fValue2 == 0.0) {
            percent = 0.0;
            String err = "Setting the percent for group " + g + " to 0 as the target value is 0";
            this.m_perspective.getErrorHandler().log(err, this.getClass().getName(), "_getGroupPercent()");
        } else {
            percent = fValue1 / fValue2 * 100.0;
        }
        return percent;
    }

    private void _calcAllSlicePercents() {
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_perspective, this.m_access, true);
        int stageIndex = 0;
        this.m_sliceCount = gEnum.getNumGroups();
        this.m_lastStageOnly = (Boolean)this.m_perspective.getFromLook(Perspective.s_identObjGlobal, Attr.LastStageOnly);
        if (this.m_lastStageOnly) {
            this.m_lastStageOnly = false;
            int lastGroupIndex = gEnum.getNumGroups() - 1;
            int numOfGroups = gEnum.getNumGroups();
            this.m_targetValues = new double[numOfGroups];
            this.m_targetValues[lastGroupIndex] = this.getTargetValue(lastGroupIndex);
            double targetFactor = ((Integer)this.m_perspective.getFromLook(Perspective.s_identObjGlobal, Attr.TargetFactor)).intValue();
            double multiFactor = Math.pow(targetFactor, 1.0 / (double)(numOfGroups - 1));
            int i = lastGroupIndex - 1;
            int j = 1;
            while (i >= 0) {
                this.m_targetValues[i] = this.m_targetValues[lastGroupIndex] * Math.pow(multiFactor, j);
                --i;
                ++j;
            }
            this.m_lastStageOnly = true;
        }
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            this.m_slicePercents[stageIndex + 1] = this._getGroupPercent(g);
            ++stageIndex;
        }
    }

    private double calcStageLabelGap() {
        return (double)TextStyleObj.getFontHeight(this._getSliceLabelFontMetrics(), this.m_perspective.getFontMetricsResolver()) * 0.33;
    }

    private void _calcWidthOfSlices() {
        this.m_sliceLabelWidths = new int[this.m_nTotalGroups];
        String label = null;
        Enumeration enumerator = this.m_sliceLabels.elements();
        int i = 0;
        while (enumerator.hasMoreElements()) {
            label = (String)enumerator.nextElement();
            this.m_sliceLabelWidths[i] = FunnelLabelContainer.getWidth(this.m_sliceLabelFM, label, this.m_perspective.getFontMetricsResolver());
            ++i;
        }
    }

    private int _calcMaxSliceLabelWidth() {
        return FunnelLabelContainer.getMaxWidth(this.m_sliceLabelFM, this.m_sliceLabels, this.m_perspective.getFontMetricsResolver());
    }
}

