/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dss.dataView.ImageViewExportXMLWriter;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.SFX;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.ObjClassID;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BorderObj;
import oracle.dss.graph.pfj.draw.ColorPinObj;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.FillGradientObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.util.ErrorHandler;

public class GraphExportXMLWriter
extends ImageViewExportXMLWriter {
    private Perspective m_pfj;
    private boolean m_bElementFilled;
    private DetObj m_detObj;
    public static final String ELEM_GRAPH = "graph";
    public static final String ELEM_REF_OBJ = "ro";
    public static final String ELEM_REFERENCE_OBJECTS = "ros";
    public static final String ATTR_DATA_SCROLL_EVENT_JS = "dataScrollEventJs";
    public static final String ATTR_DATA_ZOOM_IN_BUTTON_EVENT_JS = "dataZoomInButtonEventJs";
    public static final String ATTR_DATA_ZOOM_OUT_BUTTON_EVENT_JS = "dataZoomOutButtonEventJs";
    public static final String ATTR_DATA_ZOOM_IN_CLICK_EVENT_JS = "dataZoomInClickEventJs";
    public static final String ATTR_DATA_ZOOM_OUT_CLICK_EVENT_JS = "dataZoomOutClickEventJs";
    public static final String ATTR_DATA_ZOOM_IN_RECT_EVENT_JS = "dataZoomInRectEventJs";
    public static final String ATTR_DATA_ZOOM_OUT_RECT_EVENT_JS = "dataZoomOutRectEventJs";
    public static final String ATTR_GRAPH_TYPE = "graphType";
    public static final String ATTR_LINE_SELECT_POINT_EVENT_JS = "lineSelectPointEventJs";
    public static final String ATTR_SCROLL_LABELS = "scrollLabels";
    public static final String ATTR_SCROLL_MAX_VAL = "scrollMaxVal";
    public static final String ATTR_DATE_FORMAT = "dateFormat";
    public static final String MONTH_FORMAT = "MONTH";
    public static final String DAY_FORMAT = "DAY";
    public static final String HOUR_FORMAT = "HOUR";
    public static final String MINUTE_FORMAT = "MINUTE";
    public static final String SECOND_FORMAT = "SECOND";
    public static final String ATTR_SCROLL_MIN_VAL = "scrollMinVal";
    public static final String ATTR_SCROLL_SPAN = "scrollSpan";
    public static final String ATTR_SCROLL_START = "scrollStart";
    public static final String ATTR_SCROLL_TOTAL = "scrollTotal";
    public static final String ATTR_SERIES_ROLLOVER_BEHAVIOR = "sr";
    public static final String ATTR_TIME_AXIS_END_DATE = "timeAxisEndDate";
    public static final String ATTR_TIME_AXIS_END_PIXEL = "timeAxisEndPixel";
    public static final String ATTR_TIME_AXIS_EVENT_JS = "timeAxisEventJs";
    public static final String ATTR_TIME_AXIS_START_DATE = "timeAxisStartDate";
    public static final String ATTR_TIME_AXIS_START_PIXEL = "timeAxisStartPixel";
    public static final String ATTR_TIME_SELECTOR_EVENT_JS = "timeSelectorEventJs";
    public static final String ATTR_TRANSLATED_END = "translatedEnd";
    public static final String ATTR_TRANSLATED_START = "translatedStart";
    public static final String ATTR_Y1_BASELINE = "y1Baseline";
    public static final String ATTR_Y1_MAX_VAL = "y1MaxVal";
    public static final String ATTR_Y1_MIN_VAL = "y1MinVal";
    public static final String ATTR_ZOOM_DIR = "zoomDir";
    public static final String ATTR_PIE_TILT = "pieTilt";
    public static final String ATTR_PIE_DEPTH = "pieDepth";
    public static final String ATTR_PIE_SLICE_EXPLODE = "pieSliceExplode";
    public static final String ATTR_THREED_EFFECT = "threed";
    public static final String URL_SM_DRILL_UP_ARROW = "/bi/images/graph/graph_drill_up.gif";
    public static final String URL_LG_DRILL_UP_ARROW = "/bi/images/graph/large_drill_up.gif";
    public static final String OBJ_LINE_MARKER = "LM";
    protected CommonGraph m_graph;

    public GraphExportXMLWriter(Perspective p, OutputStream os, ErrorHandler eh, String charEnc) {
        super(os, eh, charEnc);
        this.$init$();
        this.init(p);
    }

    public GraphExportXMLWriter(Perspective p, OutputStream os, ErrorHandler eh) {
        super(os, eh);
        this.$init$();
        this.init(p);
    }

    public GraphExportXMLWriter(Perspective p, Writer writer, ErrorHandler eh, String charEnc) {
        super(writer, eh, charEnc);
        this.$init$();
        this.init(p);
    }

    public GraphExportXMLWriter(Perspective p, Writer writer, ErrorHandler eh) {
        super(writer, eh);
        this.$init$();
        this.init(p);
    }

    protected void init(Perspective p) {
        this.m_pfj = p;
    }

    public void init(DetObj detObj) {
        this.m_detObj = detObj;
        this.m_bElementFilled = false;
    }

    public String getDataZoomInRectSubmitJS() {
        return null;
    }

    public String getDataZoomOutRectSubmitJS() {
        return null;
    }

    public String getDataZoomInClickSubmitJS() {
        return null;
    }

    public String getDataZoomOutClickSubmitJS() {
        return null;
    }

    protected String getDataZoomInButtonSubmitJS(String axis) {
        return null;
    }

    protected String getDataZoomOutButtonSubmitJS(String axis) {
        return null;
    }

    protected String getDataScrollSubmitJS(String axis) {
        return null;
    }

    public String getDrillJS(DetObj detObj) {
        return null;
    }

    public String getDrillTooltip(DetObj detObj) {
        return null;
    }

    public String getLineSelectPointSubmitJS() {
        return null;
    }

    public String getTimeAxisEventSubmitJS() {
        return null;
    }

    public String getTimeSelectorSubmitJS() {
        return null;
    }

    public boolean startGraphElement() throws IOException, Exception {
        this.startElement(ELEM_GRAPH);
        Dimension rSize = this.m_pfj.getImageSize();
        this.writeAttribute("w", rSize.width);
        this.writeAttribute("h", rSize.height);
        this.writeAttribute(ATTR_GRAPH_TYPE, CommonGraph.convertGraphTypeToString(this.m_pfj.getGraphType()));
        String sSeriesRolloverBehavior = "";
        int seriesRolloverBehavior = this.m_pfj.getIntegerProp(Attr.SeriesRolloverBehavior);
        if ((seriesRolloverBehavior & 1) == 1) {
            sSeriesRolloverBehavior = sSeriesRolloverBehavior + "RB_HIGHLIGHT";
        }
        if ((seriesRolloverBehavior & 2) == 2) {
            if (sSeriesRolloverBehavior.length() > 0) {
                sSeriesRolloverBehavior = sSeriesRolloverBehavior + " ";
            }
            sSeriesRolloverBehavior = sSeriesRolloverBehavior + "RB_DIM";
        }
        if (sSeriesRolloverBehavior != null && sSeriesRolloverBehavior.length() > 0) {
            this.writeAttribute(ATTR_SERIES_ROLLOVER_BEHAVIOR, sSeriesRolloverBehavior);
        }
        if (this.isActiveDataService() || this.isPPRAnimation()) {
            this.writeAttribute("ads", "on");
        }
        this.writeAnimationAttributes();
        if (this.m_pfj.getDepthRadius() > 0 && this.m_pfj.getDepthAngle() > 0) {
            this.writeAttribute(ATTR_THREED_EFFECT, "t");
        }
        if (this.m_pfj.getJGraphType().isPieType()) {
            this.writeAttribute(ATTR_PIE_TILT, this.m_pfj.getPieTilt());
            this.writeAttribute(ATTR_PIE_DEPTH, this.m_pfj.getPieDepth());
            if (this.isActiveDataService() || this.isPPRAnimation()) {
                StringBuilder sb = new StringBuilder();
                int numSeries = this.m_pfj.getNumSeries();
                int i = 0;
                while (i < numSeries) {
                    if (this.m_pfj.getPieSliceDetach(i) > 0) {
                        if (sb.length() > 0) {
                            sb.append(";");
                        }
                        sb.append(this.m_pfj.getDataGridCallback().getSeriesSliceId(i));
                    }
                    ++i;
                }
                this.writeAttribute(ATTR_PIE_SLICE_EXPLODE, sb.toString());
            }
        }
        return true;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Point2D a, Point2D b) throws IOException, Exception {
        boolean ret = false;
        if (!bb.getTransparentBorderColor() && (ret = a instanceof Point && b instanceof Point ? this.startLineElement(((Point)a).x, ((Point)a).y, ((Point)b).x, ((Point)b).y) : this.startLineElement(a.getX(), a.getY(), b.getX(), b.getY()))) {
            this.writeIdentObjAttributes(id);
            this.writeCachedAttribute("c", bb.getBorderColor(), "l");
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Point2D a, Point2D b, int nThick, int style, boolean isMarker) throws IOException, Exception {
        boolean ret = false;
        String sStyle = null;
        if (style != Perspective.SOLID) {
            sStyle = BaseGraphComponent.convertLineStyleToString(style);
            if (style == Perspective.DASH) {
                if (isMarker) {
                    nThick = 2;
                }
            } else if (style == Perspective.DOTTED) {
                if (isMarker) {
                    nThick = 2;
                }
                if (nThick <= 1) {
                    nThick = 2;
                }
            } else if (style == Perspective.DASH_DOT && isMarker) {
                nThick = 2;
            }
        }
        if (!bb.getTransparentBorderColor()) {
            ret = a instanceof Point && b instanceof Point ? this.startLineElement(((Point)a).x, ((Point)a).y, ((Point)b).x, ((Point)b).y) : this.startLineElement(a.getX(), a.getY(), b.getX(), b.getY());
            if (ret) {
                this.writeCachedAttribute("c", bb.getBorderColor(), "l");
            }
        } else if (!bb.getTransparentFillColor() && (ret = a instanceof Point && b instanceof Point ? this.startLineElement(((Point)a).x, ((Point)a).y, ((Point)b).x, ((Point)b).y) : this.startLineElement(a.getX(), a.getY(), b.getX(), b.getY()))) {
            this.writeCachedAttribute("c", bb.getFillColor(), "l");
        }
        if (ret) {
            this.writeIdentObjAttributes(id);
            if (nThick != 1) {
                this.writeAttribute("lw", nThick);
            }
            if (sStyle != null) {
                this.writeAttribute("ls", sStyle);
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Rectangle rect, int type) throws IOException, Exception {
        boolean ret = false;
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        if (type == 2) {
            x1 = rect.x;
            y1 = rect.y + rect.height;
            x2 = rect.x + rect.width;
            y2 = y1;
        } else if (type == 1) {
            x1 = rect.x;
            y1 = rect.y;
            x2 = x1 + rect.width;
            y2 = y1;
        } else if (type == 3) {
            x1 = rect.x;
            y1 = rect.y;
            x2 = rect.x;
            y2 = rect.y + rect.height;
        } else if (type == 4) {
            x1 = rect.x + rect.width;
            y1 = rect.y;
            x2 = x1;
            y2 = rect.y + rect.height;
        }
        if (!bb.getTransparentBorderColor()) {
            ret = this.startLineElement(x1, y1, x2, y2);
            if (ret) {
                this.writeIdentObjAttributes(id);
                this.writeCachedAttribute("c", bb.getBorderColor(), "l");
            }
        } else if (!bb.getTransparentFillColor() && (ret = this.startLineElement(x1, y1, x2, y2))) {
            this.writeIdentObjAttributes(id);
            this.writeCachedAttribute("c", bb.getFillColor(), "l");
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Rectangle r) throws IOException, Exception {
        return this.startElement(id, bb, r, false, false);
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Rectangle r, boolean bOval, boolean bNoFill) throws IOException, Exception {
        return this.startElement(id, bb, r, bOval, bNoFill, false);
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Rectangle r, boolean bOval, boolean bNoFill, boolean bDotted) throws IOException, Exception {
        boolean ret = false;
        if (bb.getDropShadowOffset() != null) {
            Rectangle rDropShadow = new Rectangle(r.x + bb.getDropShadowOffset().width, r.y + bb.getDropShadowOffset().height, r.width, r.height);
            if (bOval) {
                if (this.startCircleOrOvalElement(rDropShadow)) {
                    this.writeAttribute("fc", bb.getDropShadowColor());
                    this.endElement();
                }
            } else if (this.startRectElement(rDropShadow)) {
                this.writeAttribute("fc", bb.getDropShadowColor());
                this.endElement();
            }
        }
        if (bOval) {
            boolean bTransparentBorder = bb.getTransparentBorderColor();
            boolean bTransparentFill = bb.getTransparentFillColor() || bNoFill;
            ret = this.startCircleOrOvalElement(r);
            if (ret) {
                this.writeIdentObjAttributes(id);
                if (!bTransparentBorder) {
                    this.writeAttribute("bc", bb.getBorderColor());
                }
                if (!bTransparentFill) {
                    this.writeFillAttributes(id, bb, r);
                } else {
                    this.writeCachedAttribute("ft", "ftC", null);
                    this.writeAttribute("fc", "");
                }
            }
        } else {
            boolean bTransparentBorder = bb.getTransparentBorderColor();
            boolean bTransparentFill = bb.getTransparentFillColor() || bNoFill;
            String objId = this.convertObjectIdToString(id);
            if (objId != null && objId.equals(OBJ_LINE_MARKER) && bTransparentFill && bTransparentBorder) {
                if (r != null) {
                    ret = true;
                    this.startElement("lm");
                    String p = r.x + "," + r.y;
                    this.writeAttribute("p", p);
                }
            } else {
                ret = this.startRectElement(r);
                if (ret) {
                    this.writeIdentObjAttributes(id);
                    if (!bTransparentFill) {
                        this.writeFillAttributes(id, bb, r);
                    } else {
                        this.writeCachedAttribute("ft", "ftC", null);
                        this.writeAttribute("fc", "");
                    }
                    if (!bTransparentBorder) {
                        this.writeAttribute("bc", bb.getBorderColor());
                    }
                }
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Rectangle r, boolean bOval, boolean bNoFill, int nWidth) throws IOException, Exception {
        boolean ret = false;
        if (bOval) {
            boolean bTransparentFill = bb.getTransparentFillColor() || bNoFill;
            boolean bTransparentBorder = bb.getTransparentBorderColor();
            ret = this.startCircleOrOvalElement(r);
            if (ret) {
                this.writeIdentObjAttributes(id);
                if (!bTransparentFill) {
                    this.writeFillAttributes(id, bb, r);
                } else {
                    this.writeCachedAttribute("ft", "ftC", null);
                    this.writeAttribute("fc", "");
                }
                if (!bTransparentBorder) {
                    this.writeAttribute("bc", bb.getBorderColor());
                    if (nWidth > 1) {
                        this.writeAttribute("bw", nWidth);
                    }
                }
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Polygon p) throws IOException, Exception {
        boolean ret = false;
        if (bb.getDropShadowOffset() != null) {
            Polygon pDropShadow = new Polygon();
            int i = 0;
            while (i < p.npoints) {
                pDropShadow.addPoint(p.xpoints[i] + bb.getDropShadowOffset().width, p.ypoints[i] + bb.getDropShadowOffset().height);
                ++i;
            }
            if (this.startPolygonElement(pDropShadow)) {
                this.writeCachedAttribute("fc", bb.getDropShadowColor(), "pg");
                this.endElement();
            }
        }
        boolean bTransparentFill = bb.getTransparentFillColor();
        boolean bTransparentBorder = bb.getTransparentBorderColor();
        ret = this.startPolygonElement(p);
        if (ret) {
            this.writeIdentObjAttributes(id);
            if (!bTransparentFill) {
                this.writeFillAttributes(id, bb, p);
            } else {
                this.writeCachedAttribute("ft", "ftC", null);
                this.writeAttribute("fc", "");
            }
            if (!bTransparentBorder) {
                this.writeAttribute("bc", bb.getBorderColor());
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Point[] points) throws IOException, Exception {
        boolean ret = false;
        if (!bb.getTransparentBorderColor() && (ret = this.startPolylineElement(points))) {
            this.writeIdentObjAttributes(id);
            this.writeCachedAttribute("c", bb.getBorderColor(), "pl");
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Point[] points, int nThick, int style, boolean isMarker, boolean shadow) throws IOException, Exception {
        boolean ret = false;
        String sStyle = null;
        if (style != Perspective.SOLID) {
            sStyle = BaseGraphComponent.convertLineStyleToString(style);
            if (style == Perspective.DASH) {
                if (isMarker) {
                    nThick = 2;
                }
            } else if (style == Perspective.DOTTED) {
                if (isMarker) {
                    nThick = 2;
                }
                if (nThick <= 1) {
                    nThick = 2;
                }
            } else if (style == Perspective.DASH_DOT && isMarker) {
                nThick = 2;
            }
        }
        if (!bb.getTransparentBorderColor()) {
            ret = this.startPolylineElement(points);
            if (ret) {
                Color c = shadow ? GraphExportXMLWriter.getBrighter(bb.getBorderColor()) : bb.getBorderColor();
                this.writeCachedAttribute("c", c, "pl");
            }
        } else if (!bb.getTransparentFillColor() && (ret = this.startPolylineElement(points))) {
            Color c = shadow ? GraphExportXMLWriter.getBrighter(bb.getFillColor()) : bb.getFillColor();
            this.writeCachedAttribute("c", c, "pl");
        }
        if (ret) {
            this.writeIdentObjAttributes(id);
            if (nThick != 1) {
                this.writeAttribute("lw", nThick);
            }
            if (sStyle != null) {
                this.writeAttribute("ls", sStyle);
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Arc2D arc) throws IOException, Exception {
        boolean ret = false;
        boolean bTransparentFill = bb.getTransparentFillColor();
        boolean bTransparentBorder = bb.getTransparentBorderColor();
        if (!bTransparentFill && id.getObjectID() == 626 && id.getMiscID() == 623 && !this.m_pfj.getFunnelGradientEffect()) {
            Color col = this.m_pfj.getFillColor(this.m_pfj.getFunnelFrame());
            bb.setFillColor(this.m_pfj.getDarker(col));
        }
        if (arc != null) {
            ret = this.startCircleOrOvalElement(arc);
        }
        if (ret) {
            this.writeIdentObjAttributes(id);
            if (!bTransparentFill) {
                this.writeFillAttributes(id, bb, arc);
            } else {
                this.writeCachedAttribute("ft", "ftC", null);
                this.writeAttribute("fc", "");
            }
            if (!bTransparentBorder) {
                this.writeAttribute("bc", bb.getBorderColor());
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Area area) throws IOException, Exception {
        boolean ret = false;
        boolean bTransparentFill = bb.getTransparentFillColor();
        boolean bTransparentBorder = bb.getTransparentBorderColor();
        ret = this.startPathElement(area);
        if (ret) {
            this.writeIdentObjAttributes(id);
            if (!bTransparentFill) {
                this.writeFillAttributes(id, bb, area);
            } else {
                this.writeCachedAttribute("ft", "ftC", null);
                this.writeAttribute("fc", "");
            }
            if (!bTransparentBorder) {
                this.writeAttribute("bc", bb.getBorderColor());
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Ellipse2D ellipse) throws IOException, Exception {
        boolean ret = false;
        boolean bTransparentFill = bb.getTransparentFillColor();
        boolean bTransparentBorder = bb.getTransparentBorderColor();
        if (!bTransparentFill && id.getObjectID() == 626 && id.getMiscID() == 623 && !this.m_pfj.getFunnelGradientEffect()) {
            Color col = this.m_pfj.getFillColor(this.m_pfj.getFunnelFrame());
            bb.setFillColor(this.m_pfj.getDarker(col));
        }
        if (ret = this.startCircleOrOvalElement(ellipse.getBounds())) {
            this.writeIdentObjAttributes(id);
            if (!bTransparentFill) {
                this.writeFillAttributes(id, bb, ellipse);
            } else {
                this.writeCachedAttribute("ft", "ftC", null);
                this.writeAttribute("fc", "");
            }
            if (!bTransparentBorder) {
                this.writeAttribute("bc", bb.getBorderColor());
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, GeneralPath path) throws IOException, Exception {
        boolean ret = false;
        boolean bTransparentFill = bb.getTransparentFillColor();
        boolean bTransparentBorder = bb.getTransparentBorderColor();
        ret = this.startPathElement(path);
        if (ret) {
            this.writeIdentObjAttributes(id);
            if (!bTransparentFill) {
                this.writeFillAttributes(id, bb, path);
            } else {
                this.writeCachedAttribute("ft", "ftC", null);
                this.writeAttribute("fc", "");
            }
            if (!bTransparentBorder) {
                this.writeAttribute("bc", bb.getBorderColor());
            }
        }
        return ret;
    }

    public void writeElement(IdentObj id, BlackBoxIF bb, Graphics g, String szText, Rectangle rBounds, Rectangle rInnerBounds, TextStyleObj textStyle, VC vc, String drillJS, String link, String[] tooltipsArray) throws IOException, Exception {
        if (!bb.getTransparentFillColor()) {
            Color dropShadowColor = this.m_pfj.getShadowColor(id);
            Dimension dropShadowOffset = null;
            if (this.m_pfj.getShadowDisplay(id) && !bb.getTransparentFillColor()) {
                dropShadowOffset = new Dimension(this.m_pfj.getVC().virtToDestWidth(this.m_pfj.getShadowXOffset(id) * 50), this.m_pfj.getVC().virtToDestHeight(this.m_pfj.getShadowYOffset(id) * 50));
            }
            this.fillColorText(id, bb, g, szText, rBounds, rInnerBounds, dropShadowColor, dropShadowOffset, textStyle, vc, 1, drillJS, link, tooltipsArray);
        }
    }

    protected void fillColorText(IdentObj id, BlackBoxIF bb, Graphics g, String szText, Rectangle rBounds, Rectangle rInnerBounds, Color dropShadowColor, Dimension dropShadowOffset, TextStyleObj textStyle, VC vc, int nBackgroundFillType, String drillJS, String link, String[] tooltipsArray) throws IOException, Exception {
        Color fillColor = bb.getFillColor();
        if (textStyle.getRotationAngle() == 0) {
            this.drawStyledText(id, textStyle, fillColor, g, szText, rInnerBounds, dropShadowColor, dropShadowOffset, vc, drillJS, link, tooltipsArray);
        } else {
            this.fillColorTextRotated(id, fillColor, g, szText, rInnerBounds, dropShadowColor, dropShadowOffset, textStyle, vc, nBackgroundFillType, drillJS, link, tooltipsArray);
        }
    }

    protected void fillColorTextRotated(IdentObj id, Color textColor, Graphics g, String szText, Rectangle rectBoundsDC, Color dropShadowColor, Dimension dropShadowOffset, TextStyleObj textStyle, VC vc, int nBackgroundFillType, String drillJS, String link, String[] tooltipsArray) throws IOException, Exception {
        if (rectBoundsDC.width <= 0 || rectBoundsDC.height <= 0) {
            if (this.m_eh != null) {
                this.m_eh.log("invalid rectBoundsDC", this.getClass().getName(), "protected void fillColorTextRotated");
            }
            return;
        }
        Rectangle rTextDC = null;
        rTextDC = textStyle.getRotationAngle() == 2 || textStyle.getRotationAngle() == 1 ? new Rectangle(0, 0, rectBoundsDC.height, rectBoundsDC.width) : new Rectangle(0, 0, rectBoundsDC.height, rectBoundsDC.width);
        Rectangle rBoundsDC = new Rectangle(rectBoundsDC.x, rectBoundsDC.y, rectBoundsDC.width, rectBoundsDC.height);
        if (textStyle != null && textStyle.getWordWrap()) {
            Dimension dimTextDC = textStyle.preDraw(g, szText, rTextDC, vc, dropShadowOffset, this.m_pfj.getFontMetricsResolver());
            rTextDC.width = Math.max(rTextDC.width, dimTextDC.width);
            rTextDC.height = Math.max(rTextDC.height, dimTextDC.height);
        }
        if (rTextDC.width <= 1 || rTextDC.height <= 1) {
            if (this.m_eh != null) {
                this.m_eh.log("text bounds too small to draw", this.getClass().getName(), "protected void fillColorTextRotated");
            }
            return;
        }
        if (textStyle.getRotationAngle() == 2 || textStyle.getRotationAngle() == 1) {
            rBoundsDC.height = rTextDC.width;
            rBoundsDC.width = rTextDC.height;
        }
        int oldw = rBoundsDC.width;
        int oldh = rBoundsDC.height;
        if (textStyle.getRotationAngle() == 2 || textStyle.getRotationAngle() == 1) {
            int width = rBoundsDC.width;
            rBoundsDC.width = rBoundsDC.height;
            rBoundsDC.height = width;
            rBoundsDC.y = rBoundsDC.y + oldh / 2 - oldw / 2;
            rBoundsDC.x = rBoundsDC.x - oldh / 2 + oldw / 2;
        }
        int angle = 0;
        int cx = 0;
        int cy = 0;
        if (textStyle.getRotationAngle() == 2) {
            angle = 270;
            cx = rBoundsDC.x + rBoundsDC.width / 2;
            cy = rBoundsDC.y + rBoundsDC.height / 2;
        } else if (textStyle.getRotationAngle() == 1) {
            angle = 90;
            cx = rBoundsDC.x + rBoundsDC.width / 2;
            cy = rBoundsDC.y + rBoundsDC.height / 2;
        } else {
            int rotationAngle = textStyle.getRotationAngle();
            if (rotationAngle > 0 && rotationAngle <= 90) {
                angle = 360 - rotationAngle;
            } else if (rotationAngle > 90 && rotationAngle <= 180) {
                angle = 180 - rotationAngle;
            } else if (rotationAngle > 180 && rotationAngle <= 270) {
                angle = 360 - rotationAngle;
            } else if (rotationAngle > 270 && rotationAngle <= 360) {
                angle = 180 - rotationAngle;
            }
            angle = 360 - angle;
            cx = rBoundsDC.x + rBoundsDC.width / 2;
            cy = rBoundsDC.y + rBoundsDC.height / 2;
        }
        this.drawStyledText(id, textStyle, textColor, angle, cx, cy, g, szText, rBoundsDC, dropShadowColor, dropShadowOffset, vc, drillJS, link, tooltipsArray);
    }

    protected void drawStyledText(IdentObj id, TextStyleObj textStyleObj, Color textColor, Graphics gx, String strText, Rectangle rBoundsDC, Color dropShadowColor, Dimension dropShadowOffset, VC vc, String drillJS, String link, String[] tooltipsArray) throws IOException, Exception {
        this.drawStyledText(id, textStyleObj, textColor, 0.0, 0, 0, gx, strText, rBoundsDC, dropShadowColor, dropShadowOffset, vc, drillJS, link, tooltipsArray);
    }

    protected void drawStyledText(IdentObj id, TextStyleObj textStyleObj, Color textColor, double angle, int cx, int cy, Graphics gx, String strText, Rectangle rBoundsDC, Color dropShadowColor, Dimension dropShadowOffset, VC vc, String drillJS, String link, String[] tooltipsArray) throws IOException, Exception {
        int nFontSizeDC = textStyleObj.getFontSizeDC(vc);
        int nStyle = TextStyleObj.getStyleBI(textStyleObj.getFontStyle());
        Font font = textStyleObj.getFont(textStyleObj.getFontName(), nStyle, nFontSizeDC);
        FontMetrics fm = gx.getFontMetrics(font);
        Vector<String> strLines = new Vector<String>();
        int nNumLines = 1;
        if (textStyleObj.getWordWrap()) {
            nNumLines = textStyleObj.extractLinesWordWrap(strText, strLines, rBoundsDC.width, fm, this.m_pfj.getFontMetricsResolver());
        } else {
            strLines.addElement(strText);
        }
        Dimension dimThisLineDC = new Dimension(0, 0);
        Rectangle rTextBoundsDC = new Rectangle(rBoundsDC.x, rBoundsDC.y, rBoundsDC.width, rBoundsDC.height);
        Dimension dimMaxDC = new Dimension(rTextBoundsDC.width, rTextBoundsDC.height);
        int nLine = 0;
        while (nLine < nNumLines) {
            String strThisLine = (String)strLines.elementAt(nLine);
            dimThisLineDC = textStyleObj.getTextSizeDC(gx, strThisLine, nFontSizeDC, vc, dimMaxDC, dropShadowOffset, false, this.m_pfj.getFontMetricsResolver());
            Point ptTextDC = textStyleObj.alignTextInBox(nLine, nNumLines, fm, rTextBoundsDC, dimThisLineDC, this.m_pfj);
            if (dropShadowOffset != null) {
                String fontString = this.getFontAttributes(font, dropShadowColor, (textStyleObj.getFontStyle() & 4) != 0);
                int fid = this.getFontID(fontString);
                Point ptDropShadow = new Point(ptTextDC.x + dropShadowOffset.width, ptTextDC.y + dropShadowOffset.height);
                if (this.startTextElement(ptDropShadow.x, ptDropShadow.y, this.m_pfj.getFontMetricsResolver().stringWidth(strThisLine, fm))) {
                    int halign;
                    this.writeFontIndexAttribute(fid);
                    this.writeCachedAttribute("a", angle, null);
                    if (angle != 0.0) {
                        this.writeAttribute("cx", cx);
                        this.writeAttribute("cy", cy);
                    }
                    if ((halign = textStyleObj.getHorizAlign()) == 0) {
                        this.writeCachedAttribute("j", "c", null);
                    } else if (halign == 4) {
                        this.writeCachedAttribute("j", "r", null);
                    } else {
                        this.writeCachedAttribute("j", "l", null);
                    }
                    this.writeText(strThisLine);
                    this.endElement();
                } else if (this.m_eh != null) {
                    this.m_eh.log("could not start text element dropshadow", this.getClass().getName(), "protected void drawStyledText");
                }
            }
            if (textStyleObj.isDisplayDrillIcon()) {
                Image image = null;
                image = nFontSizeDC < 18 ? TextStyleObj.SMALL_DRILL_IMAGE : TextStyleObj.LARGE_DRILL_IMAGE;
                int imageSize = image.getWidth(null);
                this.startElement("img");
                this.writeAttribute("x", rTextBoundsDC.x);
                this.writeAttribute("y", rTextBoundsDC.y + (rTextBoundsDC.height - imageSize) / 2);
                this.writeAttribute("w", imageSize);
                this.writeAttribute("h", imageSize);
                String facesResourceURL = this.m_pfj.getFacesResourceURL();
                if (facesResourceURL == null) {
                    facesResourceURL = "";
                }
                if (nFontSizeDC < 18) {
                    this.writeAttribute("url", facesResourceURL + URL_SM_DRILL_UP_ARROW);
                } else {
                    this.writeAttribute("url", facesResourceURL + URL_LG_DRILL_UP_ARROW);
                }
                this.writeAdditionalTextInfo(id, drillJS, link, tooltipsArray);
                this.endElement();
                ptTextDC.x += imageSize + 2;
                dimThisLineDC.width -= imageSize + 2;
            }
            String fontString = this.getFontAttributes(font, textColor, (textStyleObj.getFontStyle() & 4) != 0);
            int fid = this.getFontID(fontString);
            if (this.startTextElement(ptTextDC.x, ptTextDC.y, this.m_pfj.getFontMetricsResolver().stringWidth(strThisLine, fm))) {
                int halign;
                this.writeIdentObjAttributes(id);
                this.writeFontIndexAttribute(fid);
                this.writeCachedAttribute("a", angle, null);
                if (angle != 0.0) {
                    this.writeAttribute("cx", cx);
                    this.writeAttribute("cy", cy);
                }
                if ((halign = textStyleObj.getHorizAlign()) == 0) {
                    this.writeCachedAttribute("j", "c", null);
                } else if (halign == 4) {
                    this.writeCachedAttribute("j", "r", null);
                } else {
                    this.writeCachedAttribute("j", "l", null);
                }
                this.writeAdditionalTextInfo(id, drillJS, link, tooltipsArray);
                this.writeText(strThisLine);
                this.endElement();
            } else if (this.m_eh != null) {
                this.m_eh.log("could not start text element", this.getClass().getName(), "protected void drawStyledText");
            }
            ++nLine;
        }
    }

    protected void writeAdditionalTextInfo(IdentObj id, String drillJS, String link, String[] tooltipsArray) throws IOException, Exception {
        if (drillJS != null && drillJS.length() > 0) {
            this.writeAttribute("drillJs", drillJS);
        }
        if (link != null && link.length() > 0) {
            this.writeAttribute("link", link);
        }
        if (!this.hasAlt() && tooltipsArray != null && tooltipsArray.length > 0) {
            this.writeTooltipAttribute(tooltipsArray);
        }
        this.writeShapeAttributesElement();
        int graphID = this.m_pfj.getReferenceObjectGraphID(id.getObjectID());
        if (graphID != -1 && this.m_pfj.getReferenceObjectDisplay(graphID) == 2) {
            this.writeReferenceObjectsElement(id);
        }
    }

    protected void writeIdentObjAttributes(IdentObj identObj) throws IOException, Exception {
        int stack;
        int misc;
        int series;
        block21: {
            block19: {
                String gIdString;
                int group;
                block22: {
                    List groupList;
                    block20: {
                        String s;
                        int id = ObjClassID.stripExceptionalOffset(identObj.getObjectID());
                        group = identObj.getGroupID();
                        series = identObj.getSeriesID();
                        misc = identObj.getMiscID();
                        stack = identObj.getStackID();
                        if (id >= 0 && (s = this.convertObjectIdToString(identObj)) != null && s.length() > 0) {
                            this.writeCachedAttribute("O", s, null);
                        }
                        if (group < 0) break block19;
                        if (this.isUseDataIds()) break block20;
                        this.writeCachedAttribute("G", group, (String)null);
                        break block21;
                    }
                    gIdString = null;
                    if (this.m_detObj == null || ObjClassID.stripExceptionalOffset(this.m_detObj.getObjectID()) != 258 && ObjClassID.stripExceptionalOffset(this.m_detObj.getObjectID()) != 256 || (groupList = this.m_detObj.getGroupList()) == null) break block22;
                    int startGroup = this.m_pfj.getEffectiveGroupOffset();
                    StringBuilder sb = new StringBuilder("");
                    boolean bContinuousRange = false;
                    int rangeStartGroup = -1;
                    int gi = 0;
                    while (gi < groupList.size()) {
                        block23: {
                            int groupIndex;
                            block25: {
                                int nextGroupIndex;
                                block24: {
                                    Object nextGroupIObj;
                                    Object groupIObj = groupList.get(gi);
                                    if (groupIObj == null || !(groupIObj instanceof Integer)) break block23;
                                    groupIndex = (Integer)groupIObj;
                                    nextGroupIndex = -1;
                                    if (gi + 1 < groupList.size() && (nextGroupIObj = groupList.get(gi + 1)) != null && nextGroupIObj instanceof Integer) {
                                        nextGroupIndex = (Integer)nextGroupIObj;
                                    }
                                    if (bContinuousRange) break block24;
                                    if (sb.length() > 0) {
                                        sb.append(",");
                                    }
                                    rangeStartGroup = groupIndex;
                                    if (nextGroupIndex == groupIndex + 1) {
                                        bContinuousRange = true;
                                    }
                                    break block25;
                                }
                                if (nextGroupIndex == groupIndex + 1) break block23;
                                if (groupIndex - rangeStartGroup > 1) {
                                    sb.append("-");
                                } else {
                                    sb.append(",");
                                }
                                bContinuousRange = false;
                            }
                            sb.append(groupIndex - startGroup);
                        }
                        ++gi;
                    }
                    if (sb.length() > 0) {
                        gIdString = "(" + sb.toString() + ")";
                    }
                }
                if (gIdString == null) {
                    gIdString = this.m_pfj.getDataGridCallback().getGroupSliceId(group);
                }
                this.writeCachedAttribute("G", gIdString, null);
                break block21;
            }
            this.writeCachedAttribute("G", "", null);
        }
        if (series >= 0) {
            if (!this.isUseDataIds()) {
                this.writeCachedAttribute("S", series, (String)null);
            } else {
                this.writeCachedAttribute("S", this.m_pfj.getDataGridCallback().getSeriesSliceId(series), null);
            }
        } else {
            this.writeCachedAttribute("S", "", null);
        }
        if (misc >= 0) {
            this.writeAttribute("M", misc);
        }
        if (stack >= 0) {
            this.writeAttribute("stId", stack);
        }
    }

    protected void writeFillAttributes(IdentObj id, BlackBoxIF bb, Shape shape) throws IOException, Exception {
        this.m_bElementFilled = true;
        if (id.getObjectID() == 339 || id.getObjectID() == 626) {
            this.writeCachedAttribute("go", "t", null);
        } else {
            this.writeCachedAttribute("go", "f", null);
        }
        switch (bb.getFillType()) {
            case 1: {
                break;
            }
            case 2: {
                this.writeCachedAttribute("ft", "ftG", null);
                return;
            }
            case 3: {
                String szURL = this.m_pfj.getTexture(bb.getIdentObj());
                Image img = this.m_pfj.getTexture(szURL);
                if (img != null) {
                    int nDisplayMode = this.m_pfj.getTextureDisplayMode(bb.getIdentObj());
                    if (nDisplayMode == 0) {
                        this.writeCachedAttribute("ft", "ftT", null);
                        this.writeAttribute("textureDisplayMode", "TDM_TILED");
                        this.writeAttribute("textureUrl", szURL);
                        return;
                    }
                    if (nDisplayMode == 1) {
                        this.writeCachedAttribute("ft", "ftT", null);
                        this.writeAttribute("textureDisplayMode", "TDM_STRETCHED");
                        this.writeAttribute("textureUrl", szURL);
                        return;
                    }
                    if (this.m_eh == null) break;
                    this.m_eh.log("unknown display mode", this.getClass().getName(), "writeFillAttributes(IdentObj id, BlackBoxIF bb, Rectangle bounds)");
                    break;
                }
                if (this.m_eh == null) break;
                this.m_eh.log("texture image null", this.getClass().getName(), "writeFillAttributes(IdentObj id, BlackBoxIF bb, Rectangle bounds)");
                break;
            }
            case 4: {
                int pattern = this.m_pfj.getFillPattern(id);
                String sPattern = BaseGraphComponent.convertFillPatternToString(pattern);
                if (sPattern != null) {
                    this.writeCachedAttribute("ft", "ftP", null);
                    this.writeAttribute("fp", sPattern);
                    this.writeAttribute("fc", GraphExportXMLWriter.colorToHexWithAlpha(this.m_pfj.getFillColor(bb.getIdentObj())));
                    return;
                }
                if (this.m_eh == null) break;
                this.m_eh.log("invalid pattern", this.getClass().getName(), "writeFillAttributes(IdentObj id, BlackBoxIF bb, Rectangle bounds)");
                break;
            }
        }
        this.writeCachedAttribute("ft", "ftC", null);
        if (shape instanceof Polygon) {
            this.writeCachedAttribute("fc", bb.getFillColor(), "pg");
        } else {
            this.writeAttribute("fc", GraphExportXMLWriter.colorToHexWithAlpha(bb.getFillColor()));
        }
    }

    public void writeFillChildren(IdentObj id, BlackBoxIF bb) throws IOException, Exception {
        this.writeFillChildren(id, bb, null);
    }

    public void writeFillChildren(IdentObj id, BlackBoxIF bb, Rectangle rect) throws IOException, Exception {
        if (!this.isElementFilled()) {
            return;
        }
        switch (bb.getFillType()) {
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                if (!(bb.getFillObj() instanceof FillGradientObj)) break;
                this.writeGradientElement((FillGradientObj)bb.getFillObj(), rect, bb.getIdentObj(), "g");
                break;
            }
        }
    }

    public void writeBorderChildren(IdentObj id, BlackBoxIF bb, Rectangle rect) throws IOException, Exception {
        BorderObj border = bb.getBorderObj();
        if (border != null && border.getGradient() != null) {
            this.writeGradientElement(border.getGradient(), rect, bb.getIdentObj(), "lg");
        }
    }

    public void writeVisualEffectsAttributes(Map map) throws IOException, Exception {
        if (map == null) {
            return;
        }
        Color sColor = (Color)map.get("shadowColor");
        Double sDistance = (Double)map.get("shadowDistance");
        Double sStrength = (Double)map.get("shadowStrength");
        Double sAngle = (Double)map.get("shadowAngle");
        Double sBlurX = (Double)map.get("shadowBlurX");
        Double sBlurY = (Double)map.get("shadowBlurY");
        Integer sQuality = (Integer)map.get("shadowQuality");
        Integer sInner = (Integer)map.get("shadowInner");
        Integer sKnockout = (Integer)map.get("shadowKnockout");
        Integer sHide = (Integer)map.get("shadowHide");
        if (sColor != null || sDistance != null || sStrength != null || sAngle != null || sBlurX != null || sBlurY != null || sQuality != null || sInner != null || sKnockout != null || sHide != null) {
            this.writeShadowAttribute(sColor, sDistance, sStrength, sAngle, sBlurX, sBlurY, sQuality, sInner, sKnockout, sHide);
        }
        Color bHighlightColor = (Color)map.get("bevelHighlightColor");
        Color bShadowColor = (Color)map.get("bevelShadowColor");
        Double bDistance = (Double)map.get("bevelDistance");
        Double bStrength = (Double)map.get("bevelStrength");
        Double bAngle = (Double)map.get("bevelAngle");
        Double bBlurX = (Double)map.get("bevelBlurX");
        Double bBlurY = (Double)map.get("bevelBlurY");
        Integer bQuality = (Integer)map.get("bevelQuality");
        String bType = (String)map.get("bevelType");
        if (bHighlightColor != null || bShadowColor != null || bDistance != null || bStrength != null || bAngle != null || bBlurX != null || bBlurY != null || bQuality != null || bType != null) {
            this.writeBevelAttribute(bHighlightColor, bShadowColor, bDistance, bStrength, bAngle, bBlurX, bBlurY, bQuality, bType);
        }
        Color gColor = (Color)map.get("glowColor");
        Double gBlurX = (Double)map.get("glowBlurX");
        Double gBlurY = (Double)map.get("glowBlurY");
        Double gStrength = (Double)map.get("glowStrength");
        Integer gQuality = (Integer)map.get("glowQuality");
        Integer gInner = (Integer)map.get("glowInner");
        Integer gKnockout = (Integer)map.get("glowKnockout");
        if (gColor != null || gBlurX != null || gBlurY != null || gStrength != null || gQuality != null || gInner != null || gKnockout != null) {
            this.writeGlowAttribute(gColor, gBlurX, gBlurY, gStrength, gQuality, gInner, gKnockout);
        }
    }

    public boolean isElementFilled() {
        return this.m_bElementFilled;
    }

    public void writeReferenceObjectsElement(IdentObj id) throws IOException, Exception {
        boolean bElemStarted = false;
        int graphID = this.m_pfj.getReferenceObjectGraphID(id.getObjectID());
        if (graphID != -1 && this.m_pfj.m_referenceObjects != null && this.m_pfj.m_referenceObjects.size() > 0) {
            int i = 0;
            while (i < this.m_pfj.m_referenceObjects.size()) {
                int series;
                IdentObj ro = (IdentObj)this.m_pfj.m_referenceObjects.get(i);
                if (this.m_pfj.getReferenceAssociation(ro) == graphID && (graphID != 31 || (series = this.m_pfj.getReferenceSeries(ro).intValue()) == id.getSeriesID())) {
                    if (!bElemStarted) {
                        bElemStarted = true;
                        this.startElement(ELEM_REFERENCE_OBJECTS);
                    }
                    this.startElement(ELEM_REF_OBJ);
                    this.writeIdentObjAttributes(ro);
                    this.endElement();
                }
                ++i;
            }
        }
        if (bElemStarted) {
            this.endElement();
        }
    }

    protected void writeGradientElement(FillGradientObj gradient, Rectangle rect, IdentObj id, String elemType) throws IOException, Exception {
        int direction = 0;
        direction = gradient != null ? gradient.getDirection() : this.m_pfj.getGradientDirection(id);
        boolean bReverseStops = false;
        boolean bRadialCorner = false;
        int oldDirection = direction;
        switch (direction) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                direction = SFX._calcReversedGradientDirection(direction);
                bReverseStops = true;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                direction = 9;
                bRadialCorner = true;
                break;
            }
        }
        String sDirection = GraphExportXMLWriter.convertGradientDirectionToXMLString(direction);
        if (sDirection == null || sDirection.length() == 0) {
            sDirection = GraphExportXMLWriter.convertGradientDirectionToXMLString(1);
            if (this.m_eh != null) {
                this.m_eh.log("invalid gradient direction string", this.getClass().getName(), "writeGradientElement(BlackBoxIF bb, Rectangle rect)");
            }
        }
        if (sDirection != null) {
            this.startElement(elemType);
            this.writeCachedAttribute("dir", sDirection, null);
            if (rect != null) {
                this.writeAttribute("b", rect.x + "," + rect.y + "," + rect.width + "," + rect.height);
                if (direction == 9) {
                    if (!bRadialCorner) {
                        int cx = rect.x + rect.width / 2;
                        int cy = rect.y + rect.height / 2;
                        this.writeAttribute("cx", cx);
                        this.writeAttribute("cy", cy);
                        if (rect.width == rect.height) {
                            this.writeAttribute("r", rect.width / 2);
                        } else {
                            this.writeAttribute("rx", rect.width / 2);
                            this.writeAttribute("ry", rect.height / 2);
                        }
                    } else {
                        int cx = 0;
                        int cy = 0;
                        switch (oldDirection) {
                            case 12: {
                                cx = rect.x;
                                cy = rect.y + rect.height;
                                break;
                            }
                            case 13: {
                                cx = rect.x + rect.width;
                                cy = rect.y + rect.height;
                                break;
                            }
                            case 10: {
                                cx = rect.x;
                                cy = rect.y;
                                break;
                            }
                            case 11: {
                                cx = rect.x + rect.width;
                                cy = rect.y;
                                break;
                            }
                        }
                        this.writeAttribute("cx", cx);
                        this.writeAttribute("cy", cy);
                        double scale = 1.41;
                        if (rect.width == rect.height) {
                            this.writeAttribute("r", Math.round(scale * (double)rect.width));
                        } else {
                            this.writeAttribute("rx", Math.round(scale * (double)rect.width));
                            this.writeAttribute("ry", Math.round(scale * (double)rect.height));
                        }
                    }
                }
            }
            this.writeGradientStopAttributes(gradient, bReverseStops, id);
            this.endElement();
        }
    }

    protected void writeGradientStopAttributes(FillGradientObj gradient, boolean bReverseStops, IdentObj id) throws IOException, Exception {
        int pinCount = 0;
        List pins = null;
        if (gradient != null) {
            pins = gradient.getPins();
            pinCount = pins.size();
        } else {
            pinCount = this.m_pfj.getGradientNumPins(id);
        }
        if (!bReverseStops) {
            StringBuilder pos = new StringBuilder();
            StringBuilder c = new StringBuilder();
            int pin = 0;
            while (pin < pinCount) {
                if (pos.length() > 0) {
                    pos.append(",");
                }
                if (c.length() > 0) {
                    c.append(",");
                }
                ColorPinObj colorPinObj = null;
                if (pins != null) {
                    colorPinObj = (ColorPinObj)pins.get(pin);
                }
                double offset = 0.5;
                offset = colorPinObj == null ? this.m_pfj.getGradientPinPosition(id, pin) : colorPinObj.getPosition();
                Color color = null;
                color = colorPinObj == null ? this.m_pfj.getGradientPinRightColor(id, pin) : colorPinObj.getRightColor().getColor();
                pos.append(offset);
                c.append(GraphExportXMLWriter.colorToHexWithAlpha(color));
                ++pin;
            }
            this.writeCachedAttribute("p", pos.toString(), null);
            this.writeAttribute("c", c.toString());
        } else {
            StringBuilder pos = new StringBuilder();
            StringBuilder c = new StringBuilder();
            int pin = pinCount - 1;
            while (pin >= 0) {
                if (pos.length() > 0) {
                    pos.append(",");
                }
                if (c.length() > 0) {
                    c.append(",");
                }
                ColorPinObj colorPinObj = null;
                if (pins != null) {
                    colorPinObj = (ColorPinObj)pins.get(pin);
                }
                double offset = 0.5;
                offset = colorPinObj == null ? this.m_pfj.getGradientPinPosition(id, pin) : colorPinObj.getPosition();
                Color color = null;
                color = colorPinObj == null ? this.m_pfj.getGradientPinRightColor(id, pin) : colorPinObj.getRightColor().getColor();
                pos.append(1.0 - offset);
                c.append(GraphExportXMLWriter.colorToHexWithAlpha(color));
                --pin;
            }
            this.writeCachedAttribute("p", pos.toString(), null);
            this.writeAttribute("c", c.toString());
        }
    }

    public void writeAnimationAttributes() throws IOException, Exception {
        Color animationDownColor;
        Color animationUpColor;
        int animationOnDisplay;
        int animationDuration;
        int animationIndicators;
        if (this.m_graph == null) {
            return;
        }
        int animationOnDataChange = this.m_graph.getAnimationOnDataChange();
        if (animationOnDataChange != (Integer)Attr.AnimationOnDataChange.getDefault()) {
            this.writeAttribute("aDC", CommonGraph.convertAnimationOnDataChangeToString(animationOnDataChange));
        }
        if ((animationIndicators = this.m_graph.getAnimationIndicators()) != (Integer)Attr.AnimationIndicators.getDefault()) {
            this.writeAttribute("aI", CommonGraph.convertAnimationIndicatorsToString(animationIndicators));
        }
        if ((animationDuration = this.m_graph.getAnimationDuration()) != (Integer)Attr.AnimationDuration.getDefault()) {
            this.writeAttribute("aDu", animationDuration);
        }
        if ((animationOnDisplay = this.m_graph.getAnimationOnDisplay()) != (Integer)Attr.AnimationOnDisplay.getDefault()) {
            this.writeAttribute("aDi", CommonGraph.convertAnimationOnDisplayToString(animationOnDisplay));
        }
        if (!(animationUpColor = this.m_graph.getAnimationUpColor()).equals(Attr.AnimationUpColor.getDefault())) {
            this.writeAttribute("aU", animationUpColor);
        }
        if (!(animationDownColor = this.m_graph.getAnimationDownColor()).equals(Attr.AnimationDownColor.getDefault())) {
            this.writeAttribute("aD", animationDownColor);
        }
    }

    public void writeDataZoomAndScrollEventJsAttributes(DetObj detObj) throws IOException, Exception {
        int objectID = detObj.getObjectID();
        String dataZoomInButtonJs = null;
        String dataZoomOutButtonJs = null;
        String dataScrollJs = null;
        JChart_Base chartBase = this.m_pfj.getGraphObject();
        JChart_2D_Standard ch = null;
        if (chartBase instanceof JChart_2D_Standard) {
            ch = (JChart_2D_Standard)chartBase;
        }
        Axis2DObj axisObj = null;
        boolean bAutoMin = false;
        boolean bAutoMax = false;
        double autoMinVal = 0.0;
        double autoMaxVal = 0.0;
        switch (objectID) {
            case 3007: {
                dataZoomInButtonJs = this.getDataZoomInButtonSubmitJS("O1");
                break;
            }
            case 3001: {
                dataZoomInButtonJs = this.getDataZoomInButtonSubmitJS("Y1");
                break;
            }
            case 3019: {
                dataZoomInButtonJs = this.getDataZoomInButtonSubmitJS("Y2");
                break;
            }
            case 3013: {
                dataZoomInButtonJs = this.getDataZoomInButtonSubmitJS("X1");
                break;
            }
            case 3008: {
                dataZoomOutButtonJs = this.getDataZoomOutButtonSubmitJS("O1");
                break;
            }
            case 3002: {
                dataZoomOutButtonJs = this.getDataZoomOutButtonSubmitJS("Y1");
                break;
            }
            case 3020: {
                dataZoomOutButtonJs = this.getDataZoomOutButtonSubmitJS("Y2");
                break;
            }
            case 3014: {
                dataZoomOutButtonJs = this.getDataZoomOutButtonSubmitJS("X1");
                break;
            }
            case 3011: {
                dataScrollJs = this.getDataScrollSubmitJS("O1");
                this.writeAttribute(ATTR_SCROLL_START, this.m_pfj.getEffectiveGroupOffset());
                this.writeAttribute(ATTR_SCROLL_SPAN, this.m_pfj.getNumGroups());
                this.writeAttribute(ATTR_SCROLL_TOTAL, this.m_pfj.getNumTotalGroups());
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < this.m_pfj.getNumTotalGroups()) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    if (this.m_pfj.isTimeAxis()) {
                        sb.append("'" + this.m_pfj.getUnnestedGroupLabel(i) + "'");
                    } else {
                        sb.append("'" + this.m_pfj.getGroupLabel(i) + "'");
                    }
                    ++i;
                }
                if (sb.length() <= 0) break;
                this.writeAttribute(ATTR_SCROLL_LABELS, sb.toString());
                break;
            }
            case 3005: {
                dataScrollJs = this.getDataScrollSubmitJS("Y1");
                if (ch == null) break;
                axisObj = (Axis2DObj)ch.m_Y1Axis;
                bAutoMin = this.m_pfj.getY1ScaleMinAuto();
                bAutoMax = this.m_pfj.getY1ScaleMaxAuto();
                autoMinVal = this.m_pfj.getY1ScaleMinAutoValue();
                autoMaxVal = this.m_pfj.getY1ScaleMaxAutoValue();
                break;
            }
            case 3023: {
                dataScrollJs = this.getDataScrollSubmitJS("Y2");
                if (ch == null) break;
                axisObj = (Axis2DObj)ch.m_Y2Axis;
                bAutoMin = this.m_pfj.getY2ScaleMinAuto();
                bAutoMax = this.m_pfj.getY2ScaleMaxAuto();
                autoMinVal = this.m_pfj.getY2ScaleMinAutoValue();
                autoMaxVal = this.m_pfj.getY2ScaleMaxAutoValue();
                break;
            }
            case 3017: {
                dataScrollJs = this.getDataScrollSubmitJS("X1");
                if (ch == null) break;
                axisObj = (Axis2DObj)ch.m_X1Axis;
                if (this.m_pfj.isContinuousTimeAxis()) {
                    axisObj = (Axis2DObj)ch.m_O1Axis;
                }
                bAutoMin = this.m_pfj.getX1ScaleMinAuto();
                bAutoMax = this.m_pfj.getX1ScaleMaxAuto();
                if (this.m_pfj.isContinuousTimeAxis()) {
                    bAutoMin = false;
                    bAutoMax = false;
                }
                autoMinVal = this.m_pfj.getX1ScaleMinAutoValue();
                autoMaxVal = this.m_pfj.getX1ScaleMaxAutoValue();
                break;
            }
        }
        if (dataZoomInButtonJs != null) {
            this.writeAttribute(ATTR_DATA_ZOOM_IN_BUTTON_EVENT_JS, dataZoomInButtonJs);
        }
        if (dataZoomOutButtonJs != null) {
            this.writeAttribute(ATTR_DATA_ZOOM_OUT_BUTTON_EVENT_JS, dataZoomOutButtonJs);
        }
        if (dataScrollJs != null) {
            this.writeAttribute(ATTR_DATA_SCROLL_EVENT_JS, dataScrollJs);
        }
        if (axisObj != null) {
            if (axisObj.getAutoMinMaxArray() != null) {
                if (!bAutoMin) {
                    autoMinVal = axisObj.getAutoMinMaxArray()[0];
                }
                if (!bAutoMax) {
                    autoMaxVal = axisObj.getAutoMinMaxArray()[1];
                }
            }
            boolean bHoriz = axisObj.isVertical() ^ true;
            double autoMin = axisObj.getValueCoordForZoom(autoMinVal);
            double autoMax = axisObj.getValueCoordForZoom(autoMaxVal);
            double min = axisObj.getMinCoord();
            double max = axisObj.getMaxCoord();
            int start = 0;
            int span = 0;
            int total = 0;
            if (bHoriz) {
                total = Math.abs(this.m_pfj.getVC().virtToDestWidth((int)(autoMax - autoMin)));
                span = Math.abs(this.m_pfj.getVC().virtToDestWidth((int)(max - min)));
                start = Math.abs(this.m_pfj.getVC().virtToDestWidth((int)(min - autoMin)));
            } else {
                total = Math.abs(this.m_pfj.getVC().virtToDestHeight((int)(autoMax - autoMin)));
                span = Math.abs(this.m_pfj.getVC().virtToDestHeight((int)(max - min)));
                start = Math.abs(this.m_pfj.getVC().virtToDestHeight((int)(min - autoMin)));
            }
            this.writeAttribute(ATTR_SCROLL_START, start);
            this.writeAttribute(ATTR_SCROLL_SPAN, span);
            this.writeAttribute(ATTR_SCROLL_TOTAL, total);
            this.writeAttribute(ATTR_SCROLL_MIN_VAL, autoMinVal);
            this.writeAttribute(ATTR_SCROLL_MAX_VAL, autoMaxVal);
            if (objectID == 3017 && this.m_pfj.isContinuousTimeAxis()) {
                int freq = this.m_pfj.getDateFrequency();
                String format = SECOND_FORMAT;
                switch (freq) {
                    case 0: {
                        format = MONTH_FORMAT;
                        break;
                    }
                    case 1: {
                        format = DAY_FORMAT;
                        break;
                    }
                    case 2: {
                        format = HOUR_FORMAT;
                        break;
                    }
                    case 4: {
                        format = MINUTE_FORMAT;
                        break;
                    }
                    case 5: {
                        format = SECOND_FORMAT;
                        break;
                    }
                }
                this.writeAttribute(ATTR_DATE_FORMAT, format);
            }
        }
    }

    protected String convertObjectIdToString(IdentObj identObj) {
        int id = ObjClassID.stripExceptionalOffset(identObj.getObjectID());
        switch (id) {
            case 1: {
                return "CB";
            }
            case 301: {
                return "PieBarConnectLines";
            }
            case 317: {
                return "LRS";
            }
            case 258: {
                return "LR";
            }
            case 318: {
                return "LRT";
            }
            case 259: {
                return OBJ_LINE_MARKER;
            }
            case 277: {
                return "BR";
            }
            case 312: {
                return "BRS";
            }
            case 313: {
                return "BRB";
            }
            case 331: {
                return "PieBarRiser";
            }
            case 334: {
                return "PieBarRiserSide";
            }
            case 335: {
                return "PieBarRiserTop";
            }
            case 310: {
                return "StockVolumeRiser";
            }
            case 303: {
                return "StockRiser";
            }
            case 306: {
                return "StockLowerRiser";
            }
            case 307: {
                return "StockCloseTick";
            }
            case 308: {
                return "StockOpenTick";
            }
            case 319: {
                return "StockRisingRiser";
            }
            case 320: {
                return "StockFallingRiser";
            }
            case 321: {
                return "StockHighLine";
            }
            case 322: {
                return "StockLowLine";
            }
            case 474: {
                return "ParetoLineMarker";
            }
            case 473: {
                return "ParetoLineRiser";
            }
            case 475: {
                return "ParetoLineRiserTop";
            }
            case 476: {
                return "ParetoLineRiserSide";
            }
            case 315: {
                return "AreaRiserSide";
            }
            case 256: {
                return "AR";
            }
            case 314: {
                return "ART";
            }
            case 316: {
                return "ARB";
            }
            case 606: {
                return "CRF";
            }
            case 41: {
                return "CurveFitLineRiser";
            }
            case 12: {
                return "LA";
            }
            case 13: {
                return "LeM";
            }
            case 14: {
                return "LT";
            }
            case 18: {
                if (this.m_pfj.getGraphType() != 12) break;
                return "SpectralLegendMarker";
            }
            case 260: {
                return "DataText";
            }
            case 294: {
                return "PFL";
            }
            case 296: {
                return "PieLabel";
            }
            case 297: {
                return "PieRingLabel";
            }
            case 2: {
                return "F";
            }
            case 15: {
                return "FrameSide";
            }
            case 16: {
                return "FrameBottom";
            }
            case 302: {
                return "PieFrame";
            }
            case 328: {
                return "QuadrantLine";
            }
            case 329: {
                return "ScatterQuadrantLine";
            }
            case 298: {
                return "Sl";
            }
            case 299: {
                return "SC";
            }
            case 300: {
                return "SliceRing";
            }
            case 332: {
                return "PieBarSlice";
            }
            case 333: {
                return "PieBarSliecCrust";
            }
            case 295: {
                return "PSL";
            }
            case 17: {
                return "FrameSeparator";
            }
            case 269: {
                return "O1AxisLine";
            }
            case 279: {
                return "X1AxisLine";
            }
            case 271: {
                return "O1MajorGrid";
            }
            case 281: {
                return "X1MG";
            }
            case 614: {
                return "CubeFloorGridX";
            }
            case 618: {
                return "CubeRightWallGridX";
            }
            case 270: {
                return "O1L";
            }
            case 280: {
                return "X1L";
            }
            case 8: {
                return "O1Title";
            }
            case 10: {
                return "X1Title";
            }
            case 283: {
                return "Y1AxisLine";
            }
            case 285: {
                return "Y1MG";
            }
            case 616: {
                return "CubeLeftWallGridY";
            }
            case 619: {
                return "CubeRightWallGridY";
            }
            case 284: {
                return "Y1L";
            }
            case 6: {
                return "Y1Title";
            }
            case 292: {
                return "Y1ZeroLine";
            }
            case 287: {
                return "Y2AxisLine";
            }
            case 289: {
                return "Y2MajorGrid";
            }
            case 288: {
                return "Y2Label";
            }
            case 7: {
                return "Y2Title";
            }
            case 293: {
                return "Y2ZeroLine";
            }
            case 608: {
                return "CubeRiserGridY";
            }
            case 615: {
                return "CubeFloorGridZ";
            }
            case 617: {
                return "CubeLeftWallGridZ";
            }
            case 274: {
                return "O2L";
            }
            case 9: {
                return "O2Title";
            }
            case 603: {
                return "CubeFloor";
            }
            case 604: {
                return "CubeLeftWall";
            }
            case 605: {
                return "CubeRightWall";
            }
            case 3: {
                return "Footnote";
            }
            case 4: {
                return "Subtitle";
            }
            case 5: {
                return "Title";
            }
            case 357: {
                int location = this.m_pfj.getReferenceObjectLocation(identObj);
                if (location == 0) {
                    return "ROF";
                }
                return "ROB";
            }
            case 358: {
                return "ReferenceLine";
            }
            case 511: {
                return "SelectPointMarker";
            }
            case 503: {
                return "RLLT";
            }
            case 504: {
                return "RLM";
            }
            case 232: {
                return "O1DrillLabel";
            }
            case 233: {
                return "O2DrillLabel";
            }
            case 235: {
                return "DrillText";
            }
            case 234: {
                return "DrillMarker";
            }
            case 513: {
                return "TimeSelector";
            }
            case 359: {
                return "SeriesObjects";
            }
            case 620: {
                return "FunnelFrame";
            }
            case 621: {
                return "FunnelSlice";
            }
            case 622: {
                return "FunnelSliceLabel";
            }
            case 623: {
                return "FunnelLeftSurface";
            }
            case 624: {
                return "FunnelLines";
            }
            case 625: {
                return "FunnelLabelBackgroundRect";
            }
            case 626: {
                return "FunnelSkeleton";
            }
            case 627: {
                return "FunnelBoundingRect";
            }
            case 3001: {
                return "ZoomInY1";
            }
            case 3002: {
                return "ZoomOutY1";
            }
            case 3003: {
                return "ScrollIconFY1";
            }
            case 3004: {
                return "ScrollIconSY1";
            }
            case 3005: {
                return "DataScrollerY1";
            }
            case 3006: {
                return "ScrollThumbY1";
            }
            case 3007: {
                return "ZoomInO1";
            }
            case 3008: {
                return "ZoomOutO1";
            }
            case 3009: {
                return "ScrollIconFO1";
            }
            case 3010: {
                return "ScrollIconSO1";
            }
            case 3011: {
                return "DataScrollerO1";
            }
            case 3012: {
                return "ScrollThumbO1";
            }
            case 3019: {
                return "ZoomInY2";
            }
            case 3020: {
                return "ZoomOutY2";
            }
            case 3021: {
                return "ScrollIconFY2";
            }
            case 3022: {
                return "ScrollIconSY2";
            }
            case 3023: {
                return "DataScrollerY2";
            }
            case 3024: {
                return "ScrollThumbY2";
            }
            case 3013: {
                return "ZoomInX1";
            }
            case 3014: {
                return "ZoomOutX1";
            }
            case 3015: {
                return "ScrollIconFX1";
            }
            case 3016: {
                return "ScrollIconSX1";
            }
            case 3017: {
                return "DataScrollerX1";
            }
            case 3018: {
                return "ScrollThumbX1";
            }
            case 3000: {
                return "Common";
            }
            case 3025: {
                return "CommonArrow";
            }
            case 338: {
                return "PGO";
            }
            case 339: {
                return "PieGlowOverlay";
            }
        }
        return "Other";
    }

    protected static String convertGradientDirectionToXMLString(int direction) {
        switch (direction) {
            case 1: {
                return "gdRi";
            }
            case 3: {
                return "gdD";
            }
            case 5: {
                return "gdD45";
            }
            case 7: {
                return "gdD135";
            }
            case 9: {
                return "gdR";
            }
        }
        return null;
    }

    private void $init$() {
        this.m_pfj = null;
        this.m_bElementFilled = true;
        this.m_detObj = null;
    }
}

