/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.DataRange;
import oracle.dss.graph.pfj.Perspective;

public class GroupsEnumerator {
    static final boolean FORWARD = true;
    static final boolean REVERSE = false;
    int[] m_groupArray;
    int m_index;

    GroupsEnumerator(Perspective perspective, Access access, boolean bForward) {
        DataRange drViewable = access.getViewableDataRangeSG(perspective);
        int nViewGroupStart = drViewable.getColStart();
        int nViewGroupStop = drViewable.getColStop();
        int numGroups = nViewGroupStop - nViewGroupStart + 1;
        int numActualGroups = 0;
        this.m_index = 0;
        if (numGroups < 0) {
            this.m_groupArray = new int[0];
            return;
        }
        this.m_groupArray = new int[numGroups];
        if (bForward) {
            int index = 0;
            int g = nViewGroupStart;
            while (g <= nViewGroupStop) {
                this.m_groupArray[index++] = g++;
                ++numActualGroups;
            }
        } else {
            int index = numGroups - 1;
            int g = nViewGroupStart;
            while (g <= nViewGroupStop) {
                this.m_groupArray[index--] = g++;
                ++numActualGroups;
            }
        }
    }

    public int getAbsoluteGroup(int gRelative) {
        return this.groupAt(gRelative);
    }

    public int getFirstGroup() {
        return this.groupAt(0);
    }

    public int getLastGroup() {
        return this.groupAt(this.m_groupArray.length - 1);
    }

    public int getNumGroups() {
        return this.m_groupArray.length;
    }

    public int getRelativeGroup(int gAbsolute) {
        int i = 0;
        while (i < this.m_groupArray.length) {
            if (this.m_groupArray[i] == gAbsolute) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean hasMoreElements() {
        return this.m_index < this.m_groupArray.length;
    }

    public int nextGroup() {
        return this.m_groupArray[this.m_index++];
    }

    public int groupAt(int index) {
        try {
            int n = this.m_groupArray[index];
            return n;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            int n = -1;
            return n;
        }
    }

    public int peekAtNextGroup() {
        return this.groupAt(this.m_index);
    }

    public int peekAtGroupAfter(int gAbsolute) {
        int index = this.getRelativeGroup(gAbsolute);
        int gNext = -1;
        if (index >= 0) {
            gNext = this.groupAt(index + 1);
        }
        return gNext;
    }

    public int peekAtGroupBefore(int gAbsolute) {
        int index = this.getRelativeGroup(gAbsolute);
        int gNext = -1;
        if (index >= 1) {
            gNext = this.groupAt(index - 1);
        }
        return gNext;
    }

    public void reset() {
        this.m_index = 0;
    }
}

