/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.FrameObj;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.VC;

public abstract class JChart_2D
extends JChart_Base {
    FrameObj m_Frame;
    Rectangle m_rClip;
    int m_nBaseType;
    int[] m_seriesTypes;
    int[] m_axisAssignments;
    int[] m_seriesPlanes;
    int m_nDepthPlanes;
    int m_nDepthAngle;
    int m_nDepthRadius;

    public void calc() {
        Rectangle rClip = null;
        super.calc();
        this.createFrame();
        if (this.m_Frame != null) {
            this.m_Frame.calc();
        }
        if (this.m_Frame != null) {
            rClip = this.m_Perspective.getFrameRect(false);
        }
        this.m_rClip = rClip != null && !rClip.isEmpty() ? rClip : null;
    }

    public double calcBackOffset(int nCurrPlane, int nDepthPlanes) {
        if (nDepthPlanes == 0) {
            return 0.0;
        }
        double fUnit = 1.0 / (double)nDepthPlanes;
        double fOffset = fUnit * (double)nCurrPlane;
        return fOffset;
    }

    public void calcDataScrollers() {
        this.m_Frame.calcDataScrollers();
    }

    public int calcDepthPlanes() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        int nNumPlanes = 0;
        int nAreas = 0;
        boolean bHasBars = false;
        boolean bHasAreas = false;
        boolean bHasLines = false;
        this.m_seriesPlanes = new int[this.m_nTotalSeries];
        if (this.m_bAbsolute) {
            int nSeriesType;
            int s;
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                nSeriesType = this.m_seriesTypes[s];
                if (nSeriesType == 1) {
                    bHasBars = true;
                    continue;
                }
                if (nSeriesType == 3) {
                    this.m_seriesPlanes[s] = nAreas++;
                    ++nNumPlanes;
                    continue;
                }
                if (nSeriesType == 2) {
                    bHasLines = true;
                    ++nNumPlanes;
                    continue;
                }
                if (nSeriesType == 12) {
                    bHasBars = true;
                    continue;
                }
                throw new AssertionException("Unknown riser type = " + nSeriesType + " for series = " + s);
            }
            int plane = nAreas;
            if (bHasBars) {
                ++nNumPlanes;
                sEnum.reset();
                while (sEnum.hasMoreElements()) {
                    s = sEnum.nextSeries();
                    nSeriesType = this.m_seriesTypes[s];
                    if (nSeriesType == 1) {
                        this.m_seriesPlanes[s] = plane;
                    }
                    if (nSeriesType != 12) continue;
                    nNumPlanes = 2;
                }
                ++plane;
            }
            if (bHasLines) {
                sEnum.reset();
                while (sEnum.hasMoreElements()) {
                    s = sEnum.nextSeries();
                    nSeriesType = this.m_seriesTypes[s];
                    if (nSeriesType != 2) continue;
                    this.m_seriesPlanes[s] = plane++;
                }
            }
        } else {
            int nSeriesType;
            int s;
            int plane = 0;
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                nSeriesType = this.m_seriesTypes[s];
                switch (nSeriesType) {
                    case 1: {
                        bHasBars = true;
                        break;
                    }
                    case 3: {
                        this.m_seriesPlanes[s] = plane;
                        bHasAreas = true;
                        break;
                    }
                    case 2: {
                        bHasLines = true;
                        break;
                    }
                    default: {
                        throw new AssertionException("unknown seriesType = " + nSeriesType);
                    }
                }
            }
            if (bHasAreas) {
                ++nNumPlanes;
                ++plane;
            }
            if (bHasBars) {
                sEnum.reset();
                while (sEnum.hasMoreElements()) {
                    s = sEnum.nextSeries();
                    nSeriesType = this.m_seriesTypes[s];
                    if (nSeriesType != 1) continue;
                    this.m_seriesPlanes[s] = plane;
                }
                ++nNumPlanes;
                ++plane;
            }
            if (bHasLines) {
                sEnum.reset();
                while (sEnum.hasMoreElements()) {
                    s = sEnum.nextSeries();
                    nSeriesType = this.m_seriesTypes[s];
                    if (nSeriesType != 2) continue;
                    this.m_seriesPlanes[s] = plane;
                }
                ++nNumPlanes;
            }
        }
        return nNumPlanes;
    }

    public double calcFrontOffset(int nCurrPlane, int nDepthPlanes) {
        if (nDepthPlanes == 0) {
            return 0.0;
        }
        double fUnit = 1.0 / (double)nDepthPlanes;
        double fOffset = fUnit * (double)nCurrPlane + fUnit;
        return fOffset;
    }

    protected void copyParams() {
        super.copyParams();
        this.m_nDepthRadius = this.m_Perspective.getDepthRadius();
        this.m_nDepthAngle = this.m_Perspective.getDepthAngle();
        this.m_nBaseType = this.m_gt.getRiserType();
        this.m_seriesTypes = this.m_Perspective.getSeriesTypes();
        if (this.m_nDepthRadius > 0 && this.m_gt.wantDepthEffect()) {
            this.m_nDepthPlanes = this.calcDepthPlanes();
        }
        this.m_axisAssignments = new int[this.m_nTotalSeries];
        if (this.m_gt.isDualY() || this.m_gt.isParetoType() || this.m_gt.isMultiY()) {
            int s = 0;
            while (s < this.m_nTotalSeries) {
                this.m_axisAssignments[s] = this.m_Perspective.getAxisAssignment(s);
                ++s;
            }
        } else {
            int s = 0;
            while (s < this.m_nTotalSeries) {
                this.m_axisAssignments[s] = 0;
                ++s;
            }
        }
    }

    public void createFrame() {
        this.m_Frame = new FrameObj(this.m_Perspective);
    }

    public FrameObj getFrameObj() {
        return this.m_Frame;
    }

    public int getAxisAssignment(int s) {
        return this.m_axisAssignments[s];
    }

    public void init(Perspective perspective) {
        super.init(perspective);
        this.m_Frame = null;
    }

    public boolean isGroupScrollerPresent() {
        boolean bGroupScrollerPresent = false;
        if (this.m_Frame != null) {
            bGroupScrollerPresent = this.m_Frame.isGroupScrollerPresent();
        }
        return bGroupScrollerPresent;
    }

    public boolean isDataAxisScrollerPresent(int axis) {
        if (axis == 2001) {
            return this.isGroupScrollerPresent();
        }
        if (this.m_Perspective.isExportingToSVG() || this.m_Perspective.isExportingToXML()) {
            if (axis == 2003) {
                int presence = this.m_Perspective.getDataScrollerPresenceX1();
                return !(!this.m_Perspective.isX1AxisPresent() || presence != 2 && (presence != 3 && presence != 1 || this.m_Perspective.getX1ScaleMaxAuto() && this.m_Perspective.getX1ScaleMinAuto() && this.m_Perspective.getIntegerProp(Attr.TimeRangeMode) == 0));
            }
            if (axis == 2004) {
                int presence = this.m_Perspective.getDataScrollerPresenceY1();
                return !(!this.m_Perspective.isY1AxisPresent() || presence != 2 && (presence != 3 && presence != 1 || this.m_Perspective.getY1ScaleMaxAuto() && this.m_Perspective.getY1ScaleMinAuto()));
            }
            if (axis == 2005) {
                int presence = this.m_Perspective.getDataScrollerPresenceY2();
                return !(!this.m_Perspective.isY2AxisPresent() || presence != 2 && (presence != 3 && presence != 1 || this.m_Perspective.getY2ScaleMaxAuto() && this.m_Perspective.getY2ScaleMinAuto()));
            }
        }
        return false;
    }

    public Rectangle getLeftFrameEdge() {
        if (this.m_Frame != null) {
            return this.m_Frame.getLeftEdge();
        }
        return this.m_Perspective.getFrameRect(false);
    }

    public Rectangle getRightFrameEdge() {
        if (this.m_Frame != null) {
            return this.m_Frame.getRightEdge();
        }
        return this.m_Perspective.getFrameRect(false);
    }

    public Rectangle getBottomFrameEdge() {
        if (this.m_Frame != null) {
            return this.m_Frame.getBottomEdge();
        }
        return this.m_Perspective.getFrameRect(false);
    }

    public void releaseReferences() {
        if (this.m_Frame != null) {
            this.m_Frame.releaseReferences();
        }
        super.releaseReferences();
    }

    public double getNumPixelsInArc(VC vc, int nCenterX, int nCenterY, double f12OClock, double fStart, double fEnd, double fRadius, double fXSquashRatio, double fYSquashRatio) {
        boolean bCalcSquashRatio;
        double fAngleStart = f12OClock + fStart * (Math.PI * 2);
        double fAngleEnd = f12OClock + fEnd * (Math.PI * 2);
        double fRadianPieSliceAngle = fAngleEnd - fAngleStart;
        boolean bl = bCalcSquashRatio = fXSquashRatio < 0.0 && fYSquashRatio < 0.0;
        if (bCalcSquashRatio) {
            fXSquashRatio = 1.0;
        }
        if (bCalcSquashRatio) {
            Rectangle destRect = vc.getDestCoords();
            fYSquashRatio = (double)Math.abs(destRect.width) / (double)destRect.height;
            if (fYSquashRatio > 1.0) {
                fXSquashRatio = 1.0 / fYSquashRatio;
                fYSquashRatio = 1.0;
            }
        }
        double fAngle = f12OClock + fStart * (Math.PI * 2);
        int nStartArcPosX = nCenterX + (int)Math.rint(Math.cos(fAngle) * fXSquashRatio * fRadius);
        int nStartArcPosY = nCenterY - (int)(Math.sin(fAngle) * fYSquashRatio * fRadius);
        int nDestCenterX = vc.virtToDestX(nCenterX);
        int nDestCenterY = vc.virtToDestX(nCenterY);
        int nDestStartArcPosX = vc.virtToDestX(nStartArcPosX);
        int nDestStartArcPosY = vc.virtToDestX(nStartArcPosY);
        double fXSquared = Math.pow(nDestStartArcPosX - nDestCenterX, 2.0);
        double fYSquared = Math.pow(nDestStartArcPosY - nDestCenterY, 2.0);
        double fDestRadius = Math.sqrt(fXSquared + fYSquared);
        double fNumPixelsInArc = fDestRadius * fRadianPieSliceAngle;
        return fNumPixelsInArc;
    }

    public static Map getAreaEffectsMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Color bHighlightColor = new Color(255, 255, 255, 204);
        Color bShadowColor = new Color(0, 0, 0, 76);
        double bDistance = 1.0;
        double bStrength = 1.0;
        double bAngle = 90.0;
        double bBlurX = 0.0;
        double bBlurY = 2.0;
        int bQuality = 3;
        String bType = "i";
        map.put("bevelHighlightColor", bHighlightColor);
        map.put("bevelShadowColor", bShadowColor);
        map.put("bevelDistance", bDistance);
        map.put("bevelStrength", bStrength);
        map.put("bevelAngle", bAngle);
        map.put("bevelBlurX", bBlurX);
        map.put("bevelBlurY", bBlurY);
        map.put("bevelQuality", bQuality);
        map.put("bevelType", bType);
        return map;
    }

    public static Map getLineEffectsMap(double lineWidth, boolean bevelOnly) {
        double sBlurX;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (lineWidth < 1.0) {
            lineWidth = 1.0;
        }
        Color sColor = new Color(78, 87, 101, 102);
        double sDistance = lineWidth + 1.0;
        double sStrength = 1.0;
        double sAngle = 45.0;
        double sBlurY = sBlurX = Math.min(lineWidth / 2.0 + 4.0, 10.0);
        int sQuality = 2;
        int sInner = 0;
        int sKnockout = 0;
        int sHide = 0;
        Color bHighlightColor = new Color(255, 255, 255, 204);
        Color bShadowColor = new Color(0, 0, 0, 76);
        double bDistance = lineWidth / 5.0;
        double bStrength = 1.0;
        double bAngle = 90.0;
        double bBlurX = 0.0;
        double bBlurY = lineWidth / 3.0;
        int bQuality = 3;
        String bType = "i";
        if (!bevelOnly) {
            map.put("shadowColor", sColor);
            map.put("shadowDistance", sDistance);
            map.put("shadowStrength", sStrength);
            map.put("shadowAngle", sAngle);
            map.put("shadowBlurX", sBlurX);
            map.put("shadowBlurY", sBlurY);
            map.put("shadowQuality", sQuality);
            map.put("shadowInner", sInner);
            map.put("shadowKnockout", sKnockout);
            map.put("shadowHide", sHide);
        }
        map.put("bevelHighlightColor", bHighlightColor);
        map.put("bevelShadowColor", bShadowColor);
        map.put("bevelDistance", bDistance);
        map.put("bevelStrength", bStrength);
        map.put("bevelAngle", bAngle);
        map.put("bevelBlurX", bBlurX);
        map.put("bevelBlurY", bBlurY);
        map.put("bevelQuality", bQuality);
        map.put("bevelType", bType);
        return map;
    }

    public static Map getBarEffectsMap(double barWidth) {
        double sBlurX;
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        if (barWidth < 1.0) {
            barWidth = 1.0;
        }
        Color sColor = new Color(78, 87, 101, 102);
        double sDistance = Math.min(barWidth / 3.0 + 1.0, 20.0);
        double sStrength = 1.0;
        double sAngle = 45.0;
        double sBlurY = sBlurX = Math.min(barWidth / 5.0 + 3.0, 10.0);
        int sQuality = 2;
        int sInner = 0;
        int sKnockout = 0;
        int sHide = 0;
        map.put("shadowColor", sColor);
        map.put("shadowDistance", Double.valueOf(sDistance));
        map.put("shadowStrength", Double.valueOf(sStrength));
        map.put("shadowAngle", Double.valueOf(sAngle));
        map.put("shadowBlurX", Double.valueOf(sBlurX));
        map.put("shadowBlurY", Double.valueOf(sBlurY));
        map.put("shadowQuality", Integer.valueOf(sQuality));
        map.put("shadowInner", Integer.valueOf(sInner));
        map.put("shadowKnockout", Integer.valueOf(sKnockout));
        map.put("shadowHide", Integer.valueOf(sHide));
        return map;
    }
}

