/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.AxisDescriptor;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.ColorObj;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.FillGradientObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;

public class JChart_2D_BLA
extends JChart_2D_Standard {
    public static final double DEPTH_FACTOR = 12.0;
    public static final double UNSHADED = 1.0;
    public static final double SHADING_FRONT = 1.0;
    public static final double SHADING_TOP = 0.8;
    public static final double SHADING_SIDE = 0.6;
    public static final double SHADING_BOTTOM = 0.4;
    public static final boolean DRAW_NEG_SERIES = true;
    public static final boolean DRAW_POS_SERIES = false;
    boolean m_bFromZero;
    boolean m_bBipolar;
    boolean m_bDualY;
    boolean m_bBarAsPictograph;
    int m_nLineThick;
    Point[] m_seriesBackOffsets;
    Point[] m_seriesFrontOffsets;
    boolean m_bTransparentMarkers;
    boolean m_bNonZeroBaseline;
    int m_baseLineYCoord;
    private static final int INVISIBLE_RECT_SIZE = 3;

    private void $init$() {
        this.m_bTransparentMarkers = false;
        this.m_bNonZeroBaseline = false;
        this.m_baseLineYCoord = 0;
    }

    public void calc() {
        this.m_bTransparentMarkers = this.m_Perspective.getTransparentMarkers();
        this.m_baseLineYCoord = 0;
        super.calc();
        this.calcFrontBackOffsets();
        if (this.m_gt.isRiserBar() && this.isComboWithBar() || this.m_Perspective.isContinuousTimeAxis()) {
            this.calcBarOrdinalCoords();
        } else {
            this.calcOrdinalCoords();
        }
        this.m_Perspective.calcReferenceObjects(1);
        if (this.m_bBipolar && this.wantDepthEffect()) {
            this.calcBiPolarTwoHalfD();
        } else {
            if (this.m_bBipolar) {
                this.drawDualAxisLine();
            }
            this.drawAreaRisers();
            AxisDescriptor axisDescriptor = null;
            axisDescriptor = this.m_Perspective.isContinuousTimeAxis() && this.m_gt.isBLAType() ? AxisDescriptor.AD_XY : this.m_gt.getAxisDescriptor();
            if (this.m_Y1Axis != null) {
                this.m_Y1Axis.calculateGrid();
            }
            if (axisDescriptor.hasY2() && this.m_Y2Axis != null) {
                this.m_Y2Axis.calculateGrid();
            }
            this.drawBarRisers();
            this.drawLineRisers();
        }
        if (this.m_bDataTextDisplay) {
            this.drawDataValues();
        }
        if (this.m_bAbsolute) {
            this.drawFitLines();
        }
    }

    private void calcBiPolarTwoHalfD() {
        boolean bY1first = this.m_bHorz && this.m_nDepthAngle > 90;
        this.drawDualAxisLine();
        this.drawAreaRisers(true, bY1first, bY1first ^ true);
        this.drawAxisBarRisers(bY1first, bY1first ^ true);
        this.drawLineRisers();
        this.drawAreaRisers(true, bY1first ^ true, bY1first);
        this.drawAxisBarRisers(bY1first ^ true, bY1first);
    }

    private void calcFrontBackOffsets() {
        if (this.wantDepthEffect()) {
            this.m_seriesBackOffsets = new Point[this.m_nTotalSeries];
            this.m_seriesFrontOffsets = new Point[this.m_nTotalSeries];
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
            while (sEnum.hasMoreElements()) {
                int s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                this.m_seriesBackOffsets[s] = this.calcSeriesOffset(s, false);
                this.m_seriesFrontOffsets[s] = this.calcSeriesOffset(s, true);
            }
        }
    }

    private void drawDualAxisLine() {
        if (this.m_Perspective.getFrameDisplay() && this.m_Perspective.getDualAxisLineDisplay()) {
            double fSplit = (double)this.m_Perspective.getDualAxisSplitPosition() / 100.0;
            this.m_Frame.drawSeparator(this.m_bHorz, fSplit);
        }
    }

    protected void calcDataAbsolute() {
        if (this.m_Perspective.isContinuousTimeAxis()) {
            super.calcDataAbsolute();
            return;
        }
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        double fValue = 0.0;
        int nSeriesPerPixel = this.calcRisersPerPixel();
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        int nDataFormat = this.m_Perspective.getDataTextFormat();
        String szFormatPattern = this.m_Perspective.getDataTextFormatPattern();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                this.m_dataOK[s][g] = true;
                RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                if (axisObj == null) continue;
                DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                fValue = dObj.m_fValue;
                if (!dObj.m_bOK) {
                    this.m_dataOK[s][g] = false;
                }
                if (fValue <= 0.0 && axisObj.isLogScale()) {
                    this.m_dataOK[s][g] = false;
                    fValue = 0.0;
                }
                if (this.isIgnoredOffScale(axisObj, fValue)) {
                    this.m_dataOK[s][g] = false;
                    fValue = 0.0;
                }
                this.m_numYCoords[s][g] = (int)axisObj.getValueCoord(fValue);
                if (!this.m_bDataTextDisplay) continue;
                if (bNumberFormatCallBackActive) {
                    int nAxisID = this.axisAssignedToSeries(s, DataItem.DI_GENERAL);
                    this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                    this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                    continue;
                }
                this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fValue, szFormatPattern);
            }
        }
        this.calcOverdrawEliminate(nSeriesPerPixel);
    }

    private void calcOverdrawEliminate(int nSeriesPerPixel) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        if (this.m_Perspective.getOverdrawSkip() && nSeriesPerPixel > 4) {
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                int nBunchEnd = this.m_nSeries / nSeriesPerPixel - 1;
                int iBunch = 1;
                while (iBunch < nBunchEnd) {
                    int s;
                    int sRelStart = iBunch * nSeriesPerPixel;
                    int sRelBound = sRelStart + nSeriesPerPixel;
                    PfjAssert.pfjAssert(sRelBound <= this.m_nSeries);
                    int sForMin = -1;
                    int sForMax = -1;
                    int nMinCoord = Integer.MAX_VALUE;
                    int nMaxCoord = -2147483647;
                    int sRel = sRelStart;
                    while (sRel < sRelBound) {
                        s = sEnum.seriesAt(sRel);
                        PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                        if (this.m_dataOK[s][g]) {
                            int nCoord = this.m_numYCoords[s][g];
                            if (nCoord < nMinCoord) {
                                nMinCoord = nCoord;
                                sForMin = s;
                            }
                            if (nCoord > nMaxCoord) {
                                nMaxCoord = nCoord;
                                sForMax = s;
                            }
                        }
                        ++sRel;
                    }
                    if (sForMin != -1) {
                        sRel = sRelStart;
                        while (sRel < sRelBound) {
                            s = sEnum.seriesAt(sRel);
                            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                            if (s != sForMin && s != sForMax) {
                                this.m_dataOK[s][g] = false;
                            }
                            ++sRel;
                        }
                    }
                    ++iBunch;
                }
            }
        }
    }

    public Point calcSeriesOffset(int s, boolean bFront) {
        Point pt;
        if (bFront) {
            double fFront = this.calcFrontOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            pt = this.m_Frame.getDepthOffset(fFront);
        } else {
            double fBack = this.calcBackOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            pt = this.m_Frame.getDepthOffset(fBack);
        }
        return pt;
    }

    protected void copyParams() {
        super.copyParams();
        this.m_bFromZero = this.m_Perspective.getScaleFromZero();
        this.m_bBipolar = this.m_gt.isBipolar();
        this.m_bDualY = this.m_gt.isDualY();
        this.m_bBarAsPictograph = this.m_nDepthRadius > 0 ? false : this.m_Perspective.getDisplayBarAsPictograph();
        this.m_nLineThick = this.m_Perspective.getDataLineThickness();
    }

    private void drawAreaRisers() {
        if (this.m_nGroups >= 2) {
            if (this.wantDepthEffect()) {
                if (this.m_bBipolar) {
                    this.drawAreaRisers(true, false, true);
                }
                this.drawAreaRisers(true, true, false);
            } else {
                if (this.m_bBipolar) {
                    this.drawAreaRisers(false, false, true);
                }
                this.drawAreaRisers(false, true, false);
            }
        }
    }

    private void drawAreaRisers(boolean area25D, boolean bDrawY1, boolean bDrawY2) {
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        RelativeAxisObj yAxisObj = null;
        int g = 0;
        Point p = null;
        Point p0 = null;
        int nZeroCoord = 0;
        int baseCoord = 0;
        boolean bReverseSeries = false;
        boolean bReverseGroups = false;
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bNegNZValue = false;
        boolean bNegData = false;
        double fBaseline = 0.0;
        Point finalp = null;
        Point startp = null;
        Vector allVectPoints = new Vector();
        boolean bDescending = bDrawY1 ? this.m_Y1Axis.isDescending() : this.m_Y2Axis.isDescending();
        bReverseSeries = area25D ? !this.m_bAbsolute && (this.m_bHorz ? bDescending != bRightToLeft : bDescending) : this.m_bAbsolute ^ true;
        boolean bForwardSeries = bReverseSeries ^ true;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            startp = null;
            Vector seriesVect = new Vector();
            int count = 0;
            if (this.m_seriesTypes[s] != 3) continue;
            yAxisObj = this.whichAxisForSeries(s, null);
            int maxCoord = (int)yAxisObj.getValueCoord(yAxisObj.getMaxValue());
            int minCoord = (int)yAxisObj.getValueCoord(yAxisObj.getMinValue());
            if (bDescending) {
                int temp = minCoord;
                minCoord = maxCoord;
                maxCoord = temp;
            }
            if (yAxisObj == null) continue;
            int axisID = yAxisObj.getAxisObjID();
            if (bDrawY1 ? axisID != 0 && this.m_bBipolar : bDrawY2 && axisID != 1 && this.m_bBipolar) continue;
            baseCoord = (int)yAxisObj.getBaseCoord();
            nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
            if (baseCoord > maxCoord) {
                baseCoord = maxCoord;
            } else if (baseCoord < minCoord) {
                baseCoord = minCoord;
            }
            if (nZeroCoord > maxCoord) {
                nZeroCoord = maxCoord;
            } else if (nZeroCoord < minCoord) {
                nZeroCoord = minCoord;
            }
            IdentObj id = yAxisObj.getAxisIdentObj();
            this.m_bNonZeroBaseline = this.m_Perspective.getNonZeroBaseline(id);
            if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                fBaseline = this.m_Perspective.getNonZeroBaselineValue(id);
                if (yAxisObj.isLogScale() && fBaseline <= 0.0) {
                    this.m_bNonZeroBaseline = false;
                }
            }
            if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                boolean bl = bNegNZValue = fBaseline < 0.0;
                this.m_baseLineYCoord = bNegNZValue ? (fBaseline >= yAxisObj.getMinValue() ? (int)yAxisObj.getValueCoord(fBaseline) : (int)yAxisObj.getValueCoord(yAxisObj.getBaseMin())) : (fBaseline <= yAxisObj.getMaxValue() ? (int)yAxisObj.getValueCoord(fBaseline) : (int)yAxisObj.getValueCoord(yAxisObj.getBaseMax()));
                DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                bNegData = dObj.m_fValue < 0.0;
            }
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!gEnum.hasMoreElements()) continue;
                int gNext = gEnum.peekAtNextGroup();
                if (this.m_Perspective.isTimeAxis() && this.m_Perspective.getDateFrequency() == 3 && !this.m_dataOK[s][gNext]) {
                    while (gEnum.hasMoreElements() && !this.m_dataOK[s][gNext]) {
                        gNext = gEnum.nextGroup();
                        if (!gEnum.hasMoreElements()) continue;
                        gNext = gEnum.peekAtNextGroup();
                    }
                }
                PfjAssert.pfjAssert(gNext >= 0 && gNext < this.m_nTotalGroups);
                if (this.m_dataOK[s][g] && this.m_dataOK[s][gNext]) {
                    PointInfo pInfo = this.getPointInfo(seriesVect, s, g);
                    PointInfo pInfoNext = this.getPointInfo(seriesVect, s, gNext);
                    BlackBoxIF blackBox = this.assignSeriesColor(s, g);
                    blackBox.runRules(s, g);
                    p0 = this.getCoords(s, g);
                    p = this.getCoords(s, gNext);
                    finalp = new Point(p);
                    startp = new Point(p0);
                    if (this.m_numYCoords[s][g] > maxCoord && this.m_numYCoords[s][gNext] > maxCoord) {
                        if (this.m_bHorz) {
                            p0.x = p.x = maxCoord;
                        } else {
                            p0.y = p.y = maxCoord;
                        }
                    } else if (this.m_numYCoords[s][g] > maxCoord) {
                        if (this.m_bHorz) {
                            double newy = this.calcyPosition(p0, p, maxCoord);
                            p0.x = maxCoord;
                            p0.y = (int)newy;
                        } else {
                            double newx = this.calcxPosition(p0, p, maxCoord);
                            p0.y = maxCoord;
                            p0.x = (int)newx;
                        }
                    } else if (this.m_numYCoords[s][gNext] > maxCoord) {
                        if (this.m_bHorz) {
                            double newy = this.calcyPosition(p0, p, maxCoord);
                            p.x = maxCoord;
                            p.y = (int)newy;
                        } else {
                            double newx = this.calcxPosition(p0, p, maxCoord);
                            p.y = maxCoord;
                            p.x = (int)newx;
                        }
                    }
                    if (this.m_numYCoords[s][g] < minCoord && this.m_numYCoords[s][gNext] < minCoord) {
                        if (this.m_bHorz) {
                            p0.x = p.x = minCoord;
                        } else {
                            p0.y = p.y = minCoord;
                        }
                    } else if (this.m_numYCoords[s][g] < minCoord) {
                        if (this.m_bHorz) {
                            double newy = this.calcyPosition(p0, p, minCoord);
                            p0.x = minCoord;
                            p0.y = (int)newy;
                        } else {
                            double newx = this.calcxPosition(p0, p, minCoord);
                            p0.y = minCoord;
                            p0.x = (int)newx;
                        }
                    } else if (this.m_numYCoords[s][gNext] < minCoord) {
                        if (this.m_bHorz) {
                            double newy = this.calcyPosition(p0, p, minCoord);
                            p.x = minCoord;
                            p.y = (int)newy;
                        } else {
                            double newx = this.calcxPosition(p0, p, minCoord);
                            p.y = minCoord;
                            p.x = (int)newx;
                        }
                    }
                    int x0 = p0.x;
                    int y0 = p0.y;
                    if (count == 0 && !this.m_bHorz) {
                        Point st;
                        pInfo.lt = st = this.checkStartPointVertical(startp, s, g, p0);
                    } else if (count == 0 && this.m_bHorz) {
                        Point st;
                        pInfo.lt = st = this.checkStartPointHorizontal(startp, s, g, p0);
                    }
                    pInfo.rt = p0;
                    pInfoNext.lt = p;
                    ++count;
                    finalp.y = p.y;
                    continue;
                }
                if (count != 0) {
                    if (this.m_bHorz) {
                        Point last = this.checkEndPointHorizontal(finalp, s, g, p);
                        PointInfo pInfoNext = this.getPointInfo(seriesVect, s, g);
                        pInfoNext.rt = last;
                    } else {
                        Point last = this.checkEndPointVertical(finalp, s, g, p);
                        PointInfo pInfoNext = this.getPointInfo(seriesVect, s, g);
                        pInfoNext.rt = last;
                    }
                    count = 0;
                }
                if (!this.m_dataOK[s][g] || g == 0 && !this.m_dataOK[s][gNext]) {
                    PointInfo pInfo = this.getPointInfo(seriesVect, s, g);
                    pInfo.setStatus(0);
                    pInfo.rt = pInfo.lt = this.getCoords(s, g);
                }
                if (gNext != this.m_nTotalGroups - 1) continue;
                PointInfo pInfo = this.getPointInfo(seriesVect, s, gNext);
                pInfo.setStatus(0);
                pInfo.rt = pInfo.lt = this.getCoords(s, gNext);
            }
            if (count != 0) {
                if (this.m_bHorz) {
                    Point last = this.checkEndPointHorizontal(finalp, s, g, p);
                    PointInfo pInfoNext = this.getPointInfo(seriesVect, s, g);
                    pInfoNext.rt = last;
                } else {
                    Point last = this.checkEndPointVertical(finalp, s, g, p);
                    PointInfo pInfoNext = this.getPointInfo(seriesVect, s, g);
                    pInfoNext.rt = last;
                }
            }
            allVectPoints.add(seriesVect);
        }
        if (area25D) {
            this.drawAreaRiserFromVector25D(allVectPoints, yAxisObj, nZeroCoord, baseCoord, bForwardSeries);
        } else {
            this.drawAreaRiserFromVector(allVectPoints, yAxisObj, nZeroCoord, baseCoord);
        }
        if (!area25D && this.m_bTransparentMarkers) {
            this.drawTransparentMarkers(3);
        }
    }

    private void drawAxisBarRisers(boolean bDrawY1, boolean bDrawY2) {
        if (this.m_bAbsolute) {
            this.drawAxisBarRisersAbsolute(bDrawY1, bDrawY2);
        } else if (this.m_bDualY && !this.m_bBipolar) {
            this.drawAxisBarRisersStackedDualY(bDrawY1, bDrawY2);
        } else {
            this.drawAxisBarRisersStacked(bDrawY1, bDrawY2);
        }
    }

    private void drawAxisBarRisersAbsolute(boolean bDrawY1, boolean bDrawY2) {
        boolean bReverseSeries;
        boolean bReverseGroups;
        boolean bRightToLeft;
        boolean bl = bRightToLeft = this.m_nDepthAngle > 90;
        if (this.m_bHorz) {
            if (this.m_Perspective.getDepthRadius() > 0 && this.m_Perspective.getDepthAngle() > 0) {
                bReverseGroups = true;
                bReverseSeries = true;
            } else {
                bReverseGroups = false;
                bReverseSeries = false;
            }
        } else {
            bReverseGroups = bRightToLeft;
            bReverseSeries = bRightToLeft;
        }
        boolean bForwardSeries = bReverseSeries ^ true;
        boolean bForwardGroups = bReverseGroups ^ true;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, bForwardGroups);
        int sFirst = sEnum.getFirstSeries();
        int sLast = sEnum.getLastSeries();
        int gFirst = gEnum.getFirstGroup();
        while (gEnum.hasMoreElements()) {
            int axisID;
            RelativeAxisObj yAxisObj;
            int s;
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            if (bDrawY1) {
                sEnum.reset();
                while (sEnum.hasMoreElements()) {
                    s = sEnum.nextSeries();
                    PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                    if (this.m_seriesTypes[s] != 1 || (yAxisObj = this.whichAxisForSeries(s, null)) == null || (axisID = yAxisObj.getAxisObjID()) != 0 && this.m_bBipolar) continue;
                    this.drawOneBarRiser(s, g, sEnum, gEnum);
                }
            }
            if (!bDrawY2 || !this.m_bBipolar) continue;
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                yAxisObj = this.whichAxisForSeries(s, null);
                if (yAxisObj == null || (axisID = yAxisObj.getAxisObjID()) != 1 && this.m_bBipolar) continue;
                this.drawOneBarRiser(s, g, sEnum, gEnum);
            }
        }
    }

    private void drawAxisBarRisersStacked(boolean bDrawY1, boolean bDrawY2) {
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bReverseGroups = this.m_bHorz || bRightToLeft;
        boolean bForwardGroups = bReverseGroups ^ true;
        boolean bDescending = bDrawY1 ? this.m_Y1Axis.isDescending() : this.m_Y2Axis.isDescending();
        boolean bReverseSeries = this.m_bHorz ? bDescending != bRightToLeft : bDescending;
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, bForwardGroups);
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            if (bReverseSeries) {
                this.drawBarGroup(g, bDrawY1, bDrawY2, true, false, gEnum);
                this.drawBarGroup(g, bDrawY1, bDrawY2, false, true, gEnum);
                continue;
            }
            this.drawBarGroup(g, bDrawY1, bDrawY2, true, true, gEnum);
            this.drawBarGroup(g, bDrawY1, bDrawY2, false, false, gEnum);
        }
    }

    private void drawAxisBarRisersStackedDualY(boolean bDrawY1, boolean bDrawY2) {
        boolean bY1ReverseSeries;
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bReverseGroups = this.m_bHorz || bRightToLeft;
        boolean bForwardGroups = bReverseGroups ^ true;
        boolean bReverseSeries = false;
        boolean bY2first = this.m_bHorz || bRightToLeft;
        boolean bY1Descending = this.m_Y1Axis.isDescending();
        boolean bY2Descending = this.m_Y2Axis.isDescending();
        boolean bl = this.m_bHorz ? bY1Descending != bRightToLeft : (bY1ReverseSeries = bY1Descending);
        boolean bY2ReverseSeries = this.m_bHorz ? bY2Descending != bRightToLeft : bY2Descending;
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, bForwardGroups);
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            if (bY2first) {
                if (bY2ReverseSeries) {
                    this.drawBarGroup(g, false, bDrawY2, bReverseSeries ^ true, false, gEnum);
                    this.drawBarGroup(g, false, bDrawY2, bReverseSeries, true, gEnum);
                } else {
                    this.drawBarGroup(g, false, bDrawY2, bReverseSeries ^ true, true, gEnum);
                    this.drawBarGroup(g, false, bDrawY2, bReverseSeries, false, gEnum);
                }
                if (bY1ReverseSeries) {
                    this.drawBarGroup(g, bDrawY1, false, bReverseSeries ^ true, false, gEnum);
                    this.drawBarGroup(g, bDrawY1, false, bReverseSeries, true, gEnum);
                    continue;
                }
                this.drawBarGroup(g, bDrawY1, false, bReverseSeries ^ true, true, gEnum);
                this.drawBarGroup(g, bDrawY1, false, bReverseSeries, false, gEnum);
                continue;
            }
            if (bY1ReverseSeries) {
                this.drawBarGroup(g, bDrawY1, false, bReverseSeries ^ true, false, gEnum);
                this.drawBarGroup(g, bDrawY1, false, bReverseSeries, true, gEnum);
            } else {
                this.drawBarGroup(g, bDrawY1, false, bReverseSeries ^ true, true, gEnum);
                this.drawBarGroup(g, bDrawY1, false, bReverseSeries, false, gEnum);
            }
            if (bY2ReverseSeries) {
                this.drawBarGroup(g, false, bDrawY2, bReverseSeries ^ true, false, gEnum);
                this.drawBarGroup(g, false, bDrawY2, bReverseSeries, true, gEnum);
                continue;
            }
            this.drawBarGroup(g, false, bDrawY2, bReverseSeries ^ true, true, gEnum);
            this.drawBarGroup(g, false, bDrawY2, bReverseSeries, false, gEnum);
        }
    }

    private void drawAxisLineRisers(int nAxis) {
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bReverseGroups = this.m_bHorz || bRightToLeft;
        boolean bForwardGroups = bReverseGroups ^ true;
        boolean bForwardSeries = true;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, bForwardGroups);
        while (sEnum.hasMoreElements()) {
            int axisID;
            RelativeAxisObj yAxisObj;
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] != 2 || (yAxisObj = this.whichAxisForSeries(s, null)) == null || (axisID = yAxisObj.getAxisObjID()) != nAxis && (!this.m_bAbsolute || this.m_bBipolar)) continue;
            if (this.m_Perspective.getConnectLineMarkers()) {
                gEnum.reset();
                while (gEnum.hasMoreElements()) {
                    int g = gEnum.nextGroup();
                    PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                    if (!bForwardGroups && g == gEnum.getFirstGroup()) continue;
                    this.drawOneLineRiser(s, g, gEnum);
                }
            }
            if (this.m_nDepthRadius <= 0) continue;
            if (this.m_Perspective.getConnectLineMarkers()) {
                this.drawMarkersWithDepth(s, true);
                continue;
            }
            this.drawMarkersWithDepth(s, false);
        }
    }

    private void drawBarAsPictograph(Axis2DObj yAxisObj, Rectangle rVirt, IdentObj id, BlackBoxIF blackBox) {
        Rectangle rPicto = new Rectangle(rVirt);
        int nGridlines = yAxisObj.getNumMajorGrids();
        int top = rVirt.y + rVirt.height;
        int bottom = rVirt.y;
        int left = rVirt.x;
        int right = rVirt.x + rVirt.width;
        double fPrevGridPosVC = yAxisObj.getBaseCoord();
        int iGrid = 0;
        while (iGrid <= nGridlines) {
            Rectangle rClip;
            double fGridPosRel = yAxisObj.getMajorGridPos(iGrid);
            double fGridPosVC = yAxisObj.scaleToVC(fGridPosRel);
            double gap = fGridPosVC - fPrevGridPosVC;
            if (this.m_bHorz) {
                if (yAxisObj.isAscending()) {
                    if (fPrevGridPosVC > (double)left) {
                        left = (int)fPrevGridPosVC;
                    }
                    if (fGridPosVC >= (double)(rVirt.x + rVirt.width)) {
                        right = rVirt.x + rVirt.width;
                        rPicto.x = left;
                        rPicto.width = (int)gap;
                        rClip = new Rectangle(this.m_rClip);
                        if (right < rClip.x + rClip.width) {
                            rClip.width = right - rClip.x;
                        }
                        new DetRect(this.m_Detectiv, id, rPicto, blackBox, rClip);
                    } else if (fGridPosVC > (double)left + gap / 10.0) {
                        right = (int)fGridPosVC;
                        rPicto.x = left;
                        rPicto.width = right - left;
                        new DetRect(this.m_Detectiv, id, rPicto, blackBox, this.m_rClip);
                        fPrevGridPosVC = fGridPosVC;
                    }
                } else {
                    if (fPrevGridPosVC < (double)right) {
                        right = (int)fPrevGridPosVC;
                    }
                    if (fGridPosVC < (double)rVirt.x) {
                        rPicto.x = left = rVirt.x;
                        rPicto.width = right - left;
                        rClip = new Rectangle(this.m_rClip);
                        if (left > rClip.x) {
                            rClip.x = left;
                        }
                        new DetRect(this.m_Detectiv, id, rPicto, blackBox, rClip);
                    } else if (fGridPosVC < (double)right - gap / 10.0) {
                        rPicto.x = left = (int)fGridPosVC;
                        rPicto.width = right - left;
                        new DetRect(this.m_Detectiv, id, rPicto, blackBox, this.m_rClip);
                        fPrevGridPosVC = fGridPosVC;
                    }
                }
            } else if (yAxisObj.isAscending()) {
                if (fPrevGridPosVC > (double)bottom) {
                    bottom = (int)fPrevGridPosVC;
                }
                if (fGridPosVC >= (double)(rVirt.y + rVirt.height)) {
                    top = rVirt.y + rVirt.height;
                    rPicto.y = bottom;
                    rPicto.height = (int)gap;
                    rClip = new Rectangle(this.m_rClip);
                    if (top < rClip.y + rClip.height) {
                        rClip.height = top - rClip.y;
                    }
                    new DetRect(this.m_Detectiv, id, rPicto, blackBox, rClip);
                    break;
                }
                if (fGridPosVC > (double)bottom + gap / 10.0) {
                    top = (int)fGridPosVC;
                    rPicto.y = bottom;
                    rPicto.height = top - bottom;
                    new DetRect(this.m_Detectiv, id, rPicto, blackBox, this.m_rClip);
                    fPrevGridPosVC = fGridPosVC;
                }
            } else {
                if (fPrevGridPosVC < (double)top) {
                    top = (int)fPrevGridPosVC;
                }
                if (fGridPosVC <= (double)rVirt.y) {
                    rPicto.y = bottom = rVirt.y;
                    rPicto.height = top - bottom;
                    rClip = new Rectangle(this.m_rClip);
                    if (bottom > rClip.y) {
                        rClip.y = bottom;
                    }
                    new DetRect(this.m_Detectiv, id, rPicto, blackBox, rClip);
                    break;
                }
                if (fGridPosVC < (double)top - gap / 10.0) {
                    rPicto.y = bottom = (int)fGridPosVC;
                    rPicto.height = top - bottom;
                    new DetRect(this.m_Detectiv, id, rPicto, blackBox, this.m_rClip);
                    fPrevGridPosVC = fGridPosVC;
                }
            }
            ++iGrid;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawBarGroup(int g, boolean bDrawY1, boolean bDrawY2, boolean bReverseSeries, boolean bNegative, GroupsEnumerator gEnum) {
        block10: {
            bForwardSeries = bReverseSeries ^ true;
            gFirst = gEnum.getFirstGroup();
            sEnum = this.getResetSeriesEnumerator(bForwardSeries);
            sFirst = sEnum.getFirstSeries();
            sLast = sEnum.getLastSeries();
            seriesList = new ArrayList<Integer>();
            if (this.m_Perspective.getDepthRadius() <= 0 || this.m_Perspective.getDepthAngle() <= 0) ** GOTO lbl27
            while (sEnum.hasMoreElements()) {
                series = sEnum.nextSeries();
                seriesList.add(series);
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                series = sEnum.nextSeries();
                isAdded = false;
                j = 0;
                while (j < seriesList.size()) {
                    if (this.m_numYCoords[series][g] > this.m_numYCoords[(Integer)seriesList.get(j)][g]) {
                        seriesList.add(j, series);
                        isAdded = true;
                        break;
                    }
                    ++j;
                }
                if (isAdded) continue;
                seriesList.add(series);
lbl27:
                // 3 sources

                ** while (sEnum.hasMoreElements())
            }
lbl28:
            // 1 sources

            if (this.m_bHorz) {
                Collections.reverse(seriesList);
            }
        }
        i = 0;
        while (i < seriesList.size()) {
            s = (Integer)seriesList.get(i);
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (!(this.m_seriesTypes[s] != 1 || this.m_gt.isWaterfall() && s == 0 || (yAxisObj = this.whichAxisForSeries(s, null)) == null)) {
                nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
                bDescending = yAxisObj.isDescending();
                v0 = bDescending ? this.m_numYCoords[s][g] > nZeroCoord : (bNegValue = this.m_numYCoords[s][g] < nZeroCoord);
                if (!bNegValue && this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue < 0.0) {
                    bNegValue = true;
                }
                if (bNegValue == bNegative) {
                    axisID = yAxisObj.getAxisObjID();
                    if ((bDrawY1 || axisID != 0) && (bDrawY2 || axisID != 1)) {
                        this.drawOneBarRiser(s, g, sEnum, gEnum);
                    }
                }
            }
            ++i;
        }
    }

    private void drawBarRisers() {
        if (this.m_bBipolar) {
            this.drawAxisBarRisers(false, true);
            this.drawAxisBarRisers(true, false);
        } else if (this.m_bDualY) {
            this.drawAxisBarRisers(true, true);
        } else {
            this.drawAxisBarRisers(true, false);
        }
    }

    private void drawLineRisers() {
        if (this.m_Perspective.getConnectLineMarkers()) {
            this.drawLines(false);
        }
        if (this.wantDepthEffect()) {
            if (this.m_Perspective.getConnectLineMarkers()) {
                return;
            }
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator(true);
            while (sEnum.hasMoreElements()) {
                int s = sEnum.nextSeries();
                this.drawMarkersWithDepth(s, false);
            }
        } else if (!this.m_bMarkerDisplay && this.m_bTransparentMarkers) {
            this.drawTransparentMarkers(2);
        } else {
            this.drawMarkers();
        }
    }

    protected void drawLinesWithDepth() {
        if (this.m_bBipolar) {
            this.drawAxisLineRisers(1);
            this.drawAxisLineRisers(0);
        } else if (this.m_bDualY) {
            this.drawAxisLineRisers(0);
            this.drawAxisLineRisers(1);
        } else {
            this.drawAxisLineRisers(0);
        }
    }

    private void drawOneBarRiser(int s, int g, SeriesEnumerator sEnum, GroupsEnumerator gEnum) {
        int left = 0;
        int nValueCoord = this.m_numYCoords[s][g];
        double fBaseline = 0.0;
        boolean bNegNZValue = false;
        boolean bNegData = false;
        if (this.m_dataOK[s][g] && this.m_seriesTypes[s] == 1) {
            Axis2DObj yAxisObj;
            int sFirst = sEnum.getFirstSeries();
            int sLast = sEnum.getLastSeries();
            int gFirst = gEnum.getFirstGroup();
            int gLast = gEnum.getLastGroup();
            if (this.m_gt.isWaterfall()) {
                int nTemp;
                if (sLast < sFirst) {
                    nTemp = sLast;
                    sLast = sFirst;
                    sFirst = nTemp;
                }
                if (gLast < gFirst) {
                    nTemp = gLast;
                    gLast = gFirst;
                    gFirst = nTemp;
                }
            }
            if ((yAxisObj = (Axis2DObj)this.whichAxisForSeries(s, null)) != null) {
                int top;
                int bottom;
                int right;
                int nHigh;
                int nLow;
                int nBaseCoord;
                int sPrev;
                boolean bNegValue;
                int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
                boolean bDescending = yAxisObj.isDescending();
                boolean bDrawingPictograph = this.m_bBarAsPictograph && yAxisObj.getNumMajorGrids() > 1;
                BlackBoxIF blackBox = this.assignSeriesColor(s, g);
                blackBox.runRules(s, g);
                BlackBoxIF blackBoxNew = this.getMissingDataBlackBox(s, g);
                if (blackBoxNew == null) {
                    blackBoxNew = blackBox;
                }
                RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                IdentObj id = axisObj.getAxisIdentObj();
                this.m_bNonZeroBaseline = this.m_Perspective.getNonZeroBaseline(id);
                if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                    fBaseline = this.m_Perspective.getNonZeroBaselineValue(id);
                    if (yAxisObj.isLogScale() && fBaseline <= 0.0) {
                        this.m_bNonZeroBaseline = false;
                    }
                }
                if (this.m_gt.isWaterfall()) {
                    DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                    bNegValue = dObj.m_bOK && dObj.m_fValue < 0.0;
                    sPrev = this.prevSeriesForAxis(s, yAxisObj);
                } else {
                    boolean useNegValue = bNegValue = bDescending ? nValueCoord > nZeroCoord : nValueCoord < nZeroCoord;
                    if (!bNegValue && this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue < fBaseline) {
                        useNegValue = true;
                    }
                    sPrev = this.prevSeriesForAxis(s, g, yAxisObj, useNegValue);
                }
                boolean bFromZero = this.wantRisersFromZero(yAxisObj);
                if (this.m_bAbsolute || sPrev == -2) {
                    nBaseCoord = bFromZero ? nZeroCoord : (int)yAxisObj.getBaseCoord();
                } else {
                    int sIndex = sPrev;
                    if (this.m_gt.isWaterfall()) {
                        double currVal = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue;
                        DatumObj dObj = this.getDataValue(sIndex, g, DataItem.DI_GENERAL);
                        while ((currVal < 0.0 && dObj.m_fValue >= 0.0 || currVal >= 0.0 && dObj.m_fValue < 0.0) && sIndex >= 1) {
                            dObj = this.getDataValue(--sIndex, g, DataItem.DI_GENERAL);
                        }
                    }
                    nBaseCoord = this.m_numYCoords[sIndex][g];
                }
                if (bFromZero) {
                    nLow = bDescending != bNegValue ? nValueCoord : nBaseCoord;
                    nHigh = bDescending != bNegValue ? nBaseCoord : nValueCoord;
                } else {
                    nLow = bDescending ? nValueCoord : nBaseCoord;
                    int n = nHigh = bDescending ? nBaseCoord : nValueCoord;
                }
                if (bDescending && this.m_bNonZeroBaseline) {
                    int temp = nLow;
                    nLow = nHigh;
                    nHigh = temp;
                }
                if (this.m_bHorz) {
                    left = nLow;
                    right = nHigh;
                    bottom = !this.m_gt.isRiserBar() ? this.m_ordCoords[s][g] - this.m_barThickCoord / 2 : this.m_ordCoords[s][g];
                    top = bottom + this.m_barThickCoord;
                } else {
                    bottom = nLow;
                    top = nHigh;
                    left = !this.m_gt.isRiserBar() ? this.m_ordCoords[s][g] - this.m_barThickCoord / 2 : this.m_ordCoords[s][g];
                    right = left + this.m_barThickCoord;
                }
                if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                    boolean bl = bNegNZValue = fBaseline < 0.0;
                    this.m_baseLineYCoord = bNegNZValue ? (fBaseline >= axisObj.getMinValue() ? (int)axisObj.getValueCoord(fBaseline) : (int)axisObj.getValueCoord(axisObj.getBaseMin())) : (fBaseline <= axisObj.getMaxValue() ? (int)axisObj.getValueCoord(fBaseline) : (int)axisObj.getValueCoord(axisObj.getBaseMax()));
                    DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                    boolean bl2 = bNegData = dObj.m_fValue < 0.0;
                }
                if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                    if (this.m_bHorz) {
                        if (!bNegNZValue) {
                            if (bNegData) {
                                if (nHigh <= this.m_baseLineYCoord) {
                                    right = this.m_baseLineYCoord;
                                } else if (nHigh > this.m_baseLineYCoord) {
                                    left = this.m_baseLineYCoord;
                                }
                            } else if (nHigh >= this.m_baseLineYCoord) {
                                left = this.m_baseLineYCoord;
                            } else if (nHigh < this.m_baseLineYCoord) {
                                left = right;
                                right = this.m_baseLineYCoord;
                            }
                        } else if (bNegData) {
                            if (nHigh <= this.m_baseLineYCoord) {
                                right = this.m_baseLineYCoord;
                            } else if (nHigh > this.m_baseLineYCoord) {
                                right = this.m_baseLineYCoord;
                            }
                        } else if (nHigh >= this.m_baseLineYCoord) {
                            left = this.m_baseLineYCoord;
                        } else if (nHigh < this.m_baseLineYCoord) {
                            left = right;
                            right = this.m_baseLineYCoord;
                        }
                    } else if (!bNegNZValue) {
                        if (bNegData) {
                            if (nHigh <= this.m_baseLineYCoord) {
                                top = this.m_baseLineYCoord;
                            } else if (nHigh > this.m_baseLineYCoord) {
                                bottom = this.m_baseLineYCoord;
                            }
                        } else if (nHigh >= this.m_baseLineYCoord) {
                            bottom = this.m_baseLineYCoord;
                        } else if (nHigh < this.m_baseLineYCoord) {
                            bottom = top;
                            top = this.m_baseLineYCoord;
                        }
                    } else if (bNegData) {
                        if (nLow >= this.m_baseLineYCoord) {
                            top = bottom;
                            bottom = this.m_baseLineYCoord;
                        } else if (nLow < this.m_baseLineYCoord) {
                            top = this.m_baseLineYCoord;
                        }
                    } else if (nHigh >= this.m_baseLineYCoord) {
                        bottom = this.m_baseLineYCoord;
                    } else if (nHigh < this.m_baseLineYCoord) {
                        bottom = top;
                        top = this.m_baseLineYCoord;
                    }
                }
                Rectangle rVirt = new Rectangle(left, bottom, right - left, top - bottom);
                int maxCoord = (int)yAxisObj.getValueCoord(yAxisObj.getMaxValue());
                int minCoord = (int)yAxisObj.getValueCoord(yAxisObj.getMinValue());
                if (bDescending) {
                    int temp = minCoord;
                    minCoord = maxCoord;
                    maxCoord = temp;
                }
                if (!this.m_bHorz) {
                    if (rVirt.y >= maxCoord && rVirt.height != 0 && rVirt.y + rVirt.height >= maxCoord || rVirt.y > maxCoord && rVirt.height == 0 || rVirt.y <= minCoord && rVirt.height != 0 && rVirt.y + rVirt.height <= minCoord || rVirt.y < minCoord && rVirt.height == 0) {
                        return;
                    }
                    if (rVirt.y < minCoord) {
                        rVirt.height -= minCoord - rVirt.y;
                        rVirt.y = minCoord;
                    }
                    if (rVirt.y + rVirt.height > maxCoord) {
                        rVirt.height = maxCoord - rVirt.y;
                    }
                } else {
                    if (rVirt.x >= maxCoord && rVirt.width != 0 && rVirt.x + rVirt.width >= maxCoord || rVirt.x > maxCoord && rVirt.width == 0 || rVirt.x <= minCoord && rVirt.width != 0 && rVirt.x + rVirt.width <= minCoord || rVirt.x < minCoord && rVirt.width == 0) {
                        return;
                    }
                    if (rVirt.x < minCoord) {
                        rVirt.width -= minCoord - rVirt.x;
                        rVirt.x = minCoord;
                    }
                    if (rVirt.x + rVirt.width > maxCoord) {
                        rVirt.width = maxCoord - rVirt.x;
                    }
                }
                if (this.wantDepthEffect() && this.m_Frame != null) {
                    if (rVirt.width < 0 || rVirt.height < 0) {
                        return;
                    }
                    VC vc = this.m_Perspective.getVC();
                    if (!this.m_bHorz && (rVirt.height == 0 || vc.virtToDestHeight(rVirt.height) == 0) || this.m_bHorz && (rVirt.width == 0 || vc.virtToDestWidth(rVirt.width) == 0)) {
                        double min = axisObj.getMinValue();
                        double max = axisObj.getMaxValue();
                        double fValue = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue;
                        if (fValue < min || fValue > max) {
                            return;
                        }
                    }
                    if (this.m_autoGradient && !this.m_smallMarker && this.m_Perspective.m_VC.virtToDestHeight(rVirt.height) <= 3) {
                        SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                        this.drawTwoHalfDBarRiser(s, g, rVirt, bb);
                    } else {
                        this.drawTwoHalfDBarRiser(s, g, rVirt, blackBoxNew);
                    }
                } else {
                    IdentObj idFront = new IdentObj(277, s, g);
                    if (bDrawingPictograph) {
                        this.drawBarAsPictograph(yAxisObj, rVirt, idFront, blackBoxNew);
                    } else {
                        int drawType = 0;
                        VC vc = this.m_Perspective.getVC();
                        if (!(this.m_bHorz || rVirt.height != 0 && vc.virtToDestHeight(rVirt.height) != 0)) {
                            double base = 0.0;
                            if (this.m_bAbsolute && this.m_bNonZeroBaseline) {
                                base = fBaseline;
                            }
                            double min = axisObj.getMinValue();
                            double max = axisObj.getMaxValue();
                            double fValue = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue;
                            if (fValue >= min && fValue <= max) {
                                if (fValue < 0.0) {
                                    rVirt.y -= vc.destToVirtHeight(3);
                                    rVirt.height = vc.destToVirtHeight(3);
                                    drawType = 1;
                                } else {
                                    rVirt.height = vc.destToVirtHeight(3);
                                    drawType = 2;
                                }
                            }
                        } else if (this.m_bHorz && (rVirt.width == 0 || vc.virtToDestWidth(rVirt.width) == 0)) {
                            double min = axisObj.getMinValue();
                            double max = axisObj.getMaxValue();
                            double fValue = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue;
                            if (fValue >= min && fValue <= max) {
                                if (fValue < 0.0) {
                                    rVirt.x -= vc.destToVirtWidth(3);
                                    rVirt.width = vc.destToVirtWidth(3);
                                    drawType = 4;
                                } else {
                                    rVirt.width = vc.destToVirtWidth(3);
                                    drawType = 3;
                                }
                            }
                        }
                        if (this.m_autoGradient && !this.m_smallMarker && this.m_Perspective.m_VC.virtToDestHeight(rVirt.height) <= 3) {
                            SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                            boolean bHoriz = this.m_Perspective.getJGraphType().isOrientHorz();
                            int barShape = this.m_Perspective.getBarShape();
                            if (barShape == 0) {
                                new DetRect(this.m_Detectiv, idFront, rVirt, bb, this.m_rClip, drawType);
                            } else if (barShape == 2 || barShape == 3) {
                                IdentObj idFront2 = new IdentObj(312, s, g);
                                Polygon leftRect = null;
                                Polygon rightRect = null;
                                if (!bHoriz) {
                                    leftRect = new Polygon();
                                    leftRect.addPoint(rVirt.x, rVirt.y);
                                    leftRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y);
                                    leftRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y + rVirt.height);
                                    leftRect.addPoint(rVirt.x, rVirt.y + rVirt.height);
                                    leftRect.addPoint(rVirt.x, rVirt.y);
                                    rightRect = new Polygon();
                                    rightRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y);
                                    rightRect.addPoint(rVirt.x + rVirt.width, rVirt.y);
                                    rightRect.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                                    rightRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y + rVirt.height);
                                    rightRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y);
                                } else {
                                    leftRect = new Polygon();
                                    leftRect.addPoint(rVirt.x, rVirt.y);
                                    leftRect.addPoint(rVirt.x + rVirt.width, rVirt.y);
                                    leftRect.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height / 2);
                                    leftRect.addPoint(rVirt.x, rVirt.y + rVirt.height / 2);
                                    leftRect.addPoint(rVirt.x, rVirt.y);
                                    rightRect = new Polygon();
                                    rightRect.addPoint(rVirt.x, rVirt.y + rVirt.height / 2);
                                    rightRect.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height / 2);
                                    rightRect.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                                    rightRect.addPoint(rVirt.x, rVirt.y + rVirt.height);
                                    rightRect.addPoint(rVirt.x, rVirt.y + rVirt.height / 2);
                                }
                                double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                                new DetPolygon(this.m_Detectiv, idFront, leftRect, (BlackBoxIF)bb, fIntensity);
                                fIntensity = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
                                new DetPolygon(this.m_Detectiv, idFront2, rightRect, (BlackBoxIF)bb, fIntensity);
                            } else if (barShape == 1) {
                                this.applyCylinderBarsGradientEffect(bb);
                                new DetRect(this.m_Detectiv, idFront, rVirt, bb, this.m_rClip, drawType);
                            }
                        } else {
                            boolean bHoriz = this.m_Perspective.getJGraphType().isOrientHorz();
                            int barShape = this.m_Perspective.getBarShape();
                            if (barShape == 0) {
                                new DetRect(this.m_Detectiv, idFront, rVirt, blackBoxNew, this.m_rClip, drawType);
                            } else if (barShape == 2 || barShape == 3) {
                                IdentObj idFront2 = new IdentObj(312, s, g);
                                Polygon leftRect = null;
                                Polygon rightRect = null;
                                if (!bHoriz) {
                                    leftRect = new Polygon();
                                    leftRect.addPoint(rVirt.x, rVirt.y);
                                    leftRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y);
                                    leftRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y + rVirt.height);
                                    leftRect.addPoint(rVirt.x, rVirt.y + rVirt.height);
                                    leftRect.addPoint(rVirt.x, rVirt.y);
                                    rightRect = new Polygon();
                                    rightRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y);
                                    rightRect.addPoint(rVirt.x + rVirt.width, rVirt.y);
                                    rightRect.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                                    rightRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y + rVirt.height);
                                    rightRect.addPoint(rVirt.x + rVirt.width / 2, rVirt.y);
                                } else {
                                    leftRect = new Polygon();
                                    leftRect.addPoint(rVirt.x, rVirt.y);
                                    leftRect.addPoint(rVirt.x + rVirt.width, rVirt.y);
                                    leftRect.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height / 2);
                                    leftRect.addPoint(rVirt.x, rVirt.y + rVirt.height / 2);
                                    leftRect.addPoint(rVirt.x, rVirt.y);
                                    rightRect = new Polygon();
                                    rightRect.addPoint(rVirt.x, rVirt.y + rVirt.height / 2);
                                    rightRect.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height / 2);
                                    rightRect.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                                    rightRect.addPoint(rVirt.x, rVirt.y + rVirt.height);
                                    rightRect.addPoint(rVirt.x, rVirt.y + rVirt.height / 2);
                                }
                                SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                                double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                                new DetPolygon(this.m_Detectiv, idFront, leftRect, blackBoxNew, fIntensity);
                                fIntensity = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
                                new DetPolygon(this.m_Detectiv, idFront2, rightRect, (BlackBoxIF)bb, fIntensity);
                            } else if (barShape == 1) {
                                this.applyCylinderBarsGradientEffect(blackBoxNew);
                                new DetRect(this.m_Detectiv, idFront, rVirt, blackBoxNew, this.m_rClip, drawType);
                            }
                        }
                    }
                }
            }
        }
    }

    private void drawTwoHalfDBarRiser(int s, int g, Rectangle rVirt, BlackBoxIF blackBox) {
        Point ptBackOffset = this.m_seriesBackOffsets[s];
        Point ptFrontOffset = this.m_seriesFrontOffsets[s];
        rVirt.x -= ptFrontOffset.x;
        rVirt.y -= ptFrontOffset.y;
        int barShape = this.m_Perspective.getBarShape();
        if (barShape == 0) {
            double fIntensity;
            Polygon polyVC;
            if (this.m_nDepthAngle != 90) {
                int nXFrame = this.m_nDepthAngle > 90 ? rVirt.x : rVirt.x + rVirt.width;
                polyVC = new Polygon();
                polyVC.addPoint(nXFrame, rVirt.y);
                polyVC.addPoint(nXFrame, rVirt.y + rVirt.height);
                polyVC.addPoint(nXFrame + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y));
                polyVC.addPoint(nXFrame + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + (ptFrontOffset.y - ptBackOffset.y));
                polyVC.addPoint(nXFrame, rVirt.y);
                fIntensity = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
                IdentObj idSide = new IdentObj(312, s, g);
                SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                bb.runRules(s, g);
                new DetPolygon(this.m_Detectiv, idSide, polyVC, (BlackBoxIF)bb, fIntensity);
            }
            if (this.m_nDepthAngle != 0 && this.m_nDepthAngle != 180) {
                polyVC = new Polygon();
                polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
                polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                polyVC.addPoint(rVirt.x + rVirt.width + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y));
                polyVC.addPoint(rVirt.x + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y));
                polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
                fIntensity = 0.8;
                IdentObj idSide = new IdentObj(313, s, g);
                SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                bb.runRules(s, g);
                new DetPolygon(this.m_Detectiv, idSide, polyVC, (BlackBoxIF)bb, fIntensity);
            }
            IdentObj idFront = new IdentObj(277, s, g);
            if (this.m_bColorAutoshadeRisers) {
                fIntensity = 1.0;
                polyVC = new Polygon();
                polyVC.addPoint(rVirt.x, rVirt.y);
                polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y);
                polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
                polyVC.addPoint(rVirt.x, rVirt.y);
                new DetPolygon(this.m_Detectiv, idFront, polyVC, blackBox, fIntensity);
            } else {
                new DetRect(this.m_Detectiv, idFront, rVirt, blackBox, null);
            }
        } else if (barShape == 2) {
            boolean bHoriz = this.m_Perspective.getJGraphType().isOrientHorz();
            if (!bHoriz) {
                int nCenterX = rVirt.x + rVirt.width / 2;
                int nLeftX = rVirt.x + (ptFrontOffset.x - ptBackOffset.x);
                int nRightX = rVirt.x + rVirt.width + (ptFrontOffset.x - ptBackOffset.x);
                int nBottomFrontY = rVirt.y;
                int nTopFrontY = nBottomFrontY + rVirt.height;
                int nBottomBackY = rVirt.y + (ptFrontOffset.y - ptBackOffset.y);
                int nTopBackY = nBottomBackY + rVirt.height;
                SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                bb.runRules(s, g);
                Polygon leftPoly = new Polygon();
                leftPoly.addPoint(nLeftX, nBottomBackY);
                leftPoly.addPoint(nCenterX, nBottomFrontY);
                leftPoly.addPoint(nCenterX, nTopFrontY);
                leftPoly.addPoint(nLeftX, nTopBackY);
                leftPoly.addPoint(nLeftX, nBottomBackY);
                double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                IdentObj idSide = new IdentObj(277, s, g);
                new DetPolygon(this.m_Detectiv, idSide, leftPoly, blackBox, fIntensity);
                Polygon rightPoly = new Polygon();
                rightPoly.addPoint(nCenterX, nBottomFrontY);
                rightPoly.addPoint(nRightX, nBottomBackY);
                rightPoly.addPoint(nRightX, nTopBackY);
                rightPoly.addPoint(nCenterX, nTopFrontY);
                rightPoly.addPoint(nCenterX, nBottomFrontY);
                fIntensity = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
                idSide = new IdentObj(312, s, g);
                new DetPolygon(this.m_Detectiv, idSide, rightPoly, (BlackBoxIF)bb, fIntensity);
                if (this.m_nDepthAngle != 0 && this.m_nDepthAngle != 180) {
                    Polygon topPoly = new Polygon();
                    topPoly.addPoint(nCenterX, nTopFrontY);
                    topPoly.addPoint(nRightX, nTopBackY);
                    topPoly.addPoint(nLeftX, nTopBackY);
                    topPoly.addPoint(nCenterX, nTopFrontY);
                    fIntensity = this.m_bColorAutoshadeRisers ? 0.8 : 1.0;
                    IdentObj idTop = new IdentObj(313, s, g);
                    new DetPolygon(this.m_Detectiv, idTop, topPoly, (BlackBoxIF)bb, fIntensity);
                }
            } else {
                int nCenterY = rVirt.y + rVirt.height / 2;
                int nLeftY = rVirt.y + (ptFrontOffset.y - ptBackOffset.y);
                int nRightY = rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y);
                int nBottomFrontX = rVirt.x;
                int nTopFrontX = nBottomFrontX + rVirt.width;
                int nBottomBackX = rVirt.x + (ptFrontOffset.x - ptBackOffset.x);
                int nTopBackX = nBottomBackX + rVirt.width;
                SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                bb.runRules(s, g);
                Polygon leftPoly = new Polygon();
                leftPoly.addPoint(nBottomBackX, nLeftY);
                leftPoly.addPoint(nBottomFrontX, nCenterY);
                leftPoly.addPoint(nTopFrontX, nCenterY);
                leftPoly.addPoint(nTopBackX, nLeftY);
                leftPoly.addPoint(nBottomBackX, nLeftY);
                double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                IdentObj idSide = new IdentObj(277, s, g);
                new DetPolygon(this.m_Detectiv, idSide, leftPoly, blackBox, fIntensity);
                Polygon rightPoly = new Polygon();
                rightPoly.addPoint(nBottomFrontX, nCenterY);
                rightPoly.addPoint(nBottomBackX, nRightY);
                rightPoly.addPoint(nTopBackX, nRightY);
                rightPoly.addPoint(nTopFrontX, nCenterY);
                rightPoly.addPoint(nBottomFrontX, nCenterY);
                fIntensity = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
                idSide = new IdentObj(312, s, g);
                new DetPolygon(this.m_Detectiv, idSide, rightPoly, (BlackBoxIF)bb, fIntensity);
                if (this.m_nDepthAngle < 90) {
                    Polygon topPoly = new Polygon();
                    topPoly.addPoint(nTopFrontX, nCenterY);
                    topPoly.addPoint(nTopBackX, nRightY);
                    topPoly.addPoint(nTopBackX, nLeftY);
                    topPoly.addPoint(nTopFrontX, nCenterY);
                    fIntensity = this.m_bColorAutoshadeRisers ? 0.8 : 1.0;
                    IdentObj idTop = new IdentObj(313, s, g);
                    new DetPolygon(this.m_Detectiv, idTop, topPoly, (BlackBoxIF)bb, fIntensity);
                } else if (this.m_nDepthAngle > 90) {
                    Polygon bottomPoly = new Polygon();
                    bottomPoly.addPoint(nBottomFrontX, nCenterY);
                    bottomPoly.addPoint(nBottomBackX, nRightY);
                    bottomPoly.addPoint(nBottomBackX, nLeftY);
                    bottomPoly.addPoint(nBottomFrontX, nCenterY);
                    fIntensity = this.m_bColorAutoshadeRisers ? 0.8 : 1.0;
                    IdentObj idBottom = new IdentObj(313, s, g);
                    new DetPolygon(this.m_Detectiv, idBottom, bottomPoly, (BlackBoxIF)bb, fIntensity);
                }
            }
        } else if (barShape == 3) {
            boolean bHoriz = this.m_Perspective.getJGraphType().isOrientHorz();
            if (!bHoriz) {
                int nCenterFrontX = rVirt.x + rVirt.width / 2;
                int nCenterBackX = nCenterFrontX + (ptFrontOffset.x - ptBackOffset.x);
                int nLeftX = rVirt.x + (ptFrontOffset.x - ptBackOffset.x) / 2;
                int nRightX = rVirt.x + rVirt.width + (ptFrontOffset.x - ptBackOffset.x) / 2;
                int nBottomFrontY = rVirt.y;
                int nTopFrontY = nBottomFrontY + rVirt.height;
                int nBottomMidY = rVirt.y + (ptFrontOffset.y - ptBackOffset.y) / 2;
                int nTopMidY = nBottomMidY + rVirt.height;
                int nTopBackY = rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y);
                SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                bb.runRules(s, g);
                Polygon leftPoly = new Polygon();
                leftPoly.addPoint(nLeftX, nBottomMidY);
                leftPoly.addPoint(nCenterFrontX, nBottomFrontY);
                leftPoly.addPoint(nCenterFrontX, nTopFrontY);
                leftPoly.addPoint(nLeftX, nTopMidY);
                leftPoly.addPoint(nLeftX, nBottomMidY);
                double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                IdentObj idSide = new IdentObj(277, s, g);
                new DetPolygon(this.m_Detectiv, idSide, leftPoly, blackBox, fIntensity);
                Polygon rightPoly = new Polygon();
                rightPoly.addPoint(nCenterFrontX, nBottomFrontY);
                rightPoly.addPoint(nRightX, nBottomMidY);
                rightPoly.addPoint(nRightX, nTopMidY);
                rightPoly.addPoint(nCenterFrontX, nTopFrontY);
                rightPoly.addPoint(nCenterFrontX, nBottomFrontY);
                fIntensity = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
                idSide = new IdentObj(312, s, g);
                new DetPolygon(this.m_Detectiv, idSide, rightPoly, (BlackBoxIF)bb, fIntensity);
                if (this.m_nDepthAngle != 0 && this.m_nDepthAngle != 180) {
                    Polygon topPoly = new Polygon();
                    topPoly.addPoint(nCenterFrontX, nTopFrontY);
                    topPoly.addPoint(nRightX, nTopMidY);
                    topPoly.addPoint(nCenterBackX, nTopBackY);
                    topPoly.addPoint(nLeftX, nTopMidY);
                    topPoly.addPoint(nCenterFrontX, nTopFrontY);
                    fIntensity = this.m_bColorAutoshadeRisers ? 0.8 : 1.0;
                    IdentObj idTop = new IdentObj(313, s, g);
                    new DetPolygon(this.m_Detectiv, idTop, topPoly, (BlackBoxIF)bb, fIntensity);
                }
            } else {
                int nCenterFrontY = rVirt.y + rVirt.height / 2;
                int nCenterBackY = nCenterFrontY + (ptFrontOffset.y - ptBackOffset.y);
                int nLeftY = rVirt.y + (ptFrontOffset.y - ptBackOffset.y) / 2;
                int nRightY = rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y) / 2;
                int nBottomFrontX = rVirt.x;
                int nTopFrontX = nBottomFrontX + rVirt.width;
                int nBottomMidX = rVirt.x + (ptFrontOffset.x - ptBackOffset.x) / 2;
                int nTopMidX = nBottomMidX + rVirt.width;
                int nBottomBackX = rVirt.x + (ptFrontOffset.x - ptBackOffset.x);
                int nTopBackX = nBottomBackX + rVirt.width;
                SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                bb.runRules(s, g);
                Polygon leftPoly = new Polygon();
                leftPoly.addPoint(nBottomMidX, nLeftY);
                leftPoly.addPoint(nBottomFrontX, nCenterFrontY);
                leftPoly.addPoint(nTopFrontX, nCenterFrontY);
                leftPoly.addPoint(nTopMidX, nLeftY);
                leftPoly.addPoint(nBottomMidX, nLeftY);
                double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                IdentObj idSide = new IdentObj(277, s, g);
                new DetPolygon(this.m_Detectiv, idSide, leftPoly, blackBox, fIntensity);
                Polygon rightPoly = new Polygon();
                rightPoly.addPoint(nBottomFrontX, nCenterFrontY);
                rightPoly.addPoint(nBottomMidX, nRightY);
                rightPoly.addPoint(nTopMidX, nRightY);
                rightPoly.addPoint(nTopFrontX, nCenterFrontY);
                rightPoly.addPoint(nBottomFrontX, nCenterFrontY);
                fIntensity = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
                idSide = new IdentObj(312, s, g);
                new DetPolygon(this.m_Detectiv, idSide, rightPoly, (BlackBoxIF)bb, fIntensity);
                if (this.m_nDepthAngle < 90) {
                    Polygon topPoly = new Polygon();
                    topPoly.addPoint(nTopFrontX, nCenterFrontY);
                    topPoly.addPoint(nTopMidX, nRightY);
                    topPoly.addPoint(nTopBackX, nCenterBackY);
                    topPoly.addPoint(nTopMidX, nLeftY);
                    topPoly.addPoint(nTopFrontX, nCenterFrontY);
                    fIntensity = this.m_bColorAutoshadeRisers ? 0.8 : 1.0;
                    IdentObj idTop = new IdentObj(313, s, g);
                    new DetPolygon(this.m_Detectiv, idTop, topPoly, (BlackBoxIF)bb, fIntensity);
                } else if (this.m_nDepthAngle > 90) {
                    Polygon bottomPoly = new Polygon();
                    bottomPoly.addPoint(nBottomFrontX, nCenterFrontY);
                    bottomPoly.addPoint(nBottomMidX, nRightY);
                    bottomPoly.addPoint(nBottomBackX, nCenterBackY);
                    bottomPoly.addPoint(nBottomMidX, nLeftY);
                    bottomPoly.addPoint(nBottomFrontX, nCenterFrontY);
                    fIntensity = this.m_bColorAutoshadeRisers ? 0.8 : 1.0;
                    IdentObj idBottom = new IdentObj(313, s, g);
                    new DetPolygon(this.m_Detectiv, idBottom, bottomPoly, (BlackBoxIF)bb, fIntensity);
                }
            }
        } else if (barShape == 1) {
            boolean bHoriz = this.m_Perspective.getJGraphType().isOrientHorz();
            if (!bHoriz) {
                SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                bb.runRules(s, g);
                if (this.m_nDepthAngle != 0 && this.m_nDepthAngle != 180) {
                    int nCenterX = rVirt.x + (ptFrontOffset.x - ptBackOffset.x) / 2 + rVirt.width / 2;
                    int nCenterY = rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y) / 2;
                    double fYSquashRatio = (double)(ptFrontOffset.y - ptBackOffset.y) / (double)rVirt.width;
                    Polygon topFrontPoly = this.calcArcPoints(new MinMaxObj(), nCenterX, nCenterY, 0.0, 0.0, 0.5, rVirt.width / 2, 1.0, fYSquashRatio);
                    IdentObj idTop = new IdentObj(313, s, g);
                    int[] topBackXPoints = new int[topFrontPoly.npoints];
                    int[] topBackYPoints = new int[topFrontPoly.npoints];
                    int i = 0;
                    while (i < topBackXPoints.length) {
                        topBackXPoints[topBackXPoints.length - 1 - i] = topFrontPoly.xpoints[i];
                        topBackYPoints[topBackYPoints.length - 1 - i] = nCenterY + (nCenterY - topFrontPoly.ypoints[i]);
                        ++i;
                    }
                    int[] topXPoints = new int[2 * topBackXPoints.length + 1];
                    int[] topYPoints = new int[2 * topBackYPoints.length + 1];
                    int i2 = 0;
                    while (i2 < topXPoints.length - 1) {
                        if (i2 < topFrontPoly.npoints) {
                            topXPoints[i2] = topFrontPoly.xpoints[i2];
                            topYPoints[i2] = topFrontPoly.ypoints[i2];
                        } else {
                            topXPoints[i2] = topBackXPoints[i2 - topBackXPoints.length];
                            topYPoints[i2] = topBackYPoints[i2 - topBackYPoints.length];
                        }
                        ++i2;
                    }
                    topXPoints[topXPoints.length - 1] = topXPoints[0];
                    topYPoints[topYPoints.length - 1] = topYPoints[0];
                    double fIntensity = this.m_bColorAutoshadeRisers ? 0.8 : 1.0;
                    Polygon topPoly = new Polygon(topXPoints, topYPoints, topXPoints.length);
                    new DetPolygon(this.m_Detectiv, idTop, topPoly, (BlackBoxIF)bb, fIntensity);
                    IdentObj idFront = new IdentObj(277, s, g);
                    int[] frontXPoints = new int[2 * topFrontPoly.npoints + 1];
                    int[] frontYPoints = new int[2 * topFrontPoly.npoints + 1];
                    int i3 = 0;
                    while (i3 < frontXPoints.length - 1) {
                        if (i3 < topFrontPoly.npoints) {
                            frontXPoints[i3] = topFrontPoly.xpoints[i3];
                            frontYPoints[i3] = topFrontPoly.ypoints[i3];
                        } else {
                            frontXPoints[i3] = topFrontPoly.xpoints[topFrontPoly.npoints - 1 - (i3 - topFrontPoly.npoints)];
                            frontYPoints[i3] = topFrontPoly.ypoints[topFrontPoly.npoints - 1 - (i3 - topFrontPoly.npoints)] - rVirt.height;
                        }
                        ++i3;
                    }
                    frontXPoints[frontXPoints.length - 1] = frontXPoints[0];
                    frontYPoints[frontYPoints.length - 1] = frontYPoints[0];
                    fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                    Polygon frontPoly = new Polygon(frontXPoints, frontYPoints, frontXPoints.length);
                    this.applyCylinderBarsGradientEffect(blackBox);
                    new DetPolygon(this.m_Detectiv, idFront, frontPoly, blackBox, fIntensity);
                } else {
                    IdentObj idFront = new IdentObj(277, s, g);
                    double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                    Polygon poly = new Polygon();
                    poly.addPoint(rVirt.x, rVirt.y);
                    poly.addPoint(rVirt.x + rVirt.width, rVirt.y);
                    poly.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                    poly.addPoint(rVirt.x, rVirt.y + rVirt.height);
                    poly.addPoint(rVirt.x, rVirt.y);
                    this.applyCylinderBarsGradientEffect(blackBox);
                    new DetPolygon(this.m_Detectiv, idFront, poly, blackBox, fIntensity);
                }
            } else {
                SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                bb.runRules(s, g);
                if (this.m_nDepthAngle != 90) {
                    int nCenterY = rVirt.y + (ptFrontOffset.y - ptBackOffset.y) / 2 + rVirt.height / 2;
                    int nCenterX = rVirt.x + rVirt.width + (ptFrontOffset.x - ptBackOffset.x) / 2;
                    double fXSquashRatio = (double)(ptFrontOffset.x - ptBackOffset.x) / (double)rVirt.height;
                    Polygon topFrontPoly = this.calcArcPoints(new MinMaxObj(), nCenterX, nCenterY, 0.0, 0.25, 0.75, rVirt.height / 2, fXSquashRatio, 1.0);
                    IdentObj idTop = new IdentObj(313, s, g);
                    int[] topBackXPoints = new int[topFrontPoly.npoints];
                    int[] topBackYPoints = new int[topFrontPoly.npoints];
                    int i = 0;
                    while (i < topBackXPoints.length) {
                        topBackYPoints[topBackYPoints.length - 1 - i] = topFrontPoly.ypoints[i];
                        topBackXPoints[topBackXPoints.length - 1 - i] = nCenterX + (nCenterX - topFrontPoly.xpoints[i]);
                        ++i;
                    }
                    int[] topXPoints = new int[2 * topBackXPoints.length + 1];
                    int[] topYPoints = new int[2 * topBackYPoints.length + 1];
                    int i4 = 0;
                    while (i4 < topXPoints.length - 1) {
                        if (i4 < topFrontPoly.npoints) {
                            topXPoints[i4] = topFrontPoly.xpoints[i4];
                            topYPoints[i4] = topFrontPoly.ypoints[i4];
                        } else {
                            topXPoints[i4] = topBackXPoints[i4 - topBackXPoints.length];
                            topYPoints[i4] = topBackYPoints[i4 - topBackYPoints.length];
                        }
                        ++i4;
                    }
                    topXPoints[topXPoints.length - 1] = topXPoints[0];
                    topYPoints[topYPoints.length - 1] = topYPoints[0];
                    double fIntensity = this.m_bColorAutoshadeRisers ? 0.8 : 1.0;
                    if (this.m_nDepthAngle < 90) {
                        Polygon topPoly = new Polygon(topXPoints, topYPoints, topXPoints.length);
                        new DetPolygon(this.m_Detectiv, idTop, topPoly, (BlackBoxIF)bb, fIntensity);
                    } else if (this.m_nDepthAngle > 90) {
                        int[] bottomXPoints = new int[topXPoints.length];
                        int i5 = 0;
                        while (i5 < bottomXPoints.length) {
                            bottomXPoints[i5] = topXPoints[i5] - rVirt.width;
                            ++i5;
                        }
                        Polygon bottomPoly = new Polygon(bottomXPoints, topYPoints, bottomXPoints.length);
                        new DetPolygon(this.m_Detectiv, idTop, bottomPoly, (BlackBoxIF)bb, fIntensity);
                    }
                    IdentObj idFront = new IdentObj(277, s, g);
                    int[] frontXPoints = new int[2 * topFrontPoly.npoints + 1];
                    int[] frontYPoints = new int[2 * topFrontPoly.npoints + 1];
                    int i6 = 0;
                    while (i6 < frontXPoints.length - 1) {
                        if (i6 < topFrontPoly.npoints) {
                            frontXPoints[i6] = topFrontPoly.xpoints[i6];
                            frontYPoints[i6] = topFrontPoly.ypoints[i6];
                        } else {
                            frontYPoints[i6] = topFrontPoly.ypoints[topFrontPoly.npoints - 1 - (i6 - topFrontPoly.npoints)];
                            frontXPoints[i6] = topFrontPoly.xpoints[topFrontPoly.npoints - 1 - (i6 - topFrontPoly.npoints)] - rVirt.width;
                        }
                        ++i6;
                    }
                    frontXPoints[frontXPoints.length - 1] = frontXPoints[0];
                    frontYPoints[frontYPoints.length - 1] = frontYPoints[0];
                    fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                    Polygon frontPoly = new Polygon(frontXPoints, frontYPoints, frontXPoints.length);
                    this.applyCylinderBarsGradientEffect(blackBox);
                    new DetPolygon(this.m_Detectiv, idFront, frontPoly, blackBox, fIntensity);
                } else {
                    IdentObj idFront = new IdentObj(277, s, g);
                    double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                    Polygon poly = new Polygon();
                    poly.addPoint(rVirt.x, rVirt.y);
                    poly.addPoint(rVirt.x + rVirt.width, rVirt.y);
                    poly.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                    poly.addPoint(rVirt.x, rVirt.y + rVirt.height);
                    poly.addPoint(rVirt.x, rVirt.y);
                    this.applyCylinderBarsGradientEffect(blackBox);
                    new DetPolygon(this.m_Detectiv, idFront, poly, blackBox, fIntensity);
                }
            }
        }
    }

    protected Polygon calcArcPoints(MinMaxObj m_minmax_y, int nCenterX, int nCenterY, double f12OClock, double fStart, double fEnd, double fRadius, double fXSquashRatio, double fYSquashRatio) {
        int nPosY;
        int nPosX;
        double fAngle;
        Polygon polygon = new Polygon();
        double fArcLength = fEnd - fStart;
        double fNumPixelsInArc = this.getNumPixelsInArc(this.m_Perspective.getVC(), nCenterX, nCenterY, f12OClock, fStart, fEnd, fRadius, fXSquashRatio, fYSquashRatio);
        double fNumPixelsPerArcSegment = 6.0;
        if (fNumPixelsInArc <= 30.0) {
            fNumPixelsPerArcSegment = 2.0;
        } else if (fNumPixelsInArc <= 40.0) {
            fNumPixelsPerArcSegment = 3.0;
        } else if (fNumPixelsInArc <= 50.0) {
            fNumPixelsPerArcSegment = 4.0;
        } else if (fNumPixelsInArc <= 60.0) {
            fNumPixelsPerArcSegment = 5.0;
        }
        double fSegmentArcInc = fNumPixelsPerArcSegment / fNumPixelsInArc * fArcLength;
        double fPos = fStart;
        while (fPos < fEnd) {
            fAngle = f12OClock + fPos * (Math.PI * 2);
            nPosX = nCenterX + (int)Math.rint(Math.cos(fAngle) * fXSquashRatio * fRadius);
            nPosY = nCenterY - (int)(Math.sin(fAngle) * fYSquashRatio * fRadius);
            polygon.addPoint(nPosX, nPosY);
            m_minmax_y.testRawValue(nPosY);
            fPos += fSegmentArcInc;
        }
        fAngle = f12OClock + fEnd * (Math.PI * 2);
        nPosX = nCenterX + (int)(Math.cos(fAngle) * fXSquashRatio * fRadius);
        nPosY = nCenterY - (int)(Math.sin(fAngle) * fYSquashRatio * fRadius);
        polygon.addPoint(nPosX, nPosY);
        m_minmax_y.testRawValue(nPosY);
        return polygon;
    }

    protected void applyCylinderBarsGradientEffect(BlackBoxIF bb) {
        JGraphType gt = this.m_Perspective.getJGraphType();
        IdentObj identObj = bb.getIdentObj();
        int direction = 1;
        if (gt.isOrientHorz()) {
            direction = 4;
        }
        Color c = this.m_Perspective.getFillColor(identObj);
        Color darkerColor = this.m_Perspective.getDarker(c);
        Color brighterColor = this.m_Perspective.getBrighter(c);
        FillGradientObj fillGradient = new FillGradientObj(this.m_Perspective, direction);
        double midPinPos = 0.5;
        if (this.wantDepthEffect()) {
            midPinPos = 0.3 + 0.4 * ((double)this.m_Perspective.getDepthAngle() / 180.0);
        }
        fillGradient.insertPin(0.0, new ColorObj(darkerColor), new ColorObj(darkerColor));
        fillGradient.insertPin(midPinPos, new ColorObj(brighterColor), new ColorObj(brighterColor));
        fillGradient.insertPin(1.0, new ColorObj(darkerColor), new ColorObj(darkerColor));
        bb.setFillGradientObj(fillGradient);
    }

    private void drawOneLineRiser(int s, int g, GroupsEnumerator gEnum) {
        boolean bDrawSidePolygon;
        boolean bShowLeftSide;
        Polygon polyTop;
        int y3;
        int x3;
        int y2;
        int x2;
        boolean bDrawUnderside;
        double newx;
        int dy;
        int dx;
        Point ptFrontOffset;
        boolean bNegValue;
        double fIntensity = 1.0;
        int nValueCoord = this.m_numYCoords[s][g];
        int gFirst = gEnum.getFirstGroup();
        int gLast = gEnum.getLastGroup();
        int gPrev = gEnum.peekAtGroupBefore(g);
        int gNext = gEnum.peekAtGroupAfter(g);
        int gAfterNext = gEnum.peekAtGroupAfter(gNext);
        int gBeforePrev = gEnum.peekAtGroupBefore(gPrev);
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bForwardGroups = gFirst <= gLast;
        boolean bAutoMax = false;
        boolean bAutoMin = false;
        PfjAssert.pfjAssert(gFirst >= 0 && gLast >= 0 && g >= 0 && g < this.m_nTotalGroups);
        if (bForwardGroups) {
            if (gNext == -1) {
                return;
            }
            if (this.m_Perspective.isTimeAxis() && this.m_Perspective.getDateFrequency() == 3 && this.m_dataOK[s][g] && !this.m_dataOK[s][gNext]) {
                while (gEnum.hasMoreElements() && !this.m_dataOK[s][gNext]) {
                    int next = gEnum.nextGroup();
                    gNext = gEnum.peekAtGroupAfter(next);
                    gPrev = gEnum.peekAtGroupBefore(next);
                    gAfterNext = gEnum.peekAtGroupAfter(next);
                    gBeforePrev = gEnum.peekAtGroupBefore(next);
                }
            }
            if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gNext]) {
                return;
            }
        } else {
            if (gPrev == -1) {
                return;
            }
            if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gPrev]) {
                return;
            }
        }
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D lines without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D lines without m_Frame");
        }
        Rectangle rFrame = this.m_Frame.getBackWallBounds();
        if (rFrame == null) {
            throw new AssertionException("Can't draw 2.5D lines when m_Frame has no bounding rect");
        }
        double fThickMax = this.m_bHorz ? (double)rFrame.width / 12.0 : (double)rFrame.height / 12.0;
        int nOffset = (int)(fThickMax * (double)this.m_nLineThick / 100.0);
        RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, null);
        int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
        boolean bDescending = yAxisObj.isDescending();
        BlackBoxIF blackBox = this.assignSeriesColor(s, g);
        blackBox.runRules(s, -3);
        BlackBoxIF blackBoxNew = this.getMissingDataBlackBox(s, g);
        if (blackBoxNew == null) {
            blackBoxNew = blackBox;
        }
        boolean bl = bDescending ? nValueCoord > nZeroCoord : (bNegValue = nValueCoord < nZeroCoord);
        if (this.wantDepthEffect()) {
            Point ptBackOffset = this.m_seriesBackOffsets[s];
            ptFrontOffset = this.m_seriesFrontOffsets[s];
            dx = ptFrontOffset.x - ptBackOffset.x;
            dy = ptFrontOffset.y - ptBackOffset.y;
        } else {
            ptFrontOffset = new Point();
            dx = 0;
            dy = 0;
        }
        Polygon polyFront = new Polygon();
        Point p0 = this.getCoords(s, g);
        Point p1 = bForwardGroups ? this.getCoords(s, gNext) : this.getCoords(s, gPrev);
        IdentObj AxisId = yAxisObj.getAxisIdentObj();
        bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
        bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
        double max = yAxisObj.getMaxValue();
        double min = yAxisObj.getMinValue();
        int maxCoord = (int)yAxisObj.getValueCoord(max);
        int minCoord = (int)yAxisObj.getValueCoord(min);
        if (bDescending) {
            int temp = minCoord;
            minCoord = maxCoord;
            maxCoord = temp;
            boolean temp1 = bAutoMin;
            bAutoMin = bAutoMax;
            bAutoMax = temp1;
        }
        if (!bAutoMax) {
            if (this.m_numYCoords[s][g] > maxCoord && this.m_numYCoords[s][gNext] > maxCoord) {
                return;
            }
            if (this.m_numYCoords[s][g] > maxCoord) {
                if (this.m_bHorz) {
                    double newy = this.calcyPosition(p0, p1, maxCoord);
                    p0.x = maxCoord;
                    p0.y = (int)newy;
                } else {
                    newx = this.calcxPosition(p0, p1, maxCoord);
                    p0.y = maxCoord;
                    p0.x = (int)newx;
                }
            } else if (this.m_numYCoords[s][gNext] > maxCoord) {
                if (this.m_bHorz) {
                    double newy = this.calcyPosition(p0, p1, maxCoord);
                    p1.x = maxCoord;
                    p1.y = (int)newy;
                } else {
                    newx = this.calcxPosition(p0, p1, maxCoord);
                    p1.y = maxCoord;
                    p1.x = (int)newx;
                }
            }
        }
        if (!bAutoMin) {
            if (this.m_numYCoords[s][g] < minCoord && this.m_numYCoords[s][gNext] < minCoord) {
                return;
            }
            if (this.m_numYCoords[s][g] < minCoord) {
                if (this.m_bHorz) {
                    double newy = this.calcyPosition(p0, p1, minCoord);
                    p0.x = minCoord;
                    p0.y = (int)newy;
                } else {
                    newx = this.calcxPosition(p0, p1, minCoord);
                    p0.y = minCoord;
                    p0.x = (int)newx;
                }
            } else if (this.m_numYCoords[s][gNext] < minCoord) {
                if (this.m_bHorz) {
                    double newy = this.calcyPosition(p0, p1, minCoord);
                    p1.x = minCoord;
                    p1.y = (int)newy;
                } else {
                    newx = this.calcxPosition(p0, p1, minCoord);
                    p1.y = minCoord;
                    p1.x = (int)newx;
                }
            }
        }
        int x0 = p0.x - ptFrontOffset.x;
        int y0 = p0.y - ptFrontOffset.y;
        int x1 = p1.x - ptFrontOffset.x;
        int y1 = p1.y - ptFrontOffset.y;
        if (this.m_bHorz) {
            x0 += nOffset / 2;
            x1 += nOffset / 2;
        } else {
            y0 += nOffset / 2;
            y1 += nOffset / 2;
        }
        polyFront.addPoint(x0, y0);
        polyFront.addPoint(x1, y1);
        double fAngleRad = Math.atan2(y1 - y0, x1 - x0);
        double fAngleDeg = fAngleRad * 57.29577951308232;
        if (this.m_nDepthAngle <= 90) {
            bDrawUnderside = this.m_bHorz ? fAngleDeg < (double)(this.m_nDepthAngle - 180) : fAngleDeg > (double)this.m_nDepthAngle;
        } else {
            boolean bl2 = bDrawUnderside = fAngleDeg + 180.0 < (double)this.m_nDepthAngle;
        }
        if (this.m_bHorz) {
            x2 = x1 - nOffset;
            y2 = y1;
            x3 = x0 - nOffset;
            y3 = y0;
        } else {
            x2 = x1;
            y2 = y1 - nOffset;
            x3 = x0;
            y3 = y0 - nOffset;
        }
        polyFront.addPoint(x2, y2);
        polyFront.addPoint(x3, y3);
        polyFront.addPoint(x0, y0);
        if (bDrawUnderside) {
            polyTop = new Polygon();
            polyTop.addPoint(x2, y2);
            polyTop.addPoint(x3, y3);
            polyTop.addPoint(x3 + dx, y3 + dy);
            polyTop.addPoint(x2 + dx, y2 + dy);
            polyTop.addPoint(x2, y2);
        } else {
            polyTop = new Polygon();
            polyTop.addPoint(x0, y0);
            polyTop.addPoint(x1, y1);
            polyTop.addPoint(x1 + dx, y1 + dy);
            polyTop.addPoint(x0 + dx, y0 + dy);
            polyTop.addPoint(x0, y0);
        }
        if (this.m_bColorAutoshadeRisers) {
            fIntensity = this.m_bHorz ? 0.6 : (bDrawUnderside ? 0.4 : 0.8);
        }
        new DetPolygon(this.m_Detectiv, new IdentObj(318, s, g), polyTop, blackBoxNew, fIntensity);
        if (this.m_bColorAutoshadeRisers) {
            fIntensity = 1.0;
        }
        new DetPolygon(this.m_Detectiv, new IdentObj(258, s, g), polyFront, blackBoxNew, fIntensity);
        boolean bl3 = bShowLeftSide = bRightToLeft || this.m_bHorz;
        if (bForwardGroups) {
            bDrawSidePolygon = bShowLeftSide ? g == gFirst || gPrev != -1 && !this.m_dataOK[s][gPrev] : gNext == gLast || gAfterNext != -1 && !this.m_dataOK[s][gAfterNext];
        } else if (bShowLeftSide) {
            bDrawSidePolygon = g == gLast || gNext != -1 && !this.m_dataOK[s][gNext];
        } else {
            boolean bl4 = bDrawSidePolygon = gPrev == gFirst || gBeforePrev != -1 && !this.m_dataOK[s][gBeforePrev];
        }
        if (bDrawSidePolygon) {
            Polygon polySide = new Polygon();
            if (bShowLeftSide) {
                polySide.addPoint(x0, y0);
                polySide.addPoint(x3, y3);
                polySide.addPoint(x3 + dx, y3 + dy);
                polySide.addPoint(x0 + dx, y0 + dy);
                polySide.addPoint(x0, y0);
            } else {
                polySide.addPoint(x1, y1);
                polySide.addPoint(x2, y2);
                polySide.addPoint(x2 + dx, y2 + dy);
                polySide.addPoint(x1 + dx, y1 + dy);
                polySide.addPoint(x1, y1);
            }
            if (this.m_bColorAutoshadeRisers) {
                fIntensity = this.m_bHorz ? 0.8 : 0.6;
            }
            new DetPolygon(this.m_Detectiv, new IdentObj(317, s, g), polySide, blackBoxNew, fIntensity);
        }
    }

    protected void drawWaterfallLines() {
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        int sLast = sEnum.getLastSeries();
        IdentObj id = this.m_Perspective.getWaterfallLine();
        BlackBoxObj bb = new BlackBoxObj(this.m_Perspective, id);
        int nLineWidth = this.m_Perspective.getLineWidth(id);
        int nLineStyle = this.m_Perspective.getLineStyle(id);
        while (gEnum.hasMoreElements()) {
            int x2;
            int x1;
            int y2;
            int y1;
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            int gPrev = gEnum.peekAtGroupBefore(g);
            if (gPrev == -1) continue;
            if (this.m_bHorz) {
                y1 = this.m_ordCoords[sLast][gPrev] + this.m_barThickCoord;
                y2 = this.m_ordCoords[sLast][g];
                x2 = x1 = this.m_numYCoords[sLast][gPrev];
            } else {
                x1 = this.m_ordCoords[sLast][gPrev];
                x2 = this.m_ordCoords[sLast][g] + this.m_barThickCoord;
                y2 = y1 = this.m_numYCoords[sLast][gPrev];
            }
            new DetLine(this.m_Detectiv, id, x1, y1, x2, y2, (BlackBoxIF)bb, null, nLineWidth, nLineStyle);
        }
    }

    protected Point getCoords(int s, int g) {
        int nCenterOrd = !this.m_bIsThisAComboWithBar && this.m_bExtendToFrameEdge ? this.m_ordCoords[s][g] : (this.m_gt.isRiserBar() ? this.m_ordCoords[s][g] + this.m_barThickCoord / 2 : this.m_ordCoords[s][g]);
        Point ptCenter = this.m_bHorz ? new Point(this.m_numYCoords[s][g], nCenterOrd) : new Point(nCenterOrd, this.m_numYCoords[s][g]);
        return ptCenter;
    }

    protected Point getVCPositionsXY(int s, double x, double y) throws AssertionException {
        int maxValue;
        SeriesEnumerator sEnum = this.m_sEnumForward;
        int sFirst = sEnum.getFirstSeries();
        Axis2DObj xAxis = (Axis2DObj)this.m_O1Axis;
        Axis2DObj yAxis = (Axis2DObj)this.whichAxisForSeries(s, null);
        int xCoordLow = (int)xAxis.getLowCoord((double)(s - sFirst), x);
        int yCoord = (int)yAxis.getValueCoord(y);
        if (yCoord > (maxValue = (int)yAxis.getValueCoord(yAxis.getMaxValue()))) {
            return null;
        }
        int graphType = this.m_Perspective.getGraphType();
        int xCoordMin = (int)xAxis.getLowCoord(s - sFirst, 0);
        if (xCoordMin < xAxis.m_axisOrgVC) {
            xCoordLow += this.m_barThickCoord;
        }
        int xCoord = graphType >= 41 && graphType <= 47 || graphType >= 31 && graphType <= 35 ? xCoordLow : xCoordLow + this.m_barThickCoord / 2;
        if (this.wantDepthEffect()) {
            Point frontOffset = this.m_seriesFrontOffsets[s];
            xCoord -= frontOffset.x;
            yCoord -= frontOffset.y;
        }
        if (this.m_bHorz) {
            return new Point(yCoord, xCoord);
        }
        return new Point(xCoord, yCoord);
    }

    public boolean isBottomStackedArea(int s) {
        return this.isVisibleStackedArea(s, false);
    }

    public boolean isTopStackedArea(int s) {
        return this.isVisibleStackedArea(s, true);
    }

    public boolean isVisibleStackedArea(int sCurrent, boolean bTopFace) {
        int s;
        int axisCurrent = this.getAxisAssignment(sCurrent);
        boolean bForward = bTopFace ^ true;
        boolean bIsTop = true;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForward);
        while (bIsTop && sEnum.hasMoreElements()) {
            boolean bDone;
            s = sEnum.nextSeries();
            boolean bl = bForward ? s >= sCurrent : (bDone = s <= sCurrent);
            if (bDone) break;
            if (this.m_seriesTypes[s] != 3 || this.getAxisAssignment(s) != axisCurrent) continue;
            bIsTop = false;
        }
        if (!bForward && !bIsTop && sEnum.hasMoreElements() && this.m_seriesTypes[s = sEnum.nextSeries()] == 3 && this.m_Perspective.getFillColor(this.m_Perspective.getSeries(s)).getAlpha() > 0) {
            bIsTop = true;
        }
        return bIsTop;
    }

    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        String ResultString = dataTextTemplate;
        return ResultString;
    }

    protected boolean wantDepthEffect() {
        return this.m_nDepthRadius > 0 && this.m_gt.wantDepthEffect();
    }

    protected boolean wantRisersFromZero(RelativeAxisObj yAxisObj) {
        boolean bFromZero = this.m_bFromZero;
        if (!bFromZero) {
            bFromZero = yAxisObj.hasNegData() && !this.m_bAbsolute && !yAxisObj.isLogScale();
        }
        return bFromZero;
    }

    protected void drawAreaRiserFromVector(Vector allVectPoints, RelativeAxisObj yAxisObj, int nZeroCoord, int baseCoord) {
        BlackBoxIF blackBox = null;
        Object pt1 = null;
        Object pt2 = null;
        Object ld = null;
        Object ld2 = null;
        Object first = null;
        int s = 0;
        int g = 0;
        int allVSize = allVectPoints.size();
        VC vc = this.m_Perspective.getVC();
        int j = 0;
        while (j < allVSize) {
            Vector seriesVect = (Vector)allVectPoints.elementAt(j);
            Polygon polygon = new Polygon();
            boolean bAreaRendered = false;
            int startIndex = -1;
            int endIndex = -1;
            int prevX = -1;
            int prevY = -1;
            double fXValue = 0.0;
            double fYValue = 0.0;
            Point cStartPoint = null;
            boolean done = false;
            while (!done) {
                int y;
                startIndex = this.getStartGroupInSeriesVect(seriesVect, startIndex + 1);
                endIndex = this.getEndGroupInSeriesVect(seriesVect, startIndex + 1);
                if (startIndex == -1) {
                    if (endIndex == -1 || bAreaRendered) break;
                    double min = this.getO1Axis().getMinValue();
                    double max = this.getO1Axis().getMaxValue();
                    polygon = new Polygon();
                    PointInfo info = (PointInfo)seriesVect.elementAt(0);
                    s = info.series;
                    RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                    IdentObj AxisId = axisObj.getAxisIdentObj();
                    boolean bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
                    boolean bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
                    int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
                    int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
                    y = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord);
                    int leftGroup = -1;
                    int rightGroup = -1;
                    int i = 1;
                    while (i < this.m_nTotalGroups) {
                        double value = this.getDataValue((int)s, (int)i, (DataItem)DataItem.DI_XY_X).m_fValue;
                        if (value < min) {
                            leftGroup = i;
                        } else if (value > max) {
                            rightGroup = i;
                            break;
                        }
                        ++i;
                    }
                    if (rightGroup - leftGroup < 1) continue;
                    DatumObj obj = this.getDataValue(s, leftGroup, DataItem.DI_XY_X);
                    fXValue = obj.m_fValue;
                    obj = this.getDataValue(s, leftGroup, DataItem.DI_XY_Y);
                    fYValue = obj.m_fValue;
                    DatumObj obj3 = this.getDataValue(s, rightGroup, DataItem.DI_XY_X);
                    double fXValue3 = obj3.m_fValue;
                    obj3 = this.getDataValue(s, rightGroup, DataItem.DI_XY_Y);
                    double fYValue3 = obj3.m_fValue;
                    if (rightGroup - leftGroup == 1) {
                        if (obj.m_bOK && obj3.m_bOK) {
                            double x1 = this.getO1Axis().getValueCoord(fXValue);
                            RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                            double y1 = yAxis.getValueCoord(fYValue);
                            Point leftPoint = new Point((int)x1, (int)y1);
                            double x3 = this.getO1Axis().getValueCoord(fXValue3);
                            double y3 = yAxis.getValueCoord(fYValue3);
                            Point rightPoint = new Point((int)x3, (int)y3);
                            double minXCoord = this.getO1Axis().getValueCoord(min);
                            double yCoord1 = this.calcyPosition(leftPoint, rightPoint, minXCoord);
                            double maxXCoord = this.getO1Axis().getValueCoord(max);
                            double yCoord3 = this.calcyPosition(leftPoint, rightPoint, maxXCoord);
                            if (!bAutoMin && yCoord1 < (double)minCoord) {
                                yCoord1 = minCoord;
                            }
                            if (!bAutoMin && yCoord3 < (double)minCoord) {
                                yCoord3 = minCoord;
                            }
                            if (!bAutoMax && yCoord1 > (double)maxCoord) {
                                yCoord1 = maxCoord;
                            }
                            if (!bAutoMax && yCoord3 > (double)maxCoord) {
                                yCoord3 = maxCoord;
                            }
                            polygon.addPoint((int)minXCoord, (int)yCoord1);
                            polygon.addPoint((int)maxXCoord, (int)yCoord3);
                            polygon.addPoint((int)maxXCoord, y);
                            polygon.addPoint((int)minXCoord, y);
                            polygon.addPoint((int)minXCoord, (int)yCoord1);
                        }
                    } else if (rightGroup - leftGroup == 2) {
                        DatumObj obj2 = this.getDataValue(s, leftGroup + 1, DataItem.DI_XY_X);
                        double fXValue2 = obj2.m_fValue;
                        obj2 = this.getDataValue(s, leftGroup + 1, DataItem.DI_XY_Y);
                        double fYValue2 = obj2.m_fValue;
                        if (obj.m_bOK && obj2.m_bOK && obj3.m_bOK) {
                            double x1 = this.getO1Axis().getValueCoord(fXValue);
                            RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                            double y1 = yAxis.getValueCoord(fYValue);
                            Point leftPoint = new Point((int)x1, (int)y1);
                            double x2 = this.getO1Axis().getValueCoord(fXValue2);
                            double y2 = yAxis.getValueCoord(fYValue2);
                            Point midPoint = new Point((int)x2, (int)y2);
                            double x3 = this.getO1Axis().getValueCoord(fXValue3);
                            double y3 = yAxis.getValueCoord(fYValue3);
                            Point rightPoint = new Point((int)x3, (int)y3);
                            double minXCoord = this.getO1Axis().getValueCoord(min);
                            double yCoord1 = this.calcyPosition(leftPoint, midPoint, minXCoord);
                            double maxXCoord = this.getO1Axis().getValueCoord(max);
                            double yCoord3 = this.calcyPosition(midPoint, rightPoint, maxXCoord);
                            if (!bAutoMin && yCoord1 < (double)minCoord) {
                                yCoord1 = minCoord;
                            }
                            if (!bAutoMin && y2 < (double)minCoord) {
                                y2 = minCoord;
                            }
                            if (!bAutoMin && yCoord3 < (double)minCoord) {
                                yCoord3 = minCoord;
                            }
                            if (!bAutoMax && yCoord1 > (double)maxCoord) {
                                yCoord1 = maxCoord;
                            }
                            if (!bAutoMax && y2 > (double)maxCoord) {
                                y2 = maxCoord;
                            }
                            if (!bAutoMax && yCoord3 > (double)maxCoord) {
                                yCoord3 = maxCoord;
                            }
                            polygon.addPoint((int)minXCoord, (int)yCoord1);
                            polygon.addPoint((int)x2, (int)y2);
                            polygon.addPoint((int)maxXCoord, (int)yCoord3);
                            polygon.addPoint((int)maxXCoord, y);
                            polygon.addPoint((int)minXCoord, y);
                            polygon.addPoint((int)minXCoord, (int)yCoord1);
                        }
                    }
                    blackBox = this.assignSeriesColor(s, g);
                    blackBox.runRules(s, g);
                    new DetPolygon(this.m_Detectiv, new IdentObj(256, s), polygon, blackBox, this.m_rClip);
                    break;
                }
                if (endIndex - startIndex > 0) {
                    int k = startIndex;
                    while (k <= endIndex) {
                        PointInfo info = (PointInfo)seriesVect.elementAt(k);
                        s = info.series;
                        g = info.group;
                        if (k == startIndex && this.m_Perspective.isContinuousTimeAxis() && g > 0 && this.m_dataOK[s][g]) {
                            DatumObj obj = this.getDataValue(s, g - 1, DataItem.DI_XY_X);
                            fXValue = obj.m_fValue;
                            obj = this.getDataValue(s, g - 1, DataItem.DI_XY_Y);
                            fYValue = obj.m_fValue;
                            double x1 = 0.0;
                            double y1 = 0.0;
                            if (obj.m_bOK) {
                                RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                                IdentObj AxisId = axisObj.getAxisIdentObj();
                                boolean bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
                                boolean bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
                                int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
                                int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
                                x1 = this.getO1Axis().getValueCoord(fXValue);
                                RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                                y1 = yAxis.getValueCoord(fYValue);
                                Point pt3 = new Point(info.lt.x, info.lt.y);
                                double min = this.getO1Axis().getMinValue();
                                double minXCoord = this.getO1Axis().getValueCoord(min);
                                double yCoord = this.calcyPosition(new Point((int)x1, (int)y1), pt3, minXCoord);
                                if (!bAutoMin && yCoord < (double)minCoord) {
                                    yCoord = minCoord;
                                }
                                if (!bAutoMax && yCoord > (double)maxCoord) {
                                    yCoord = maxCoord;
                                }
                                polygon.addPoint((int)minXCoord, (int)yCoord);
                                cStartPoint = new Point((int)minXCoord, (int)yCoord);
                            }
                        }
                        int destX = this.m_Perspective.m_VC.virtToDestX(info.lt.x);
                        int destY = this.m_Perspective.m_VC.virtToDestY(info.lt.y);
                        if (destX != prevX || destY != prevY) {
                            polygon.addPoint(info.lt.x, info.lt.y);
                            prevX = destX;
                            prevY = destY;
                        }
                        if (!info.lt.equals(info.rt)) {
                            polygon.addPoint(info.rt.x, info.rt.y);
                        }
                        if (k == endIndex) {
                            int x;
                            PointInfo startInfo = (PointInfo)seriesVect.elementAt(startIndex);
                            if (this.m_bAbsolute || j == allVSize - 1) {
                                PointInfo endInfo = (PointInfo)seriesVect.elementAt(endIndex);
                                if (this.m_bHorz) {
                                    x = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord);
                                    polygon.addPoint(x, endInfo.rt.y);
                                    polygon.addPoint(x, startInfo.lt.y);
                                } else {
                                    y = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord);
                                    if (this.m_Perspective.isContinuousTimeAxis() && g < this.m_nTotalGroups - 1 && this.m_dataOK[s][g]) {
                                        DatumObj obj = this.getDataValue(s, g + 1, DataItem.DI_XY_X);
                                        fXValue = obj.m_fValue;
                                        obj = this.getDataValue(s, g + 1, DataItem.DI_XY_Y);
                                        fYValue = obj.m_fValue;
                                        double x1 = 0.0;
                                        double y1 = 0.0;
                                        if (obj.m_bOK) {
                                            RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                                            IdentObj AxisId = axisObj.getAxisIdentObj();
                                            boolean bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
                                            boolean bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
                                            int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
                                            int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
                                            x1 = this.getO1Axis().getValueCoord(fXValue);
                                            RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                                            y1 = yAxis.getValueCoord(fYValue);
                                            Point pt4 = new Point(endInfo.rt.x, endInfo.rt.y);
                                            double max = this.getO1Axis().getMaxValue();
                                            double maxXCoord = this.getO1Axis().getValueCoord(max);
                                            double yCoord = this.calcyPosition(new Point((int)x1, (int)y1), pt4, maxXCoord);
                                            if (!bAutoMin && yCoord < (double)minCoord) {
                                                yCoord = minCoord;
                                            }
                                            if (!bAutoMax && yCoord > (double)maxCoord) {
                                                yCoord = maxCoord;
                                            }
                                            polygon.addPoint((int)maxXCoord, (int)yCoord);
                                            polygon.addPoint((int)maxXCoord, y);
                                        } else {
                                            polygon.addPoint(endInfo.rt.x, y);
                                        }
                                    } else {
                                        polygon.addPoint(endInfo.rt.x, y);
                                    }
                                    if (cStartPoint != null) {
                                        polygon.addPoint(cStartPoint.x, y);
                                    } else {
                                        polygon.addPoint(startInfo.lt.x, y);
                                    }
                                }
                                if (cStartPoint != null) {
                                    polygon.addPoint(cStartPoint.x, cStartPoint.y);
                                } else {
                                    polygon.addPoint(startInfo.lt.x, startInfo.lt.y);
                                }
                                blackBox = this.assignSeriesColor(s, g);
                                blackBox.runRules(s, g);
                                ArrayList<Integer> groups = new ArrayList<Integer>();
                                int i = startIndex;
                                while (i <= endIndex) {
                                    groups.add(i);
                                    ++i;
                                }
                                new DetPolygon(this.m_Detectiv, new IdentObj(256, s, g), polygon, blackBox, this.m_rClip, groups);
                                bAreaRendered = true;
                                polygon = new Polygon();
                            } else {
                                Vector seriesBelow = null;
                                int lastx = ((PointInfo)seriesVect.elementAt((int)endIndex)).rt.x;
                                int firstx = ((PointInfo)seriesVect.elementAt((int)startIndex)).lt.x;
                                int lasty = ((PointInfo)seriesVect.elementAt((int)endIndex)).rt.y;
                                int firsty = ((PointInfo)seriesVect.elementAt((int)startIndex)).lt.y;
                                boolean found = false;
                                int i = j + 1;
                                while (i < allVSize) {
                                    seriesBelow = (Vector)allVectPoints.elementAt(i);
                                    int m = 0;
                                    while (m < seriesBelow.size()) {
                                        if (((PointInfo)seriesBelow.elementAt(m)).getStatus() == 1) {
                                            found = true;
                                            break;
                                        }
                                        ++m;
                                    }
                                    if (found) break;
                                    ++i;
                                }
                                if (!found) {
                                    if (this.m_bHorz) {
                                        x = this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord;
                                        polygon.addPoint(x, lasty);
                                        polygon.addPoint(x, firsty);
                                    } else {
                                        y = this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord;
                                        polygon.addPoint(lastx, y);
                                        polygon.addPoint(firstx, y);
                                    }
                                } else {
                                    int eindex = -1;
                                    int sindex = -1;
                                    int n = seriesBelow.size() - 1;
                                    while (n >= 0) {
                                        PointInfo belowInfo = (PointInfo)seriesBelow.elementAt(n);
                                        if (belowInfo.status == 0) {
                                            eindex = -1;
                                            sindex = -1;
                                            break;
                                        }
                                        if (belowInfo.rt.x == lastx) {
                                            eindex = n;
                                        }
                                        if (belowInfo.lt.x == firstx) {
                                            sindex = n;
                                        }
                                        --n;
                                    }
                                    if (eindex == -1 || sindex == -1) {
                                        if (this.m_bHorz) {
                                            x = this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord;
                                            polygon.addPoint(x, lasty);
                                            polygon.addPoint(x, firsty);
                                        } else {
                                            y = this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord;
                                            polygon.addPoint(lastx, y);
                                            polygon.addPoint(firstx, y);
                                        }
                                    } else {
                                        int i2 = eindex;
                                        while (i2 >= sindex) {
                                            PointInfo prevInfo = (PointInfo)seriesBelow.elementAt(i2);
                                            polygon.addPoint(prevInfo.rt.x, prevInfo.rt.y);
                                            if (!prevInfo.lt.equals(prevInfo.rt)) {
                                                polygon.addPoint(prevInfo.lt.x, prevInfo.lt.y);
                                            }
                                            --i2;
                                        }
                                    }
                                }
                                polygon.addPoint(startInfo.lt.x, startInfo.lt.y);
                                blackBox = this.assignSeriesColor(s, g);
                                blackBox.runRules(s, g);
                                new DetPolygon(this.m_Detectiv, new IdentObj(256, s), polygon, blackBox, this.m_rClip);
                                bAreaRendered = true;
                                polygon = new Polygon();
                            }
                        }
                        ++k;
                    }
                }
                startIndex = endIndex;
            }
            ++j;
        }
    }

    protected void drawAreaRiserFromVector25D(Vector allVectPoints, RelativeAxisObj yAxisObj, int nZeroCoord, int baseCoord, boolean bForwardSeries) {
        int s = 0;
        int g = 0;
        int allVSize = allVectPoints.size();
        int j = 0;
        while (j < allVSize) {
            Vector seriesVect = (Vector)allVectPoints.elementAt(j);
            Vector<Point> facePoints = new Vector<Point>();
            Vector<Point> topPoints = new Vector<Point>();
            Vector<Point> leftPoints = new Vector<Point>();
            Vector<Point> rightPoints = new Vector<Point>();
            Vector<Point> bottomPoints = new Vector<Point>();
            Point cStartPoint = null;
            double fXValue = 0.0;
            double fYValue = 0.0;
            int startIndex = -1;
            int endIndex = -1;
            boolean done = false;
            while (!done) {
                startIndex = this.getStartGroupInSeriesVect(seriesVect, startIndex + 1);
                endIndex = this.getEndGroupInSeriesVect(seriesVect, startIndex + 1);
                if (startIndex == -1) break;
                if (endIndex - startIndex > 0) {
                    int k = startIndex;
                    while (k <= endIndex) {
                        PointInfo info = (PointInfo)seriesVect.elementAt(k);
                        s = info.series;
                        g = info.group;
                        if (k == startIndex && this.m_Perspective.isContinuousTimeAxis() && g > 0 && this.m_dataOK[s][g]) {
                            DatumObj obj = this.getDataValue(s, g - 1, DataItem.DI_XY_X);
                            fXValue = obj.m_fValue;
                            obj = this.getDataValue(s, g - 1, DataItem.DI_XY_Y);
                            fYValue = obj.m_fValue;
                            double x1 = 0.0;
                            double y1 = 0.0;
                            if (obj.m_bOK) {
                                RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                                IdentObj AxisId = axisObj.getAxisIdentObj();
                                boolean bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
                                boolean bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
                                int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
                                int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
                                x1 = this.getO1Axis().getValueCoord(fXValue);
                                RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                                y1 = yAxis.getValueCoord(fYValue);
                                Point pt3 = new Point(info.lt.x, info.lt.y);
                                double min = this.getO1Axis().getMinValue();
                                double minXCoord = this.getO1Axis().getValueCoord(min);
                                double yCoord = this.calcyPosition(new Point((int)x1, (int)y1), pt3, minXCoord);
                                if (!bAutoMin && yCoord < (double)minCoord) {
                                    yCoord = minCoord;
                                }
                                if (!bAutoMax && yCoord > (double)maxCoord) {
                                    yCoord = maxCoord;
                                }
                                cStartPoint = new Point((int)minXCoord, (int)yCoord);
                                facePoints.add(cStartPoint);
                                topPoints.add(cStartPoint);
                                leftPoints.add(cStartPoint);
                            } else if (k == startIndex) {
                                leftPoints.add(info.lt);
                            }
                        } else if (k == startIndex) {
                            leftPoints.add(info.lt);
                        }
                        facePoints.add(info.lt);
                        topPoints.add(info.lt);
                        if (!info.lt.equals(info.rt)) {
                            facePoints.add(info.rt);
                            topPoints.add(info.rt);
                        }
                        if (k == endIndex) {
                            int y;
                            int x;
                            rightPoints.add(info.rt);
                            PointInfo startInfo = (PointInfo)seriesVect.elementAt(startIndex);
                            int closerToBase = bForwardSeries ? 0 : allVSize - 1;
                            if (this.m_bAbsolute || j == closerToBase) {
                                Point bottomLeft;
                                Point bottomRight;
                                PointInfo endInfo = (PointInfo)seriesVect.elementAt(endIndex);
                                if (this.m_bHorz) {
                                    x = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord);
                                    bottomRight = new Point(x, endInfo.rt.y);
                                    bottomLeft = new Point(x, startInfo.lt.y);
                                } else {
                                    y = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord);
                                    if (this.m_Perspective.isContinuousTimeAxis() && g < this.m_nTotalGroups - 1 && this.m_dataOK[s][g]) {
                                        DatumObj obj = this.getDataValue(s, g + 1, DataItem.DI_XY_X);
                                        fXValue = obj.m_fValue;
                                        obj = this.getDataValue(s, g + 1, DataItem.DI_XY_Y);
                                        fYValue = obj.m_fValue;
                                        double x1 = 0.0;
                                        double y1 = 0.0;
                                        if (obj.m_bOK) {
                                            RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                                            IdentObj AxisId = axisObj.getAxisIdentObj();
                                            boolean bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
                                            boolean bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
                                            int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
                                            int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
                                            x1 = this.getO1Axis().getValueCoord(fXValue);
                                            RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                                            y1 = yAxis.getValueCoord(fYValue);
                                            Point pt4 = new Point(endInfo.rt.x, endInfo.rt.y);
                                            double max = this.getO1Axis().getMaxValue();
                                            double maxXCoord = this.getO1Axis().getValueCoord(max);
                                            double yCoord = this.calcyPosition(new Point((int)x1, (int)y1), pt4, maxXCoord);
                                            if (!bAutoMin && yCoord < (double)minCoord) {
                                                yCoord = minCoord;
                                            }
                                            if (!bAutoMax && yCoord > (double)maxCoord) {
                                                yCoord = maxCoord;
                                            }
                                            facePoints.add(new Point((int)maxXCoord, (int)yCoord));
                                            topPoints.add(new Point((int)maxXCoord, (int)yCoord));
                                            bottomRight = new Point((int)maxXCoord, y);
                                            rightPoints.removeElementAt(rightPoints.size() - 1);
                                            rightPoints.add(new Point((int)maxXCoord, (int)yCoord));
                                        } else {
                                            bottomRight = new Point(endInfo.rt.x, y);
                                        }
                                    } else {
                                        bottomRight = new Point(endInfo.rt.x, y);
                                    }
                                    bottomLeft = cStartPoint != null ? new Point(cStartPoint.x, y) : new Point(startInfo.lt.x, y);
                                }
                                facePoints.add(bottomRight);
                                facePoints.add(bottomLeft);
                                leftPoints.add(bottomLeft);
                                rightPoints.add(bottomRight);
                                bottomPoints.add(bottomRight);
                                bottomPoints.add(bottomLeft);
                                if (cStartPoint != null) {
                                    facePoints.add(cStartPoint);
                                } else {
                                    facePoints.add(startInfo.lt);
                                }
                            } else {
                                Vector seriesBelow = null;
                                int lastx = ((PointInfo)seriesVect.elementAt((int)endIndex)).rt.x;
                                int firstx = ((PointInfo)seriesVect.elementAt((int)startIndex)).lt.x;
                                int lasty = ((PointInfo)seriesVect.elementAt((int)endIndex)).rt.y;
                                int firsty = ((PointInfo)seriesVect.elementAt((int)startIndex)).lt.y;
                                boolean found = false;
                                if (bForwardSeries) {
                                    int i = j - 1;
                                    while (i >= 0) {
                                        seriesBelow = (Vector)allVectPoints.elementAt(i);
                                        int m = 0;
                                        while (m < seriesBelow.size()) {
                                            if (((PointInfo)seriesBelow.elementAt(m)).getStatus() == 1) {
                                                found = true;
                                                break;
                                            }
                                            ++m;
                                        }
                                        if (!found) {
                                            --i;
                                            continue;
                                        }
                                        break;
                                    }
                                } else {
                                    int i = j + 1;
                                    while (i < allVSize) {
                                        seriesBelow = (Vector)allVectPoints.elementAt(i);
                                        int m = 0;
                                        while (m < seriesBelow.size()) {
                                            if (((PointInfo)seriesBelow.elementAt(m)).getStatus() == 1) {
                                                found = true;
                                                break;
                                            }
                                            ++m;
                                        }
                                        if (!found) {
                                            ++i;
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                if (!found) {
                                    Point bottomLeft;
                                    Point bottomRight;
                                    if (this.m_bHorz) {
                                        x = this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord;
                                        bottomRight = new Point(x, lasty);
                                        bottomLeft = new Point(x, firsty);
                                    } else {
                                        y = this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord;
                                        bottomRight = new Point(lastx, y);
                                        bottomLeft = new Point(firstx, y);
                                    }
                                    facePoints.add(bottomRight);
                                    facePoints.add(bottomLeft);
                                    leftPoints.add(bottomLeft);
                                    rightPoints.add(bottomRight);
                                    bottomPoints.add(bottomRight);
                                    bottomPoints.add(bottomLeft);
                                    facePoints.add(startInfo.lt);
                                } else {
                                    int eindex = -1;
                                    int sindex = -1;
                                    int n = seriesBelow.size() - 1;
                                    while (n >= 0) {
                                        PointInfo belowInfo = (PointInfo)seriesBelow.elementAt(n);
                                        if (belowInfo.status == 0) {
                                            eindex = -1;
                                            sindex = -1;
                                            break;
                                        }
                                        if (belowInfo.rt.x == lastx) {
                                            eindex = n;
                                        }
                                        if (belowInfo.lt.x == firstx) {
                                            sindex = n;
                                        }
                                        --n;
                                    }
                                    if (eindex == -1 || sindex == -1) {
                                        Point bottomLeft;
                                        Point bottomRight;
                                        if (this.m_bHorz) {
                                            x = this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord;
                                            bottomRight = new Point(x, lasty);
                                            bottomLeft = new Point(x, firsty);
                                        } else {
                                            y = this.wantRisersFromZero(yAxisObj) ? nZeroCoord : baseCoord;
                                            bottomRight = new Point(lastx, y);
                                            bottomLeft = new Point(firstx, y);
                                        }
                                        facePoints.add(bottomRight);
                                        facePoints.add(bottomLeft);
                                        leftPoints.add(bottomLeft);
                                        rightPoints.add(bottomRight);
                                        bottomPoints.add(bottomRight);
                                        bottomPoints.add(bottomLeft);
                                        facePoints.add(startInfo.lt);
                                    } else {
                                        int i = eindex;
                                        while (i >= sindex) {
                                            PointInfo prevInfo = (PointInfo)seriesBelow.elementAt(i);
                                            facePoints.add(prevInfo.rt);
                                            bottomPoints.add(prevInfo.rt);
                                            if (i == eindex) {
                                                rightPoints.add(prevInfo.rt);
                                            }
                                            if (i == sindex) {
                                                leftPoints.add(prevInfo.lt);
                                            }
                                            if (!prevInfo.lt.equals(prevInfo.rt)) {
                                                facePoints.add(prevInfo.lt);
                                                bottomPoints.add(prevInfo.lt);
                                            }
                                            --i;
                                        }
                                        facePoints.add(startInfo.lt);
                                    }
                                }
                            }
                            this.draw25DPolygon(facePoints, topPoints, leftPoints, rightPoints, bottomPoints, bForwardSeries, s, g);
                            facePoints = new Vector();
                            topPoints = new Vector();
                            leftPoints = new Vector();
                            rightPoints = new Vector();
                            bottomPoints = new Vector();
                        }
                        ++k;
                    }
                }
                startIndex = endIndex;
            }
            if (this.m_bTransparentMarkers) {
                this.drawTransparentMarkersWithDepth(s, 3);
            }
            ++j;
        }
    }

    private int getStartGroupInSeriesVect(Vector seriesVect, int index) {
        int k = index;
        while (k < seriesVect.size()) {
            PointInfo info = (PointInfo)seriesVect.elementAt(k);
            if (info.getStatus() == 1) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    private int getEndGroupInSeriesVect(Vector seriesVect, int index) {
        int k = index;
        while (k < seriesVect.size()) {
            PointInfo info = (PointInfo)seriesVect.elementAt(k);
            if (info.getStatus() == 0) {
                return k - 1;
            }
            if (k == seriesVect.size() - 1) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    private PointInfo getPointInfo(Vector seriesVect, int s, int g) {
        if (seriesVect.size() == 0) {
            PointInfo info = new PointInfo(s, g);
            seriesVect.add(info);
            return info;
        }
        PointInfo info = (PointInfo)seriesVect.lastElement();
        if (info.group == g) {
            return info;
        }
        info = new PointInfo(s, g);
        seriesVect.add(info);
        return info;
    }

    private void draw25DPolygon(Vector facePoints, Vector topPoints, Vector leftPoints, Vector rightPoints, Vector bottomPoints, boolean bForwardSeries, int s, int g) {
        int dy;
        int dx;
        Point frontOffset;
        BlackBoxIF blackBox = this.assignSeriesColor(s, g);
        blackBox.runRules(s, g);
        double fIntensity = 1.0;
        double fIntensityTop = 1.0;
        double fIntensitySide = 1.0;
        double fIntensityBottom = 1.0;
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bShowLeftSide = bRightToLeft || this.m_bHorz;
        RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, null);
        boolean bDescending = yAxisObj.isDescending();
        int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
        BlackBoxIF riserBlackBox = this.getMissingDataBlackBox(s, g);
        if (riserBlackBox == null) {
            riserBlackBox = blackBox;
        }
        BlackBoxIF blackBoxNew = riserBlackBox;
        if (riserBlackBox instanceof BlackBoxObj) {
            BlackBoxObj newBox = new BlackBoxObj((BlackBoxObj)riserBlackBox);
            newBox.setFillType(1);
            blackBoxNew = newBox;
        }
        if (this.wantDepthEffect()) {
            Point backOffset = this.m_seriesBackOffsets[s];
            frontOffset = this.m_seriesFrontOffsets[s];
            dx = frontOffset.x - backOffset.x;
            dy = frontOffset.y - backOffset.y;
        } else {
            frontOffset = new Point();
            dx = 0;
            dy = 0;
        }
        Polygon polyFront = new Polygon();
        Polygon polyTop = null;
        Polygon polyBottom = null;
        Point p = null;
        int i = 0;
        while (i < facePoints.size()) {
            p = (Point)facePoints.elementAt(i);
            polyFront.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
            ++i;
        }
        if (this.m_bAbsolute || this.isTopStackedArea(s)) {
            Point p2;
            if (this.m_bColorAutoshadeRisers) {
                double d = fIntensityTop = this.m_bHorz ? 0.6 : 0.8;
            }
            if (!bShowLeftSide) {
                int j = 0;
                while (j < topPoints.size() - 1) {
                    polyTop = new Polygon();
                    p = (Point)topPoints.elementAt(j);
                    polyTop.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                    p2 = (Point)topPoints.elementAt(j + 1);
                    polyTop.addPoint(p2.x - frontOffset.x, p2.y - frontOffset.y);
                    polyTop.addPoint(p2.x - frontOffset.x + dx, p2.y - frontOffset.y + dy);
                    polyTop.addPoint(p.x - frontOffset.x + dx, p.y - frontOffset.y + dy);
                    polyTop.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                    new DetPolygon(this.m_Detectiv, new IdentObj(314, s), polyTop, blackBoxNew, fIntensityTop);
                    ++j;
                }
            } else {
                int j = topPoints.size() - 1;
                while (j > 0) {
                    polyTop = new Polygon();
                    p = (Point)topPoints.elementAt(j);
                    polyTop.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                    p2 = (Point)topPoints.elementAt(j - 1);
                    polyTop.addPoint(p2.x - frontOffset.x, p2.y - frontOffset.y);
                    polyTop.addPoint(p2.x - frontOffset.x + dx, p2.y - frontOffset.y + dy);
                    polyTop.addPoint(p.x - frontOffset.x + dx, p.y - frontOffset.y + dy);
                    polyTop.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                    new DetPolygon(this.m_Detectiv, new IdentObj(314, s), polyTop, blackBoxNew, fIntensityTop);
                    --j;
                }
            }
        }
        if (this.m_bAbsolute || this.isBottomStackedArea(s)) {
            if (this.m_bColorAutoshadeRisers) {
                double d = fIntensityBottom = this.m_bHorz ? 0.6 : 0.8;
            }
            if (!bShowLeftSide) {
                int j = 0;
                while (j < bottomPoints.size() - 1) {
                    polyBottom = new Polygon();
                    p = (Point)bottomPoints.elementAt(j);
                    polyBottom.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                    Point p2 = (Point)bottomPoints.elementAt(j + 1);
                    polyBottom.addPoint(p2.x - frontOffset.x, p2.y - frontOffset.y);
                    polyBottom.addPoint(p2.x - frontOffset.x + dx, p2.y - frontOffset.y + dy);
                    polyBottom.addPoint(p.x - frontOffset.x + dx, p.y - frontOffset.y + dy);
                    polyBottom.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                    new DetPolygon(this.m_Detectiv, new IdentObj(316, s), polyBottom, blackBoxNew, fIntensityBottom);
                    ++j;
                }
            } else {
                int j = bottomPoints.size() - 1;
                while (j > 0) {
                    polyBottom = new Polygon();
                    p = (Point)bottomPoints.elementAt(j);
                    polyBottom.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                    Point p2 = (Point)bottomPoints.elementAt(j - 1);
                    polyBottom.addPoint(p2.x - frontOffset.x, p2.y - frontOffset.y);
                    polyBottom.addPoint(p2.x - frontOffset.x + dx, p2.y - frontOffset.y + dy);
                    polyBottom.addPoint(p.x - frontOffset.x + dx, p.y - frontOffset.y + dy);
                    polyBottom.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
                    new DetPolygon(this.m_Detectiv, new IdentObj(316, s), polyBottom, blackBoxNew, fIntensityBottom);
                    --j;
                }
            }
        }
        if (bShowLeftSide) {
            Polygon polyLeft = new Polygon();
            p = (Point)leftPoints.elementAt(0);
            Point p2 = (Point)leftPoints.elementAt(1);
            polyLeft.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
            polyLeft.addPoint(p2.x - frontOffset.x, p2.y - frontOffset.y);
            polyLeft.addPoint(p2.x - frontOffset.x + dx, p2.y - frontOffset.y + dy);
            polyLeft.addPoint(p.x - frontOffset.x + dx, p.y - frontOffset.y + dy);
            polyLeft.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
            if (this.m_bColorAutoshadeRisers) {
                fIntensitySide = this.m_bHorz ? 0.8 : 0.6;
            }
            new DetPolygon(this.m_Detectiv, new IdentObj(315, s), polyLeft, blackBoxNew, fIntensitySide);
        } else if (rightPoints.size() >= 2) {
            Polygon polyRight = new Polygon();
            p = (Point)rightPoints.elementAt(0);
            Point p2 = (Point)rightPoints.elementAt(1);
            polyRight.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
            polyRight.addPoint(p2.x - frontOffset.x, p2.y - frontOffset.y);
            polyRight.addPoint(p2.x - frontOffset.x + dx, p2.y - frontOffset.y + dy);
            polyRight.addPoint(p.x - frontOffset.x + dx, p.y - frontOffset.y + dy);
            polyRight.addPoint(p.x - frontOffset.x, p.y - frontOffset.y);
            if (this.m_bColorAutoshadeRisers) {
                fIntensitySide = this.m_bHorz ? 0.8 : 0.6;
            }
            new DetPolygon(this.m_Detectiv, new IdentObj(315, s), polyRight, blackBoxNew, fIntensitySide);
        }
        if (this.m_bColorAutoshadeRisers) {
            fIntensity = 1.0;
        }
        new DetPolygon(this.m_Detectiv, new IdentObj(256, s), polyFront, riserBlackBox, fIntensity);
    }

    public JChart_2D_BLA() {
        this.$init$();
    }

    private class PointInfo {
        public Point lt;
        public Point rt;
        public static final int NULL_STATUS = 0;
        public static final int OK_STATUS = 1;
        public int group;
        public int series;
        int status;

        private void $init$() {
            this.lt = null;
            this.rt = null;
            this.group = -1;
            this.series = -1;
            this.status = 1;
        }

        public PointInfo(int s, int g) {
            this.$init$();
            this.series = s;
            this.group = g;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int stat) {
            this.status = stat;
        }
    }
}

