/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dss.graph.pfj.DataRange;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.PieFrameObj;
import oracle.dss.graph.pfj.PieSliceObj;
import oracle.dss.graph.pfj.ReversePathIterator;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetOval;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetPolyline;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.presutil.PresUtils;

public class JChart_2D_Pie
extends JChart_2D {
    public static final boolean DEBUG_2D_PIE = false;
    public static final int DRILL_LABEL_MARGIN = 10;
    double m_fRingPct;
    double m_fPieTilt;
    double m_fThickness;
    double m_maxStrLength;
    int m_nPiesPerRow;
    int m_bPieLabelDisplay;
    int m_nFeelerTextFormat;
    String m_strFeelerTextFormatPattern;
    int m_nPieFeelerTextDisplay;
    boolean m_bSliceLabelVisibility;
    boolean m_bGTHasRing;
    boolean m_bGTProportional;
    boolean m_bGTMultiple;
    boolean m_bShowPieTotal;
    boolean m_bReverseGroups;
    int m_nKissingFeelers;
    int m_nThickOffset;
    int m_nRadius;
    int m_nSaveRadius;
    int m_temp;
    double m_fPieTotal;
    double m_fHighestGroupTotal;
    Rectangle m_rPieFrame;
    PieSliceObj[] m_slices;
    int m_nSliceCount;
    int m_nLabelHeight;
    int m_nPieLabelHeight;
    int m_nXCenter;
    int m_nYCenter;
    int m_sliceLabelLeftEdge;
    int m_sliceLabelRightEdge;
    int[] m_stringWidths;
    String[] m_fullSliceLabels;
    int m_maxLabelWidthDest;
    Vector m_vectStrLabels;
    Vector m_leftSliceLabels;
    Vector m_rightSliceLabels;
    FontMetrics m_sliceLabelFM;
    Dimension m_labelDimVC;
    int m_nLineWidthFeeler;
    int m_nLineStyleFeeler;
    int m_pivotLineVirt;
    int m_pivotLineDest;
    int m_feelerTextGapVirt;
    int m_feelerTextGapDest;
    Rectangle m_rOPI_PieFrame;
    int m_nPieBarSlice;
    Point m_ptTopSlice;
    Point m_ptBottomSlice;
    TextStyleObj m_textStyleFeelers;
    boolean[][] m_bSeriesPartOfOther;
    boolean[][] m_bSeriesDrawn;
    boolean m_bOtherPercentage;
    boolean m_bLabelsAtTopOrBottom;
    boolean m_sliceLabelTruncated;
    boolean m_DetachPresent;
    Area m_area;
    Arc2D m_arc2D;
    double m_xRadius;
    double m_yRadius;
    Rectangle m_drillLabelRect;
    IdentObj m_drillLabel;
    IdentObj m_drillLabelBox;
    TextStyleObj m_pieLabelTextStyleObj;
    VC m_VC;
    int m_leftMostPointOfPie;
    int m_rightMostPointOfPie;
    int m_sliceLabelFontHeight;
    int m_virtMarginHeight;
    int m_virtMarginWidth;
    int m_sliceLabelGap;
    public static final double SLIGHTLY_SHADED = 0.8;
    public static final double MORE_SHADED = 0.6;
    public static final double MOST_SHADED = 0.4;
    public static final double UNKNOWN_ANGLE = -7.0;
    public static final int TYPE_TOP = 1000;
    public static final int TYPE_LEFT = 2000;
    public static final int TYPE_RIGHT = 3000;
    public static final int TYPE_CRUST = 4000;
    public static final int TYPE_RING = 5000;
    public static final int RADIAL_FEELER = 100;
    public static final int PIVOT_FEELER = 200;
    public static final int PPR_AUTOMATIC = 0;
    public static final int MAX_PIELABELHEIGHT = 2500;
    public static final int LABEL_COMPENSATION = 2;
    public static final int AVG_PIELABEL_SIZE = 4;
    public static final int MARGIN = 5;
    public static final int MAX_PIVOT_LINE = 5;
    public static final int MIN_PIVOT_LINE = 2;
    public static final int MAX_FEELER_TEXT_GAP = 3;
    public static final int MIN_FEELER_TEXT_GAP = 1;
    public static final int ADDITIONAL_SPACE = 26;
    public static final int COLLISION_NONE = 0;
    public static final int COLLISION_BOTH = 1;
    public static final int COLLISION_TOP = 2;
    public static final int COLLISION_BOTTOM = 3;
    public static final int kPENETRATING_FEELER = 0;
    public static final int kKISSING_FEELER = 1;
    public static final double FONT_GAP = 0.33;
    public static final double MIN_RADIUS = 0.25;
    private Vector m_boundingRects;
    private boolean m_collision;
    private boolean m_no_collision;
    private boolean m_circular;

    private void $init$() {
        this.m_collision = false;
        this.m_no_collision = false;
        this.m_circular = false;
    }

    public void calc() {
        this.calcCommon(false);
        if (this.m_bGTMultiple) {
            this.calcMultiplePies();
        } else {
            this.calcSinglePie();
        }
        this.calcDrillLabel();
        if (this.m_sliceLabelTruncated) {
            this.m_Perspective.setSliceLabelsTruncated(this.m_sliceLabelTruncated, new IdentObj(295));
        } else {
            this.m_Perspective.setSliceLabelsTruncated(this.m_sliceLabelTruncated, null);
        }
        this.fireInapropriateDataEvent();
    }

    public void calcCommon(boolean al) {
        if (!al) {
            super.calc();
        }
        this.calcHighestGroupTotal();
        boolean bOtherSeries = this.m_Perspective.getOtherSeries();
        if (bOtherSeries) {
            this.createSeriesPartOfOther(this.m_nTotalSeries, this.m_nTotalGroups);
            this.createSeriesDrawn(this.m_nTotalSeries, this.m_nTotalGroups);
        }
        this.m_bOtherPercentage = false;
        this.m_VC = this.m_Perspective.getVC();
        this.m_vectStrLabels = null;
        this.m_sliceLabelTruncated = false;
        this.m_fullSliceLabels = null;
        this.m_nPieLabelHeight = 0;
        this.m_collision = false;
        this.m_no_collision = false;
        this.m_circular = false;
        this.m_DetachPresent = false;
        this.m_sliceLabelFM = null;
        this.m_virtMarginHeight = this.m_VC.destToVirtHeight(5);
        this.m_virtMarginWidth = this.m_VC.destToVirtWidth(5);
        if (this.m_Perspective.getDisplay(296)) {
            this.m_nPieLabelHeight = this.calcPieLabelHeight();
        }
        this.createFeelerTextStyle();
        this.m_sliceLabelGap = (int)((double)this.m_VC.destToVirtHeight(TextStyleObj.getFontHeight(this.getSliceLabelFontMetrics(), this.m_Perspective.getFontMetricsResolver())) * 0.33);
        this.m_boundingRects = new Vector();
    }

    public void calcDataScrollers() {
    }

    public void calcHighestGroupTotal() {
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        this.m_fHighestGroupTotal = 0.0;
        if (this.m_bGTProportional) {
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                double fThisTotal = this.getGroupTotal(g);
                if (!(fThisTotal > this.m_fHighestGroupTotal)) continue;
                this.m_fHighestGroupTotal = fThisTotal;
            }
        }
    }

    public void calcMultiplePies() {
        int nNumPiesLeftOver;
        int nNumRowsY;
        double fSumTotal = 0.0;
        int nNumColsX = this.m_nPiesPerRow;
        if (nNumColsX == 0) {
            int numRowsAfter;
            int numRowsBefore;
            int numRowsAfter2;
            int numRowsBefore2;
            nNumColsX = (int)Math.sqrt(this.m_nGroups);
            int destPieFrameHeight = this.m_VC.virtToDestHeight(this.m_rOPI_PieFrame.height);
            int destPieFrameWidth = this.m_VC.virtToDestWidth(this.m_rOPI_PieFrame.width);
            if (destPieFrameWidth < (int)((double)destPieFrameHeight * 0.2) && nNumColsX > 1) {
                --nNumColsX;
            }
            if (destPieFrameWidth < (int)((double)destPieFrameHeight * 0.4) && nNumColsX > 1) {
                --nNumColsX;
            }
            if (destPieFrameWidth > (int)((double)destPieFrameHeight * 1.3) && (numRowsBefore2 = (this.m_nGroups - 1) / nNumColsX + 1) == (numRowsAfter2 = (this.m_nGroups - 1) / ++nNumColsX + 1)) {
                --nNumColsX;
            }
            if (destPieFrameWidth > (int)((double)destPieFrameHeight * 2.3) && (numRowsBefore = (this.m_nGroups - 1) / nNumColsX + 1) == (numRowsAfter = (this.m_nGroups - 1) / ++nNumColsX + 1)) {
                --nNumColsX;
            }
            if (nNumColsX < 1) {
                nNumColsX = 1;
            }
        }
        if (nNumColsX > this.m_nGroups) {
            this.m_Perspective.getErrorHandler().log("Attempted using PiesPerRow greater than number of groups.", this.getClass().getName(), "calcMultiplePies()");
            nNumRowsY = 1;
            nNumColsX = this.m_nGroups;
            nNumPiesLeftOver = 0;
        } else {
            nNumRowsY = (this.m_nGroups - 1) / nNumColsX + 1;
            nNumPiesLeftOver = this.m_nGroups % nNumColsX;
        }
        Rectangle rectSubPie = new Rectangle(this.m_rOPI_PieFrame.x, this.m_rOPI_PieFrame.y, this.m_rOPI_PieFrame.width / nNumColsX, this.m_rOPI_PieFrame.height / nNumRowsY);
        this.m_nRadius = this.calcSinglePieRadius(rectSubPie, false);
        if (!this.m_bSliceLabelVisibility || this.m_nPieFeelerTextDisplay == 3) {
            int radiusDest;
            int rectSubPieDestHt = this.m_VC.virtToDestHeight(rectSubPie.height - this.m_nPieLabelHeight);
            int rectSubPieDestWd = this.m_VC.virtToDestWidth(rectSubPie.width);
            Rectangle destRect = this.m_VC.getDestCoords();
            double fYSquashRatio = Math.abs((double)destRect.width) / (double)destRect.height;
            double fXSquashRatio = 1.0;
            if (fYSquashRatio > 1.0) {
                fXSquashRatio = 1.0 / fYSquashRatio;
                fYSquashRatio = 1.0;
            }
            if ((radiusDest = (int)this.m_VC.virtToDestWidth((double)this.m_nRadius * fXSquashRatio)) * 2 > (int)((double)rectSubPieDestWd * 0.9)) {
                radiusDest = (int)((double)rectSubPieDestWd * 0.9 / 2.0);
            }
            if (radiusDest * 2 > (int)((double)rectSubPieDestHt * 0.9)) {
                radiusDest = (int)((double)rectSubPieDestHt * 0.9 / 2.0);
            }
            this.m_nRadius = this.calcVirtRadius(radiusDest, destRect);
        }
        this.m_nSaveRadius = this.m_nRadius;
        int nTopX = this.m_rOPI_PieFrame.x;
        int nTopY = this.m_rOPI_PieFrame.y + this.m_rOPI_PieFrame.height - rectSubPie.height;
        this.calcPivotLineAndGap(rectSubPie.width, rectSubPie.height);
        int nCurrentGroup = 0;
        int nRowY = 0;
        while (nRowY < nNumRowsY) {
            int nCenterLeftOverPieXOffset = this.m_nGroups < nCurrentGroup + nNumColsX ? this.m_rOPI_PieFrame.width / 2 - nNumPiesLeftOver * rectSubPie.width / 2 : 0;
            int nColX = 0;
            while (nColX < nNumColsX) {
                if (nCurrentGroup < this.m_nGroups) {
                    rectSubPie.x = nTopX + nColX * rectSubPie.width + nCenterLeftOverPieXOffset;
                    rectSubPie.y = nTopY - nRowY * rectSubPie.height;
                    this.m_rPieFrame = rectSubPie;
                    double total = this.drawPie(rectSubPie, nCurrentGroup++);
                    fSumTotal += total;
                }
                ++nColX;
            }
            ++nRowY;
        }
    }

    public void calcSinglePie() {
        this.m_rPieFrame = this.m_rOPI_PieFrame;
        this.m_nLabelHeight = Math.min(2000, this.m_rOPI_PieFrame.height / 4);
        this.m_nRadius = this.calcSinglePieRadius(this.m_rPieFrame, false);
        if (this.m_nRadius <= 0) {
            return;
        }
        this.m_nSaveRadius = this.m_nRadius;
        double fSumTotal = this.drawPie(this.m_rOPI_PieFrame, 0);
    }

    public Vector getPieRingBounds() {
        return this.m_boundingRects;
    }

    public int calcReqWidth(Rectangle pieFrame) {
        this.calcCommon(true);
        return this.calcSinglePieRadius(pieFrame, true);
    }

    public int calcSinglePieRadius(Rectangle pieFrame, boolean al) {
        int numLinesPerLabelOnRight;
        int numLinesPerLabelOnLeft;
        int numLinesPerLabel;
        int maxRadiusDest;
        int maxRadius;
        int radiusDest = 0;
        int availWidth = pieFrame.width;
        int availHeight = pieFrame.height;
        this.m_maxLabelWidthDest = 0;
        this.m_bLabelsAtTopOrBottom = false;
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        GroupsEnumerator gEnumRev = this.getResetGroupsEnumerator(false);
        int group = 0;
        int g = gEnum.getAbsoluteGroup(group);
        if (this.m_gt.isPieBarType() && this.isPieBarSliceOK()) {
            availWidth -= availWidth - availWidth * 9 / 10;
        }
        if ((availHeight -= this.m_nPieLabelHeight) < 200 || availWidth < 200) {
            return -1;
        }
        this.calcPivotLineAndGap(availWidth, availHeight);
        Rectangle rect = this.m_VC.getDestCoords();
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        int maxDetach = 0;
        while (sEnum.hasMoreElements()) {
            double fDetach;
            int nDetach;
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            double fValue = this.m_gt.isPieBarType() ? this.getSeriesTotal(s) : this.getDataValue((int)s, (int)g).m_fValue;
            if (!(fValue > 0.0) || !this.m_bSmallDataSet || (nDetach = (int)((fDetach = (double)this.m_Perspective.getPieSliceDetach(s, g) / 100.0) * 1500.0)) <= maxDetach) continue;
            maxDetach = nDetach;
        }
        int nTipX = 0;
        int nTipY = 0;
        if (maxDetach > 0) {
            double fXSquashRatio = 1.0;
            double fYSquashRatio = Math.abs((double)rect.width) / (double)rect.height;
            if (fYSquashRatio > 1.0) {
                fXSquashRatio = 1.0 / fYSquashRatio;
                fYSquashRatio = 1.0;
            }
            fYSquashRatio -= fYSquashRatio * this.m_fPieTilt;
            double f12OClock = -1.5707963267948966;
            double fAngle = f12OClock + 4.71238898038469;
            nTipX = 0 + (int)(Math.cos(fAngle) * fXSquashRatio * (double)maxDetach);
            fAngle = f12OClock + 0.0;
            nTipY = 0 - (int)(Math.sin(fAngle) * fYSquashRatio * (double)maxDetach);
        }
        if (this.m_gt.isPieBarType()) {
            this.m_fHighestGroupTotal = this.m_fPieTotal = this.getSumTotal();
        } else {
            this.m_fPieTotal = this.getGroupTotal(g);
        }
        if (!this.m_bGTMultiple && this.m_fPieTotal <= 0.0) {
            return -1;
        }
        FontMetrics fm = this.getSliceLabelFontMetrics();
        int fontHeight = TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver());
        this.getSliceLabels(g, fm);
        int availWidthDest = this.m_VC.virtToDestWidth(availWidth - Math.abs(nTipX) * 2);
        int availHeightDest = this.m_VC.virtToDestHeight(availHeight - Math.abs(nTipY) * 2);
        if (!this.m_bSliceLabelVisibility || this.m_nPieFeelerTextDisplay == 3) {
            radiusDest = availWidthDest < availHeightDest ? availWidthDest / 2 - 5 : availHeightDest / 2 - 5;
            if (al) {
                return (radiusDest + 5) * 2;
            }
            return this.calcVirtRadius(radiusDest, rect);
        }
        boolean bAnimationSupported = this.m_Perspective.m_bAnimationSupported;
        int radiusByHt = availHeight / 2;
        radiusByHt = this.m_bLabelsAtTopOrBottom || bAnimationSupported ? (radiusByHt -= this.m_VC.destToVirtHeight(fontHeight)) : (radiusByHt -= this.m_VC.destToVirtHeight(fontHeight / 2));
        radiusByHt = this.m_bLabelsAtTopOrBottom || bAnimationSupported ? (int)((double)radiusByHt / 1.125) : (int)((double)radiusByHt / 1.0625);
        int radiusByHtDest = this.m_VC.virtToDestHeight(radiusByHt);
        int minRadiusByWd = (int)((double)availWidth * 0.25);
        int minRadiusByWdDest = this.m_VC.virtToDestWidth(minRadiusByWd);
        int minRadiusDest = 0;
        if (radiusByHtDest < minRadiusByWdDest) {
            int minRadius = this.calcVirtRadius(radiusByHtDest, rect);
            if (al) {
                return this.m_maxLabelWidthDest * 2 + radiusByHtDest * 2 + 26;
            }
            return minRadius;
        }
        int minRadius = this.calcVirtRadius(minRadiusByWdDest, rect);
        minRadiusDest = minRadiusByWdDest;
        int maxRadiusByWd = availWidth / 2;
        int maxRadiusByWdDest = this.m_VC.virtToDestWidth(maxRadiusByWd);
        if (radiusByHtDest < maxRadiusByWdDest) {
            maxRadius = this.calcVirtRadius(radiusByHtDest, rect);
            maxRadiusDest = radiusByHtDest;
        } else {
            maxRadius = this.calcVirtRadius(maxRadiusByWdDest, rect);
            maxRadiusDest = maxRadiusByWdDest;
        }
        if (bAnimationSupported) {
            minRadiusDest = maxRadiusDest = (minRadiusDest + maxRadiusDest) / 2;
            maxRadius = this.calcVirtRadius(maxRadiusDest, rect);
            minRadius = this.calcVirtRadius(minRadiusDest, rect);
        }
        int maxSliceLabelWidthDest = (availWidthDest - minRadiusDest * 2) / 2;
        int minSliceLabelWidthDest = (availWidthDest - maxRadiusDest * 2) / 2;
        maxSliceLabelWidthDest -= this.m_feelerTextGapDest;
        minSliceLabelWidthDest -= this.m_feelerTextGapDest;
        if ((this.m_nPieFeelerTextDisplay == 1 || this.m_nPieFeelerTextDisplay == 4) && this.m_bSliceLabelVisibility) {
            maxSliceLabelWidthDest -= this.m_pivotLineDest;
            minSliceLabelWidthDest -= this.m_pivotLineDest;
        }
        maxSliceLabelWidthDest -= 5;
        if (this.m_maxLabelWidthDest < (minSliceLabelWidthDest -= 5)) {
            if (al) {
                return this.m_maxLabelWidthDest * 2 + maxRadiusDest * 2 + 26;
            }
            return this.calcVirtRadius(maxRadiusDest, rect);
        }
        if (this.m_nPieFeelerTextDisplay == 2 && this.m_bSliceLabelVisibility) {
            if (this.m_maxLabelWidthDest < maxSliceLabelWidthDest) {
                int newRadius = minRadiusDest + (maxSliceLabelWidthDest - this.m_maxLabelWidthDest);
                if (newRadius > maxRadiusDest) {
                    newRadius = maxRadiusDest;
                }
                if (al) {
                    return this.m_maxLabelWidthDest * 2 + newRadius * 2 + 26;
                }
                return this.calcVirtRadius(newRadius, rect);
            }
            if (al) {
                return this.m_maxLabelWidthDest * 2 + minRadiusDest * 2 + 26;
            }
            return this.calcVirtRadius(minRadiusDest, rect);
        }
        if (al) {
            return -1;
        }
        double maxNumLines = (double)availHeightDest / (double)fontHeight;
        int numLabelsOnLeft = this.m_leftSliceLabels.size();
        int numLabelsOnRight = this.m_rightSliceLabels.size();
        double minNumWrapLinesReqOnLeft = (double)(numLabelsOnLeft * 2) + (double)(numLabelsOnLeft + 1) * 0.33;
        double minNumWrapLinesReqOnRight = (double)(numLabelsOnRight * 2) + (double)(numLabelsOnRight + 1) * 0.33;
        if (minNumWrapLinesReqOnLeft > maxNumLines || minNumWrapLinesReqOnRight > maxNumLines) {
            if (this.m_maxLabelWidthDest < maxSliceLabelWidthDest) {
                int newRadius = minRadiusDest + (maxSliceLabelWidthDest - this.m_maxLabelWidthDest);
                if (newRadius > maxRadiusDest) {
                    newRadius = maxRadiusDest;
                }
                return this.calcVirtRadius(newRadius, rect);
            }
            return this.calcVirtRadius(minRadiusDest, rect);
        }
        Dimension dimLen = this.getLongestStringWidth(fm);
        int widthOfLongestWord = dimLen.width;
        int widthOfLongestString = dimLen.height;
        if (widthOfLongestWord != widthOfLongestString && availWidthDest / widthOfLongestWord > 6) {
            widthOfLongestWord = availWidthDest / 6;
        }
        int n = numLinesPerLabel = (numLinesPerLabelOnLeft = (int)(Math.floor(maxNumLines - (double)(numLabelsOnLeft + 1) * 0.33) / (double)numLabelsOnLeft)) < (numLinesPerLabelOnRight = (int)(Math.floor(maxNumLines - (double)(numLabelsOnRight + 1) * 0.33) / (double)numLabelsOnRight)) ? numLinesPerLabelOnLeft : numLinesPerLabelOnRight;
        if (this.m_maxLabelWidthDest / numLinesPerLabel < widthOfLongestWord && widthOfLongestWord < maxSliceLabelWidthDest) {
            int newRadius = minRadiusDest + (maxSliceLabelWidthDest - widthOfLongestWord);
            if (newRadius > maxRadiusDest) {
                newRadius = maxRadiusDest;
            }
            return this.calcVirtRadius(newRadius, rect);
        }
        return this.calcVirtRadius(minRadiusDest, rect);
    }

    private Dimension getLongestStringWidth(FontMetrics fm) {
        int maxWdLen = 0;
        int maxStrLen = 0;
        int i = 0;
        while (i < this.m_vectStrLabels.size()) {
            String label = (String)this.m_vectStrLabels.elementAt(i);
            int strLen = this.m_Perspective.getFontMetricsResolver().stringWidth(label, fm);
            if (strLen > maxStrLen) {
                maxStrLen = strLen;
            }
            if (label != null) {
                boolean count = false;
                StringTokenizer tokens = new StringTokenizer(label, " ");
                while (tokens.hasMoreTokens()) {
                    String word = tokens.nextToken();
                    int wdLen = this.m_Perspective.getFontMetricsResolver().stringWidth(word, fm);
                    if (wdLen <= maxWdLen) continue;
                    maxWdLen = wdLen;
                }
            }
            ++i;
        }
        return new Dimension(maxWdLen, maxStrLen);
    }

    private int calcVirtRadius(int radiusDest, Rectangle rect) {
        if (rect.width < rect.height) {
            return this.m_VC.destToVirtWidth(radiusDest);
        }
        return this.m_VC.destToVirtHeight(radiusDest);
    }

    private FontMetrics getSliceLabelFontMetrics() {
        if (this.m_sliceLabelFM == null) {
            Graphics graphics = this.m_Perspective.getGraphicsContext();
            Font font = this.m_textStyleFeelers.getFont(this.m_VC);
            this.m_sliceLabelFM = graphics.getFontMetrics(font);
            return this.m_sliceLabelFM;
        }
        return this.m_sliceLabelFM;
    }

    private void calcPivotLineAndGap(int width, int height) {
        int minDiameter;
        int availWidthDest = this.m_VC.virtToDestWidth(width);
        int availHeightDest = this.m_VC.virtToDestHeight(height);
        if (availHeightDest < (minDiameter = availWidthDest / 2)) {
            minDiameter = availHeightDest;
        }
        this.m_pivotLineDest = (int)((double)minDiameter * 0.04);
        if (this.m_pivotLineDest > 5) {
            this.m_pivotLineDest = 5;
        } else if (this.m_pivotLineDest < 2) {
            this.m_pivotLineDest = 2;
        }
        this.m_pivotLineVirt = this.m_VC.destToVirtWidth(this.m_pivotLineDest);
        this.m_feelerTextGapDest = (int)((double)minDiameter * 0.02);
        if (this.m_feelerTextGapDest > 3) {
            this.m_feelerTextGapDest = 3;
        } else if (this.m_feelerTextGapDest < 1) {
            this.m_feelerTextGapDest = 1;
        }
        this.m_feelerTextGapVirt = this.m_VC.destToVirtWidth(this.m_feelerTextGapDest);
    }

    private void getSliceLabels(int g, FontMetrics fm) {
        double fSliceEnd;
        double fSlicePct;
        double fValue;
        int s;
        double fOtherPct = 0.0;
        double firstAngle = -1.0;
        int leftInsertPos = 0;
        int rightInsertPos = 0;
        int nSeriesCount = 0;
        boolean bOtherSeries = this.m_Perspective.getOtherSeries();
        boolean sliceDeleted = false;
        this.m_leftSliceLabels = new Vector();
        this.m_rightSliceLabels = new Vector();
        this.m_vectStrLabels = new Vector();
        this.m_stringWidths = new int[25];
        this.m_sliceLabelFontHeight = TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver());
        double fOtherPercentage = this.m_Perspective.getOtherPercentage() / 100.0;
        double fCurrAngle = this.getPieRotation();
        this.m_maxLabelWidthDest = 0;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasMoreElements()) {
            s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            fValue = this.m_gt.isPieBarType() ? this.getSeriesTotal(s) : this.getDataValue((int)s, (int)g).m_fValue;
            if (!(fValue > 0.0)) continue;
            fSlicePct = fValue / this.m_fPieTotal;
            if (bOtherSeries && fSlicePct < fOtherPercentage) {
                fOtherPct += fSlicePct;
                continue;
            }
            fSliceEnd = fCurrAngle + fSlicePct;
            if (fCurrAngle == 0.125) {
                fCurrAngle += 1.0E-12;
            }
            if (fCurrAngle == 0.375) {
                fCurrAngle -= 1.0E-12;
            }
            if (fCurrAngle == 0.625) {
                fCurrAngle -= 1.0E-12;
            }
            if (fCurrAngle == 0.875) {
                fCurrAngle -= 1.0E-12;
            }
            double fDist = fSliceEnd - fCurrAngle;
            double fAngleStart = fCurrAngle - Math.floor(fCurrAngle);
            double fAngleEnd = fSliceEnd - Math.floor(fSliceEnd);
            double fAngleAvg = fAngleStart + fDist / 2.0;
            fAngleAvg -= Math.floor(fAngleAvg);
            String slabel = this.getLabel(s, g, fValue, fSlicePct);
            this.m_vectStrLabels.addElement(slabel);
            int labelWidth = this.m_Perspective.getFontMetricsResolver().stringWidth(slabel, fm);
            if (labelWidth > this.m_maxLabelWidthDest) {
                this.m_maxLabelWidthDest = labelWidth;
            }
            if ((double)slabel.length() > this.m_maxStrLength) {
                this.m_maxStrLength = slabel.length();
            }
            if (this.m_stringWidths.length <= nSeriesCount) {
                int[] newArray = new int[this.m_stringWidths.length * 2];
                System.arraycopy(this.m_stringWidths, 0, newArray, 0, this.m_stringWidths.length);
                this.m_stringWidths = newArray;
            }
            this.m_stringWidths[nSeriesCount] = labelWidth;
            if (fAngleAvg < 0.08 || fAngleAvg > 0.92 || fAngleAvg > 0.42 && fAngleAvg < 0.58) {
                this.m_bLabelsAtTopOrBottom = true;
            }
            if (firstAngle < 0.0) {
                firstAngle = fAngleAvg;
            }
            if (!(sliceDeleted = this.m_bSmallDataSet ? this.m_Perspective.getPieSliceDelete(s) || this.m_Perspective.getPieSliceDelete(s, g) : false)) {
                if (fAngleAvg > 0.0 && fAngleAvg <= 0.5) {
                    if (fAngleAvg < firstAngle) {
                        this.m_rightSliceLabels.insertElementAt(slabel, rightInsertPos++);
                    } else {
                        this.m_rightSliceLabels.addElement(slabel);
                    }
                } else if (fAngleAvg < firstAngle && fAngleAvg != 0.0) {
                    this.m_leftSliceLabels.insertElementAt(slabel, leftInsertPos++);
                } else {
                    this.m_leftSliceLabels.addElement(slabel);
                }
            }
            fCurrAngle = fSliceEnd;
            ++nSeriesCount;
        }
        if (fOtherPct > 0.0) {
            s = -1;
            fValue = fOtherPct * this.m_fPieTotal;
            fSlicePct = fOtherPct;
            fSliceEnd = fCurrAngle + fSlicePct;
            if (fCurrAngle == 0.125) {
                fCurrAngle += 1.0E-12;
            }
            if (fCurrAngle == 0.375) {
                fCurrAngle -= 1.0E-12;
            }
            if (fCurrAngle == 0.625) {
                fCurrAngle -= 1.0E-12;
            }
            if (fCurrAngle == 0.875) {
                fCurrAngle -= 1.0E-12;
            }
            double fDist = fSliceEnd - fCurrAngle;
            double fAngleStart = fCurrAngle - Math.floor(fCurrAngle);
            double fAngleEnd = fSliceEnd - Math.floor(fSliceEnd);
            double fAngleAvg = fAngleStart + fDist / 2.0;
            fAngleAvg -= Math.floor(fAngleAvg);
            String slabel = this.getLabel(s, g, fValue, fSlicePct);
            this.m_vectStrLabels.addElement(slabel);
            int labelWidth = this.m_Perspective.getFontMetricsResolver().stringWidth(slabel, fm);
            if (labelWidth > this.m_maxLabelWidthDest) {
                this.m_maxLabelWidthDest = labelWidth;
            }
            if ((double)slabel.length() > this.m_maxStrLength) {
                this.m_maxStrLength = slabel.length();
            }
            if (this.m_stringWidths.length <= nSeriesCount) {
                int[] newArray = new int[this.m_stringWidths.length * 2];
                System.arraycopy(this.m_stringWidths, 0, newArray, 0, this.m_stringWidths.length);
                this.m_stringWidths = newArray;
            }
            this.m_stringWidths[nSeriesCount] = labelWidth;
            if (fAngleAvg < 0.08 || fAngleAvg > 0.92 || fAngleAvg > 0.42 && fAngleAvg < 0.58) {
                this.m_bLabelsAtTopOrBottom = true;
            }
            if (firstAngle < 0.0) {
                firstAngle = fAngleAvg;
            }
            if (!(sliceDeleted = this.m_bSmallDataSet ? this.m_Perspective.getPieSliceDelete(s) || this.m_Perspective.getPieSliceDelete(s, g) : false)) {
                if (fAngleAvg > 0.0 && fAngleAvg <= 0.5) {
                    if (fAngleAvg < firstAngle) {
                        this.m_rightSliceLabels.insertElementAt(slabel, rightInsertPos++);
                    } else {
                        this.m_rightSliceLabels.addElement(slabel);
                    }
                } else if (fAngleAvg < firstAngle) {
                    this.m_leftSliceLabels.insertElementAt(slabel, leftInsertPos++);
                } else {
                    this.m_leftSliceLabels.addElement(slabel);
                }
            }
        }
        this.m_fullSliceLabels = new String[this.m_vectStrLabels.size()];
    }

    public String getLabel(int s, int g, double fValue, double fSlicePct) {
        String str;
        switch (this.m_bPieLabelDisplay) {
            case 0: {
                if (this.m_Perspective.isNumberFormatCallBack()) {
                    this.m_Perspective.getNumberFormatCallBack().setState(1, s, g, -1, -3);
                    str = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                    break;
                }
                str = TDGNumberFormat.toString(this.m_Perspective, this.m_nFeelerTextFormat, fValue, this.m_strFeelerTextFormatPattern);
                break;
            }
            case 1: {
                if (this.m_Perspective.isNumberFormatCallBack()) {
                    this.m_Perspective.getNumberFormatCallBack().setState(1, s, g, -1, -3);
                    str = this.m_Perspective.getNumberFormatCallBack().toString(fSlicePct);
                    break;
                }
                str = TDGNumberFormat.toString(this.m_Perspective, this.m_nFeelerTextFormat, fSlicePct, this.m_strFeelerTextFormatPattern);
                break;
            }
            case 2: {
                if (s == -1) {
                    str = "Other";
                    break;
                }
                str = this.m_Perspective.getSeriesLabel(s);
                break;
            }
            case 3: {
                str = s == -1 ? "Other" : this.m_Perspective.getSeriesLabel(s);
                if (this.m_Perspective.isNumberFormatCallBack()) {
                    this.m_Perspective.getNumberFormatCallBack().setState(1, s, g, -1, -3);
                    str = str + ", " + this.m_Perspective.getNumberFormatCallBack().toString(fSlicePct);
                    break;
                }
                str = str + " (" + TDGNumberFormat.toString(this.m_Perspective, this.m_nFeelerTextFormat, fSlicePct, this.m_strFeelerTextFormatPattern) + ")";
                break;
            }
            default: {
                str = "!";
                break;
            }
        }
        return str;
    }

    private int calcPieLabelHeight() {
        IdentObj id;
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        GroupsEnumerator gEnumRev = this.getResetGroupsEnumerator(false);
        int group = 0;
        int g = gEnum.getAbsoluteGroup(group);
        int gReverse = this.m_bReverseGroups ? gEnumRev.getAbsoluteGroup(group) : g;
        Dimension dimTitleVC = new Dimension(0, 0);
        String szPieLabel = null;
        szPieLabel = this.m_gt.isPieBarType() ? (this.m_Perspective.getPieBarLabelDisplay() ? this.m_Perspective.getPieBarLabelString() : "") : this.m_Perspective.getGroupLabel(gReverse);
        if (!(this.m_bGTMultiple || szPieLabel != null && szPieLabel.length() > 0)) {
            return 0;
        }
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(296);
            id.setMiscID(gReverse);
        } else {
            id = new IdentObj(296, -3, gReverse);
        }
        boolean bPieGroupLabelFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
        this.m_pieLabelTextStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bPieGroupLabelFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), this.m_Perspective.getAutofit(id), false, this.m_Perspective.getTextWrap(id));
        Graphics graphics = this.m_Perspective.getGraphicsContext();
        Font font = this.m_pieLabelTextStyleObj.getFont(this.m_VC);
        FontMetrics fm = graphics.getFontMetrics(font);
        dimTitleVC.height = this.m_VC.destToVirtHeight(TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver()) + 5);
        return dimTitleVC.height;
    }

    public void createFrame() {
        this.m_Frame = new PieFrameObj(this.m_Perspective);
    }

    protected void calcFeelerLabels(int group) {
        double fMaxStrLength = 1.0;
        if (this.m_bGTMultiple) {
            FontMetrics fm = this.getSliceLabelFontMetrics();
            this.getSliceLabels(group, fm);
        }
        FontMetrics fm = this.getSliceLabelFontMetrics();
        int fontHeight = TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver());
        this.m_labelDimVC = new Dimension(this.m_VC.destToVirtWidth(this.m_maxLabelWidthDest), this.m_VC.destToVirtHeight(fontHeight));
    }

    protected void createFeelerTextStyle() {
        IdentObj idFeeler = this.m_Perspective.getPieSliceLabel();
        this.m_textStyleFeelers = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(idFeeler), this.m_Perspective.getFontStyle(idFeeler), this.m_Perspective.getFontSizeAbsolute(idFeeler), this.m_Perspective.getFontSize(idFeeler), this.m_Perspective.getFontSizeVC(idFeeler), 0, 0, this.m_Perspective.getTextJustVert(idFeeler), false, false, this.m_Perspective.getTextWrap(idFeeler));
    }

    protected void copyParams() {
        super.copyParams();
        this.m_bGTHasRing = this.m_gt.toString().equals("PIE_RING") || this.m_gt.toString().equals("PIE_RINGMULT") || this.m_gt.toString().equals("PIE_RINGMULTPROP") || this.m_gt.toString().equals("PIE_BAR_RING");
        this.m_bGTProportional = this.m_gt.toString().equals("PIE_MULTPROP") || this.m_gt.toString().equals("PIE_RINGMULTPROP");
        boolean bl = this.m_bGTMultiple = this.m_bGTProportional || this.m_gt.toString().equals("PIE_MULT") || this.m_gt.toString().equals("PIE_RINGMULT");
        if (!this.m_bSmallDataSet && !this.m_bGTMultiple) {
            this.m_bSmallDataSet = this.m_nSeries < 899;
        }
        this.m_nKissingFeelers = 1;
        this.m_fThickness = (double)this.m_Perspective.getPieDepth() / 100.0;
        this.m_bShowPieTotal = this.m_Perspective.getPieRingTotalDisplay();
        this.m_nPiesPerRow = this.m_Perspective.getPiesPerRow();
        this.m_fPieTilt = (double)this.m_Perspective.getPieTilt() / 100.0;
        this.m_nPieFeelerTextDisplay = this.m_Perspective.getPieFeelerTextDisplay();
        this.m_bSliceLabelVisibility = this.m_Perspective.getDisplay(this.m_Perspective.getPieSliceLabel());
        this.m_bPieLabelDisplay = this.m_Perspective.getPieLabelDisplay();
        this.m_bReverseGroups = this.m_Perspective.getReverseGroups();
        this.m_nFeelerTextFormat = this.m_Perspective.getPieFeelerTextFormat();
        this.m_strFeelerTextFormatPattern = this.m_Perspective.getPieFeelerTextFormatPattern();
        this.m_fRingPct = this.m_bGTHasRing ? (double)this.m_Perspective.getPieRingSize() / 100.0 : 0.0;
        this.m_nLineWidthFeeler = this.m_Perspective.getLineWidth(this.m_Perspective.getPieFeelerLine());
        this.m_nLineStyleFeeler = this.m_Perspective.getLineStyle(this.m_Perspective.getPieFeelerLine());
        this.m_rOPI_PieFrame = this.m_Perspective.getRect(new IdentObj(302));
        this.m_nPieBarSlice = this.m_Perspective.getPieBarSeries();
        PfjAssert.pfjAssert(this.m_nPieBarSlice >= 0);
        if (this.m_nPieBarSlice >= this.m_nTotalSeries) {
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
            this.m_nPieBarSlice = sEnum.getFirstSeries();
            this.m_Perspective.setPieBarSeries(this.m_nPieBarSlice);
        }
    }

    protected Polygon createTopPoly(PieSliceObj theSlice) {
        double diff;
        Polygon poly = new Polygon();
        int nPoints = theSlice.m_polyCrust.npoints;
        poly.addPoint(theSlice.m_ptRingLeft.x, theSlice.m_ptRingLeft.y);
        int i = 0;
        while (i < nPoints) {
            poly.addPoint(theSlice.m_polyCrust.xpoints[i], theSlice.m_polyCrust.ypoints[i]);
            ++i;
        }
        if (theSlice.m_nSeriesID == this.m_nPieBarSlice) {
            this.m_ptTopSlice = new Point(theSlice.m_polyCrust.xpoints[0], theSlice.m_polyCrust.ypoints[0]);
            this.m_ptBottomSlice = new Point(theSlice.m_polyCrust.xpoints[nPoints - 1], theSlice.m_polyCrust.ypoints[nPoints - 1]);
        }
        poly.addPoint(theSlice.m_ptRingRight.x, theSlice.m_ptRingRight.y);
        if (theSlice.m_polyRing != null) {
            i = nPoints - 2;
            while (i >= 0) {
                poly.addPoint(theSlice.m_polyRing.xpoints[i], theSlice.m_polyRing.ypoints[i]);
                --i;
            }
            return poly;
        }
        Point pt = this.m_VC.virtToDest(theSlice.m_ptTip);
        Arc2D.Double arc = new Arc2D.Double();
        double startAngle = 360.0 - theSlice.m_fAngleEnd * 360.0 + 90.0;
        if (startAngle > 360.0) {
            startAngle -= 360.0;
        }
        if (theSlice.m_fAngleEnd == 0.0) {
            diff = 360.0 - theSlice.m_fAngleStart * 360.0;
        }
        diff = theSlice.m_fPiePct == 1.0 ? 360.0 - theSlice.m_fAngleStart * 360.0 + theSlice.m_fAngleEnd * 360.0 : (theSlice.m_fAngleEnd > theSlice.m_fAngleStart ? theSlice.m_fAngleEnd * 360.0 - theSlice.m_fAngleStart * 360.0 : 360.0 - theSlice.m_fAngleStart * 360.0 + theSlice.m_fAngleEnd * 360.0);
        double cornerX = (double)pt.x - this.m_xRadius;
        double cornerY = (double)pt.y - this.m_yRadius;
        double width = this.m_xRadius * 2.0;
        double height = this.m_yRadius * 2.0;
        ((Arc2D)arc).setArc(cornerX, cornerY, width, height, startAngle, diff, 2);
        this.m_arc2D = arc;
        return poly;
    }

    protected GeneralPath convertShapeToPath(Shape shape, Shape shape2) {
        PathIterator pi;
        PathIterator pi2;
        GeneralPath path = new GeneralPath();
        double x = 0.0;
        double y = 0.0;
        if (shape != null && (pi2 = shape.getPathIterator(null)) != null) {
            while (!pi2.isDone()) {
                double[] coords = new double[6];
                int type = pi2.currentSegment(coords);
                switch (type) {
                    case 0: {
                        path.moveTo((float)coords[0], (float)coords[1]);
                        x = coords[0];
                        y = coords[1];
                        break;
                    }
                    case 3: {
                        path.curveTo((float)coords[0], (float)coords[1], (float)coords[2], (float)coords[3], (float)coords[4], (float)coords[5]);
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                pi2.next();
            }
        }
        if ((pi = ReversePathIterator.getReversePathIterator(shape2)) != null) {
            while (!pi.isDone()) {
                double[] coords = new double[6];
                int type = pi.currentSegment(coords);
                switch (type) {
                    case 0: {
                        path.lineTo((float)coords[0], (float)coords[1]);
                        break;
                    }
                    case 3: {
                        path.curveTo((float)coords[0], (float)coords[1], (float)coords[2], (float)coords[3], (float)coords[4], (float)coords[5]);
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                pi.next();
            }
        }
        path.lineTo((float)x, (float)y);
        return path;
    }

    protected Polygon createCrustPoly(PieSliceObj theSlice) {
        double diff;
        Polygon poly = new Polygon();
        int nPoints = theSlice.m_polyCrust.npoints;
        int i = 0;
        while (i < nPoints) {
            if (theSlice.m_bSliceSplit) {
                if (theSlice.m_ptCenter.y < theSlice.m_ptTip.y) {
                    poly.addPoint(theSlice.m_polyCrust.xpoints[i], theSlice.m_polyCrust.ypoints[i]);
                } else {
                    poly.addPoint(theSlice.m_polyCrust.xpoints[i], theSlice.m_polyCrust.ypoints[i]);
                }
            } else {
                poly.addPoint(theSlice.m_polyCrust.xpoints[i], theSlice.m_polyCrust.ypoints[i]);
            }
            ++i;
        }
        i = nPoints - 1;
        while (i >= 0) {
            poly.addPoint(theSlice.m_polyCrust.xpoints[i], theSlice.m_polyCrust.ypoints[i] - this.m_nThickOffset);
            --i;
        }
        poly.addPoint(theSlice.m_polyCrust.xpoints[0], theSlice.m_polyCrust.ypoints[0]);
        if (theSlice.m_polyRing != null) {
            return poly;
        }
        Point pt = this.m_VC.virtToDest(theSlice.m_ptTip);
        Arc2D.Double arc = new Arc2D.Double();
        double startAngle = 360.0 - theSlice.m_fAngleEnd * 360.0 + 90.0;
        if (startAngle > 360.0) {
            startAngle -= 360.0;
        }
        if (theSlice.m_fAngleEnd == 0.0) {
            diff = 360.0 - theSlice.m_fAngleStart * 360.0;
        }
        diff = theSlice.m_fPiePct == 1.0 ? 360.0 - theSlice.m_fAngleStart * 360.0 + theSlice.m_fAngleEnd * 360.0 : (theSlice.m_fAngleEnd > theSlice.m_fAngleStart ? theSlice.m_fAngleEnd * 360.0 - theSlice.m_fAngleStart * 360.0 : 360.0 - theSlice.m_fAngleStart * 360.0 + theSlice.m_fAngleEnd * 360.0);
        double cornerX = (double)pt.x - this.m_xRadius;
        double cornerY = (double)pt.y - this.m_yRadius;
        double width = this.m_xRadius * 2.0;
        double height = this.m_yRadius * 2.0;
        ((Arc2D)arc).setArc(cornerX, cornerY, width, height, startAngle, diff, 0);
        Arc2D.Double arc3D = new Arc2D.Double();
        ((Arc2D)arc3D).setArc(cornerX, cornerY + (double)this.m_VC.virtToDestHeight(this.m_nThickOffset), width, height, startAngle, diff, 0);
        GeneralPath topPath = null;
        topPath = this.convertShapeToPath(arc, arc3D);
        this.m_area = topPath != null ? new Area(topPath) : null;
        return poly;
    }

    protected Polygon createLeftPoly(PieSliceObj theSlice) {
        Polygon poly = new Polygon();
        poly.addPoint(theSlice.m_ptCrustLeft.x, theSlice.m_ptCrustLeft.y);
        poly.addPoint(theSlice.m_ptRingLeft.x, theSlice.m_ptRingLeft.y);
        poly.addPoint(theSlice.m_ptRingLeft.x, theSlice.m_ptRingLeft.y - this.m_nThickOffset);
        poly.addPoint(theSlice.m_ptCrustLeft.x, theSlice.m_ptCrustLeft.y - this.m_nThickOffset);
        poly.addPoint(theSlice.m_ptCrustLeft.x, theSlice.m_ptCrustLeft.y);
        return poly;
    }

    protected Polygon createRightPoly(PieSliceObj theSlice) {
        Polygon poly = new Polygon();
        poly.addPoint(theSlice.m_ptRingRight.x, theSlice.m_ptRingRight.y);
        poly.addPoint(theSlice.m_ptCrustRight.x, theSlice.m_ptCrustRight.y);
        poly.addPoint(theSlice.m_ptCrustRight.x, theSlice.m_ptCrustRight.y - this.m_nThickOffset);
        poly.addPoint(theSlice.m_ptRingRight.x, theSlice.m_ptRingRight.y - this.m_nThickOffset);
        return poly;
    }

    protected Polygon createRingPoly(PieSliceObj theSlice) {
        Polygon poly = new Polygon();
        int nPoints = theSlice.m_polyRing.npoints;
        int i = 0;
        while (i < nPoints) {
            if (theSlice.m_bSliceSplit) {
                if (theSlice.m_ptCenter.y < theSlice.m_ptTip.y) {
                    poly.addPoint(theSlice.m_polyRing.xpoints[i], theSlice.m_polyRing.ypoints[i] - 100);
                } else {
                    poly.addPoint(theSlice.m_polyRing.xpoints[i], theSlice.m_polyRing.ypoints[i] + 100);
                }
            } else {
                poly.addPoint(theSlice.m_polyRing.xpoints[i], theSlice.m_polyRing.ypoints[i]);
            }
            ++i;
        }
        i = nPoints - 1;
        while (i >= 0) {
            poly.addPoint(theSlice.m_polyRing.xpoints[i], theSlice.m_polyRing.ypoints[i] - this.m_nThickOffset);
            --i;
        }
        poly.addPoint(theSlice.m_polyRing.xpoints[0], theSlice.m_polyRing.ypoints[0]);
        return poly;
    }

    protected PieSliceObj createSliceObj(int nCenterX, int nCenterY, int nRadius, double fStart, double fEnd, int nDetatch, double fAngleDet, double fTilt, double fRing) {
        double fAngle;
        PieSliceObj theSlice = new PieSliceObj();
        double fXSquashRatio = 1.0;
        MinMaxObj m_minmax_y = new MinMaxObj();
        Rectangle destRect = this.m_VC.getDestCoords();
        double fYSquashRatio = Math.abs((double)destRect.width) / (double)destRect.height;
        if (fYSquashRatio > 1.0) {
            fXSquashRatio = 1.0 / fYSquashRatio;
            fYSquashRatio = 1.0;
        }
        fYSquashRatio -= fYSquashRatio * fTilt;
        this.m_xRadius = this.m_VC.virtToDestWidth((double)nRadius * fXSquashRatio);
        this.m_yRadius = this.m_VC.virtToDestHeight((double)nRadius * fYSquashRatio);
        if (fStart == 0.125) {
            fStart += 1.0E-12;
        }
        if (fStart == 0.375) {
            fStart -= 1.0E-12;
        }
        if (fStart == 0.625) {
            fStart -= 1.0E-12;
        }
        if (fStart == 0.875) {
            fStart -= 1.0E-12;
        }
        int nTipX = nCenterX;
        int nTipY = nCenterY;
        double fDist = fEnd - fStart;
        double f12OClock = -1.5707963267948966;
        theSlice.m_bSliceSplit = false;
        theSlice.m_fAngleStart = fStart - Math.floor(fStart);
        theSlice.m_fAngleEnd = fEnd - Math.floor(fEnd);
        theSlice.m_fAngleAvg = fStart + fDist / 2.0;
        theSlice.m_fAngleAvg -= Math.floor(theSlice.m_fAngleAvg);
        if (theSlice.m_fAngleStart == theSlice.m_fAngleEnd) {
            if (theSlice.m_fAngleStart == 0.0) {
                theSlice.m_fAngleEnd = 0.75;
            } else if (theSlice.m_fAngleStart == 0.75) {
                theSlice.m_fAngleStart = 0.0;
            }
        }
        this.calcSlicePositionAndOrient(theSlice);
        theSlice.m_nDetatch = nDetatch;
        if (nDetatch > 0) {
            fAngle = fAngleDet == -7.0 ? f12OClock + (fStart + fDist / 2.0) * (Math.PI * 2) : fAngleDet;
            theSlice.m_fAngleDet = fAngle;
            nTipX = nCenterX + (int)(Math.cos(fAngle) * fXSquashRatio * (double)nDetatch);
            nTipY = nCenterY - (int)(Math.sin(fAngle) * fYSquashRatio * (double)nDetatch);
        }
        theSlice.m_polyCrust = new Polygon();
        theSlice.m_polyRing = fRing > 0.0 ? new Polygon() : null;
        theSlice.m_ptTip = new Point(nTipX, nTipY);
        m_minmax_y.testRawValue(nTipY);
        fAngle = f12OClock + theSlice.m_fAngleAvg * (Math.PI * 2);
        this.calcFeelerPoints(theSlice, m_minmax_y, nTipX, nTipY, nRadius, fAngle, fRing, fXSquashRatio, fYSquashRatio);
        this.calcLeftAndRightMostPoints(nCenterX, nCenterY, nRadius, f12OClock, nDetatch, fXSquashRatio, fYSquashRatio);
        this.calcArcPoints(theSlice, m_minmax_y, nTipX, nTipY, f12OClock, fStart, fEnd, nRadius, fRing, fXSquashRatio, fYSquashRatio);
        theSlice.m_fHighestY = m_minmax_y.getRawMax();
        theSlice.m_fLowestY = m_minmax_y.getRawMin();
        return theSlice;
    }

    protected Point[] calcArcPointsForTestPolygon() {
        Point[] points = new Point[100];
        double fPos = 0.0;
        double fXSquashRatio = 1.0;
        double fTilt = this.m_fPieTilt;
        Rectangle destRect = this.m_VC.getDestCoords();
        double fYSquashRatio = Math.abs((double)destRect.width) / (double)destRect.height;
        if (fYSquashRatio > 1.0) {
            fXSquashRatio = 1.0 / fYSquashRatio;
            fYSquashRatio = 1.0;
        }
        fYSquashRatio -= fYSquashRatio * fTilt;
        double f12OClock = -1.5707963267948966;
        int i = 0;
        while (i < 100) {
            double fAngle = f12OClock + fPos * (Math.PI * 2);
            int nPosX = this.m_nXCenter + (int)Math.rint(Math.cos(fAngle) * fXSquashRatio * (double)this.m_nRadius);
            int nPosY = this.m_nYCenter - (int)(Math.sin(fAngle) * fYSquashRatio * (double)this.m_nRadius);
            if (this.m_nThickOffset > 0 && fPos > 0.25 && fPos < 0.75) {
                nPosY -= this.m_nThickOffset;
            }
            points[i] = new Point(nPosX, nPosY);
            fPos += 0.01;
            ++i;
        }
        return points;
    }

    protected void calcArcPoints(PieSliceObj theSlice, MinMaxObj m_minmax_y, int nCenterX, int nCenterY, double f12OClock, double fStart, double fEnd, double fRadius, double fRing, double fXSquashRatio, double fYSquashRatio) {
        int nPosY;
        int nPosX;
        double fAngle;
        double fArcLength = fEnd - fStart;
        double fNumPixelsInArc = this.getNumPixelsInArc(nCenterX, nCenterY, f12OClock, fStart, fEnd, fRadius);
        double fNumPixelsPerArcSegment = 1.0 / this.m_Perspective.getNumPieArcSegmentsPerPixel();
        double fSegmentArcInc = fNumPixelsPerArcSegment / fNumPixelsInArc * fArcLength;
        double fPos = fStart;
        while (fPos < fEnd) {
            fAngle = f12OClock + fPos * (Math.PI * 2);
            nPosX = nCenterX + (int)Math.rint(Math.cos(fAngle) * fXSquashRatio * fRadius);
            nPosY = nCenterY - (int)(Math.sin(fAngle) * fYSquashRatio * fRadius);
            theSlice.m_polyCrust.addPoint(nPosX, nPosY);
            m_minmax_y.testRawValue(nPosY);
            if (fRing > 0.0) {
                nPosX = nCenterX + (int)Math.rint(Math.cos(fAngle) * fXSquashRatio * (fRadius * fRing));
                nPosY = nCenterY - (int)(Math.sin(fAngle) * fYSquashRatio * (fRadius * fRing));
                theSlice.m_polyRing.addPoint(nPosX, nPosY);
                m_minmax_y.testRawValue(nPosY);
            }
            fPos += fSegmentArcInc;
        }
        fAngle = f12OClock + fEnd * (Math.PI * 2);
        nPosX = nCenterX + (int)(Math.cos(fAngle) * fXSquashRatio * fRadius);
        nPosY = nCenterY - (int)(Math.sin(fAngle) * fYSquashRatio * fRadius);
        theSlice.m_polyCrust.addPoint(nPosX, nPosY);
        m_minmax_y.testRawValue(nPosY);
        if (fRing > 0.0) {
            nPosX = nCenterX + (int)(Math.cos(fAngle) * fXSquashRatio * (fRadius * fRing));
            nPosY = nCenterY - (int)(Math.sin(fAngle) * fYSquashRatio * (fRadius * fRing));
            theSlice.m_polyRing.addPoint(nPosX, nPosY);
            m_minmax_y.testRawValue(nPosY);
        }
        int nLastPoint = theSlice.m_polyCrust.npoints - 1;
        theSlice.m_ptCrustLeft = new Point(theSlice.m_polyCrust.xpoints[0], theSlice.m_polyCrust.ypoints[0]);
        theSlice.m_ptCrustRight = new Point(theSlice.m_polyCrust.xpoints[nLastPoint], theSlice.m_polyCrust.ypoints[nLastPoint]);
        if (fRing > 0.0) {
            theSlice.m_ptRingLeft = new Point(theSlice.m_polyRing.xpoints[0], theSlice.m_polyRing.ypoints[0]);
            theSlice.m_ptRingRight = new Point(theSlice.m_polyRing.xpoints[nLastPoint], theSlice.m_polyRing.ypoints[nLastPoint]);
        } else {
            theSlice.m_ptRingLeft = new Point(nCenterX, nCenterY);
            theSlice.m_ptRingRight = new Point(nCenterX, nCenterY);
        }
    }

    public double getNumPixelsInArc(int nCenterX, int nCenterY, double f12OClock, double fStart, double fEnd, double fRadius) {
        return this.getNumPixelsInArc(this.m_VC, nCenterX, nCenterY, f12OClock, fStart, fEnd, fRadius, -1.0, -1.0);
    }

    protected void calcFeelerPoints(PieSliceObj theSlice, MinMaxObj m_minmax_y, int nTipX, int nTipY, double fRadius, double fAngle, double fRing, double fXSquashRatio, double fYSquashRatio) {
        double fAttach;
        int nPosY;
        int nPosX;
        if (this.m_nKissingFeelers == 1) {
            nPosX = nTipX + (int)Math.rint(Math.cos(fAngle) * fXSquashRatio * fRadius);
            nPosY = nTipY - (int)(Math.sin(fAngle) * fYSquashRatio * fRadius);
            theSlice.m_ptCenter = new Point(nPosX, nPosY);
        } else {
            fAttach = fRadius * (fRing + (1.0 - fRing) / 1.5);
            nPosX = nTipX + (int)(Math.cos(fAngle) * fXSquashRatio * fAttach);
            nPosY = nTipY - (int)(Math.sin(fAngle) * fYSquashRatio * fAttach);
            theSlice.m_ptCenter = new Point(nPosX, nPosY);
            m_minmax_y.testRawValue(nPosY);
        }
        double fBloom = 0.25 - Math.abs(0.5 - theSlice.m_fAngleAvg);
        if (fBloom < 0.0) {
            fBloom = 0.0;
        }
        fBloom *= 4.0;
        double fExtend = 0.125;
        if (theSlice.m_fAngleAvg > 0.125 && theSlice.m_fAngleAvg < 0.375) {
            fExtend *= Math.abs(0.25 - theSlice.m_fAngleAvg) / 0.125;
        } else if (theSlice.m_fAngleAvg > 0.625 && theSlice.m_fAngleAvg < 0.875) {
            fExtend *= Math.abs(0.75 - theSlice.m_fAngleAvg) / 0.125;
        }
        fAttach = fRadius + fRadius * (fExtend + fBloom * (0.3 * this.m_fThickness + 0.5 * this.m_fPieTilt));
        nPosX = nTipX + (int)(Math.cos(fAngle) * fXSquashRatio * fAttach);
        nPosY = nTipY - (int)(Math.sin(fAngle) * fYSquashRatio * fAttach);
        theSlice.m_ptFeelerJoint = new Point(nPosX, nPosY);
        m_minmax_y.testRawValue(nPosY);
    }

    protected void calcLeftAndRightMostPoints(int nCenterX, int nCenterY, double fRadius, double f12OClock, int nDetatch, double fXSquashRatio, double fYSquashRatio) {
        int leftMostPointOfPie;
        double fAngle;
        int nTipX;
        int rightMostPointOfPie;
        if (nDetatch > 0) {
            this.m_DetachPresent = true;
        }
        if ((rightMostPointOfPie = (nTipX = nCenterX + (int)(Math.cos(fAngle = f12OClock + 1.5707963267948966) * fXSquashRatio * (double)nDetatch)) + (int)Math.rint(Math.cos(fAngle) * fXSquashRatio * fRadius)) > this.m_rightMostPointOfPie) {
            this.m_rightMostPointOfPie = rightMostPointOfPie;
        }
        if ((leftMostPointOfPie = (nTipX = nCenterX + (int)(Math.cos(fAngle = f12OClock + 4.71238898038469) * fXSquashRatio * (double)nDetatch)) + (int)Math.rint(Math.cos(fAngle) * fXSquashRatio * fRadius)) < this.m_leftMostPointOfPie) {
            this.m_leftMostPointOfPie = leftMostPointOfPie;
        }
    }

    protected void calcSlicePositionAndOrient(PieSliceObj theSlice) {
        theSlice.m_nSliceSide = theSlice.m_fAngleAvg > 0.0 && theSlice.m_fAngleAvg <= 0.5 ? 1 : 0;
    }

    protected double drawPie(Rectangle rcPieFrame, int nPieGroupRel) {
        this.m_leftMostPointOfPie = 50000;
        this.m_rightMostPointOfPie = -50000;
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        GroupsEnumerator gEnumRev = this.getResetGroupsEnumerator(false);
        int g = gEnum.getAbsoluteGroup(nPieGroupRel);
        this.m_nXCenter = this.m_rPieFrame.x + this.m_rPieFrame.width / 2;
        this.m_nYCenter = this.m_rPieFrame.y + this.m_nPieLabelHeight + (this.m_rPieFrame.height - this.m_nPieLabelHeight) / 2;
        if (this.m_gt.isPieBarType() && this.isPieBarSliceOK()) {
            this.m_nXCenter = this.m_rPieFrame.x + this.m_rPieFrame.width * 9 / 20;
        }
        this.m_sliceLabelLeftEdge = this.m_rPieFrame.x + this.m_virtMarginWidth;
        this.m_sliceLabelRightEdge = this.m_rPieFrame.x + (this.m_nXCenter - this.m_rPieFrame.x) * 2 - this.m_virtMarginWidth;
        this.m_nThickOffset = (int)(this.m_fThickness * (double)(this.m_rPieFrame.height / 10));
        this.m_slices = new PieSliceObj[this.m_nTotalSeries + 5];
        if (this.m_gt.isPieBarType()) {
            this.m_fHighestGroupTotal = this.m_fPieTotal = this.getSumTotal();
        } else {
            this.m_fPieTotal = this.getGroupTotal(g);
        }
        if (this.m_fPieTotal > 0.0) {
            if (this.m_bGTProportional && this.m_fHighestGroupTotal > 0.0) {
                double fPct = this.m_fPieTotal / this.m_fHighestGroupTotal;
                this.m_nRadius = (int)((double)this.m_nSaveRadius * fPct);
            }
            int radius = 0;
            Rectangle r = this.m_VC.getDestCoords();
            radius = r.width < r.height ? this.m_VC.virtToDestWidth(this.m_nRadius) : this.m_VC.virtToDestHeight(this.m_nRadius);
            int side = radius * 2;
            int x = this.m_VC.virtToDestX(this.m_nXCenter) - radius;
            int y = this.m_VC.virtToDestY(this.m_nYCenter) - radius;
            this.m_boundingRects.add(new Rectangle(x, y, side, side));
            int gradientSide = (int)((double)side * 1.34);
            int gradientX = this.m_VC.virtToDestX(this.m_nXCenter) - gradientSide / 2;
            int gradientY = this.m_VC.virtToDestY(this.m_nYCenter) - gradientSide / 2 + (int)((double)(side / 2) * 0.5);
            Polygon gradientPoly = new Polygon();
            gradientPoly.addPoint(gradientX, gradientY);
            gradientPoly.addPoint(gradientX + gradientSide, gradientY);
            gradientPoly.addPoint(gradientX + gradientSide, gradientY + gradientSide);
            gradientPoly.addPoint(gradientX, gradientY + gradientSide);
            Ellipse2D.Double outer = new Ellipse2D.Double(gradientX, gradientY, gradientSide, gradientSide);
            Ellipse2D.Double inner = new Ellipse2D.Double(x, y, side, side);
            Area gradientArea = new Area(outer);
            gradientArea.intersect(new Area(inner));
            if (this.m_Perspective.getPieDepth() == 0 && this.m_Perspective.getVisualEffects() != 0) {
                if (this.m_Perspective.isExportingToXML()) {
                    x = this.m_VC.virtToDestX(this.m_nXCenter) - --side / 2;
                    y = this.m_VC.virtToDestY(this.m_nYCenter) - side / 2;
                    IdentObj id = new IdentObj(338);
                    BlackBoxObj bb = new BlackBoxObj(this.m_Perspective, id);
                    Rectangle rr = new Rectangle(this.m_VC.destToVirtX(x), this.m_VC.destToVirtY(y + side), this.m_VC.destToVirtWidth(side), this.m_VC.destToVirtHeight(side));
                    DetOval pieGlow = new DetOval(this.m_Perspective.getDetectiv(), id, rr, bb, rr);
                    HashMap<String, Serializable> glow = new HashMap<String, Serializable>();
                    glow.put("glowColor", new Color(PresUtils.hexStringWithAlphaToInt("#FF93A4BD"), true));
                    glow.put("glowBlurX", new Double(65.0));
                    glow.put("glowBlurY", new Double(65.0));
                    glow.put("glowKnockout", new Integer(1));
                    pieGlow.setVisualEffectsMap(glow);
                } else if (!this.m_Perspective.isExportingToSVG()) {
                    IdentObj id = new IdentObj(337);
                    int glowRectSide = (int)((double)side * Math.sqrt(2.0));
                    x = this.m_VC.virtToDestX(this.m_nXCenter) - glowRectSide / 2;
                    y = this.m_VC.virtToDestY(this.m_nYCenter) - glowRectSide / 2;
                    double pin1 = (double)side / (double)glowRectSide - 0.25;
                    this.m_Perspective.setGradientPinPosition(id, pin1, 1);
                    this.m_Perspective.setGradientPinPosition(id, pin1 + 0.2, 2);
                    BlackBoxObj bb = new BlackBoxObj(this.m_Perspective, id);
                    new DetRect(this.m_Perspective.getDetectiv(), id, this.m_VC.destToVirtX(x), this.m_VC.destToVirtY(y + glowRectSide), this.m_VC.destToVirtWidth(glowRectSide), this.m_VC.destToVirtHeight(glowRectSide), bb, false, false);
                }
            }
            this.createSliceObjects(g);
            if (this.m_bSliceLabelVisibility) {
                this.calcFeelerLabels(g);
            }
            this.sortSlicesBackToFront();
            if (this.m_nThickOffset == 0) {
                this.drawAllSliceTops();
            } else {
                this.drawSlices();
                this.drawAllSliceTops();
            }
            if (gradientPoly != null && this.m_Perspective.isExportingToXML() && this.m_Perspective.getPieDepth() == 0) {
                IdentObj id = new IdentObj(339);
                this.m_Perspective.setGradientNumPins(id, 3);
                this.m_Perspective.setGradientPinPosition(id, 0.0, 0);
                this.m_Perspective.setGradientPinPosition(id, 0.18, 1);
                this.m_Perspective.setGradientPinPosition(id, 1.0, 2);
                Color[] color = new Color[]{new Color(255, 255, 255, 100), new Color(255, 255, 255, 80), new Color(108, 118, 128, 0)};
                int i = 0;
                while (i < 3) {
                    this.m_Perspective.setGradientPinRightColor(id, color[i], i);
                    this.m_Perspective.setGradientPinLeftColor(id, color[i], i);
                    ++i;
                }
                BlackBoxObj gb = new BlackBoxObj(this.m_Perspective, id);
                new DetPolygon(this.m_Perspective.getDetectiv(), id, this.m_VC.destToVirt(gradientPoly), (BlackBoxIF)gb, 1.0, false, gradientArea);
            }
            this.drawAllSliceLabels();
            int gReverse = this.m_bReverseGroups ? gEnumRev.getAbsoluteGroup(nPieGroupRel) : g;
            if (this.m_bShowPieTotal && this.m_bGTHasRing) {
                this.drawRingLabel(gReverse);
            }
            if (this.m_Perspective.getDisplay(296)) {
                this.drawPieGroupLabel(gReverse);
            }
        }
        return this.m_fPieTotal;
    }

    protected void createSliceObjects(int g) {
        double fSliceEnd;
        double fSlicePct;
        int nDetach;
        double fDetach;
        double fValue;
        int s;
        double fOtherPct = 0.0;
        boolean bOtherSeries = this.m_Perspective.getOtherSeries();
        boolean nTotalSeriesCount = false;
        double fOtherPercentage = this.m_Perspective.getOtherPercentage() / 100.0;
        double fCurrAngle = this.getPieRotation();
        this.m_nSliceCount = 0;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasMoreElements()) {
            s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            fValue = this.m_gt.isPieBarType() ? this.getSeriesTotal(s) : this.getDataValue((int)s, (int)g).m_fValue;
            if (fValue > 0.0) {
                fDetach = this.m_bSmallDataSet ? (double)this.m_Perspective.getPieSliceDetach(s, g) / 100.0 : 0.0;
                nDetach = (int)(fDetach * 1500.0);
                fSlicePct = fValue / this.m_fPieTotal;
                if (bOtherSeries && fSlicePct < fOtherPercentage) {
                    fOtherPct += fSlicePct;
                    this.setSeriesPartOfOther(s, g, true);
                    continue;
                }
                fSliceEnd = fCurrAngle + fSlicePct;
                this.m_slices[this.m_nSliceCount] = this.createSliceObj(this.m_nXCenter, this.m_nYCenter, this.m_nRadius, fCurrAngle, fSliceEnd, nDetach, -7.0, this.m_fPieTilt, this.m_fRingPct);
                this.m_slices[this.m_nSliceCount].m_nSeriesID = s;
                this.m_slices[this.m_nSliceCount].m_nSliceIdx = this.m_nSliceCount;
                this.m_slices[this.m_nSliceCount].m_nGroupID = g;
                this.m_slices[this.m_nSliceCount].m_fPiePct = fSlicePct;
                this.m_slices[this.m_nSliceCount].m_fSliceValue = fValue;
                if (nDetach > 0 && this.m_nSliceCount > 0) {
                    this.m_slices[this.m_nSliceCount - 1].m_nDetatchAdj = 1;
                }
                if (this.m_nSliceCount > 0 && this.m_slices[this.m_nSliceCount - 1].m_nDetatch > 0) {
                    this.m_slices[this.m_nSliceCount].m_nDetatchAdj = 1;
                }
                this.m_slices[this.m_nSliceCount].m_bSliceDeleted = this.m_bSmallDataSet ? this.m_Perspective.getPieSliceDelete(s) || this.m_Perspective.getPieSliceDelete(s, g) : false;
                fCurrAngle = fSliceEnd;
                ++this.m_nSliceCount;
                if (!bOtherSeries) continue;
                this.setSeriesDrawn(s, g, true);
                continue;
            }
            if (fValue == 0.0) {
                if (!bOtherSeries) continue;
                this.setSeriesDrawn(s, g, false);
                continue;
            }
            if (!bOtherSeries) continue;
            this.setSeriesDrawn(s, g, false);
        }
        if (fOtherPct > 0.0) {
            s = -1;
            fValue = fOtherPct * this.m_fPieTotal;
            fDetach = this.m_bSmallDataSet ? (double)this.m_Perspective.getPieSliceDetach(s, g) / 100.0 : 0.0;
            nDetach = (int)(fDetach * 1500.0);
            fSlicePct = fOtherPct;
            fSliceEnd = fCurrAngle + fSlicePct;
            this.m_slices[this.m_nSliceCount] = this.createSliceObj(this.m_nXCenter, this.m_nYCenter, this.m_nRadius, fCurrAngle, fSliceEnd, nDetach, -7.0, this.m_fPieTilt, this.m_fRingPct);
            this.m_slices[this.m_nSliceCount].m_nSeriesID = s;
            this.m_slices[this.m_nSliceCount].m_nSliceIdx = this.m_nSliceCount;
            this.m_slices[this.m_nSliceCount].m_nGroupID = g;
            this.m_slices[this.m_nSliceCount].m_fPiePct = fSlicePct;
            this.m_slices[this.m_nSliceCount].m_fSliceValue = fValue;
            this.m_slices[this.m_nSliceCount].m_bSliceDeleted = this.m_bSmallDataSet ? this.m_Perspective.getPieSliceDelete(s) || this.m_Perspective.getPieSliceDelete(s, g) : false;
            fCurrAngle = fSliceEnd;
            ++this.m_nSliceCount;
        }
        if (this.m_nSliceCount > 1) {
            if (this.m_slices[this.m_nSliceCount - 1].m_nDetatch > 0) {
                this.m_slices[0].m_nDetatchAdj = 1;
            }
            if (this.m_slices[0].m_nDetatch > 0) {
                this.m_slices[this.m_nSliceCount - 1].m_nDetatchAdj = 1;
            }
        }
    }

    protected void sortSlicesBackToFront() {
        int nStartElement = 0;
        int nEndElement = nStartElement + this.m_nSliceCount - 1;
        int i = nStartElement;
        while (i < nEndElement) {
            int j = i + 1;
            while (j <= nEndElement) {
                boolean nResult;
                if (this.m_slices[j].m_ptCenter.y > this.m_nYCenter) {
                    nResult = this.m_slices[i].m_fHighestY < this.m_slices[j].m_fHighestY;
                } else {
                    boolean bl = nResult = this.m_slices[i].m_fLowestY < this.m_slices[j].m_fLowestY;
                }
                if (nResult) {
                    PieSliceObj tempObj = this.m_slices[i];
                    this.m_slices[i] = this.m_slices[j];
                    this.m_slices[j] = tempObj;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void drawAllSliceTops() {
        int sRel = 0;
        while (sRel < this.m_nSliceCount) {
            if (!this.m_slices[sRel].m_bSliceDeleted && !this.m_slices[sRel].m_bSliceSplit) {
                this.drawSliceTop(this.m_slices[sRel]);
            }
            ++sRel;
        }
    }

    protected Area calcSliceTopArea() {
        Area area = new Area();
        int sRel = 0;
        while (sRel < this.m_nSliceCount) {
            if (!this.m_slices[sRel].m_bSliceDeleted && !this.m_slices[sRel].m_bSliceSplit) {
                this.createTopPoly(this.m_slices[sRel]);
                area.add(new Area(this.m_arc2D));
            }
            ++sRel;
        }
        return area;
    }

    protected void drawSlices() {
        int sRel = 0;
        while (sRel < this.m_nSliceCount) {
            if (!this.m_slices[sRel].m_bSliceDeleted) {
                if (this.m_slices[sRel].m_fAngleEnd > 0.0 && this.m_slices[sRel].m_fAngleEnd <= 0.25 || this.m_slices[sRel].m_fAngleStart >= 0.75) {
                    this.drawSliceCrust(this.m_slices[sRel]);
                    if (this.m_bSmallDataSet) {
                        if (this.m_slices[sRel].m_nSliceSide == 1) {
                            this.drawSliceLeftEdge(this.m_slices[sRel]);
                            this.drawSliceRightEdge(this.m_slices[sRel]);
                        } else {
                            this.drawSliceRightEdge(this.m_slices[sRel]);
                            this.drawSliceLeftEdge(this.m_slices[sRel]);
                        }
                    }
                    this.drawSliceRing(this.m_slices[sRel]);
                } else if (this.m_slices[sRel].m_fAngleStart <= 0.25 && this.m_slices[sRel].m_fAngleEnd <= 0.5) {
                    this.drawSliceLeftEdge(this.m_slices[sRel]);
                    this.drawSliceRing(this.m_slices[sRel]);
                    this.drawSliceRightEdge(this.m_slices[sRel]);
                    this.drawSliceCrust(this.m_slices[sRel]);
                } else if (this.m_slices[sRel].m_fAngleStart <= 0.25) {
                    this.drawSliceLeftEdge(this.m_slices[sRel]);
                    this.drawSliceRightEdge(this.m_slices[sRel]);
                    this.drawSliceRing(this.m_slices[sRel]);
                    this.drawSliceCrust(this.m_slices[sRel]);
                } else if (this.m_slices[sRel].m_fAngleEnd >= 0.75) {
                    this.drawSliceRightEdge(this.m_slices[sRel]);
                    this.drawSliceRing(this.m_slices[sRel]);
                    this.drawSliceLeftEdge(this.m_slices[sRel]);
                    this.drawSliceCrust(this.m_slices[sRel]);
                } else {
                    this.drawSliceRing(this.m_slices[sRel]);
                    if (this.m_bSmallDataSet) {
                        if (this.m_slices[sRel].m_nSliceSide == 1) {
                            this.drawSliceLeftEdge(this.m_slices[sRel]);
                            this.drawSliceRightEdge(this.m_slices[sRel]);
                        } else {
                            this.drawSliceRightEdge(this.m_slices[sRel]);
                            this.drawSliceLeftEdge(this.m_slices[sRel]);
                        }
                    }
                    this.drawSliceCrust(this.m_slices[sRel]);
                }
            }
            ++sRel;
        }
    }

    protected void drawPieGroupLabel(int nPieGroup) {
        IdentObj id;
        DataRange drViewSG = this.m_Perspective.getViewableDataRangeSG();
        int nViewGroupStart = drViewSG.getColStart();
        int nViewGroupStop = drViewSG.getColStop();
        String szPieLabel = this.m_gt.isPieBarType() ? (this.m_Perspective.getPieBarLabelDisplay() ? this.m_Perspective.getPieBarLabelString() : "") : this.m_Perspective.getGroupLabel(nPieGroup);
        if (szPieLabel == null || szPieLabel.length() <= 0) {
            return;
        }
        int nLowestY = this.m_rPieFrame.y;
        int nLabelSize = (int)((double)this.m_rPieFrame.width / 1.2);
        Rectangle rGroupLabel = new Rectangle(this.m_nXCenter - nLabelSize / 2, nLowestY, nLabelSize, this.m_nPieLabelHeight);
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(296);
            id.setMiscID(nPieGroup);
        } else {
            id = new IdentObj(296, -3, nPieGroup);
        }
        BlackBoxObj blackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
        if (this.m_Perspective.getDrillCallback().isDrillingEnabled()) {
            int underline = this.m_Perspective.getFontStyle(id) & 4;
            this.m_pieLabelTextStyleObj.setFontStyle(this.m_pieLabelTextStyleObj.getFontStyle() & 0xFFFFFFFB | underline);
        }
        new DetLabel(this.m_Detectiv, id, szPieLabel, rGroupLabel, this.m_pieLabelTextStyleObj, blackBoxLabel, false);
    }

    protected void drawRingLabel(int nPieGroup) {
        String str;
        double fDataTextValue;
        String szFormatPattern = this.m_Perspective.getPieRingTotalFormatPattern();
        int nFormat = this.m_Perspective.getPieRingTotalFormat();
        double fLabelSize = (double)this.m_nRadius * 1.5;
        int nLabelSize = (int)fLabelSize;
        Dimension labelDim = new Dimension(nLabelSize, nLabelSize);
        double d = fDataTextValue = TDGNumberFormat.isPercentFormat(nFormat) ? 1.0 : this.m_fPieTotal;
        if (this.m_Perspective.isNumberFormatCallBack()) {
            this.m_Perspective.getNumberFormatCallBack().setState(2, -3, -3, -1, -3);
            str = this.m_Perspective.getNumberFormatCallBack().toString(fDataTextValue);
        } else {
            str = TDGNumberFormat.toString(this.m_Perspective, nFormat, fDataTextValue, szFormatPattern);
        }
        IdentObj id = this.m_Perspective.getPieRingLabel();
        BlackBoxObj blackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
        boolean bPieRingLabelFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bPieRingLabelFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), 0, 0, false, false, this.m_Perspective.getTextWrap(id));
        Graphics gx = this.m_Perspective.getGraphicsContext();
        Vector<String> vStrRingLabels = new Vector<String>();
        vStrRingLabels.addElement(str);
        int nFontSizeVC = bPieRingLabelFontSizeAbsolute ? this.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id)) : this.m_Perspective.getFontSizeVC(id);
        textStyleObj.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(id), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, vStrRingLabels, labelDim, this.m_VC);
        Rectangle rRingLabel = new Rectangle(this.m_nXCenter - labelDim.width / 2, this.m_nYCenter - labelDim.height / 2, labelDim.width, labelDim.height);
        id = new IdentObj(id.getObjectID(), -3, nPieGroup);
        new DetLabel(this.m_Detectiv, id, str, rRingLabel, textStyleObj, blackBoxLabel, false);
    }

    protected void packLabelsOnBottom(PieSliceObj[] pieSliceObjects) {
        if (pieSliceObjects == null) {
            return;
        }
        int topY = this.m_rPieFrame.y + this.m_rPieFrame.height;
        int bottomY = this.m_rPieFrame.y + this.m_nPieLabelHeight;
        boolean count = false;
        int prevRectY = bottomY;
        int i = pieSliceObjects.length - 1;
        while (i >= 0) {
            if (prevRectY + this.m_sliceLabelGap > this.m_nYCenter) {
                int idealY = pieSliceObjects[i].m_ptFeelerJoint.y - pieSliceObjects[i].m_LabelRect.height / 2;
                int packedY = prevRectY + this.m_sliceLabelGap;
                if (idealY > packedY) {
                    int requiredSpace = 0;
                    int j = 0;
                    while (j <= i) {
                        requiredSpace += pieSliceObjects[j].m_LabelRect.height + this.m_sliceLabelGap;
                        ++j;
                    }
                    int availableSpace = topY - idealY;
                    pieSliceObjects[i].m_LabelRect.y = availableSpace >= requiredSpace ? idealY : topY - requiredSpace;
                } else {
                    pieSliceObjects[i].m_LabelRect.y = packedY;
                }
            } else {
                pieSliceObjects[i].m_LabelRect.y = prevRectY + this.m_sliceLabelGap;
            }
            prevRectY = pieSliceObjects[i].m_LabelRect.y + pieSliceObjects[i].m_LabelRect.height;
            --i;
        }
    }

    protected void packLabelsOnTop(PieSliceObj[] pieSliceObjects) {
        if (pieSliceObjects == null) {
            return;
        }
        int topY = this.m_rPieFrame.y + this.m_rPieFrame.height;
        int bottomY = this.m_rPieFrame.y + this.m_nPieLabelHeight;
        boolean count = false;
        int prevRectY = topY;
        int i = 0;
        while (i < pieSliceObjects.length) {
            if (prevRectY - this.m_sliceLabelGap < this.m_nYCenter) {
                int idealY = pieSliceObjects[i].m_ptFeelerJoint.y - pieSliceObjects[i].m_LabelRect.height / 2;
                int packedY = prevRectY - this.m_sliceLabelGap - pieSliceObjects[i].m_LabelRect.height;
                if (idealY < packedY) {
                    int requiredSpace = 0;
                    int j = i + 1;
                    while (j < pieSliceObjects.length) {
                        requiredSpace += pieSliceObjects[j].m_LabelRect.height + this.m_sliceLabelGap;
                        if (j == pieSliceObjects.length - 1) {
                            requiredSpace += this.m_sliceLabelGap;
                        }
                        ++j;
                    }
                    int availableSpace = idealY - bottomY;
                    pieSliceObjects[i].m_LabelRect.y = availableSpace >= requiredSpace ? idealY : bottomY + requiredSpace;
                } else {
                    pieSliceObjects[i].m_LabelRect.y = packedY;
                }
            } else {
                pieSliceObjects[i].m_LabelRect.y = prevRectY - this.m_sliceLabelGap - pieSliceObjects[i].m_LabelRect.height;
            }
            prevRectY = pieSliceObjects[i].m_LabelRect.y;
            ++i;
        }
    }

    protected void repositionSliceLabels(PieSliceObj[] pieSliceObjects, int collision) {
        int topY = this.m_rPieFrame.y + this.m_rPieFrame.height;
        int bottomY = this.m_nYCenter;
        int halfFrameSpace = topY - bottomY;
        int topLabelSpace = 0;
        int bottomLabelSpace = 0;
        int i = 0;
        while (i < pieSliceObjects.length) {
            if (pieSliceObjects[i].m_nSliceSide == 0 && pieSliceObjects[i].m_fAngleAvg <= 0.75 || pieSliceObjects[i].m_nSliceSide == 1 && pieSliceObjects[i].m_fAngleAvg >= 0.25) {
                bottomLabelSpace += pieSliceObjects[i].m_LabelRect.height + this.m_sliceLabelGap;
            } else if (pieSliceObjects[i].m_nSliceSide == 0 && pieSliceObjects[i].m_fAngleAvg > 0.75 || pieSliceObjects[i].m_nSliceSide == 1 && pieSliceObjects[i].m_fAngleAvg < 0.25) {
                topLabelSpace += pieSliceObjects[i].m_LabelRect.height + this.m_sliceLabelGap;
            }
            ++i;
        }
        topLabelSpace += this.m_sliceLabelGap / 2;
        if ((bottomLabelSpace += this.m_sliceLabelGap / 2) > halfFrameSpace) {
            this.packLabelsOnBottom(pieSliceObjects);
        } else if (topLabelSpace > halfFrameSpace) {
            this.packLabelsOnTop(pieSliceObjects);
        } else if (collision == 1) {
            this.repositionSliceLabelsTop(pieSliceObjects);
            this.repositionSliceLabelsBottom(pieSliceObjects);
        } else if (collision == 2) {
            this.repositionSliceLabelsTop(pieSliceObjects);
        } else {
            this.repositionSliceLabelsBottom(pieSliceObjects);
        }
    }

    protected void repositionSliceLabelsTop(PieSliceObj[] pieSliceObjects) {
        if (pieSliceObjects == null) {
            return;
        }
        int topY = this.m_rPieFrame.y + this.m_rPieFrame.height;
        int count = 0;
        int i = 0;
        while (i < pieSliceObjects.length) {
            if (pieSliceObjects[i].m_nSliceSide == 0 && pieSliceObjects[i].m_fAngleAvg <= 0.75 || pieSliceObjects[i].m_nSliceSide == 1 && pieSliceObjects[i].m_fAngleAvg >= 0.25) break;
            ++count;
            ++i;
        }
        int prevRectY = this.m_nYCenter;
        int i2 = count - 1;
        while (i2 >= 0) {
            int packedY = 0;
            int idealY = pieSliceObjects[i2].m_ptFeelerJoint.y - pieSliceObjects[i2].m_LabelRect.height / 2;
            packedY = i2 == count - 1 ? prevRectY + this.m_sliceLabelGap / 2 : prevRectY + this.m_sliceLabelGap;
            if (idealY > packedY && idealY - this.m_sliceLabelGap / 2 >= this.m_nYCenter) {
                int requiredSpace = 0;
                int j = 0;
                while (j <= i2) {
                    requiredSpace += pieSliceObjects[j].m_LabelRect.height + this.m_sliceLabelGap;
                    ++j;
                }
                int availableSpace = topY - idealY;
                pieSliceObjects[i2].m_LabelRect.y = availableSpace >= requiredSpace ? idealY : topY - requiredSpace;
            } else {
                pieSliceObjects[i2].m_LabelRect.y = packedY;
            }
            prevRectY = pieSliceObjects[i2].m_LabelRect.y + pieSliceObjects[i2].m_LabelRect.height;
            --i2;
        }
    }

    protected void repositionSliceLabelsBottom(PieSliceObj[] pieSliceObjects) {
        int topMostBottomLabel;
        if (pieSliceObjects == null) {
            return;
        }
        int bottomY = this.m_rPieFrame.y + this.m_nPieLabelHeight;
        int count = 0;
        int i = pieSliceObjects.length - 1;
        while (i >= 0) {
            if (pieSliceObjects[i].m_nSliceSide == 0 && pieSliceObjects[i].m_fAngleAvg > 0.75 || pieSliceObjects[i].m_nSliceSide == 1 && pieSliceObjects[i].m_fAngleAvg < 0.25) break;
            ++count;
            --i;
        }
        int prevRectY = this.m_nYCenter;
        int i2 = topMostBottomLabel = pieSliceObjects.length - count;
        while (i2 < pieSliceObjects.length) {
            int packedY = 0;
            int idealY = pieSliceObjects[i2].m_ptFeelerJoint.y - pieSliceObjects[i2].m_LabelRect.height / 2;
            packedY = i2 == topMostBottomLabel ? prevRectY - this.m_sliceLabelGap / 2 - pieSliceObjects[i2].m_LabelRect.height : prevRectY - this.m_sliceLabelGap - pieSliceObjects[i2].m_LabelRect.height;
            if (idealY < packedY && idealY + pieSliceObjects[i2].m_LabelRect.height + this.m_sliceLabelGap / 2 <= this.m_nYCenter) {
                int requiredSpace = 0;
                int j = i2 + 1;
                while (j < pieSliceObjects.length) {
                    requiredSpace += pieSliceObjects[j].m_LabelRect.height + this.m_sliceLabelGap;
                    if (j == pieSliceObjects.length - 1) {
                        requiredSpace += this.m_sliceLabelGap;
                    }
                    ++j;
                }
                int availableSpace = idealY - bottomY;
                pieSliceObjects[i2].m_LabelRect.y = availableSpace >= requiredSpace ? idealY : bottomY + requiredSpace;
            } else {
                pieSliceObjects[i2].m_LabelRect.y = packedY;
            }
            prevRectY = pieSliceObjects[i2].m_LabelRect.y;
            ++i2;
        }
    }

    protected int checkForCollisions(PieSliceObj[] pieSliceObjects) {
        if (pieSliceObjects == null) {
            return 0;
        }
        boolean top = false;
        boolean bottom = false;
        int collisions = 0;
        int topY = this.m_rPieFrame.y + this.m_rPieFrame.height;
        int bottomY = this.m_rPieFrame.y + this.m_nPieLabelHeight;
        if (pieSliceObjects[0].m_LabelRect.y + pieSliceObjects[0].m_LabelRect.height > topY) {
            top = true;
        }
        if (pieSliceObjects[pieSliceObjects.length - 1].m_LabelRect.y < bottomY) {
            bottom = true;
        }
        if (pieSliceObjects.length == 1) {
            collisions = top && bottom ? 1 : (top ? 2 : (bottom ? 3 : 0));
            return collisions;
        }
        boolean left = true;
        if (pieSliceObjects[0].m_nSliceSide == 1) {
            left = false;
        }
        int i = 0;
        while (i < pieSliceObjects.length - 1) {
            PieSliceObj theSlice = pieSliceObjects[i];
            PieSliceObj nextSlice = pieSliceObjects[i + 1];
            Rectangle rLabel = theSlice.m_LabelRect;
            Rectangle rNextLabel = nextSlice.m_LabelRect;
            if (rLabel.y < rNextLabel.y + rNextLabel.height + this.m_sliceLabelGap) {
                if (left) {
                    if (theSlice.m_fAngleAvg > 0.75 && nextSlice.m_fAngleAvg > 0.75) {
                        top = true;
                    } else if (theSlice.m_fAngleAvg <= 0.75 && nextSlice.m_fAngleAvg <= 0.75) {
                        bottom = true;
                    } else {
                        top = true;
                        bottom = true;
                    }
                } else if (theSlice.m_fAngleAvg < 0.25 && nextSlice.m_fAngleAvg < 0.25) {
                    top = true;
                } else if (theSlice.m_fAngleAvg >= 0.25 && nextSlice.m_fAngleAvg >= 0.25) {
                    bottom = true;
                } else {
                    top = true;
                    bottom = true;
                }
            }
            ++i;
        }
        collisions = top && bottom ? 1 : (top ? 2 : (bottom ? 3 : 0));
        return collisions;
    }

    protected void calcNormalSliceLabelRects(PieSliceObj[] pieSliceObjects, int labelWidth) {
        if (pieSliceObjects == null) {
            return;
        }
        int i = 0;
        while (i < pieSliceObjects.length) {
            PieSliceObj theSlice = pieSliceObjects[i];
            int x = this.m_leftMostPointOfPie - this.m_pivotLineVirt - this.m_feelerTextGapVirt - labelWidth;
            if (theSlice.m_nSliceSide == 1) {
                x = this.m_rightMostPointOfPie + this.m_pivotLineVirt + this.m_feelerTextGapVirt;
            }
            theSlice.m_LabelRect = new Rectangle(x, theSlice.m_ptFeelerJoint.y - this.m_labelDimVC.height / 2, labelWidth, this.m_labelDimVC.height);
            ++i;
        }
        int collision = this.checkForCollisions(pieSliceObjects);
        if (collision != 0) {
            this.repositionSliceLabels(pieSliceObjects, collision);
            this.m_collision = true;
        } else if (!this.m_collision) {
            this.m_no_collision = true;
        }
    }

    protected boolean calcCircularSliceLabelRects(PieSliceObj[] pieSliceObjAllLeft, PieSliceObj[] pieSliceObjAllRight) {
        if (pieSliceObjAllLeft == null || pieSliceObjAllRight == null) {
            return false;
        }
        int i = 0;
        while (i < pieSliceObjAllLeft.length) {
            PieSliceObj theSlice = pieSliceObjAllLeft[i];
            theSlice.m_LabelRect = new Rectangle(this.m_sliceLabelLeftEdge, theSlice.m_ptFeelerJoint.y - this.m_labelDimVC.height / 2, theSlice.m_ptFeelerJoint.x - this.m_sliceLabelLeftEdge - this.m_pivotLineVirt - this.m_feelerTextGapVirt, this.m_labelDimVC.height);
            ++i;
        }
        int i2 = 0;
        while (i2 < pieSliceObjAllRight.length) {
            PieSliceObj theSlice = pieSliceObjAllRight[i2];
            int x = theSlice.m_ptFeelerJoint.x + this.m_pivotLineVirt + this.m_feelerTextGapVirt;
            theSlice.m_LabelRect = new Rectangle(x, theSlice.m_ptFeelerJoint.y - this.m_labelDimVC.height / 2, this.m_sliceLabelRightEdge - x, this.m_labelDimVC.height);
            ++i2;
        }
        if (this.checkForCollisions(pieSliceObjAllLeft) != 0 || this.checkForCollisions(pieSliceObjAllRight) != 0) {
            return false;
        }
        boolean needsWrappingOnLeft = false;
        int i3 = 0;
        while (i3 < pieSliceObjAllLeft.length) {
            PieSliceObj theSlice = pieSliceObjAllLeft[i3];
            int stringWidthVirt = this.m_VC.destToVirtWidth(this.m_stringWidths[theSlice.m_nSliceIdx]);
            if (stringWidthVirt > theSlice.m_LabelRect.width) {
                needsWrappingOnLeft = true;
            }
            ++i3;
        }
        boolean needsWrappingOnRight = false;
        int i4 = 0;
        while (i4 < pieSliceObjAllRight.length) {
            PieSliceObj theSlice = pieSliceObjAllRight[i4];
            int stringWidthVirt = this.m_VC.destToVirtWidth(this.m_stringWidths[theSlice.m_nSliceIdx]);
            if (stringWidthVirt > theSlice.m_LabelRect.width) {
                needsWrappingOnRight = true;
            }
            ++i4;
        }
        if (!needsWrappingOnLeft && !needsWrappingOnRight) {
            return true;
        }
        if (needsWrappingOnLeft && needsWrappingOnRight) {
            boolean result = this.wrapCircularSliceLabels(pieSliceObjAllLeft);
            if (!result) {
                return false;
            }
            return this.wrapCircularSliceLabels(pieSliceObjAllRight);
        }
        if (needsWrappingOnLeft) {
            return this.wrapCircularSliceLabels(pieSliceObjAllLeft);
        }
        return this.wrapCircularSliceLabels(pieSliceObjAllRight);
    }

    protected boolean wrapCircularSliceLabels(PieSliceObj[] pieSliceObjects) {
        Point[] points = this.calcArcPointsForTestPolygon();
        int topY = this.m_rPieFrame.y + this.m_rPieFrame.height;
        int bottomY = this.m_rPieFrame.y + this.m_nPieLabelHeight;
        int fontHeightVC = this.m_VC.destToVirtHeight(this.m_sliceLabelFontHeight);
        boolean success = true;
        int i = 0;
        while (i < pieSliceObjects.length) {
            PieSliceObj theSlice = pieSliceObjects[i];
            int stringWidthVirt = this.m_VC.destToVirtWidth(this.m_stringWidths[theSlice.m_nSliceIdx]);
            if (stringWidthVirt > theSlice.m_LabelRect.width) {
                int pointIndex;
                double fAngleAvg = theSlice.m_fAngleAvg;
                int maxTopY = 0;
                int maxBotY = 0;
                maxTopY = i == 0 ? topY : pieSliceObjects[i - 1].m_LabelRect.y;
                maxBotY = i == pieSliceObjects.length - 1 ? bottomY : pieSliceObjects[i + 1].m_LabelRect.y + pieSliceObjects[i + 1].m_LabelRect.height;
                if (fAngleAvg > 0.67 && fAngleAvg < 0.83) {
                    pointIndex = 75;
                } else if (fAngleAvg > 0.17 && fAngleAvg < 0.33) {
                    pointIndex = 25;
                } else if (fAngleAvg > 0.75 || fAngleAvg == 0.0) {
                    if (fAngleAvg == 0.0) {
                        fAngleAvg = 0.99;
                    }
                    pointIndex = (int)(fAngleAvg * 100.0) - 5;
                    if (points[pointIndex].y > maxBotY) {
                        maxBotY = points[pointIndex].y;
                    }
                } else if (fAngleAvg > 0.5) {
                    pointIndex = (int)(fAngleAvg * 100.0) + 5;
                    if (points[pointIndex].y < maxTopY) {
                        maxTopY = points[pointIndex].y;
                    }
                } else if (fAngleAvg > 0.25) {
                    pointIndex = (int)(fAngleAvg * 100.0) - 5;
                    if (points[pointIndex].y < maxTopY) {
                        maxTopY = points[pointIndex].y;
                    }
                } else {
                    pointIndex = (int)(fAngleAvg * 100.0) + 5;
                    if (points[pointIndex].y > maxBotY) {
                        maxBotY = points[pointIndex].y;
                    }
                }
                if ((maxTopY -= this.m_sliceLabelGap) - (maxBotY += this.m_sliceLabelGap) < theSlice.m_LabelRect.height * 2) {
                    success = false;
                    break;
                }
                String label = (String)this.m_vectStrLabels.elementAt(theSlice.m_nSliceIdx);
                int leftEdgeOfLabel = 0;
                int labelWidth = 0;
                if (theSlice.m_nSliceSide == 0) {
                    leftEdgeOfLabel = theSlice.m_LabelRect.x;
                    int rightEdgeOfLabel = points[pointIndex].x;
                    labelWidth = points[pointIndex].x - this.m_pivotLineVirt - this.m_feelerTextGapVirt - theSlice.m_LabelRect.x;
                } else {
                    leftEdgeOfLabel = points[pointIndex].x + this.m_pivotLineVirt + this.m_feelerTextGapVirt;
                    labelWidth = this.m_sliceLabelRightEdge - leftEdgeOfLabel;
                }
                this.m_textStyleFeelers.setTextTruncate(true, -1, 0);
                this.m_textStyleFeelers.setTextTruncated(false);
                Vector strs = new Vector();
                int numLinesReqd = this.m_textStyleFeelers.extractLinesWordWrap(label, strs, this.m_VC.virtToDestWidth(labelWidth), this.getSliceLabelFontMetrics(), this.m_Perspective.getFontMetricsResolver());
                this.m_textStyleFeelers.setWordWrap(true);
                if (this.m_textStyleFeelers.isTextTruncated()) {
                    success = false;
                    break;
                }
                int rectHeight = fontHeightVC * numLinesReqd;
                if (rectHeight > maxTopY - maxBotY) {
                    success = false;
                    break;
                }
                int ypos = 0;
                ypos = theSlice.m_ptFeelerJoint.y + rectHeight / 2 <= maxTopY && theSlice.m_ptFeelerJoint.y - rectHeight / 2 >= maxBotY ? theSlice.m_ptFeelerJoint.y - rectHeight / 2 : (theSlice.m_ptFeelerJoint.y + rectHeight / 2 <= maxTopY ? maxBotY : maxTopY - rectHeight);
                theSlice.m_LabelRect = new Rectangle(leftEdgeOfLabel, ypos, labelWidth, rectHeight);
            }
            ++i;
        }
        if (!success) {
            this.m_textStyleFeelers.setWordWrap(false);
            this.m_textStyleFeelers.setTextTruncate(false, -1, 0);
            return false;
        }
        return true;
    }

    protected void calcWrappedSliceLabelRects(PieSliceObj[] pieSliceObjects) {
        boolean topCrowded;
        if (pieSliceObjects == null) {
            return;
        }
        int x = this.m_sliceLabelLeftEdge;
        int labelWidth = this.m_leftMostPointOfPie - this.m_pivotLineVirt - this.m_feelerTextGapVirt - x;
        FontMetrics fm = this.getSliceLabelFontMetrics();
        int fontHeightVC = this.m_VC.destToVirtHeight(this.m_sliceLabelFontHeight);
        int numLabels = 0;
        PieSliceObj theSlice = pieSliceObjects[0];
        if (theSlice.m_nSliceSide == 1) {
            numLabels = this.m_rightSliceLabels.size();
            x = this.m_sliceLabelRightEdge - labelWidth;
        } else {
            numLabels = this.m_leftSliceLabels.size();
        }
        int availHeightDest = this.m_VC.virtToDestHeight(this.m_rPieFrame.height - this.m_nPieLabelHeight);
        double maxNumLines = (double)availHeightDest / (double)this.m_sliceLabelFontHeight;
        int numLinesPerLabel = (int)(Math.floor(maxNumLines - (double)(numLabels + 1) * 0.5) / (double)numLabels);
        int extraLines = (int)(Math.floor(maxNumLines - (double)(numLabels + 1) * 0.5) % (double)numLabels);
        int topLabels = 0;
        int i = 0;
        while (i < pieSliceObjects.length) {
            theSlice = pieSliceObjects[i];
            if (theSlice.m_fAngleAvg > 0.75 || theSlice.m_fAngleAvg < 0.25) {
                ++topLabels;
            }
            ++i;
        }
        boolean bl = topCrowded = topLabels > pieSliceObjects.length - topLabels;
        if (topCrowded) {
            PieSliceObj[] newPieSliceArray = new PieSliceObj[pieSliceObjects.length];
            int j = 0;
            int i2 = pieSliceObjects.length - 1;
            while (i2 >= 0) {
                newPieSliceArray[j] = pieSliceObjects[i2];
                ++j;
                --i2;
            }
            pieSliceObjects = newPieSliceArray;
        }
        int i3 = 0;
        while (i3 < pieSliceObjects.length) {
            theSlice = pieSliceObjects[i3];
            int stringWidthVirt = this.m_VC.destToVirtWidth(this.m_stringWidths[theSlice.m_nSliceIdx]);
            int numLinesAvail = 0;
            int numLinesUsed = 0;
            if (stringWidthVirt <= labelWidth) {
                numLinesUsed = 1;
                extraLines += numLinesPerLabel - numLinesUsed;
            } else {
                int stringWidth = this.m_stringWidths[theSlice.m_nSliceIdx];
                String label = (String)this.m_vectStrLabels.elementAt(theSlice.m_nSliceIdx);
                if (extraLines > 0) {
                    --extraLines;
                    numLinesAvail = numLinesPerLabel + 1;
                } else {
                    numLinesAvail = numLinesPerLabel;
                }
                this.m_textStyleFeelers.setTextTruncate(true, numLinesAvail, 0);
                this.m_textStyleFeelers.setTextTruncated(false);
                this.m_textStyleFeelers.setWordWrap(true);
                Vector strs = new Vector();
                numLinesUsed = this.m_textStyleFeelers.extractLinesWordWrap(label, strs, this.m_VC.virtToDestWidth(labelWidth), fm, this.m_Perspective.getFontMetricsResolver());
                if (numLinesUsed < numLinesAvail) {
                    extraLines += numLinesAvail - numLinesUsed;
                }
                if (this.m_textStyleFeelers.isTextTruncated()) {
                    this.m_sliceLabelTruncated = true;
                    this.m_fullSliceLabels[theSlice.m_nSliceIdx] = label;
                    label = "";
                    int j = 0;
                    while (j < strs.size()) {
                        label = label + (String)strs.elementAt(j);
                        if (j < strs.size() - 1) {
                            label = label + ' ';
                        }
                        ++j;
                    }
                    this.m_vectStrLabels.setElementAt(label, theSlice.m_nSliceIdx);
                }
            }
            int rectHeight = fontHeightVC * numLinesUsed;
            theSlice.m_LabelRect = new Rectangle(x, theSlice.m_ptFeelerJoint.y - rectHeight / 2, labelWidth, rectHeight);
            ++i3;
        }
        if (topCrowded) {
            PieSliceObj[] newPieSliceArray = new PieSliceObj[pieSliceObjects.length];
            int j = 0;
            int i4 = pieSliceObjects.length - 1;
            while (i4 >= 0) {
                newPieSliceArray[j] = pieSliceObjects[i4];
                ++j;
                --i4;
            }
            pieSliceObjects = newPieSliceArray;
        }
        this.m_textStyleFeelers.setTextTruncate(false, -1, 0);
        int collision = this.checkForCollisions(pieSliceObjects);
        if (collision != 0) {
            this.repositionSliceLabels(pieSliceObjects, collision);
        }
    }

    protected void calcOutOfPlotAreaSliceLabels(PieSliceObj[] pieSliceObjects) {
        int middleRectY;
        if (pieSliceObjects == null) {
            return;
        }
        FontMetrics fm = this.getSliceLabelFontMetrics();
        int fontHeightVC = this.m_VC.destToVirtHeight(this.m_sliceLabelFontHeight);
        int middleSliceIndex = pieSliceObjects.length / 2;
        int x = this.m_sliceLabelLeftEdge;
        int labelWidth = this.m_leftMostPointOfPie - this.m_pivotLineVirt - this.m_feelerTextGapVirt - x;
        if (labelWidth < 100) {
            labelWidth = 100;
        }
        if (pieSliceObjects[0].m_nSliceSide == 1) {
            x = this.m_rightMostPointOfPie + this.m_pivotLineVirt + this.m_feelerTextGapVirt;
        }
        int yPos = middleRectY = this.m_nYCenter - this.m_labelDimVC.height / 2;
        int i = middleSliceIndex;
        while (i < pieSliceObjects.length) {
            pieSliceObjects[i].m_LabelRect = new Rectangle(x, yPos, labelWidth, this.m_labelDimVC.height);
            yPos -= this.m_labelDimVC.height + this.m_sliceLabelGap;
            this.truncateLabelAsNeeded(pieSliceObjects[i], labelWidth, fm);
            ++i;
        }
        yPos = middleRectY + (this.m_labelDimVC.height + this.m_sliceLabelGap);
        int i2 = middleSliceIndex - 1;
        while (i2 >= 0) {
            pieSliceObjects[i2].m_LabelRect = new Rectangle(x, yPos, labelWidth, this.m_labelDimVC.height);
            yPos += this.m_labelDimVC.height + this.m_sliceLabelGap;
            this.truncateLabelAsNeeded(pieSliceObjects[i2], labelWidth, fm);
            --i2;
        }
    }

    protected void truncateLabelAsNeeded(PieSliceObj theSlice, int labelWidth, FontMetrics fm) {
        if (this.m_stringWidths[theSlice.m_nSliceIdx] > this.m_VC.virtToDestWidth(labelWidth)) {
            String label;
            this.m_fullSliceLabels[theSlice.m_nSliceIdx] = label = (String)this.m_vectStrLabels.elementAt(theSlice.m_nSliceIdx);
            label = PresUtils.truncateText(label, fm, 0, this.m_VC.virtToDestWidth(labelWidth), this.m_Perspective.getFontMetricsResolver());
            this.m_vectStrLabels.setElementAt(label, theSlice.m_nSliceIdx);
            this.m_sliceLabelTruncated = true;
        }
    }

    protected void drawFeelers(PieSliceObj theSlice, BlackBoxObj blackBox) {
        IdentObj idFeeler;
        Rectangle rLabel = null;
        rLabel = theSlice.m_LabelRect;
        Point[] ptPolyline = new Point[4];
        if (this.m_gt.isPieBarType()) {
            idFeeler = new IdentObj(294, theSlice.m_nSeriesID);
            idFeeler.setMiscID(theSlice.m_nGroupID);
        } else {
            idFeeler = new IdentObj(294, theSlice.m_nSeriesID, theSlice.m_nGroupID);
        }
        ptPolyline[0] = new Point(theSlice.m_ptCenter.x, theSlice.m_ptCenter.y);
        if (theSlice.m_nSliceSide == 0) {
            ptPolyline[1] = new Point(theSlice.m_ptFeelerJoint.x, rLabel.y + rLabel.height / 2);
            ptPolyline[2] = new Point(rLabel.x + rLabel.width + this.m_feelerTextGapVirt, rLabel.y + rLabel.height / 2);
        } else {
            ptPolyline[1] = new Point(theSlice.m_ptFeelerJoint.x, rLabel.y + rLabel.height / 2);
            ptPolyline[2] = new Point(rLabel.x - this.m_feelerTextGapVirt, rLabel.y + rLabel.height / 2);
        }
        IdentObj newID = new IdentObj(idFeeler);
        newID.setMiscID(100);
        if (this.m_Perspective.m_bExportingToFlash) {
            theSlice.setRadialLine(new DetLine(this.m_Detectiv, newID, ptPolyline[0].x, ptPolyline[0].y, ptPolyline[1].x, ptPolyline[1].y, (BlackBoxIF)blackBox, null, this.m_nLineWidthFeeler, this.m_nLineStyleFeeler));
            newID = new IdentObj(idFeeler);
            newID.setMiscID(200);
            theSlice.setPivotLine(new DetLine(this.m_Detectiv, newID, ptPolyline[1].x, ptPolyline[1].y, ptPolyline[2].x, ptPolyline[2].y, (BlackBoxIF)blackBox, null, this.m_nLineWidthFeeler, this.m_nLineStyleFeeler));
        } else {
            Vector<Point> polylinePts = new Vector<Point>(3);
            polylinePts.add(ptPolyline[0]);
            polylinePts.add(ptPolyline[1]);
            polylinePts.add(ptPolyline[2]);
            new DetPolyline(this.m_Detectiv, newID, polylinePts, (BlackBoxIF)blackBox, null, false, false, this.m_nLineWidthFeeler, this.m_nLineStyleFeeler);
        }
    }

    protected void drawAllSliceLabels() {
        if ((this.m_nPieFeelerTextDisplay == 1 || this.m_nPieFeelerTextDisplay == 4) && this.m_bSliceLabelVisibility) {
            int reqHeightOnRight;
            Vector<PieSliceObj> pieSliceObjAllLeftV = new Vector<PieSliceObj>();
            Vector<PieSliceObj> pieSliceObjAllRightV = new Vector<PieSliceObj>();
            PieSliceObj atZero = null;
            int s = 0;
            while (s < this.m_nSliceCount) {
                if (!this.m_slices[s].m_bSliceDeleted && !this.m_slices[s].m_bSliceSplit) {
                    if (this.m_slices[s].m_fAngleAvg == 0.0) {
                        atZero = this.m_slices[s];
                    } else if (this.m_slices[s].m_nSliceSide == 0) {
                        if (pieSliceObjAllLeftV.size() > 0) {
                            PieSliceObj prevSlice = (PieSliceObj)pieSliceObjAllLeftV.elementAt(pieSliceObjAllLeftV.size() - 1);
                            if (prevSlice.m_fAngleAvg > this.m_slices[s].m_fAngleAvg) {
                                pieSliceObjAllLeftV.add(this.m_slices[s]);
                            } else {
                                int i = 0;
                                while (i < pieSliceObjAllLeftV.size()) {
                                    prevSlice = (PieSliceObj)pieSliceObjAllLeftV.elementAt(i);
                                    if (prevSlice.m_fAngleAvg < this.m_slices[s].m_fAngleAvg) {
                                        pieSliceObjAllLeftV.insertElementAt(this.m_slices[s], i);
                                        break;
                                    }
                                    ++i;
                                }
                            }
                        } else {
                            pieSliceObjAllLeftV.add(this.m_slices[s]);
                        }
                    } else if (pieSliceObjAllRightV.size() > 0) {
                        PieSliceObj prevSlice = (PieSliceObj)pieSliceObjAllRightV.elementAt(pieSliceObjAllRightV.size() - 1);
                        if (prevSlice.m_fAngleAvg < this.m_slices[s].m_fAngleAvg) {
                            pieSliceObjAllRightV.add(this.m_slices[s]);
                        } else {
                            int i = 0;
                            while (i < pieSliceObjAllRightV.size()) {
                                prevSlice = (PieSliceObj)pieSliceObjAllRightV.elementAt(i);
                                if (prevSlice.m_fAngleAvg > this.m_slices[s].m_fAngleAvg) {
                                    pieSliceObjAllRightV.insertElementAt(this.m_slices[s], i);
                                    break;
                                }
                                ++i;
                            }
                        }
                    } else {
                        pieSliceObjAllRightV.add(this.m_slices[s]);
                    }
                }
                ++s;
            }
            if (atZero != null) {
                pieSliceObjAllLeftV.insertElementAt(atZero, 0);
            }
            PieSliceObj[] pieSliceObjAllLeft = null;
            PieSliceObj[] pieSliceObjAllRight = null;
            if (pieSliceObjAllLeftV.size() > 0) {
                pieSliceObjAllLeft = new PieSliceObj[pieSliceObjAllLeftV.size()];
                int i = 0;
                while (i < pieSliceObjAllLeft.length) {
                    pieSliceObjAllLeft[i] = (PieSliceObj)pieSliceObjAllLeftV.elementAt(i);
                    ++i;
                }
            }
            if (pieSliceObjAllRightV.size() > 0) {
                pieSliceObjAllRight = new PieSliceObj[pieSliceObjAllRightV.size()];
                int i = 0;
                while (i < pieSliceObjAllRight.length) {
                    pieSliceObjAllRight[i] = (PieSliceObj)pieSliceObjAllRightV.elementAt(i);
                    ++i;
                }
            }
            boolean leftSideDone = false;
            boolean rightSideDone = false;
            int fontHeightVC = this.m_VC.destToVirtHeight(this.m_sliceLabelFontHeight);
            int reqHeightOnLeft = this.m_leftSliceLabels.size() * fontHeightVC + (this.m_leftSliceLabels.size() + 1) * this.m_sliceLabelGap;
            if (reqHeightOnLeft > this.m_rPieFrame.height - this.m_nPieLabelHeight) {
                leftSideDone = true;
                this.calcOutOfPlotAreaSliceLabels(pieSliceObjAllLeft);
            }
            if ((reqHeightOnRight = this.m_rightSliceLabels.size() * fontHeightVC + (this.m_rightSliceLabels.size() + 1) * this.m_sliceLabelGap) > this.m_rPieFrame.height - this.m_nPieLabelHeight) {
                rightSideDone = true;
                this.calcOutOfPlotAreaSliceLabels(pieSliceObjAllRight);
            }
            int labelWidthAvailable = this.m_leftMostPointOfPie - this.m_pivotLineVirt - this.m_feelerTextGapVirt - this.m_sliceLabelLeftEdge;
            int maxlabelWidthVirt = this.m_VC.destToVirtWidth(this.m_maxLabelWidthDest);
            if (rightSideDone && !leftSideDone) {
                if (labelWidthAvailable >= maxlabelWidthVirt) {
                    this.calcNormalSliceLabelRects(pieSliceObjAllLeft, maxlabelWidthVirt);
                } else {
                    this.calcWrappedSliceLabelRects(pieSliceObjAllLeft);
                }
            }
            if (!rightSideDone && leftSideDone) {
                if (labelWidthAvailable >= maxlabelWidthVirt) {
                    this.calcNormalSliceLabelRects(pieSliceObjAllRight, maxlabelWidthVirt);
                } else {
                    this.calcWrappedSliceLabelRects(pieSliceObjAllRight);
                }
            }
            if (!rightSideDone && !leftSideDone) {
                if (labelWidthAvailable >= maxlabelWidthVirt) {
                    this.calcNormalSliceLabelRects(pieSliceObjAllLeft, maxlabelWidthVirt);
                    this.calcNormalSliceLabelRects(pieSliceObjAllRight, maxlabelWidthVirt);
                } else if (this.m_DetachPresent) {
                    this.calcWrappedSliceLabelRects(pieSliceObjAllLeft);
                    this.calcWrappedSliceLabelRects(pieSliceObjAllRight);
                } else {
                    boolean result = this.calcCircularSliceLabelRects(pieSliceObjAllLeft, pieSliceObjAllRight);
                    if (!result) {
                        this.calcWrappedSliceLabelRects(pieSliceObjAllLeft);
                        this.calcWrappedSliceLabelRects(pieSliceObjAllRight);
                    } else if (this.m_nPieFeelerTextDisplay == 4) {
                        this.m_circular = true;
                    }
                }
            }
        }
        int sRel = 0;
        while (sRel < this.m_nSliceCount) {
            if (!this.m_slices[sRel].m_bSliceDeleted && !this.m_slices[sRel].m_bSliceSplit && this.m_bSliceLabelVisibility) {
                this.drawSliceLabel(this.m_slices[sRel]);
            }
            ++sRel;
        }
    }

    PieSliceObj nextSliceOnSide(int SeriesOrdinal) {
        PieSliceObj anotherSliceObj = null;
        int aSide = this.m_slices[SeriesOrdinal].m_nSliceSide;
        int sRel = SeriesOrdinal + 1;
        while (sRel < this.m_nSliceCount) {
            if (!this.m_slices[sRel].m_bSliceDeleted && !this.m_slices[sRel].m_bSliceSplit && this.m_slices[sRel].m_nSliceSide == aSide) {
                anotherSliceObj = this.m_slices[sRel];
                break;
            }
            ++sRel;
        }
        return anotherSliceObj;
    }

    /*
     * Unable to fully structure code
     */
    protected void drawSliceLabel(PieSliceObj theSlice) {
        ptPolyline = new Point[4];
        rLabel = null;
        gx = this.m_Perspective.getGraphicsContext();
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(295, theSlice.m_nSeriesID);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(295, theSlice.m_nSeriesID, theSlice.m_nGroupID);
        }
        rBlackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
        rBlackBoxLabel.setTransparentFillColor(true);
        rBlackBoxLabel.setTransparentBorderColor(true);
        idColor = new IdentObj(294);
        savedValue = this.m_nPieFeelerTextDisplay;
        if (this.m_nPieFeelerTextDisplay == 4 && !this.m_no_collision) {
            this.m_nPieFeelerTextDisplay = 1;
        } else if (this.m_nPieFeelerTextDisplay == 4 && this.m_circular) {
            this.m_nPieFeelerTextDisplay = 1;
        } else if (this.m_nPieFeelerTextDisplay == 4 && this.m_no_collision) {
            this.m_nPieFeelerTextDisplay = 2;
        }
        switch (this.m_nPieFeelerTextDisplay) {
            case 0: {
                return;
            }
            case 1: {
                blackBox = new BlackBoxObj(this.m_Perspective, idColor);
                rLabel = theSlice.m_LabelRect;
                if (theSlice.m_nSliceSide == 0) {
                    this.m_textStyleFeelers.setHorizAlign(4);
                } else {
                    this.m_textStyleFeelers.setHorizAlign(2);
                }
                if (this.m_circular) break;
                this.drawFeelers(theSlice, blackBox);
                break;
            }
            case 2: {
                if (theSlice.m_nSliceSide == 0) {
                    rLabel = new Rectangle(this.m_sliceLabelLeftEdge, theSlice.m_ptFeelerJoint.y - this.m_labelDimVC.height / 2, theSlice.m_ptFeelerJoint.x - this.m_sliceLabelLeftEdge - this.m_feelerTextGapVirt, this.m_labelDimVC.height);
                    this.m_textStyleFeelers.setHorizAlign(4);
                } else {
                    rLabel = new Rectangle(theSlice.m_ptFeelerJoint.x + this.m_feelerTextGapVirt, theSlice.m_ptFeelerJoint.y - this.m_labelDimVC.height / 2, this.m_sliceLabelRightEdge - theSlice.m_ptFeelerJoint.x, this.m_labelDimVC.height);
                    this.m_textStyleFeelers.setHorizAlign(2);
                }
                this.truncateLabelAsNeeded(theSlice, rLabel.width, this.getSliceLabelFontMetrics());
                break;
            }
            default: {
                position = 0.66;
                idFeeler = this.m_Perspective.getPieSliceLabel();
                nFontSizeVC = this.m_Perspective.getFontSizeAbsolute(idFeeler) != false ? this.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(idFeeler)) : this.m_Perspective.getFontSizeVC(idFeeler);
                centerX = 0;
                centerY = 0;
                tipX = 0;
                tipY = 0;
                if (this.m_nSliceCount >= 20) ** GOTO lbl104
                nPoints = theSlice.m_polyCrust.npoints;
                poly = new Polygon();
                poly.addPoint(theSlice.m_ptRingLeft.x, theSlice.m_ptRingLeft.y);
                i = 0;
                while (i < nPoints) {
                    poly.addPoint(theSlice.m_polyCrust.xpoints[i], theSlice.m_polyCrust.ypoints[i]);
                    ++i;
                }
                poly.addPoint(theSlice.m_ptRingRight.x, theSlice.m_ptRingRight.y);
                if (theSlice.m_polyRing != null) {
                    i = nPoints - 2;
                    while (i >= 0) {
                        poly.addPoint(theSlice.m_polyRing.xpoints[i], theSlice.m_polyRing.ypoints[i]);
                        --i;
                    }
                }
                if (theSlice.m_polyRing != null) {
                    tipX = theSlice.m_polyRing.xpoints[theSlice.m_polyRing.npoints / 2];
                    tipY = theSlice.m_polyRing.ypoints[theSlice.m_polyRing.npoints / 2];
                } else {
                    tipX = theSlice.m_ptRingRight.x;
                    tipY = theSlice.m_ptRingRight.y;
                }
                i = 0;
                while (i < 2) {
                    diffX = (int)((double)Math.abs(theSlice.m_ptCenter.x - tipX) * position);
                    diffY = (int)((double)Math.abs(theSlice.m_ptCenter.y - tipY) * position);
                    centerX = theSlice.m_ptCenter.x > tipX ? tipX + diffX : tipX - diffX;
                    centerY = theSlice.m_ptCenter.y > tipY ? tipY + diffY : tipY - diffY;
                    dim = new Dimension(32000, 32000);
                    vector = new Vector<E>();
                    vector.add(this.m_vectStrLabels.elementAt(theSlice.m_nSliceIdx));
                    this.m_textStyleFeelers.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(idFeeler), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, vector, dim, this.m_VC);
                    x = centerX - dim.width / 2;
                    y = centerY - dim.height / 2;
                    x2 = x + dim.width;
                    y2 = y + dim.height;
                    if (!(poly.contains(x, y) && poly.contains(x2, y) && poly.contains(x, y2) && poly.contains(x2, y2))) {
                        if (position == 0.66) {
                            position = 0.5;
                        } else if (position == 0.5) {
                            position = 0.66;
                            diffX = (int)((double)Math.abs(theSlice.m_ptCenter.x - tipX) * position);
                            diffY = (int)((double)Math.abs(theSlice.m_ptCenter.y - tipY) * position);
                            centerX = theSlice.m_ptCenter.x > tipX ? tipX + diffX : tipX - diffX;
                            centerY = theSlice.m_ptCenter.y > tipY ? tipY + diffY : tipY - diffY;
                        }
                        ++i;
                        continue;
                    }
                    ** GOTO lbl114
                }
                ** GOTO lbl114
lbl104:
                // 1 sources

                if (theSlice.m_polyRing != null) {
                    tipX = theSlice.m_polyRing.xpoints[theSlice.m_polyRing.npoints / 2];
                    tipY = theSlice.m_polyRing.ypoints[theSlice.m_polyRing.npoints / 2];
                } else {
                    tipX = theSlice.m_ptRingRight.x;
                    tipY = theSlice.m_ptRingRight.y;
                }
                diffX = (int)((double)Math.abs(theSlice.m_ptCenter.x - tipX) * position);
                diffY = (int)((double)Math.abs(theSlice.m_ptCenter.y - tipY) * position);
                centerX = theSlice.m_ptCenter.x > tipX ? tipX + diffX : tipX - diffX;
                centerY = theSlice.m_ptCenter.y > tipY ? tipY + diffY : tipY - diffY;
lbl114:
                // 3 sources

                x = centerX - this.m_labelDimVC.width / 2;
                rLabel = new Rectangle(x, centerY - this.m_labelDimVC.height / 2, this.m_labelDimVC.width, this.m_labelDimVC.height);
                break;
            }
        }
        this.m_nPieFeelerTextDisplay = savedValue;
        if (this.m_gt.isPieBarType()) {
            idBackground = new IdentObj(388, theSlice.m_nSeriesID);
            idBackground.setMiscID(theSlice.m_nGroupID);
        } else {
            idBackground = new IdentObj(388, theSlice.m_nSeriesID, theSlice.m_nGroupID);
        }
        blackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
        theSlice.setLabel(new DetLabel(this.m_Detectiv, id, (String)this.m_vectStrLabels.elementAt(theSlice.m_nSliceIdx), this.m_fullSliceLabels[theSlice.m_nSliceIdx], rLabel, this.m_textStyleFeelers, blackBoxLabel, false));
    }

    protected void drawSliceCrust(PieSliceObj theSlice) {
        IdentObj id;
        int nObjectID = this.getSliceObjectID(299);
        int s = theSlice.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(nObjectID, s);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(nObjectID, s, theSlice.m_nGroupID);
        }
        SimpleBlackBoxObj blackBox = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, theSlice.m_nGroupID), this.m_bWantRiserBorder);
        Polygon polygon = this.createCrustPoly(theSlice);
        id.setMiscID(4000 + theSlice.m_nSliceIdx);
        double fIntensity = 0.6;
        if (polygon != null) {
            new DetPolygon(this.m_Detectiv, id, polygon, (BlackBoxIF)blackBox, fIntensity, false, this.m_area);
        }
    }

    protected void drawSliceLeftEdge(PieSliceObj theSlice) {
        IdentObj id;
        double fIntensity = 0.8;
        int nObjectID = this.getSliceObjectID(299);
        int s = theSlice.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(nObjectID, s);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(nObjectID, s, theSlice.m_nGroupID);
        }
        BlackBoxIF blackBox = this.assignSeriesColor(s, theSlice.m_nGroupID);
        blackBox.runRules(s, theSlice.m_nGroupID);
        Polygon polygon = this.createLeftPoly(theSlice);
        id.setMiscID(2000 + theSlice.m_nSliceIdx);
        if (polygon != null) {
            new DetPolygon(this.m_Detectiv, id, polygon, blackBox, fIntensity, false);
        }
    }

    protected void drawSliceRightEdge(PieSliceObj theSlice) {
        IdentObj id;
        double fIntensity = 0.4;
        int nObjectID = this.getSliceObjectID(299);
        int s = theSlice.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(nObjectID, s);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(nObjectID, s, theSlice.m_nGroupID);
        }
        BlackBoxIF blackBox = this.assignSeriesColor(s, theSlice.m_nGroupID);
        blackBox.runRules(s, theSlice.m_nGroupID);
        Polygon polygon = this.createRightPoly(theSlice);
        id.setMiscID(3000 + theSlice.m_nSliceIdx);
        if (polygon != null) {
            new DetPolygon(this.m_Detectiv, id, polygon, blackBox, fIntensity, false);
        }
    }

    protected void drawSliceRing(PieSliceObj theSlice) {
        IdentObj id;
        if (this.m_fRingPct <= 0.0) {
            return;
        }
        double fIntensity = 0.6;
        int nObjectID = this.getSliceObjectID(299);
        int s = theSlice.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(nObjectID, s);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(nObjectID, s, theSlice.m_nGroupID);
        }
        BlackBoxIF blackBox = this.assignSeriesColor(s, theSlice.m_nGroupID);
        blackBox.runRules(s, theSlice.m_nGroupID);
        Polygon polygon = this.createRingPoly(theSlice);
        id.setMiscID(5000 + theSlice.m_nSliceIdx);
        if (polygon != null) {
            new DetPolygon(this.m_Detectiv, id, polygon, blackBox, fIntensity, false);
        }
    }

    protected void drawSliceTop(PieSliceObj theSlice) {
        IdentObj id;
        int nObjectID = this.getSliceObjectID(298);
        int s = theSlice.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(nObjectID, s);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(nObjectID, s, theSlice.m_nGroupID);
        }
        Polygon polygon = this.createTopPoly(theSlice);
        if (this.m_arc2D != null) {
            Rectangle2D b = this.m_arc2D.getBounds2D();
            this.m_smallMarker = b != null && (b.getHeight() <= 10.0 || b.getWidth() <= 10.0);
        }
        BlackBoxIF blackBox = this.assignSeriesColor(s, theSlice.m_nGroupID);
        blackBox.runRules(s, theSlice.m_nGroupID);
        id.setMiscID(1000);
        if (this.m_arc2D == null) {
            Point pt = this.m_VC.virtToDest(theSlice.m_ptTip);
            int x = (int)((double)pt.x - this.m_xRadius);
            int y = (int)((double)pt.y - this.m_yRadius);
            int w = (int)(this.m_xRadius * 2.0);
            int h = (int)(this.m_yRadius * 2.0);
            new DetPolygon(this.m_Detectiv, id, polygon, blackBox, new Rectangle(x, y, w, h), 1.0, true);
        } else if (polygon != null) {
            new DetPolygon(this.m_Detectiv, id, polygon, blackBox, 1.0, true, this.m_arc2D);
        }
    }

    public double getGroupTotal(int g) {
        double fPosSum = 0.0;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            DatumObj dobj = this.getDataValue(s, g);
            double fValue = dobj.m_fValue;
            if (fValue > 0.0) {
                fPosSum += fValue;
                this.m_positiveVal = true;
                continue;
            }
            if (fValue == 0.0 && dobj.m_bOK) {
                this.m_zeroVal = true;
                continue;
            }
            if (!(fValue < 0.0)) continue;
            this.m_negativeVal = true;
        }
        return fPosSum;
    }

    public double getSeriesTotal(int s) {
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        double fPosSum = 0.0;
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            DatumObj dobj = this.getDataValue(s, g);
            double fValue = dobj.m_fValue;
            if (fValue > 0.0) {
                fPosSum += fValue;
                this.m_positiveVal = true;
                continue;
            }
            if (fValue == 0.0 && dobj.m_bOK) {
                this.m_zeroVal = true;
                continue;
            }
            if (!(fValue < 0.0)) continue;
            this.m_negativeVal = true;
        }
        return fPosSum;
    }

    public double getSumTotal() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        double fPosSum = 0.0;
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                double fValue = this.getDataValue((int)s, (int)g).m_fValue;
                if (!(fValue > 0.0)) continue;
                fPosSum += fValue;
            }
        }
        return fPosSum;
    }

    private void createSeriesPartOfOther(int nNumSeries, int nNumGroups) {
        this.m_bSeriesPartOfOther = new boolean[nNumSeries][nNumGroups];
        int nSeries = 0;
        while (nSeries < nNumSeries) {
            int nGroup = 0;
            while (nGroup < nNumGroups) {
                this.m_bSeriesPartOfOther[nSeries][nGroup] = false;
                ++nGroup;
            }
            ++nSeries;
        }
    }

    private void createSeriesDrawn(int nNumSeries, int nNumGroups) {
        this.m_bSeriesDrawn = new boolean[nNumSeries][nNumGroups];
        int nSeries = 0;
        while (nSeries < nNumSeries) {
            int nGroup = 0;
            while (nGroup < nNumGroups) {
                this.m_bSeriesDrawn[nSeries][nGroup] = false;
                ++nGroup;
            }
            ++nSeries;
        }
    }

    private void setSeriesPartOfOther(int nSeries, int nGroup, boolean bValue) {
        if (this.m_bSeriesPartOfOther != null) {
            this.m_bSeriesPartOfOther[nSeries][nGroup] = bValue;
        }
        if (bValue) {
            this.m_bOtherPercentage = true;
        }
    }

    private void setSeriesDrawn(int nSeries, int nGroup, boolean bValue) {
        if (this.m_bSeriesDrawn != null) {
            this.m_bSeriesDrawn[nSeries][nGroup] = bValue;
        }
    }

    protected boolean isSeriesPartOfOther(int nSeries) {
        boolean bSeriesIsPartOfOther = false;
        if (this.m_Perspective.getOtherSeries() && this.m_bSeriesDrawn != null && this.m_bSeriesPartOfOther != null) {
            int nGraphType = this.m_Perspective.getGraphType();
            switch (nGraphType) {
                default: {
                    return bSeriesIsPartOfOther;
                }
                case 55: 
                case 56: 
                case 93: 
                case 94: {
                    bSeriesIsPartOfOther = this.m_bSeriesPartOfOther[nSeries][0];
                    break;
                }
                case 57: 
                case 58: 
                case 59: 
                case 60: {
                    int nNumSeriesAssignedToOther = this.getNumSeriesAssignedToOther(nSeries);
                    if (nNumSeriesAssignedToOther != this.m_nTotalGroups) break;
                    bSeriesIsPartOfOther = true;
                    break;
                }
            }
            int nNumSeriesDrawn = this.getNumSeriesDrawn(nSeries);
            bSeriesIsPartOfOther = nNumSeriesDrawn <= 0;
        }
        return bSeriesIsPartOfOther;
    }

    private int getNumSeriesAssignedToOther(int nSeries) {
        int nNumSeriesAssignedToOther = 0;
        int nGroup = 0;
        while (nGroup < this.m_nTotalGroups) {
            boolean bOther = this.m_bSeriesPartOfOther[nSeries][nGroup];
            if (bOther) {
                ++nNumSeriesAssignedToOther;
            }
            ++nGroup;
        }
        return nNumSeriesAssignedToOther;
    }

    private int getNumSeriesDrawn(int nSeries) {
        int nGroup = 0;
        int nNumSeriesDrawn = 0;
        while (nGroup < this.m_nTotalGroups) {
            boolean bDrawn = this.m_bSeriesDrawn[nSeries][nGroup];
            if (bDrawn) {
                ++nNumSeriesDrawn;
            }
            ++nGroup;
        }
        return nNumSeriesDrawn;
    }

    protected boolean getOtherPercentageFlag() {
        return this.m_bOtherPercentage;
    }

    public int getBarThickness() {
        return 0;
    }

    protected double getPieRotation() {
        double fPieRotAngle = (double)this.m_Perspective.getPieRotate() / 360.0;
        return fPieRotAngle;
    }

    protected int getSliceObjectID(int nDefaultID) {
        return nDefaultID;
    }

    protected boolean isPieBarSliceOK() {
        return false;
    }

    protected void calcDrillLabel() {
        this.m_drillLabel = new IdentObj(232);
        this.m_drillLabelBox = new IdentObj(230);
        IdentObj title = this.getTitle();
        if (title == null) {
            return;
        }
        Dimension dimTitleVC = new Dimension(0, 0);
        IdentObj box = this.getTitleBox();
        String strTitle = this.m_Perspective.getTextString(title);
        if (this.m_Perspective.getDisplay(title) && strTitle.length() != 0) {
            TextStyleObj titleTextStyle = this.getTitleTextStyle();
            int nTitleFontSizeVC = this.getTitleFontSizeVC();
            int nDestTitleFontSize = this.m_VC.virtToDestHeight(nTitleFontSizeVC);
            int fontSize = !this.m_Perspective.getFontSizeAbsolute(title) ? this.m_VC.virtToDestHeight(this.m_Perspective.getFontSizeVC(title)) : this.m_Perspective.getFontSize(title);
            int fontStyle = TextStyleObj.getJavaFontStyle(this.m_Perspective.getFontStyle(title));
            String fontName = this.m_Perspective.getFontName(title);
            Graphics g = this.m_Perspective.getGraphicsContext();
            Font font = new Font(fontName, fontStyle, fontSize);
            FontMetrics fm = g.getFontMetrics(font);
            Dimension dimMax = new Dimension(16000, 16000);
            dimMax = this.m_VC.virtToDest(dimMax);
            Dimension dimTitleDC = titleTextStyle.getTextSizeDC(g, strTitle, nDestTitleFontSize, this.m_VC, dimMax, null, this.m_Perspective.getFontMetricsResolver());
            dimTitleVC.width = this.m_VC.destToVirtWidth(dimTitleDC.width);
            dimTitleVC.height = this.m_VC.destToVirtHeight(dimTitleDC.height);
            Rectangle pieFrame = this.m_Perspective.getRect(this.m_Perspective.getPieFrame());
            this.m_drillLabelRect = new Rectangle();
            this.m_drillLabelRect.y = pieFrame.y - this.m_VC.destToVirtHeight(10) - dimTitleVC.height;
            this.m_drillLabelRect.width = pieFrame.width;
            this.m_drillLabelRect.height = dimTitleVC.height;
            this.m_drillLabelRect.x = pieFrame.x;
            int rectLength = this.m_VC.virtToDestWidth(this.m_drillLabelRect.width);
            if (!this.m_Perspective.getTextWrap(title) && rectLength < this.m_Perspective.getFontMetricsResolver().stringWidth(strTitle, fm)) {
                strTitle = PresUtils.truncateText(strTitle, fm, 2, rectLength, this.m_Perspective.getFontMetricsResolver());
                this.m_Perspective.setAxisTitleTruncated(true, 0, title);
            }
            if (this.m_Perspective.getDisplay(box)) {
                BlackBoxObj bbBox = new BlackBoxObj(this.m_Perspective, box);
                new DetRect(this.m_Perspective.getDetectiv(), box, this.m_drillLabelRect.x, this.m_drillLabelRect.y, this.m_drillLabelRect.width, this.m_drillLabelRect.height, bbBox, null, false, true, true);
            }
            BlackBoxObj titleBox = new BlackBoxObj(this.m_Perspective, title);
            new DetLabel(this.m_Perspective.getDetectiv(), title, strTitle, this.m_drillLabelRect, titleTextStyle, titleBox, this.m_Perspective.getMoveAxisTitles());
        }
    }

    protected TextStyleObj getTitleTextStyle() {
        IdentObj title = this.getTitle();
        boolean bAutofit = this.m_Perspective.getAutofit(title);
        int nTitleFontSizeVC = this.getTitleFontSizeVC();
        boolean bTitleFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(title);
        TextStyleObj titleTextStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(title), this.m_Perspective.getFontStyle(title), bTitleFontSizeAbsolute, this.m_Perspective.getFontSize(title), nTitleFontSizeVC, 0, this.m_Perspective.getTextJustHoriz(title), this.m_Perspective.getTextJustVert(title), bAutofit, false, this.m_Perspective.getTextWrap(title));
        titleTextStyle.setDisplayDrillIcon(true);
        int fontSize = this.m_VC.virtToDestHeight(nTitleFontSizeVC);
        if (fontSize < 18 && TextStyleObj.SMALL_DRILL_IMAGE == null) {
            TextStyleObj.SMALL_DRILL_IMAGE = TextStyleObj.getImageResource(TextStyleObj.class, "images/graph_drill_up.gif");
        } else if (fontSize >= 18 && TextStyleObj.LARGE_DRILL_IMAGE == null) {
            TextStyleObj.LARGE_DRILL_IMAGE = TextStyleObj.getImageResource(TextStyleObj.class, "images/large_drill_up.gif");
        }
        return titleTextStyle;
    }

    protected int getTitleFontSizeVC() {
        IdentObj title = this.getTitle();
        boolean bTitleFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(title);
        int nTitleFontSizeVC = bTitleFontSizeAbsolute ? this.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(title)) : this.m_Perspective.getFontSizeVC(title);
        return nTitleFontSizeVC;
    }

    protected IdentObj getTitle() {
        if (this.m_Perspective.getDrillCallback().isDrillingEnabled() && this.m_Perspective.getTextString(this.m_drillLabel) != null && this.m_Perspective.getDisplay(this.m_drillLabel)) {
            return this.m_drillLabel;
        }
        return null;
    }

    protected IdentObj getTitleBox() {
        if (this.m_Perspective.getDrillCallback().isDrillingEnabled() && this.m_Perspective.getTextString(this.m_drillLabel) != null && this.m_Perspective.getDisplay(this.m_drillLabel)) {
            return this.m_drillLabelBox;
        }
        return null;
    }

    public JChart_2D_Pie() {
        this.$init$();
    }
}

