/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Circular;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class JChart_2D_Polar
extends JChart_2D_Circular {
    public void calc() {
        super.calc();
        this.m_Perspective.calcReferenceObjects(1);
        if (this.m_nDepthRadius > 0) {
            this.drawAllMarkersWithDepth(false);
        } else {
            this.drawMarkers();
        }
        this.drawLabels();
    }

    public boolean wantLegend() {
        return true;
    }

    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        String ResultString = dataTextTemplate;
        ResultString = this.ReplaceMacro(ResultString, "[X]", dataItems[0]);
        ResultString = this.ReplaceMacro(ResultString, "[Y]", dataItems[1]);
        return ResultString;
    }

    public double getLabelXValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XY_LBL_X;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getLabelYValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XY_LBL_Y;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XY_X;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXYZ_XValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XYZ_X;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXYZ_YValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XYZ_Y;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXYZ_ZValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XYZ_Z;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getYValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XY_Y;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    protected void drawLabels() {
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Vector<String> vectStrLabels = null;
        IdentObj id = this.m_Perspective.getDataText();
        DataFormat df = this.m_Access.getDataFormat();
        int nItems = df.getNumDataItems();
        Rectangle rClip = this.m_Perspective.getFrameRect(true);
        if (this.m_bDataTextDisplay) {
            int g;
            int s;
            vectStrLabels = new Vector<String>(this.m_nSeries * this.m_nGroups);
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                gEnum.reset();
                while (gEnum.hasMoreElements()) {
                    g = gEnum.nextGroup();
                    PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                    if (!this.m_dataOK[s][g]) continue;
                    vectStrLabels.addElement(this.m_DataLabel[s][g]);
                }
            }
            Dimension labelDim = new Dimension(5000, 1600);
            boolean bScatLabelFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
            TextStyleObj textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bScatLabelFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), 2, this.m_Perspective.getTextJustVert(id), false, false, this.m_Perspective.getTextWrap(id));
            int nFontSizeVC = bScatLabelFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id)) : this.m_Perspective.getFontSizeVC(id);
            Graphics gx = this.m_Perspective.getGraphicsContext();
            textStyle.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(new IdentObj(260, -3, -3)), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, vectStrLabels, labelDim, this.m_Perspective.m_VC);
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                gEnum.reset();
                while (gEnum.hasMoreElements()) {
                    g = gEnum.nextGroup();
                    PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                    if (!this.m_dataOK[s][g] || this.m_DataLabel[s][g] == null) continue;
                    BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
                    Rectangle rLabel = this.calcDataValuePosition(s, g, labelDim);
                    if (rLabel == null) continue;
                    IdentObj newID = new IdentObj(id.getObjectID(), s, g);
                    new DetLabel(this.m_Detectiv, newID, this.m_DataLabel[s][g], rLabel, textStyle, (BlackBoxIF)blackBox, false, rClip);
                }
            }
        }
    }

    protected Rectangle calcDataValuePosition(int s, int g, Dimension labelDim) {
        int width = labelDim.width;
        int height = labelDim.height;
        int x1 = this.m_numXCoords[s][g];
        int y1 = this.m_numYCoords[s][g];
        Rectangle rDataValue = new Rectangle(x1, y1, width, height);
        return rDataValue;
    }
}

