/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import oracle.dss.graph.managers.GraphStyle;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.AxisDescriptor;
import oracle.dss.graph.pfj.AxisSplits;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DataTextPosition;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D;
import oracle.dss.graph.pfj.Line;
import oracle.dss.graph.pfj.MarkerObj;
import oracle.dss.graph.pfj.MarkerTemplate;
import oracle.dss.graph.pfj.MarkerTemplateArray;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.ZoomState;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetPolyline;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.Polyline;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.graph.pfj.math.CurveFitIF;
import oracle.dss.graph.pfj.math.SVD;

public abstract class JChart_2D_Standard
extends JChart_2D {
    public static final int NO_PREVIOUS_SERIES = -2;
    static final int TWOD_MARKER_FIXUP = 3;
    RelativeAxisObj m_O1Axis;
    RelativeAxisObj m_X1Axis;
    RelativeAxisObj m_Y1Axis;
    RelativeAxisObj m_Y2Axis;
    RelativeAxisObj m_Z1Axis;
    RelativeAxisObj m_Y3Axis;
    RelativeAxisObj m_Y4Axis;
    RelativeAxisObj m_Y5Axis;
    int m_scaling;
    int[][] m_ordCoords;
    int m_barThickCoord;
    int[][] m_numXCoords;
    int[][] m_numYCoords;
    boolean[][] m_dataOK;
    String[][] m_DataLabel;
    boolean m_bDataTextDisplay;
    boolean m_bHorz;
    boolean m_bExtendToFrameEdge;
    boolean m_bIsThisAComboWithBar;
    boolean m_bSquareMarkers;
    boolean m_bMarkerDisplay;
    boolean m_bAllMarkersSameSize;
    int m_nMarkerSizeDefault;
    double[][] m_fStackedCumulativeValues;
    double[][] m_fPercentCumulativeValues;
    SeriesEnumerator m_sEnumReverseForPrev;
    int[][] m_nParetoYCoordsVC;
    int[][] m_nParetoCoordsVC;
    int[] m_nMaxParetoYCoords;
    int[] m_nPercentParetoValues;
    double[] m_fMaxParetoActuals;
    double[] m_fMinParetoActuals;
    double[][] m_fParetoYCoords;
    ArrayList m_bubbleMarkerInfo;
    private static Comparator m_bubbleComparator = new 1();

    public void calc() {
        super.calc();
        this.m_positiveValY1 = false;
        this.m_negativeValY1 = false;
        this.m_zeroValY1 = false;
        this.m_nullValY1 = false;
        this.m_positiveValY2 = false;
        this.m_negativeValY2 = false;
        this.m_zeroValY2 = false;
        this.m_nullValY2 = false;
        this.m_positiveValX1 = false;
        this.m_negativeValX1 = false;
        this.m_zeroValX1 = false;
        this.m_nullValX1 = false;
        this.m_dualY = false;
        this.m_XY = false;
        this.m_dualYX = false;
        this.createAxes();
        int nBorderWidth = this.m_Perspective.getLineWidth(this.m_Perspective.getFrame());
        if (this.m_Frame != null && this.m_Perspective.getFrameDisplay()) {
            this.m_Frame.drawFrameBorders(nBorderWidth);
        }
        this.drawAxisBody();
        if (this.m_bAbsolute) {
            this.calcDataAbsolute();
        } else if (this.m_bStacked) {
            this.calcDataStacked();
        } else if (this.m_gt.isScalingPercent()) {
            this.calcDataPercent();
        } else if (this.m_gt.isScalingWaterfall()) {
            this.calcDataWaterfall();
        }
        if (this.m_Perspective.isContinuousTimeAxis() && this.m_gt.isBLAType()) {
            this.m_O1Axis.setXCordinates(this.m_numXCoords);
        }
        if (this.m_Perspective.getGraphType() != 96) {
            this.fireInapropriateDataEvent();
        }
    }

    protected void calcBarOrdinalCoords() {
        SeriesEnumerator sEnum = this.m_sEnumForward;
        GroupsEnumerator gEnum = this.m_gEnumForward;
        int axisOffset = 0;
        this.m_ordCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_barThickCoord = (int)(this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0));
        this.m_smallMarker = this.m_Perspective.m_VC.virtToDestWidth(this.m_barThickCoord) <= 3;
        int sRel = 0;
        while (sRel < this.m_nSeries) {
            int s = sEnum.seriesAt(sRel);
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            int axis = this.getAxisAssignment(s);
            axisOffset = 0;
            if (this.m_gt.isDualY() && this.m_bStacked && axis == 1) {
                axisOffset = 1;
            }
            int gRel = 0;
            while (gRel < this.m_nGroups) {
                int g = gEnum.groupAt(gRel);
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                this.m_ordCoords[s][g] = this.m_bAbsolute ? (int)this.m_O1Axis.getLowCoord(sRel, gRel) : (this.m_nTotalSeries > 1 ? (int)this.m_O1Axis.getLowCoord(axisOffset, gRel) : (int)this.m_O1Axis.getLowCoord(sRel, gRel));
                ++gRel;
            }
            ++sRel;
        }
    }

    protected void calcDataAbsolute() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        AxisDescriptor axisDescriptor = null;
        axisDescriptor = this.m_Perspective.isContinuousTimeAxis() && this.m_gt.isBLAType() ? AxisDescriptor.AD_XY : this.m_gt.getAxisDescriptor();
        RelativeAxisObj axisObj = null;
        double fValue = 0.0;
        boolean bUseXAxis = axisDescriptor.hasX1();
        DataFormat df = this.m_Access.getDataFormat();
        int nItems = df.getNumDataItems();
        boolean bScatter = this.m_gt.isScatter();
        boolean bBubble = this.m_gt.isBubble();
        boolean bScatterLabels = this.m_gt.isScatterWithLabel();
        int nDataFormat = this.m_Perspective.getDataTextFormat();
        String szFormatPattern = this.m_Perspective.getDataTextFormatPattern();
        String sDataTextTemplate = "";
        String[] dataItemStringArray = new String[nItems];
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        if (bUseXAxis) {
            this.m_numXCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        if (bScatterLabels || this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        if ((bScatter || bBubble) && !bScatterLabels && this.m_bDataTextDisplay) {
            sDataTextTemplate = bBubble ? this.m_Perspective.getDataTextTemplateBubble() : this.m_Perspective.getDataTextTemplateScatter();
        }
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            if (s >= this.m_nTotalSeries) break;
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                DataItem item;
                int g = gEnum.nextGroup();
                this.m_dataOK[s][g] = true;
                boolean bDataLabelDecided = false;
                if ((bScatter || bBubble) && !bScatterLabels && this.m_bDataTextDisplay) {
                    int i = 0;
                    while (i < nItems) {
                        item = df.getDataItem(i);
                        DatumObj dObj = this.getDataValue(s, g, item);
                        fValue = dObj.m_fValue;
                        if (bNumberFormatCallBackActive) {
                            int nAxisID = this.axisAssignedToSeries(s, item);
                            this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                            dataItemStringArray[i] = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                        } else {
                            dataItemStringArray[i] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fValue, szFormatPattern);
                        }
                        ++i;
                    }
                    this.m_DataLabel[s][g] = this.processDataTextTemplate(dataItemStringArray, sDataTextTemplate);
                    bDataLabelDecided = true;
                }
                int i = 0;
                while (i < nItems) {
                    block29: {
                        item = df.getDataItem(i);
                        try {
                            if (item.isLabel()) {
                                if (this.m_Access.isCellNumeric(s, g, item)) {
                                    fValue = this.getDataValue((int)s, (int)g, (DataItem)item).m_fValue;
                                    if (bNumberFormatCallBackActive) {
                                        int nAxisID = this.axisAssignedToSeries(s, item);
                                        this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                                        this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                                    } else {
                                        this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fValue, szFormatPattern);
                                    }
                                } else {
                                    this.m_DataLabel[s][g] = this.m_Access.getDataAsString(s, g, item);
                                }
                            } else {
                                axisObj = this.whichAxisForSeries(s, item);
                                if (axisObj != null) {
                                    DatumObj dObj = this.getDataValue(s, g, item);
                                    fValue = dObj.m_fValue;
                                    if (!dObj.m_bOK) {
                                        this.m_dataOK[s][g] = dObj.m_bOK;
                                    }
                                    if (fValue <= 0.0 && this.isBadValueInLogscale(axisObj, fValue)) {
                                        this.m_dataOK[s][g] = false;
                                        fValue = 0.0;
                                    }
                                    if (this.isIgnoredOffScale(axisObj, fValue)) {
                                        this.m_dataOK[s][g] = false;
                                        fValue = 0.0;
                                    }
                                }
                            }
                        }
                        catch (AssertionException e) {
                            if (!item.isRequired()) break block29;
                            this.m_dataOK[s][g] = false;
                            fValue = 0.0;
                        }
                    }
                    if (!item.isLabel() && axisObj != null) {
                        if (item.getAssocAxis() == 0) {
                            this.m_numYCoords[s][g] = (int)axisObj.getValueCoord(fValue);
                        } else if (item.getAssocAxis() == 7) {
                            this.m_numXCoords[s][g] = (int)axisObj.getValueCoord(fValue);
                        }
                        if (this.m_bDataTextDisplay && !bDataLabelDecided) {
                            if (bNumberFormatCallBackActive) {
                                int nAxisID = this.axisAssignedToSeries(s, item);
                                this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                                this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                            } else {
                                this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fValue, szFormatPattern);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected void calcDataPercent() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int nDataFormat = 2;
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_fPercentCumulativeValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        while (gEnum.hasMoreElements()) {
            double fValue;
            int s;
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            double fPosTotal = 0.0;
            double fNegTotal = 0.0;
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                DatumObj dObj = this.getDataValue(s, g);
                fValue = dObj.m_fValue;
                this.m_dataOK[s][g] = dObj.m_bOK;
                if (fValue >= 0.0) {
                    fPosTotal += fValue;
                    continue;
                }
                fNegTotal += fValue;
            }
            fNegTotal = -fNegTotal;
            double fTotTotal = fPosTotal + fNegTotal;
            double fPosRatio = fPosTotal / fTotTotal;
            double fNegRatio = fNegTotal / fTotTotal;
            double fPosSum = 0.0;
            double fNegSum = 0.0;
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, DataItem.DI_GENERAL);
                if (yAxisObj == null) continue;
                fValue = this.getDataValue((int)s, (int)g).m_fValue;
                if (fValue >= 0.0 && fPosTotal > 0.0) {
                    this.m_fPercentCumulativeValues[s][g] = fPosRatio * (fPosSum += fValue) / fPosTotal;
                    this.m_numYCoords[s][g] = (int)yAxisObj.getValueCoord(fPosRatio * fPosSum / fPosTotal);
                    if (!this.m_bDataTextDisplay) continue;
                    if (bNumberFormatCallBackActive) {
                        int nAxisID = this.axisAssignedToSeries(s, DataItem.DI_GENERAL);
                        this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                        this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fPosRatio * fValue / fPosTotal);
                        continue;
                    }
                    this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fPosRatio * fValue / fPosTotal, "");
                    continue;
                }
                if (fValue < 0.0 && fNegTotal < 0.0) {
                    this.m_fPercentCumulativeValues[s][g] = fNegRatio * (fNegSum += fValue) / fNegTotal;
                    this.m_numYCoords[s][g] = (int)yAxisObj.getValueCoord(fNegRatio * fNegSum / fNegTotal);
                    if (!this.m_bDataTextDisplay) continue;
                    if (bNumberFormatCallBackActive) {
                        int nAxisID = this.axisAssignedToSeries(s, DataItem.DI_GENERAL);
                        this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                        this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fNegRatio * fValue / fNegTotal);
                        continue;
                    }
                    this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fNegRatio * fValue / fNegTotal, "");
                    continue;
                }
                this.m_dataOK[s][g] = false;
            }
        }
    }

    protected void calcParetoData() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        double fAccum = 0.0;
        double fValue = 0.0;
        int nTotalZeroCount = 0;
        this.m_nParetoYCoordsVC = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_nParetoCoordsVC = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_nMaxParetoYCoords = new int[this.m_nTotalSeries];
        this.m_fParetoYCoords = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            this.m_nMaxParetoYCoords[s] = 0;
            fAccum = 0.0;
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                if (axisObj == null) continue;
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                fValue = dObj.m_fValue;
                fAccum += Math.abs(fValue);
                if (fValue <= 0.0) {
                    ++nTotalZeroCount;
                    fValue = 0.0;
                }
                this.m_nParetoYCoordsVC[s][g] = (int)axisObj.getValueCoord(fAccum);
                this.m_fParetoYCoords[s][g] = fAccum;
                this.m_nParetoCoordsVC[s][g] = (int)this.m_O1Axis.getLowCoord(s, g);
                int n = s;
                this.m_nMaxParetoYCoords[n] = this.m_nMaxParetoYCoords[n] + this.m_nParetoYCoordsVC[s][g];
            }
        }
    }

    public double getParetoValue(int nSeries, int nGroup) {
        return this.m_fParetoYCoords[nSeries][nGroup];
    }

    public double getPercentCumulativeValue(int nSeries, int nGroup) {
        double fValue = 0.0;
        if (this.m_fPercentCumulativeValues != null) {
            fValue = this.m_fPercentCumulativeValues[nSeries][nGroup];
        }
        return fValue;
    }

    protected void calcDataStacked() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int sFirst = sEnum.getFirstSeries();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_fStackedCumulativeValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            SumObj sumObj = new SumObj();
            SumObj totalObj = this.getGroupTotals(g);
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                int s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, DataItem.DI_GENERAL);
                if (yAxisObj == null) continue;
                DatumObj dObj = this.getDataValue(s, g);
                double fValue = dObj.m_fValue;
                this.m_dataOK[s][g] = dObj.m_bOK;
                if (fValue <= 0.0 && this.isBadValueInLogscale(yAxisObj, fValue)) {
                    fValue = 0.0;
                    this.m_dataOK[s][g] = false;
                }
                double fNewSum = this.processOneStackedValue(s, g, yAxisObj, fValue, sumObj);
                int nRiser = this.m_seriesTypes[s];
                int nAxis = this.getAxisAssignment(s);
                boolean bY2 = nAxis == 1;
                boolean bPos = fValue >= 0.0;
                double accValue = fNewSum;
                if (this.m_gt.isWaterfall() && nRiser != 1 || !this.m_gt.isWaterfall() && !this.m_Perspective.isMarkerTypeStacked(nRiser)) {
                    accValue = fValue;
                }
                this.m_fStackedCumulativeValues[s][g] = accValue;
                if (!this.m_bDataTextDisplay) continue;
                this.calcDataLabel(bPos, bY2, s, g, nRiser, fValue, sumObj, totalObj);
            }
        }
    }

    protected void calcDataWaterfall() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int gFirst = gEnum.getFirstGroup();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_fStackedCumulativeValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            SumObj sumObj = new SumObj();
            SumObj totalObj = this.getGroupTotals(g);
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                double fEndOfPreviousStack;
                int s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, DataItem.DI_GENERAL);
                if (yAxisObj == null) continue;
                DatumObj dObj = this.getDataValue(s, g);
                double fValue = dObj.m_fValue;
                this.m_dataOK[s][g] = dObj.m_bOK;
                if (this.m_gt.isWaterfall() && !sumObj.m_bFirstTime && sumObj.m_bFirstSetIsPositive == fValue < 0.0) {
                    fValue = -fValue;
                }
                if (fValue <= 0.0 && this.isBadValueInLogscale(yAxisObj, fValue)) {
                    fValue = 0.0;
                    this.m_dataOK[s][g] = false;
                }
                double fNewSum = this.processOneStackedValue(s, g, yAxisObj, fValue, sumObj);
                if (this.m_gt.isWaterfall() && g != gFirst) {
                    int gPrev = gEnum.peekAtGroupBefore(g);
                    PfjAssert.pfjAssert(gPrev != -1);
                    int sLast = sEnum.getLastSeries();
                    fEndOfPreviousStack = this.m_fStackedCumulativeValues[sLast][gPrev];
                    this.m_numYCoords[s][g] = (int)yAxisObj.getValueCoord(fNewSum += fEndOfPreviousStack);
                } else {
                    fEndOfPreviousStack = 0.0;
                }
                int nAxis = this.getAxisAssignment(s);
                boolean bY2 = nAxis == 1;
                boolean bPos = fValue >= 0.0;
                int nRiser = this.m_seriesTypes[s];
                this.m_fStackedCumulativeValues[s][g] = sumObj.getSum(bPos, bY2, nRiser) + fEndOfPreviousStack;
                if (!this.m_bDataTextDisplay) continue;
                this.calcDataLabel(bPos, bY2, s, g, nRiser, fValue, sumObj, totalObj);
            }
        }
    }

    protected SumObj getGroupTotals(int g) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        SumObj totalObj = new SumObj();
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, DataItem.DI_GENERAL);
            if (yAxisObj == null) continue;
            DatumObj dObj = this.getDataValue(s, g);
            double fValue = dObj.m_fValue;
            this.m_dataOK[s][g] = dObj.m_bOK;
            if (fValue <= 0.0 && this.isBadValueInLogscale(yAxisObj, fValue)) {
                fValue = 0.0;
                this.m_dataOK[s][g] = false;
            }
            this.processOneStackedValue(s, g, yAxisObj, fValue, totalObj);
        }
        return totalObj;
    }

    private void calcDataLabel(boolean bPos, boolean bY2, int s, int g, int nRiser, double fValue, SumObj sumObj, SumObj totalObj) {
        String szDataFormatPattern = this.m_Perspective.getDataTextFormatPattern();
        int nDataFormat = this.m_Perspective.getDataTextFormat();
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        double fNewSum = sumObj.getSum(bPos, bY2, nRiser);
        if (this.m_Perspective.getStackedDataValueSum()) {
            if (TDGNumberFormat.isPercentFormat(nDataFormat)) {
                double fTotal = totalObj.getSum(bPos, bY2, nRiser);
                fNewSum /= fTotal;
            }
            if (this.m_gt.isWaterfall()) {
                fNewSum = this.m_fStackedCumulativeValues[s][g];
            }
        } else {
            fNewSum = fValue;
        }
        if (bNumberFormatCallBackActive) {
            int nAxisID = this.axisAssignedToSeries(s, DataItem.DI_GENERAL);
            this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
            this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fNewSum);
        } else {
            this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fNewSum, szDataFormatPattern);
        }
    }

    public double getStackedCumulativeValue(int nSeries, int nGroup) {
        double fValue = 0.0;
        if (this.m_fStackedCumulativeValues != null) {
            fValue = this.m_fStackedCumulativeValues[nSeries][nGroup];
        }
        return fValue;
    }

    protected void calcOrdinalCoords() {
        PfjAssert.pfjAssert(this.m_O1Axis != null);
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.m_gEnumForward;
        this.m_ordCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_barThickCoord = (int)(this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0));
        int gRel = 0;
        while (gRel < this.m_nGroups) {
            int g = gEnum.groupAt(gRel);
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            int nOrdCoord = (int)this.m_O1Axis.getCenterCoord(gRel);
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                int s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                this.m_ordCoords[s][g] = nOrdCoord;
            }
            ++gRel;
        }
    }

    protected int calcRisersPerPixel() {
        int nRisersPerPixel;
        if (this.m_gt.getIntegerGraphType() != 17 && this.m_gt.getIntegerGraphType() != 24 && this.m_gt.getIntegerGraphType() != 97) {
            return 1;
        }
        if (this.isComboWithNonBar() || this.m_Frame == null) {
            return 1;
        }
        Rectangle rFrame = this.m_Frame.getBackWallBounds();
        int nPixels = this.m_bHorz ? this.m_Perspective.m_VC.virtToDestHeight(rFrame.height) : this.m_Perspective.m_VC.virtToDestWidth(rFrame.width);
        if (nPixels == 0) {
            nRisersPerPixel = 1;
        } else {
            nRisersPerPixel = this.m_nSeries * this.m_nGroups / nPixels;
            if (nRisersPerPixel < 1) {
                nRisersPerPixel = 1;
            }
        }
        return nRisersPerPixel;
    }

    protected void copyParams() {
        super.copyParams();
        this.m_bHorz = this.m_gt.isOrientHorz();
        this.m_bDataTextDisplay = this.m_Perspective.getDataTextDisplay();
        this.m_sEnumReverseForPrev = new SeriesEnumerator(this.m_Perspective, this.m_Access, false);
        this.m_bExtendToFrameEdge = this.m_gt.isParetoType() ? false : this.m_Perspective.getExtendToFrameEdge();
        this.m_bIsThisAComboWithBar = this.isComboWithBar();
        this.m_bSquareMarkers = this.m_Perspective.getSquareMarkers();
        this.m_bMarkerDisplay = this.m_Perspective.getMarkerDisplay();
        this.m_nMarkerSizeDefault = this.m_Perspective.getMarkerSizeDefault();
    }

    protected void createAxes() {
        boolean bVerticalChart;
        AxisDescriptor axisDescriptor = this.m_gt.getAxisDescriptor();
        AxisSplits axisSplits = new AxisSplits(this.m_Perspective);
        axisSplits.calc();
        int[] offsetArray = axisSplits.getAxisOffsets();
        int[] sizeArray = axisSplits.getAxisSizes();
        axisSplits.releaseReferences();
        axisSplits = null;
        this.m_scaling = this.m_gt.getScalingMethod();
        int ordType = this.whichOrdType();
        this.m_Perspective.setMinimumAxisTextSizeVC(16000);
        int nSaveMode = this.m_Perspective.getAxisTextAutofitMode();
        this.m_Perspective.setAxisTextAutofitMode(0);
        if (nSaveMode != 0) {
            this.m_Perspective.setTestLabelCalc(true);
        } else {
            this.m_Perspective.setTestLabelCalc(false);
        }
        boolean bl = bVerticalChart = this.m_gt.getOrientation() == 2;
        if (axisDescriptor.hasZ1()) {
            this.createZ1Axis(bVerticalChart ^ true, true);
            this.calcAxis(this.m_Z1Axis);
        }
        if (axisDescriptor.hasO1()) {
            if (this.m_Perspective.isContinuousTimeAxis()) {
                this.createTimeAxis(bVerticalChart ^ true, this.m_Perspective.getX1AxisDescending() ^ true);
                this.calcAxis(this.m_O1Axis);
            } else {
                this.createOrdinalAxis(ordType, bVerticalChart ^ true, bVerticalChart);
                this.calcAxis(this.m_O1Axis);
            }
        } else if (axisDescriptor.hasX1()) {
            if (this.m_Perspective.isContinuousTimeAxis()) {
                this.createTimeAxis(bVerticalChart ^ true, this.m_Perspective.getX1AxisDescending() ^ true);
                this.calcAxis(this.m_O1Axis);
            } else {
                this.createX1Axis(bVerticalChart ^ true, this.m_Perspective.getX1AxisDescending() ^ true);
                this.calcAxis(this.m_X1Axis);
            }
        }
        if (axisDescriptor.hasY2()) {
            int y1Auto = 0;
            if (this.m_Perspective.getScaleMaxAuto(AxisTemplate.Y1_AXIS.getAxis())) {
                ++y1Auto;
            }
            if (this.m_Perspective.getScaleMinAuto(AxisTemplate.Y1_AXIS.getAxis())) {
                ++y1Auto;
            }
            if (!this.m_Perspective.getLogScale(AxisTemplate.Y1_AXIS.getAxis()) && this.m_Perspective.getGridStepAuto(AxisTemplate.Y1_AXIS.getMajor())) {
                ++y1Auto;
            }
            int y2Auto = 0;
            if (this.m_Perspective.getScaleMaxAuto(AxisTemplate.Y2_AXIS.getAxis())) {
                ++y2Auto;
            }
            if (this.m_Perspective.getScaleMinAuto(AxisTemplate.Y2_AXIS.getAxis())) {
                ++y2Auto;
            }
            if (!this.m_Perspective.getLogScale(AxisTemplate.Y2_AXIS.getAxis()) && this.m_Perspective.getGridStepAuto(AxisTemplate.Y2_AXIS.getMajor())) {
                ++y2Auto;
            }
            if (y1Auto <= y2Auto || this.m_gt.isParetoType() || this.m_gt.isStockType() || this.m_gt.isBipolar()) {
                this.createY1Axis(bVerticalChart, this.m_Perspective.getY1AxisDescending() ^ true, offsetArray[0], sizeArray[0]);
                if (this.m_Y1Axis != null) {
                    this.calcAxis(this.m_Y1Axis);
                }
                this.createY2Axis(bVerticalChart, this.m_Perspective.getY2AxisDescending() ^ true, offsetArray[1], sizeArray[1]);
                this.m_Y2Axis.m_requiredSteps = this.m_Y1Axis.m_numberOfSteps;
                this.calcAxis(this.m_Y2Axis);
            } else {
                this.createY2Axis(bVerticalChart, this.m_Perspective.getY2AxisDescending() ^ true, offsetArray[1], sizeArray[1]);
                this.calcAxis(this.m_Y2Axis);
                this.createY1Axis(bVerticalChart, this.m_Perspective.getY1AxisDescending() ^ true, offsetArray[0], sizeArray[0]);
                if (this.m_Y1Axis != null) {
                    this.m_Y1Axis.m_requiredSteps = this.m_Y2Axis.m_numberOfSteps;
                    this.calcAxis(this.m_Y1Axis);
                }
            }
        } else {
            this.createY1Axis(bVerticalChart, this.m_Perspective.getY1AxisDescending() ^ true, offsetArray[0], sizeArray[0]);
            if (this.m_Y1Axis != null) {
                this.calcAxis(this.m_Y1Axis);
            }
        }
        if (axisDescriptor.hasY3()) {
            this.createY3Axis(bVerticalChart, this.m_Perspective.getY3AxisDescending() ^ true, offsetArray[2], sizeArray[2]);
            this.calcAxis(this.m_Y3Axis);
        }
        if (axisDescriptor.hasY4()) {
            this.createY4Axis(bVerticalChart, this.m_Perspective.getY4AxisDescending() ^ true, offsetArray[3], sizeArray[3]);
            this.calcAxis(this.m_Y4Axis);
        }
        if (axisDescriptor.hasY5()) {
            this.createY5Axis(bVerticalChart, this.m_Perspective.getY5AxisDescending() ^ true, offsetArray[4], sizeArray[4]);
            this.calcAxis(this.m_Y5Axis);
        }
        this.m_Perspective.setAxisTextAutofitMode(nSaveMode);
        this.m_Perspective.setTestLabelCalc(false);
        if (this.m_Perspective.getAxisTextAutofitMode() != 0) {
            if (axisDescriptor.hasO1()) {
                if (this.m_O1Axis != null) {
                    this.m_O1Axis.calc();
                }
            } else if (axisDescriptor.hasX1() && this.m_X1Axis != null) {
                this.m_X1Axis.calc();
            }
            if (this.m_Y1Axis != null) {
                this.m_Y1Axis.calc();
            }
            if (axisDescriptor.hasY2() && this.m_Y2Axis != null) {
                this.m_Y2Axis.calc();
            }
            if (axisDescriptor.hasZ1() && this.m_Z1Axis != null) {
                this.m_Z1Axis.calc();
            }
        }
    }

    protected void calcAxis(RelativeAxisObj relAxis) {
        if (relAxis != null) {
            relAxis.calc();
            if (relAxis.getAxisTextLabelSizeVC() < this.m_Perspective.getMinimumAxisTextSizeVC()) {
                this.m_Perspective.setMinimumAxisTextSizeVC(relAxis.getAxisTextLabelSizeVC());
            }
        }
    }

    protected MinMaxObj createMinMaxZoom(RelativeAxisObj axis) {
        MinMaxObj minMaxZoom = null;
        if (axis == null) {
            return null;
        }
        PfjAssert.pfjAssert(this.isZoomingArmed());
        PfjAssert.pfjAssert(axis.isNumericAxis());
        ZoomState z = this.m_Perspective.getZoomList().getZoomState();
        if (z == null || !z.isZoomed()) {
            return null;
        }
        if (axis.isNumericAxis()) {
            minMaxZoom = z.getScaleMinMax(axis.getAxisObjID());
        }
        return minMaxZoom;
    }

    protected void createOrdinalAxis(int ordType, boolean bVerticalAxis, boolean bAscending) {
        this.m_O1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.O1_AXIS, ordType, bVerticalAxis, bAscending);
    }

    protected void createX1Axis(boolean bVerticalAxis, boolean bAscending) {
        MinMaxObj x1MinMaxZoom;
        boolean bMustIncludeZero = this.m_Perspective.getX1MustIncludeZero() && !this.m_Perspective.getX1LogScale();
        MinMaxObj x1MinMaxObj = this.findLimits(7, this.m_scaling, bMustIncludeZero, null);
        this.m_X1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, x1MinMaxObj, bVerticalAxis, bAscending, 0, 100);
        if (this.isZoomingArmed() && (x1MinMaxZoom = this.createMinMaxZoom(this.m_X1Axis)) != null) {
            this.m_X1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, x1MinMaxZoom, bVerticalAxis, bAscending, 0, 100);
        }
    }

    protected void createTimeAxis(boolean bVerticalAxis, boolean bAscending) {
        MinMaxObj x1MinMaxZoom;
        MinMaxObj x1MinMaxObj = this.findLimits(7, this.m_scaling, false, null);
        this.m_O1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, x1MinMaxObj, bVerticalAxis, bAscending, 0, 100);
        if (this.isZoomingArmed() && (x1MinMaxZoom = this.createMinMaxZoom(this.m_O1Axis)) != null) {
            this.m_O1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, x1MinMaxZoom, bVerticalAxis, bAscending, 0, 100);
        }
        this.m_O1Axis.setContinuousTimeAxis(true);
    }

    protected void createY1Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y1MinMaxZoom;
        boolean bMustIncludeZero = this.m_Perspective.getY1MustIncludeZero() && !this.m_Perspective.getY1LogScale();
        MinMaxObj y1MinMaxObj = this.findLimits(0, this.m_scaling, bMustIncludeZero, null);
        this.m_Y1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        if (this.isZoomingArmed() && (y1MinMaxZoom = this.createMinMaxZoom(this.m_Y1Axis)) != null) {
            this.m_Y1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, y1MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
    }

    protected void createY2Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y2MinMaxZoom;
        boolean bMustIncludeZero = this.m_Perspective.getY2MustIncludeZero() && !this.m_Perspective.getY2LogScale();
        MinMaxObj y2MinMaxObj = this.findLimits(1, this.m_scaling, bMustIncludeZero, null);
        if (this.m_nDepthRadius > 0 && this.m_nDepthAngle > 90 && !bVerticalAxis) {
            bAscending ^= true;
        }
        this.m_Y2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, y2MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        if (this.isZoomingArmed() && (y2MinMaxZoom = this.createMinMaxZoom(this.m_Y2Axis)) != null) {
            this.m_Y2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, y2MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
    }

    protected void createZ1Axis(boolean bVerticalAxis, boolean bAscending) {
        boolean bZ1LogScale = false;
        boolean bZ1MustIncludeZero = false;
        boolean bDisplayOnCalc = false;
        boolean bMustIncludeZero = bZ1MustIncludeZero && !bZ1LogScale;
        MinMaxObj z1MinMaxObj = this.findLimits(8, this.m_scaling, bMustIncludeZero, null);
        this.m_Z1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Z1_AXIS, z1MinMaxObj, bVerticalAxis, bAscending, 0, 100, bDisplayOnCalc);
    }

    protected void createY3Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y1MinMaxZoom;
        AxisTemplate template = AxisTemplate.Y3_AXIS;
        IdentObj id = template.getAxis();
        boolean bMustIncludeZero = this.m_Perspective.getScaleMustIncludeZero(id) && !this.m_Perspective.getLogScale(id);
        MinMaxObj y1MinMaxObj = this.findLimits(template.getAxisObjID(), this.m_scaling, bMustIncludeZero, null);
        this.m_Y3Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        if (this.isZoomingArmed() && (y1MinMaxZoom = this.createMinMaxZoom(this.m_Y3Axis)) != null) {
            this.m_Y3Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
    }

    protected void createY4Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y1MinMaxZoom;
        AxisTemplate template = AxisTemplate.Y4_AXIS;
        IdentObj id = template.getAxis();
        boolean bMustIncludeZero = this.m_Perspective.getScaleMustIncludeZero(id) && !this.m_Perspective.getLogScale(id);
        MinMaxObj y1MinMaxObj = this.findLimits(template.getAxisObjID(), this.m_scaling, bMustIncludeZero, null);
        this.m_Y4Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        if (this.isZoomingArmed() && (y1MinMaxZoom = this.createMinMaxZoom(this.m_Y4Axis)) != null) {
            this.m_Y4Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
    }

    protected void createY5Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y1MinMaxZoom;
        AxisTemplate template = AxisTemplate.Y5_AXIS;
        IdentObj id = template.getAxis();
        boolean bMustIncludeZero = this.m_Perspective.getScaleMustIncludeZero(id) && !this.m_Perspective.getLogScale(id);
        MinMaxObj y1MinMaxObj = this.findLimits(template.getAxisObjID(), this.m_scaling, bMustIncludeZero, null);
        this.m_Y5Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        if (this.isZoomingArmed() && (y1MinMaxZoom = this.createMinMaxZoom(this.m_Y4Axis)) != null) {
            this.m_Y5Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
    }

    private void drawAxisBody() {
        if (this.m_O1Axis != null) {
            this.m_O1Axis.calcAxisBody();
        }
        if (this.m_X1Axis != null) {
            this.m_X1Axis.calcAxisBody();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.calcAxisBody();
        }
        if (this.m_Y2Axis != null) {
            this.m_Y2Axis.calcAxisBody();
        }
        if (this.m_Y3Axis != null) {
            this.m_Y3Axis.calcAxisBody();
        }
        if (this.m_Y4Axis != null) {
            this.m_Y4Axis.calcAxisBody();
        }
        if (this.m_Y5Axis != null) {
            this.m_Y5Axis.calcAxisBody();
        }
    }

    protected void drawDataValues() {
        int s;
        int g;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        Graphics gx = this.m_Perspective.getGraphicsContext();
        IdentObj id = this.m_Perspective.getDataText();
        Vector<String> szLabels = new Vector<String>(this.m_nSeries * this.m_nGroups);
        Dimension labelDim = new Dimension(5000, 1600);
        boolean bDataValueFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
        TextStyleObj textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bDataValueFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), false, false, this.m_Perspective.getTextWrap(id));
        while (gEnum.hasMoreElements()) {
            g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                szLabels.addElement(this.m_DataLabel[s][g]);
            }
        }
        int nFontSizeVC = bDataValueFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id)) : this.m_Perspective.getFontSizeVC(id);
        textStyle.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(id), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, szLabels, labelDim, this.m_Perspective.m_VC);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (s == 0 && this.m_Perspective.getGraphType() == 95) continue;
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                Rectangle rLabel;
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g] || this.m_DataLabel[s][g] == null || (rLabel = this.calcDataValuePosition(s, g, labelDim)) == null) continue;
                IdentObj newID = new IdentObj(id.getObjectID(), s, g);
                new DetLabel(this.m_Detectiv, newID, this.m_DataLabel[s][g], rLabel, textStyle, (BlackBoxIF)blackBox, false, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Rectangle calcDataValuePosition(int s, int g, Dimension dimLabel) {
        int adjustedBaseCoord;
        Point ptTwoHalfDOffset;
        Rectangle rDataTextPos = null;
        int nValueCoord = this.m_numYCoords[s][g];
        Axis2DObj yAxisObj = (Axis2DObj)this.whichAxisForSeries(s, null);
        if (yAxisObj == null) return rDataTextPos;
        int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
        boolean bDescending = yAxisObj.isDescending();
        boolean bNegValue = bDescending ? nValueCoord > nZeroCoord : nValueCoord < nZeroCoord;
        int sPrev = this.prevSeriesForAxis(s, g, yAxisObj, bNegValue);
        int nPrevCoord = 0;
        boolean bPrevCoordValid = false;
        if (sPrev != -2) {
            bPrevCoordValid = true;
            nPrevCoord = this.m_numYCoords[sPrev][g];
        }
        boolean nonZeroBaseline = this.m_Perspective.getNonZeroBaseline(yAxisObj.getAxisIdentObj());
        double fBaseLine = this.m_Perspective.getNonZeroBaselineValue(yAxisObj.getAxisIdentObj());
        if (nonZeroBaseline && this.m_bAbsolute && !this.m_gt.isStockType() && !this.m_gt.isParetoType() && yAxisObj.isLogScale() && fBaseLine <= 0.0) {
            nonZeroBaseline = false;
        }
        int baseLineYCoord = 0;
        if (nonZeroBaseline) {
            baseLineYCoord = fBaseLine <= yAxisObj.getMaxValue() ? (int)yAxisObj.getValueCoord(fBaseLine) : (int)yAxisObj.getValueCoord(yAxisObj.getBaseMax());
        }
        int nDataTextPosition = this.m_Perspective.getDataTextPosition();
        int nGraphType = this.m_Perspective.getGraphType();
        Point ptCenterTop = this.getCoords(s, g);
        if (this.m_nDepthRadius > 0 && this.m_gt.wantDepthEffect()) {
            double fFrontOffset = this.calcFrontOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            ptTwoHalfDOffset = this.m_Frame.getDepthOffset(fFrontOffset);
            if (this.m_gt.isBLAType() && this.m_seriesTypes[s] == 2) {
                Rectangle rFrame = this.m_Frame.getBackWallBounds();
                if (rFrame == null) {
                    String expStr = "Can't draw data labels for 2.5D lines when m_Frame has no bounding rect";
                    throw new AssertionException(expStr);
                }
                double DEPTH_FACTOR = 12.0;
                int m_nLineThick = this.m_Perspective.getDataLineThickness();
                double fThickMax = this.m_bHorz ? (double)rFrame.width / DEPTH_FACTOR : (double)rFrame.height / DEPTH_FACTOR;
                int nOffset = (int)(fThickMax * (double)m_nLineThick / 100.0);
                if (this.m_bHorz) {
                    ptCenterTop.x = bNegValue ? (ptCenterTop.x -= nOffset / 2) : (ptCenterTop.x += nOffset / 2);
                } else {
                    ptCenterTop.y = bNegValue ? (ptCenterTop.y -= nOffset / 2) : (ptCenterTop.y += nOffset / 2);
                }
            }
        } else {
            ptTwoHalfDOffset = this.m_Frame.getDepthOffset(1.0);
        }
        double fDataValue = this.getDataValue((int)s, (int)g).m_fValue;
        int nBaseCoord = this.getBaseCoord(s);
        double fStackedCumVal = this.getStackedCumulativeValue(s, g);
        boolean stacked = false;
        double maxVal = yAxisObj.getMaxValue();
        double minVal = yAxisObj.getMinValue();
        int centerTop = this.m_bHorz ? ptCenterTop.x : ptCenterTop.y;
        int maxCoord = bNegValue ? (int)yAxisObj.getValueCoord(minVal) : (int)yAxisObj.getValueCoord(maxVal);
        if (this.m_gt.isLAType() && (bNegValue ? ptCenterTop.y < maxCoord : ptCenterTop.y > maxCoord)) {
            return null;
        }
        if (nGraphType == 25 || nGraphType == 27 || nGraphType == 29 || nGraphType == 37 || nGraphType == 18 || nGraphType == 20 || nGraphType == 22 || nGraphType == 32) {
            stacked = true;
        }
        if (bNegValue) {
            if (centerTop < maxCoord) {
                if (this.m_gt.isBLAType()) {
                    if (this.m_seriesTypes[s] == 2) return null;
                    if (this.m_seriesTypes[s] == 3) {
                        return null;
                    }
                    if (stacked) {
                        if (sPrev != -2 && nPrevCoord <= maxCoord) {
                            return null;
                        }
                        if (maxVal < 0.0) {
                            fDataValue = maxVal < fStackedCumVal - fDataValue ? minVal - maxVal : (fDataValue -= fStackedCumVal - minVal);
                            fStackedCumVal = minVal - maxVal;
                        } else {
                            fDataValue -= fStackedCumVal - minVal;
                            fStackedCumVal = minVal;
                        }
                    }
                }
                if (minVal >= 0.0) {
                    return null;
                }
                if (this.m_bHorz) {
                    ptCenterTop.x = maxCoord;
                } else {
                    ptCenterTop.y = maxCoord;
                }
            } else if (stacked && maxVal < 0.0) {
                if (fDataValue < fStackedCumVal - maxVal) {
                    fDataValue = fStackedCumVal - maxVal;
                }
                fStackedCumVal -= maxVal;
            }
        } else if (centerTop > maxCoord) {
            if (this.m_gt.isBLAType()) {
                if (this.m_seriesTypes[s] == 2) return null;
                if (this.m_seriesTypes[s] == 3) {
                    return null;
                }
                if (stacked) {
                    if (sPrev != -2 && nPrevCoord >= maxCoord) {
                        return null;
                    }
                    if (minVal > 0.0) {
                        fDataValue = minVal > fStackedCumVal - fDataValue ? maxVal - minVal : (fDataValue -= fStackedCumVal - maxVal);
                        fStackedCumVal = maxVal - minVal;
                    } else {
                        fDataValue -= fStackedCumVal - maxVal;
                        fStackedCumVal = maxVal;
                    }
                }
            }
            if (maxVal <= 0.0) {
                return null;
            }
            if (this.m_bHorz) {
                ptCenterTop.x = maxCoord;
            } else {
                ptCenterTop.y = maxCoord;
            }
        } else if (stacked && minVal > 0.0) {
            if (fDataValue > fStackedCumVal - minVal) {
                fDataValue = fStackedCumVal - minVal;
            }
            fStackedCumVal -= minVal;
        }
        if (bNegValue) {
            adjustedBaseCoord = (int)yAxisObj.getValueCoord(maxVal);
            if (nBaseCoord > adjustedBaseCoord) {
                nBaseCoord = adjustedBaseCoord;
            }
        } else {
            adjustedBaseCoord = (int)yAxisObj.getValueCoord(minVal);
            if (nBaseCoord < adjustedBaseCoord) {
                nBaseCoord = adjustedBaseCoord;
            }
        }
        if (this.m_gt.isLAType() && nBaseCoord == adjustedBaseCoord && (bNegValue ? ptCenterTop.y > nBaseCoord : ptCenterTop.y < nBaseCoord)) {
            return null;
        }
        if (bNegValue) {
            if (centerTop >= nBaseCoord && this.m_gt.isBLAType()) {
                if (this.m_seriesTypes[s] != 2) {
                    if (this.m_seriesTypes[s] != 3) return null;
                }
                if (centerTop > nBaseCoord) {
                    return null;
                }
            }
        } else if (centerTop <= nBaseCoord && this.m_gt.isBLAType()) {
            if (this.m_seriesTypes[s] != 2) {
                if (this.m_seriesTypes[s] != 3) return null;
            }
            if (centerTop < nBaseCoord) {
                return null;
            }
        }
        double fPercentCumVal = this.getPercentCumulativeValue(s, g);
        double fAngle = this.m_Perspective.getDataTextAngle(s, g);
        double fDist = this.m_Perspective.getDataTextRadius(s, g);
        boolean bIsCombo = this.isComboWithNonBar();
        DataTextPosition dataTextPos = new DataTextPosition(nDataTextPosition, nGraphType, ptTwoHalfDOffset, nBaseCoord, ptCenterTop, dimLabel, fDataValue, fStackedCumVal, fPercentCumVal, this.m_bHorz, this.isAxisAscending(s), fAngle, fDist, bIsCombo, nPrevCoord, bPrevCoordValid, nonZeroBaseline, baseLineYCoord, fBaseLine, this.m_Perspective);
        return dataTextPos.calcPosition();
    }

    protected void drawEquationText(CurveFitIF curve, double[] a, int s, double dCorr) {
        Graphics gx = this.m_Perspective.getGraphicsContext();
        IdentObj id = this.m_Perspective.getCurveFitEquationText();
        IdentObj idSeries = this.m_Perspective.getCurveFitEquationText(s);
        Dimension labelDim = new Dimension(5000, 1600);
        int nCoeffs = curve.numCoeffs();
        String[] strCoeffs = new String[nCoeffs + 1];
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        int nDataTextFormat = this.m_Perspective.getDataTextFormat();
        String sDataTextFormatPattern = this.m_Perspective.getDataTextFormatPattern();
        boolean bDrawCorrelation = false;
        int i = 1;
        while (i <= nCoeffs) {
            if (bNumberFormatCallBackActive) {
                this.m_Perspective.getNumberFormatCallBack().setState(3, s, -3, -1, -3);
                strCoeffs[i] = this.m_Perspective.getNumberFormatCallBack().toString(a[i]);
            } else {
                strCoeffs[i] = TDGNumberFormat.toString(this.m_Perspective, nDataTextFormat, a[i], sDataTextFormatPattern);
            }
            ++i;
        }
        TextStyleObj tsEquation = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), this.m_Perspective.getFontSizeAbsolute(), this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), false, false, this.m_Perspective.getTextWrap(id));
        if (this.m_Perspective.getFontSizeAbsolute()) {
            int nFontSizeVC = this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id));
        } else {
            int nFontSizeVC = this.m_Perspective.getFontSizeVC(id);
        }
        BlackBoxObj bbEquation = new BlackBoxObj(this.m_Perspective, idSeries);
        Rectangle rEquation = this.m_Perspective.getRect(idSeries);
        IdentObj newID = new IdentObj(idSeries);
        String strEquation = curve.createEquation(strCoeffs, this.m_Perspective.getCurveFitHighOrderFirst());
        if (bDrawCorrelation) {
            String strCorr;
            if (bNumberFormatCallBackActive) {
                this.m_Perspective.getNumberFormatCallBack().setState(3, s, -3, -1, -3);
                strCorr = this.m_Perspective.getNumberFormatCallBack().toString(dCorr);
            } else {
                strCorr = TDGNumberFormat.toString(this.m_Perspective, nDataTextFormat, dCorr, sDataTextFormatPattern);
            }
            strEquation = strEquation + ", " + strCorr;
        }
        new DetLabel(this.m_Detectiv, newID, strEquation, rEquation, tsEquation, (BlackBoxIF)bbEquation, true, null);
    }

    protected void drawFitLines() {
        if (this.m_bHorz) {
            return;
        }
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            CurveFitIF curveObj = this.m_Perspective.getCurveObj(s);
            if (curveObj == null) continue;
            this.drawOneFitLine(s, curveObj);
        }
    }

    protected void drawOneFitLine(int s, CurveFitIF curveObj) {
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int nCoeffs = curveObj.numCoeffs();
        int nPoints = 0;
        int gFirst = gEnum.getFirstGroup();
        double[] chisq = new double[1];
        double[] xPoints = new double[this.m_nTotalGroups + 1];
        double[] yPoints = new double[this.m_nTotalGroups + 1];
        int g = 0;
        while (g < this.m_nTotalGroups) {
            try {
                Point2D ptData = this.getDataValuesXY(s, g);
                xPoints[++nPoints] = ptData.getX();
                yPoints[nPoints] = ptData.getY();
            }
            catch (Exception e) {
                // empty catch block
            }
            ++g;
        }
        if (nPoints < nCoeffs) {
            return;
        }
        double[] a = new double[nCoeffs + 1];
        try {
            SVD.fit(curveObj, xPoints, yPoints, null, nPoints, a, chisq);
        }
        catch (Exception e) {
            return;
        }
        IdentObj id = this.m_Perspective.getCurveFitLineRiser(s);
        int nPixelWidth = this.m_Perspective.getLineWidth(id);
        if (nPixelWidth < 1) {
            nPixelWidth = 1;
        }
        int nWidth = this.m_Perspective.m_VC.destToVirtHeight(nPixelWidth);
        int nPlottedPoints = this.m_Perspective.getCurveFitNumSegments();
        if (nPlottedPoints > this.m_nTotalGroups) {
            switch (this.m_Perspective.getCurveFitType(s)) {
                case 4: 
                case 5: 
                case 9: {
                    nPlottedPoints = this.m_nTotalGroups + 1;
                    break;
                }
                default: {
                    nPlottedPoints = this.m_nTotalGroups;
                    break;
                }
            }
        }
        double xMin = Double.MAX_VALUE;
        double xMax = -1.7976931348623157E308;
        int nViewablePoints = 0;
        while (gEnum.hasMoreElements()) {
            g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            try {
                Point2D ptData = this.getDataValuesXY(s, g);
                if (ptData.getX() < xMin) {
                    xMin = ptData.getX();
                }
                if (ptData.getX() > xMax) {
                    xMax = ptData.getX();
                }
                ++nViewablePoints;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (nViewablePoints < 2) {
            return;
        }
        double xIncr = (xMax - xMin) / (double)(nPlottedPoints - 1);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        Polygon plottedPoly = new Polygon();
        int i = 0;
        while (i < nPlottedPoints) {
            try {
                double x = xMin + (double)i * xIncr;
                double y = curveObj.compute(x, a);
                Point pt0 = this.getVCPositionsXY(s, x - (double)gFirst, y);
                if (pt0 != null) {
                    plottedPoly.addPoint(pt0.x, pt0.y);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        if (plottedPoly.npoints >= 2) {
            Polyline polyline = new Polyline(plottedPoly.xpoints, plottedPoly.ypoints, plottedPoly.npoints, nWidth);
            new DetPolygon(this.m_Detectiv, id, polyline.m_polygon, (BlackBoxIF)blackBox, null);
            if (this.m_Perspective.getCurveFitEquationDisplay()) {
                this.drawEquationText(curveObj, a, s, chisq[0]);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void drawCenteredSteppedLine(int s, boolean is3D) {
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int g = 0;
        Point pt1 = null;
        Point pt2 = null;
        int halfWidth = 0;
        BlackBoxIF blackBox = null;
        boolean bAutoMax = false;
        boolean bAutoMin = false;
        IdentObj idSeries = new IdentObj(-3, s);
        int nWidth = this.m_Perspective.getLineWidth(idSeries);
        Vector<Point> points = new Vector<Point>(16, 4);
        int nStyle = this.m_Perspective.getLineStyle(idSeries);
        while (gEnum.hasMoreElements()) {
            int gNext;
            block53: {
                int minCoord;
                block52: {
                    g = gEnum.nextGroup();
                    PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                    if (!gEnum.hasMoreElements()) continue;
                    gNext = gEnum.peekAtNextGroup();
                    if (this.m_Perspective.isTimeAxis() && this.m_Perspective.getDateFrequency() == 3 && !this.m_dataOK[s][gNext]) {
                        while (gEnum.hasMoreElements() && !this.m_dataOK[s][gNext]) {
                            gNext = gEnum.nextGroup();
                            gNext = gEnum.peekAtNextGroup();
                        }
                    }
                    PfjAssert.pfjAssert(gNext >= 0 && gNext < this.m_nTotalGroups);
                    if (!this.m_dataOK[s][g]) continue;
                    blackBox = this.assignSeriesColor(s, g);
                    blackBox.runRules(s, -3);
                    blackBox.setTransparentBorderColor(false);
                    if (blackBox.getFillColor() != null) {
                        blackBox.setBorderColor(blackBox.getFillColor());
                    }
                    pt1 = this.getCoords(s, g);
                    pt2 = this.getCoords(s, gNext);
                    halfWidth = this.m_bHorz ? (pt1.y - pt2.y) / 2 : (pt2.x - pt1.x) / 2;
                    RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                    IdentObj AxisId = axisObj.getAxisIdentObj();
                    bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
                    bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
                    double fValue = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue;
                    double fValue1 = this.getDataValue((int)s, (int)gNext, (DataItem)DataItem.DI_GENERAL).m_fValue;
                    double max = axisObj.getMaxValue();
                    double min = axisObj.getMinValue();
                    int maxCoord = (int)axisObj.getValueCoord(max);
                    minCoord = (int)axisObj.getValueCoord(min);
                    if (axisObj.isDescending()) {
                        int temp = minCoord;
                        minCoord = maxCoord;
                        maxCoord = temp;
                        boolean temp1 = bAutoMin;
                        bAutoMin = bAutoMax;
                        bAutoMax = temp1;
                    }
                    if (!bAutoMax) {
                        if (this.m_numYCoords[s][g] > maxCoord && this.m_numYCoords[s][gNext] > maxCoord) continue;
                        if (this.m_numYCoords[s][g] > maxCoord) {
                            if (this.m_bHorz) {
                                pt1.x = maxCoord;
                                points.addElement(new Point(pt1.x, pt1.y - halfWidth));
                                points.addElement(new Point(pt2.x, pt2.y + halfWidth));
                                break block52;
                            } else {
                                pt1.y = maxCoord;
                                points.addElement(new Point(pt1.x + halfWidth, pt1.y));
                                points.addElement(new Point(pt2.x - halfWidth, pt2.y));
                                continue;
                            }
                        }
                        if (this.m_numYCoords[s][gNext] > maxCoord) {
                            if (this.m_bHorz) {
                                pt2.x = maxCoord;
                                if (points.size() <= 0) {
                                    points.addElement(new Point(pt1.x, pt1.y + halfWidth));
                                }
                                points.addElement(new Point(pt1.x, pt1.y - halfWidth));
                                points.addElement(new Point(pt2.x, pt2.y + halfWidth));
                                if (is3D) {
                                    this.draw3DLine(s, points);
                                } else {
                                    new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), points, blackBox, null, nWidth, nStyle, false);
                                }
                                points = new Vector(16, 4);
                                continue;
                            }
                            pt2.y = maxCoord;
                            if (points.size() <= 0) {
                                points.addElement(new Point(pt1.x - halfWidth, pt1.y));
                            }
                            points.addElement(new Point(pt1.x + halfWidth, pt1.y));
                            points.addElement(new Point(pt2.x - halfWidth, pt2.y));
                            if (is3D) {
                                this.draw3DLine(s, points);
                            } else {
                                new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), points, blackBox, null, nWidth, nStyle, false);
                            }
                            points = new Vector(16, 4);
                            continue;
                        }
                    }
                }
                if (!bAutoMin) {
                    if (this.m_numYCoords[s][g] < minCoord && this.m_numYCoords[s][gNext] < minCoord) continue;
                    if (this.m_numYCoords[s][g] < minCoord) {
                        if (this.m_bHorz) {
                            pt1.x = minCoord;
                            points.addElement(new Point(pt1.x, pt1.y - halfWidth));
                            points.addElement(new Point(pt2.x, pt2.y + halfWidth));
                            break block53;
                        } else {
                            pt1.y = minCoord;
                            points.addElement(new Point(pt1.x + halfWidth, pt1.y));
                            points.addElement(new Point(pt2.x - halfWidth, pt2.y));
                            continue;
                        }
                    }
                    if (this.m_numYCoords[s][gNext] < minCoord) {
                        if (this.m_bHorz) {
                            pt2.x = minCoord;
                            if (points.size() <= 0) {
                                points.addElement(new Point(pt1.x, pt1.y + halfWidth));
                            }
                            points.addElement(new Point(pt1.x, pt1.y - halfWidth));
                            points.addElement(new Point(pt2.x, pt2.y + halfWidth));
                            if (is3D) {
                                this.draw3DLine(s, points);
                            } else {
                                new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), points, blackBox, null, nWidth, nStyle, false);
                            }
                            points = new Vector(16, 4);
                            continue;
                        }
                        pt2.y = minCoord;
                        if (points.size() <= 0) {
                            points.addElement(new Point(pt1.x - halfWidth, pt1.y));
                        }
                        points.addElement(new Point(pt1.x + halfWidth, pt1.y));
                        points.addElement(new Point(pt2.x - halfWidth, pt2.y));
                        if (is3D) {
                            this.draw3DLine(s, points);
                        } else {
                            new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), points, blackBox, null, nWidth, nStyle, false);
                        }
                        points = new Vector(16, 4);
                        continue;
                    }
                }
            }
            boolean bDrawNormal = true;
            if (this.m_nFillMissingData != 0) {
                boolean bFilledMissingData = this.m_Access.m_DataStorage.isMissingDataFilledIn(s, g);
                int nNumSegments = this.m_Perspective.getNumMissingDataSegments();
                if (bFilledMissingData && nNumSegments != 0) {
                    Line theLine = new Line(pt1, pt2);
                    Point ptTwo = null;
                    int nDenominator = nNumSegments * 2 + 1;
                    int nIdx = 1;
                    while (nIdx < nDenominator) {
                        Point ptOne = theLine.fractionalPoint(nIdx, nDenominator);
                        ptTwo = theLine.fractionalPoint(nIdx + 1, nDenominator);
                        if (this.m_bHorz) {
                            if (points.size() <= 0) {
                                points.addElement(new Point(ptOne.x, ptOne.y + halfWidth));
                            }
                            points.addElement(new Point(ptOne.x, ptOne.y - halfWidth));
                            points.addElement(new Point(ptTwo.x, ptTwo.y + halfWidth));
                        } else {
                            if (points.size() <= 0) {
                                points.addElement(new Point(ptOne.x - halfWidth, ptOne.y));
                            }
                            points.addElement(new Point(ptOne.x + halfWidth, ptOne.y));
                            points.addElement(new Point(ptTwo.x - halfWidth, ptTwo.y));
                        }
                        ++nIdx;
                        ++nIdx;
                    }
                    if (this.m_bHorz) {
                        points.addElement(new Point(ptTwo.x, ptTwo.y - halfWidth));
                    } else {
                        points.addElement(new Point(ptTwo.x + halfWidth, ptTwo.y));
                    }
                    bDrawNormal = false;
                }
            }
            if (!bDrawNormal || blackBox.getTransparentFillColor()) continue;
            if (this.m_bHorz) {
                if (points.size() <= 0) {
                    points.addElement(new Point(pt1.x, pt1.y + halfWidth));
                }
                points.addElement(new Point(pt1.x, pt1.y - halfWidth));
                if (this.m_dataOK[s][gNext]) {
                    points.addElement(new Point(pt2.x, pt2.y + halfWidth));
                }
            } else {
                if (points.size() <= 0) {
                    points.addElement(new Point(pt1.x - halfWidth, pt1.y));
                }
                points.addElement(new Point(pt1.x + halfWidth, pt1.y));
                if (this.m_dataOK[s][gNext]) {
                    points.addElement(new Point(pt2.x - halfWidth, pt2.y));
                }
            }
            if (this.m_dataOK[s][gNext]) continue;
            if (is3D) {
                this.draw3DLine(s, points);
            } else {
                new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), points, blackBox, null, nWidth, nStyle, false);
            }
            points = new Vector(16, 4);
        }
        if (points.size() > 0) {
            if (this.m_bHorz) {
                points.addElement(new Point(pt2.x, pt2.y - halfWidth));
            } else {
                points.addElement(new Point(pt2.x + halfWidth, pt2.y));
            }
            if (is3D) {
                this.draw3DLine(s, points);
            } else {
                new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), points, blackBox, null, nWidth, nStyle, false);
            }
        }
        if (!is3D) return;
        if (!this.m_bMarkerDisplay && this.m_Perspective.getTransparentMarkers()) {
            this.drawTransparentMarkersWithDepth(s, 2);
            return;
        }
        this.drawMarkersWithDepth(s, this.m_Perspective.getConnectLineMarkers());
    }

    protected void drawSteppedLine(int s, boolean is3D) {
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int g = 0;
        Point pt1 = null;
        Point pt2 = null;
        BlackBoxIF blackBox = null;
        boolean bAutoMax = false;
        boolean bAutoMin = false;
        IdentObj idSeries = new IdentObj(-3, s);
        int nWidth = this.m_Perspective.getLineWidth(idSeries);
        Vector<Point> points = new Vector<Point>(16, 4);
        int nStyle = this.m_Perspective.getLineStyle(idSeries);
        while (gEnum.hasMoreElements()) {
            g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            if (!gEnum.hasMoreElements()) continue;
            int gNext = gEnum.peekAtNextGroup();
            if (this.m_Perspective.isTimeAxis() && this.m_Perspective.getDateFrequency() == 3 && !this.m_dataOK[s][gNext]) {
                while (gEnum.hasMoreElements() && !this.m_dataOK[s][gNext]) {
                    gNext = gEnum.nextGroup();
                    gNext = gEnum.peekAtNextGroup();
                }
            }
            PfjAssert.pfjAssert(gNext >= 0 && gNext < this.m_nTotalGroups);
            if (!this.m_dataOK[s][g]) continue;
            blackBox = this.assignSeriesColor(s, g);
            blackBox.runRules(s, -3);
            blackBox.setTransparentBorderColor(false);
            if (blackBox.getFillColor() != null) {
                blackBox.setBorderColor(blackBox.getFillColor());
            }
            pt1 = this.getCoords(s, g);
            pt2 = this.getCoords(s, gNext);
            RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
            IdentObj AxisId = axisObj.getAxisIdentObj();
            bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
            bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
            double fValue = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue;
            double fValue1 = this.getDataValue((int)s, (int)gNext, (DataItem)DataItem.DI_GENERAL).m_fValue;
            double max = axisObj.getMaxValue();
            double min = axisObj.getMinValue();
            int maxCoord = (int)axisObj.getValueCoord(max);
            int minCoord = (int)axisObj.getValueCoord(min);
            if (axisObj.isDescending()) {
                int temp = minCoord;
                minCoord = maxCoord;
                maxCoord = temp;
                boolean temp1 = bAutoMin;
                bAutoMin = bAutoMax;
                bAutoMax = temp1;
            }
            if (!bAutoMax) {
                if (this.m_numYCoords[s][g] > maxCoord && this.m_numYCoords[s][gNext] > maxCoord) continue;
                if (this.m_numYCoords[s][g] > maxCoord) {
                    if (this.m_bHorz) {
                        pt1.x = maxCoord;
                        points.addElement(new Point(pt1.x, pt2.y));
                        continue;
                    }
                    pt1.y = maxCoord;
                    points.addElement(new Point(pt2.x, pt1.y));
                    continue;
                }
                if (this.m_numYCoords[s][gNext] > maxCoord) {
                    if (this.m_bHorz) {
                        points.addElement(pt1);
                        pt2.x = maxCoord;
                        points.addElement(new Point(pt1.x, pt2.y));
                        points.addElement(pt2);
                        if (is3D) {
                            this.draw3DLine(s, points);
                        } else {
                            new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), points, blackBox, null, nWidth, nStyle, false);
                        }
                        points = new Vector(16, 4);
                        continue;
                    }
                    points.addElement(pt1);
                    pt2.y = maxCoord;
                    points.addElement(new Point(pt2.x, pt1.y));
                    points.addElement(pt2);
                    if (is3D) {
                        this.draw3DLine(s, points);
                    } else {
                        new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), points, blackBox, null, nWidth, nStyle, false);
                    }
                    points = new Vector(16, 4);
                    continue;
                }
            }
            if (!bAutoMin) {
                if (this.m_numYCoords[s][g] < minCoord && this.m_numYCoords[s][gNext] < minCoord) continue;
                if (this.m_numYCoords[s][g] < minCoord) {
                    if (this.m_bHorz) {
                        pt1.x = minCoord;
                        points.addElement(new Point(pt1.x, pt2.y));
                        continue;
                    }
                    pt1.y = minCoord;
                    points.addElement(new Point(pt2.x, pt1.y));
                    continue;
                }
                if (this.m_numYCoords[s][gNext] < minCoord) {
                    if (this.m_bHorz) {
                        points.addElement(pt1);
                        pt2.x = minCoord;
                        points.addElement(new Point(pt1.x, pt2.y));
                        points.addElement(pt2);
                        if (is3D) {
                            this.draw3DLine(s, points);
                        } else {
                            new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), points, blackBox, null, nWidth, nStyle, false);
                        }
                        points = new Vector(16, 4);
                        continue;
                    }
                    points.addElement(pt1);
                    pt2.y = minCoord;
                    points.addElement(new Point(pt2.x, pt1.y));
                    points.addElement(pt2);
                    if (is3D) {
                        this.draw3DLine(s, points);
                    } else {
                        new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), points, blackBox, null, nWidth, nStyle, false);
                    }
                    points = new Vector(16, 4);
                    continue;
                }
            }
            boolean bDrawNormal = true;
            if (this.m_nFillMissingData != 0) {
                boolean bFilledMissingData = this.m_Access.m_DataStorage.isMissingDataFilledIn(s, g);
                int nNumSegments = this.m_Perspective.getNumMissingDataSegments();
                if (bFilledMissingData && nNumSegments != 0) {
                    Line theLine = new Line(pt1, pt2);
                    Point ptTwo = null;
                    int nDenominator = nNumSegments * 2 + 1;
                    int nIdx = 1;
                    while (nIdx < nDenominator) {
                        Point ptOne = theLine.fractionalPoint(nIdx, nDenominator);
                        ptTwo = theLine.fractionalPoint(nIdx + 1, nDenominator);
                        points.addElement(ptOne);
                        if (this.m_bHorz) {
                            points.addElement(new Point(ptOne.x, ptTwo.y));
                        } else {
                            points.addElement(new Point(ptTwo.x, ptOne.y));
                        }
                        ++nIdx;
                        ++nIdx;
                    }
                    points.addElement(ptTwo);
                    bDrawNormal = false;
                }
            }
            if (!bDrawNormal || blackBox.getTransparentFillColor()) continue;
            points.addElement(pt1);
            if (this.m_bHorz) {
                points.addElement(new Point(pt1.x, pt2.y));
            } else {
                points.addElement(new Point(pt2.x, pt1.y));
            }
            if (this.m_dataOK[s][gNext]) continue;
            if (is3D) {
                this.draw3DLine(s, points);
            } else {
                new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), points, blackBox, null, nWidth, nStyle, false);
            }
            points = new Vector(16, 4);
        }
        if (points.size() > 0) {
            points.addElement(pt2);
            if (is3D) {
                this.draw3DLine(s, points);
            } else {
                new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), points, blackBox, null, nWidth, nStyle, false);
            }
        }
        if (is3D) {
            if (!this.m_bMarkerDisplay && this.m_Perspective.getTransparentMarkers()) {
                this.drawTransparentMarkersWithDepth(s, 2);
            } else {
                this.drawMarkersWithDepth(s, this.m_Perspective.getConnectLineMarkers());
            }
        }
    }

    private void solveTridiag(float[] sub, float[] diag, float[] sup, float[] b, int n) {
        int i = 2;
        while (i <= n) {
            sub[i] = sub[i] / diag[i - 1];
            diag[i] = diag[i] - sub[i] * sup[i - 1];
            b[i] = b[i] - sub[i] * b[i - 1];
            ++i;
        }
        b[n] = b[n] / diag[n];
        i = n - 1;
        while (i >= 1) {
            b[i] = (b[i] - sup[i] * b[i + 1]) / diag[i];
            --i;
        }
    }

    protected Vector calcCurveLinePoints(Vector points) {
        int np = points.size();
        if (np == 0) {
            return null;
        }
        float[] d = new float[np];
        float[] x = new float[np];
        float oldy = 0.0f;
        float oldt = 0.0f;
        int precision = 10;
        Vector<Point> newPoints = new Vector<Point>(16, 4);
        int i = 0;
        while (i < np) {
            Point p = (Point)points.elementAt(i);
            x[i] = p.x;
            d[i] = p.y;
            ++i;
        }
        if (np > 1) {
            float[] a = new float[np];
            float[] h = new float[np];
            int i2 = 1;
            while (i2 <= np - 1) {
                h[i2] = x[i2] - x[i2 - 1];
                ++i2;
            }
            if (np > 2) {
                float[] sub = new float[np - 1];
                float[] diag = new float[np - 1];
                float[] sup = new float[np - 1];
                int i3 = 1;
                while (i3 <= np - 2) {
                    diag[i3] = (h[i3] + h[i3 + 1]) / 3.0f;
                    sup[i3] = h[i3 + 1] / 6.0f;
                    sub[i3] = h[i3] / 6.0f;
                    a[i3] = (d[i3 + 1] - d[i3]) / h[i3 + 1] - (d[i3] - d[i3 - 1]) / h[i3];
                    ++i3;
                }
                this.solveTridiag(sub, diag, sup, a, np - 2);
            }
            oldt = x[0];
            oldy = d[0];
            newPoints.addElement(new Point((int)oldt, (int)oldy));
            int i4 = 1;
            while (i4 <= np - 1) {
                int j = 1;
                while (j <= precision) {
                    float t1 = h[i4] * (float)j / (float)precision;
                    float t2 = h[i4] - t1;
                    float y = ((-a[i4 - 1] / 6.0f * (t2 + h[i4]) * t1 + d[i4 - 1]) * t2 + (-a[i4] / 6.0f * (t1 + h[i4]) * t2 + d[i4]) * t1) / h[i4];
                    float t = x[i4 - 1] + t1;
                    newPoints.addElement(new Point((int)oldt, (int)oldy));
                    oldt = t;
                    oldy = y;
                    if (j == precision) {
                        newPoints.addElement(new Point((int)oldt, (int)oldy));
                    }
                    ++j;
                }
                ++i4;
            }
        }
        return newPoints;
    }

    public void draw3DLine(int s, Vector points) {
        boolean bDrawUnderside = false;
        int dx = 0;
        int dy = 0;
        Point pt1 = null;
        Point pt2 = null;
        int g = 0;
        Object blackBox = null;
        Color seriesColor = this.m_Perspective.getFillColor(this.m_Perspective.getSeries(s));
        Color c = this.m_Perspective.getBrighter(seriesColor);
        IdentObj identObjTop = new IdentObj(318, s, g, -3, 1);
        if (this.m_autoGradient) {
            this.m_Perspective.setFillColor(identObjTop, c);
            this.m_Perspective.setGradientEffect(identObjTop, 4);
        } else {
            this.m_Perspective.setFillColor(identObjTop, c);
            this.m_Perspective.setFillType(identObjTop, 1);
        }
        BlackBoxObj blackBoxTop = new BlackBoxObj(this.m_Perspective, identObjTop);
        blackBoxTop.runRules(s, -3);
        blackBoxTop.setBorderColor(seriesColor);
        this.m_Perspective.setColorFactor(0.9);
        c = this.m_Perspective.getDarker(seriesColor);
        IdentObj identObjBottom = new IdentObj(318, s, g, -3, 2);
        if (this.m_autoGradient) {
            this.m_Perspective.setFillColor(identObjBottom, c);
            this.m_Perspective.setColorFactor(0.85);
            this.m_Perspective.setGradientEffect(identObjBottom, 2);
        } else {
            this.m_Perspective.setFillColor(identObjBottom, c);
            this.m_Perspective.setFillType(identObjBottom, 1);
        }
        BlackBoxObj blackBoxBottom = new BlackBoxObj(this.m_Perspective, identObjBottom);
        blackBoxBottom.runRules(s, -3);
        blackBoxBottom.setBorderColor(seriesColor);
        double fFrontOffset = this.calcFrontOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
        double fBackOffset = this.calcBackOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
        if (fBackOffset > 0.0) {
            fBackOffset -= 1.0 / (double)this.m_nDepthPlanes / 2.0;
        } else {
            fFrontOffset = 1.0 / (double)this.m_nDepthPlanes / 2.0 + fFrontOffset;
        }
        Point ptFrontOffset = this.m_Frame.getDepthOffset(fFrontOffset);
        Point ptBackOffset = this.m_Frame.getDepthOffset(fBackOffset);
        dx = ptFrontOffset.x - ptBackOffset.x;
        dy = ptFrontOffset.y - ptBackOffset.y;
        int i = 0;
        while (i < points.size()) {
            Point pt = (Point)points.elementAt(i);
            pt.x -= ptFrontOffset.x;
            pt.y -= ptFrontOffset.y;
            ++i;
        }
        Vector polyPoints = new Vector(16, 4);
        boolean bCurrentSide = bDrawUnderside;
        polyPoints.addElement(points.elementAt(0));
        int i2 = 0;
        while (i2 <= points.size() - 1) {
            if (i2 < points.size() - 1) {
                pt1 = (Point)points.elementAt(i2);
                pt2 = (Point)points.elementAt(i2 + 1);
                double fAngleRad = Math.atan2(pt2.y - pt1.y, pt2.x - pt1.x);
                double fAngleDeg = fAngleRad * 57.29577951308232;
                if (this.m_nDepthAngle <= 90) {
                    bDrawUnderside = this.m_bHorz ? fAngleDeg < (double)(this.m_nDepthAngle - 180) : fAngleDeg > (double)this.m_nDepthAngle;
                } else {
                    boolean bl = bDrawUnderside = fAngleDeg + 180.0 < (double)this.m_nDepthAngle;
                }
            }
            if (i2 == 0) {
                bCurrentSide = bDrawUnderside;
            }
            if (bCurrentSide != bDrawUnderside && polyPoints.size() > 1 || i2 == points.size() - 1) {
                Polygon polyTop = new Polygon();
                int j = 0;
                while (j < polyPoints.size()) {
                    Point p1 = (Point)polyPoints.elementAt(j);
                    polyTop.addPoint(p1.x, p1.y);
                    ++j;
                }
                int j2 = polyPoints.size() - 1;
                while (j2 >= 0) {
                    Point p1 = (Point)polyPoints.elementAt(j2);
                    polyTop.addPoint(p1.x + dx, p1.y + dy);
                    --j2;
                }
                Point p1 = (Point)polyPoints.elementAt(0);
                polyTop.addPoint(p1.x, p1.y);
                if (bCurrentSide) {
                    new DetPolygon(this.m_Detectiv, identObjTop, polyTop, (BlackBoxIF)blackBoxTop, 1.0);
                } else {
                    new DetPolygon(this.m_Detectiv, identObjBottom, polyTop, (BlackBoxIF)blackBoxBottom, 1.0);
                }
                bCurrentSide = bDrawUnderside;
                polyPoints = new Vector(16, 4);
                if (i2 < points.size() - 1) {
                    polyPoints.addElement(points.elementAt(i2));
                    polyPoints.addElement(points.elementAt(i2 + 1));
                }
            } else {
                polyPoints.addElement(points.elementAt(i2 + 1));
            }
            ++i2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void drawLines(boolean bCircular) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int s = 0;
        int gNext = -1;
        int g = 0;
        Point pt1 = null;
        Point pt2 = null;
        BlackBoxIF blackBox = null;
        int nWidth = 0;
        int nStyle = Perspective.SOLID;
        boolean bCloseCircularLines = false;
        boolean bAutoMax = false;
        boolean bAutoMin = false;
        boolean is3D = false;
        int validStartGroup = -1;
        int validEndGroup = -1;
        if (this.m_nDepthRadius > 0 && this.m_gt.wantDepthEffect()) {
            is3D = true;
        }
        block5: while (sEnum.hasMoreElements()) {
            s = sEnum.nextSeries();
            if (s >= this.m_nTotalSeries) {
                return;
            }
            validStartGroup = -1;
            validEndGroup = -1;
            if (this.m_seriesTypes[s] != 2 || this.m_gt.isWaterfall() && this.m_seriesTypes[s] != 2 && this.m_seriesTypes[s] != 3) continue;
            IdentObj idSeries = new IdentObj(-3, s);
            gEnum.reset();
            if (gEnum.hasMoreElements()) {
                bCloseCircularLines = true;
            }
            boolean isSmooth = false;
            switch (this.m_Perspective.getLineType(idSeries)) {
                case 1: {
                    if (gEnum.getNumGroups() <= 2 || this.m_gt.isLineSelectPoint()) break;
                    isSmooth = true;
                    break;
                }
                case 2: {
                    this.drawSteppedLine(s, is3D);
                    continue block5;
                }
                case 3: {
                    this.drawCenteredSteppedLine(s, is3D);
                    continue block5;
                }
            }
            Vector<Point> points1 = new Vector<Point>(16, 4);
            Vector<Point> points2 = new Vector<Point>(16, 4);
            RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
            IdentObj AxisId = axisObj.getAxisIdentObj();
            bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
            bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
            double max = axisObj.getMaxValue();
            double min = axisObj.getMinValue();
            int maxCoord = (int)axisObj.getValueCoord(max);
            int minCoord = (int)axisObj.getValueCoord(min);
            ArrayList<Integer> groupIndexes1 = new ArrayList<Integer>();
            ArrayList<Integer> groupIndexes2 = new ArrayList<Integer>();
            while (gEnum.hasMoreElements()) {
                double newx;
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!gEnum.hasMoreElements()) continue;
                gNext = gEnum.peekAtNextGroup();
                if (this.m_Perspective.isTimeAxis() && this.m_Perspective.getDateFrequency() == 3 && !this.m_dataOK[s][gNext]) {
                    while (gEnum.hasMoreElements() && !this.m_dataOK[s][gNext]) {
                        gNext = gEnum.nextGroup();
                        gNext = gEnum.peekAtNextGroup();
                    }
                }
                PfjAssert.pfjAssert(gNext >= 0 && gNext < this.m_nTotalGroups);
                if (validStartGroup == -1 && this.m_dataOK[s][g]) {
                    validStartGroup = g;
                }
                if (gNext > validEndGroup && this.m_dataOK[s][gNext]) {
                    validEndGroup = gNext;
                }
                blackBox = this.assignSeriesColor(s, g);
                blackBox.runRules(s, -3);
                blackBox.setTransparentBorderColor(false);
                if (blackBox.getFillColor() != null) {
                    blackBox.setBorderColor(blackBox.getFillColor());
                }
                if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gNext]) continue;
                pt1 = this.getCoords(s, g);
                pt2 = this.getCoords(s, gNext);
                nStyle = this.m_Perspective.getLineStyle(idSeries);
                if (axisObj.isDescending()) {
                    int temp = minCoord;
                    minCoord = maxCoord;
                    maxCoord = temp;
                    boolean temp1 = bAutoMin;
                    bAutoMin = bAutoMax;
                    bAutoMax = temp1;
                }
                if (!bAutoMax) {
                    if (this.m_numYCoords[s][g] > maxCoord && this.m_numYCoords[s][gNext] > maxCoord) continue;
                    if (this.m_numYCoords[s][g] > maxCoord) {
                        if (this.m_bHorz) {
                            double newy = this.calcyPosition(pt1, pt2, maxCoord);
                            pt1.x = maxCoord;
                            pt1.y = (int)newy;
                        } else {
                            newx = this.calcxPosition(pt1, pt2, maxCoord);
                            pt1.y = maxCoord;
                            pt1.x = (int)newx;
                        }
                    } else if (this.m_numYCoords[s][gNext] > maxCoord) {
                        if (this.m_bHorz) {
                            double newy = this.calcyPosition(pt1, pt2, maxCoord);
                            pt2.x = maxCoord;
                            pt2.y = (int)newy;
                        } else {
                            newx = this.calcxPosition(pt1, pt2, maxCoord);
                            pt2.y = maxCoord;
                            pt2.x = (int)newx;
                        }
                    }
                }
                if (!bAutoMin) {
                    if (this.m_numYCoords[s][g] < minCoord && this.m_numYCoords[s][gNext] < minCoord) continue;
                    if (this.m_numYCoords[s][g] < minCoord) {
                        if (this.m_bHorz) {
                            double newy = this.calcyPosition(pt1, pt2, minCoord);
                            pt1.x = minCoord;
                            pt1.y = (int)newy;
                        } else {
                            newx = this.calcxPosition(pt1, pt2, minCoord);
                            pt1.y = minCoord;
                            pt1.x = (int)newx;
                        }
                    } else if (this.m_numYCoords[s][gNext] < minCoord) {
                        if (this.m_bHorz) {
                            double newy = this.calcyPosition(pt1, pt2, minCoord);
                            pt2.x = minCoord;
                            pt2.y = (int)newy;
                        } else {
                            newx = this.calcxPosition(pt1, pt2, minCoord);
                            pt2.y = minCoord;
                            pt2.x = (int)newx;
                        }
                    }
                }
                boolean bDrawNormal = true;
                if (this.m_nFillMissingData != 0) {
                    boolean bFilledMissingData = this.m_Access.m_DataStorage.isMissingDataFilledIn(s, g);
                    int nNumSegments = this.m_Perspective.getNumMissingDataSegments();
                    if (bFilledMissingData && nNumSegments != 0) {
                        Line theLine = new Line(pt1, pt2);
                        int nDenominator = nNumSegments * 2 + 1;
                        int nIdx = 1;
                        while (nIdx < nDenominator) {
                            Point ptOne = theLine.fractionalPoint(nIdx, nDenominator);
                            Point ptTwo = theLine.fractionalPoint(nIdx + 1, nDenominator);
                            points1.addElement(ptOne);
                            points2.addElement(ptTwo);
                            groupIndexes1.add(new Integer(g));
                            groupIndexes2.add(new Integer(gNext));
                            ++nIdx;
                            ++nIdx;
                        }
                        bDrawNormal = false;
                    }
                }
                if (!bDrawNormal || blackBox.getTransparentFillColor()) continue;
                points1.addElement(pt1);
                points2.addElement(pt2);
                groupIndexes1.add(new Integer(g));
                groupIndexes2.add(new Integer(gNext));
            }
            nWidth = this.m_Perspective.getLineWidth(idSeries);
            this.addStartAndEndPoints(points1, points2, groupIndexes1, groupIndexes2, s, validStartGroup, validEndGroup, minCoord, maxCoord, bAutoMin, bAutoMax);
            if (points1.size() <= 0) {
                if (!is3D) continue;
                if (!this.m_bMarkerDisplay && this.m_Perspective.getTransparentMarkers()) {
                    this.drawTransparentMarkersWithDepth(s, 2);
                    continue;
                }
                this.drawMarkersWithDepth(s, false);
                continue;
            }
            Vector<Point> points = new Vector<Point>(16, 4);
            points.addElement((Point)points1.elementAt(0));
            ArrayList<Integer> groupIndexes = new ArrayList<Integer>();
            groupIndexes.add((Integer)groupIndexes1.get(0));
            int i = 0;
            while (i < points1.size()) {
                points.addElement((Point)points2.elementAt(i));
                groupIndexes.add((Integer)groupIndexes2.get(i));
                if (i + 1 < points1.size() && !(pt1 = (Point)points1.elementAt(i + 1)).equals(pt2 = (Point)points2.elementAt(i))) {
                    if (isSmooth && !this.m_bHorz) {
                        points = this.calcCurveLinePoints(points);
                    }
                    if (is3D) {
                        this.draw3DLine(s, points);
                    } else {
                        new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), points, blackBox, this.m_Frame.getBackWallBounds(), nWidth, nStyle, false, groupIndexes);
                    }
                    points = new Vector<Point>(16, 4);
                    points.addElement((Point)points1.elementAt(i + 1));
                    groupIndexes = new ArrayList();
                    groupIndexes.add((Integer)groupIndexes1.get(i + 1));
                }
                ++i;
            }
            if (isSmooth && !this.m_bHorz) {
                points = this.calcCurveLinePoints(points);
            }
            if (is3D) {
                this.draw3DLine(s, points);
            } else {
                new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), (Vector)points, blackBox, this.m_Frame.getBackWallBounds(), nWidth, nStyle, false, groupIndexes);
            }
            if (!is3D) continue;
            if (!this.m_bMarkerDisplay && this.m_Perspective.getTransparentMarkers()) {
                this.drawTransparentMarkersWithDepth(s, 2);
                continue;
            }
            this.drawMarkersWithDepth(s, this.m_Perspective.getConnectLineMarkers());
        }
    }

    public void addStartAndEndPoints(Vector points1, Vector points2, int s, int validStartGroup, int validEndGroup, double minCoord, double maxCoord, boolean bAutoMin, boolean bAutoMax) {
        this.addStartAndEndPoints(points1, points2, null, null, s, validStartGroup, validEndGroup, minCoord, maxCoord, bAutoMin, bAutoMax);
    }

    public void addStartAndEndPoints(Vector points1, Vector points2, ArrayList groups1, ArrayList groups2, int s, int validStartGroup, int validEndGroup, double minCoord, double maxCoord, boolean bAutoMin, boolean bAutoMax) {
        if (!this.m_Perspective.isContinuousTimeAxis()) {
            return;
        }
        double fXValue = 0.0;
        double fYValue = 0.0;
        if (validStartGroup > 0 && this.m_dataOK[s][validStartGroup] && points1.size() > 0) {
            DatumObj obj = this.getDataValue(s, validStartGroup - 1, DataItem.DI_XY_X);
            fXValue = obj.m_fValue;
            obj = this.getDataValue(s, validStartGroup - 1, DataItem.DI_XY_Y);
            fYValue = obj.m_fValue;
            double x = 0.0;
            double y = 0.0;
            if (obj.m_bOK) {
                x = this.getO1Axis().getValueCoord(fXValue);
                RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                y = yAxis.getValueCoord(fYValue);
                Point pt1 = (Point)points1.elementAt(0);
                double min = this.getO1Axis().getMinValue();
                double minXCoord = this.getO1Axis().getValueCoord(min);
                double yCoord = this.calcyPosition(new Point((int)x, (int)y), pt1, minXCoord);
                if (!bAutoMin && yCoord < minCoord) {
                    yCoord = minCoord;
                }
                if (!bAutoMax && yCoord > maxCoord) {
                    yCoord = maxCoord;
                }
                points1.insertElementAt(new Point((int)minXCoord, (int)yCoord), 0);
                points2.insertElementAt(pt1, 0);
                if (groups1 != null && groups1.size() > 0 && groups2 != null && groups2.size() > 0) {
                    groups1.add(0, new Integer(validStartGroup - 1));
                    groups2.add(0, (Integer)groups1.get(1));
                }
            }
        }
        if (validEndGroup < this.m_nTotalGroups - 1 && validEndGroup >= 0 && this.m_dataOK[s][validEndGroup] && points2.size() > 0) {
            DatumObj obj = this.getDataValue(s, validEndGroup + 1, DataItem.DI_XY_X);
            fXValue = obj.m_fValue;
            obj = this.getDataValue(s, validEndGroup + 1, DataItem.DI_XY_Y);
            fYValue = obj.m_fValue;
            double x = 0.0;
            double y = 0.0;
            if (obj.m_bOK) {
                x = this.getO1Axis().getValueCoord(fXValue);
                RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                y = yAxis.getValueCoord(fYValue);
                Point pt1 = (Point)points2.lastElement();
                double max = this.getO1Axis().getMaxValue();
                double maxXCoord = this.getO1Axis().getValueCoord(max);
                double yCoord = this.calcyPosition(new Point((int)x, (int)y), pt1, maxXCoord);
                if (!bAutoMin && yCoord < minCoord) {
                    yCoord = minCoord;
                }
                if (!bAutoMax && yCoord > maxCoord) {
                    yCoord = maxCoord;
                }
                points2.add(new Point((int)maxXCoord, (int)yCoord));
                points1.add(pt1);
                if (groups1 != null && groups1.size() > 0 && groups2 != null && groups2.size() > 0) {
                    groups1.add((Integer)groups2.get(groups2.size() - 1));
                    groups2.add(new Integer(validEndGroup + 1));
                }
            }
        }
        if (validStartGroup == 0 && this.m_dataOK[s][validStartGroup] && !this.m_dataOK[s][validStartGroup + 1]) {
            DatumObj obj = this.getDataValue(s, validStartGroup + 1, DataItem.DI_XY_X);
            fXValue = obj.m_fValue;
            obj = this.getDataValue(s, validStartGroup + 1, DataItem.DI_XY_Y);
            fYValue = obj.m_fValue;
            double x = 0.0;
            double y = 0.0;
            if (obj.m_bOK) {
                x = this.getO1Axis().getValueCoord(fXValue);
                RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                y = yAxis.getValueCoord(fYValue);
                Point pt1 = this.getCoords(s, validStartGroup);
                double max = this.getO1Axis().getMaxValue();
                double maxXCoord = this.getO1Axis().getValueCoord(max);
                double yCoord = this.calcyPosition(pt1, new Point((int)x, (int)y), maxXCoord);
                if (!bAutoMin && (double)pt1.y < minCoord) {
                    pt1.y = (int)minCoord;
                }
                if (!bAutoMin && yCoord < minCoord) {
                    yCoord = minCoord;
                }
                if (!bAutoMax && (double)pt1.y > maxCoord) {
                    pt1.y = (int)maxCoord;
                }
                if (!bAutoMax && yCoord > maxCoord) {
                    yCoord = maxCoord;
                }
                points1.add(pt1);
                points2.add(new Point((int)maxXCoord, (int)yCoord));
                if (groups1 != null && groups2 != null) {
                    groups1.add(0, new Integer(validStartGroup));
                    groups2.add(0, new Integer(validStartGroup + 1));
                }
            }
        }
        if (validEndGroup == this.m_nTotalGroups - 1 && validEndGroup >= 1 && this.m_dataOK[s][validEndGroup] && !this.m_dataOK[s][validEndGroup - 1]) {
            DatumObj obj = this.getDataValue(s, validEndGroup - 1, DataItem.DI_XY_X);
            fXValue = obj.m_fValue;
            obj = this.getDataValue(s, validEndGroup - 1, DataItem.DI_XY_Y);
            fYValue = obj.m_fValue;
            double x = 0.0;
            double y = 0.0;
            if (obj.m_bOK) {
                x = this.getO1Axis().getValueCoord(fXValue);
                RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                y = yAxis.getValueCoord(fYValue);
                Point pt1 = this.getCoords(s, validEndGroup);
                double min = this.getO1Axis().getMinValue();
                double minXCoord = this.getO1Axis().getValueCoord(min);
                double yCoord = this.calcyPosition(new Point((int)x, (int)y), pt1, minXCoord);
                if (!bAutoMin && (double)pt1.y < minCoord) {
                    pt1.y = (int)minCoord;
                }
                if (!bAutoMin && yCoord < minCoord) {
                    yCoord = minCoord;
                }
                if (!bAutoMax && (double)pt1.y > maxCoord) {
                    pt1.y = (int)maxCoord;
                }
                if (!bAutoMax && yCoord > maxCoord) {
                    yCoord = maxCoord;
                }
                points2.add(new Point((int)minXCoord, (int)yCoord));
                points1.add(pt1);
                if (groups1 != null && groups2 != null) {
                    groups1.add(0, new Integer(validEndGroup - 1));
                    groups2.add(0, new Integer(validEndGroup));
                }
            }
        }
        if (validEndGroup < this.m_nTotalGroups - 1 && validStartGroup > 0 && validEndGroup == validStartGroup && this.m_dataOK[s][validEndGroup] && !this.m_dataOK[s][validEndGroup - 1] && !this.m_dataOK[s][validEndGroup + 1]) {
            DatumObj obj = this.getDataValue(s, validEndGroup - 1, DataItem.DI_XY_X);
            fXValue = obj.m_fValue;
            obj = this.getDataValue(s, validEndGroup - 1, DataItem.DI_XY_Y);
            fYValue = obj.m_fValue;
            DatumObj obj2 = this.getDataValue(s, validEndGroup + 1, DataItem.DI_XY_X);
            double fXValue2 = obj2.m_fValue;
            obj2 = this.getDataValue(s, validEndGroup + 1, DataItem.DI_XY_Y);
            double fYValue2 = obj2.m_fValue;
            double x = 0.0;
            double y = 0.0;
            if (obj.m_bOK && obj2.m_bOK) {
                x = this.getO1Axis().getValueCoord(fXValue);
                RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                y = yAxis.getValueCoord(fYValue);
                Point pt1 = this.getCoords(s, validEndGroup);
                double min = this.getO1Axis().getMinValue();
                double minXCoord = this.getO1Axis().getValueCoord(min);
                double yCoord = this.calcyPosition(new Point((int)x, (int)y), pt1, minXCoord);
                if (!bAutoMin && (double)pt1.y < minCoord) {
                    pt1.y = (int)minCoord;
                }
                if (!bAutoMin && yCoord < minCoord) {
                    yCoord = minCoord;
                }
                if (!bAutoMax && (double)pt1.y > maxCoord) {
                    pt1.y = (int)maxCoord;
                }
                if (!bAutoMax && yCoord > maxCoord) {
                    yCoord = maxCoord;
                }
                points1.add(new Point((int)minXCoord, (int)yCoord));
                points2.add(pt1);
                if (groups1 != null && groups2 != null) {
                    groups1.add(0, new Integer(validEndGroup - 1));
                    groups2.add(0, new Integer(validEndGroup));
                }
            }
            if (obj.m_bOK && obj2.m_bOK) {
                x = this.getO1Axis().getValueCoord(fXValue2);
                RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                y = yAxis.getValueCoord(fYValue2);
                Point pt1 = (Point)points2.lastElement();
                double max = this.getO1Axis().getMaxValue();
                double maxXCoord = this.getO1Axis().getValueCoord(max);
                double yCoord = this.calcyPosition(new Point((int)x, (int)y), pt1, maxXCoord);
                if (!bAutoMin && yCoord < minCoord) {
                    yCoord = minCoord;
                }
                if (!bAutoMax && yCoord > maxCoord) {
                    yCoord = maxCoord;
                }
                points2.add(new Point((int)maxXCoord, (int)yCoord));
                points1.add(pt1);
                if (groups1 != null && groups1.size() > 0 && groups2 != null && groups2.size() > 0) {
                    groups1.add((Integer)groups2.get(groups2.size() - 1));
                    groups2.add(new Integer(validEndGroup + 1));
                }
            }
        }
        if (validEndGroup == -1 && validStartGroup == -1) {
            int startGroup = -1;
            int endGroup = -1;
            double min = this.getO1Axis().getMinValue();
            double max = this.getO1Axis().getMaxValue();
            int i = 1;
            while (i < this.m_nTotalGroups) {
                if (this.getDataValue((int)s, (int)i, (DataItem)DataItem.DI_XY_X).m_fValue > max) {
                    startGroup = i - 1;
                    endGroup = i;
                    break;
                }
                ++i;
            }
            if (startGroup == endGroup) {
                return;
            }
            DatumObj obj = this.getDataValue(s, startGroup, DataItem.DI_XY_X);
            fXValue = obj.m_fValue;
            obj = this.getDataValue(s, startGroup, DataItem.DI_XY_Y);
            fYValue = obj.m_fValue;
            DatumObj obj2 = this.getDataValue(s, endGroup, DataItem.DI_XY_X);
            double fXValue2 = obj2.m_fValue;
            obj2 = this.getDataValue(s, endGroup, DataItem.DI_XY_Y);
            double fYValue2 = obj2.m_fValue;
            if (obj.m_bOK && obj2.m_bOK) {
                double x1 = this.getO1Axis().getValueCoord(fXValue);
                RelativeAxisObj yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                double y1 = yAxis.getValueCoord(fYValue);
                Point pt1 = new Point((int)x1, (int)y1);
                double x2 = this.getO1Axis().getValueCoord(fXValue2);
                double y2 = yAxis.getValueCoord(fYValue2);
                Point pt2 = new Point((int)x2, (int)y2);
                double minXCoord = this.getO1Axis().getValueCoord(min);
                double yCoord1 = this.calcyPosition(pt1, pt2, minXCoord);
                double maxXCoord = this.getO1Axis().getValueCoord(max);
                double yCoord2 = this.calcyPosition(pt1, pt2, maxXCoord);
                if (!bAutoMin && yCoord1 < minCoord) {
                    yCoord1 = minCoord;
                }
                if (!bAutoMin && yCoord2 < minCoord) {
                    yCoord2 = minCoord;
                }
                if (!bAutoMax && yCoord1 > maxCoord) {
                    yCoord1 = maxCoord;
                }
                if (!bAutoMax && yCoord2 > maxCoord) {
                    yCoord2 = maxCoord;
                }
                points1.add(new Point((int)minXCoord, (int)yCoord1));
                points2.add(new Point((int)maxXCoord, (int)yCoord2));
                if (groups1 != null && groups2 != null) {
                    groups1.add(0, new Integer(startGroup));
                    groups2.add(0, new Integer(endGroup));
                }
            }
        }
    }

    protected void drawMissingLineData(int nNumMissingSegments, Point ptIn1, Point ptIn2, int nSeries, int nGroup, BlackBoxIF blackBox, int nLineWidth, int nLineStyle) {
        Line theLine = new Line(ptIn1, ptIn2);
        int nDenominator = nNumMissingSegments * 2 + 1;
        int nIdx = 1;
        while (nIdx < nDenominator) {
            Point ptOne = theLine.fractionalPoint(nIdx, nDenominator);
            Point ptTwo = theLine.fractionalPoint(nIdx + 1, nDenominator);
            IdentObj idObj = new IdentObj(258, nSeries, nGroup);
            new DetLine(this.m_Detectiv, idObj, ptOne.x, ptOne.y, ptTwo.x, ptTwo.y, blackBox, null, nLineWidth, nLineStyle);
            ++nIdx;
            ++nIdx;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void drawMarkers() {
        sEnum = this.getResetSeriesEnumerator();
        gEnum = this.getResetGroupsEnumerator();
        s = 0;
        g = 0;
        if (this.m_bMarkerDisplay || this.m_gt.isBLAType() || this.m_gt.isPolar() || this.m_gt.isScatter() || this.m_gt.isBubble()) ** GOTO lbl70
        return;
lbl-1000:
        // 1 sources

        {
            s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] != 2) continue;
            idSeries = new IdentObj(-3, s);
            nMarkerSeriesID = s % this.m_nSeriesLooping;
            if (this.m_Perspective.getMarkerShapeObj(idSeries) != null) {
                nMarkerSeriesID = s;
            }
            idMarkerSeries = new IdentObj(-3, nMarkerSeriesID);
            markerTemplate = this.getMarkerShape(idMarkerSeries);
            axisObj = this.whichAxisForSeries(s, null);
            maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
            minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
            if (this.m_gt.isBubble() && !this.m_Perspective.getUseDefaultBubbleMarker()) {
                markerTemplate = MarkerTemplateArray.PRESET_BUBBLE;
            }
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g] || this.m_gt.isBLAType() && (this.m_numYCoords[s][g] > maxCoord || this.m_numYCoords[s][g] < minCoord)) continue;
                center = this.getCoords(s, g);
                markerSizeX = markerSizeY = this.getMarkerSize(s, g);
                if (this.m_bSquareMarkers) {
                    destX = this.m_Perspective.m_VC.virtToDestWidth((double)markerSizeX);
                    if (destX > (destY = this.m_Perspective.m_VC.virtToDestHeight((double)markerSizeY))) {
                        markerSizeX = (int)((double)markerSizeX * destY / destX);
                    } else {
                        markerSizeY = (int)((double)markerSizeY * destX / destY);
                    }
                }
                this.m_smallMarker = this.m_autoGradient != false && this.m_Perspective.m_VC.virtToDestWidth(markerSizeX) <= 8;
                blackBox = this.assignSeriesColor(s, g);
                style = blackBox.runRules(s, g);
                if (!this.m_bMarkerDisplay && this.m_gt.isBLAType() && (style == null || !style.isMarkerVisibleUsed())) continue;
                if (this.m_gt.isBubble()) {
                    this._addBubbleMarker(this.m_Detectiv, new IdentObj(259, s, g), markerTemplate, center, markerSizeX, markerSizeY, blackBox, this.m_rClip, true);
                    continue;
                }
                if (style != null) {
                    if (style.isMarkerVisibleUsed() && !style.isMarkerVisible()) {
                        markerTemplate = new MarkerTemplateArray().getMarkerTemplate(0);
                    } else if (style.isMarkerShapeUsed() && style.getMarkerShape() != markerTemplate.getMarkerType() || style.isMarkerVisibleUsed() && style.isMarkerVisible()) {
                        markerTemplate = new MarkerTemplateArray().getMarkerTemplate(style.getMarkerShape());
                    }
                }
                seriesLooping = this.m_Perspective.getSeriesLooping();
                lineMarkerID = new IdentObj(259, s % seriesLooping);
                bb = new BlackBoxObj(this.m_Perspective, lineMarkerID);
                if (s >= seriesLooping) {
                    this.m_Perspective.m_getDefault = false;
                    idS = new IdentObj(-3, s);
                    c = this.m_Perspective.getFillColor(idS);
                    this.m_Perspective.m_getDefault = true;
                    if (c != null) {
                        lineMarkerID = new IdentObj(259, s);
                        bb = new BlackBoxObj(this.m_Perspective, lineMarkerID);
                    }
                }
                if (blackBox.getBorderColor() != null) {
                    bb.setBorderColor(blackBox.getBorderColor());
                }
                bb.setTransparentBorderColor(blackBox.getTransparentBorderColor());
                if (markerTemplate.m_markerType == 0 && !this.m_gt.isPolar() && !this.m_gt.isScatter()) {
                    dimMarker = this.getTransparentMarkerDimension();
                    bb.setTransparentFillColor(true);
                    new MarkerObj(this.m_Detectiv, new IdentObj(259, s, g), MarkerTemplateArray.PRESET_SQUARE, center, dimMarker.width, dimMarker.height, bb, null, true, false, 0, 0, 0, false);
                    continue;
                }
                new MarkerObj(this.m_Detectiv, new IdentObj(259, s, g), markerTemplate, center, markerSizeX, markerSizeY, bb, null, true);
            }
lbl70:
            // 3 sources

            ** while (sEnum.hasMoreElements())
        }
lbl71:
        // 1 sources

        if (this.m_gt.isBubble()) {
            this._createBubbleMarkerObjs();
        }
    }

    private void _addBubbleMarker(Detectiv a_Detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox, Rectangle rClip, boolean bLimitSize) {
        if (this.m_bubbleMarkerInfo == null) {
            this.m_bubbleMarkerInfo = new ArrayList(this.m_nTotalGroups * this.m_nTotalSeries);
        }
        Object[] bubbleInfo = new Object[]{a_Detectiv, id, template, center, new Integer(markerSizeX), new Integer(markerSizeY), blackBox, rClip, new Boolean(bLimitSize)};
        this.m_bubbleMarkerInfo.add(bubbleInfo);
    }

    private void _createBubbleMarkerObjs() {
        if (this.m_bubbleMarkerInfo != null) {
            Collections.sort(this.m_bubbleMarkerInfo, m_bubbleComparator);
            for (Object[] bubbleInfo : this.m_bubbleMarkerInfo) {
                Detectiv detectiv = (Detectiv)bubbleInfo[0];
                IdentObj id = (IdentObj)bubbleInfo[1];
                MarkerTemplate template = (MarkerTemplate)bubbleInfo[2];
                Point center = (Point)bubbleInfo[3];
                int markerSizeX = (Integer)bubbleInfo[4];
                int markerSizeY = (Integer)bubbleInfo[5];
                BlackBoxIF blackBox = (BlackBoxIF)bubbleInfo[6];
                Rectangle rClip = (Rectangle)bubbleInfo[7];
                boolean bLimitSize = (Boolean)bubbleInfo[8];
                new MarkerObj(detectiv, id, template, center, markerSizeX, markerSizeY, blackBox, rClip, bLimitSize);
            }
            this.m_bubbleMarkerInfo = null;
        }
    }

    protected void drawTransparentMarkers(int nSeriesType) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        MarkerTemplate markerTemplate = MarkerTemplateArray.PRESET_SQUARE;
        Dimension dimMarker = this.getTransparentMarkerDimension();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] != nSeriesType) continue;
            gEnum.reset();
            RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
            int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
            int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
            if (axisObj.isDescending()) {
                int temp = minCoord;
                minCoord = maxCoord;
                maxCoord = temp;
            }
            int prevX = -1;
            int prevY = -1;
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g] || !this.m_gt.isPolar() && !this.m_gt.isRadarType() && (this.m_numYCoords[s][g] > maxCoord || this.m_numYCoords[s][g] < minCoord)) continue;
                IdentObj identObjLineMarker = new IdentObj(259, s, g);
                SimpleBlackBoxObj blackBoxTransparent = new SimpleBlackBoxObj(this.m_Perspective, identObjLineMarker, false);
                blackBoxTransparent.setTransparentFillColor(true);
                Point ptCenter = this.getCoords(s, g);
                int destX = this.m_Perspective.m_VC.virtToDestX(ptCenter.x);
                int destY = this.m_Perspective.m_VC.virtToDestY(ptCenter.y);
                if (destX == prevX && destY == prevY) continue;
                prevX = destX;
                prevY = destY;
                new MarkerObj(this.m_Detectiv, identObjLineMarker, markerTemplate, ptCenter, dimMarker.width, dimMarker.height, blackBoxTransparent, null, true, false, 0, 0, 0, false);
            }
        }
    }

    protected Dimension getTransparentMarkerDimension() {
        double destY;
        int nMarkerHeight;
        int nMarkerSize = this.m_Perspective.getTransparentMarkerSize();
        int nMarkerWidth = nMarkerSize == 0 ? (nMarkerHeight = this.m_Perspective.getMarkerSizeDefault()) : (nMarkerHeight = nMarkerSize);
        double destX = this.m_Perspective.m_VC.virtToDestWidth((double)nMarkerWidth);
        if (destX > (destY = this.m_Perspective.m_VC.virtToDestHeight((double)nMarkerHeight))) {
            nMarkerWidth = (int)((double)nMarkerWidth * destY / destX);
        } else {
            nMarkerHeight = (int)((double)nMarkerHeight * destX / destY);
        }
        Dimension dimMarker = new Dimension(nMarkerWidth, nMarkerHeight);
        return dimMarker;
    }

    /*
     * Unable to fully structure code
     */
    protected void drawAllMarkersWithDepth(boolean faceOnly) {
        sEnum = this.getResetSeriesEnumerator();
        if (!(this.m_bMarkerDisplay || this.m_gt.isBLAType() || this.m_gt.isPolar() || this.m_gt.isRadarType() || this.m_gt.isScatter() || this.m_gt.isBubble())) {
            return;
        }
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.m_Frame != null) ** GOTO lbl10
        throw new AssertionException("Can't draw 2.5D markers without m_Frame");
lbl-1000:
        // 1 sources

        {
            s = sEnum.nextSeries();
            this.drawMarkersWithDepth(s, faceOnly);
lbl10:
            // 2 sources

            ** while (sEnum.hasMoreElements())
        }
lbl11:
        // 1 sources

        if (this.m_gt.isBubble()) {
            this._createBubbleMarkerObjsWithDepth();
        }
    }

    protected void drawMarkersWithDepth(int s, boolean faceOnly) {
        int nYDepth;
        int nXDepth;
        Point ptBackOffset;
        Point ptFrontOffset;
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        boolean bAutoMax = false;
        boolean bAutoMin = false;
        boolean bThreeD = faceOnly ^ true;
        if (!(this.m_bMarkerDisplay || this.m_gt.isBLAType() || this.m_gt.isPolar() || this.m_gt.isRadarType() || this.m_gt.isScatter() || this.m_gt.isBubble())) {
            return;
        }
        RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
        IdentObj AxisId = axisObj.getAxisIdentObj();
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D markers without m_Frame");
        }
        PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
        if (this.m_seriesTypes[s] != 2) {
            return;
        }
        int nMarkerSeriesID = s % this.m_nSeriesLooping;
        IdentObj idMarkerSeries = this.m_Perspective.getSeries(nMarkerSeriesID);
        MarkerTemplate markerTemplate = this.getMarkerShape(idMarkerSeries);
        if (markerTemplate.m_markerType == 2) {
            markerTemplate = MarkerTemplateArray.PRESET_DEPTHCIRCLE;
        }
        if (this.m_gt.isBubble() && !this.m_Perspective.getUseDefaultBubbleMarker()) {
            markerTemplate = MarkerTemplateArray.PRESET_BUBBLE;
        }
        if (this.m_nDepthRadius > 0 && this.m_nDepthPlanes > 0) {
            double fFrontOffset = this.calcFrontOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            double fBackOffset = this.calcBackOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            if (fBackOffset > 0.0) {
                fBackOffset -= 1.0 / (double)this.m_nDepthPlanes / 2.0;
            } else {
                fFrontOffset = 1.0 / (double)this.m_nDepthPlanes / 2.0 + fFrontOffset;
            }
            ptFrontOffset = this.m_Frame.getDepthOffset(fFrontOffset);
            ptBackOffset = this.m_Frame.getDepthOffset(fBackOffset);
            nXDepth = ptFrontOffset.x - ptBackOffset.x;
            nYDepth = ptFrontOffset.y - ptBackOffset.y;
        } else {
            ptFrontOffset = new Point();
            ptBackOffset = new Point();
            nXDepth = 0;
            nYDepth = 0;
        }
        gEnum.reset();
        int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
        int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
        while (gEnum.hasMoreElements()) {
            int markerSizeY;
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            if (!this.m_dataOK[s][g] || this.m_gt.isBLAType() && (this.m_numYCoords[s][g] > maxCoord || this.m_numYCoords[s][g] < minCoord)) continue;
            Point ptCenter = this.getCoords(s, g);
            Point ptFront = new Point(ptCenter.x - ptFrontOffset.x, ptCenter.y - ptFrontOffset.y);
            int markerSizeX = markerSizeY = this.getMarkerSize(s, g);
            if (this.m_bSquareMarkers) {
                double destY;
                double destX = this.m_Perspective.m_VC.virtToDestWidth((double)markerSizeX);
                if (destX > (destY = this.m_Perspective.m_VC.virtToDestHeight((double)markerSizeY))) {
                    markerSizeX = (int)((double)markerSizeX * destY / destX);
                } else {
                    markerSizeY = (int)((double)markerSizeY * destX / destY);
                }
            }
            BlackBoxIF blackBox = this.assignSeriesColor(s, g);
            GraphStyle style = blackBox.runRules(s, g);
            if (!this.m_bMarkerDisplay && this.m_gt.isBLAType() && (style == null || !style.isMarkerVisibleUsed())) continue;
            IdentObj identObjLineMarker = new IdentObj(259, s, g);
            identObjLineMarker.setMiscID(0);
            if (this.m_gt.isBubble()) {
                this._addBubbleMarkerWithDepth(this.m_Detectiv, identObjLineMarker, markerTemplate, ptFront, markerSizeX, markerSizeY, blackBox, this.m_rClip, true, true, nXDepth, nYDepth, this.m_nDepthAngle);
                continue;
            }
            if (style != null) {
                if (style.isMarkerVisibleUsed() && !style.isMarkerVisible()) {
                    markerTemplate = new MarkerTemplateArray().getMarkerTemplate(0);
                } else if (style.isMarkerShapeUsed() && style.getMarkerShape() != markerTemplate.getMarkerType()) {
                    markerTemplate = new MarkerTemplateArray().getMarkerTemplate(style.getMarkerShape());
                }
            }
            IdentObj lineMarkerID = new IdentObj(259, s);
            BlackBoxIF bb = new BlackBoxObj(this.m_Perspective, lineMarkerID);
            if (blackBox.getBorderColor() != null) {
                bb.setBorderColor(blackBox.getBorderColor());
            }
            bb.setTransparentBorderColor(blackBox.getTransparentBorderColor());
            Color markerColor = this.m_Perspective.getFillColor(lineMarkerID);
            if (markerColor.equals((Color)Attr.SeriesFillColor[s].getDefault())) {
                bb = blackBox;
            }
            new MarkerObj(this.m_Detectiv, identObjLineMarker, markerTemplate, ptFront, markerSizeX, markerSizeY, bb, null, true, bThreeD, nXDepth, nYDepth, this.m_nDepthAngle);
        }
    }

    private void _addBubbleMarkerWithDepth(Detectiv a_Detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox, Rectangle rClip, boolean bLimitSize, boolean threed, int nXDepth, int nYDepth, int nDepthAngle) {
        if (this.m_bubbleMarkerInfo == null) {
            this.m_bubbleMarkerInfo = new ArrayList(this.m_nTotalGroups * this.m_nTotalSeries);
        }
        Object[] bubbleInfo = new Object[]{a_Detectiv, id, template, center, new Integer(markerSizeX), new Integer(markerSizeY), blackBox, rClip, new Boolean(bLimitSize), new Boolean(threed), new Integer(nXDepth), new Integer(nYDepth), new Integer(nDepthAngle)};
        this.m_bubbleMarkerInfo.add(bubbleInfo);
    }

    private void _createBubbleMarkerObjsWithDepth() {
        if (this.m_bubbleMarkerInfo != null) {
            Collections.sort(this.m_bubbleMarkerInfo, m_bubbleComparator);
            for (Object[] bubbleInfo : this.m_bubbleMarkerInfo) {
                Detectiv detectiv = (Detectiv)bubbleInfo[0];
                IdentObj id = (IdentObj)bubbleInfo[1];
                MarkerTemplate template = (MarkerTemplate)bubbleInfo[2];
                Point center = (Point)bubbleInfo[3];
                int markerSizeX = (Integer)bubbleInfo[4];
                int markerSizeY = (Integer)bubbleInfo[5];
                BlackBoxIF blackBox = (BlackBoxIF)bubbleInfo[6];
                Rectangle rClip = (Rectangle)bubbleInfo[7];
                boolean bLimitSize = (Boolean)bubbleInfo[8];
                boolean threed = (Boolean)bubbleInfo[9];
                int nXDepth = (Integer)bubbleInfo[10];
                int nYDepth = (Integer)bubbleInfo[11];
                int nDepthAngle = (Integer)bubbleInfo[12];
                new MarkerObj(detectiv, id, template, center, markerSizeX, markerSizeY, blackBox, rClip, bLimitSize, threed, nXDepth, nYDepth, nDepthAngle);
            }
            this.m_bubbleMarkerInfo = null;
        }
    }

    protected void drawTransparentMarkersWithDepth(int s, int nSeriesType) {
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        Point ptFront = new Point();
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D markers without m_Frame");
        }
        PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
        MarkerTemplate markerTemplate = MarkerTemplateArray.PRESET_SQUARE;
        Dimension dimMarker = this.getTransparentMarkerDimension();
        if (this.m_seriesTypes[s] == nSeriesType) {
            int nYDepth;
            int nXDepth;
            Point ptBackOffset;
            Point ptFrontOffset;
            if (this.m_nDepthRadius > 0 && this.m_nDepthPlanes > 0) {
                double fFrontOffset = this.calcFrontOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
                ptFrontOffset = this.m_Frame.getDepthOffset(fFrontOffset);
                double fBackOffset = this.calcBackOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
                ptBackOffset = this.m_Frame.getDepthOffset(fBackOffset);
                nXDepth = ptFrontOffset.x - ptBackOffset.x;
                nYDepth = ptFrontOffset.y - ptBackOffset.y;
                nXDepth = 3 * nXDepth;
                nYDepth = 3 * nYDepth;
            } else {
                ptFrontOffset = new Point();
                ptBackOffset = new Point();
                nXDepth = 0;
                nYDepth = 0;
            }
            nYDepth = 0;
            nXDepth = 0;
            gEnum.reset();
            RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
            int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
            int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
            if (axisObj.isDescending()) {
                int temp = minCoord;
                minCoord = maxCoord;
                maxCoord = temp;
            }
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g] || !this.m_gt.isPolar() && !this.m_gt.isRadarType() && (this.m_numYCoords[s][g] > maxCoord || this.m_numYCoords[s][g] < minCoord)) continue;
                Point ptCenter = this.getCoords(s, g);
                ptFront.x = ptCenter.x - ptFrontOffset.x;
                ptFront.y = ptCenter.y - ptFrontOffset.y;
                IdentObj identObjLineMarker = new IdentObj(259, s, g);
                identObjLineMarker.setMiscID(0);
                SimpleBlackBoxObj blackBoxTransparent = new SimpleBlackBoxObj(this.m_Perspective, identObjLineMarker, false);
                blackBoxTransparent.setTransparentFillColor(true);
                new MarkerObj(this.m_Detectiv, identObjLineMarker, markerTemplate, ptFront, dimMarker.width, dimMarker.height, blackBoxTransparent, null, true, true, nXDepth, nYDepth, this.m_nDepthAngle, false);
            }
        }
    }

    protected MinMaxObj findLimits(int axis, int scaling, boolean bMustIncludeZero, MinMaxObj mmZoom) {
        MinMaxObj minMaxObj;
        block101: {
            int s;
            int[] axisAssignments;
            int nItems;
            DataFormat df;
            int nZeroValue;
            double fEndOfPreviousStack;
            block102: {
                block94: {
                    fEndOfPreviousStack = 0.0;
                    nZeroValue = 0;
                    minMaxObj = this.findPreScaledLimits(axis, scaling, bMustIncludeZero);
                    if (minMaxObj != null) {
                        return minMaxObj;
                    }
                    minMaxObj = new MinMaxObj(bMustIncludeZero);
                    df = this.m_Access.getDataFormat();
                    nItems = df.getNumDataItems();
                    axisAssignments = new int[this.m_nTotalSeries];
                    s = 0;
                    while (s < this.m_nTotalSeries) {
                        axisAssignments[s] = this.getAxisAssignment(s);
                        ++s;
                    }
                    this.setNonDataLimits(minMaxObj);
                    if (scaling != 1) break block94;
                    s = 0;
                    while (s < this.m_nTotalSeries) {
                        block95: {
                            if (this.m_Perspective.getSeriesVisibility(s) == 1 || (axis == 0 || axis == 1 || axis == 2 || axis == 3 || axis == 4) && axisAssignments[s] != axis) break block95;
                            if (axis == 1) {
                                this.m_dualY = true;
                            }
                            if (axis == 7) {
                                this.m_XY = true;
                            }
                            if (this.m_dualY && this.m_XY) {
                                this.m_dualYX = true;
                                this.m_dualY = false;
                                this.m_XY = false;
                            }
                            int g = 0;
                            while (g < this.m_nTotalGroups) {
                                int i = 0;
                                while (i < nItems) {
                                    block96: {
                                        double fValue;
                                        block100: {
                                            block97: {
                                                DatumObj dObj;
                                                block99: {
                                                    block98: {
                                                        DataItem item = df.getDataItem(i);
                                                        if (item.ignoreInScaling() || !AxisTemplate.isSameType(item.getAssocAxis(), axis)) break block96;
                                                        dObj = this.getDataValue(s, g, item);
                                                        fValue = dObj.m_fValue;
                                                        if (fValue == 0.0 && !dObj.m_bOK) {
                                                            if (axis == 0) {
                                                                this.m_nullValY1 = true;
                                                            } else if (axis == 1) {
                                                                this.m_nullValY2 = true;
                                                            } else if (axis == 7) {
                                                                this.m_nullValX1 = true;
                                                            }
                                                        }
                                                        if (!dObj.m_bOK) break block96;
                                                        if (!(fValue <= 0.0) || !this.isBadValueInLogscale(axis, fValue)) break block97;
                                                        if (axis != 0) break block98;
                                                        if (fValue == 0.0 && dObj.m_bOK) {
                                                            this.m_zeroValY1 = true;
                                                        } else if (fValue == 0.0 && !dObj.m_bOK) {
                                                            this.m_nullValY1 = true;
                                                        } else {
                                                            this.m_negativeValY1 = true;
                                                        }
                                                        break block96;
                                                    }
                                                    if (axis != 1) break block99;
                                                    if (fValue == 0.0 && dObj.m_bOK) {
                                                        this.m_zeroValY2 = true;
                                                    } else if (fValue == 0.0 && !dObj.m_bOK) {
                                                        this.m_nullValY2 = true;
                                                    } else {
                                                        this.m_negativeValY2 = true;
                                                    }
                                                    break block96;
                                                }
                                                if (axis != 7) break block100;
                                                if (fValue == 0.0 && dObj.m_bOK) {
                                                    this.m_zeroValX1 = true;
                                                } else if (fValue == 0.0 && !dObj.m_bOK) {
                                                    this.m_nullValX1 = true;
                                                } else {
                                                    this.m_negativeValX1 = true;
                                                }
                                                break block96;
                                            }
                                            if (axis == 0) {
                                                this.m_positiveValY1 = true;
                                            } else if (axis == 1) {
                                                this.m_positiveValY2 = true;
                                            } else if (axis == 7) {
                                                this.m_positiveValX1 = true;
                                            }
                                        }
                                        if (mmZoom == null || !(fValue < mmZoom.getAdjMin()) && !(fValue > mmZoom.getAdjMax())) {
                                            minMaxObj.testRawValue(fValue);
                                        }
                                    }
                                    ++i;
                                }
                                ++g;
                            }
                        }
                        ++s;
                    }
                    break block101;
                }
                if (scaling != 2) break block102;
                SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
                GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
                while (gEnum.hasMoreElements()) {
                    int g = gEnum.nextGroup();
                    PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                    SumObj sumObj = new SumObj();
                    sEnum.reset();
                    while (sEnum.hasMoreElements()) {
                        s = sEnum.nextSeries();
                        PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                        if (this.m_Perspective.getSeriesVisibility(s) == 1 || (axis == 0 || axis == 1 || axis == 2 || axis == 3 || axis == 4) && axisAssignments[s] != axis) continue;
                        if (axis == 1) {
                            this.m_dualY = true;
                        }
                        if (axis == 7) {
                            this.m_XY = true;
                        }
                        if (this.m_dualY && this.m_XY) {
                            this.m_dualYX = true;
                            this.m_dualY = false;
                            this.m_XY = false;
                        }
                        int i = 0;
                        while (i < nItems) {
                            block103: {
                                double fValue;
                                block107: {
                                    block104: {
                                        DatumObj dObj;
                                        block106: {
                                            block105: {
                                                DataItem item = df.getDataItem(i);
                                                if (item.ignoreInScaling() || !AxisTemplate.isSameType(item.getAssocAxis(), axis)) break block103;
                                                dObj = this.getDataValue(s, g, item);
                                                fValue = dObj.m_fValue;
                                                if (fValue == 0.0 && !dObj.m_bOK) {
                                                    if (axis == 0) {
                                                        this.m_nullValY1 = true;
                                                    } else if (axis == 1) {
                                                        this.m_nullValY2 = true;
                                                    } else if (axis == 7) {
                                                        this.m_nullValX1 = true;
                                                    }
                                                }
                                                if (!dObj.m_bOK) break block103;
                                                if (!(fValue <= 0.0) || !this.isBadValueInLogscale(axis, fValue)) break block104;
                                                if (axis != 0) break block105;
                                                if (fValue == 0.0 && dObj.m_bOK) {
                                                    this.m_zeroValY1 = true;
                                                } else if (fValue == 0.0 && !dObj.m_bOK) {
                                                    this.m_nullValY1 = true;
                                                } else {
                                                    this.m_negativeValY1 = true;
                                                }
                                                break block103;
                                            }
                                            if (axis != 1) break block106;
                                            if (fValue == 0.0 && dObj.m_bOK) {
                                                this.m_zeroValY2 = true;
                                            } else if (fValue == 0.0 && !dObj.m_bOK) {
                                                this.m_nullValY2 = true;
                                            } else {
                                                this.m_negativeValY2 = true;
                                            }
                                            break block103;
                                        }
                                        if (axis != 7) break block107;
                                        if (fValue == 0.0 && dObj.m_bOK) {
                                            this.m_zeroValX1 = true;
                                        } else if (fValue == 0.0 && !dObj.m_bOK) {
                                            this.m_nullValX1 = true;
                                        } else {
                                            this.m_negativeValX1 = true;
                                        }
                                        break block103;
                                    }
                                    if (axis == 0) {
                                        this.m_positiveValY1 = true;
                                    } else if (axis == 1) {
                                        this.m_positiveValY2 = true;
                                    } else if (axis == 7) {
                                        this.m_positiveValX1 = true;
                                    }
                                }
                                boolean bPos = fValue >= 0.0;
                                boolean bY2 = axis == 1;
                                int nRiser = this.m_seriesTypes[s];
                                if (this.m_Perspective.isMarkerTypeStacked(nRiser)) {
                                    double fSum = sumObj.getSum(bPos, bY2, nRiser) + fValue;
                                    sumObj.setSum(bPos, bY2, nRiser, fSum);
                                    minMaxObj.testRawValue(fSum);
                                } else {
                                    minMaxObj.testRawValue(fValue);
                                }
                            }
                            ++i;
                        }
                    }
                }
                break block101;
            }
            if (scaling == 5) {
                SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
                GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
                while (gEnum.hasMoreElements()) {
                    int g = gEnum.nextGroup();
                    PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                    SumObj sumObj = new SumObj();
                    sEnum.reset();
                    while (sEnum.hasMoreElements()) {
                        s = sEnum.nextSeries();
                        PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                        if (this.m_Perspective.getSeriesVisibility(s) == 1 || (axis == 0 || axis == 1 || axis == 2 || axis == 3 || axis == 4) && axisAssignments[s] != axis) continue;
                        int i = 0;
                        while (i < nItems) {
                            DataItem item = df.getDataItem(i);
                            if (!item.ignoreInScaling() && AxisTemplate.isSameType(item.getAssocAxis(), axis)) {
                                DatumObj dObj = this.getDataValue(s, g, item);
                                double fValue = dObj.m_fValue;
                                if (dObj.m_bOK) {
                                    if (!sumObj.m_bFirstTime && sumObj.m_bFirstSetIsPositive == fValue < 0.0) {
                                        fValue = -fValue;
                                    }
                                    if (!(fValue <= 0.0) || !this.isBadValueInLogscale(axis, fValue)) {
                                        boolean bPos = fValue >= 0.0;
                                        boolean bY2 = axis == 1;
                                        int nRiser = this.m_seriesTypes[s];
                                        double fSum = sumObj.getSum(bPos, bY2, nRiser) + fValue;
                                        sumObj.setSum(bPos, bY2, nRiser, fSum);
                                        minMaxObj.testRawValue(fSum += fEndOfPreviousStack);
                                        if (s == sEnum.getLastSeries()) {
                                            fEndOfPreviousStack = fSum;
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                }
            } else if (scaling == 3) {
                s = 0;
                block10: while (s < this.m_nTotalSeries) {
                    if (this.m_Perspective.getSeriesVisibility(s) != 1 && (axis != 0 && axis != 1 && axis != 2 && axis != 3 && axis != 4 || axisAssignments[s] == axis)) {
                        int g = 0;
                        while (g < this.m_nTotalGroups) {
                            int i = 0;
                            while (i < nItems) {
                                DataItem item = df.getDataItem(i);
                                if (!item.ignoreInScaling() && AxisTemplate.isSameType(item.getAssocAxis(), axis)) {
                                    DatumObj dObj = this.getDataValue(s, g, item);
                                    double fValue = dObj.m_fValue;
                                    if (dObj.m_bOK) {
                                        if (fValue < 0.0) {
                                            this.m_negativeVal = true;
                                            break block10;
                                        }
                                        if (fValue == 0.0 && dObj.m_bOK) {
                                            this.m_zeroVal = true;
                                            ++nZeroValue;
                                        }
                                        if (fValue > 0.0) {
                                            this.m_positiveVal = true;
                                        }
                                    }
                                }
                                ++i;
                            }
                            ++g;
                        }
                    }
                    ++s;
                }
                minMaxObj.testRawValue(1.0);
                minMaxObj.testRawValue(0.0);
            } else if (scaling == 4) {
                s = 0;
                while (s < this.m_nTotalSeries) {
                    if (this.m_Perspective.getSeriesVisibility(s) != 1) {
                        int g = 0;
                        while (g < this.m_nTotalGroups) {
                            if (axis == 7) {
                                int i = 0;
                                while (i < nItems) {
                                    DataItem item = df.getDataItem(i);
                                    if (!item.ignoreInScaling()) {
                                        DatumObj dObj = this.getDataValue(s, g, item);
                                        double fValue = dObj.m_fValue;
                                        if (!(!dObj.m_bOK || fValue <= 0.0 && this.isBadValueInLogscale(axis, fValue))) {
                                            minMaxObj.testRawValue(fValue);
                                        }
                                    }
                                    ++i;
                                }
                            } else {
                                throw new AssertionException("FindLimit should not be called for Y1 axis");
                            }
                            ++g;
                        }
                    }
                    ++s;
                }
            } else {
                throw new AssertionException(1, 5, scaling);
            }
        }
        return minMaxObj;
    }

    public int getBaseCoord(int s) {
        RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, null);
        boolean bFromZero = this.m_Perspective.getScaleFromZero() || yAxisObj.hasNegData() && !this.m_bAbsolute;
        int baseCoord = bFromZero ? (int)yAxisObj.getValueCoord(0.0) : (int)yAxisObj.getBaseCoord();
        return baseCoord;
    }

    public int getDataCoord(int s, int g) {
        return this.getDataCoord(s, g, DataItem.DI_GENERAL, false);
    }

    public int getDataCoord(int s, int g, DataItem item, boolean bCumulative) {
        RelativeAxisObj axisObj = this.whichAxisForSeries(s, item);
        double val = this.getDataValue((int)s, (int)g, (DataItem)item).m_fValue;
        if (bCumulative) {
            return this.getDataCoordCum(s, g, item);
        }
        return (int)axisObj.getValueCoord(val);
    }

    public int getDataCoordCum(int s, int g, DataItem item) {
        return this.m_numYCoords[s][g];
    }

    public double getDataFromCoord(int s, int g, int nCoord) {
        RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, DataItem.DI_GENERAL);
        return yAxisObj.getValueFromCoord(nCoord);
    }

    public double getDataFromCoord(int s, int g, DataItem item, int nCoord) {
        RelativeAxisObj axisObj = this.whichAxisForSeries(s, item);
        return axisObj.getValueFromCoord(nCoord);
    }

    public DatumObj getDataValue(int s, int g, DataItem item) {
        DatumObj dObj = super.getDataValue(s, g, item);
        double fValue = dObj.m_fValue;
        boolean bOK = dObj.m_bOK;
        if (this.m_gt.isRiserArea() && !this.m_bAbsolute && fValue < 0.0) {
            dObj = new DatumObj(-fValue, bOK);
        }
        return dObj;
    }

    public DatumObj getDataValue(int s, int g) {
        DatumObj dObj = super.getDataValue(s, g);
        double fValue = dObj.m_fValue;
        boolean bOK = dObj.m_bOK;
        if (this.m_gt.isRiserArea() && !this.m_bAbsolute && fValue < 0.0) {
            dObj = new DatumObj(-fValue, bOK);
        }
        return dObj;
    }

    public double getAutoLowerSplitValue(IdentObj id) {
        if (id == null) {
            return Double.NaN;
        }
        if (this.m_X1Axis != null && id.equals(this.m_X1Axis.getAxisIdentObj())) {
            return this.m_X1Axis.getAutoLowerSplitValue();
        }
        if (this.m_Y1Axis != null && id.equals(this.m_Y1Axis.getAxisIdentObj())) {
            return this.m_Y1Axis.getAutoLowerSplitValue();
        }
        if (this.m_Y2Axis != null && id.equals(this.m_Y2Axis.getAxisIdentObj())) {
            return this.m_Y2Axis.getAutoLowerSplitValue();
        }
        return Double.NaN;
    }

    public double getAutoHigherSplitValue(IdentObj id) {
        if (id == null) {
            return Double.NaN;
        }
        if (this.m_X1Axis != null && id.equals(this.m_X1Axis.getAxisIdentObj())) {
            return this.m_X1Axis.getAutoHigherSplitValue();
        }
        if (this.m_Y1Axis != null && id.equals(this.m_Y1Axis.getAxisIdentObj())) {
            return this.m_Y1Axis.getAutoHigherSplitValue();
        }
        if (this.m_Y2Axis != null && id.equals(this.m_Y2Axis.getAxisIdentObj())) {
            return this.m_Y2Axis.getAutoHigherSplitValue();
        }
        return Double.NaN;
    }

    public int getMarkerSize(int s, int g) {
        return this.m_Perspective.getMarkerSize(s, g);
    }

    public MarkerTemplate getMarkerShape(IdentObj idMarkerSeries) {
        MarkerTemplate markerTemplate = this.m_Perspective.getMarkerTemplate(idMarkerSeries);
        return markerTemplate;
    }

    public double getQuantizedDataValue(int nSeries, int nGroup, DataItem item) {
        double fValue = this.getDataValue((int)nSeries, (int)nGroup, (DataItem)item).m_fValue;
        boolean bExact = this.m_Perspective.getExactColorByHeight();
        if (!bExact) {
            Vector dLabels = this.m_Y1Axis.getNumericLabelsAsDouble();
            int nLabels = dLabels.size();
            PfjAssert.pfjAssert(nLabels > 1);
            boolean bFound = false;
            int i = 1;
            while (i < nLabels && !bFound) {
                double fCurr;
                double fPrev = (Double)dLabels.elementAt(i - 1);
                double fMid = (fPrev + (fCurr = ((Double)dLabels.elementAt(i)).doubleValue())) / 2.0;
                if (fValue < fMid) {
                    fValue = fPrev;
                    bFound = true;
                }
                ++i;
            }
            if (!bFound) {
                fValue = (Double)dLabels.elementAt(nLabels - 1);
            }
        }
        return fValue;
    }

    public RelativeAxisObj getX1Axis() {
        return this.m_X1Axis;
    }

    public RelativeAxisObj getY1Axis() {
        return this.m_Y1Axis;
    }

    public RelativeAxisObj getY2Axis() {
        return this.m_Y2Axis;
    }

    public RelativeAxisObj getO1Axis() {
        return this.m_O1Axis;
    }

    public void init(Perspective perspective) {
        super.init(perspective);
        this.m_O1Axis = null;
        this.m_X1Axis = null;
        this.m_Y1Axis = null;
        this.m_Y2Axis = null;
        this.m_Z1Axis = null;
    }

    protected boolean isAxisAscending(int nSeries) {
        RelativeAxisObj axis = this.whichAxisForSeries(nSeries, DataItem.DI_GENERAL);
        return axis.isAscending();
    }

    public boolean isComboWithBar() {
        boolean bIsCombo = false;
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        while (sEnum.hasMoreElements() && !bIsCombo) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] == 1) {
                bIsCombo = true;
            }
            if (this.m_seriesTypes[s] != 2 || this.m_Perspective.getLineType(this.m_Perspective.getSeries(s)) != 3) continue;
            bIsCombo = true;
        }
        return bIsCombo;
    }

    public boolean isComboWithNonBar() {
        boolean bIsCombo = false;
        if (this.m_Perspective.getGraphType() == 96) {
            return false;
        }
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        while (sEnum.hasMoreElements() && !bIsCombo) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] == 1) continue;
            bIsCombo = true;
        }
        return bIsCombo;
    }

    public boolean isZoomingArmed() {
        boolean bEnabled = this.m_Perspective.getZoomList().isCurrentlyZoomed();
        return bEnabled;
    }

    protected int prevSeriesForAxis(int sCurrent, int axisCurrent) {
        SeriesEnumerator sEnum = this.m_sEnumReverseForPrev;
        int nPrevSeries = -2;
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int axis;
            int s = sEnum.nextSeries();
            if (s >= sCurrent || (axis = this.getAxisAssignment(s)) != axisCurrent) continue;
            nPrevSeries = s;
            break;
        }
        return nPrevSeries;
    }

    protected int prevSeriesForAxis(int sCurrent, int gCurrent, int axisCurrent, boolean bNegCurrent) {
        SeriesEnumerator sEnum = this.m_sEnumReverseForPrev;
        int nPrevSeries = -2;
        int nRiserCurrent = this.m_seriesTypes[sCurrent];
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int nRiserType;
            boolean bNegPrev;
            RelativeAxisObj axisObj;
            int axis;
            int s = sEnum.nextSeries();
            if (s >= sCurrent || (axis = this.getAxisAssignment(s)) != axisCurrent || !this.m_dataOK[s][gCurrent]) continue;
            switch (axis) {
                case 7: {
                    axisObj = this.m_X1Axis;
                    break;
                }
                case 0: {
                    axisObj = this.m_Y1Axis;
                    break;
                }
                case 1: {
                    axisObj = this.m_Y2Axis;
                    break;
                }
                case 2: {
                    axisObj = this.m_Y3Axis;
                    break;
                }
                case 3: {
                    axisObj = this.m_Y4Axis;
                    break;
                }
                case 4: {
                    axisObj = this.m_Y5Axis;
                    break;
                }
                case 8: {
                    axisObj = this.m_Z1Axis;
                    break;
                }
                default: {
                    throw new AssertionException("Invalid axis = " + axis);
                }
            }
            int zeroCoord = (int)axisObj.getValueCoord(0.0);
            boolean bl = bNegPrev = this.m_numYCoords[s][gCurrent] < zeroCoord;
            if (!bNegPrev && this.getDataValue((int)s, (int)gCurrent, (DataItem)DataItem.DI_GENERAL).m_fValue < 0.0) {
                bNegPrev = true;
            }
            if (bNegPrev != bNegCurrent || (nRiserType = this.m_seriesTypes[s]) != nRiserCurrent) continue;
            nPrevSeries = s;
            break;
        }
        return nPrevSeries;
    }

    protected int prevSeriesForAxis(int sCurrent, int gCurrent, RelativeAxisObj axisObjDesired, boolean bNegValue) {
        return this.prevSeriesForAxis(sCurrent, gCurrent, axisObjDesired.getAxisObjID(), bNegValue);
    }

    protected int prevSeriesForAxis(int sCurrent, RelativeAxisObj axisObjDesired) {
        return this.prevSeriesForAxis(sCurrent, axisObjDesired.getAxisObjID());
    }

    protected double processOneStackedValue(int s, int g, RelativeAxisObj yAxisObj, double fValue, SumObj sumObj) {
        int nRiser;
        boolean bY2;
        boolean bPos = fValue >= 0.0;
        double fNewSum = sumObj.getSum(bPos, bY2 = yAxisObj == this.m_Y2Axis, nRiser = this.m_seriesTypes[s]) + fValue;
        if (this.isIgnoredOffScale(yAxisObj, fNewSum)) {
            this.m_dataOK[s][g] = false;
        } else if (this.m_gt.isWaterfall() && nRiser != 1 || !this.m_gt.isWaterfall() && !this.m_Perspective.isMarkerTypeStacked(nRiser)) {
            this.m_numYCoords[s][g] = (int)yAxisObj.getValueCoord(fValue);
        } else {
            sumObj.setSum(bPos, bY2, nRiser, fNewSum);
            if (this.m_gt.isWaterfall() && s == 0) {
                sumObj.setSum(bPos ^ true, bY2, nRiser, fNewSum);
            }
            this.m_numYCoords[s][g] = (int)yAxisObj.getValueCoord(fNewSum);
        }
        return fNewSum;
    }

    public void releaseReferences() {
        if (this.m_O1Axis != null) {
            this.m_O1Axis.releaseReferences();
        }
        if (this.m_X1Axis != null) {
            this.m_X1Axis.releaseReferences();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.releaseReferences();
        }
        if (this.m_Y2Axis != null) {
            this.m_Y2Axis.releaseReferences();
        }
        if (this.m_Z1Axis != null) {
            this.m_Z1Axis.releaseReferences();
        }
        super.releaseReferences();
    }

    public boolean seriesAssignedToBothAxes() {
        boolean bAssignedToY1 = false;
        boolean bAssignedToOtherY = false;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            int assignedAxis = this.getAxisAssignment(s);
            if ((bAssignedToY1 |= assignedAxis == 0) && (bAssignedToOtherY |= assignedAxis != 0)) break;
        }
        return bAssignedToY1 && bAssignedToOtherY;
    }

    public void setNonDataLimits(MinMaxObj mm) {
    }

    protected RelativeAxisObj whichAxisForSeries(int s, DataItem item) {
        RelativeAxisObj axisObj;
        int axis = this.axisAssignedToSeries(s, item);
        switch (axis) {
            case 7: {
                if (this.m_Perspective.isContinuousTimeAxis() && (this.m_gt.isBLAType() || this.m_gt.isScatter() || this.m_gt.isBubble())) {
                    axisObj = this.m_O1Axis;
                    break;
                }
                axisObj = this.m_X1Axis;
                break;
            }
            case 0: {
                axisObj = this.m_Y1Axis;
                break;
            }
            case 1: {
                axisObj = this.m_Y2Axis;
                break;
            }
            case 2: {
                axisObj = this.m_Y3Axis;
                break;
            }
            case 3: {
                axisObj = this.m_Y4Axis;
                break;
            }
            case 4: {
                axisObj = this.m_Y5Axis;
                break;
            }
            case 8: {
                axisObj = this.m_Z1Axis;
                break;
            }
            default: {
                axisObj = null;
                break;
            }
        }
        return axisObj;
    }

    public int axisAssignedToSeries(int s, DataItem item) {
        int nAxis;
        if (this.m_gt.isMultiY()) {
            nAxis = this.getAxisAssignment(s);
        } else {
            nAxis = item == null ? 0 : item.getAssocAxis();
            if (nAxis == 0) {
                nAxis = this.getAxisAssignment(s);
            }
        }
        return nAxis;
    }

    protected int whichOrdType() {
        int nOrdType = 1;
        if (this.m_bExtendToFrameEdge && !this.m_bIsThisAComboWithBar) {
            nOrdType = 6;
        } else if (this.m_gt.isRiserBar()) {
            if (this.m_bAbsolute) {
                nOrdType = 0;
            } else if (this.m_bStacked && this.m_gt.isDualY() && !this.m_gt.isBipolar() && this.seriesAssignedToBothAxes()) {
                nOrdType = 3;
            }
        } else if (this.m_gt.isRiserArea() || this.m_gt.isRiserMarker()) {
            nOrdType = 2;
        } else if (this.m_gt.isParetoType()) {
            nOrdType = 10;
        }
        return nOrdType;
    }

    String ReplaceMacro(String SourceString, String aMacro, String Replacement) {
        int aPosition;
        String aProcessedString = "";
        aProcessedString = SourceString;
        while ((aPosition = aProcessedString.indexOf(aMacro)) != -1) {
            String testString = aProcessedString.substring(0, aPosition);
            testString = testString + Replacement;
            aProcessedString = testString = testString + aProcessedString.substring(aPosition += aMacro.length(), aProcessedString.length());
        }
        return aProcessedString;
    }

    protected abstract Point getCoords(int var1, int var2);

    protected abstract String processDataTextTemplate(String[] var1, String var2);

    protected double calcxPosition(Point startPt, Point endPt, double currentY) {
        double dx2 = endPt.x;
        double dx1 = startPt.x;
        double dy1 = startPt.y;
        double dy2 = endPt.y;
        double a1 = (dy1 - dy2) / (dx1 - dx2);
        double a0 = dy1 - dx1 * a1;
        double x11 = (currentY - a0) / a1;
        return x11;
    }

    protected double calcyPosition(Point startPt, Point endPt, double currentX) {
        double dx2 = endPt.x;
        double dx1 = startPt.x;
        double dy1 = startPt.y;
        double dy2 = endPt.y;
        double a1 = (dy1 - dy2) / (dx1 - dx2);
        double a0 = dy1 - dx1 * a1;
        double y11 = a1 * currentX + a0;
        return y11;
    }

    protected Point checkEndPointVertical(Point p, int s, int g, Point cPt) {
        Point pt2 = new Point();
        if (p.x != cPt.x) {
            pt2.y = cPt.y;
            pt2.x = p.x;
            return pt2;
        }
        return cPt;
    }

    protected void checkEndPointVert(Vector vt, Point p, int s, int g, Point cPt) {
        Point pt2 = new Point();
        LineDesc lDesc = (LineDesc)vt.lastElement();
        Point plast = lDesc.getPt();
        lDesc = new LineDesc();
        if (p.x != plast.x) {
            pt2.y = plast.y;
            pt2.x = p.x;
            lDesc.setLineDesc(pt2, s, g);
        } else {
            lDesc.setLineDesc(plast, s, g);
        }
        vt.add(lDesc);
    }

    protected void checkStartPointHoriz(Vector vt, Point p, int s, int g, Point cPt) {
        Point pt2 = new Point();
        LineDesc lDesc = new LineDesc();
        if (p.y != cPt.y) {
            lDesc = new LineDesc();
            pt2.y = p.y;
            pt2.x = cPt.x;
            lDesc.setLineDesc(pt2, s, g);
            vt.add(lDesc);
        }
    }

    protected Point checkStartPointHorizontal(Point p, int s, int g, Point cPt) {
        Point pt2 = new Point();
        if (p.y != cPt.y) {
            pt2.y = p.y;
            pt2.x = cPt.x;
            return pt2;
        }
        return cPt;
    }

    protected Point checkStartPointVertical(Point p, int s, int g, Point cPt) {
        Point pt2 = new Point();
        if (p.x != cPt.x) {
            pt2.y = cPt.y;
            pt2.x = p.x;
            return pt2;
        }
        return cPt;
    }

    protected Point checkEndPointHorizontal(Point p, int s, int g, Point cPt) {
        Point pt2 = new Point();
        if (p.y != cPt.y) {
            pt2.y = p.y;
            pt2.x = cPt.x;
            return pt2;
        }
        return cPt;
    }

    protected void checkStartPointVert(Vector vt, Point p, int s, int g, Point cPt) {
        Point pt2 = new Point();
        LineDesc lDesc = new LineDesc();
        if (p.x != cPt.x) {
            pt2.y = cPt.y;
            pt2.x = p.x;
            lDesc.setLineDesc(pt2, s, g);
        } else {
            lDesc.setLineDesc(cPt, s, g);
        }
        vt.add(lDesc);
    }

    protected void checkEndPointHoriz(Vector vt, Point p, int s, int g, Point cPt) {
        Point pt2 = new Point();
        LineDesc lDesc = (LineDesc)vt.lastElement();
        Point plast = lDesc.getPt();
        if (p.y != plast.y) {
            lDesc = new LineDesc();
            pt2.y = p.y;
            pt2.x = plast.x;
            lDesc.setLineDesc(pt2, s, g);
            vt.add(lDesc);
        }
    }

    static final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int ySize2;
            int xSize2;
            int area2;
            int ySize1;
            Object[] obj1 = (Object[])o1;
            Object[] obj2 = (Object[])o2;
            int xSize1 = (Integer)obj1[4];
            int area1 = xSize1 * (ySize1 = ((Integer)obj1[5]).intValue());
            if (area1 > (area2 = (xSize2 = ((Integer)obj2[4]).intValue()) * (ySize2 = ((Integer)obj2[5]).intValue()))) {
                return -1;
            }
            if (area1 == area2) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object obj) {
            return false;
        }
    }

    class SumObj {
        double[] m_sumPosY1;
        double[] m_sumPosY2;
        double[] m_sumNegY1;
        double[] m_sumNegY2;
        boolean m_bFirstSetIsPositive;
        boolean m_bFirstTime;

        private void $init$() {
            this.m_bFirstTime = true;
        }

        public SumObj() {
            this.$init$();
            this.m_sumPosY1 = new double[3];
            this.m_sumPosY2 = new double[3];
            this.m_sumNegY1 = new double[3];
            this.m_sumNegY2 = new double[3];
        }

        public double getSum(boolean bPositive, boolean bY2, int nRiserType) {
            int i;
            switch (nRiserType) {
                case 2: {
                    i = 1;
                    break;
                }
                case 3: {
                    i = 2;
                    break;
                }
                default: {
                    i = 0;
                    break;
                }
            }
            if (bPositive) {
                if (bY2) {
                    return this.m_sumPosY2[i];
                }
                return this.m_sumPosY1[i];
            }
            if (bY2) {
                return this.m_sumNegY2[i];
            }
            return this.m_sumNegY1[i];
        }

        public void setSum(boolean bPositive, boolean bY2, int nRiserType, double newValue) {
            switch (nRiserType) {
                case 2: {
                    int i = 1;
                    break;
                }
                case 3: {
                    int i = 2;
                    break;
                }
                default: {
                    int i = 0;
                    break;
                }
            }
            if (bPositive) {
                if (bY2) {
                    this.m_sumPosY2[i] = newValue;
                } else {
                    this.m_sumPosY1[i] = newValue;
                }
            } else if (bY2) {
                this.m_sumNegY2[i] = newValue;
            } else {
                this.m_sumNegY1[i] = newValue;
            }
            if (this.m_bFirstTime) {
                this.m_bFirstSetIsPositive = bPositive;
                this.m_bFirstTime = false;
            }
        }
    }

    class LineDesc {
        protected Point m_pt;
        protected int m_nSeries;
        protected int m_nGroup;

        private void $init$() {
            this.m_nSeries = 0;
            this.m_nGroup = 0;
        }

        public void LineDesc() {
            this.m_pt = null;
            this.m_nSeries = 0;
            this.m_nGroup = 0;
        }

        public void LineDesc(Point a, int s, int g) {
            this.m_pt = a;
            this.m_nSeries = s;
            this.m_nGroup = g;
        }

        public void setLineDesc(Point a, int s, int g) {
            this.m_pt = a;
            this.m_nSeries = s;
            this.m_nGroup = g;
        }

        public int getGroup() {
            return this.m_nGroup;
        }

        public int getSeries() {
            return this.m_nSeries;
        }

        public Point getPt() {
            return this.m_pt;
        }

        LineDesc() {
            this.$init$();
        }
    }
}

