/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.LegendObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.ZoomState;

public class LegendZoom
implements Serializable {
    protected Perspective m_Perspective;
    protected JChart_Base m_Chart;
    protected LegendObj m_Legend;

    public LegendZoom(Perspective perspective, JChart_Base chart, LegendObj legend) {
        this.m_Perspective = perspective;
        this.m_Chart = chart;
        this.m_Legend = legend;
    }

    public void doZoomIn(ZoomState zoomState, Rectangle rZoom) {
        Point ptBotLeft = new Point(rZoom.x, rZoom.y);
        int nNewBotLeftBoxNum = this.getLegendBoxNum(ptBotLeft);
        int nDiffY = rZoom.y > 0 ? rZoom.y - rZoom.height : rZoom.y + rZoom.height;
        Point ptTopLeft = new Point(rZoom.x, nDiffY);
        int nNewTopLeftBoxNum = this.getLegendBoxNum(ptTopLeft);
        Point ptTopRight = new Point(rZoom.x + rZoom.width, nDiffY);
        int nNewTopRightBoxNum = this.getLegendBoxNum(ptTopRight);
        Point ptBotRight = new Point(rZoom.x + rZoom.width, rZoom.y);
        int nNewBotRightBoxNum = this.getLegendBoxNum(ptBotRight);
        boolean nNumPrevRows = false;
    }

    int getLegendBoxNum(Point ptInLegend) {
        Rectangle rLegend = this.m_Perspective.getLegendRect();
        int nNumLegendCols = this.m_Legend.getNumOfCols();
        int nNumLegendRows = this.m_Legend.getNumOfRows(nNumLegendCols);
        int nDiffX = Math.abs(ptInLegend.x - rLegend.x);
        int nDiffY = rLegend.y > 0 ? Math.abs(rLegend.y - rLegend.height) : Math.abs(rLegend.y + rLegend.height);
        nDiffY = Math.abs(nDiffY - ptInLegend.y);
        int nCol = nDiffX / (rLegend.width / nNumLegendCols);
        int nRow = nDiffY / (rLegend.height / nNumLegendRows);
        int nBoxNum = nRow * nNumLegendCols;
        nBoxNum = nBoxNum + nCol + 1;
        return nBoxNum;
    }
}

