/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.MarkerTemplate;
import oracle.dss.graph.pfj.MarkerTemplateArray;
import oracle.dss.graph.pfj.ObjClassID;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.QSortPoly;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.ColorObj;
import oracle.dss.graph.pfj.draw.DetImage;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetOval;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.FillGradientObj;
import oracle.dss.graph.pfj.draw.IdentObj;

public class MarkerObj {
    protected IdentObj m_id;
    protected MarkerTemplate m_template;
    protected Point m_center;
    protected int m_markerSizeX;
    protected int m_markerSizeY;
    protected BlackBoxIF m_bb;
    protected Rectangle m_rClip;
    protected Detectiv m_Detectiv;
    protected Perspective m_Perspective;
    protected String m_szRefLabel;
    protected double m_nData;
    protected boolean m_threed;
    protected boolean m_bHiliteable;
    protected int m_nXDepth;
    protected int m_nYDepth;
    protected int m_nDepthAngle;

    private void $init$() {
        this.m_threed = false;
        this.m_bHiliteable = true;
        this.m_nXDepth = 0;
        this.m_nYDepth = 0;
        this.m_nDepthAngle = 0;
    }

    public MarkerObj(Detectiv a_Detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox, Rectangle rClip, boolean bLimitSize) {
        this(a_Detectiv, id, template, center, markerSizeX, markerSizeY, blackBox, rClip, bLimitSize, false, 0, 0, 0);
    }

    public MarkerObj(Detectiv a_Detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox, Rectangle rClip, boolean bLimitSize, boolean threed, int nXDepth, int nYDepth, int nDepthAngle) {
        this(a_Detectiv, id, template, center, markerSizeX, markerSizeY, blackBox, rClip, bLimitSize, threed, nXDepth, nYDepth, nDepthAngle, true);
    }

    public MarkerObj(Detectiv a_Detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox, Rectangle rClip, boolean bLimitSize, boolean threed, int nXDepth, int nYDepth, int nDepthAngle, boolean bHiliteable) {
        this.$init$();
        this.m_threed = threed;
        this.m_nXDepth = 300;
        this.m_nYDepth = 300;
        this.m_nDepthAngle = nDepthAngle;
        this.m_bHiliteable = bHiliteable;
        if (center == null) {
            center = new Point(0, 0);
        }
        if (template == MarkerTemplateArray.PRESET_BUBBLE) {
            if (markerSizeX < 0) {
                throw new AssertionException(0, Integer.MAX_VALUE, markerSizeX);
            }
            if (markerSizeY < 0) {
                throw new AssertionException(0, Integer.MAX_VALUE, markerSizeY);
            }
        } else {
            if (markerSizeX < 0 || bLimitSize && markerSizeX > 100) {
                throw new AssertionException(0, 100, markerSizeX);
            }
            if (markerSizeY < 0 || bLimitSize && markerSizeY > 100) {
                throw new AssertionException(0, 100, markerSizeY);
            }
        }
        this.m_id = id;
        this.m_template = template;
        this.m_center = center;
        this.m_markerSizeX = markerSizeX;
        this.m_markerSizeY = markerSizeY;
        this.m_bb = blackBox;
        this.m_rClip = rClip;
        this.m_Detectiv = a_Detectiv;
        this.m_Perspective = this.m_Detectiv.getPerspective();
        if (this.m_bb.getTransparentFillColor()) {
            if (ObjClassID.stripExceptionalOffset(this.m_id.getObjectID()) == 13 && this.m_Perspective.getSeriesVisibility(this.m_id.getSeriesID()) == 1) {
                this.m_bb.setTransparentBorderColor(false);
                if (!this.m_threed) {
                    this.m_bb.setBorderColor(this.m_Perspective.getDarker(this.m_bb.getFillColor()));
                } else {
                    this.m_bb.setBorderColor(this.m_bb.getFillColor());
                }
            } else {
                this.m_bb.setTransparentBorderColor(true);
            }
        }
        this.calc();
    }

    public MarkerObj(Detectiv a_Detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox) {
        this(a_Detectiv, id, template, center, markerSizeX, markerSizeY, blackBox, null, true);
    }

    public void calc() {
        switch (this.m_template.m_markerType) {
            case 0: {
                break;
            }
            case 1: {
                this.calcRect();
                break;
            }
            case 2: {
                this.calcOval();
                break;
            }
            case 9: {
                this.calcBubble();
                break;
            }
            case 4: 
            case 10: {
                this.calcLine();
                break;
            }
            case 3: {
                this.calcDiamond();
                break;
            }
            case 5: {
                this.calcPlus();
                break;
            }
            case 6: {
                this.calcTriangleDn();
                break;
            }
            case 7: {
                this.calcTriangleUp();
                break;
            }
            case 8: {
                this.calcDrillUp();
                break;
            }
            default: {
                throw new AssertionException("MarkerObj - unknown markerType = " + this.m_template.m_markerType);
            }
        }
    }

    public void calcBubble() {
        int minWidth;
        int height;
        Polygon scaledPolygon = new Polygon();
        VC vc = this.m_Perspective.getVC();
        int width = vc.virtToDestWidth(this.m_markerSizeX);
        if (width < (height = vc.virtToDestHeight(this.m_markerSizeY))) {
            width = height;
        }
        if (width < (minWidth = 3)) {
            width = minWidth;
        }
        height = width;
        this._calcOval(height, width, scaledPolygon, vc);
    }

    public void calcOval() {
        int height;
        Polygon scaledPolygon = new Polygon();
        VC vc = this.m_Perspective.getVC();
        int width = vc.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (width < (height = vc.virtToDestHeight(this.m_template.m_rect.height * this.m_markerSizeY / 100))) {
            width = height;
        }
        if (!this.m_Perspective.getJGraphType().isBubble()) {
            if (width < 5) {
                width = 5;
            }
            if (width % 2 == 0) {
                ++width;
            }
        } else if (width < 3) {
            width = 3;
        }
        height = width;
        this._calcOval(height, width, scaledPolygon, vc);
    }

    private void _calcOval(int height, int width, Polygon scaledPolygon, VC vc) {
        int cx = vc.virtToDestX(this.m_center.x);
        int cy = vc.virtToDestY(this.m_center.y);
        int x = cx - height / 2;
        int y = cy - height / 2;
        Rectangle scaledRect = new Rectangle(x, y, width - 1, height - 1);
        switch (height) {
            case 3: {
                scaledPolygon.addPoint(x + 1, y);
                scaledPolygon.addPoint(x + 2, y + 1);
                scaledPolygon.addPoint(x + 1, y + 2);
                scaledPolygon.addPoint(x, y + 1);
                scaledPolygon.addPoint(x + 1, y);
                break;
            }
            case 4: {
                scaledPolygon.addPoint(x + 1, y);
                scaledPolygon.addPoint(x + 2, y);
                scaledPolygon.addPoint(x + 3, y + 1);
                scaledPolygon.addPoint(x + 3, y + 2);
                scaledPolygon.addPoint(x + 2, y + 3);
                scaledPolygon.addPoint(x + 1, y + 3);
                scaledPolygon.addPoint(x, y + 2);
                scaledPolygon.addPoint(x, y + 1);
                scaledPolygon.addPoint(x + 1, y);
                break;
            }
            case 5: {
                scaledPolygon.addPoint(x + 1, y);
                scaledPolygon.addPoint(x + 3, y);
                scaledPolygon.addPoint(x + 4, y + 1);
                scaledPolygon.addPoint(x + 4, y + 3);
                scaledPolygon.addPoint(x + 3, y + 4);
                scaledPolygon.addPoint(x + 1, y + 4);
                scaledPolygon.addPoint(x, y + 3);
                scaledPolygon.addPoint(x, y + 1);
                scaledPolygon.addPoint(x + 1, y);
                break;
            }
            case 6: {
                scaledPolygon.addPoint(x + 2, y);
                scaledPolygon.addPoint(x + 3, y);
                scaledPolygon.addPoint(x + 4, y + 1);
                scaledPolygon.addPoint(x + 5, y + 2);
                scaledPolygon.addPoint(x + 5, y + 3);
                scaledPolygon.addPoint(x + 4, y + 4);
                scaledPolygon.addPoint(x + 3, y + 5);
                scaledPolygon.addPoint(x + 2, y + 5);
                scaledPolygon.addPoint(x + 1, y + 4);
                scaledPolygon.addPoint(x, y + 3);
                scaledPolygon.addPoint(x, y + 2);
                scaledPolygon.addPoint(x + 1, y + 1);
                scaledPolygon.addPoint(x + 2, y);
                break;
            }
            case 7: {
                scaledPolygon.addPoint(x + 2, y);
                scaledPolygon.addPoint(x + 4, y);
                scaledPolygon.addPoint(x + 5, y + 1);
                scaledPolygon.addPoint(x + 6, y + 2);
                scaledPolygon.addPoint(x + 6, y + 4);
                scaledPolygon.addPoint(x + 5, y + 5);
                scaledPolygon.addPoint(x + 4, y + 6);
                scaledPolygon.addPoint(x + 2, y + 6);
                scaledPolygon.addPoint(x + 1, y + 5);
                scaledPolygon.addPoint(x, y + 4);
                scaledPolygon.addPoint(x, y + 2);
                scaledPolygon.addPoint(x + 1, y + 1);
                scaledPolygon.addPoint(x + 2, y);
                break;
            }
            case 8: {
                scaledPolygon.addPoint(x + 3, y);
                scaledPolygon.addPoint(x + 4, y);
                scaledPolygon.addPoint(x + 5, y + 1);
                scaledPolygon.addPoint(x + 6, y + 1);
                scaledPolygon.addPoint(x + 6, y + 2);
                scaledPolygon.addPoint(x + 7, y + 3);
                scaledPolygon.addPoint(x + 7, y + 4);
                scaledPolygon.addPoint(x + 6, y + 5);
                scaledPolygon.addPoint(x + 6, y + 6);
                scaledPolygon.addPoint(x + 5, y + 6);
                scaledPolygon.addPoint(x + 4, y + 7);
                scaledPolygon.addPoint(x + 3, y + 7);
                scaledPolygon.addPoint(x + 2, y + 6);
                scaledPolygon.addPoint(x + 1, y + 6);
                scaledPolygon.addPoint(x + 1, y + 5);
                scaledPolygon.addPoint(x, y + 4);
                scaledPolygon.addPoint(x, y + 3);
                scaledPolygon.addPoint(x + 1, y + 2);
                scaledPolygon.addPoint(x + 1, y + 1);
                scaledPolygon.addPoint(x + 2, y + 1);
                scaledPolygon.addPoint(x + 3, y);
                break;
            }
            case 9: {
                scaledPolygon.addPoint(x + 3, y);
                scaledPolygon.addPoint(x + 5, y);
                scaledPolygon.addPoint(x + 6, y + 1);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 7, y + 2);
                scaledPolygon.addPoint(x + 8, y + 3);
                scaledPolygon.addPoint(x + 8, y + 5);
                scaledPolygon.addPoint(x + 7, y + 6);
                scaledPolygon.addPoint(x + 7, y + 7);
                scaledPolygon.addPoint(x + 6, y + 7);
                scaledPolygon.addPoint(x + 5, y + 8);
                scaledPolygon.addPoint(x + 3, y + 8);
                scaledPolygon.addPoint(x + 2, y + 7);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x + 1, y + 6);
                scaledPolygon.addPoint(x, y + 5);
                scaledPolygon.addPoint(x, y + 3);
                scaledPolygon.addPoint(x + 1, y + 2);
                scaledPolygon.addPoint(x + 1, y + 1);
                scaledPolygon.addPoint(x + 2, y + 1);
                scaledPolygon.addPoint(x + 3, y);
                break;
            }
            case 10: {
                scaledPolygon.addPoint(x + 4, y);
                scaledPolygon.addPoint(x + 5, y);
                scaledPolygon.addPoint(x + 6, y + 1);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 8, y + 2);
                scaledPolygon.addPoint(x + 8, y + 3);
                scaledPolygon.addPoint(x + 9, y + 4);
                scaledPolygon.addPoint(x + 9, y + 5);
                scaledPolygon.addPoint(x + 8, y + 6);
                scaledPolygon.addPoint(x + 8, y + 7);
                scaledPolygon.addPoint(x + 7, y + 8);
                scaledPolygon.addPoint(x + 6, y + 8);
                scaledPolygon.addPoint(x + 5, y + 9);
                scaledPolygon.addPoint(x + 4, y + 9);
                scaledPolygon.addPoint(x + 3, y + 8);
                scaledPolygon.addPoint(x + 2, y + 8);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x + 1, y + 6);
                scaledPolygon.addPoint(x, y + 5);
                scaledPolygon.addPoint(x, y + 4);
                scaledPolygon.addPoint(x + 1, y + 3);
                scaledPolygon.addPoint(x + 1, y + 2);
                scaledPolygon.addPoint(x + 2, y + 1);
                scaledPolygon.addPoint(x + 3, y + 1);
                scaledPolygon.addPoint(x + 4, y);
                break;
            }
            case 11: {
                scaledPolygon.addPoint(x + 4, y);
                scaledPolygon.addPoint(x + 6, y);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 8, y + 1);
                scaledPolygon.addPoint(x + 9, y + 2);
                scaledPolygon.addPoint(x + 9, y + 3);
                scaledPolygon.addPoint(x + 10, y + 4);
                scaledPolygon.addPoint(x + 10, y + 6);
                scaledPolygon.addPoint(x + 9, y + 7);
                scaledPolygon.addPoint(x + 9, y + 8);
                scaledPolygon.addPoint(x + 8, y + 9);
                scaledPolygon.addPoint(x + 7, y + 9);
                scaledPolygon.addPoint(x + 6, y + 10);
                scaledPolygon.addPoint(x + 4, y + 10);
                scaledPolygon.addPoint(x + 3, y + 9);
                scaledPolygon.addPoint(x + 2, y + 9);
                scaledPolygon.addPoint(x + 1, y + 8);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x, y + 6);
                scaledPolygon.addPoint(x, y + 4);
                scaledPolygon.addPoint(x + 1, y + 3);
                scaledPolygon.addPoint(x + 1, y + 2);
                scaledPolygon.addPoint(x + 2, y + 1);
                scaledPolygon.addPoint(x + 3, y + 1);
                scaledPolygon.addPoint(x + 4, y);
                break;
            }
            case 12: {
                scaledPolygon.addPoint(x + 5, y);
                scaledPolygon.addPoint(x + 6, y);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 9, y + 1);
                scaledPolygon.addPoint(x + 10, y + 2);
                scaledPolygon.addPoint(x + 10, y + 4);
                scaledPolygon.addPoint(x + 11, y + 5);
                scaledPolygon.addPoint(x + 11, y + 6);
                scaledPolygon.addPoint(x + 10, y + 7);
                scaledPolygon.addPoint(x + 10, y + 9);
                scaledPolygon.addPoint(x + 9, y + 10);
                scaledPolygon.addPoint(x + 7, y + 10);
                scaledPolygon.addPoint(x + 6, y + 11);
                scaledPolygon.addPoint(x + 5, y + 11);
                scaledPolygon.addPoint(x + 4, y + 10);
                scaledPolygon.addPoint(x + 2, y + 10);
                scaledPolygon.addPoint(x + 1, y + 9);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x, y + 6);
                scaledPolygon.addPoint(x, y + 5);
                scaledPolygon.addPoint(x + 1, y + 4);
                scaledPolygon.addPoint(x + 1, y + 2);
                scaledPolygon.addPoint(x + 2, y + 1);
                scaledPolygon.addPoint(x + 4, y + 1);
                scaledPolygon.addPoint(x + 5, y);
                break;
            }
            case 13: {
                scaledPolygon.addPoint(x + 5, y);
                scaledPolygon.addPoint(x + 7, y);
                scaledPolygon.addPoint(x + 8, y + 1);
                scaledPolygon.addPoint(x + 9, y + 1);
                scaledPolygon.addPoint(x + 10, y + 2);
                scaledPolygon.addPoint(x + 11, y + 3);
                scaledPolygon.addPoint(x + 11, y + 4);
                scaledPolygon.addPoint(x + 12, y + 5);
                scaledPolygon.addPoint(x + 12, y + 7);
                scaledPolygon.addPoint(x + 11, y + 8);
                scaledPolygon.addPoint(x + 11, y + 9);
                scaledPolygon.addPoint(x + 10, y + 10);
                scaledPolygon.addPoint(x + 9, y + 11);
                scaledPolygon.addPoint(x + 8, y + 11);
                scaledPolygon.addPoint(x + 7, y + 12);
                scaledPolygon.addPoint(x + 5, y + 12);
                scaledPolygon.addPoint(x + 4, y + 11);
                scaledPolygon.addPoint(x + 3, y + 11);
                scaledPolygon.addPoint(x + 2, y + 10);
                scaledPolygon.addPoint(x + 1, y + 9);
                scaledPolygon.addPoint(x + 1, y + 8);
                scaledPolygon.addPoint(x, y + 7);
                scaledPolygon.addPoint(x, y + 5);
                scaledPolygon.addPoint(x + 1, y + 4);
                scaledPolygon.addPoint(x + 1, y + 3);
                scaledPolygon.addPoint(x + 2, y + 2);
                scaledPolygon.addPoint(x + 3, y + 1);
                scaledPolygon.addPoint(x + 4, y + 1);
                scaledPolygon.addPoint(x + 5, y);
                break;
            }
            case 14: {
                scaledPolygon.addPoint(x + 4, y);
                scaledPolygon.addPoint(x + 9, y);
                scaledPolygon.addPoint(x + 10, y + 1);
                scaledPolygon.addPoint(x + 11, y + 2);
                scaledPolygon.addPoint(x + 12, y + 3);
                scaledPolygon.addPoint(x + 12, y + 4);
                scaledPolygon.addPoint(x + 13, y + 5);
                scaledPolygon.addPoint(x + 13, y + 8);
                scaledPolygon.addPoint(x + 12, y + 9);
                scaledPolygon.addPoint(x + 12, y + 10);
                scaledPolygon.addPoint(x + 11, y + 11);
                scaledPolygon.addPoint(x + 10, y + 12);
                scaledPolygon.addPoint(x + 9, y + 13);
                scaledPolygon.addPoint(x + 4, y + 13);
                scaledPolygon.addPoint(x + 3, y + 12);
                scaledPolygon.addPoint(x + 2, y + 11);
                scaledPolygon.addPoint(x + 1, y + 10);
                scaledPolygon.addPoint(x, y + 9);
                scaledPolygon.addPoint(x, y + 4);
                scaledPolygon.addPoint(x + 1, y + 3);
                scaledPolygon.addPoint(x + 2, y + 2);
                scaledPolygon.addPoint(x + 3, y + 1);
                scaledPolygon.addPoint(x + 4, y);
                break;
            }
            case 15: {
                scaledPolygon.addPoint(x + 5, y);
                scaledPolygon.addPoint(x + 9, y);
                scaledPolygon.addPoint(x + 10, y + 1);
                scaledPolygon.addPoint(x + 11, y + 1);
                scaledPolygon.addPoint(x + 12, y + 2);
                scaledPolygon.addPoint(x + 13, y + 3);
                scaledPolygon.addPoint(x + 13, y + 4);
                scaledPolygon.addPoint(x + 14, y + 5);
                scaledPolygon.addPoint(x + 14, y + 9);
                scaledPolygon.addPoint(x + 13, y + 10);
                scaledPolygon.addPoint(x + 13, y + 11);
                scaledPolygon.addPoint(x + 12, y + 12);
                scaledPolygon.addPoint(x + 11, y + 13);
                scaledPolygon.addPoint(x + 10, y + 13);
                scaledPolygon.addPoint(x + 9, y + 14);
                scaledPolygon.addPoint(x + 5, y + 14);
                scaledPolygon.addPoint(x + 4, y + 13);
                scaledPolygon.addPoint(x + 3, y + 13);
                scaledPolygon.addPoint(x + 2, y + 12);
                scaledPolygon.addPoint(x + 1, y + 11);
                scaledPolygon.addPoint(x + 1, y + 10);
                scaledPolygon.addPoint(x, y + 9);
                scaledPolygon.addPoint(x, y + 5);
                scaledPolygon.addPoint(x + 1, y + 4);
                scaledPolygon.addPoint(x + 1, y + 3);
                scaledPolygon.addPoint(x + 2, y + 2);
                scaledPolygon.addPoint(x + 3, y + 1);
                scaledPolygon.addPoint(x + 4, y + 1);
                scaledPolygon.addPoint(x + 5, y);
                break;
            }
            case 16: {
                scaledPolygon.addPoint(x + 5, y);
                scaledPolygon.addPoint(x + 10, y);
                scaledPolygon.addPoint(x + 11, y + 1);
                scaledPolygon.addPoint(x + 12, y + 2);
                scaledPolygon.addPoint(x + 13, y + 2);
                scaledPolygon.addPoint(x + 13, y + 3);
                scaledPolygon.addPoint(x + 14, y + 4);
                scaledPolygon.addPoint(x + 15, y + 5);
                scaledPolygon.addPoint(x + 15, y + 10);
                scaledPolygon.addPoint(x + 14, y + 11);
                scaledPolygon.addPoint(x + 13, y + 12);
                scaledPolygon.addPoint(x + 13, y + 13);
                scaledPolygon.addPoint(x + 12, y + 13);
                scaledPolygon.addPoint(x + 11, y + 14);
                scaledPolygon.addPoint(x + 10, y + 15);
                scaledPolygon.addPoint(x + 5, y + 15);
                scaledPolygon.addPoint(x + 4, y + 14);
                scaledPolygon.addPoint(x + 3, y + 13);
                scaledPolygon.addPoint(x + 2, y + 13);
                scaledPolygon.addPoint(x + 2, y + 12);
                scaledPolygon.addPoint(x + 1, y + 11);
                scaledPolygon.addPoint(x, y + 10);
                scaledPolygon.addPoint(x, y + 5);
                scaledPolygon.addPoint(x + 1, y + 4);
                scaledPolygon.addPoint(x + 2, y + 3);
                scaledPolygon.addPoint(x + 2, y + 2);
                scaledPolygon.addPoint(x + 3, y + 2);
                scaledPolygon.addPoint(x + 4, y + 1);
                scaledPolygon.addPoint(x + 5, y);
                break;
            }
            case 17: {
                scaledPolygon.addPoint(x + 6, y);
                scaledPolygon.addPoint(x + 10, y);
                scaledPolygon.addPoint(x + 11, y + 1);
                scaledPolygon.addPoint(x + 12, y + 1);
                scaledPolygon.addPoint(x + 13, y + 2);
                scaledPolygon.addPoint(x + 14, y + 3);
                scaledPolygon.addPoint(x + 15, y + 4);
                scaledPolygon.addPoint(x + 15, y + 5);
                scaledPolygon.addPoint(x + 16, y + 6);
                scaledPolygon.addPoint(x + 16, y + 10);
                scaledPolygon.addPoint(x + 15, y + 11);
                scaledPolygon.addPoint(x + 15, y + 12);
                scaledPolygon.addPoint(x + 14, y + 13);
                scaledPolygon.addPoint(x + 13, y + 14);
                scaledPolygon.addPoint(x + 12, y + 15);
                scaledPolygon.addPoint(x + 11, y + 15);
                scaledPolygon.addPoint(x + 10, y + 16);
                scaledPolygon.addPoint(x + 6, y + 16);
                scaledPolygon.addPoint(x + 5, y + 15);
                scaledPolygon.addPoint(x + 4, y + 15);
                scaledPolygon.addPoint(x + 3, y + 14);
                scaledPolygon.addPoint(x + 2, y + 13);
                scaledPolygon.addPoint(x + 1, y + 12);
                scaledPolygon.addPoint(x + 1, y + 11);
                scaledPolygon.addPoint(x, y + 10);
                scaledPolygon.addPoint(x, y + 6);
                scaledPolygon.addPoint(x + 1, y + 5);
                scaledPolygon.addPoint(x + 1, y + 4);
                scaledPolygon.addPoint(x + 2, y + 3);
                scaledPolygon.addPoint(x + 3, y + 2);
                scaledPolygon.addPoint(x + 4, y + 1);
                scaledPolygon.addPoint(x + 5, y + 1);
                scaledPolygon.addPoint(x + 6, y);
                break;
            }
            case 18: {
                scaledPolygon.addPoint(x + 7, y);
                scaledPolygon.addPoint(x + 10, y);
                scaledPolygon.addPoint(x + 11, y + 1);
                scaledPolygon.addPoint(x + 13, y + 1);
                scaledPolygon.addPoint(x + 14, y + 2);
                scaledPolygon.addPoint(x + 15, y + 3);
                scaledPolygon.addPoint(x + 16, y + 4);
                scaledPolygon.addPoint(x + 16, y + 6);
                scaledPolygon.addPoint(x + 17, y + 7);
                scaledPolygon.addPoint(x + 17, y + 10);
                scaledPolygon.addPoint(x + 16, y + 11);
                scaledPolygon.addPoint(x + 16, y + 13);
                scaledPolygon.addPoint(x + 15, y + 14);
                scaledPolygon.addPoint(x + 14, y + 15);
                scaledPolygon.addPoint(x + 13, y + 16);
                scaledPolygon.addPoint(x + 11, y + 16);
                scaledPolygon.addPoint(x + 10, y + 17);
                scaledPolygon.addPoint(x + 7, y + 17);
                scaledPolygon.addPoint(x + 6, y + 16);
                scaledPolygon.addPoint(x + 4, y + 16);
                scaledPolygon.addPoint(x + 3, y + 15);
                scaledPolygon.addPoint(x + 2, y + 14);
                scaledPolygon.addPoint(x + 1, y + 13);
                scaledPolygon.addPoint(x + 1, y + 11);
                scaledPolygon.addPoint(x, y + 10);
                scaledPolygon.addPoint(x, y + 7);
                scaledPolygon.addPoint(x + 1, y + 6);
                scaledPolygon.addPoint(x + 1, y + 4);
                scaledPolygon.addPoint(x + 2, y + 3);
                scaledPolygon.addPoint(x + 3, y + 2);
                scaledPolygon.addPoint(x + 4, y + 1);
                scaledPolygon.addPoint(x + 6, y + 1);
                scaledPolygon.addPoint(x + 7, y);
                break;
            }
            case 19: {
                scaledPolygon.addPoint(x + 7, y);
                scaledPolygon.addPoint(x + 11, y);
                scaledPolygon.addPoint(x + 12, y + 1);
                scaledPolygon.addPoint(x + 13, y + 1);
                scaledPolygon.addPoint(x + 14, y + 2);
                scaledPolygon.addPoint(x + 15, y + 2);
                scaledPolygon.addPoint(x + 16, y + 3);
                scaledPolygon.addPoint(x + 16, y + 4);
                scaledPolygon.addPoint(x + 17, y + 5);
                scaledPolygon.addPoint(x + 17, y + 6);
                scaledPolygon.addPoint(x + 18, y + 7);
                scaledPolygon.addPoint(x + 18, y + 11);
                scaledPolygon.addPoint(x + 17, y + 12);
                scaledPolygon.addPoint(x + 17, y + 13);
                scaledPolygon.addPoint(x + 16, y + 14);
                scaledPolygon.addPoint(x + 16, y + 15);
                scaledPolygon.addPoint(x + 15, y + 16);
                scaledPolygon.addPoint(x + 14, y + 16);
                scaledPolygon.addPoint(x + 13, y + 17);
                scaledPolygon.addPoint(x + 12, y + 17);
                scaledPolygon.addPoint(x + 11, y + 18);
                scaledPolygon.addPoint(x + 7, y + 18);
                scaledPolygon.addPoint(x + 6, y + 17);
                scaledPolygon.addPoint(x + 5, y + 17);
                scaledPolygon.addPoint(x + 4, y + 16);
                scaledPolygon.addPoint(x + 3, y + 16);
                scaledPolygon.addPoint(x + 2, y + 15);
                scaledPolygon.addPoint(x + 2, y + 14);
                scaledPolygon.addPoint(x + 1, y + 13);
                scaledPolygon.addPoint(x + 1, y + 12);
                scaledPolygon.addPoint(x, y + 11);
                scaledPolygon.addPoint(x, y + 7);
                scaledPolygon.addPoint(x + 1, y + 6);
                scaledPolygon.addPoint(x + 1, y + 5);
                scaledPolygon.addPoint(x + 2, y + 4);
                scaledPolygon.addPoint(x + 2, y + 3);
                scaledPolygon.addPoint(x + 3, y + 2);
                scaledPolygon.addPoint(x + 4, y + 2);
                scaledPolygon.addPoint(x + 5, y + 1);
                scaledPolygon.addPoint(x + 6, y + 1);
                scaledPolygon.addPoint(x + 7, y);
                break;
            }
            case 20: {
                scaledPolygon.addPoint(x + 8, y);
                scaledPolygon.addPoint(x + 11, y);
                scaledPolygon.addPoint(x + 12, y + 1);
                scaledPolygon.addPoint(x + 14, y + 1);
                scaledPolygon.addPoint(x + 15, y + 2);
                scaledPolygon.addPoint(x + 16, y + 3);
                scaledPolygon.addPoint(x + 17, y + 4);
                scaledPolygon.addPoint(x + 18, y + 5);
                scaledPolygon.addPoint(x + 18, y + 7);
                scaledPolygon.addPoint(x + 19, y + 8);
                scaledPolygon.addPoint(x + 19, y + 11);
                scaledPolygon.addPoint(x + 18, y + 12);
                scaledPolygon.addPoint(x + 18, y + 14);
                scaledPolygon.addPoint(x + 17, y + 15);
                scaledPolygon.addPoint(x + 16, y + 16);
                scaledPolygon.addPoint(x + 15, y + 17);
                scaledPolygon.addPoint(x + 14, y + 18);
                scaledPolygon.addPoint(x + 12, y + 18);
                scaledPolygon.addPoint(x + 11, y + 19);
                scaledPolygon.addPoint(x + 8, y + 19);
                scaledPolygon.addPoint(x + 7, y + 18);
                scaledPolygon.addPoint(x + 5, y + 18);
                scaledPolygon.addPoint(x + 4, y + 17);
                scaledPolygon.addPoint(x + 3, y + 16);
                scaledPolygon.addPoint(x + 2, y + 15);
                scaledPolygon.addPoint(x + 1, y + 14);
                scaledPolygon.addPoint(x + 1, y + 12);
                scaledPolygon.addPoint(x, y + 11);
                scaledPolygon.addPoint(x, y + 8);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x + 1, y + 5);
                scaledPolygon.addPoint(x + 2, y + 4);
                scaledPolygon.addPoint(x + 3, y + 3);
                scaledPolygon.addPoint(x + 4, y + 2);
                scaledPolygon.addPoint(x + 5, y + 1);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 8, y);
                break;
            }
            case 21: {
                scaledPolygon.addPoint(x + 8, y);
                scaledPolygon.addPoint(x + 12, y);
                scaledPolygon.addPoint(x + 13, y + 1);
                scaledPolygon.addPoint(x + 14, y + 1);
                scaledPolygon.addPoint(x + 15, y + 2);
                scaledPolygon.addPoint(x + 16, y + 2);
                scaledPolygon.addPoint(x + 17, y + 3);
                scaledPolygon.addPoint(x + 18, y + 4);
                scaledPolygon.addPoint(x + 18, y + 5);
                scaledPolygon.addPoint(x + 19, y + 6);
                scaledPolygon.addPoint(x + 19, y + 7);
                scaledPolygon.addPoint(x + 20, y + 8);
                scaledPolygon.addPoint(x + 20, y + 12);
                scaledPolygon.addPoint(x + 19, y + 13);
                scaledPolygon.addPoint(x + 19, y + 14);
                scaledPolygon.addPoint(x + 18, y + 15);
                scaledPolygon.addPoint(x + 18, y + 16);
                scaledPolygon.addPoint(x + 17, y + 17);
                scaledPolygon.addPoint(x + 16, y + 18);
                scaledPolygon.addPoint(x + 15, y + 18);
                scaledPolygon.addPoint(x + 14, y + 19);
                scaledPolygon.addPoint(x + 13, y + 19);
                scaledPolygon.addPoint(x + 12, y + 20);
                scaledPolygon.addPoint(x + 8, y + 20);
                scaledPolygon.addPoint(x + 7, y + 19);
                scaledPolygon.addPoint(x + 6, y + 19);
                scaledPolygon.addPoint(x + 5, y + 18);
                scaledPolygon.addPoint(x + 4, y + 18);
                scaledPolygon.addPoint(x + 3, y + 17);
                scaledPolygon.addPoint(x + 2, y + 16);
                scaledPolygon.addPoint(x + 2, y + 15);
                scaledPolygon.addPoint(x + 1, y + 14);
                scaledPolygon.addPoint(x + 1, y + 13);
                scaledPolygon.addPoint(x, y + 12);
                scaledPolygon.addPoint(x, y + 8);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x + 1, y + 6);
                scaledPolygon.addPoint(x + 2, y + 5);
                scaledPolygon.addPoint(x + 2, y + 4);
                scaledPolygon.addPoint(x + 3, y + 3);
                scaledPolygon.addPoint(x + 4, y + 2);
                scaledPolygon.addPoint(x + 5, y + 2);
                scaledPolygon.addPoint(x + 6, y + 1);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 8, y);
                break;
            }
            case 22: {
                scaledPolygon.addPoint(x + 8, y);
                scaledPolygon.addPoint(x + 13, y);
                scaledPolygon.addPoint(x + 14, y + 1);
                scaledPolygon.addPoint(x + 15, y + 1);
                scaledPolygon.addPoint(x + 16, y + 2);
                scaledPolygon.addPoint(x + 17, y + 2);
                scaledPolygon.addPoint(x + 18, y + 3);
                scaledPolygon.addPoint(x + 19, y + 4);
                scaledPolygon.addPoint(x + 19, y + 5);
                scaledPolygon.addPoint(x + 20, y + 6);
                scaledPolygon.addPoint(x + 20, y + 8);
                scaledPolygon.addPoint(x + 21, y + 9);
                scaledPolygon.addPoint(x + 21, y + 12);
                scaledPolygon.addPoint(x + 20, y + 13);
                scaledPolygon.addPoint(x + 20, y + 15);
                scaledPolygon.addPoint(x + 19, y + 16);
                scaledPolygon.addPoint(x + 19, y + 17);
                scaledPolygon.addPoint(x + 18, y + 18);
                scaledPolygon.addPoint(x + 17, y + 19);
                scaledPolygon.addPoint(x + 16, y + 19);
                scaledPolygon.addPoint(x + 15, y + 20);
                scaledPolygon.addPoint(x + 13, y + 20);
                scaledPolygon.addPoint(x + 12, y + 21);
                scaledPolygon.addPoint(x + 9, y + 21);
                scaledPolygon.addPoint(x + 8, y + 20);
                scaledPolygon.addPoint(x + 6, y + 20);
                scaledPolygon.addPoint(x + 5, y + 19);
                scaledPolygon.addPoint(x + 4, y + 19);
                scaledPolygon.addPoint(x + 3, y + 18);
                scaledPolygon.addPoint(x + 2, y + 17);
                scaledPolygon.addPoint(x + 2, y + 16);
                scaledPolygon.addPoint(x + 1, y + 15);
                scaledPolygon.addPoint(x + 1, y + 14);
                scaledPolygon.addPoint(x, y + 13);
                scaledPolygon.addPoint(x, y + 8);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x + 1, y + 6);
                scaledPolygon.addPoint(x + 2, y + 5);
                scaledPolygon.addPoint(x + 2, y + 4);
                scaledPolygon.addPoint(x + 3, y + 3);
                scaledPolygon.addPoint(x + 4, y + 2);
                scaledPolygon.addPoint(x + 5, y + 2);
                scaledPolygon.addPoint(x + 6, y + 1);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 8, y);
                break;
            }
            case 23: {
                scaledPolygon.addPoint(x + 9, y);
                scaledPolygon.addPoint(x + 13, y);
                scaledPolygon.addPoint(x + 14, y + 1);
                scaledPolygon.addPoint(x + 16, y + 1);
                scaledPolygon.addPoint(x + 17, y + 2);
                scaledPolygon.addPoint(x + 18, y + 3);
                scaledPolygon.addPoint(x + 19, y + 3);
                scaledPolygon.addPoint(x + 19, y + 4);
                scaledPolygon.addPoint(x + 20, y + 5);
                scaledPolygon.addPoint(x + 21, y + 6);
                scaledPolygon.addPoint(x + 21, y + 8);
                scaledPolygon.addPoint(x + 22, y + 9);
                scaledPolygon.addPoint(x + 22, y + 13);
                scaledPolygon.addPoint(x + 21, y + 14);
                scaledPolygon.addPoint(x + 21, y + 16);
                scaledPolygon.addPoint(x + 20, y + 17);
                scaledPolygon.addPoint(x + 19, y + 18);
                scaledPolygon.addPoint(x + 19, y + 19);
                scaledPolygon.addPoint(x + 18, y + 19);
                scaledPolygon.addPoint(x + 17, y + 20);
                scaledPolygon.addPoint(x + 16, y + 21);
                scaledPolygon.addPoint(x + 14, y + 21);
                scaledPolygon.addPoint(x + 13, y + 22);
                scaledPolygon.addPoint(x + 9, y + 22);
                scaledPolygon.addPoint(x + 8, y + 21);
                scaledPolygon.addPoint(x + 6, y + 21);
                scaledPolygon.addPoint(x + 5, y + 20);
                scaledPolygon.addPoint(x + 4, y + 19);
                scaledPolygon.addPoint(x + 3, y + 19);
                scaledPolygon.addPoint(x + 3, y + 18);
                scaledPolygon.addPoint(x + 2, y + 17);
                scaledPolygon.addPoint(x + 1, y + 16);
                scaledPolygon.addPoint(x + 1, y + 14);
                scaledPolygon.addPoint(x, y + 13);
                scaledPolygon.addPoint(x, y + 9);
                scaledPolygon.addPoint(x + 1, y + 8);
                scaledPolygon.addPoint(x + 1, y + 6);
                scaledPolygon.addPoint(x + 2, y + 5);
                scaledPolygon.addPoint(x + 3, y + 4);
                scaledPolygon.addPoint(x + 3, y + 3);
                scaledPolygon.addPoint(x + 4, y + 3);
                scaledPolygon.addPoint(x + 5, y + 2);
                scaledPolygon.addPoint(x + 6, y + 1);
                scaledPolygon.addPoint(x + 8, y + 1);
                scaledPolygon.addPoint(x + 9, y);
                break;
            }
            case 24: {
                scaledPolygon.addPoint(x + 10, y);
                scaledPolygon.addPoint(x + 13, y);
                scaledPolygon.addPoint(x + 14, y + 1);
                scaledPolygon.addPoint(x + 16, y + 1);
                scaledPolygon.addPoint(x + 17, y + 2);
                scaledPolygon.addPoint(x + 18, y + 2);
                scaledPolygon.addPoint(x + 19, y + 3);
                scaledPolygon.addPoint(x + 20, y + 4);
                scaledPolygon.addPoint(x + 21, y + 5);
                scaledPolygon.addPoint(x + 21, y + 6);
                scaledPolygon.addPoint(x + 22, y + 7);
                scaledPolygon.addPoint(x + 22, y + 8);
                scaledPolygon.addPoint(x + 23, y + 9);
                scaledPolygon.addPoint(x + 23, y + 14);
                scaledPolygon.addPoint(x + 22, y + 15);
                scaledPolygon.addPoint(x + 22, y + 16);
                scaledPolygon.addPoint(x + 21, y + 17);
                scaledPolygon.addPoint(x + 21, y + 18);
                scaledPolygon.addPoint(x + 20, y + 19);
                scaledPolygon.addPoint(x + 19, y + 20);
                scaledPolygon.addPoint(x + 18, y + 21);
                scaledPolygon.addPoint(x + 17, y + 21);
                scaledPolygon.addPoint(x + 16, y + 22);
                scaledPolygon.addPoint(x + 14, y + 22);
                scaledPolygon.addPoint(x + 13, y + 23);
                scaledPolygon.addPoint(x + 10, y + 23);
                scaledPolygon.addPoint(x + 9, y + 22);
                scaledPolygon.addPoint(x + 7, y + 22);
                scaledPolygon.addPoint(x + 6, y + 21);
                scaledPolygon.addPoint(x + 5, y + 21);
                scaledPolygon.addPoint(x + 4, y + 20);
                scaledPolygon.addPoint(x + 3, y + 19);
                scaledPolygon.addPoint(x + 2, y + 18);
                scaledPolygon.addPoint(x + 2, y + 17);
                scaledPolygon.addPoint(x + 1, y + 16);
                scaledPolygon.addPoint(x + 1, y + 15);
                scaledPolygon.addPoint(x, y + 14);
                scaledPolygon.addPoint(x, y + 9);
                scaledPolygon.addPoint(x + 1, y + 8);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x + 2, y + 6);
                scaledPolygon.addPoint(x + 2, y + 5);
                scaledPolygon.addPoint(x + 3, y + 4);
                scaledPolygon.addPoint(x + 4, y + 3);
                scaledPolygon.addPoint(x + 5, y + 2);
                scaledPolygon.addPoint(x + 6, y + 2);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 9, y + 1);
                scaledPolygon.addPoint(x + 10, y);
                break;
            }
            case 25: {
                scaledPolygon.addPoint(x + 10, y);
                scaledPolygon.addPoint(x + 14, y);
                scaledPolygon.addPoint(x + 15, y + 1);
                scaledPolygon.addPoint(x + 17, y + 1);
                scaledPolygon.addPoint(x + 18, y + 2);
                scaledPolygon.addPoint(x + 19, y + 2);
                scaledPolygon.addPoint(x + 20, y + 3);
                scaledPolygon.addPoint(x + 21, y + 4);
                scaledPolygon.addPoint(x + 22, y + 5);
                scaledPolygon.addPoint(x + 22, y + 6);
                scaledPolygon.addPoint(x + 23, y + 7);
                scaledPolygon.addPoint(x + 23, y + 9);
                scaledPolygon.addPoint(x + 24, y + 10);
                scaledPolygon.addPoint(x + 24, y + 14);
                scaledPolygon.addPoint(x + 23, y + 15);
                scaledPolygon.addPoint(x + 23, y + 17);
                scaledPolygon.addPoint(x + 22, y + 18);
                scaledPolygon.addPoint(x + 22, y + 19);
                scaledPolygon.addPoint(x + 21, y + 20);
                scaledPolygon.addPoint(x + 20, y + 21);
                scaledPolygon.addPoint(x + 19, y + 22);
                scaledPolygon.addPoint(x + 18, y + 22);
                scaledPolygon.addPoint(x + 17, y + 23);
                scaledPolygon.addPoint(x + 15, y + 23);
                scaledPolygon.addPoint(x + 14, y + 24);
                scaledPolygon.addPoint(x + 10, y + 24);
                scaledPolygon.addPoint(x + 9, y + 23);
                scaledPolygon.addPoint(x + 7, y + 23);
                scaledPolygon.addPoint(x + 6, y + 22);
                scaledPolygon.addPoint(x + 5, y + 22);
                scaledPolygon.addPoint(x + 4, y + 21);
                scaledPolygon.addPoint(x + 3, y + 20);
                scaledPolygon.addPoint(x + 2, y + 19);
                scaledPolygon.addPoint(x + 2, y + 18);
                scaledPolygon.addPoint(x + 1, y + 17);
                scaledPolygon.addPoint(x + 1, y + 15);
                scaledPolygon.addPoint(x, y + 14);
                scaledPolygon.addPoint(x, y + 10);
                scaledPolygon.addPoint(x + 1, y + 9);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x + 2, y + 6);
                scaledPolygon.addPoint(x + 2, y + 5);
                scaledPolygon.addPoint(x + 3, y + 4);
                scaledPolygon.addPoint(x + 4, y + 3);
                scaledPolygon.addPoint(x + 5, y + 2);
                scaledPolygon.addPoint(x + 6, y + 2);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 9, y + 1);
                scaledPolygon.addPoint(x + 10, y);
                break;
            }
            case 26: {
                scaledPolygon.addPoint(x + 11, y);
                scaledPolygon.addPoint(x + 14, y);
                scaledPolygon.addPoint(x + 15, y + 1);
                scaledPolygon.addPoint(x + 18, y + 1);
                scaledPolygon.addPoint(x + 19, y + 2);
                scaledPolygon.addPoint(x + 20, y + 3);
                scaledPolygon.addPoint(x + 21, y + 3);
                scaledPolygon.addPoint(x + 22, y + 4);
                scaledPolygon.addPoint(x + 22, y + 5);
                scaledPolygon.addPoint(x + 23, y + 6);
                scaledPolygon.addPoint(x + 24, y + 7);
                scaledPolygon.addPoint(x + 24, y + 10);
                scaledPolygon.addPoint(x + 25, y + 11);
                scaledPolygon.addPoint(x + 25, y + 14);
                scaledPolygon.addPoint(x + 24, y + 15);
                scaledPolygon.addPoint(x + 24, y + 18);
                scaledPolygon.addPoint(x + 23, y + 19);
                scaledPolygon.addPoint(x + 22, y + 20);
                scaledPolygon.addPoint(x + 22, y + 21);
                scaledPolygon.addPoint(x + 21, y + 22);
                scaledPolygon.addPoint(x + 20, y + 22);
                scaledPolygon.addPoint(x + 19, y + 23);
                scaledPolygon.addPoint(x + 18, y + 24);
                scaledPolygon.addPoint(x + 15, y + 24);
                scaledPolygon.addPoint(x + 14, y + 25);
                scaledPolygon.addPoint(x + 11, y + 25);
                scaledPolygon.addPoint(x + 10, y + 24);
                scaledPolygon.addPoint(x + 7, y + 24);
                scaledPolygon.addPoint(x + 6, y + 23);
                scaledPolygon.addPoint(x + 5, y + 22);
                scaledPolygon.addPoint(x + 4, y + 22);
                scaledPolygon.addPoint(x + 3, y + 21);
                scaledPolygon.addPoint(x + 3, y + 20);
                scaledPolygon.addPoint(x + 2, y + 19);
                scaledPolygon.addPoint(x + 1, y + 18);
                scaledPolygon.addPoint(x + 1, y + 15);
                scaledPolygon.addPoint(x, y + 14);
                scaledPolygon.addPoint(x, y + 11);
                scaledPolygon.addPoint(x + 1, y + 10);
                scaledPolygon.addPoint(x + 1, y + 7);
                scaledPolygon.addPoint(x + 2, y + 6);
                scaledPolygon.addPoint(x + 3, y + 5);
                scaledPolygon.addPoint(x + 3, y + 4);
                scaledPolygon.addPoint(x + 4, y + 3);
                scaledPolygon.addPoint(x + 5, y + 3);
                scaledPolygon.addPoint(x + 6, y + 2);
                scaledPolygon.addPoint(x + 7, y + 1);
                scaledPolygon.addPoint(x + 10, y + 1);
                scaledPolygon.addPoint(x + 11, y);
                break;
            }
            default: {
                scaledPolygon = new Polygon();
                int angle = 260;
                int i = 0;
                while (i < 36) {
                    int x3 = (int)((double)(height / 2) * Math.cos((double)angle * (Math.PI / 180)));
                    int y3 = (int)((double)(height / 2) * Math.sin((double)angle * (Math.PI / 180)));
                    if (angle == 360) {
                        angle = 0;
                    }
                    angle += 10;
                    scaledPolygon.addPoint(x3 + cx, y3 + cy);
                    ++i;
                }
                break block0;
            }
        }
        if (this.m_threed) {
            Color c = this.m_bb.getFillColor();
            IdentObj identObj = new IdentObj(this.m_id);
            identObj.setMiscID(1);
            this.m_Perspective.setFillType(identObj, 2);
            this.m_Perspective.setGradientDirection(identObj, 9);
            this.m_Perspective.setGradientNumPins(identObj, 2);
            this.m_Perspective.setGradientPinPosition(identObj, 0.0, 0);
            this.m_Perspective.setGradientPinPosition(identObj, 1.0, 1);
            this.m_Perspective.setGradientPinRightColor(identObj, this.m_Perspective.getBrighter(c), 0);
            this.m_Perspective.setGradientPinLeftColor(identObj, this.m_Perspective.getBrighter(c), 0);
            this.m_Perspective.setGradientPinRightColor(identObj, c, 1);
            this.m_Perspective.setGradientPinLeftColor(identObj, c, 1);
            BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, identObj);
            blackBox.setBorderColor(c);
            new DetOval(this.m_Detectiv, identObj, scaledRect, blackBox, true, scaledPolygon, this.m_rClip);
        } else {
            new DetOval(this.m_Detectiv, this.m_id, scaledRect, this.m_bb, true, scaledPolygon, this.m_rClip);
        }
    }

    public void calcTriangleUp() {
        int height;
        Polygon scaledPolygon = new Polygon();
        VC vc = this.m_Perspective.getVC();
        int width = vc.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (width < (height = vc.virtToDestHeight(this.m_template.m_rect.height * this.m_markerSizeY / 100))) {
            width = height;
        }
        if (width < 5) {
            width = 5;
        }
        if (width % 2 == 0) {
            ++width;
        }
        height = width;
        int x = vc.virtToDestX(this.m_center.x);
        int y = vc.virtToDestY(this.m_center.y);
        scaledPolygon.addPoint(x, y - height / 2);
        scaledPolygon.addPoint(x + width / 2, y + height / 2);
        scaledPolygon.addPoint(x - width / 2, y + height / 2);
        scaledPolygon.addPoint(x, y - height / 2);
        if (!this.m_threed) {
            new DetPolygon(this.m_Detectiv, this.m_id, scaledPolygon, this.m_bb, this.m_bHiliteable);
        }
        if (this.m_threed) {
            this.threedPolygons(scaledPolygon, vc);
        }
    }

    public void calcTriangleDn() {
        int height;
        Polygon scaledPolygon = new Polygon();
        VC vc = this.m_Perspective.getVC();
        int width = vc.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (width < (height = vc.virtToDestHeight(this.m_template.m_rect.height * this.m_markerSizeY / 100))) {
            width = height;
        }
        if (width < 5) {
            width = 5;
        }
        if (width % 2 == 0) {
            ++width;
        }
        height = width;
        int x = vc.virtToDestX(this.m_center.x);
        int y = vc.virtToDestY(this.m_center.y);
        scaledPolygon.addPoint(x, y + height / 2);
        scaledPolygon.addPoint(x + width / 2, y - height / 2);
        scaledPolygon.addPoint(x - height / 2, y - height / 2);
        scaledPolygon.addPoint(x, y + height / 2);
        if (!this.m_threed) {
            new DetPolygon(this.m_Detectiv, this.m_id, scaledPolygon, this.m_bb, this.m_bHiliteable);
        }
        if (this.m_threed) {
            this.threedPolygons(scaledPolygon, vc);
        }
    }

    public void calcDiamond() {
        int height;
        Polygon scaledPolygon = new Polygon();
        VC vc = this.m_Perspective.getVC();
        int width = vc.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (width < (height = vc.virtToDestHeight(this.m_template.m_rect.height * this.m_markerSizeY / 100))) {
            width = height;
        }
        if (width < 5) {
            width = 5;
        }
        if (width % 2 == 0) {
            ++width;
        }
        height = width;
        int x = vc.virtToDestX(this.m_center.x);
        int y = vc.virtToDestY(this.m_center.y);
        scaledPolygon.addPoint(x + width / 2, y);
        scaledPolygon.addPoint(x, y - height / 2);
        scaledPolygon.addPoint(x - width / 2, y);
        scaledPolygon.addPoint(x, y + height / 2);
        if (!this.m_threed) {
            new DetPolygon(this.m_Detectiv, this.m_id, scaledPolygon, this.m_bb, this.m_bHiliteable);
        }
        if (this.m_threed) {
            this.threedPolygons(scaledPolygon, vc);
        }
    }

    public void threedPolygons(Polygon scaledPolygon, VC vc) {
        Vector<Polygon> vectorPolyMarker = new Vector<Polygon>();
        Vector<Double> directionVector = new Vector<Double>();
        this.m_nXDepth /= 3;
        this.m_nYDepth /= 3;
        int nFace = 0;
        while (nFace < scaledPolygon.npoints) {
            int nSide = (nFace + 1) % scaledPolygon.npoints;
            double fAngleRad = Math.atan2(scaledPolygon.ypoints[nSide] - scaledPolygon.ypoints[nFace], scaledPolygon.xpoints[nSide] - scaledPolygon.xpoints[nFace]);
            double fAngleDeg = fAngleRad * 57.29577951308232;
            directionVector.addElement(fAngleDeg);
            Polygon polyMarkerSide = new Polygon();
            polyMarkerSide.addPoint(scaledPolygon.xpoints[nFace], scaledPolygon.ypoints[nFace]);
            polyMarkerSide.addPoint(scaledPolygon.xpoints[nSide], scaledPolygon.ypoints[nSide]);
            polyMarkerSide.addPoint(scaledPolygon.xpoints[nSide] + vc.virtToDestWidth(this.m_nXDepth), scaledPolygon.ypoints[nSide] - vc.virtToDestHeight(this.m_nYDepth));
            polyMarkerSide.addPoint(scaledPolygon.xpoints[nFace] + vc.virtToDestWidth(this.m_nXDepth), scaledPolygon.ypoints[nFace] - vc.virtToDestHeight(this.m_nYDepth));
            vectorPolyMarker.addElement(polyMarkerSide);
            ++nFace;
        }
        int nSortType = this.m_nDepthAngle > 90 ? 1 : 0;
        QSortPoly.quickSortPoly(vectorPolyMarker, 0, vectorPolyMarker.size() - 1, nSortType);
        if (!this.m_bb.getTransparentFillColor()) {
            Color c = this.m_bb.getFillColor();
            int nPoly = 0;
            while (nPoly < vectorPolyMarker.size()) {
                Polygon p = (Polygon)vectorPolyMarker.elementAt(nPoly);
                IdentObj identObj = new IdentObj(this.m_id);
                identObj.setMiscID(nPoly);
                this.m_Perspective.setFillType(identObj, 2);
                if ((Double)directionVector.elementAt(nPoly) >= 45.0) {
                    this.m_Perspective.setGradientDirection(identObj, 2);
                } else {
                    this.m_Perspective.setGradientDirection(identObj, 4);
                }
                this.m_Perspective.setGradientNumPins(identObj, 2);
                this.m_Perspective.setGradientPinPosition(identObj, 0.0, 0);
                this.m_Perspective.setGradientPinPosition(identObj, 1.0, 1);
                this.m_Perspective.setGradientPinRightColor(identObj, this.m_Perspective.getBrighter(c), 0);
                this.m_Perspective.setGradientPinLeftColor(identObj, this.m_Perspective.getBrighter(c), 0);
                this.m_Perspective.setGradientPinRightColor(identObj, c, 1);
                this.m_Perspective.setGradientPinLeftColor(identObj, c, 1);
                BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, identObj);
                blackBox.setBorderColor(this.m_Perspective.getBrighter(c));
                new DetPolygon(this.m_Detectiv, identObj, p, (BlackBoxIF)blackBox, this.m_bHiliteable);
                ++nPoly;
            }
        }
        IdentObj obj = new IdentObj(this.m_id);
        obj.setMiscID(vectorPolyMarker.size());
        new DetPolygon(this.m_Detectiv, obj, scaledPolygon, this.m_bb, this.m_bHiliteable);
    }

    public void calcPlus() {
        int height;
        Polygon scaledPolygon = new Polygon();
        VC vc = this.m_Perspective.getVC();
        int width = vc.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (width < (height = vc.virtToDestHeight(this.m_template.m_rect.height * this.m_markerSizeY / 100))) {
            width = height;
        }
        if (width < 5) {
            width = 5;
        }
        if (width % 2 == 0) {
            ++width;
        }
        height = width;
        int x = vc.virtToDestX(this.m_center.x);
        int y = vc.virtToDestY(this.m_center.y);
        int depth = 1;
        boolean done = false;
        while (!done) {
            if (width >= (depth += 2) * 3 + 2) continue;
            done = true;
            depth -= 2;
        }
        int halfDepth = (depth + 1) / 2;
        scaledPolygon.addPoint(x - halfDepth, y - height / 2);
        scaledPolygon.addPoint(x + halfDepth, y - height / 2);
        scaledPolygon.addPoint(x + halfDepth, y - halfDepth);
        scaledPolygon.addPoint(x + height / 2, y - halfDepth);
        scaledPolygon.addPoint(x + height / 2, y + halfDepth);
        scaledPolygon.addPoint(x + halfDepth, y + halfDepth);
        scaledPolygon.addPoint(x + halfDepth, y + height / 2);
        scaledPolygon.addPoint(x - halfDepth, y + height / 2);
        scaledPolygon.addPoint(x - halfDepth, y + halfDepth);
        scaledPolygon.addPoint(x - height / 2, y + halfDepth);
        scaledPolygon.addPoint(x - height / 2, y - halfDepth);
        scaledPolygon.addPoint(x - halfDepth, y - halfDepth);
        scaledPolygon.addPoint(x - halfDepth, y - height / 2);
        if (!this.m_threed) {
            new DetPolygon(this.m_Detectiv, this.m_id, scaledPolygon, this.m_bb, this.m_bHiliteable);
        }
        if (this.m_threed) {
            this.threedPolygons(scaledPolygon, vc);
        }
    }

    public void calcRect() {
        VC vc = this.m_Perspective.getVC();
        int width = vc.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (width < 5) {
            width = 5;
        }
        if (width % 2 == 0) {
            ++width;
        }
        int height = width;
        int x = vc.virtToDestX(this.m_center.x);
        int y = vc.virtToDestY(this.m_center.y);
        Rectangle scaledRect = new Rectangle(x - width / 2, y - height / 2, width - 1, height - 1);
        if (!this.m_threed) {
            if (this.m_Perspective.getBarShape() == 1) {
                this.applyCylinderBarsGradientEffect(this.m_bb);
            }
            new DetRect(this.m_Detectiv, this.m_id, scaledRect, this.m_bb, this.m_bHiliteable);
        }
        if (this.m_threed) {
            Polygon scaledPolygon = new Polygon();
            scaledPolygon.addPoint(x - width / 2, y - height / 2);
            scaledPolygon.addPoint(x + width / 2, y - height / 2);
            scaledPolygon.addPoint(x + width / 2, y + height / 2);
            scaledPolygon.addPoint(x - width / 2, y + height / 2);
            this.threedPolygons(scaledPolygon, vc);
        }
    }

    protected void applyCylinderBarsGradientEffect(BlackBoxIF bb) {
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (!gt.isBLAType()) {
            return;
        }
        int direction = 1;
        if (gt.isOrientHorz()) {
            direction = 4;
        }
        Color c = this.m_Perspective.getFillColor(bb.getIdentObj());
        Color darkerColor = this.m_Perspective.getDarker(c);
        Color brighterColor = this.m_Perspective.getBrighter(c);
        FillGradientObj fillGradient = new FillGradientObj(this.m_Perspective, direction);
        double midPinPos = 0.5;
        if (this.m_Perspective.getDepthRadius() > 0 && gt.wantDepthEffect()) {
            midPinPos = 0.3 + 0.4 * ((double)this.m_Perspective.getDepthAngle() / 180.0);
        }
        fillGradient.insertPin(0.0, new ColorObj(darkerColor), new ColorObj(darkerColor));
        fillGradient.insertPin(midPinPos, new ColorObj(brighterColor), new ColorObj(brighterColor));
        fillGradient.insertPin(1.0, new ColorObj(darkerColor), new ColorObj(darkerColor));
        bb.setFillGradientObj(fillGradient);
    }

    public void calcLine() {
        int nLineStyle = this.m_template.getLineStyle();
        VC vc = this.m_Perspective.getVC();
        int width = vc.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        int x = vc.virtToDestX(this.m_center.x);
        int y = vc.virtToDestY(this.m_center.y);
        x = vc.destToVirtX(x - width / 2);
        new DetLine(this.m_Detectiv, this.m_id, x, this.m_center.y, x + vc.destToVirtWidth(width - 1), this.m_center.y, this.m_bb, null, 5, nLineStyle);
    }

    public void calcDrillUp() {
        VC vc = this.m_Perspective.getVC();
        int x = vc.virtToDestX(this.m_center.x);
        int y = vc.virtToDestY(this.m_center.y);
        Rectangle scaledRect = new Rectangle(x - this.m_markerSizeX / 2, y - this.m_markerSizeY / 2, this.m_markerSizeX, this.m_markerSizeY);
        new DetImage(this.m_Detectiv, this.m_id, this.m_bb, this.m_rClip, false, scaledRect);
    }

    public Point getCenter() {
        return this.m_center;
    }

    public int getMarkerType() {
        return this.m_template.m_markerType;
    }

    public Dimension getSize() {
        return new Dimension(this.m_template.m_rect.width * this.m_markerSizeX / 100, this.m_template.m_rect.height * this.m_markerSizeY / 100);
    }

    public void setReferenceLabel(String str) {
        this.m_szRefLabel = str;
    }

    public double getReferenceData() {
        return this.m_nData;
    }

    public String getReferenceLabel() {
        return this.m_szRefLabel;
    }
}

