/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;

public class MarkerTemplate
implements Serializable {
    public static final int MARKER_TYPE_NULL = 0;
    public static final int MARKER_TYPE_RECT = 1;
    public static final int MARKER_TYPE_OVAL = 2;
    public static final int MARKER_TYPE_DIAMOND = 3;
    public static final int MARKER_TYPE_REFERENCELINE = 4;
    public static final int MARKER_TYPE_PLUS = 5;
    public static final int MARKER_TYPE_TRIANGLE_DN = 6;
    public static final int MARKER_TYPE_TRIANGLE_UP = 7;
    public static final int MARKER_TYPE_DRILL_UP = 8;
    public static final int MARKER_TYPE_BUBBLE = 9;
    public static final int MARKER_TYPE_DATALINE = 10;
    public static final int UNIT = 1000;
    private static final int HALF = 500;
    private static final int THIRD = 333;
    private static final int QUARTER = 250;
    public static final Rectangle MARKER_SQUARE = new Rectangle(-1000, -1000, 2000, 2000);
    public static final Rectangle MARKER_LINE = new Rectangle(-1000, -500, 2000, 500);
    private static final int[] MARKER_REF_X = new int[]{-1000, 1000, 1000, -1000};
    private static final int[] MARKER_REF_Y = new int[]{-1, -1, 1, 1};
    public static final Polygon MARKER_REFERENCE_LINE = new Polygon(MARKER_REF_X, MARKER_REF_Y, 4);
    private static final int nXFortyFiveDeg = (int)(1000.0 * Math.cos(0.7853981633974483));
    private static final int nYFortyFiveDeg = (int)(1000.0 * Math.sin(0.7853981633974483));
    private static final int[] MARKER_DEPTHCIRCLE_X = new int[]{1000, nXFortyFiveDeg, 0, -nXFortyFiveDeg, -1000, -nXFortyFiveDeg, 0, nXFortyFiveDeg};
    private static final int[] MARKER_DEPTHCIRCLE_Y = new int[]{0, nYFortyFiveDeg, 1000, nYFortyFiveDeg, 0, -nYFortyFiveDeg, -1000, -nYFortyFiveDeg};
    public static final Polygon MARKER_DEPTHCIRCLE = new Polygon(MARKER_DEPTHCIRCLE_X, MARKER_DEPTHCIRCLE_Y, 8);
    private static final int[] MARKER_DIAMOND_X = new int[]{1000, 0, -1000, 0};
    private static final int[] MARKER_DIAMOND_Y = new int[]{0, 1000, 0, -1000};
    public static final Polygon MARKER_DIAMOND = new Polygon(MARKER_DIAMOND_X, MARKER_DIAMOND_Y, 4);
    private static final int[] MARKER_PLUS_X = new int[]{1000, 333, 333, -333, -333, -1000, -1000, -333, -333, 333, 333, 1000};
    private static final int[] MARKER_PLUS_Y = new int[]{333, 333, 1000, 1000, 333, 333, -333, -333, -1000, -1000, -333, -333};
    public static final Polygon MARKER_PLUS = new Polygon(MARKER_PLUS_X, MARKER_PLUS_Y, 12);
    private static final int YVAL = (int)(1000.0 * Math.sqrt(3.0) / 2.0);
    private static final int[] MARKER_TRIANGLE_DN_X = new int[]{1000, 0, -1000};
    private static final int[] MARKER_TRIANGLE_DN_Y = new int[]{YVAL, -YVAL, YVAL};
    public static final Polygon MARKER_TRIANGLE_DN = new Polygon(MARKER_TRIANGLE_DN_X, MARKER_TRIANGLE_DN_Y, 3);
    private static final int[] MARKER_TRIANGLE_UP_X = new int[]{1000, 0, -1000};
    private static final int[] MARKER_TRIANGLE_UP_Y = new int[]{-YVAL, YVAL, -YVAL};
    public static final Polygon MARKER_TRIANGLE_UP = new Polygon(MARKER_TRIANGLE_UP_X, MARKER_TRIANGLE_UP_Y, 3);
    private static final int A = 666;
    private static final int[] MARKER_PIRATE_PLUS_X = new int[]{0, -666, 666, 0, 1000, 1000, 0, 666, -666, 0, -1000, -1000};
    private static final int[] MARKER_PIRATE_PLUS_Y = new int[]{0, 1000, 1000, 0, 666, -666, 0, -1000, -1000, 0, -666, 666};
    public static final Polygon MARKER_PIRATE_PLUS = new Polygon(MARKER_PIRATE_PLUS_X, MARKER_PIRATE_PLUS_Y, 12);
    Rectangle m_rect;
    Polygon m_polygon;
    int m_markerType;
    int m_nLineWidth;
    Color m_LineColor;
    int m_nLineWidthVC;
    int m_nLineStyle;

    public MarkerTemplate() {
        this.m_markerType = 0;
    }

    public MarkerTemplate(Polygon polygon, int markerType) {
        this(null, polygon, markerType);
    }

    public MarkerTemplate(Polygon polygon) {
        this(null, polygon, 0);
    }

    public MarkerTemplate(Rectangle rect) {
        this(rect, null, 1);
    }

    public MarkerTemplate(Rectangle rect, int markerType) {
        this(rect, null, markerType);
    }

    public MarkerTemplate(Rectangle rect, Polygon polygon, int markerType) {
        this.m_rect = rect;
        this.m_polygon = polygon;
        this.m_markerType = markerType;
    }

    public MarkerTemplate(Rectangle rect, boolean bOval) {
        this(rect, null, 1);
        if (bOval) {
            this.m_markerType = 2;
        }
    }

    public boolean isValid() {
        boolean bValid = true;
        switch (this.m_markerType) {
            case 0: {
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                if (this.m_polygon == null) {
                    bValid = false;
                    break;
                }
                Rectangle r = this.m_polygon.getBounds();
                if (r != null && r.width > 0 && r.width <= 2000 && r.height > 0 && r.height <= 2000) break;
                bValid = false;
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                if (this.m_rect != null && this.m_rect.width > 0 && this.m_rect.width <= 2000 && this.m_rect.height > 0 && this.m_rect.height <= 2000) break;
                bValid = false;
                break;
            }
            case 9: {
                if (this.m_rect != null && this.m_rect.width > 0 && this.m_rect.height > 0) break;
                bValid = false;
                break;
            }
            default: {
                bValid = false;
                break;
            }
        }
        return bValid;
    }

    public String toString() {
        String s;
        switch (this.m_markerType) {
            case 0: {
                s = "Null Marker";
                break;
            }
            case 1: {
                s = "Rect = " + this.m_rect;
                break;
            }
            case 2: {
                s = "Oval whose rect = " + this.m_rect;
                break;
            }
            case 9: {
                s = "Bubble whose rect = " + this.m_rect;
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                s = "Polygon = " + this.m_polygon;
                break;
            }
            case 8: {
                s = "Drill-up icon";
                break;
            }
            default: {
                s = "Unknown marker type!";
                break;
            }
        }
        return s;
    }

    public int getMarkerType() {
        return this.m_markerType;
    }

    public MarkerTemplate(Rectangle rect, int markerType, int nLineWidth, Color clr) {
        this(rect, null, markerType, nLineWidth, clr);
    }

    public MarkerTemplate(Rectangle rect, Polygon polygon, int markerType, int nLineWidth, Color color) {
        this.m_rect = rect;
        this.m_polygon = polygon;
        this.m_markerType = markerType;
        this.m_nLineWidth = nLineWidth;
        this.m_LineColor = color;
    }

    public MarkerTemplate(Polygon polygon, int markerType, int nLineWidth, Color color) {
        this.m_rect = null;
        this.m_polygon = polygon;
        this.m_markerType = markerType;
        this.m_nLineWidth = nLineWidth;
        this.m_LineColor = color;
    }

    public int getLineWidth() {
        return this.m_nLineWidth;
    }

    public void setLineStyle(int style) {
        this.m_nLineStyle = style;
    }

    public int getLineStyle() {
        return this.m_nLineStyle;
    }

    public void setLineWidthVC(int lineWidth) {
        this.m_nLineWidthVC = lineWidth;
    }

    public int getLineWidthVC() {
        return this.m_nLineWidthVC;
    }

    public Color getLineColor() {
        return this.m_LineColor;
    }
}

