/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.MarkerTemplate;

public class MarkerTemplateArray
implements Serializable {
    Vector m_vectMarkerTemplate;
    public static final int SQUARE_MARKERTEMPLATE_INDEX = 1;
    public static final MarkerTemplate PRESET_NULL = new MarkerTemplate();
    public static final MarkerTemplate PRESET_SQUARE = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE);
    public static final MarkerTemplate PRESET_CIRCLE = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, true);
    public static final MarkerTemplate PRESET_DIAMOND = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, 3);
    public static final MarkerTemplate PRESET_PLUS = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, 5);
    public static final MarkerTemplate PRESET_TRIANGLE_DN = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, 6);
    public static final MarkerTemplate PRESET_TRIANGLE_UP = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, 7);
    public static final MarkerTemplate PRESET_DEPTHCIRCLE = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, true);
    public static final MarkerTemplate PRESET_BUBBLE = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, 9);

    private void $init$() {
        this.m_vectMarkerTemplate = null;
    }

    public MarkerTemplateArray() {
        this.$init$();
        this.m_vectMarkerTemplate = new Vector(0);
        this.m_vectMarkerTemplate.addElement(PRESET_NULL);
        this.m_vectMarkerTemplate.addElement(PRESET_SQUARE);
        this.m_vectMarkerTemplate.addElement(PRESET_CIRCLE);
        this.m_vectMarkerTemplate.addElement(PRESET_DIAMOND);
        this.m_vectMarkerTemplate.addElement(PRESET_PLUS);
        this.m_vectMarkerTemplate.addElement(PRESET_TRIANGLE_DN);
        this.m_vectMarkerTemplate.addElement(PRESET_TRIANGLE_UP);
    }

    public int getLoopedMarkerShape(int nIndex) {
        int nNumMarkers = this.findNextTemplateSlot() - 1;
        int nMarkerShapeIdx = nIndex % nNumMarkers;
        return ++nMarkerShapeIdx;
    }

    public MarkerTemplate getMarkerTemplate(int nIdx) {
        MarkerTemplate mkrTemplate = null;
        mkrTemplate = nIdx >= 0 && nIdx < this.m_vectMarkerTemplate.size() ? (MarkerTemplate)this.m_vectMarkerTemplate.elementAt(nIdx) : (MarkerTemplate)this.m_vectMarkerTemplate.elementAt(1);
        return mkrTemplate;
    }

    protected int findNextTemplateSlot() {
        int nAvailableSlot = this.m_vectMarkerTemplate.size();
        return nAvailableSlot;
    }

    public int registerMarkerTemplate(MarkerTemplate newMarkerTemplate) throws AssertionException {
        this.checkValidMarkerTemplate(newMarkerTemplate);
        int nIndex = this.findNextTemplateSlot();
        this.m_vectMarkerTemplate.addElement(newMarkerTemplate);
        return nIndex;
    }

    public void setMarkerTemplate(int nIndex, MarkerTemplate newMarkerTemplate) throws AssertionException {
        if (nIndex < 0) {
            throw new AssertionException("Can't set marker template; bad value for index: " + nIndex);
        }
        this.checkValidMarkerTemplate(newMarkerTemplate);
        if (nIndex >= this.m_vectMarkerTemplate.size()) {
            this.m_vectMarkerTemplate.addElement(newMarkerTemplate);
        } else {
            this.m_vectMarkerTemplate.setElementAt(newMarkerTemplate, nIndex);
        }
    }

    protected void checkValidMarkerTemplate(MarkerTemplate newMarkerTemplate) {
        if (newMarkerTemplate == null) {
            throw new AssertionException("Can't register marker template is null");
        }
        if (!newMarkerTemplate.isValid()) {
            throw new AssertionException("Can't register marker template type is invalid or polygon bounds > 900");
        }
    }
}

