/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Point;
import java.awt.geom.Point2D;
import oracle.dss.graph.pfj.math.FP;

public final class MathExt {
    public static final double TWO_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double DEG_PER_RAD = 57.29577951308232;
    public static final double RAD_PER_DEG = Math.PI / 180;

    public static double sigdigits(double dVal, int significantDigits) {
        int excessDigitValue;
        boolean Neg;
        String theValueString = Double.toString(dVal);
        int excessDigit = significantDigits;
        boolean Decimal = theValueString.indexOf(".") != -1;
        boolean bl = Neg = dVal < 0.0;
        if (Decimal) {
            ++excessDigit;
        }
        if (Neg) {
            ++excessDigit;
        }
        if (theValueString.length() < excessDigit) {
            return dVal;
        }
        String excessFractionString = theValueString.substring(excessDigit, theValueString.length());
        excessFractionString = "0." + excessFractionString;
        double excessFractionValue = new Double(excessFractionString);
        String significanceAdder = "0.";
        int i = 1;
        while (i < significantDigits) {
            significanceAdder = significanceAdder + "0";
            ++i;
        }
        significanceAdder = significanceAdder + "5";
        double returnValue = dVal;
        if (excessFractionValue > 0.5) {
            returnValue = Neg ? dVal - new Double(significanceAdder) : dVal + new Double(significanceAdder);
        } else if (FP.equal(excessFractionValue, 0.5) && (excessDigitValue = new Integer(theValueString.substring(excessDigit - 1, excessDigit)).intValue()) % 2 != 0) {
            returnValue = Neg ? dVal - new Double(significanceAdder) : dVal + new Double(significanceAdder);
        }
        return returnValue;
    }

    public static Point polToCart(double angleInDeg, double radius, Point origin) {
        Point pt = new Point(0, 0);
        double fX = radius * Math.cos(angleInDeg * (Math.PI / 180));
        double fY = radius * Math.sin(angleInDeg * (Math.PI / 180));
        pt.x = origin.x + (int)fX;
        pt.y = origin.y + (int)fY;
        return pt;
    }

    public static Point2D polToCart(double angleInDeg, double radius, Point2D origin) {
        Point2D.Double pt = new Point2D.Double(0.0, 0.0);
        double fX = radius * Math.cos(angleInDeg * (Math.PI / 180));
        double fY = radius * Math.sin(angleInDeg * (Math.PI / 180));
        pt = new Point2D.Double(origin.getX() + fX, origin.getY() + fY);
        return pt;
    }

    public static int findQuadrantAngle(double angle) {
        while (angle >= 360.0) {
            angle -= 360.0;
        }
        if (angle < 90.0) {
            return 1;
        }
        if (angle < 180.0) {
            return 2;
        }
        if (angle < 270.0) {
            return 3;
        }
        return 4;
    }

    public static double getIntercept(double x0, double y0, double x1, double y1, double y) {
        double fSlope = (y - y0) / (y1 - y0);
        double fXDiff = x1 - x0;
        double x = fXDiff * fSlope + x0;
        return x;
    }
}

