/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;

public class NYDescriptor
implements Serializable {
    public static final boolean[] usageValuesTwoY = new boolean[]{true, true};
    public static final boolean[] usageValuesThreeY = new boolean[]{true, true, true};
    public static final boolean[] usageValuesFourY = new boolean[]{true, true, true, true};
    public static final boolean[] usageValuesFiveY = new boolean[]{true, true, true, true, true};
    protected final boolean[] m_bUsageValues;
    protected final float[] m_fStartValues;
    protected final float[] m_fSizeValues;

    public NYDescriptor(boolean[] bUsageValues) throws IllegalArgumentException {
        if (bUsageValues == null) {
            throw new IllegalArgumentException("NYDescriptor cannot be constructed with null values");
        }
        if (bUsageValues.length == 0 || !bUsageValues[0]) {
            throw new IllegalArgumentException("NYDescriptor cannot be constructed without valid Y1 values");
        }
        this.m_bUsageValues = new boolean[bUsageValues.length];
        this.m_fStartValues = new float[bUsageValues.length];
        this.m_fSizeValues = new float[bUsageValues.length];
        int nAxisCount = 0;
        int i = 0;
        while (i < bUsageValues.length) {
            if (bUsageValues[i]) {
                ++nAxisCount;
            }
            ++i;
        }
        float fPctLeft = 1.0f;
        int nDone = 0;
        int i2 = 0;
        while (i2 < bUsageValues.length) {
            this.m_bUsageValues[i2] = bUsageValues[i2];
            if (!bUsageValues[i2]) {
                this.m_fStartValues[i2] = 0.0f;
                this.m_fSizeValues[i2] = 0.0f;
            } else {
                float fSize;
                this.m_fSizeValues[i2] = fSize = fPctLeft / (float)(nAxisCount - nDone);
                this.m_fStartValues[i2] = 1.0f - fPctLeft;
                fPctLeft -= fSize;
                ++nDone;
            }
            ++i2;
        }
    }

    public NYDescriptor(boolean[] bUsageValues, float[] fStartValues, float[] fSizeValues) throws IllegalArgumentException {
        if (bUsageValues == null || fStartValues == null || fSizeValues == null) {
            throw new IllegalArgumentException("NYDescriptor cannot be constructed with null arguments");
        }
        int nLength = Math.min(Math.min(bUsageValues.length, fStartValues.length), fSizeValues.length);
        if (nLength == 0 || !bUsageValues[0] || fSizeValues[0] <= 0.0f) {
            throw new IllegalArgumentException("NYDescriptor cannot be constructed with empty arrays or invalid Y1 values");
        }
        this.m_bUsageValues = new boolean[nLength];
        this.m_fStartValues = new float[nLength];
        this.m_fSizeValues = new float[nLength];
        int i = 0;
        while (i < nLength) {
            if (fStartValues[i] < 0.0f || fStartValues[i] > 1.0f || fSizeValues[i] < 0.0f || fSizeValues[i] > 1.0f) {
                throw new IllegalArgumentException("start and size values must be between 0 and 1");
            }
            if (this.m_bUsageValues[i] && fSizeValues[i] == 0.0f) {
                throw new IllegalArgumentException("size must be positive if the axis is in use");
            }
            this.m_bUsageValues[i] = bUsageValues[i];
            this.m_fStartValues[i] = fStartValues[i];
            this.m_fSizeValues[i] = fSizeValues[i];
            ++i;
        }
    }

    public boolean hasYAxis(int nWhichAxis) {
        return nWhichAxis < this.m_bUsageValues.length && this.m_bUsageValues[nWhichAxis];
    }

    public float getOffset(int nWhichAxis) {
        if (nWhichAxis < this.m_fStartValues.length) {
            return this.m_fStartValues[nWhichAxis];
        }
        return 0.0f;
    }

    public float getSize(int nWhichAxis) {
        if (nWhichAxis < this.m_fSizeValues.length) {
            return this.m_fSizeValues[nWhichAxis];
        }
        return 0.0f;
    }

    public String toString() {
        return super.toString();
    }
}

