/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import oracle.dss.graph.pfj.RadixCompare;

public class RadixSort {
    private RadixCompare delegate;
    private Object[] userArray;
    private Object[] sourceArray;
    private Object[] targetArray;
    private int keyLength;
    private int[] counts;

    public static void sort(Object[] userArray, RadixCompare delegate, int keyLength) {
        RadixSort h = new RadixSort();
        h.delegate = delegate;
        h.userArray = userArray;
        h.keyLength = keyLength;
        h.radixSort();
    }

    private void radixSort() {
        this.counts = new int[256];
        this.sourceArray = this.userArray;
        this.targetArray = new Object[this.userArray.length];
        int col = this.keyLength - 1;
        while (col > 0) {
            this.sortCol(col);
            Object[] temp = this.sourceArray;
            this.sourceArray = this.targetArray;
            this.targetArray = temp;
            --col;
        }
        if (this.sourceArray != this.userArray) {
            System.arraycopy(this.sourceArray, 0, this.userArray, 0, this.sourceArray.length);
        }
    }

    private void sortCol(int col) {
        int i = 0;
        while (i < this.counts.length) {
            this.counts[i] = 0;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.sourceArray.length) {
            int n = this.delegate.getKeyByteAt(this.sourceArray[i2], col);
            this.counts[n] = this.counts[n] + 1;
            ++i2;
        }
        int soFar = 0;
        int i3 = 0;
        while (i3 < this.counts.length) {
            int temp = this.counts[i3];
            this.counts[i3] = soFar;
            soFar += temp;
            ++i3;
        }
        int from = 0;
        while (from < this.sourceArray.length) {
            int keyByte;
            int n = keyByte = this.delegate.getKeyByteAt(this.sourceArray[from], col);
            this.counts[n] = this.counts[n] + 1;
            this.targetArray[to] = this.sourceArray[from];
            ++from;
        }
    }
}

