/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;
import oracle.dss.graph.pfj.AxisDescriptor;
import oracle.dss.graph.pfj.CircularAxisObj;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetOval;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetPolyline;
import oracle.dss.graph.pfj.draw.IdentObj;

public class ReferenceObj
implements Serializable {
    protected Perspective m_Perspective;
    protected JChart_Base m_chart;
    private Rectangle m_rFrameVC;
    private Point m_centerFramePosVC;
    protected JGraphType m_gt;
    protected Point pt1;
    protected Point pt2;
    protected Point pt3;
    protected Point pt4;
    protected int m_location;

    private void $init$() {
        this.m_chart = null;
        this.m_gt = null;
        this.m_location = 1;
    }

    public ReferenceObj(Perspective perspective) {
        this.$init$();
        this.m_rFrameVC = new Rectangle();
        this.m_centerFramePosVC = new Point(0, 0);
        this.m_Perspective = perspective;
        this.m_chart = this.m_Perspective.getGraphObject();
    }

    public void setLocation(int location) {
        this.m_location = location;
    }

    public void calc() {
        this.m_gt = this.m_Perspective.getJGraphType();
        if (!(this.m_gt.isBLAType() || this.m_gt.isPolar() || this.m_gt.isRadarType() || this.m_gt.isScatter() || this.m_gt.isBubble() || this.m_gt.isParetoType() || this.m_gt.isStockType())) {
            return;
        }
        int count = this.m_Perspective.m_referenceObjects.size();
        int i = 0;
        while (i < count) {
            this.calcOne((IdentObj)this.m_Perspective.m_referenceObjects.get(i));
            ++i;
        }
    }

    public void calcOne(IdentObj id) {
        double m_relVal;
        double nLowValue;
        int location = this.m_Perspective.getReferenceObjectLocation(id);
        if (location != this.m_location) {
            return;
        }
        int nAxisID = 2004;
        int nNdx = id.getMiscID();
        double nValue = this.m_Perspective.getReferenceLineValue(id);
        Double hValue = this.m_Perspective.getReferenceAreaHighValue(id);
        Double lValue = this.m_Perspective.getReferenceAreaLowValue(id);
        int nType = this.m_Perspective.getReferenceObjectType(id);
        Polygon p = null;
        boolean displayObject = this.m_Perspective.getDisplay(id);
        int nComponent = this.m_Perspective.getReferenceAssociation(id);
        int display = this.m_Perspective.getReferenceObjectDisplay(nComponent);
        if (display == 0) {
            return;
        }
        if (display == 2 && this.m_Perspective.m_currentComponentID != nComponent) {
            displayObject = false;
        }
        switch (nComponent) {
            case 46: {
                nAxisID = 2004;
                break;
            }
            case 51: {
                nAxisID = 2005;
                break;
            }
            case 41: {
                nAxisID = 2003;
                break;
            }
            case 31: {
                IdentObj sid;
                int series = this.m_Perspective.getReferenceSeries(id);
                if (display == 2 && this.m_Perspective.m_currentSeries != series) {
                    displayObject = false;
                }
                if (this.m_Perspective.getAxisAssignment(sid = this.m_Perspective.getSeries(series)) == 1 && this.m_gt.isDualY()) {
                    nAxisID = 2005;
                    break;
                }
                nAxisID = 2004;
                break;
            }
        }
        if (this.m_Perspective.isExportingToSVG() || this.m_Perspective.isExportingToXML()) {
            displayObject = true;
        }
        if (!this.checkValidAxis(nAxisID, this.m_chart)) {
            return;
        }
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        int nLineWidth = this.m_Perspective.getLineWidth(id);
        int nLineStyle = this.m_Perspective.getLineStyle(id);
        int nWidth = nLineWidth == 0 ? 1 : nLineWidth;
        int nWidthVC = this.m_Perspective.m_VC.destToVirtWidth(nWidth);
        blackBox.setBorderColor(this.m_Perspective.getFillColor(id));
        boolean bDrawWithDepth = this.m_Perspective.getDepthRadius() > 0;
        Point frameDepthOffse = this.m_Perspective.getFrameDepthOffset();
        Rectangle frameRect = this.m_Perspective.getFrameRect(true);
        String szLabel = this.m_Perspective.getTextString(id);
        frameRect = this.m_Perspective.getRect(this.m_Perspective.getFrame());
        JChart_2D_Standard ch2 = (JChart_2D_Standard)this.m_chart;
        RelativeAxisObj aObj = null;
        switch (nAxisID) {
            case 2004: {
                aObj = ch2.getY1Axis();
                break;
            }
            case 2005: {
                aObj = ch2.getY2Axis();
                break;
            }
            case 2003: {
                if (this.m_Perspective.isContinuousTimeAxis()) {
                    aObj = ch2.getO1Axis();
                    break;
                }
                aObj = ch2.getX1Axis();
                break;
            }
        }
        if (aObj == null) {
            return;
        }
        double max = aObj.getMaxValue();
        double min = aObj.getMinValue();
        double nHighValue = hValue == Double.POSITIVE_INFINITY ? max : hValue;
        double d = nLowValue = lValue == Double.NEGATIVE_INFINITY ? min : lValue;
        if (this.m_gt.isParetoType() && nAxisID == 2005) {
            if (nType == 0) {
                if ((nValue = aObj.getValueFromRelCoord(nValue / 100.0)) > max || nValue < min) {
                    return;
                }
            } else {
                nHighValue = aObj.getValueFromRelCoord(nHighValue / 100.0);
                nLowValue = aObj.getValueFromRelCoord(nLowValue / 100.0);
                if (nHighValue > max && nLowValue > max || nHighValue < min && nLowValue < min) {
                    return;
                }
                if (nHighValue > max) {
                    nHighValue = max;
                }
                if (nLowValue < min) {
                    nLowValue = min;
                }
            }
        } else if (nType == 0) {
            if (this.m_gt.isPercent() && nValue > 1.0 && nValue <= 100.0) {
                nValue /= 100.0;
            }
            if (nValue > max || nValue < min) {
                return;
            }
        } else {
            if (this.m_gt.isPercent() && nHighValue > 1.0 && nHighValue <= 100.0) {
                nHighValue /= 100.0;
            }
            if (this.m_gt.isPercent() && nLowValue > 1.0 && nLowValue <= 100.0) {
                nLowValue /= 100.0;
            }
            if (nHighValue > max && nLowValue > max || nHighValue < min && nLowValue < min) {
                return;
            }
            if (nHighValue > max) {
                nHighValue = max;
            }
            if (nLowValue < min) {
                nLowValue = min;
            }
        }
        if (aObj.isVertical()) {
            if (nType == 0) {
                int y = (int)aObj.getValueCoord(nValue);
                if (location == 1 && bDrawWithDepth) {
                    this.pt1 = new Point(frameRect.x, y);
                    this.pt2 = new Point(frameRect.x + frameRect.width, y);
                } else {
                    this.pt1 = new Point(frameRect.x - frameDepthOffse.x, y - frameDepthOffse.y);
                    this.pt2 = new Point(frameRect.x + frameRect.width - frameDepthOffse.x, y - frameDepthOffse.y);
                }
                m_relVal = aObj.getValueRelCoord(nValue);
            } else {
                int low = (int)aObj.getValueCoord(nLowValue);
                int high = (int)aObj.getValueCoord(nHighValue);
                p = new Polygon();
                if (location == 1 && bDrawWithDepth) {
                    p.addPoint(frameRect.x, low);
                    p.addPoint(frameRect.x + frameRect.width, low);
                    p.addPoint(frameRect.x + frameRect.width, high);
                    p.addPoint(frameRect.x, high);
                } else {
                    p.addPoint(frameRect.x - frameDepthOffse.x, low - frameDepthOffse.y);
                    p.addPoint(frameRect.x + frameRect.width - frameDepthOffse.x, low - frameDepthOffse.y);
                    p.addPoint(frameRect.x + frameRect.width - frameDepthOffse.x, high - frameDepthOffse.y);
                    p.addPoint(frameRect.x - frameDepthOffse.x, high - frameDepthOffse.y);
                }
                m_relVal = aObj.getValueRelCoord(nLowValue);
            }
        } else if (nType == 0) {
            int x = (int)aObj.getValueCoord(nValue);
            if (location == 1 && bDrawWithDepth) {
                this.pt1 = new Point(x, frameRect.y);
                this.pt2 = new Point(x, frameRect.y + frameRect.height);
            } else {
                this.pt1 = new Point(x - frameDepthOffse.x, frameRect.y - frameDepthOffse.y);
                this.pt2 = new Point(x - frameDepthOffse.x, frameRect.y + frameRect.height - frameDepthOffse.y);
            }
            m_relVal = aObj.getValueRelCoord(nValue);
        } else {
            int low = (int)aObj.getValueCoord(nLowValue);
            int high = (int)aObj.getValueCoord(nHighValue);
            p = new Polygon();
            if (location == 1 && bDrawWithDepth) {
                p.addPoint(low, frameRect.y);
                p.addPoint(low, frameRect.y + frameRect.height);
                p.addPoint(high, frameRect.y + frameRect.height);
                p.addPoint(high, frameRect.y);
            } else {
                p.addPoint(low - frameDepthOffse.x, frameRect.y - frameDepthOffse.y);
                p.addPoint(low - frameDepthOffse.x, frameRect.y + frameRect.height - frameDepthOffse.y);
                p.addPoint(high - frameDepthOffse.x, frameRect.y + frameRect.height - frameDepthOffse.y);
                p.addPoint(high - frameDepthOffse.x, frameRect.y - frameDepthOffse.y);
            }
            m_relVal = aObj.getValueRelCoord(nLowValue);
        }
        if ((this.pt1 != null || p != null) && displayObject) {
            if (this.m_gt.isPolar() || this.m_gt.isRadarType()) {
                this.m_rFrameVC.width = frameRect.width;
                this.m_rFrameVC.height = frameRect.height;
                this.m_centerFramePosVC.x = frameRect.x + frameRect.width / 2;
                this.m_centerFramePosVC.y = frameRect.y + frameRect.height / 2;
                if (nAxisID == 2004) {
                    if (this.m_gt.isPolar()) {
                        Rectangle rOval = new Rectangle(this.getValueOval(m_relVal));
                        DetOval dOval = new DetOval(this.m_Perspective.m_Detectiv, id, rOval.x, rOval.y, rOval.width, rOval.height, blackBox, null, false, true, true, nLineWidth, nWidthVC);
                        dOval.setReferenceData(nValue);
                        dOval.setReferenceObject();
                    } else {
                        aObj = ch2.getY1Axis();
                        CircularAxisObj cObj = (CircularAxisObj)aObj;
                        Point pt = new Point(0, 0);
                        Vector<Point> points = new Vector<Point>();
                        Rectangle rect = this.m_Perspective.getFrameRect(false);
                        Dimension frameDimVC = new Dimension(rect.width, rect.height);
                        int nLabels = ((JChart_2D_Standard)this.m_Perspective.m_chart).m_O1Axis.getNumLabels();
                        Vector o1PosRel = ((JChart_2D_Standard)this.m_Perspective.m_chart).m_O1Axis.getRelLabelPos(nLabels);
                        int i = 0;
                        while (i < nLabels) {
                            double angle = CircularAxisObj.getAngleFromRelAngle((Double)o1PosRel.elementAt(i), this.m_Perspective);
                            CircularAxisObj.polarToCartesian(pt, angle, m_relVal, frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
                            points.add(new Point(pt.x, pt.y));
                            ++i;
                        }
                        points.add((Point)points.elementAt(0));
                        new DetPolyline(this.m_Perspective.getDetectiv(), id, points, blackBox, null, nLineWidth);
                    }
                } else if (nAxisID == 2003) {
                    aObj = ch2.getX1Axis();
                    Rectangle rFrame = this.m_Perspective.getFrameRect(false);
                    this.pt2 = new Point(0, 0);
                    double angle = aObj.getValueCoord(nValue);
                    Dimension m_frameDimVC = new Dimension(rFrame.width, rFrame.height);
                    CircularAxisObj cObj = (CircularAxisObj)aObj;
                    CircularAxisObj.polarToCartesian(this.pt2, angle, 1.0, m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
                    DetLine nLineObj = new DetLine(this.m_Perspective.m_Detectiv, id, this.m_centerFramePosVC.x, this.m_centerFramePosVC.y, this.pt2.x, this.pt2.y, (BlackBoxIF)blackBox, null, nLineWidth, nLineStyle);
                    nLineObj.setReferenceData(nValue);
                    nLineObj.setReferenceObject();
                }
            } else if (nType == 0) {
                DetLine nLineObj = new DetLine(this.m_Perspective.m_Detectiv, id, this.pt1.x, this.pt1.y, this.pt2.x, this.pt2.y, blackBox, null, false, true, nLineWidth, nLineStyle);
                nLineObj.setReferenceData(nValue);
                nLineObj.setReferenceObject();
            } else {
                new DetPolygon(this.m_Perspective.m_Detectiv, id, p, (BlackBoxIF)blackBox, 1.0);
            }
        }
    }

    public Rectangle getValueOval(double fRelValue) {
        return new Rectangle((int)((double)this.m_centerFramePosVC.x - (double)(this.m_rFrameVC.width / 2) * fRelValue), (int)((double)this.m_centerFramePosVC.y - (double)(this.m_rFrameVC.height / 2) * fRelValue), (int)((double)(2 * this.m_rFrameVC.width / 2) * fRelValue), (int)((double)(2 * this.m_rFrameVC.height / 2) * fRelValue));
    }

    private boolean checkValidAxis(int nAxisID, JChart_Base m_chart) {
        boolean bValid = false;
        if (m_chart != null) {
            JChart_2D_Standard ch2 = (JChart_2D_Standard)m_chart;
            AxisDescriptor axisDescriptor = this.m_gt.getAxisDescriptor();
            if (axisDescriptor != null) {
                if (nAxisID == 2004) {
                    if (axisDescriptor.hasY1()) {
                        bValid = true;
                    }
                } else if (nAxisID == 2003) {
                    if (axisDescriptor.hasX1() || this.m_Perspective.isContinuousTimeAxis()) {
                        bValid = true;
                    }
                } else if (nAxisID == 2005 && (axisDescriptor.hasY2() || this.m_gt.isStockTypeWithVolume())) {
                    bValid = true;
                }
            }
        }
        return bValid;
    }

    public boolean IsReferenceLineAxisValid(int nAxisID) {
        if (!(this.m_gt.isBLAType() || this.m_gt.isPolar() || this.m_gt.isRadarType() || this.m_gt.isScatter() || this.m_gt.isBubble() || this.m_gt.isParetoType() || this.m_gt.isStockType())) {
            return this.checkValidAxis(nAxisID, this.m_chart);
        }
        return false;
    }

    public boolean IsValidAxis(int nAxisID) {
        return this.checkValidAxis(nAxisID, this.m_Perspective.getGraphObject());
    }
}

