/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.AxisObj;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Scat;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.MathExt;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.NumberFormatCallBack;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.math.FP;

public abstract class RelativeAxisObj
extends AxisObj {
    private static final double AUTOMINMAX_ADJUST = 1.05;
    private static final int MAX_NUMBER_OF_GRIDS = 100;
    static final int BUBBLE_DEST_BUFFER = 2;
    private static final int BUBBLE_VIRT_BUFFER = 100;
    public static final int SERIES_SIDE_BY_SIDE = 0;
    public static final int ONE_SERIES_PER_GROUP = 1;
    public static final int CENTERED_ON_GROUP = 2;
    public static final int TWO_SERIES_PER_GROUP = 3;
    public static final int CONNECTED_SERIES = 4;
    public static final int CONNECTED_GROUPS = 5;
    public static final int DATA_TOUCH_BORDER = 6;
    public static final int GROUP_3D = 7;
    public static final int SERIES_3D = 8;
    public static final int CIRCULAR = 9;
    public static final int ONE_SERIES_PER_GROUPS = 10;
    protected boolean m_bNumericAxis;
    protected MinMaxObj m_objMinMax;
    protected double m_fScaleMin;
    protected double m_fScaleMax;
    protected double m_fScaleStep;
    protected double m_fMinAutoScaleStep;
    protected double m_fMinorStep;
    protected double m_fValToRelCoord;
    protected boolean m_bLogScale;
    protected double m_fLogScaleBase;
    protected boolean m_bAutoMax;
    protected boolean m_bAutoMin;
    protected boolean m_bAutoStep;
    private double m_nSpaceBetGroups;
    private double m_nLeftPosFirstGroup;
    private double m_nSpaceBetSeries;
    private double m_nOffsetBetGroupPosAndFirstSeries;
    private double m_fRiserWidth;
    int[] m_nSeriesTypes;
    int m_nBaseRiserType;
    boolean m_bIsComboChart;
    private int m_nNumLabels;
    double[] m_nParetoSeriesMaximums;
    double[] m_nParetoSeriesMinimums;
    double m_Y2DefaultScaleStep;
    private String m_NonZeroBaselineLabel;
    AxisTemplate m_AxisTempID;
    protected double m_fBaseMax;
    protected double m_fBaseMin;
    protected boolean m_bNonZeroBaseline;
    protected int m_numberOfSteps;
    protected int m_requiredSteps;
    protected int m_axisLengthVC;
    protected int m_axisOrgVC;
    private double m_minBubbleVal;
    private double m_maxBubbleVal;
    private int m_minBubbleSize;
    private int m_maxBubbleSize;
    private double[] m_autoMinMaxArray;
    private Vector m_dates;
    int[][] m_numXCoords;
    boolean m_firstCalc;

    private void $init$() {
        this.m_nParetoSeriesMaximums = new double[this.m_numSeries];
        this.m_nParetoSeriesMinimums = new double[this.m_numSeries];
        this.m_Y2DefaultScaleStep = 10.0;
        this.m_NonZeroBaselineLabel = null;
        this.m_AxisTempID = null;
        this.m_fBaseMax = 0.0;
        this.m_fBaseMin = 0.0;
        this.m_bNonZeroBaseline = false;
        this.m_numberOfSteps = 0;
        this.m_requiredSteps = 0;
        this.m_minBubbleVal = 0.0;
        this.m_maxBubbleVal = 0.0;
        this.m_minBubbleSize = 0;
        this.m_maxBubbleSize = 0;
        this.m_autoMinMaxArray = null;
        this.m_dates = null;
        this.m_firstCalc = false;
    }

    protected RelativeAxisObj(Perspective perspective, Access access, AxisTemplate id, int nOrdinalAxisType, boolean bAscending) {
        this(perspective, access, id, nOrdinalAxisType, bAscending, 0, 100);
        this.m_bNumericAxis = false;
    }

    protected RelativeAxisObj(Perspective perspective, Access access, AxisTemplate id, int nOrdinalAxisType, boolean bAscending, int nAxisOffset, int nAxisSize) {
        super(perspective, access, id, bAscending, nAxisOffset, nAxisSize);
        this.$init$();
        this.m_bNumericAxis = false;
        this.m_AxisTempID = id;
        if (nOrdinalAxisType < 0 || nOrdinalAxisType > 10) {
            throw new AssertionException("RelativeAxisObj Constructor: Invalid parameter passed for OrdinalAxisType");
        }
        this.m_nOrdinalAxisType = nOrdinalAxisType;
        this.m_nNumLabels = 0;
    }

    protected RelativeAxisObj(Perspective perspective, Access access, AxisTemplate id, MinMaxObj minMax, boolean bAscending, int nAxisOffset, int nAxisSize) {
        super(perspective, access, id, bAscending, nAxisOffset, nAxisSize);
        this.$init$();
        this.m_bNumericAxis = true;
        this.m_objMinMax = minMax;
        this.m_nNumLabels = 0;
    }

    public void copyScaleParams() {
        this.m_bLogScale = this.m_Perspective.getLogScale(this.m_template.getAxis());
        this.m_fLogScaleBase = this.m_Perspective.getLogScaleBase(this.m_template.getAxis());
        if (this.m_fLogScaleBase < 2.0) {
            this.m_fLogScaleBase = 2.0;
        }
        if (this.m_fLogScaleBase > 100.0) {
            this.m_fLogScaleBase = 100.0;
        }
        this.m_bAutoMax = this.m_Perspective.getScaleMaxAuto(this.m_template.getAxis());
        this.m_bAutoMin = this.m_Perspective.getScaleMinAuto(this.m_template.getAxis());
        this.m_bAutoStep = this.m_Perspective.getGridStepAuto(this.m_template.getMajor());
        if (this.m_gt.isParetoType()) {
            this.m_fScaleMax = this.getParetoSeriesMaximum(this.m_Perspective.getDisplayParetoSeries());
            this.m_bAutoMax = false;
            this.m_bAutoMin = true;
            this.m_fScaleMin = 0.0;
        } else {
            this.m_fScaleMax = this.m_bAutoMax ? this.m_objMinMax.getAdjMax() : this.m_Perspective.getScaleMax(this.m_template.getAxis());
            double d = this.m_fScaleMin = this.m_bAutoMin ? this.m_objMinMax.getAdjMin() : this.m_Perspective.getScaleMin(this.m_template.getAxis());
            if (this.m_bNonZeroBaseline && this.m_gt.isScalingAbs() && !this.m_gt.isBubble() && !this.m_gt.isScatter()) {
                double fNZBaseline = this.m_Perspective.getNonZeroBaselineValue(this.m_template.getAxis());
                this.m_fBaseMax = this.m_fScaleMax;
                this.m_fBaseMin = this.m_fScaleMin;
                if (!(fNZBaseline <= 0.0) || !this.isLogScale()) {
                    if (fNZBaseline >= this.m_fScaleMax && this.m_bAutoMax) {
                        this.m_fScaleMax = fNZBaseline;
                    } else if (fNZBaseline <= this.m_fScaleMin && this.m_bAutoMin) {
                        this.m_fScaleMin = fNZBaseline;
                    }
                }
            }
        }
        this.m_fScaleStep = this.m_Perspective.getGridStep(this.m_template.getMajor());
        this.m_fMinAutoScaleStep = this.m_Perspective.getMinAutoGridStep(this.m_template.getMajor());
    }

    public void setXCordinates(int[][] XCoords) {
        this.m_numXCoords = XCoords;
    }

    public void setContinuousTimeAxis(boolean timeAxis) {
        this.m_continuousTimeAxis = timeAxis;
    }

    public void calc_init() {
        this.initSeriesTypes();
        this.m_bNonZeroBaseline = this.m_Perspective.getNonZeroBaseline(this.m_template.getAxis());
        if (this.m_bNumericAxis) {
            this.copyScaleParams();
            if (!this.m_objMinMax.isValid() && !this.m_gt.isParetoType()) {
                this.m_fScaleMin = 0.0;
                this.m_fScaleMax = 1.0;
                return;
            }
            this.calcNumericScale();
            this.calcMinorStep();
            this._updateValToRelCoord();
        } else {
            this.calcOrdinalScale();
        }
        this.calcNumLabels();
    }

    public void calc() {
        if (this.m_Perspective.getAxesPreviewMode() && !this.m_bNumericAxis) {
            return;
        }
        if (this.m_Perspective.isAlwaysCalcAxisAutoMinMax() && this.m_bNumericAxis) {
            boolean bX1ScaleMaxAuto = this.m_Perspective.getX1ScaleMaxAuto();
            boolean bX1ScaleMinAuto = this.m_Perspective.getX1ScaleMinAuto();
            boolean bY1ScaleMaxAuto = this.m_Perspective.getY1ScaleMaxAuto();
            boolean bY1ScaleMinAuto = this.m_Perspective.getY1ScaleMinAuto();
            boolean bY2ScaleMaxAuto = this.m_Perspective.getY2ScaleMaxAuto();
            boolean bY2ScaleMinAuto = this.m_Perspective.getY2ScaleMinAuto();
            double x1ScaleMax = this.m_Perspective.getX1ScaleMax();
            double x1ScaleMin = this.m_Perspective.getX1ScaleMin();
            double y1ScaleMax = this.m_Perspective.getY1ScaleMax();
            double y1ScaleMin = this.m_Perspective.getY1ScaleMin();
            double y2ScaleMax = this.m_Perspective.getY2ScaleMax();
            double y2ScaleMin = this.m_Perspective.getY2ScaleMin();
            this.m_Perspective.setX1ScaleMaxAuto(true);
            this.m_Perspective.setX1ScaleMinAuto(true);
            this.m_Perspective.setY1ScaleMaxAuto(true);
            this.m_Perspective.setY1ScaleMinAuto(true);
            this.m_Perspective.setY2ScaleMaxAuto(true);
            this.m_Perspective.setY2ScaleMinAuto(true);
            this.m_firstCalc = true;
            this.calc_init();
            this.m_firstCalc = false;
            this.m_autoMinMaxArray = new double[2];
            if (this.m_bLogScale) {
                this.m_autoMinMaxArray[0] = Math.pow(this.m_fLogScaleBase, this.m_fScaleMin);
                this.m_autoMinMaxArray[1] = Math.pow(this.m_fLogScaleBase, this.m_fScaleMax);
            } else {
                this.m_autoMinMaxArray[0] = this.m_fScaleMin;
                this.m_autoMinMaxArray[1] = this.m_fScaleMax;
            }
            if (!bY1ScaleMinAuto) {
                y1ScaleMin = Math.max(y1ScaleMin, this.m_Perspective.getY1ScaleZoomMin());
            }
            if (!bY1ScaleMaxAuto) {
                y1ScaleMax = Math.min(y1ScaleMax, this.m_Perspective.getY1ScaleZoomMax());
            }
            this.m_Perspective.setX1ScaleMax(x1ScaleMax);
            this.m_Perspective.setX1ScaleMin(x1ScaleMin);
            this.m_Perspective.setY1ScaleMax(y1ScaleMax);
            this.m_Perspective.setY1ScaleMin(y1ScaleMin);
            this.m_Perspective.setY2ScaleMax(y2ScaleMax);
            this.m_Perspective.setY2ScaleMin(y2ScaleMin);
            this.m_Perspective.setX1ScaleMaxAuto(bX1ScaleMaxAuto);
            this.m_Perspective.setX1ScaleMinAuto(bX1ScaleMinAuto);
            this.m_Perspective.setY1ScaleMaxAuto(bY1ScaleMaxAuto);
            this.m_Perspective.setY1ScaleMinAuto(bY1ScaleMinAuto);
            this.m_Perspective.setY2ScaleMaxAuto(bY2ScaleMaxAuto);
            this.m_Perspective.setY2ScaleMinAuto(bY2ScaleMinAuto);
        }
        this.calc_init();
        if (this.m_Perspective.getAxesPreviewMode()) {
            return;
        }
        super.calc();
    }

    protected void calcAutoMinMax() {
        int nScaleFactor = 0;
        double fMin = this.m_fScaleMin;
        double fMax = this.m_fScaleMax;
        if (FP.equal(fMax, 0.0) && FP.equal(fMin, 0.0)) {
            fMax = 1.0;
        } else if (FP.equal(fMax - fMin, 0.0)) {
            fMax *= 1.1;
            fMin /= 1.1;
        } else if (FP.lessThan(fMax - fMin, 0.0)) {
            fMax = Math.max(fMin, fMax);
            fMin = Math.min(fMin, fMax);
        }
        double fSpread = fMax - fMin;
        double fT = Math.log(fSpread) / Math.log(10.0);
        double fTestVal = 0.0;
        double fBaseToUse = this.m_bLogScale ? this.m_fLogScaleBase : 10.0;
        fTestVal = FP.equal(fT - (double)FP.round(fT), 0.0) ? Math.pow(fBaseToUse, fT - 2.0) : Math.pow(fBaseToUse, Math.floor(fT) - 1.0);
        int nFirst2Digits = (int)(fSpread / fTestVal) - 1;
        nScaleFactor = nFirst2Digits >= 9 && nFirst2Digits <= 16 ? 2 : (nFirst2Digits >= 17 && nFirst2Digits <= 29 ? 4 : (nFirst2Digits >= 30 && nFirst2Digits <= 44 ? 5 : (nFirst2Digits >= 45 && nFirst2Digits <= 79 ? 10 : (nFirst2Digits >= 80 && nFirst2Digits <= 99 ? 20 : (nFirst2Digits > 100 ? (fTestVal > 0.0 ? (int)fSpread / 100 / (int)fTestVal : (int)fSpread / 100 / 64) : 1)))));
        if (this.m_fAxisLengthRel < 1.0) {
            double fTemp = nScaleFactor;
            fTemp /= this.m_fAxisLengthRel;
            while (fTemp >= 20.0) {
                fTemp /= (double)10;
                fTestVal *= (double)10;
            }
            nScaleFactor = fTemp < 20.0 && fTemp > 10.0 ? 20 : (fTemp > 5.0 ? 10 : (fTemp > 4.0 ? 5 : (fTemp > 2.0 ? 4 : 2)));
        }
        double fScaleUnit = (double)nScaleFactor * fTestVal;
        double fBot = Math.floor(this.m_fScaleMin / fScaleUnit) * fScaleUnit;
        if (FP.greaterThan(fScaleUnit, 0.0)) {
            while (FP.greaterThan(fBot, this.m_fScaleMax)) {
                fBot -= fScaleUnit;
            }
        }
        if (this.isCurveLinePointCloseToMin(fBot, fScaleUnit)) {
            fBot -= fScaleUnit / 2.0;
        }
        double fTop = fBot;
        if (FP.greaterThan(fScaleUnit, 0.0)) {
            while (FP.lessThan(fTop, fMax)) {
                fTop += fScaleUnit;
            }
        }
        if (this.m_bAutoMin) {
            this.m_fScaleMin = fBot;
        }
        if (this.m_bAutoMax) {
            this.m_fScaleMax = fTop;
        }
        if (this.m_gt.isBubble() && this.getAxisObjID() != 8 && (this.m_bAutoMin || this.m_bAutoMax)) {
            this._calcMinMaxBubblesOnAxis();
            int destBuffer = 2;
            int virtBuffer = 100;
            int buff = 0;
            buff = this.isVertical() ? this.m_Perspective.m_VC.destToVirtHeight(destBuffer) : this.m_Perspective.m_VC.destToVirtWidth(destBuffer);
            if (buff > virtBuffer) {
                virtBuffer = buff;
            }
            int minBubbleSize = this.m_minBubbleSize + 2 * virtBuffer;
            int maxBubbleSize = this.m_maxBubbleSize + 2 * virtBuffer;
            int minBubbleCoord = (int)this.getValueCoord(this.m_minBubbleVal);
            int maxBubbleCoord = (int)this.getValueCoord(this.m_maxBubbleVal);
            int minBubbleEdge = minBubbleCoord - minBubbleSize / 2;
            int maxBubbleEdge = maxBubbleCoord + maxBubbleSize / 2;
            double minBubbleEdgeValue = this.getValueFromCoord(minBubbleEdge);
            double maxBubbleEdgeValue = this.getValueFromCoord(maxBubbleEdge);
            boolean bAdjustMin = this.m_bAutoMin && minBubbleEdgeValue < this.m_fScaleMin;
            boolean bAdjustMax = this.m_bAutoMax && maxBubbleEdgeValue > this.m_fScaleMax;
            boolean bLimitMin = false;
            boolean bLimitMax = false;
            int iterations = 0;
            int maxIterations = 10;
            double origScaleMin = this.m_fScaleMin;
            double origScaleMax = this.m_fScaleMax;
            double origRange = origScaleMax - origScaleMin;
            while ((bAdjustMin || bAdjustMax) && iterations < maxIterations) {
                if (bAdjustMin) {
                    int steps = (int)Math.ceil((this.m_fScaleMin - minBubbleEdgeValue) / fScaleUnit);
                    if ((double)steps * fScaleUnit + (origScaleMin - this.m_fScaleMin) > origRange) {
                        this.m_fScaleMin = origScaleMin - origRange;
                        bAdjustMin = false;
                        bLimitMin = true;
                    } else {
                        this.m_fScaleMin -= (double)steps * fScaleUnit;
                    }
                    if (!bLimitMax) {
                        bAdjustMax = true;
                    }
                    this._updateValToRelCoord();
                    minBubbleCoord = (int)this.getValueCoord(this.m_minBubbleVal);
                    maxBubbleCoord = (int)this.getValueCoord(this.m_maxBubbleVal);
                    minBubbleEdge = minBubbleCoord - minBubbleSize / 2;
                    maxBubbleEdge = maxBubbleCoord + maxBubbleSize / 2;
                    minBubbleEdgeValue = this.getValueFromCoord(minBubbleEdge);
                    maxBubbleEdgeValue = this.getValueFromCoord(maxBubbleEdge);
                    bAdjustMin = bAdjustMin && this.m_bAutoMin && minBubbleEdgeValue < this.m_fScaleMin;
                    boolean bl = bAdjustMax = bAdjustMax && this.m_bAutoMax && maxBubbleEdgeValue > this.m_fScaleMax;
                }
                if (bAdjustMax) {
                    int steps = (int)Math.ceil((maxBubbleEdgeValue - this.m_fScaleMax) / fScaleUnit);
                    if ((double)steps * fScaleUnit + (this.m_fScaleMax - origScaleMax) > origRange) {
                        this.m_fScaleMax = origScaleMax + origRange;
                        bAdjustMax = false;
                        bLimitMax = true;
                    } else {
                        this.m_fScaleMax += (double)steps * fScaleUnit;
                    }
                    if (!bLimitMin) {
                        bAdjustMin = true;
                    }
                    this._updateValToRelCoord();
                    minBubbleCoord = (int)this.getValueCoord(this.m_minBubbleVal);
                    maxBubbleCoord = (int)this.getValueCoord(this.m_maxBubbleVal);
                    minBubbleEdge = minBubbleCoord - minBubbleSize / 2;
                    maxBubbleEdge = maxBubbleCoord + maxBubbleSize / 2;
                    minBubbleEdgeValue = this.getValueFromCoord(minBubbleEdge);
                    maxBubbleEdgeValue = this.getValueFromCoord(maxBubbleEdge);
                    bAdjustMin = bAdjustMin && this.m_bAutoMin && minBubbleEdgeValue < this.m_fScaleMin;
                    bAdjustMax = bAdjustMax && this.m_bAutoMax && maxBubbleEdgeValue > this.m_fScaleMax;
                }
                ++iterations;
            }
        }
        this.m_numberOfSteps = (int)Math.round((this.m_fScaleMax - this.m_fScaleMin) / fScaleUnit);
        if (!(!this.m_bAutoStep || this.m_bAutoMax && this.m_bAutoMin || FP.equal(this.m_fScaleMin + fScaleUnit * (double)this.m_numberOfSteps, this.m_fScaleMax))) {
            double minMaxDiff = this.m_fScaleMax - this.m_fScaleMin;
            if (nScaleFactor == 20) {
                nScaleFactor = 15;
            }
            int i = nScaleFactor;
            while (i > 0) {
                double tempfScaleUnit = (double)i * fTestVal;
                double numberOfSteps = (int)Math.ceil(minMaxDiff / tempfScaleUnit);
                if (numberOfSteps > 100.0) break;
                double newMaxVal = this.m_fScaleMin + tempfScaleUnit * numberOfSteps;
                boolean evenIntevals = FP.equal(newMaxVal, this.m_fScaleMax);
                if (evenIntevals) {
                    if (!this.m_bNonZeroBaseline && this.m_fScaleMin < 0.0 && this.m_fScaleMax > 0.0) {
                        double minDivStep = this.m_fScaleMin / tempfScaleUnit;
                        double minDivStepRnd = Math.round(this.m_fScaleMin / tempfScaleUnit);
                        if (FP.equal(minDivStep, minDivStepRnd)) {
                            fScaleUnit = tempfScaleUnit;
                            nScaleFactor = i;
                            break;
                        }
                        evenIntevals = false;
                    } else {
                        fScaleUnit = tempfScaleUnit;
                        nScaleFactor = i;
                        break;
                    }
                }
                --i;
            }
        }
        if (this.m_bAutoStep) {
            if (this.m_fMinAutoScaleStep != 0.0) {
                this.m_fScaleStep = fScaleUnit > this.m_fMinAutoScaleStep ? (!FP.equal(fScaleUnit % this.m_fMinAutoScaleStep, 0.0) ? fScaleUnit - fScaleUnit % this.m_fMinAutoScaleStep : fScaleUnit) : (fScaleUnit < this.m_fMinAutoScaleStep && this.m_fMinAutoScaleStep <= this.m_fScaleMax - this.m_fScaleMin ? this.m_fMinAutoScaleStep : fScaleUnit);
                if (this.m_bAutoMin && this.m_fScaleMin > 0.0) {
                    this.m_fScaleMin -= this.m_fScaleMin % this.m_fMinAutoScaleStep;
                }
                if (this.m_bAutoMax && this.m_fScaleMax > 0.0 && this.m_fScaleMax % this.m_fMinAutoScaleStep != 0.0) {
                    this.m_fScaleMax = this.m_fScaleMax - this.m_fScaleMax % this.m_fMinAutoScaleStep + this.m_fMinAutoScaleStep;
                }
                if (this.m_bAutoMin && this.m_fScaleMin < 0.0 && this.m_fScaleMin % this.m_fMinAutoScaleStep != 0.0) {
                    this.m_fScaleMin = this.m_fScaleMin - this.m_fScaleMin % this.m_fMinAutoScaleStep - this.m_fMinAutoScaleStep;
                }
                if (this.m_bAutoMax && this.m_fScaleMax < 0.0) {
                    this.m_fScaleMax -= this.m_fScaleMax % this.m_fMinAutoScaleStep;
                }
                if (fScaleUnit < this.m_fMinAutoScaleStep && this.m_fMinAutoScaleStep <= this.m_fScaleMax - this.m_fScaleMin) {
                    this.m_fScaleStep = this.m_fMinAutoScaleStep;
                }
            } else {
                this.m_fScaleStep = fScaleUnit;
            }
        }
        this.m_numberOfSteps = (int)Math.round((this.m_fScaleMax - this.m_fScaleMin) / this.m_fScaleStep);
        if (!this.m_Perspective.getBooleanProp(Attr.AlignTickMarks) || !this.m_gt.isDualY() || this.m_gt.isParetoType() || this.m_gt.isParetoType() || this.m_gt.isStockType() || this.m_gt.isBipolar()) {
            return;
        }
        boolean mustIncludeZero = false;
        if (this.m_template == AxisTemplate.Y2_AXIS) {
            mustIncludeZero = this.m_Perspective.getY2MustIncludeZero();
        } else if (this.m_template == AxisTemplate.Y1_AXIS) {
            mustIncludeZero = this.m_Perspective.getY1MustIncludeZero();
        }
        boolean adjustMinMax = false;
        if (this.m_requiredSteps != 0 && (this.m_numberOfSteps >= this.m_requiredSteps && this.m_numberOfSteps % this.m_requiredSteps != 0 || this.m_requiredSteps >= this.m_numberOfSteps && this.m_requiredSteps % this.m_numberOfSteps != 0)) {
            if (this.m_bAutoStep) {
                double newStepVal = (this.m_fScaleMax - this.m_fScaleMin) / (double)this.m_requiredSteps;
                if (this.m_fMinAutoScaleStep != 0.0 && (newStepVal < this.m_fMinAutoScaleStep || !FP.equal(newStepVal % this.m_fMinAutoScaleStep, 0.0))) {
                    adjustMinMax = true;
                }
                if (!adjustMinMax) {
                    double minDivStepRnd;
                    double minDivStep;
                    double newScaleFactor = Math.ceil(newStepVal / fTestVal);
                    double m_fScaleStepOld = this.m_fScaleStep;
                    double m_fScaleMaxOld = this.m_fScaleMax;
                    double m_fScaleMinOld = this.m_fScaleMin;
                    if (this.m_bAutoMax && this.m_fScaleMax != 0.0) {
                        this.m_fScaleStep = newScaleFactor * fTestVal;
                        this.m_fScaleMax = this.m_fScaleMin + this.m_fScaleStep * (double)this.m_requiredSteps;
                    } else if (this.m_bAutoMin && this.m_fScaleMin != 0.0) {
                        this.m_fScaleStep = newScaleFactor * fTestVal;
                        this.m_fScaleMin = this.m_fScaleMax - this.m_fScaleStep * (double)this.m_requiredSteps;
                    } else {
                        this.m_fScaleStep = newStepVal;
                    }
                    if (!this.m_bNonZeroBaseline && this.m_fScaleMin < 0.0 && this.m_fScaleMax > 0.0 && !FP.equal(minDivStep = this.m_fScaleMin / this.m_fScaleStep, minDivStepRnd = (double)Math.round(this.m_fScaleMin / this.m_fScaleStep))) {
                        adjustMinMax = true;
                        this.m_fScaleStep = m_fScaleStepOld;
                        this.m_fScaleMax = m_fScaleMaxOld;
                        this.m_fScaleMin = m_fScaleMinOld;
                    }
                }
            }
            if (adjustMinMax || !this.m_bAutoStep) {
                if (this.m_numberOfSteps > this.m_requiredSteps) {
                    int n = 2;
                    while (this.m_numberOfSteps >= this.m_requiredSteps) {
                        this.m_requiredSteps *= n++;
                    }
                }
                if (this.m_requiredSteps > 100) {
                    return;
                }
                if (this.m_bAutoMax && this.m_bAutoMin) {
                    if (mustIncludeZero && this.m_fScaleMin == 0.0) {
                        this.m_fScaleMax = this.m_fScaleMin + this.m_fScaleStep * (double)this.m_requiredSteps;
                    } else {
                        int diff = this.m_requiredSteps - this.m_numberOfSteps;
                        int eachSide = diff / 2;
                        int topSide = eachSide + diff % 2;
                        this.m_fScaleMax += this.m_fScaleStep * (double)topSide;
                        this.m_fScaleMin -= this.m_fScaleStep * (double)eachSide;
                    }
                } else if (this.m_bAutoMax) {
                    this.m_fScaleMax = this.m_fScaleMin + this.m_fScaleStep * (double)this.m_requiredSteps;
                } else if (this.m_bAutoMin) {
                    this.m_fScaleMin = this.m_fScaleMax - this.m_fScaleStep * (double)this.m_requiredSteps;
                }
            }
        }
    }

    protected boolean isCurveLinePointCloseToMin(double fBot, double fScaleUnit) {
        boolean changeMin = false;
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        int s = 0;
        int g = 0;
        DataFormat df = this.m_Access.getDataFormat();
        while (sEnum.hasMoreElements()) {
            s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_numTotalSeries);
            int axis = this.m_Perspective.getAxisAssignment(s);
            if (this.m_Perspective.getLineType(new IdentObj(-3, s)) != 1) continue;
            gEnum.reset();
            block3: while (gEnum.hasMoreElements()) {
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_numTotalGroups);
                int nItems = df.getNumDataItems();
                int i = 0;
                while (i < nItems) {
                    DataItem item = df.getDataItem(i);
                    if (!item.ignoreInScaling() && AxisTemplate.isSameType(item.getAssocAxis(), axis)) {
                        try {
                            DatumObj dObj = new DatumObj(this.m_Access.getDataAsDouble(s, g, item, false), true);
                            double fValue = dObj.m_fValue;
                            if (fValue < fBot + fScaleUnit / 2.0) {
                                changeMin = true;
                                continue block3;
                            }
                        }
                        catch (AssertionException ae) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
        }
        return changeMin;
    }

    private void calcLogScale() {
        double fT = Math.log(this.m_fScaleMin) / Math.log(this.m_fLogScaleBase);
        this.m_fScaleMin = Math.floor(fT);
        fT = Math.log(this.m_fScaleMax) / Math.log(this.m_fLogScaleBase);
        this.m_fScaleMax = Math.ceil(fT);
        if (this.m_gt.isBubble() && this.getAxisObjID() != 8 && (this.m_bAutoMin || this.m_bAutoMax)) {
            this._calcMinMaxBubblesOnAxis();
            int destBuffer = 2;
            int virtBuffer = 100;
            int buff = 0;
            buff = this.isVertical() ? this.m_Perspective.m_VC.destToVirtHeight(destBuffer) : this.m_Perspective.m_VC.destToVirtWidth(destBuffer);
            if (buff > virtBuffer) {
                virtBuffer = buff;
            }
            int minBubbleSize = this.m_minBubbleSize + 2 * virtBuffer;
            int maxBubbleSize = this.m_maxBubbleSize + 2 * virtBuffer;
            int minBubbleCoord = (int)this.getValueCoord(this.m_minBubbleVal);
            int maxBubbleCoord = (int)this.getValueCoord(this.m_maxBubbleVal);
            int minBubbleEdge = minBubbleCoord - minBubbleSize / 2;
            int maxBubbleEdge = maxBubbleCoord + maxBubbleSize / 2;
            double minBubbleEdgeValue = this.getValueFromCoord(minBubbleEdge);
            double maxBubbleEdgeValue = this.getValueFromCoord(maxBubbleEdge);
            boolean bAdjustMin = this.m_bAutoMin && minBubbleEdgeValue < Math.pow(this.m_fLogScaleBase, this.m_fScaleMin);
            boolean bAdjustMax = this.m_bAutoMax && maxBubbleEdgeValue > Math.pow(this.m_fLogScaleBase, this.m_fScaleMax);
            boolean bLimitMin = false;
            boolean bLimitMax = false;
            int iterations = 0;
            int maxIterations = 10;
            double origScaleMin = this.m_fScaleMin;
            double origScaleMax = this.m_fScaleMax;
            double origRange = origScaleMax - origScaleMin;
            while ((bAdjustMin || bAdjustMax) && iterations < maxIterations) {
                if (bAdjustMin) {
                    fT = Math.log(this.getValueFromCoord(minBubbleEdge)) / Math.log(this.m_fLogScaleBase);
                    double newMin = Math.floor(fT);
                    if (newMin < origScaleMin - origRange) {
                        this.m_fScaleMin = origScaleMin - origRange;
                        bAdjustMin = false;
                        bLimitMin = true;
                    } else {
                        this.m_fScaleMin = newMin;
                    }
                    if (!bLimitMax) {
                        bAdjustMax = true;
                    }
                    this._updateValToRelCoord();
                    minBubbleCoord = (int)this.getValueCoord(this.m_minBubbleVal);
                    maxBubbleCoord = (int)this.getValueCoord(this.m_maxBubbleVal);
                    minBubbleEdge = minBubbleCoord - minBubbleSize / 2;
                    maxBubbleEdge = maxBubbleCoord + maxBubbleSize / 2;
                    minBubbleEdgeValue = this.getValueFromCoord(minBubbleEdge);
                    maxBubbleEdgeValue = this.getValueFromCoord(maxBubbleEdge);
                    bAdjustMin = bAdjustMin && this.m_bAutoMin && minBubbleEdgeValue < Math.pow(this.m_fLogScaleBase, this.m_fScaleMin);
                    boolean bl = bAdjustMax = bAdjustMax && this.m_bAutoMax && maxBubbleEdgeValue > Math.pow(this.m_fLogScaleBase, this.m_fScaleMax);
                }
                if (bAdjustMax) {
                    fT = Math.log(this.getValueFromCoord(maxBubbleEdge)) / Math.log(this.m_fLogScaleBase);
                    double newMax = Math.ceil(fT);
                    if (newMax > origScaleMax + origRange) {
                        this.m_fScaleMax = origScaleMax + origRange;
                        bAdjustMax = false;
                        bLimitMax = true;
                    } else {
                        this.m_fScaleMax = newMax;
                    }
                    if (!bLimitMin) {
                        bAdjustMin = true;
                    }
                    this._updateValToRelCoord();
                    minBubbleCoord = (int)this.getValueCoord(this.m_minBubbleVal);
                    maxBubbleCoord = (int)this.getValueCoord(this.m_maxBubbleVal);
                    minBubbleEdge = minBubbleCoord - minBubbleSize / 2;
                    maxBubbleEdge = maxBubbleCoord + maxBubbleSize / 2;
                    minBubbleEdgeValue = this.getValueFromCoord(minBubbleEdge);
                    maxBubbleEdgeValue = this.getValueFromCoord(maxBubbleEdge);
                    bAdjustMin = bAdjustMin && this.m_bAutoMin && minBubbleEdgeValue < Math.pow(this.m_fLogScaleBase, this.m_fScaleMin);
                    bAdjustMax = bAdjustMax && this.m_bAutoMax && maxBubbleEdgeValue > Math.pow(this.m_fLogScaleBase, this.m_fScaleMax);
                }
                ++iterations;
            }
        }
        this.m_fScaleStep = 1.0;
        this.m_fMinorStep = 0.1;
        if (!this.m_gt.isDualY() || this.m_gt.isParetoType() || this.m_gt.isParetoType() || this.m_gt.isStockType() || this.m_gt.isBipolar()) {
            return;
        }
        this.m_numberOfSteps = (int)(this.m_fScaleMax - this.m_fScaleMin);
        this.m_fScaleStep = 1.0;
        if (this.m_requiredSteps != 0 && (this.m_numberOfSteps >= this.m_requiredSteps && this.m_numberOfSteps % this.m_requiredSteps != 0 || this.m_requiredSteps >= this.m_numberOfSteps && this.m_requiredSteps % this.m_numberOfSteps != 0)) {
            if (this.m_bAutoMin) {
                if (this.m_numberOfSteps > this.m_requiredSteps) {
                    int n = 2;
                    while (this.m_numberOfSteps >= this.m_requiredSteps) {
                        this.m_requiredSteps *= n++;
                    }
                }
                this.m_fScaleMin = this.m_fScaleMax - this.m_fScaleStep * (double)this.m_requiredSteps;
            } else if (this.m_bAutoMax) {
                if (this.m_numberOfSteps > this.m_requiredSteps) {
                    int n = 2;
                    while (this.m_numberOfSteps >= this.m_requiredSteps) {
                        this.m_requiredSteps *= n++;
                    }
                }
                this.m_fScaleMax = this.m_fScaleMin + this.m_fScaleStep * (double)this.m_requiredSteps;
            }
        }
    }

    protected void calcOrdinalScale() {
        this.calcOrdinalScaleGroupSpacing();
        this.calcOrdinalScaleRiserSpacing();
    }

    protected void calcRiserWidth() {
        JChart_2D_Standard chartBase = (JChart_2D_Standard)this.m_Perspective.getGraphObject();
        if (chartBase.isComboWithBar()) {
            this.m_fRiserWidth = 300.0;
            double extra = (this.m_fScaleMax - this.m_fScaleMin) * this.m_fRiserWidth / (double)this.m_axisLengthVC;
            this.m_fScaleMin -= extra / 2.0;
            this.m_fScaleMax += extra / 2.0;
        }
    }

    protected void calcOrdinalScaleRiserSpacing() {
        switch (this.m_nOrdinalAxisType) {
            case 0: {
                this.calcOrdinalScaleRiserSpacingSideBySide();
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                this.m_fRiserWidth = this.m_nSpaceBetGroups * (double)this.m_Perspective.getRiserWidth() / 100.0;
                this.m_nSpaceBetSeries = 0.0;
                this.m_nOffsetBetGroupPosAndFirstSeries = (this.m_nSpaceBetGroups - this.m_fRiserWidth) / 2.0;
                break;
            }
            case 3: {
                double fMaxRiserWidth = this.m_nSpaceBetGroups / 2.0;
                double fRiserWidth = fMaxRiserWidth * (double)this.m_Perspective.getRiserWidth() / 100.0;
                double fMaxRiserGap = this.m_nSpaceBetGroups - 2.0 * fRiserWidth;
                double fRiserGap = fMaxRiserGap * (double)this.m_Perspective.getRiserBarGroupSpacing() / 100.0;
                this.m_fRiserWidth = this.m_nSpaceBetGroups * (double)this.m_Perspective.getRiserWidth() / 100.0 / 2.0;
                this.m_nSpaceBetSeries = fRiserWidth + fRiserGap;
                this.m_nOffsetBetGroupPosAndFirstSeries = (this.m_nSpaceBetGroups - 2.0 * fRiserWidth - fRiserGap) / 2.0;
                break;
            }
            case 10: {
                this.m_fRiserWidth = this.m_nSpaceBetGroups * (double)this.m_Perspective.getRiserWidth() / 100.0;
                this.m_nSpaceBetSeries = 0.0;
                this.m_nOffsetBetGroupPosAndFirstSeries = this.m_nSpaceBetGroups / 2.0;
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                this.m_fRiserWidth = this.m_nSpaceBetGroups;
                this.m_nSpaceBetSeries = 0.0;
                this.m_nOffsetBetGroupPosAndFirstSeries = this.m_nSpaceBetGroups / 2.0;
                break;
            }
        }
    }

    protected void calcOrdinalScaleRiserSpacingSideBySide() {
        int nComboAdjustedNumSeries = this.getComboAdjustedNumSeries();
        int temp = this.m_numSeries;
        this.m_fRiserWidth = this.m_nSpaceBetGroups * (double)this.m_Perspective.getRiserWidth() / 100.0 / (double)nComboAdjustedNumSeries;
        double fMaxRiserWidth = this.m_nSpaceBetGroups / (double)nComboAdjustedNumSeries;
        double fRiserWidth = fMaxRiserWidth * (double)this.m_Perspective.getRiserWidth() / 100.0;
        double fMaxRiserGap = this.m_numSeries > 1 ? (nComboAdjustedNumSeries == 1 ? 0.2 : (this.m_nSpaceBetGroups - fRiserWidth) / (double)(nComboAdjustedNumSeries - 1) - fRiserWidth) : this.m_nSpaceBetGroups - fRiserWidth;
        double fRiserGap = fMaxRiserGap * (double)this.m_Perspective.getRiserBarGroupSpacing() / 100.0;
        this.m_nSpaceBetSeries = fRiserWidth + fRiserGap;
        this.m_nOffsetBetGroupPosAndFirstSeries = this.m_numSeries > 1 ? (this.m_nSeriesTypes == null ? (this.m_nSpaceBetGroups - (double)nComboAdjustedNumSeries * fRiserWidth - (double)(nComboAdjustedNumSeries - 1) * fRiserGap) / 2.0 : (this.m_nSpaceBetGroups - (double)nComboAdjustedNumSeries * fRiserWidth - (double)(nComboAdjustedNumSeries - 1) * fRiserGap) / 2.0) : (this.m_nSpaceBetGroups - fRiserWidth) / 2.0;
        this.m_numSeries = temp;
    }

    protected int getComboAdjustedNumSeries() {
        int nComboAdjustedNumSeries = this.m_numSeries;
        if (this.m_numSeries > 1 && this.m_nSeriesTypes != null) {
            int nNumNonBaseRiserTypes = 0;
            int nSeries = 0;
            while (nSeries < this.m_numSeries) {
                if (this.m_nSeriesTypes[nSeries] != this.m_nBaseRiserType) {
                    ++nNumNonBaseRiserTypes;
                }
                ++nSeries;
            }
            nComboAdjustedNumSeries = this.m_numSeries - nNumNonBaseRiserTypes;
        }
        return nComboAdjustedNumSeries;
    }

    protected void calcOrdinalScaleGroupSpacing() {
        if (this.isO1WithNestedLabels()) {
            int nlbs = this.isO1WithNestedLabels() && this.m_cbO1Labels != null ? this.m_cbO1Labels.getNumLabelsOnLevel(0) : this.m_nNumLabels;
            if (this.m_nOrdinalAxisType == 6) {
                if (nlbs > 1) {
                    this.m_nSpaceBetGroups = this.m_fAxisLengthRel / (double)(nlbs - 1);
                    this.m_nLeftPosFirstGroup = -this.m_nSpaceBetGroups / 2.0;
                } else {
                    this.m_nSpaceBetGroups = 0.5;
                    this.m_nLeftPosFirstGroup = 0.5;
                }
            } else {
                this.m_nSpaceBetGroups = this.m_fAxisLengthRel / (double)nlbs;
                this.m_nLeftPosFirstGroup = 0.0;
            }
        } else if (this.m_nOrdinalAxisType == 6) {
            if (this.m_numGroups > 1) {
                this.m_nSpaceBetGroups = this.m_fAxisLengthRel / (double)(this.m_numGroups - 1);
                this.m_nLeftPosFirstGroup = -this.m_nSpaceBetGroups / 2.0;
            } else {
                this.m_nSpaceBetGroups = 0.5;
                this.m_nLeftPosFirstGroup = 0.5;
            }
        } else if (this.m_nOrdinalAxisType == 9) {
            if (this.m_numGroups > 1) {
                this.m_nSpaceBetGroups = this.m_fAxisLengthRel / (double)this.m_numGroups;
                this.m_nLeftPosFirstGroup = -this.m_nSpaceBetGroups / 2.0;
            } else {
                this.m_nSpaceBetGroups = 0.0;
                this.m_nLeftPosFirstGroup = 0.0;
            }
        } else if (this.useSeriesLabels()) {
            this.m_nSpaceBetGroups = this.m_fAxisLengthRel / (double)this.m_numSeries;
            this.m_nLeftPosFirstGroup = 0.0;
        } else {
            this.m_nSpaceBetGroups = this.m_fAxisLengthRel / (double)this.m_numGroups;
            this.m_nLeftPosFirstGroup = 0.0;
        }
    }

    protected double getBaseRelCoord() {
        if (this.m_bLogScale) {
            return this.getValueRelCoord(Math.pow(this.m_fLogScaleBase, this.m_fScaleMin));
        }
        return this.getValueRelCoord(this.m_fScaleMin);
    }

    public double getCenterRelCoord(int g) {
        double offset;
        if (this.isO1WithNestedLabels() && this.m_cbO1Labels != null && this.m_nNestingLevel != 0) {
            int num = this.m_cbO1Labels.getParentIndex(g, this.m_nNestingLevel);
            offset = this.m_nLeftPosFirstGroup + (double)num * this.m_nSpaceBetGroups;
            if (this.m_nOrdinalAxisType == 6) {
                offset = this.m_nLeftPosFirstGroup + (double)num * this.m_nSpaceBetGroups + this.m_nSpaceBetGroups / 2.0;
            }
        } else {
            offset = this.m_Perspective.isContinuousTimeAxis() ? this.m_nLeftPosFirstGroup + (double)this.m_numXCoords[0][g] + this.m_nSpaceBetGroups / 2.0 : this.m_nLeftPosFirstGroup + (double)g * this.m_nSpaceBetGroups + this.m_nSpaceBetGroups / 2.0;
        }
        if (this.m_bAscending) {
            return this.m_fAxisPositionRel + offset;
        }
        return this.m_fAxisPositionRel + this.m_fAxisLengthRel - offset;
    }

    public double getCenterRelCoord(int s, int g) {
        double offset;
        if (this.isO1WithNestedLabels() && this.m_cbO1Labels != null && this.m_nNestingLevel != 0) {
            int num = this.m_cbO1Labels.getParentIndex(g, this.m_nNestingLevel);
            offset = this.m_nLeftPosFirstGroup + (double)num * this.m_nSpaceBetGroups;
            if (this.m_nOrdinalAxisType == 6) {
                offset = this.m_nLeftPosFirstGroup + (double)num * this.m_nSpaceBetGroups + this.m_nSpaceBetGroups / 2.0;
            }
        } else {
            offset = this.m_Perspective.isContinuousTimeAxis() ? this.m_nLeftPosFirstGroup + (double)this.m_numXCoords[s][g] + this.m_nSpaceBetGroups / 2.0 : this.m_nLeftPosFirstGroup + (double)g * this.m_nSpaceBetGroups + this.m_nSpaceBetGroups / 2.0;
        }
        if (this.m_bAscending) {
            return this.m_fAxisPositionRel + offset;
        }
        return this.m_fAxisPositionRel + this.m_fAxisLengthRel - offset;
    }

    public double getCenterRelCoord(double g) {
        int nGroup = (int)g;
        double fResult = this.getCenterRelCoord(nGroup);
        return fResult;
    }

    public double getCenterRelCoord(double s, double g) {
        int nGroup = (int)g;
        double fResult = this.getCenterRelCoord(s, (double)nGroup);
        return fResult;
    }

    protected int getGroupAboveRelCoord(double fCoord) {
        if (!this.m_bNumericAxis) {
            int nGroup;
            if (this.isAscending()) {
                double fGroup = (fCoord - this.m_nLeftPosFirstGroup - this.m_nSpaceBetGroups / 2.0) / this.m_nSpaceBetGroups;
                nGroup = (int)Math.ceil(fGroup - this.m_nSpaceBetGroups * 1.0E-4);
            } else {
                double fGroup = (1.0 - fCoord - this.m_nLeftPosFirstGroup - this.m_nSpaceBetGroups / 2.0) / this.m_nSpaceBetGroups;
                nGroup = (int)Math.floor(fGroup + this.m_nSpaceBetGroups * 1.0E-4);
            }
            if (nGroup < 0) {
                nGroup = 0;
            } else if (nGroup >= this.m_numTotalGroups) {
                nGroup = this.m_numTotalGroups - 1;
            }
            return nGroup;
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    protected int getGroupBelowRelCoord(double fCoord) {
        if (!this.m_bNumericAxis) {
            int nGroup;
            if (this.isAscending()) {
                double fGroup = (fCoord - this.m_nLeftPosFirstGroup - this.m_nSpaceBetGroups / 2.0) / this.m_nSpaceBetGroups;
                nGroup = (int)Math.floor(fGroup + this.m_nSpaceBetGroups * 1.0E-4);
            } else {
                double fGroup = (1.0 - fCoord - this.m_nLeftPosFirstGroup - this.m_nSpaceBetGroups / 2.0) / this.m_nSpaceBetGroups;
                nGroup = (int)Math.ceil(fGroup - this.m_nSpaceBetGroups * 1.0E-4);
            }
            if (nGroup < 0) {
                nGroup = 0;
            } else if (nGroup >= this.m_numTotalGroups) {
                nGroup = this.m_numTotalGroups - 1;
            }
            return nGroup;
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    protected int getGroupAboveRelCoordForZoom(double fCoord) {
        if (!this.m_bNumericAxis) {
            int nGroup;
            if (this.isAscending()) {
                double fGroup = (fCoord - this.m_nLeftPosFirstGroup - this.m_nSpaceBetGroups / 2.0) / this.m_nSpaceBetGroups;
                nGroup = (int)Math.ceil(fGroup - this.m_nSpaceBetGroups * 1.0E-4);
            } else {
                double fGroup = (1.0 - fCoord - this.m_nLeftPosFirstGroup - this.m_nSpaceBetGroups / 2.0) / this.m_nSpaceBetGroups;
                nGroup = (int)Math.floor(fGroup + this.m_nSpaceBetGroups * 1.0E-4);
            }
            if (nGroup >= this.m_numTotalGroups) {
                nGroup = this.m_numTotalGroups - 1;
            }
            return nGroup;
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    protected int getGroupBelowRelCoordForZoom(double fCoord) {
        if (!this.m_bNumericAxis) {
            int nGroup;
            if (this.isAscending()) {
                double fGroup = (fCoord - this.m_nLeftPosFirstGroup - this.m_nSpaceBetGroups / 2.0) / this.m_nSpaceBetGroups;
                nGroup = (int)Math.floor(fGroup + this.m_nSpaceBetGroups * 1.0E-4);
            } else {
                double fGroup = (1.0 - fCoord - this.m_nLeftPosFirstGroup - this.m_nSpaceBetGroups / 2.0) / this.m_nSpaceBetGroups;
                nGroup = (int)Math.ceil(fGroup - this.m_nSpaceBetGroups * 1.0E-4);
            }
            if (nGroup >= this.m_numTotalGroups) {
                nGroup = this.m_numTotalGroups - 1;
            }
            return nGroup;
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    protected double getHighRelCoord(int s, int g) {
        return this.getLowRelCoord(s, g) + this.m_fRiserWidth;
    }

    public double getIntervalStart(int nInterval) {
        if (this.m_bNumericAxis) {
            return this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + this.m_fScaleStep * (double)nInterval) : this.m_fScaleMin + this.m_fScaleStep * (double)nInterval;
        }
        throw new AssertionException("Numeric Axis method call on ordinal axis");
    }

    public double getIntervalStop(int nInterval) {
        if (this.m_bNumericAxis) {
            return this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + this.m_fScaleStep * (double)(nInterval + 1)) : this.m_fScaleMin + this.m_fScaleStep * (double)(nInterval + 1);
        }
        throw new AssertionException("Numeric Axis method call on ordinal axis");
    }

    protected double getLabelRelPos(int nIndex) {
        if (this.m_bNumericAxis) {
            return this.getMajorGridPos(nIndex);
        }
        return this.getCenterRelCoord(nIndex);
    }

    protected double getLowRelCoord(double fSeries, double fGroup) {
        int nSeries = (int)fSeries;
        int nGroup = (int)fGroup;
        double fResult = this.getLowRelCoord(nSeries, nGroup);
        return fResult;
    }

    protected void initSeriesTypes() {
        this.m_nSeriesTypes = this.m_Perspective.getSeriesTypes();
        this.m_nBaseRiserType = this.m_Perspective.getBaseRiserType();
        this.m_bIsComboChart = false;
        int nSeries = 0;
        while (nSeries < this.m_Perspective.getNumTotalSeries()) {
            if (this.m_nSeriesTypes[nSeries] != this.m_nBaseRiserType) {
                this.m_bIsComboChart = true;
            }
            ++nSeries;
        }
    }

    protected double getLowRelCoord(int s, int g) {
        if (this.m_bNumericAxis) {
            double fLowRelCoord = this.getCenterRelCoord(s, g) - this.m_fRiserWidth / 2.0;
            return fLowRelCoord;
        }
        int gt = this.m_Perspective.getGraphType();
        double fGroupBegin = gt >= 41 && gt <= 47 || gt >= 31 && gt <= 35 ? (double)g * this.m_nSpaceBetGroups : (double)g * this.m_nSpaceBetGroups + this.m_nOffsetBetGroupPosAndFirstSeries;
        double fLowRelCoord = 0.0;
        PfjAssert.pfjAssert(this.m_nSeriesTypes != null);
        boolean isDualYStacked = false;
        if (this.m_gt.getIntegerGraphType() == 20 || this.m_gt.getIntegerGraphType() == 27) {
            isDualYStacked = true;
        }
        if (this.m_nSeriesTypes[s] == this.m_nBaseRiserType || isDualYStacked) {
            fLowRelCoord = this.adjustLowRelForComboCharts(fGroupBegin, s, g);
            if (this.m_nOrdinalAxisType == 2) {
                fLowRelCoord -= this.m_fRiserWidth / 2.0;
            }
            fLowRelCoord = this.m_bAscending ? this.m_fAxisPositionRel + fLowRelCoord : this.m_fAxisPositionRel + this.m_fAxisLengthRel - fLowRelCoord - this.m_fRiserWidth;
        } else {
            JGraphType graphType = this.m_Perspective.getJGraphType();
            fLowRelCoord = this.getCenterRelCoord(g) - this.m_fRiserWidth / 2.0;
            if (this.m_nOrdinalAxisType == 2) {
                fLowRelCoord -= this.m_fRiserWidth / 2.0;
            }
        }
        return fLowRelCoord;
    }

    protected double adjustLowRelForComboCharts(double fGroupBegin, int s, int g) {
        double fLowRelCoord = fGroupBegin;
        if (this.m_bIsComboChart && this.m_nSeriesTypes != null) {
            int nSeries = 0;
            while (nSeries < s) {
                if (this.m_nSeriesTypes[nSeries] == this.m_nBaseRiserType || this.m_gt.getIntegerGraphType() == 20 || this.m_gt.getIntegerGraphType() == 27) {
                    fLowRelCoord += this.m_nSpaceBetSeries;
                }
                ++nSeries;
            }
        } else {
            fLowRelCoord = fGroupBegin + (double)s * this.m_nSpaceBetSeries;
        }
        return fLowRelCoord;
    }

    protected double getMajorGridPos(int nIndex) {
        if (this.m_bNumericAxis && !this.m_continuousTimeAxis) {
            return this.getValueRelCoord(this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + this.m_fScaleStep * (double)nIndex) : this.m_fScaleMin + this.m_fScaleStep * (double)nIndex);
        }
        if (this.m_continuousTimeAxis) {
            if (this.m_cbO1Labels != null && this.m_nNestingLevel != 0) {
                int num = this.m_cbO1Labels.getParentIndex(nIndex, this.m_nNestingLevel);
                return this.getValueRelCoord(((Date)this.m_dates.get(num)).getTime());
            }
            return this.getValueRelCoord(((Date)this.m_dates.get(nIndex)).getTime());
        }
        if (this.m_nOrdinalAxisType == 6 || this.m_nOrdinalAxisType == 9) {
            return this.getCenterRelCoord(nIndex);
        }
        double fPos = this.getCenterRelCoord(nIndex - 1);
        double fDelta = 0.0;
        fDelta = this.m_nOrdinalAxisType == 2 ? this.m_nSpaceBetGroups : this.m_nSpaceBetGroups / 2.0;
        fPos = this.m_bAscending ? (fPos += fDelta) : (fPos -= fDelta);
        return fPos;
    }

    protected double getMinorGridPos(int nMajorIndex, int nMinorIndex) {
        if (this.m_bNumericAxis) {
            double fVal = this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + (double)nMajorIndex) * (double)(nMinorIndex + 2) : this.m_fScaleMin + this.m_fScaleStep * (double)nMajorIndex + this.m_fMinorStep * (double)(nMinorIndex + 1);
            return this.getValueRelCoord(fVal);
        }
        double minorStep = this.m_nSpaceBetGroups / (double)(this.getNumMinorGrids() + 1);
        return this.getMajorGridPos(nMajorIndex) + minorStep * (double)(nMinorIndex + 1);
    }

    Vector getNumericLabels() {
        Vector<String> vectStrLabels;
        block11: {
            PfjAssert.pfjAssert(this.m_bNumericAxis);
            vectStrLabels = null;
            boolean bExists = false;
            if (!this.m_bNumericAxis) break block11;
            vectStrLabels = new Vector<String>(this.getNumLabels());
            IdentObj id = new IdentObj(this.m_template.getLabel());
            int nFormat = this.m_Perspective.getTextFormatPreset(id);
            String szFormatPattern = this.m_Perspective.getTextFormatPattern(id);
            if (nFormat == 0 && this.m_gt.isPercent()) {
                nFormat = 2;
            }
            if (this.isY2Axis() && this.m_gt.isParetoType()) {
                nFormat = 23;
                int j = 0;
                while (j < this.getNumLabels()) {
                    String szLabel = TDGNumberFormat.toString(this.m_Perspective, nFormat, MathExt.sigdigits((double)j * this.m_Y2DefaultScaleStep, 10), szFormatPattern);
                    if (this.m_Perspective.isNumberFormatCallBack()) {
                        NumberFormatCallBack nfcb = this.m_Perspective.getNumberFormatCallBack();
                        nfcb.setAxisMin(this.getMinValue());
                        nfcb.setAxisMax(this.getMaxValue());
                        nfcb.setAxisStep(this.getStepValue());
                        int nAxisID = this.m_template.getAxisObjID();
                        nfcb.setState(0, -3, -3, nAxisID, j);
                        double d = Double.parseDouble(szLabel) / 100.0;
                        szLabel = nfcb.toString(d);
                    }
                    vectStrLabels.addElement(szLabel);
                    ++j;
                }
            } else {
                int i = 0;
                while (i < this.getNumLabels()) {
                    String szLabel;
                    if (this.m_Perspective.isNumberFormatCallBack()) {
                        this.m_Perspective.getNumberFormatCallBack().setAxisMin(this.getMinValue());
                        this.m_Perspective.getNumberFormatCallBack().setAxisMax(this.getMaxValue());
                        this.m_Perspective.getNumberFormatCallBack().setAxisStep(this.getStepValue());
                        int nAxisID = this.m_template.getAxisObjID();
                        this.m_Perspective.getNumberFormatCallBack().setState(0, -3, -3, nAxisID, i);
                        szLabel = this.m_Perspective.getNumberFormatCallBack().toString(this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + (double)i * this.m_fScaleStep) : this.m_fScaleMin + (double)i * this.m_fScaleStep);
                    } else {
                        if (this.m_bNonZeroBaseline && this.m_gt.isScalingAbs() && !this.m_gt.isBubble() && !this.m_gt.isScatter()) {
                            double fBaseline = this.m_Perspective.getNonZeroBaselineValue(this.m_template.getAxis());
                            double val = MathExt.sigdigits(this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + (double)i * this.m_fScaleStep) : this.m_fScaleMin + (double)i * this.m_fScaleStep, 10);
                            if (val == fBaseline) {
                                bExists = true;
                            }
                            if (val > fBaseline && !bExists) {
                                szLabel = TDGNumberFormat.toString(this.m_Perspective, nFormat, MathExt.sigdigits(fBaseline, 10), szFormatPattern);
                                this.m_NonZeroBaselineLabel = new String(szLabel);
                                bExists = true;
                            }
                        }
                        szLabel = TDGNumberFormat.toString(this.m_Perspective, nFormat, MathExt.sigdigits(this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + (double)i * this.m_fScaleStep) : this.m_fScaleMin + (double)i * this.m_fScaleStep, 10), szFormatPattern);
                    }
                    vectStrLabels.addElement(szLabel);
                    ++i;
                }
            }
        }
        return vectStrLabels;
    }

    protected String[] getLabels(int count, double min, double max) {
        String[] list = new String[count];
        double minVal = min;
        double maxVal = max;
        if (this.m_bLogScale) {
            minVal = Math.pow(this.m_fLogScaleBase, min);
            maxVal = Math.pow(this.m_fLogScaleBase, max);
        }
        double scaleStep = (maxVal - minVal) / (double)count;
        int i = 0;
        while (i < count) {
            if (this.m_Perspective.isNumberFormatCallBack()) {
                this.m_Perspective.getNumberFormatCallBack().setAxisMin(minVal);
                this.m_Perspective.getNumberFormatCallBack().setAxisMax(maxVal);
                this.m_Perspective.getNumberFormatCallBack().setAxisStep(scaleStep);
                int nAxisID = this.m_template.getAxisObjID();
                this.m_Perspective.getNumberFormatCallBack().setState(0, -3, -3, nAxisID, i);
                list[i] = this.m_Perspective.getNumberFormatCallBack().toString(this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, min + (double)i * scaleStep) : min + (double)i * scaleStep);
            }
            ++i;
        }
        return list;
    }

    Vector getNumericLabelsAsDouble() {
        PfjAssert.pfjAssert(this.m_bNumericAxis);
        if (this.m_bNumericAxis) {
            Vector<Double> szLabels = new Vector<Double>(this.getNumLabels());
            int i = 0;
            while (i < this.getNumLabels()) {
                double fLabel = this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + (double)i * this.m_fScaleStep) : this.m_fScaleMin + (double)i * this.m_fScaleStep;
                Double dLabel = new Double(fLabel);
                szLabels.addElement(dLabel);
                ++i;
            }
            return szLabels;
        }
        return null;
    }

    public int getNumIntervals() {
        if (this.m_bNumericAxis) {
            double num = (this.m_fScaleMax - this.m_fScaleMin) / this.m_fScaleStep;
            double roundNum = Math.rint(num);
            int numLabels = FP.equal(num, roundNum) ? (int)(roundNum + 1.0) : (int)(num + 1.0);
            return numLabels;
        }
        throw new AssertionException("Numeric Axis method call on ordinal axis");
    }

    private void calcNumLabels() {
        double roundNum;
        double num;
        this.m_nNumLabels = this.m_bNumericAxis ? (this.isY2Axis() && this.m_gt.isParetoType() ? (int)(100.0 / this.m_Y2DefaultScaleStep) + 1 : (FP.equal(num = (this.m_fScaleMax - this.m_fScaleMin) / this.m_fScaleStep, roundNum = Math.rint(num)) ? (int)(roundNum + 1.0) : (int)(num + 1.0))) : (!this.useSeriesLabels() ? this.m_numGroups : this.m_numSeries);
    }

    protected int getNumLabels() {
        int nLabels = this.isO1WithNestedLabels() && this.m_cbO1Labels != null ? this.m_cbO1Labels.getNumLabelsOnLevel(this.m_nNestingLevel) : this.m_nNumLabels;
        return nLabels;
    }

    protected int getNumMajorGrids() {
        if (!this.m_bNumericAxis && this.m_nOrdinalAxisType == 0) {
            return this.getNumLabels() + 1;
        }
        return this.getNumLabels();
    }

    protected int getNumMinorGrids() {
        int nGrids;
        if (this.m_bNumericAxis) {
            if (this.m_bLogScale) {
                return 8;
            }
            nGrids = (int)Math.max(Math.floor(this.m_fScaleStep / this.m_fMinorStep), 0.0);
            if (FP.equal(this.m_fMinorStep * (double)nGrids, this.m_fScaleStep)) {
                --nGrids;
            }
        } else {
            nGrids = this.m_Perspective.getGridCount(this.m_template.getMinor());
        }
        return nGrids;
    }

    protected double getValueFromRelCoord(double coord) {
        if (this.m_bNumericAxis) {
            double val = this.m_bAscending ? (coord - this.m_fAxisPositionRel) / this.m_fValToRelCoord + this.m_fScaleMin : (this.m_fAxisPositionRel + this.m_fAxisLengthRel - coord) / this.m_fValToRelCoord + this.m_fScaleMin;
            if (this.m_bLogScale) {
                val = Math.pow(this.m_fLogScaleBase, val);
            }
            return val;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    public double getValueRelCoord(double fValue) {
        if (!this.m_gt.isBLAType() && !this.m_bLogScale) {
            if (fValue < this.m_fScaleMin) {
                fValue = this.m_fScaleMin;
            }
            if (fValue > this.m_fScaleMax) {
                fValue = this.m_fScaleMax;
            }
        }
        if (this.m_bLogScale) {
            fValue = fValue == 0.0 ? this.m_fScaleMin : Math.log(fValue) / Math.log(this.m_fLogScaleBase);
        }
        double offset = fValue - this.m_fScaleMin;
        if (this.m_fScaleMax - this.m_fScaleMin <= 0.0) {
            offset = this.m_continuousTimeAxis ? 0.0 : 1.0;
        }
        double fCoord = this.m_bAscending ? this.m_fAxisPositionRel + offset * this.m_fValToRelCoord : this.m_fAxisPositionRel + this.m_fAxisLengthRel - offset * this.m_fValToRelCoord;
        if (!this.m_gt.isBLAType()) {
            fCoord = Math.min(fCoord, 1.0);
            if (this.pinCoordToMinScale()) {
                fCoord = Math.max(fCoord, 0.0);
            }
        }
        return fCoord;
    }

    public double getValueRelCoordForZoom(double fValue) {
        if (!(this.m_gt.isBLAType() || this.m_gt.isBubble() || this.m_gt.isScatter() || this.m_bLogScale)) {
            if (fValue < this.m_fScaleMin) {
                fValue = this.m_fScaleMin;
            }
            if (fValue > this.m_fScaleMax) {
                fValue = this.m_fScaleMax;
            }
        }
        if (this.m_bLogScale) {
            fValue = fValue == 0.0 ? this.m_fScaleMin : Math.log(fValue) / Math.log(this.m_fLogScaleBase);
        }
        double offset = fValue - this.m_fScaleMin;
        if (this.m_fScaleMax - this.m_fScaleMin <= 0.0) {
            offset = 1.0;
        }
        double fCoord = this.m_bAscending ? this.m_fAxisPositionRel + offset * this.m_fValToRelCoord : this.m_fAxisPositionRel + this.m_fAxisLengthRel - offset * this.m_fValToRelCoord;
        if (!(this.m_gt.isBLAType() || this.m_gt.isBubble() || this.m_gt.isScatter())) {
            fCoord = Math.min(fCoord, 1.0);
            if (this.pinCoordToMinScale()) {
                fCoord = Math.max(fCoord, 0.0);
            }
        }
        return fCoord;
    }

    public boolean hasNegData() {
        if (this.m_bNumericAxis) {
            return this.m_fScaleMin < 0.0;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    public boolean isNumericAxis() {
        return this.m_bNumericAxis;
    }

    protected boolean isZeroInRange() {
        if (this.m_bNumericAxis) {
            return (this.m_fScaleMin > 0.0 || this.m_fScaleMax < 0.0) ^ true;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    private void _updateValToRelCoord() {
        this.m_fValToRelCoord = this.m_fScaleMax - this.m_fScaleMin <= 0.0 ? this.m_fAxisLengthRel : this.m_fAxisLengthRel / (this.m_fScaleMax - this.m_fScaleMin);
    }

    private void _calcBubbleSizes() {
        this._updateValToRelCoord();
        JChart_Base chartBase = this.m_Perspective.getGraphObject();
        JChart_2D_Scat chartScat = null;
        if (chartBase instanceof JChart_2D_Scat) {
            chartScat = (JChart_2D_Scat)chartBase;
        }
        if (chartScat != null && this.getAxisObjID() == 8) {
            chartScat.calcBubbleSizes(this.m_fScaleMin, this.m_fScaleMax);
        }
    }

    private void _calcMinMaxBubblesOnAxis() {
        this._updateValToRelCoord();
        JChart_Base chartBase = this.m_Perspective.getGraphObject();
        JChart_2D_Scat chartScat = null;
        if (chartBase instanceof JChart_2D_Scat) {
            chartScat = (JChart_2D_Scat)chartBase;
        }
        if (chartScat != null && (this.getAxisObjID() == 0 || this.getAxisObjID() == 1 || this.getAxisObjID() == 7) && (this.m_bAutoMax || this.m_bAutoMin)) {
            SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
            GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
            int s = 0;
            int g = 0;
            double maxBubbleVal = this.m_fScaleMin;
            double minBubbleVal = this.m_fScaleMax;
            int maxBubbleValSize = 0;
            int minBubbleValSize = 0;
            int maxBubbleValCoord = 0;
            int minBubbleValCoord = 0;
            if (this.m_bLogScale) {
                maxBubbleValCoord = (int)this.getValueCoord(Math.pow(this.m_fLogScaleBase, maxBubbleVal));
                minBubbleValCoord = (int)this.getValueCoord(Math.pow(this.m_fLogScaleBase, minBubbleVal));
            } else {
                maxBubbleValCoord = (int)this.getValueCoord(maxBubbleVal);
                minBubbleValCoord = (int)this.getValueCoord(minBubbleVal);
            }
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_numTotalSeries);
                int axis = 0;
                if (this.getAxisObjID() == 7) {
                    axis = 7;
                } else if (this.m_gt.isDualY()) {
                    axis = this.m_Perspective.getAxisAssignment(s);
                }
                if (axis != this.getAxisObjID()) continue;
                gEnum.reset();
                while (gEnum.hasMoreElements()) {
                    g = gEnum.nextGroup();
                    PfjAssert.pfjAssert(g >= 0 && g < this.m_numTotalGroups);
                    int bubbleSize = 0;
                    double fValue = 0.0;
                    try {
                        switch (axis) {
                            case 0: 
                            case 1: {
                                fValue = chartScat.getXYZ_YValue(s, g);
                                bubbleSize = chartScat.getBubbleSizeY(s, g);
                                break;
                            }
                            case 7: {
                                fValue = chartScat.getXYZ_XValue(s, g);
                                bubbleSize = chartScat.getBubbleSizeX(s, g);
                                break;
                            }
                        }
                    }
                    catch (AssertionException e) {
                        continue;
                    }
                    if (this.m_bLogScale && fValue <= 0.0) continue;
                    int fValueCoord = (int)this.getValueCoord(fValue);
                    if (fValueCoord + bubbleSize / 2 > maxBubbleValCoord + maxBubbleValSize / 2) {
                        maxBubbleVal = fValue;
                        maxBubbleValCoord = fValueCoord;
                        maxBubbleValSize = bubbleSize;
                    }
                    if (fValueCoord - bubbleSize / 2 >= minBubbleValCoord - minBubbleValSize / 2) continue;
                    minBubbleVal = fValue;
                    minBubbleValCoord = fValueCoord;
                    minBubbleValSize = bubbleSize;
                }
            }
            this.m_minBubbleVal = minBubbleVal;
            this.m_maxBubbleVal = maxBubbleVal;
            this.m_minBubbleSize = minBubbleValSize;
            this.m_maxBubbleSize = maxBubbleValSize;
        }
    }

    private void calcTimeInterval() {
        int frameWidth = this.m_Perspective.getVC().virtToDestWidth(this.m_axisLengthVC);
        double diff = this.m_fScaleMax - this.m_fScaleMin;
        boolean sec = false;
        boolean minute = false;
        boolean hour = false;
        boolean day = false;
        boolean month = false;
        boolean year = false;
        int count = 0;
        int interval = this.m_Perspective.getIntegerProp(Attr.ContinuousTimeAxisInterval);
        if (interval == 0) {
            if (diff < (double)Perspective.MINUTE_LG) {
                sec = true;
            } else if (diff < (double)Perspective.HOUR_LG) {
                count = (int)(diff / (double)Perspective.MINUTE_LG);
                if (count <= 1) {
                    if (frameWidth / (count + 1) > 100) {
                        sec = true;
                    } else {
                        minute = true;
                    }
                } else {
                    minute = true;
                }
            } else if (diff < (double)Perspective.DAY_LG) {
                count = (int)(diff / (double)Perspective.HOUR_LG);
                if (count <= 1) {
                    if (frameWidth / (count + 1) > 100) {
                        minute = true;
                    } else {
                        hour = true;
                    }
                } else {
                    hour = true;
                }
            } else if (diff < (double)Perspective.MONTH_LG) {
                count = (int)(diff / (double)Perspective.DAY_LG);
                if (count <= 1) {
                    if (frameWidth / (count + 1) > 100) {
                        hour = true;
                    } else {
                        day = true;
                    }
                } else {
                    day = true;
                }
            } else if (diff < (double)Perspective.YEAR_LG) {
                count = (int)(diff / (double)Perspective.MONTH_LG);
                if (count <= 1) {
                    if (frameWidth / (count + 1) > 100) {
                        day = true;
                    } else {
                        month = true;
                    }
                } else {
                    month = true;
                }
            } else {
                year = true;
            }
        } else if (interval == 1) {
            year = true;
        } else if (interval == 2) {
            month = true;
        } else if (interval == 3) {
            day = true;
        } else if (interval == 4) {
            hour = true;
        } else if (interval == 5) {
            minute = true;
        } else {
            sec = true;
        }
        if (month) {
            String format = this.m_Perspective.getTimeAxisDateFormat(1);
            if (format.equals("NONE")) {
                year = true;
                month = false;
            }
        } else if (day) {
            String format = this.m_Perspective.getTimeAxisDateFormat(2);
            if (format.equals("NONE")) {
                month = true;
                day = false;
                format = this.m_Perspective.getTimeAxisDateFormat(1);
                if (format.equals("NONE")) {
                    month = false;
                    year = true;
                }
            }
        } else if (hour) {
            String format = this.m_Perspective.getTimeAxisDateFormat(3);
            if (format.equals("NONE")) {
                hour = false;
                day = true;
                format = this.m_Perspective.getTimeAxisDateFormat(2);
                if (format.equals("NONE")) {
                    month = true;
                    day = false;
                    format = this.m_Perspective.getTimeAxisDateFormat(1);
                    if (format.equals("NONE")) {
                        month = false;
                        year = true;
                    }
                }
            }
        } else if (minute) {
            String format = this.m_Perspective.getTimeAxisDateFormat(3);
            if (format.equals("NONE")) {
                hour = false;
                minute = false;
                day = true;
                format = this.m_Perspective.getTimeAxisDateFormat(2);
                if (format.equals("NONE")) {
                    month = true;
                    day = false;
                    format = this.m_Perspective.getTimeAxisDateFormat(1);
                    if (format.equals("NONE")) {
                        month = false;
                        year = true;
                    }
                }
            } else if (format.equals("HH") || format.equals("HH24")) {
                hour = true;
                minute = false;
            }
        } else if (sec) {
            String format = this.m_Perspective.getTimeAxisDateFormat(3);
            if (format.equals("NONE")) {
                hour = false;
                minute = false;
                sec = false;
                day = true;
                format = this.m_Perspective.getTimeAxisDateFormat(2);
                if (format.equals("NONE")) {
                    month = true;
                    day = false;
                    format = this.m_Perspective.getTimeAxisDateFormat(1);
                    if (format.equals("NONE")) {
                        month = false;
                        year = true;
                    }
                }
            } else if (format.equals("HH") || format.equals("HH24")) {
                hour = true;
                minute = false;
                sec = false;
            } else if (format.equals("HH:MI") || format.equals("HH24:MI")) {
                minute = true;
                sec = false;
            }
        }
        if (!this.m_firstCalc) {
            this.m_dates = new Vector();
            this.fillDates(frameWidth, sec, minute, hour, day, month, year, this.m_dates);
            this.m_Perspective.m_groupLabels = this.m_dates;
            this.m_Perspective.formatDates();
        }
    }

    protected void fillDates(int frameWidth, boolean sec, boolean minute, boolean hour, boolean day, boolean month, boolean year, Vector dates) {
        double diff = this.m_fScaleMax - this.m_fScaleMin;
        int countBySpace = frameWidth / 20;
        int countByValue = 0;
        int count = 0;
        countByValue = sec ? (int)(diff / (double)Perspective.SECOND_LG) : (minute ? (int)(diff / (double)Perspective.MINUTE_LG) : (hour ? (int)(diff / (double)Perspective.HOUR_LG) : (day ? (int)(diff / (double)Perspective.DAY_LG) : (month ? (int)(diff / (double)Perspective.MONTH_LG) : (int)(diff / (double)Perspective.YEAR_LG)))));
        count = countByValue > countBySpace ? countByValue / countBySpace : 1;
        int field = 0;
        if (sec) {
            field = 13;
            this.m_Perspective.m_dateFreq = 6;
        } else if (minute) {
            field = 12;
            this.m_Perspective.m_dateFreq = 5;
        } else if (hour) {
            field = 10;
            this.m_Perspective.m_dateFreq = 4;
        } else if (day) {
            field = 5;
            this.m_Perspective.m_dateFreq = 2;
        } else if (month) {
            field = 2;
            this.m_Perspective.m_dateFreq = 1;
        } else {
            field = 1;
            this.m_Perspective.m_dateFreq = 0;
        }
        GregorianCalendar calendar = new GregorianCalendar(this.m_Perspective.getTimeZone(), this.m_Perspective.getLocale());
        calendar.setTimeInMillis((long)this.m_fScaleMin);
        int[] clearFields = null;
        clearFields = sec ? this.getClearArrayForSec() : (minute ? this.getClearArrayForMinute() : (hour ? this.getClearArrayForHour() : (day ? this.getClearArrayForDay() : (month ? this.getClearArrayForMonth() : this.getClearArrayForYear()))));
        int i = 0;
        while (i < clearFields.length) {
            if (clearFields[i] == 5) {
                calendar.set(clearFields[i], 1);
            } else {
                calendar.set(clearFields[i], 0);
            }
            ++i;
        }
        if (this.m_fScaleMin != (double)calendar.getTimeInMillis()) {
            calendar.add(field, 1);
        }
        while (calendar.getTimeInMillis() <= (long)this.m_fScaleMax) {
            dates.add(calendar.getTime());
            calendar.add(field, count);
        }
        if (dates.isEmpty()) {
            calendar.setTimeInMillis((long)this.m_fScaleMin);
            dates.add(calendar.getTime());
        }
    }

    public int[] getClearArrayForSec() {
        int[] clearArray = new int[]{14};
        return clearArray;
    }

    public int[] getClearArrayForMinute() {
        int[] clearArray = new int[]{14, 13};
        return clearArray;
    }

    public int[] getClearArrayForHour() {
        int[] clearArray = new int[]{14, 13, 12};
        return clearArray;
    }

    public int[] getClearArrayForDay() {
        int[] clearArray = new int[]{14, 13, 12, 11};
        return clearArray;
    }

    public int[] getClearArrayForMonth() {
        int[] clearArray = new int[]{14, 13, 12, 11, 5};
        return clearArray;
    }

    public int[] getClearArrayForYear() {
        int[] clearArray = new int[]{14, 13, 12, 11, 5, 2};
        return clearArray;
    }

    protected void roundOffMin(int[] clearFields, GregorianCalendar calendar) {
    }

    protected void roundOffMax(int[] clearFields, int incrField, GregorianCalendar calendar) {
    }

    protected void calcNumericScale() {
        double min;
        double max;
        if (this.m_gt.isBubble() && this.getAxisObjID() == 8) {
            this._calcBubbleSizes();
        }
        if (this.m_continuousTimeAxis) {
            this.m_bAutoMax = this.m_Perspective.getScaleMaxAuto(this.m_template.getAxis());
            this.m_bAutoMin = this.m_Perspective.getScaleMinAuto(this.m_template.getAxis());
            this.m_fScaleMax = this.m_bAutoMax ? this.m_objMinMax.getAdjMax() : this.m_Perspective.getScaleMax(this.m_template.getAxis());
            double d = this.m_fScaleMin = this.m_bAutoMin ? this.m_objMinMax.getAdjMin() : this.m_Perspective.getScaleMin(this.m_template.getAxis());
            if (this.m_Perspective.getIntegerProp(Attr.TimeRangeMode) == 0) {
                this.m_fScaleMax = this.m_bAutoMax ? this.m_objMinMax.getAdjMax() : this.m_Perspective.getScaleMax(this.m_template.getAxis());
                this.m_fScaleMin = this.m_bAutoMin ? this.m_objMinMax.getAdjMin() : this.m_Perspective.getScaleMin(this.m_template.getAxis());
            } else if (this.m_Perspective.getIntegerProp(Attr.TimeRangeMode) == 3 && !this.m_firstCalc) {
                if (this.m_bAutoMin) {
                    this.m_fScaleMin = ((Date)this.m_Perspective.getObjProp(Attr.ExplicitTimeRangeStart)).getTime();
                    if (this.m_Perspective.isZoomScrollStarted()) {
                        this.m_Perspective.setScaleMinAuto(this.m_template.getAxis(), false);
                        this.m_Perspective.setScaleMin(this.m_template.getAxis(), this.m_fScaleMin);
                        this.m_Perspective.setZoomScrollStarted(false);
                    }
                }
                if (this.m_bAutoMax) {
                    this.m_fScaleMax = ((Date)this.m_Perspective.getObjProp(Attr.ExplicitTimeRangeEnd)).getTime();
                    if (this.m_Perspective.isZoomScrollStarted()) {
                        this.m_Perspective.setScaleMaxAuto(this.m_template.getAxis(), false);
                        this.m_Perspective.setScaleMax(this.m_template.getAxis(), this.m_fScaleMax);
                        this.m_Perspective.setZoomScrollStarted(false);
                    }
                }
            } else if (this.m_Perspective.getIntegerProp(Attr.TimeRangeMode) == 2 && !this.m_firstCalc) {
                if (this.m_bAutoMax) {
                    this.m_fScaleMax = this.m_fScaleMin + (double)this.m_Perspective.getLongProp(Attr.RelativeTimeRange);
                    if (this.m_Perspective.isZoomScrollStarted()) {
                        this.m_Perspective.setScaleMaxAuto(this.m_template.getAxis(), false);
                        this.m_Perspective.setScaleMax(this.m_template.getAxis(), this.m_fScaleMax);
                        this.m_Perspective.setZoomScrollStarted(false);
                    }
                }
            } else if (this.m_Perspective.getIntegerProp(Attr.TimeRangeMode) == 1 && !this.m_firstCalc && this.m_bAutoMin) {
                this.m_fScaleMin = this.m_fScaleMax - (double)this.m_Perspective.getLongProp(Attr.RelativeTimeRange);
                if (this.m_Perspective.isZoomScrollStarted()) {
                    this.m_Perspective.setScaleMinAuto(this.m_template.getAxis(), false);
                    this.m_Perspective.setScaleMin(this.m_template.getAxis(), this.m_fScaleMin);
                    this.m_Perspective.setZoomScrollStarted(false);
                }
            }
            this.calcTimeInterval();
            this.calcRiserWidth();
            return;
        }
        boolean bNeedUpdateLook = false;
        if (this.isY2Axis() && this.m_gt.isParetoType()) {
            this.m_fScaleMin = 0.0;
            if (this.m_bAutoStep) {
                this.m_Y2DefaultScaleStep = 10.0;
                this.m_Perspective.putToLookNoCalc(Perspective.s_identObjGlobal, Attr.ParetoY2MajorGridStep, new Double(10.0));
            } else {
                this.m_Y2DefaultScaleStep = this.m_Perspective.getParetoY2MajorGridStep();
            }
            this.m_fScaleMax = this.getParetoSeriesMaximum(this.m_Perspective.getDisplayParetoSeries());
            if (this.m_bAutoStep && this.m_Y2DefaultScaleStep < this.m_fMinAutoScaleStep && this.m_fMinAutoScaleStep <= 100.0) {
                this.m_Y2DefaultScaleStep = this.m_fMinAutoScaleStep;
            }
            if (this.m_bAutoStep && this.m_fMinAutoScaleStep != 0.0 && this.m_Y2DefaultScaleStep > this.m_fMinAutoScaleStep && !FP.equal(this.m_Y2DefaultScaleStep % this.m_fMinAutoScaleStep, 0.0)) {
                this.m_Y2DefaultScaleStep -= this.m_Y2DefaultScaleStep % this.m_fMinAutoScaleStep;
            }
            this.m_fScaleStep = (this.m_fScaleMax - this.m_fScaleMin) / 10.0;
            this.m_fScaleStep = (this.m_fScaleMax - this.m_fScaleMin) / (100.0 / this.m_Y2DefaultScaleStep);
            this.m_bAutoStep = false;
        }
        if (this.m_gt.isPercent()) {
            this.m_bAutoStep = false;
            this.m_bAutoMin = false;
            this.m_bAutoMax = false;
            this.m_fScaleMax = this.m_objMinMax.getAdjMax() > 0.0 ? 1.0 : 0.0;
            this.m_fScaleMin = this.m_objMinMax.getAdjMin() < 0.0 ? -1.0 : 0.0;
            this.m_fScaleStep = 0.2;
            this.m_bLogScale = false;
        }
        if (this.m_fScaleMin > this.m_fScaleMax) {
            double temp = this.m_fScaleMin;
            this.m_fScaleMin = this.m_fScaleMax;
            this.m_fScaleMax = temp;
            this.m_bAscending ^= true;
            if (!this.m_Perspective.getAxesPreviewMode()) {
                this.m_Perspective.getErrorHandler().log("Warning: Scale minimum larger that scale maximum, axis automatically inverted", this.getClass().getName(), "calcNumericScale()");
            }
            bNeedUpdateLook = true;
        }
        if (this.m_fScaleStep < 0.0 && !this.m_bAutoStep) {
            if (!this.m_Perspective.getAxesPreviewMode()) {
                this.m_Perspective.getErrorHandler().log("Warning: Negative axis step, step set to automatic", this.getClass().getName(), "calcNumericScale()");
            }
            this.m_bAutoStep = true;
            this.m_Perspective.setGridStepAuto(this.m_template.getMajor(), true);
        } else if (this.m_fScaleStep > this.m_fScaleMax - this.m_fScaleMin && this.m_fScaleMax != this.m_fScaleMin && !this.m_bAutoStep) {
            if (!this.m_Perspective.getAxesPreviewMode()) {
                this.m_Perspective.getErrorHandler().log("Warning: Step larger than range, step set to automatic", this.getClass().getName(), "calcNumericScale()");
            }
            this.m_bAutoStep = true;
            this.m_Perspective.setGridStepAuto(this.m_template.getMajor(), true);
        } else if (this.m_fScaleStep * 100.0 < this.m_fScaleMax - this.m_fScaleMin && !this.m_bAutoStep && this.m_fScaleStep * 100.0 < (max = this.m_Perspective.getScaleMax(this.m_template.getAxis())) - (min = this.m_Perspective.getScaleMin(this.m_template.getAxis()))) {
            if (!this.m_Perspective.getAxesPreviewMode()) {
                this.m_Perspective.getErrorHandler().log("Warning: Step too small (too many labels/grids), step set to automatic", this.getClass().getName(), "calcNumericScale()");
            }
            this.m_bAutoStep = true;
            this.m_Perspective.setGridStepAuto(this.m_template.getMajor(), true);
        }
        if (this.m_bLogScale) {
            if (this.m_fScaleMin <= 0.0) {
                this.m_bLogScale = false;
                this.m_Perspective.setLogScale(this.m_template.getAxis(), false);
                if (!this.m_Perspective.getAxesPreviewMode()) {
                    this.m_Perspective.getErrorHandler().log("Warning: Negative or null minimum scale invalid for a logarithmic scale: set to linear scales", this.getClass().getName(), "calcNumericScale()");
                }
            }
            if (this.m_fScaleMax <= 0.0) {
                this.m_bLogScale = false;
                this.m_Perspective.setLogScale(this.m_template.getAxis(), false);
                if (!this.m_Perspective.getAxesPreviewMode()) {
                    this.m_Perspective.getErrorHandler().log("Warning: Negative or null maximum scale invalid for a logarithmic scale: set to linear scales", this.getClass().getName(), "calcNumericScale()");
                }
            }
            if (this.m_bLogScale) {
                this.calcLogScale();
                this.m_Perspective.setGridStepAuto(this.m_template.getMajor(), true);
                this.m_Perspective.setGridStep(this.m_template.getMajor(), this.m_fScaleStep);
                return;
            }
        }
        if (FP.equal(this.m_fScaleMin, 0.0) && FP.equal(this.m_fScaleMax, 0.0)) {
            this.m_bAutoMax = false;
            this.m_bAutoMin = false;
            this.m_bAutoStep = false;
            this.m_fScaleMax = 1.0;
            this.m_fScaleMin = 0.0;
            this.m_fScaleStep = 0.2;
            this.m_Perspective.setLogScale(this.m_template.getAxis(), false);
            this.m_Perspective.setGridStep(this.m_template.getMajor(), this.m_fScaleStep);
            this.m_Perspective.setScaleMax(this.m_template.getAxis(), this.m_fScaleMax);
            this.m_Perspective.setScaleMin(this.m_template.getAxis(), this.m_fScaleMin);
            if (!this.m_Perspective.getAxesPreviewMode()) {
                this.m_Perspective.getErrorHandler().log("Warning: scale minimum and maximum are both 0, scaling from 0 to 1", this.getClass().getName(), "calcNumericScale()");
            }
        }
        if (FP.equal(this.m_fScaleMin, this.m_fScaleMax) && !this.m_bAutoMax && !this.m_bAutoMin) {
            this.m_bAutoMax = true;
            this.m_bAutoMin = true;
            if (!this.m_Perspective.getAxesPreviewMode()) {
                this.m_Perspective.getErrorHandler().log("Warning: scale minimum and maximum are equal, set to automatic", this.getClass().getName(), "calcNumericScale()");
            }
            bNeedUpdateLook = true;
        }
        if (this.m_objMinMax.isDataDerived()) {
            double minMaxAve = (Math.abs(this.m_fScaleMin) + Math.abs(this.m_fScaleMax)) / 2.0;
            double delta = Math.abs(this.m_fScaleMax - this.m_fScaleMin);
            double minMaxAdjust = 1.05;
            if (minMaxAve != 0.0 && delta != 0.0 && delta < 0.5 * minMaxAve) {
                minMaxAdjust = 1.0 + 0.1 * delta / minMaxAve;
            }
            if (this.m_bAutoMin) {
                this.m_fScaleMin = this.m_fScaleMin < 0.0 ? (this.m_fScaleMin *= minMaxAdjust) : (this.m_fScaleMin /= minMaxAdjust);
            }
            if (this.m_bAutoMax) {
                this.m_fScaleMax = this.m_fScaleMax < 0.0 ? (this.m_fScaleMax /= minMaxAdjust) : (this.m_fScaleMax *= minMaxAdjust);
            }
        }
        if (this.m_bAutoMax || this.m_bAutoMin || this.m_bAutoStep) {
            this.calcAutoMinMax();
        } else {
            this.m_numberOfSteps = (int)Math.round((this.m_fScaleMax - this.m_fScaleMin) / this.m_fScaleStep);
        }
        if (!this.m_gt.isPercent()) {
            this.m_Perspective.setNoXMLMode(true);
            this.m_Perspective.setGridStep(this.m_template.getMajor(), this.m_fScaleStep);
            this.m_Perspective.setNoXMLMode(false);
            if (bNeedUpdateLook || this.m_bAutoMax || this.m_bAutoMin || this.m_bAutoStep) {
                if (bNeedUpdateLook) {
                    this.m_Perspective.setScaleMaxAuto(this.m_template.getAxis(), this.m_bAutoMax);
                    this.m_Perspective.setScaleMinAuto(this.m_template.getAxis(), this.m_bAutoMin);
                    this.m_Perspective.setGridStepAuto(this.m_template.getMajor(), this.m_bAutoStep);
                }
                if (this.m_Perspective.getAxisDescending(this.m_template.getAxis()) != (this.m_bAscending ^ true)) {
                    this.m_Perspective.setAxisDescending(this.m_template.getAxis(), this.m_bAscending ^ true);
                }
                if (this.isY2Axis() && this.m_gt.isParetoType()) {
                    this.m_Perspective.setScaleMax(this.m_template.getAxis(), 100.0);
                    this.m_Perspective.setScaleMin(this.m_template.getAxis(), 0.0);
                } else if (!(this.m_gt.isParetoType() || this.m_bNonZeroBaseline && this.m_gt.isScalingAbs() && !this.m_gt.isBubble() && !this.m_gt.isScatter())) {
                    this.m_Perspective.setScaleMax(this.m_template.getAxis(), this.m_fScaleMax);
                    this.m_Perspective.setScaleMin(this.m_template.getAxis(), this.m_fScaleMin);
                }
            }
        }
    }

    protected boolean isLogScale() {
        return this.m_bLogScale;
    }

    private void calcMinorStep() {
        boolean bAutoMinorStep = this.m_Perspective.getGridStepAuto(this.m_template.getMinor());
        boolean bUpdateStep = false;
        this.m_fMinorStep = bAutoMinorStep ? this.m_fScaleStep / 2.0 : this.m_Perspective.getGridStep(this.m_template.getMinor());
        if (this.m_fMinorStep < 0.0 && !this.m_bAutoStep) {
            if (!this.m_Perspective.getAxesPreviewMode()) {
                this.m_Perspective.getErrorHandler().log("Warning: Negative axis minor step, minor step set to automatic", this.getClass().getName(), "calcMinorStep()");
            }
            this.m_fMinorStep = this.m_fScaleStep / 2.0;
            bAutoMinorStep = true;
            bUpdateStep = true;
        } else if (this.m_fMinorStep >= this.m_fScaleStep) {
            if (!this.m_Perspective.getAxesPreviewMode()) {
                this.m_Perspective.getErrorHandler().log("Warning: Minor step larger than range, minor step set to automatic", this.getClass().getName(), "calcMinorStep()");
            }
            this.m_fMinorStep = this.m_fScaleStep / 2.0;
            bAutoMinorStep = true;
            bUpdateStep = true;
        } else if (this.m_fMinorStep * 100.0 < this.m_fScaleStep) {
            if (!this.m_Perspective.getAxesPreviewMode()) {
                this.m_Perspective.getErrorHandler().log("Warning: Minor step too small (too many minor grids), minor step set to automatic", this.getClass().getName(), "calcMinorStep()");
            }
            this.m_fMinorStep = this.m_fScaleStep / 2.0;
            bAutoMinorStep = true;
            bUpdateStep = true;
        }
        if (bUpdateStep || this.m_bLogScale) {
            this.m_Perspective.setGridStepAuto(this.m_template.getMinor(), true);
            this.m_Perspective.setGridStep(this.m_template.getMinor(), this.m_fMinorStep);
        }
    }

    protected double getMinCoord() {
        if (this.m_bNumericAxis) {
            return this.getValueCoord(this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin) : this.m_fScaleMin);
        }
        throw new AssertionException("This method should be called only for numeric axis");
    }

    protected double getMaxCoord() {
        if (this.m_bNumericAxis) {
            return this.getValueCoord(this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMax) : this.m_fScaleMax);
        }
        throw new RuntimeException("This method should be called only for numeric axis");
    }

    public double getMinValue() {
        if (this.m_bNumericAxis) {
            if (this.m_bLogScale) {
                return Math.pow(this.m_fLogScaleBase, this.m_fScaleMin);
            }
            return this.m_fScaleMin;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    public double getBaseMax() {
        if (this.m_bNumericAxis) {
            if (this.m_bLogScale) {
                return Math.pow(this.m_fLogScaleBase, this.m_fBaseMax);
            }
            return this.m_fBaseMax;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    public double getBaseMin() {
        if (this.m_bNumericAxis) {
            if (this.m_bLogScale) {
                return Math.pow(this.m_fLogScaleBase, this.m_fBaseMin);
            }
            return this.m_fBaseMin;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    public double getMaxValue() {
        if (this.m_bNumericAxis) {
            if (this.m_bLogScale) {
                return Math.pow(this.m_fLogScaleBase, this.m_fScaleMax);
            }
            return this.m_fScaleMax;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    public double getStepValue() {
        if (this.m_bNumericAxis) {
            return this.m_fScaleStep;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    public boolean isValueOffscale(double value) {
        if (this.m_bNumericAxis) {
            if (this.m_bLogScale) {
                return value < Math.pow(this.m_fLogScaleBase, this.m_fScaleMin) || value > Math.pow(this.m_fLogScaleBase, this.m_fScaleMax);
            }
            return value < this.m_fScaleMin || value > this.m_fScaleMax;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    protected boolean pinCoordToMinScale() {
        return true;
    }

    protected boolean useSeriesLabels() {
        if (this.m_continuousTimeAxis) {
            return false;
        }
        if (this.m_bNumericAxis) {
            throw new AssertionException("Numerical Axis method call on ordinal axis");
        }
        boolean bUseSeries = this.m_nOrdinalAxisType == 8 || this.m_nOrdinalAxisType == 4;
        return bUseSeries;
    }

    protected abstract double getBaseCoord();

    protected abstract boolean isPolarAxis();

    public abstract void calcAxisBody();

    protected abstract void adjustLabelPos(int var1, int var2, Vector var3);

    protected abstract int getTitleJustVert(IdentObj var1, int var2);

    protected abstract int getTitleJustHoriz(IdentObj var1, int var2);

    protected abstract double getCenterCoord(int var1);

    protected abstract int getGroupAboveCoord(int var1);

    protected abstract int getGroupBelowCoord(int var1);

    protected abstract int getGroupAboveCoordForZoom(int var1);

    protected abstract int getGroupBelowCoordForZoom(int var1);

    protected abstract double getHighCoord(int var1, int var2);

    protected abstract double getLowCoord(int var1, int var2);

    protected abstract double getValueCoord(double var1);

    protected abstract double getValueCoordForZoom(double var1);

    protected abstract double getValueFromCoord(int var1);

    public void setParetoSeriesMaximum(int nSeries, double fValue) {
        this.m_nParetoSeriesMaximums[nSeries] = fValue;
    }

    public double getParetoSeriesMaximum(int nSeries) {
        return this.m_nParetoSeriesMaximums[nSeries];
    }

    public void setParetoSeriesMinimum(int nSeries, double fValue) {
        this.m_nParetoSeriesMinimums[nSeries] = fValue;
    }

    public double getParetoSeriesMinimum(int nSeries) {
        return this.m_nParetoSeriesMinimums[nSeries];
    }

    public String getNonZeroBaselineLabel() {
        return this.m_NonZeroBaselineLabel;
    }

    protected double[] getAutoMinMaxArray() {
        return this.m_autoMinMaxArray;
    }
}

