/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import oracle.dss.graph.pfj.ObjClassID;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.ObjectString;

public class TDGMouseState {
    public static final int DEADZONEMOUSELOCATION_UNKNOWN = 0;
    public static final int DEADZONEMOUSELOCATION_LEFTOFDEADZONE = 1;
    public static final int DEADZONEMOUSELOCATION_INDEADZONE = 2;
    public static final int DEADZONEMOUSELOCATION_RIGHTOFDEADZONE = 3;
    MouseEvent m_evt;
    DetObj m_DetObj;
    boolean m_ShiftKey;
    boolean m_ControlKey;
    boolean m_DragHappened;
    int m_nDeadZoneMouseLocation;

    private void $init$() {
        this.m_ShiftKey = false;
        this.m_ControlKey = false;
        this.m_DragHappened = false;
        this.m_nDeadZoneMouseLocation = 0;
    }

    public TDGMouseState(MouseEvent evt, DetObj aDetObj) {
        this.$init$();
        this.m_evt = evt;
        this.m_DetObj = aDetObj;
        if (evt != null) {
            this.m_ShiftKey = (evt.getModifiers() & 1) != 0;
            this.m_ControlKey = (evt.getModifiers() & 2) != 0;
        }
    }

    public TDGMouseState(MouseEvent evt, DetObj aDetObj, boolean DragHappened) {
        this(evt, aDetObj);
        this.m_DragHappened = DragHappened;
    }

    public IdentObj getIdentObj() {
        return this.m_DetObj.getIdentID();
    }

    public MouseEvent getMouseEvent() {
        return this.m_evt;
    }

    public int getMouseX() {
        if (this.m_evt != null) {
            return this.m_evt.getX();
        }
        return -1;
    }

    public int getMouseY() {
        if (this.m_evt != null) {
            return this.m_evt.getY();
        }
        return -1;
    }

    public boolean isShiftKey() {
        return this.m_ShiftKey;
    }

    public boolean isControlKey() {
        return this.m_ControlKey;
    }

    public boolean isDrag() {
        return this.m_DragHappened;
    }

    public Rectangle getElementBounds() {
        return this.m_DetObj.getBounds();
    }

    public int getElementObjectID() {
        int nObjectID = this.m_DetObj.getObjectID();
        if (ObjClassID.isExceptional(nObjectID)) {
            nObjectID = ObjClassID.stripExceptionalOffset(nObjectID);
        }
        return nObjectID;
    }

    public int getElementInstanceID() {
        return this.m_DetObj.getIdentID().getMiscID();
    }

    public int getElementSeriesID() {
        return this.m_DetObj.getSeriesID();
    }

    public int getElementGroupID() {
        return this.m_DetObj.getGroupID();
    }

    public String getElementName() {
        return ObjectString.objectName(this.getElementObjectID());
    }

    public String getElementDesc() {
        return ObjectString.objectDescription(this.getElementObjectID());
    }

    public String getElementText() {
        String ReturnString = null;
        if (this.m_DetObj.getIdentID().isText() && this.m_DetObj instanceof DetLabel && (ReturnString = ((DetLabel)this.m_DetObj).getFullText()) == null) {
            ReturnString = ((DetLabel)this.m_DetObj).getLabelString();
        }
        return ReturnString;
    }

    public void setDeadZoneMouseLocation(int nDeadZoneMouseLocation) {
        this.m_nDeadZoneMouseLocation = nDeadZoneMouseLocation;
    }

    public int getDeadZoneMouseLocation() {
        return this.m_nDeadZoneMouseLocation;
    }
}

