/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import oracle.dss.graph.pfj.Perspective;

public class TDGNumberFormat {
    private static final int DEFAULT_MAXNUMDECIMALS = 5;
    public static final int FORMAT_USE_PATTERN = -1;
    public static final int FORMAT_GENERAL = 0;
    public static final int FORMAT_INTEGER = 1;
    public static final int FORMAT_PERCENT = 2;
    public static final int FORMAT_PERCENT_1 = 3;
    public static final int FORMAT_PERCENT_2 = 4;
    public static final int FORMAT_CURRENCY_GENERAL = 5;
    public static final int FORMAT_CURRENCY_INT = 6;
    public static final int FORMAT_K = 7;
    public static final int FORMAT_CURRENCY_K = 8;
    public static final int FORMAT_M = 9;
    public static final int FORMAT_CURRENCY_M = 10;
    public static final int FORMAT_B = 11;
    public static final int FORMAT_CURRENCY_B = 12;
    public static final int FORMAT_T = 13;
    public static final int FORMAT_CURRENCY_T = 14;
    public static final int FORMAT_NUMERIC = 15;
    public static final int FORMAT_NUMERIC_2 = 16;
    public static final int FORMAT_CURRENCY = 17;
    public static final int FORMAT_DATE_SHORT = 18;
    public static final int FORMAT_DATE_MEDIUM = 19;
    public static final int FORMAT_DATE_LONG = 20;
    public static final int FORMAT_DATE_FULL = 21;
    public static final int FORMAT_PARETO_PERCENT = 23;
    public static final int GENERAL = 0;
    public static final int CURRENCY = 1;
    public static final int PERCENT = 2;

    public static String toString(Perspective perspective, int nFormat, double dVal, String szPattern) {
        String strFormat;
        if ((nFormat == 0 || nFormat == 15 || nFormat == 16) && (dVal > 1.0E15 || dVal < -1.0E15)) {
            strFormat = Double.toString(dVal);
        } else if (nFormat == 23) {
            strFormat = Double.toString(dVal);
        } else {
            switch (nFormat) {
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    strFormat = TDGNumberFormat.dateFormatting(perspective, nFormat, dVal);
                    break;
                }
                default: {
                    strFormat = TDGNumberFormat.decimalFormatting(perspective, nFormat, dVal, szPattern);
                    break;
                }
            }
        }
        return strFormat;
    }

    private static String dateFormatting(Perspective perspective, int nFormat, double dVal) {
        int nDateFormatStyle;
        Double doubleValue = new Double(dVal);
        long lValue = doubleValue.longValue();
        Date dateValue = new Date(lValue);
        switch (nFormat) {
            default: {
                nDateFormatStyle = 3;
                break;
            }
            case 19: {
                nDateFormatStyle = 2;
                break;
            }
            case 20: {
                nDateFormatStyle = 1;
                break;
            }
            case 21: {
                nDateFormatStyle = 0;
                break;
            }
        }
        DateFormat formatDate = DateFormat.getDateInstance(nDateFormatStyle, perspective.m_Locale);
        Locale locale = perspective.m_Locale;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (locale.getLanguage().compareTo("th") == 0 && locale.getCountry().compareTo("TH") == 0) {
            if (perspective.m_Locale != null) {
                formatDate.setCalendar(new GregorianCalendar(perspective.m_Locale));
            } else {
                formatDate.setCalendar(new GregorianCalendar());
            }
        }
        String strFormat = formatDate.format(dateValue);
        return strFormat;
    }

    private static String decimalFormatting(Perspective perspective, int nFormat, double dVal, String szPattern) {
        DecimalFormat format = TDGNumberFormat.isPercentFormat(nFormat) ? (DecimalFormat)NumberFormat.getPercentInstance(perspective.m_Locale) : (TDGNumberFormat.isCurrencyFormat(nFormat) ? (DecimalFormat)NumberFormat.getCurrencyInstance(perspective.m_Locale) : (DecimalFormat)NumberFormat.getInstance(perspective.m_Locale));
        if (nFormat == -1) {
            format.applyLocalizedPattern(szPattern);
        } else {
            if (nFormat == 3) {
                format.setMinimumFractionDigits(1);
                format.setMaximumFractionDigits(1);
            } else if (nFormat == 4 || nFormat == 5 || nFormat == 16) {
                format.setMinimumFractionDigits(2);
                format.setMaximumFractionDigits(2);
            } else if (nFormat == 0) {
                format.setMinimumFractionDigits(0);
                format.setMaximumFractionDigits(5);
            } else if (nFormat != 17) {
                format.setMaximumFractionDigits(0);
            }
            if (nFormat == 1) {
                format.setGroupingUsed(false);
            }
            String strPrefix = "";
            if (nFormat == 0 || nFormat == 5 || nFormat == 6 || nFormat == 15 || nFormat == 16) {
                strPrefix = TDGNumberFormat.calcPrefix(dVal);
            } else if (nFormat == 7 || nFormat == 8) {
                strPrefix = "K";
            } else if (nFormat == 9 || nFormat == 10) {
                strPrefix = "M";
            } else if (nFormat == 11 || nFormat == 12) {
                strPrefix = "B";
            } else if (nFormat == 13 || nFormat == 14) {
                strPrefix = "T";
            }
            if (!strPrefix.equals("")) {
                if (strPrefix.equals("K")) {
                    dVal /= 1000.0;
                } else if (strPrefix.equals("M")) {
                    dVal /= 1000000.0;
                } else if (strPrefix.equals("B")) {
                    dVal /= 1.0E9;
                } else if (strPrefix.equals("T")) {
                    dVal /= 1.0E12;
                }
                format.setPositiveSuffix(strPrefix + format.getPositiveSuffix());
                format.setNegativeSuffix(strPrefix + format.getNegativeSuffix());
            }
        }
        if (dVal < 1.0 && dVal > -1.0 && nFormat == 1) {
            dVal = Math.floor(dVal + 0.5);
        }
        return format.format(dVal);
    }

    private static String calcPrefix(double dVal) {
        String strPrefix = "";
        if (dVal >= 1.0E12 && dVal < 1.0E15 || dVal <= -1.0E12 && dVal > -1.0E15) {
            strPrefix = "T";
        } else if (dVal >= 1.0E9 && dVal < 1.0E12 || dVal <= -1.0E9 && dVal > -1.0E12) {
            strPrefix = "B";
        } else if (dVal >= 1000000.0 && dVal < 1.0E9 || dVal <= -1000000.0 && dVal > -1.0E9) {
            strPrefix = "M";
        } else if (dVal >= 1000.0 && dVal < 1000000.0 || dVal <= -1000.0 && dVal > -1000000.0) {
            strPrefix = "K";
        }
        return strPrefix;
    }

    static boolean isPercentFormat(int nFormat) {
        return nFormat == 2 || nFormat == 3 || nFormat == 4;
    }

    static boolean isCurrencyFormat(int nFormat) {
        return nFormat == 5 || nFormat == 17 || nFormat == 6 || nFormat == 8 || nFormat == 10 || nFormat == 12 || nFormat == 14;
    }
}

