/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.IdentObj;

public class Zoom
implements Serializable {
    protected Perspective m_Perspective;
    protected Point m_ptStartZoomRect;
    protected Rectangle m_OldZoomRect;

    public Zoom(Perspective perspective) {
        this.m_Perspective = perspective;
    }

    public void mouseDraggedZoom(MouseEvent evt, IdentObj id, Graphics g) {
        boolean bConstrainY;
        Rectangle rFrame = this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getFrameRect(false));
        Point ptEndZoomRect = new Point(evt.getX(), evt.getY());
        if (ptEndZoomRect.x < rFrame.x) {
            ptEndZoomRect.x = rFrame.x;
        } else if (ptEndZoomRect.x > rFrame.x + rFrame.width) {
            ptEndZoomRect.x = rFrame.x + rFrame.width;
        }
        if (ptEndZoomRect.y < rFrame.y) {
            ptEndZoomRect.y = rFrame.y;
        } else if (ptEndZoomRect.y > rFrame.y + rFrame.height) {
            ptEndZoomRect.y = rFrame.y + rFrame.height;
        }
        int nX = Math.min(ptEndZoomRect.x, this.m_ptStartZoomRect.x);
        int nY = Math.min(ptEndZoomRect.y, this.m_ptStartZoomRect.y);
        int nWidth = Math.abs(ptEndZoomRect.x - this.m_ptStartZoomRect.x);
        int nHeight = Math.abs(ptEndZoomRect.y - this.m_ptStartZoomRect.y);
        boolean bConstrainX = this.m_Perspective.getZoomDirection() == 2;
        boolean bl = bConstrainY = this.m_Perspective.getZoomDirection() == 1;
        if (this.m_Perspective.isChartOrientHorz()) {
            bConstrainX = this.m_Perspective.getZoomDirection() == 1;
            boolean bl2 = bConstrainY = this.m_Perspective.getZoomDirection() == 2;
        }
        if (bConstrainY) {
            nY = rFrame.y;
            nHeight = rFrame.height;
        } else if (bConstrainX) {
            nX = rFrame.x;
            nWidth = rFrame.width;
        }
        Rectangle newRect = new Rectangle(nX, nY, nWidth, nHeight);
        g.setXORMode(Color.yellow);
        if (this.m_OldZoomRect != null) {
            g.drawRect(this.m_OldZoomRect.x, this.m_OldZoomRect.y, this.m_OldZoomRect.width, this.m_OldZoomRect.height);
        }
        g.drawRect(newRect.x, newRect.y, newRect.width, newRect.height);
        g.setPaintMode();
        this.m_OldZoomRect = new Rectangle(nX, nY, nWidth, nHeight);
    }

    public void mouseReleasedZoom(MouseEvent evt, Graphics g) {
        g.setXORMode(Color.yellow);
        if (this.m_OldZoomRect != null) {
            g.drawRect(this.m_OldZoomRect.x, this.m_OldZoomRect.y, this.m_OldZoomRect.width, this.m_OldZoomRect.height);
        }
        g.setPaintMode();
        if (this.m_OldZoomRect != null) {
            if (this.m_Perspective.getZoomDirection() == 1) {
                Point point = this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getFrameDepthOffset());
            }
            this.m_Perspective.doZoomIn(this.m_Perspective.m_VC.destToVirt(this.m_OldZoomRect));
        } else {
            int nIndex = evt.getClickCount() > 1 ? 0 : this.m_Perspective.getZoomIndex() - 1;
            this.m_Perspective.setZoomIndex(nIndex);
        }
        this.m_OldZoomRect = null;
    }

    public void eraseZoomRect(Graphics g) {
        g.setXORMode(Color.yellow);
        if (this.m_OldZoomRect != null) {
            g.drawRect(this.m_OldZoomRect.x, this.m_OldZoomRect.y, this.m_OldZoomRect.width, this.m_OldZoomRect.height);
        }
        g.setPaintMode();
        this.m_OldZoomRect = null;
    }

    public boolean isRegionZoomable(JChart_Base chart, Point ptPressed) {
        boolean bZoomable = false;
        if (!chart.m_gt.is3DType()) {
            Rectangle rFrame = this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getFrameRect(false));
            bZoomable = rFrame.contains(ptPressed);
        }
        return bZoomable;
    }

    public void setStartZoomRectPoint(Point ptZoom) {
        this.m_ptStartZoomRect = ptZoom;
        this.m_OldZoomRect = null;
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }
}

