/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import oracle.dss.graph.GraphStyleManager;
import oracle.dss.graph.managers.GraphStyle;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BorderObj;
import oracle.dss.graph.pfj.draw.ColorObj;
import oracle.dss.graph.pfj.draw.FillColorObj;
import oracle.dss.graph.pfj.draw.FillGradientObj;
import oracle.dss.graph.pfj.draw.FillObj;
import oracle.dss.graph.pfj.draw.FillTextureObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class BlackBoxObj
implements Serializable,
BlackBoxIF {
    static final String CLASS_TEXTURE = "oracle.dss.graph.pfj.draw.FillTextureObj";
    static final String CLASS_GRADIENT = "oracle.dss.graph.pfj.draw.FillGradientObj";
    static final String CLASS_COLOR = "oracle.dss.graph.pfj.draw.FillColorObj";
    public static final int SCALE_FACTOR = 50;
    private Perspective m_Perspective;
    public IdentObj m_id;
    protected IdentObj m_colorID;
    private FillObj m_FillObj;
    private BorderObj m_BorderObj;
    private Color m_DropShadowColor;
    private Dimension m_DropShadowOffset;
    private boolean m_bTransparentBorderColor;
    private boolean m_bTransparentFillColor;
    Color m_ChartBackgroundColor;

    private BlackBoxObj() {
        this.m_BorderObj = new BorderObj(Color.black);
        this.m_FillObj = new FillColorObj(Color.white);
        this.m_DropShadowColor = Color.black;
        this.m_DropShadowOffset = null;
    }

    public BlackBoxObj(BlackBoxObj bb) {
        this();
        this.copy(bb);
    }

    public BlackBoxObj(Perspective p, IdentObj id) {
        this.m_Perspective = p;
        this.m_id = id;
        this.m_colorID = id;
        if (!id.isSERIES_NA()) {
            int series = p.getEffectiveSeriesIndex(id.getSeriesID());
            this.m_colorID = new IdentObj(-3);
            this.m_colorID.copy(id);
            this.m_colorID.setSeriesID(series);
        }
        this.m_BorderObj = new BorderObj(p.getBorderColor(this.m_colorID));
        switch (p.getFillType(this.m_colorID)) {
            case 1: {
                this.m_FillObj = new FillColorObj(p.getFillColor(this.m_colorID));
                break;
            }
            case 2: {
                FillGradientObj fillGradient = new FillGradientObj(p, p.getGradientDirection(this.m_colorID));
                int nPins = p.getGradientNumPins(this.m_colorID);
                int i = 0;
                while (i < nPins) {
                    fillGradient.insertPin(p.getGradientPinPosition(this.m_colorID, i), new ColorObj(p.getGradientPinLeftColor(this.m_colorID, i)), new ColorObj(p.getGradientPinRightColor(this.m_colorID, i)));
                    ++i;
                }
                this.m_FillObj = fillGradient;
                break;
            }
            case 3: {
                String szURL = p.getTexture(this.m_colorID);
                Image img = p.getTexture(szURL);
                if (img != null) {
                    int nDisplayMode = p.getTextureDisplayMode(this.m_colorID);
                    int nFlipMode = p.getTextureFlipMode(this.m_colorID);
                    this.m_FillObj = new FillTextureObj(p, img, nDisplayMode, nFlipMode, 0);
                    break;
                }
                this.m_FillObj = new FillColorObj(p.getFillColor(this.m_colorID));
                p.setFillType(this.m_colorID, 1);
                break;
            }
            case 4: {
                int pattern = p.getFillPattern(this.m_colorID);
                Image img = p.getPatternTexture(this.m_colorID, pattern);
                if (img != null) {
                    int nDisplayMode = 0;
                    int nFlipMode = 0;
                    this.m_FillObj = new FillTextureObj(p, img, nDisplayMode, nFlipMode, 0);
                    break;
                }
                this.m_FillObj = new FillColorObj(p.getFillColor(this.m_colorID));
                p.setFillType(this.m_colorID, 1);
                break;
            }
        }
        this.m_bTransparentBorderColor = this.m_Perspective.getTransparentBorderColor(this.m_colorID);
        this.m_bTransparentFillColor = this.m_Perspective.getTransparentFillColor(this.m_colorID);
        this.m_ChartBackgroundColor = p.getFillColor(p.getChartBackground());
        this.m_DropShadowColor = p.getShadowColor(this.m_colorID);
        this.m_DropShadowOffset = p.getShadowDisplay(this.m_colorID) && !this.m_bTransparentFillColor ? new Dimension(p.getVC().virtToDestWidth(p.getShadowXOffset(this.m_colorID) * 50), p.getVC().virtToDestHeight(p.getShadowYOffset(this.m_colorID) * 50)) : null;
    }

    public GraphStyle runRules(int seriesID, int groupID) {
        GraphStyle style = null;
        Color c = this.getFillColor();
        if (this.m_Perspective != null) {
            Color newColor;
            GraphStyleManager styleManager = this.m_Perspective.getStyleManager();
            if (this.m_id != null && this.m_id.getObjectID() == -3 && styleManager != null && styleManager.getBundles() != null && (style = styleManager.getGraphComponentStyle(this.m_Perspective.getCommonGraph(), seriesID, groupID)) != null && !c.equals(newColor = style.getFillColor()) && newColor != null) {
                this.setFillColor(newColor);
            }
        }
        return style;
    }

    public void copy(BlackBoxObj bb) {
        String szOrgType = bb.m_FillObj.getClass().getName();
        if (szOrgType.equals(CLASS_GRADIENT)) {
            this.m_FillObj = new FillGradientObj();
        } else if (szOrgType.equals(CLASS_COLOR)) {
            this.m_FillObj = new FillColorObj();
        } else if (szOrgType.equals(CLASS_TEXTURE)) {
            this.m_FillObj = new FillTextureObj();
        }
        this.m_FillObj.copy(bb.m_FillObj);
        this.m_BorderObj.copy(bb.m_BorderObj);
        this.m_Perspective = bb.m_Perspective;
        this.m_DropShadowColor = bb.m_DropShadowColor;
        this.m_DropShadowOffset = bb.m_DropShadowOffset;
        this.m_id = bb.m_id;
        this.m_colorID = bb.m_colorID;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlackBoxObj)) {
            return false;
        }
        BlackBoxObj bb2 = (BlackBoxObj)obj;
        boolean bEqual = this.m_FillObj.equals(bb2.m_FillObj);
        return bEqual;
    }

    public Color getBorderColor() {
        return this.m_BorderObj.getColor();
    }

    public Color getFillColor() {
        String sz = this.m_FillObj.getClass().getName();
        if (sz.equals(CLASS_COLOR)) {
            return ((FillColorObj)this.m_FillObj).getColor();
        }
        return Color.white;
    }

    public int getFillType() {
        String sz = this.m_FillObj.getClass().getName();
        if (sz.equals(CLASS_COLOR)) {
            return 1;
        }
        if (sz.equals(CLASS_GRADIENT)) {
            return 2;
        }
        if (this.m_Perspective.getFillType(this.m_colorID) == 4) {
            return 4;
        }
        return 3;
    }

    public void setFillType(int fillType) {
        switch (fillType) {
            case 1: {
                this.m_FillObj = new FillColorObj(this.m_Perspective.getFillColor(this.m_colorID));
                break;
            }
            case 2: {
                FillGradientObj fillGradient = new FillGradientObj(this.m_Perspective, this.m_Perspective.getGradientDirection(this.m_colorID));
                int nPins = this.m_Perspective.getGradientNumPins(this.m_colorID);
                int i = 0;
                while (i < nPins) {
                    fillGradient.insertPin(this.m_Perspective.getGradientPinPosition(this.m_colorID, i), new ColorObj(this.m_Perspective.getGradientPinLeftColor(this.m_colorID, i)), new ColorObj(this.m_Perspective.getGradientPinRightColor(this.m_colorID, i)));
                    ++i;
                }
                this.m_FillObj = fillGradient;
                break;
            }
            case 3: {
                String szURL = this.m_Perspective.getTexture(this.m_colorID);
                Image img = this.m_Perspective.getTexture(szURL);
                if (img != null) {
                    int nDisplayMode = this.m_Perspective.getTextureDisplayMode(this.m_colorID);
                    int nFlipMode = this.m_Perspective.getTextureFlipMode(this.m_colorID);
                    this.m_FillObj = new FillTextureObj(this.m_Perspective, img, nDisplayMode, nFlipMode, 0);
                    break;
                }
                this.m_FillObj = new FillColorObj(this.m_Perspective.getFillColor(this.m_colorID));
                this.m_Perspective.setFillType(this.m_colorID, 1);
                break;
            }
            case 4: {
                int pattern = this.m_Perspective.getFillPattern(this.m_colorID);
                Image img = this.m_Perspective.getPatternTexture(this.m_colorID, pattern);
                if (img != null) {
                    int nDisplayMode = 0;
                    int nFlipMode = 0;
                    this.m_FillObj = new FillTextureObj(this.m_Perspective, img, nDisplayMode, nFlipMode, 0);
                    break;
                }
                this.m_FillObj = new FillColorObj(this.m_Perspective.getFillColor(this.m_colorID));
                this.m_Perspective.setFillType(this.m_colorID, 1);
                break;
            }
        }
    }

    public FillObj getFillObj() {
        return this.m_FillObj;
    }

    public BorderObj getBorderObj() {
        return this.m_BorderObj;
    }

    public void setFillGradientObj(FillGradientObj fillGradientObj) {
        this.m_FillObj = fillGradientObj;
    }

    public void setBorderGradientObj(FillGradientObj borderGradientObj) {
        this.m_BorderObj.setGradient(borderGradientObj);
    }

    public boolean getTransparentBorderColor() {
        return this.m_bTransparentBorderColor;
    }

    public boolean getTransparentFillColor() {
        return this.m_bTransparentFillColor;
    }

    public void setTransparentFillColor(boolean bTransparent) {
        this.m_bTransparentFillColor = bTransparent;
    }

    public void setTransparentBorderColor(boolean bTransparent) {
        this.m_bTransparentBorderColor = bTransparent;
    }

    public void paint(Graphics g, Rectangle rect, int type) {
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        if (type == 2) {
            x1 = rect.x;
            y1 = rect.y + rect.height;
            x2 = rect.x + rect.width;
            y2 = y1;
        } else if (type == 1) {
            x1 = rect.x;
            y1 = rect.y;
            x2 = x1 + rect.width;
            y2 = y1;
        } else if (type == 3) {
            x1 = rect.x;
            y1 = rect.y;
            x2 = rect.x;
            y2 = rect.y + rect.height;
        } else if (type == 4) {
            x1 = rect.x + rect.width;
            y1 = rect.y;
            x2 = x1;
            y2 = rect.y + rect.height;
        }
        if (!this.m_bTransparentFillColor) {
            g.setColor(this.m_FillObj.getColor());
            g.drawLine(x1, y1, x2, y2);
        }
        if (!this.m_bTransparentBorderColor) {
            g.setColor(this.m_BorderObj.getColor());
            g.drawLine(x1, y1, x2, y2);
        }
    }

    public void paint(Graphics g, Point a, Point b) {
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(g, a, b);
        }
    }

    public void paint(Graphics g, Point2D a, Point2D b) {
        if (!this.m_bTransparentBorderColor) {
            Object oldHint = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            this.m_BorderObj.paint(g, a, b);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldHint);
        }
    }

    public void paint(Graphics g, Polygon p) {
        if (this.m_DropShadowOffset != null) {
            Polygon pDropShadow = new Polygon();
            int i = 0;
            while (i < p.npoints) {
                pDropShadow.addPoint(p.xpoints[i] + this.m_DropShadowOffset.width, p.ypoints[i] + this.m_DropShadowOffset.height);
                ++i;
            }
            g.setColor(this.m_DropShadowColor);
            g.fillPolygon(pDropShadow);
        }
        if (!this.m_bTransparentFillColor) {
            this.m_FillObj.fillPolygon(g, this.m_Perspective, p);
        }
        if (!this.m_bTransparentBorderColor) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.m_BorderObj.paint(g, this.m_Perspective, p);
        }
    }

    public void paint(Graphics g, GeneralPath path, Rectangle rect) {
        if (!this.m_bTransparentFillColor) {
            this.m_FillObj.fillPolygon(g, this.m_Perspective, path, rect);
        }
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(g, this.m_Perspective, path);
        }
    }

    public void paint(Graphics g, Area area) {
        if (!this.m_bTransparentFillColor) {
            this.m_FillObj.fillPolygon(g, this.m_Perspective, area);
        }
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(g, this.m_Perspective, area);
        }
    }

    public void paint(Graphics g, RectangularShape shape) {
        Object oldHint = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        Object oldRenderingHint = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_RENDERING);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (!this.m_bTransparentFillColor) {
            if (this.m_id.getObjectID() == 626 && this.m_id.getMiscID() == 623 && !this.m_Perspective.getFunnelGradientEffect()) {
                Color col = this.m_Perspective.getFillColor(this.m_Perspective.getFunnelFrame());
                this.setFillColor(this.m_Perspective.getDarker(col));
            }
            this.m_FillObj.fillPolygon(g, this.m_Perspective, shape);
        }
        if (!this.m_bTransparentBorderColor) {
            if (this.m_id.getObjectID() == 626) {
                this.m_BorderObj.paint(g, this.m_Perspective, shape, (float)this.m_Perspective.getLineWidth(this.m_Perspective.getFunnelFrame()));
            } else {
                this.m_BorderObj.paint(g, this.m_Perspective, shape);
            }
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldHint);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, oldRenderingHint);
    }

    public void paint(Graphics g, Arc2D arc, Area fillArea, Area boundingArea) {
        Object oldHint = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        Object oldRenderingHint = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_RENDERING);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (!this.m_bTransparentFillColor && fillArea != null) {
            if (this.m_id.getObjectID() == -3 && this.m_id.getSeriesID() == this.m_id.getMiscID() && this.m_Perspective.getFunnelGradientEffect() && boundingArea != null && !fillArea.equals(boundingArea) && this.m_FillObj instanceof FillGradientObj) {
                ((FillGradientObj)this.m_FillObj).setBoundingArea(boundingArea);
            }
            this.m_FillObj.fillPolygon(g, this.m_Perspective, fillArea);
        }
        if (!this.m_bTransparentBorderColor && arc != null) {
            if (this.m_id.getObjectID() == 620) {
                this.m_BorderObj.paint(g, this.m_Perspective, arc, (float)this.m_Perspective.getLineWidth(this.m_id));
            } else {
                this.m_BorderObj.paint(g, this.m_Perspective, arc);
            }
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldHint);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, oldRenderingHint);
    }

    public void paint(Graphics g, Rectangle r) {
        this.paint(g, r, false, false);
    }

    public void paint(Graphics g, Rectangle r, boolean bOval, boolean bNoFill) {
        this.paint(g, r, bOval, bNoFill, false);
    }

    public void paint(Graphics g, Rectangle r, boolean bOval, boolean bNoFill, boolean bDotted) {
        if (this.m_DropShadowOffset != null) {
            Rectangle rDropShadow = new Rectangle(r.x + this.m_DropShadowOffset.width, r.y + this.m_DropShadowOffset.height, r.width, r.height);
            g.setColor(this.m_DropShadowColor);
            if (bOval) {
                g.fillOval(rDropShadow.x, rDropShadow.y, rDropShadow.width, rDropShadow.height);
            } else {
                g.fillRect(rDropShadow.x, rDropShadow.y, rDropShadow.width, rDropShadow.height);
            }
        }
        if (bOval) {
            if (!this.m_bTransparentFillColor && !bNoFill) {
                this.m_FillObj.fillOval(g, this.m_Perspective, r);
            }
            if (!this.m_bTransparentBorderColor) {
                this.m_BorderObj.paintOval(g, r);
            }
        } else {
            if (!this.m_bTransparentFillColor && !bNoFill) {
                this.m_FillObj.fillRect(g, this.m_Perspective, r);
            }
            if (!this.m_bTransparentBorderColor) {
                Rectangle s = new Rectangle(r);
                if (bDotted) {
                    this.m_BorderObj.paint(g, s, bDotted);
                } else {
                    this.m_BorderObj.paint(g, s);
                }
            }
        }
    }

    public void paint(Graphics g, String szText, Rectangle rBounds, Rectangle rInnerBounds, TextStyleObj textStyle, VC vc) {
        if (!this.m_bTransparentFillColor) {
            int nBackgroundFillType = this.m_Perspective.getFillType(this.m_Perspective.getChartBackground());
            boolean bPrintingInProgress = this.m_Perspective.getPrintingInProgress();
            this.m_FillObj.fillText(g, this.m_Perspective, szText, rBounds, rInnerBounds, this.m_DropShadowColor, this.m_DropShadowOffset, textStyle, vc, this.m_ChartBackgroundColor, nBackgroundFillType, bPrintingInProgress);
        }
    }

    public void paint(Graphics g, Point a, Point b, int nThick) {
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        double fNinetyRadians = 1.57;
        double fAngle = Math.atan2(dy, dx);
        double fTwoSeventyRadians = 4.71;
        double x = (double)nThick * Math.cos(fAngle + fNinetyRadians);
        double y = (double)nThick * Math.sin(fAngle + fNinetyRadians);
        double y2 = (double)(nThick / 2) * Math.sin(fAngle + fTwoSeventyRadians);
        double x2 = (double)(nThick / 2) * Math.cos(fAngle + fTwoSeventyRadians);
        Polygon pg = new Polygon();
        pg.addPoint(b.x + (int)Math.round(x2), b.y + (int)Math.round(y2));
        pg.addPoint(b.x + (int)Math.round(x) + (int)Math.round(x2), b.y + (int)Math.round(y) + (int)Math.round(y2));
        pg.addPoint(a.x + (int)Math.round(x) + (int)Math.round(x2), a.y + (int)Math.round(y) + (int)Math.round(y2));
        pg.addPoint(a.x + (int)Math.round(x2), a.y + (int)Math.round(y2));
        pg.addPoint(b.x + (int)Math.round(x2), b.y + (int)Math.round(y2));
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        g2.drawPolygon(pg.xpoints, pg.ypoints, pg.npoints);
        if (!this.m_bTransparentFillColor) {
            this.m_FillObj.fillPolygon(g, this.m_Perspective, pg);
        }
        this.m_FillObj.fillOval(g, this.m_Perspective, a.x - nThick / 2, a.y - nThick / 2, nThick, nThick);
        this.m_FillObj.fillOval(g, this.m_Perspective, b.x - nThick / 2, b.y - nThick / 2, nThick, nThick);
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(g, pg);
        }
    }

    public void paint(Graphics g, Point a, Point b, int nThick, int style, boolean isMarker) {
        if (g instanceof Graphics2D) {
            Stroke oldStroke = ((Graphics2D)g).getStroke();
            BasicStroke dashed = new BasicStroke(nThick, 0, 0);
            float dashLen = 10.0f;
            if (style != Perspective.SOLID) {
                if (style == Perspective.DASH) {
                    float[] dash1;
                    if (isMarker) {
                        dash1 = new float[]{4.0f, 2.0f, 4.0f};
                        dashLen = 2.0f;
                        nThick = 2;
                    } else {
                        dash1 = new float[]{dashLen, dashLen / 2.0f};
                    }
                    dashed = new BasicStroke(nThick, 0, 0, dashLen, dash1, 0.0f);
                } else if (style == Perspective.DOTTED) {
                    if (isMarker) {
                        nThick = 2;
                    }
                    if (nThick <= 1) {
                        nThick = 2;
                    }
                    float[] dash1 = new float[]{nThick};
                    dashed = new BasicStroke(nThick, 0, 0, 1.0f, dash1, 0.0f);
                } else if (style == Perspective.DASH_DOT) {
                    float[] dash1;
                    if (isMarker) {
                        dash1 = new float[]{3.0f, 1.0f, 2.0f, 1.0f, 3.0f};
                        nThick = 2;
                    } else {
                        dash1 = new float[]{dashLen, dashLen / 2.0f, nThick, dashLen / 2.0f};
                    }
                    dashed = new BasicStroke(nThick, 0, 0, 1.0f, dash1, 0.0f);
                }
            }
            ((Graphics2D)g).setStroke(dashed);
            if (!this.m_bTransparentFillColor) {
                g.setColor(this.getFillColor());
                g.drawLine(a.x, a.y, b.x, b.y);
            }
            if (!this.m_bTransparentBorderColor) {
                this.m_BorderObj.paint(g, a, b);
            }
            ((Graphics2D)g).setStroke(oldStroke);
        } else {
            this.paint(g, a, b, nThick);
        }
    }

    public void paint(Graphics g, Point2D a, Point2D b, int nThick, int style, boolean isMarker) {
        if (g instanceof Graphics2D) {
            Stroke oldStroke = ((Graphics2D)g).getStroke();
            BasicStroke dashed = new BasicStroke(nThick, 0, 0);
            float dashLen = 10.0f;
            if (style != Perspective.SOLID) {
                if (style == Perspective.DASH) {
                    float[] dash1;
                    if (isMarker) {
                        dash1 = new float[]{4.0f, 2.0f, 4.0f};
                        dashLen = 2.0f;
                        nThick = 2;
                    } else {
                        dash1 = new float[]{dashLen, dashLen / 2.0f};
                    }
                    dashed = new BasicStroke(nThick, 0, 0, dashLen, dash1, 0.0f);
                } else if (style == Perspective.DOTTED) {
                    if (isMarker) {
                        nThick = 2;
                    }
                    if (nThick <= 1) {
                        nThick = 2;
                    }
                    float[] dash1 = new float[]{nThick};
                    dashed = new BasicStroke(nThick, 0, 0, 1.0f, dash1, 0.0f);
                } else if (style == Perspective.DASH_DOT) {
                    float[] dash1;
                    if (isMarker) {
                        dash1 = new float[]{3.0f, 1.0f, 2.0f, 1.0f, 3.0f};
                        nThick = 2;
                    } else {
                        dash1 = new float[]{dashLen, dashLen / 2.0f, nThick, dashLen / 2.0f};
                    }
                    dashed = new BasicStroke(nThick, 0, 0, 1.0f, dash1, 0.0f);
                }
            }
            ((Graphics2D)g).setStroke(dashed);
            if (!this.m_bTransparentFillColor) {
                g.setColor(this.getFillColor());
                Line2D.Double line = new Line2D.Double(a, b);
                ((Graphics2D)g).draw(line);
            }
            if (!this.m_bTransparentBorderColor) {
                this.m_BorderObj.paint(g, a, b);
            }
            ((Graphics2D)g).setStroke(oldStroke);
        } else {
            Point p1 = new Point((int)Math.round(a.getX()), (int)Math.round(a.getY()));
            Point p2 = new Point((int)Math.round(b.getX()), (int)Math.round(b.getY()));
            this.paint(g, p1, p2, nThick);
        }
    }

    public void paint(Graphics g, Point[] points, int nThick, int style, boolean isMarker, boolean is3D) {
        Stroke oldStroke = ((Graphics2D)g).getStroke();
        BasicStroke dashed = new BasicStroke(nThick, 1, 1);
        float dashLen = 10.0f;
        if (style != Perspective.SOLID) {
            if (style == Perspective.DASH) {
                float[] dash1;
                if (isMarker) {
                    dash1 = new float[]{4.0f, 2.0f, 4.0f};
                    dashLen = 2.0f;
                    nThick = 2;
                } else {
                    dash1 = new float[]{dashLen, dashLen / 2.0f};
                }
                dashed = new BasicStroke(nThick, 0, 0, dashLen, dash1, 0.0f);
            } else if (style == Perspective.DOTTED) {
                if (isMarker) {
                    nThick = 2;
                }
                if (nThick <= 1) {
                    nThick = 2;
                }
                float[] dash1 = new float[]{nThick};
                dashed = new BasicStroke(nThick, 0, 0, 1.0f, dash1, 0.0f);
            } else if (style == Perspective.DASH_DOT) {
                float[] dash1;
                if (isMarker) {
                    dash1 = new float[]{3.0f, 1.0f, 2.0f, 1.0f, 3.0f};
                    nThick = 2;
                } else {
                    dash1 = new float[]{dashLen, dashLen / 2.0f, nThick, dashLen / 2.0f};
                }
                dashed = new BasicStroke(nThick, 0, 0, 1.0f, dash1, 0.0f);
            }
        }
        int np = points.length;
        int[] x = new int[np];
        int[] y = new int[np];
        int i = 0;
        while (i < np) {
            x[i] = points[i].x;
            y[i] = points[i].y;
            ++i;
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!this.m_bTransparentFillColor) {
            if (!is3D) {
                ((Graphics2D)g).setStroke(dashed);
                g.setColor(this.getFillColor());
                g.drawPolyline(x, y, np);
            } else {
                nThick = nThick % 2 == 0 ? nThick++ : nThick;
                int shadowX = nThick <= 2 ? 1 : 2;
                shadowX = nThick == 1 ? 0 : shadowX;
                int shadowY = nThick / 2 + 1;
                dashed = new BasicStroke(nThick, 2, 1);
                int i2 = 0;
                while (i2 < np) {
                    x[i2] = points[i2].x + shadowX;
                    y[i2] = points[i2].y - shadowY;
                    ++i2;
                }
                ((Graphics2D)g).setStroke(dashed);
                g.setColor(this._getBrighter(this.getFillColor()));
                g.drawPolyline(x, y, np);
                dashed = new BasicStroke(nThick, 2, 1);
                int i3 = 0;
                while (i3 < np) {
                    x[i3] = points[i3].x;
                    y[i3] = points[i3].y;
                    ++i3;
                }
                ((Graphics2D)g).setStroke(dashed);
                g.setColor(this.getFillColor());
                g.drawPolyline(x, y, np);
            }
        }
        ((Graphics2D)g).setStroke(oldStroke);
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    public void setBorderColor(Color color) {
        this.m_BorderObj.setColor(color);
    }

    public void setFillColor(int r, int g, int b, int a) {
        String sz = this.m_FillObj.getClass().getName();
        if (!sz.equals(CLASS_COLOR)) {
            this.m_FillObj = new FillColorObj();
        }
        ((FillColorObj)this.m_FillObj).setColor(r, g, b, a);
    }

    public void setFillColor(Color color) {
        this.setFillColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public Color getGradientColorAt(double relValue) {
        String sz = this.m_FillObj.getClass().getName();
        if (sz.equals(CLASS_GRADIENT)) {
            return ((FillGradientObj)this.m_FillObj).getColorAt(relValue);
        }
        return new Color(0, 0, 0, 0);
    }

    public void paint(Graphics g, Rectangle r, boolean bOval, boolean bNoFill, int nWidth) {
        if (bOval) {
            if (!this.m_bTransparentFillColor && !bNoFill) {
                this.m_FillObj.fillOval(g, this.m_Perspective, r);
            }
            if (!this.m_bTransparentBorderColor) {
                Rectangle rPrime = new Rectangle(r);
                if (nWidth == 0) {
                    this.m_BorderObj.paintOval(g, rPrime);
                } else {
                    int i = 0;
                    while (i < nWidth) {
                        rPrime.grow(1, 1);
                        this.m_BorderObj.paintOval(g, rPrime);
                        ++i;
                    }
                }
            }
        }
    }

    public IdentObj getIdentObj() {
        return this.m_id;
    }

    public Dimension getDropShadowOffset() {
        return this.m_DropShadowOffset;
    }

    public Color getDropShadowColor() {
        return this.m_DropShadowColor;
    }

    private Color _getBrighter(Color c) {
        double COLOR_FACTOR = 1.25;
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = (int)(0.25 / COLOR_FACTOR);
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        r = (int)((double)r * COLOR_FACTOR);
        g = (int)((double)g * COLOR_FACTOR);
        b = (int)((double)b * COLOR_FACTOR);
        if (r >= 255 && g >= 255 && b >= 255) {
            return c;
        }
        return new Color(Math.min(r, 255), Math.min(g, 255), Math.min(b, 255), c.getAlpha());
    }
}

