/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.draw.ColorObj;

public class ColorPinObj {
    private ColorObj m_LeftColor;
    private ColorObj m_RightColor;
    private double m_fPosition;

    public ColorPinObj() {
        this.m_LeftColor = new ColorObj();
        this.m_RightColor = new ColorObj();
        this.m_fPosition = 0.0;
    }

    public ColorPinObj(double fValue, ColorObj leftColor, ColorObj rightColor) {
        this.m_LeftColor = new ColorObj(leftColor);
        this.m_RightColor = new ColorObj(rightColor);
        if (!(this.m_fPosition >= 0.0) || !(this.m_fPosition <= 1.0)) {
            throw new AssertionException(0.0, 1.0, fValue);
        }
        this.m_fPosition = fValue;
    }

    public void copy(ColorPinObj cpo) {
        this.m_fPosition = cpo.m_fPosition;
        this.m_LeftColor.copy(cpo.m_LeftColor);
        this.m_RightColor.copy(cpo.m_RightColor);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColorPinObj)) {
            return false;
        }
        ColorPinObj cpo = (ColorPinObj)obj;
        boolean bEqual = this.m_fPosition == cpo.m_fPosition && this.m_LeftColor.equals(cpo.m_LeftColor) && this.m_RightColor.equals(cpo.m_RightColor);
        return bEqual;
    }

    public ColorObj getLeftColor() {
        return this.m_LeftColor;
    }

    public double getPosition() {
        return this.m_fPosition;
    }

    public ColorObj getRightColor() {
        return this.m_RightColor;
    }

    public void setColor(ColorObj leftColor, ColorObj rightColor) {
        this.m_LeftColor = new ColorObj(leftColor);
        this.m_RightColor = new ColorObj(rightColor);
    }
}

