/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.util.List;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.draw.ColorObj;
import oracle.dss.graph.pfj.draw.ColorPinObj;

public class ColorPinStripeObj {
    private Vector m_Pins = new Vector(2, 3);

    public ColorPinStripeObj() {
        ColorObj leftColor = new ColorObj(0.0, 0.0, 0.0, 1.0);
        ColorObj rightColor = new ColorObj(0.0, 0.0, 1.0, 1.0);
        ColorPinObj pin = new ColorPinObj(0.0, leftColor, rightColor);
        this.m_Pins.addElement(pin);
        leftColor = new ColorObj(0.0, 0.0, 0.0, 1.0);
        pin = new ColorPinObj(1.0, leftColor, rightColor);
        this.m_Pins.addElement(pin);
    }

    public void copy(ColorPinStripeObj cpso) {
        this.m_Pins.removeAllElements();
        int i = 0;
        while (i < cpso.m_Pins.size()) {
            ColorPinObj pinFrom = (ColorPinObj)cpso.m_Pins.elementAt(i);
            ColorPinObj pinTo = new ColorPinObj();
            pinTo.copy(pinFrom);
            this.m_Pins.addElement(pinTo);
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColorPinStripeObj)) {
            return false;
        }
        ColorPinStripeObj cpso = (ColorPinStripeObj)obj;
        boolean bEqual = this.m_Pins.size() == cpso.m_Pins.size();
        int i = 0;
        while (i < this.m_Pins.size() && bEqual) {
            ColorPinObj pinThat;
            ColorPinObj pinThis = (ColorPinObj)this.m_Pins.elementAt(i);
            if (!pinThis.equals(pinThat = (ColorPinObj)cpso.m_Pins.elementAt(i))) {
                bEqual = false;
            }
            ++i;
        }
        return bEqual;
    }

    public int findClosestPin(double fValue) {
        if (fValue < 0.0 || fValue > 1.0) {
            throw new AssertionException(0.0, 1.0, fValue);
        }
        double fDist = 1.0;
        int nClosest = 0;
        int nPin = 0;
        while (nPin < this.m_Pins.size()) {
            ColorPinObj pin = (ColorPinObj)this.m_Pins.elementAt(nPin);
            if (Math.abs(pin.getPosition() - fValue) < fDist) {
                fDist = Math.abs(pin.getPosition() - fValue);
                nClosest = nPin;
            }
            ++nPin;
        }
        return nClosest;
    }

    public void getColorAt(double fValue, ColorObj color) {
        if (fValue < 0.0 || fValue > 1.0) {
            throw new AssertionException(0.0, 1.0, fValue);
        }
        fValue = (double)((int)(100.0 * fValue)) / 100.0;
        int nSize = this.m_Pins.size();
        int i = 0;
        while (i < nSize - 1) {
            ColorPinObj leftPin = (ColorPinObj)this.m_Pins.elementAt(i);
            ColorPinObj rightPin = (ColorPinObj)this.m_Pins.elementAt(i + 1);
            if (fValue >= leftPin.getPosition() && fValue <= rightPin.getPosition()) {
                double fraction = (fValue - leftPin.getPosition()) / (rightPin.getPosition() - leftPin.getPosition());
                color.setRed(leftPin.getRightColor().getRed() + fraction * (rightPin.getLeftColor().getRed() - leftPin.getRightColor().getRed()));
                color.setGreen(leftPin.getRightColor().getGreen() + fraction * (rightPin.getLeftColor().getGreen() - leftPin.getRightColor().getGreen()));
                color.setBlue(leftPin.getRightColor().getBlue() + fraction * (rightPin.getLeftColor().getBlue() - leftPin.getRightColor().getBlue()));
                color.setAlpha(leftPin.getRightColor().getAlpha() + fraction * (rightPin.getLeftColor().getAlpha() - leftPin.getRightColor().getAlpha()));
                return;
            }
            ++i;
        }
        color.setColor(0, 0, 0, 0);
    }

    public void insertPin(double fValue, ColorObj leftColor, ColorObj rightColor) {
        if (fValue < 0.0 || fValue > 1.0) {
            throw new AssertionException(0.0, 1.0, fValue);
        }
        int nClosestPin = this.findClosestPin(fValue);
        ColorPinObj closestPin = (ColorPinObj)this.m_Pins.elementAt(nClosestPin);
        if (Math.abs(closestPin.getPosition() - fValue) < 0.001) {
            closestPin.setColor(leftColor, rightColor);
        } else {
            ColorPinObj pin = new ColorPinObj(fValue, leftColor, rightColor);
            if (closestPin.getPosition() > fValue) {
                this.m_Pins.insertElementAt(pin, nClosestPin);
            } else {
                this.m_Pins.insertElementAt(pin, nClosestPin + 1);
            }
        }
    }

    public List getPins() {
        return this.m_Pins;
    }
}

