/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Map;
import oracle.dss.graph.flash.ChartRenderer;
import oracle.dss.graph.pfj.GraphExportXMLWriter;
import oracle.dss.graph.pfj.GraphSVGWriter;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class DetImage
extends DetObj {
    private Rectangle m_rBounds;

    public DetImage(Detectiv m_Detectiv, IdentObj id, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, Rectangle rBounds) {
        super(m_Detectiv, id, blackBox, clipRect, bMoveable, true, false);
        this.m_rBounds = new Rectangle(rBounds.x, rBounds.y, rBounds.width, rBounds.height);
    }

    public Rectangle getBounds() {
        return this.m_rBounds;
    }

    public void hilite(Graphics g, VC vc) {
    }

    public boolean isPointInObj(int x, int y, VC vc) {
        return this.m_rBounds.contains(vc.virtToDestX(x), vc.virtToDestY(y));
    }

    public boolean isPointInObj(Point pt, VC vc) {
        return this.isPointInObj(pt.x, pt.y, vc);
    }

    public void paintIt(Graphics g, VC vc) {
        Image image = null;
        if (this.m_rBounds.width < 16 && TextStyleObj.SMALL_DRILL_IMAGE == null) {
            TextStyleObj.SMALL_DRILL_IMAGE = TextStyleObj.getImageResource(TextStyleObj.class, "images/graph_drill_up.gif");
        } else if (this.m_rBounds.width >= 16 && TextStyleObj.LARGE_DRILL_IMAGE == null) {
            TextStyleObj.LARGE_DRILL_IMAGE = TextStyleObj.getImageResource(TextStyleObj.class, "images/large_drill_up.gif");
        }
        image = this.m_rBounds.width < 16 ? TextStyleObj.SMALL_DRILL_IMAGE : TextStyleObj.LARGE_DRILL_IMAGE;
        int imageSize = image.getWidth(null);
        g.drawImage(image, this.m_rBounds.x, this.m_rBounds.y, null);
    }

    public void renderItToSVG(Map context) throws IOException, Exception {
        boolean bStartG;
        boolean bOnMouseOverOutPresent;
        boolean bOnClickPresent;
        GraphSVGWriter writer = (GraphSVGWriter)context.get("svgWriter");
        int mode = (Integer)context.get("svgMode");
        boolean bTooltips = (mode & 2) != 0;
        String[] tooltipsArray = null;
        if (bTooltips) {
            tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
        }
        boolean bShapeAttributes = (mode & 0x10) != 0;
        String clickEventJS = null;
        boolean bl = bOnClickPresent = bShapeAttributes && writer.isOnClickPresent();
        if (bShapeAttributes && !bOnClickPresent) {
            clickEventJS = writer.getClickEventJS();
        }
        boolean bl2 = bOnMouseOverOutPresent = bShapeAttributes && writer.isOnMouseOverOutPresent();
        if (bOnMouseOverOutPresent) {
            bTooltips = false;
        }
        String saAlt = null;
        String saTitle = null;
        String saHRef = null;
        String saTarget = null;
        if (bShapeAttributes) {
            saAlt = writer.getShapeAttributesAlt();
            saTitle = writer.getShapeAttributesTitle();
            if (!bOnClickPresent) {
                saHRef = writer.getShapeAttributesHRef();
            }
            saTarget = writer.getShapeAttributesTarget();
        }
        boolean bDrilling = (mode & 4) != 0;
        bDrilling = bDrilling && !bOnClickPresent && clickEventJS == null;
        String drillJS = null;
        if (bDrilling && ((drillJS = writer.getDrillJS(this)) == null || drillJS.length() < 1)) {
            bDrilling = false;
        }
        if (bTooltips) {
            if (saAlt != null) {
                tooltipsArray = new String[]{saAlt};
            } else if (saTitle != null) {
                tooltipsArray = new String[]{saTitle};
            }
        }
        if (bDrilling && bTooltips && tooltipsArray == null) {
            tooltipsArray = new String[]{writer.getDrillTooltip(this)};
        }
        bTooltips = bTooltips && tooltipsArray != null && tooltipsArray.length > 0;
        boolean bStartA = bDrilling || bOnClickPresent || clickEventJS != null || saHRef != null;
        boolean bAnchorGroup = false;
        if (bStartA) {
            writer.startElement("a");
            String href = "";
            if (clickEventJS == null && !bDrilling && saHRef != null) {
                href = saHRef;
            }
            writer.writeAttribute("xlink:href", href);
            if (saTarget != null) {
                writer.writeAttribute("target", saTarget);
            }
            String strOnclick = null;
            if (clickEventJS != null) {
                strOnclick = clickEventJS;
            } else if (bDrilling) {
                strOnclick = drillJS;
            }
            if (strOnclick != null) {
                bAnchorGroup = true;
                writer.startElement("g");
                writer.writeAttribute("onclick", strOnclick);
            }
        }
        boolean bl3 = bStartG = bTooltips || bDrilling || bShapeAttributes;
        if (bStartG) {
            writer.startElement("g");
            if (bShapeAttributes) {
                writer.writeShapeAttributes();
            }
        }
        if (this.m_rBounds.width < 16) {
            writer.writeSmallDrillUpArrow(this.m_rBounds.x, this.m_rBounds.y);
        } else {
            writer.writeLargeDrillUpArrow(this.m_rBounds.x, this.m_rBounds.y);
        }
        if (bStartG) {
            writer.startRectElement(this.m_rBounds);
            writer.writeAttribute("fill", "none");
            writer.writeAttribute("pointer-events", "visible");
            if (bTooltips) {
                boolean bTooltipWritten = writer.writeTooltip(tooltipsArray);
            } else if (saTitle != null) {
                writer.writeTitleElement(saTitle);
            }
            writer.endElement();
        }
        if (bStartG) {
            writer.endElement();
        }
        if (bStartA) {
            if (bAnchorGroup) {
                writer.endElement();
            }
            writer.endElement();
        }
    }

    public void renderItToXML(Map context) throws IOException, Exception {
        GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
        String drillJS = writer.getDrillJS(this);
        boolean bDrilling = drillJS != null && drillJS.length() > 0;
        Image image = null;
        if (this.m_rBounds.width < 16) {
            if (TextStyleObj.SMALL_DRILL_IMAGE == null) {
                TextStyleObj.SMALL_DRILL_IMAGE = TextStyleObj.getImageResource(TextStyleObj.class, "images/graph_drill_up.gif");
            }
            image = TextStyleObj.SMALL_DRILL_IMAGE;
        } else {
            if (TextStyleObj.LARGE_DRILL_IMAGE == null) {
                TextStyleObj.LARGE_DRILL_IMAGE = TextStyleObj.getImageResource(TextStyleObj.class, "images/large_drill_up.gif");
            }
            image = TextStyleObj.LARGE_DRILL_IMAGE;
        }
        int imageSize = image.getWidth(null);
        writer.startElement("img");
        writer.writeAttribute("x", this.m_rBounds.x);
        writer.writeAttribute("y", this.m_rBounds.y);
        writer.writeAttribute("w", imageSize);
        writer.writeAttribute("h", imageSize);
        String facesResourceURL = this.m_Detectiv.getPerspective().getFacesResourceURL();
        if (facesResourceURL == null) {
            facesResourceURL = "";
        }
        if (this.m_rBounds.width < 16) {
            writer.writeAttribute("url", facesResourceURL + "/bi/images/graph/graph_drill_up.gif");
        } else {
            writer.writeAttribute("url", facesResourceURL + "/bi/images/graph/large_drill_up.gif");
        }
        if (bDrilling) {
            writer.writeAttribute("drillJs", drillJS);
        }
        if (!writer.hasAlt()) {
            String[] tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
            if (bDrilling && tooltipsArray == null) {
                tooltipsArray = new String[]{writer.getDrillTooltip(this)};
            }
            if (tooltipsArray == null || tooltipsArray.length > 0) {
                // empty if block
            }
            writer.writeTooltipAttribute(tooltipsArray);
        }
        writer.writeShapeAttributesElement();
        writer.endElement();
    }

    public void setBounds(Rectangle rBounds) {
        this.m_rBounds = rBounds;
    }

    public Polygon getShape(VC vc) {
        return this.rectToPoly(vc.destToVirt(this.m_rBounds));
    }

    public void renderItToFlash(Map context) {
        Image image = null;
        ChartRenderer chartRenderer = (ChartRenderer)context.get("flashRenderer");
        if (this.m_rBounds.width < 16 && TextStyleObj.SMALL_DRILL_IMAGE == null) {
            TextStyleObj.SMALL_DRILL_IMAGE = TextStyleObj.getImageResource(TextStyleObj.class, "images/graph_drill_up.gif");
        } else if (this.m_rBounds.width >= 16 && TextStyleObj.LARGE_DRILL_IMAGE == null) {
            TextStyleObj.LARGE_DRILL_IMAGE = TextStyleObj.getImageResource(TextStyleObj.class, "images/large_drill_up.gif");
        }
        image = this.m_rBounds.width < 16 ? TextStyleObj.SMALL_DRILL_IMAGE : TextStyleObj.LARGE_DRILL_IMAGE;
        chartRenderer.drawImage(image, this.m_rBounds.x, this.m_rBounds.y, null);
    }
}

