/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dss.graph.flash.ChartRenderer;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.GraphExportXMLWriter;
import oracle.dss.graph.pfj.GraphSVGWriter;
import oracle.dss.graph.pfj.JChart_2D;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.math.FP;

public class DetPolygon
extends DetObj {
    Polygon m_polygon;
    Polygon m_destPolygon;
    double m_fIntensity;
    Area m_area;
    Arc2D m_arc2D;
    GeneralPath m_path;
    Area m_fillArea;
    Ellipse2D m_ellipse2D;
    Area m_detectArea;
    Area m_boundingArea;
    Polygon m_fillPolygon;

    private void $init$() {
        this.m_area = null;
        this.m_arc2D = null;
        this.m_ellipse2D = null;
        this.m_detectArea = null;
        this.m_boundingArea = null;
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, double fIntensity) {
        super(detectiv, id, blackBox, null, false, true, true);
        this.$init$();
        this.m_polygon = poly;
        this.m_fIntensity = fIntensity;
        if (id.getObjectID() == 277 && this.m_polygon != null) {
            int destWidth = this.m_Detectiv.getPerspective().getVC().virtToDestWidth(this.m_polygon.getBounds().width);
            this.setVisualEffectsMap(JChart_2D.getBarEffectsMap(destWidth));
        } else if (id.getObjectID() == 256 && this.m_Detectiv.getPerspective().getDepthRadius() == 0) {
            this.setVisualEffectsMap(JChart_2D.getAreaEffectsMap());
        }
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, double fIntensity, boolean bHiliteable) {
        this(detectiv, id, poly, blackBox, null, fIntensity, bHiliteable);
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, double fIntensity, boolean bHiliteable, Area area) {
        this(detectiv, id, poly, blackBox, null, fIntensity, bHiliteable);
        this.m_area = area;
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon fillPoly, BlackBoxIF blackBox, double fIntensity, boolean bHiliteable, GeneralPath path, Arc2D arc, Area fillArea, Area boundingArea) {
        this(detectiv, id, null, blackBox, fIntensity, bHiliteable, arc);
        this.m_path = path;
        this.m_fillArea = fillArea;
        this.m_boundingArea = boundingArea;
        this.m_fillPolygon = fillPoly;
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Area detectArea, BlackBoxIF blackBox, double fIntensity, boolean bHiliteable, GeneralPath path, Ellipse2D ellipse) {
        this(detectiv, id, null, blackBox, null, fIntensity, bHiliteable);
        this.m_path = path;
        this.m_detectArea = detectArea;
        this.m_ellipse2D = ellipse;
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, double fIntensity, boolean bHiliteable, Arc2D arc) {
        this(detectiv, id, poly, blackBox, null, fIntensity, bHiliteable);
        this.m_arc2D = arc;
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, Rectangle clipRect) {
        this(detectiv, id, poly, blackBox, clipRect, 1.0, true);
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, Rectangle clipRect, List groups) {
        this(detectiv, id, poly, blackBox, clipRect, 1.0, true);
        this.m_groups = groups;
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, boolean bHiliteable) {
        super(detectiv, id, blackBox, null, false, true, bHiliteable);
        this.$init$();
        this.m_fIntensity = 1.0;
        this.m_destPolygon = poly;
        if (id.getObjectID() == 277 && this.m_destPolygon != null) {
            this.setVisualEffectsMap(JChart_2D.getBarEffectsMap(this.m_destPolygon.getBounds().width));
        } else if (id.getObjectID() == 256 && this.m_Detectiv.getPerspective().getDepthRadius() == 0) {
            this.setVisualEffectsMap(JChart_2D.getAreaEffectsMap());
        }
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, Rectangle clipRect, double fIntensity, boolean bHiliteable) {
        super(detectiv, id, blackBox, clipRect, false, true, bHiliteable);
        this.$init$();
        this.m_polygon = poly;
        this.m_fIntensity = fIntensity;
        if (id.getObjectID() == 277 && this.m_polygon != null) {
            int destWidth = this.m_Detectiv.getPerspective().getVC().virtToDestWidth(this.m_polygon.getBounds().width);
            this.setVisualEffectsMap(JChart_2D.getBarEffectsMap(destWidth));
        } else if (id.getObjectID() == 256 && this.m_Detectiv.getPerspective().getDepthRadius() == 0) {
            this.setVisualEffectsMap(JChart_2D.getAreaEffectsMap());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DetPolygon)) {
            return false;
        }
        DetPolygon detPolygon = (DetPolygon)obj;
        return this.m_id.equals(detPolygon.m_id);
    }

    public Rectangle getBounds() {
        if (this.m_Detectiv.getPerspective().isFunnel()) {
            if (this.m_id.getObjectID() == 620) {
                IdentObj id = new IdentObj(this.m_id);
                id.setMiscID(627);
                DetObj detObj = this.m_Detectiv.findNodeOf(id);
                return detObj.getBounds();
            }
            if (this.m_ellipse2D != null) {
                return this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_ellipse2D.getBounds2D().getBounds());
            }
            return this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_fillPolygon).getBounds();
        }
        if (this.m_destPolygon != null) {
            return this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_destPolygon).getBounds();
        }
        return this.m_polygon.getBounds();
    }

    public void hilite(Graphics g, VC vc) {
        g.setXORMode(Color.yellow);
        if (this.m_Detectiv.getPerspective().isFunnel()) {
            Graphics2D g2 = (Graphics2D)g;
            Object oldHint = g2.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            Object oldRenderingHint = g2.getRenderingHint(RenderingHints.KEY_RENDERING);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            if (this.m_path != null) {
                g2.draw(this.m_path);
            } else if (this.m_arc2D != null) {
                g2.draw(this.m_arc2D);
            } else if (this.m_ellipse2D != null) {
                g2.draw(this.m_ellipse2D);
            }
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldHint);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, oldRenderingHint);
        } else if (this.m_destPolygon != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(1.0f, 1, 1));
            g2.drawPolygon(this.m_destPolygon);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            if (this.m_arc2D != null || this.m_area != null) {
                this.m_Detectiv.getPerspective();
                if (Perspective.compareVersions(Perspective.m_JavaVersion, "1.4.0") == -1 || this.m_Detectiv.getPerspective().getPrimitiveAntialiasing()) {
                    if (this.m_arc2D != null) {
                        g2.draw(this.m_arc2D);
                    } else {
                        g2.draw(this.m_area);
                    }
                } else {
                    g2.setStroke(new BasicStroke(1.01f));
                    if (this.m_arc2D != null) {
                        g2.draw(this.m_arc2D);
                    } else {
                        g2.draw(this.m_area);
                    }
                    g2.setStroke(new BasicStroke(1.0f));
                }
            } else if (this.m_Detectiv.getPerspective().isPie()) {
                g2.setStroke(new BasicStroke(1.0f, 1, 1));
                g2.draw(vc.virtToDestPath(this.m_polygon));
            } else {
                g2.setStroke(new BasicStroke(1.0f, 1, 1));
                Polygon dest = vc.virtToDest(this.m_polygon);
                g2.drawPolygon(dest);
            }
        }
        g.setPaintMode();
    }

    public boolean isPointInObj(int x, int y, VC vc) {
        if (this.m_Detectiv.getPerspective().isFunnel()) {
            if (this.m_fillPolygon != null) {
                return this.m_bDetectable && this.m_fillPolygon.contains(vc.virtToDestX(x), vc.virtToDestY(y));
            }
            if (this.m_detectArea != null) {
                return this.m_bDetectable && this.m_detectArea.contains(vc.virtToDestX(x), vc.virtToDestY(y));
            }
            return false;
        }
        if (this.m_destPolygon != null) {
            return this.m_bDetectable && this.m_destPolygon.contains(vc.virtToDestX(x), vc.virtToDestY(y));
        }
        return this.m_bDetectable && this.m_polygon.contains(x, y);
    }

    public boolean isPointInObj(Point pt, VC vc) {
        return this.isPointInObj(pt.x, pt.y, vc);
    }

    public void paintIt(Graphics g, VC vc) {
        Polygon pDest = null;
        GeneralPath path = null;
        if (this.m_destPolygon != null) {
            pDest = this.m_destPolygon;
        } else if (this.m_area == null && this.m_arc2D == null && this.m_Detectiv.getPerspective().isPie()) {
            path = vc.virtToDestPath(this.m_polygon);
        } else if (!this.m_Detectiv.getPerspective().isFunnel() && this.m_polygon != null) {
            pDest = vc.virtToDest(this.m_polygon);
        }
        if (FP.equal(this.m_fIntensity, 1.0) || this.m_blackBox.getFillType() != 1) {
            this.paint(g, pDest, this.m_area, this.m_arc2D, path);
        } else {
            Color colorOrig = this.m_blackBox.getFillColor();
            if (colorOrig == null) {
                this.paint(g, pDest, this.m_area, this.m_arc2D, path);
            } else {
                double fR = (double)colorOrig.getRed() * this.m_fIntensity;
                double fG = (double)colorOrig.getGreen() * this.m_fIntensity;
                double fB = (double)colorOrig.getBlue() * this.m_fIntensity;
                this.m_blackBox.setFillColor(new Color(FP.round(fR), FP.round(fG), FP.round(fB), colorOrig.getAlpha()));
                this.paint(g, pDest, this.m_area, this.m_arc2D, path);
                this.m_blackBox.setFillColor(colorOrig);
            }
        }
    }

    public void renderItToSVG(Map context) throws IOException, Exception {
        VC vc = (VC)context.get("svgVC");
        Polygon pDest = null;
        GeneralPath path = null;
        if (this.m_destPolygon != null) {
            pDest = this.m_destPolygon;
        } else if (this.m_area == null && this.m_arc2D == null && this.m_Detectiv.getPerspective().isPie()) {
            path = vc.virtToDestPath(this.m_polygon);
        } else if (!this.m_Detectiv.getPerspective().isFunnel()) {
            pDest = vc.virtToDest(this.m_polygon);
        }
        if (FP.equal(this.m_fIntensity, 1.0) || this.m_blackBox.getFillType() != 1) {
            this.renderToSVG(context, pDest, this.m_area, this.m_arc2D, path);
        } else {
            Color colorOrig = this.m_blackBox.getFillColor();
            if (colorOrig == null) {
                this.renderToSVG(context, pDest, this.m_area, this.m_arc2D, path);
            } else {
                double fR = (double)colorOrig.getRed() * this.m_fIntensity;
                double fG = (double)colorOrig.getGreen() * this.m_fIntensity;
                double fB = (double)colorOrig.getBlue() * this.m_fIntensity;
                this.m_blackBox.setFillColor(new Color(FP.round(fR), FP.round(fG), FP.round(fB), colorOrig.getAlpha()));
                this.renderToSVG(context, pDest, this.m_area, this.m_arc2D, path);
                this.m_blackBox.setFillColor(colorOrig);
            }
        }
    }

    public void renderItToFlash(Map context) throws Exception {
        VC vc = (VC)context.get("flashVC");
        Polygon pDest = null;
        GeneralPath path = null;
        if (this.m_destPolygon != null) {
            pDest = this.m_destPolygon;
        } else if (this.m_area == null && this.m_arc2D == null && this.m_Detectiv.getPerspective().isPie()) {
            path = vc.virtToDestPath(this.m_polygon);
        } else if (!this.m_Detectiv.getPerspective().isFunnel()) {
            pDest = vc.virtToDest(this.m_polygon);
        }
        if (FP.equal(this.m_fIntensity, 1.0) || this.m_blackBox.getFillType() != 1) {
            this.renderToFlash(context, pDest, this.m_area, this.m_arc2D, path);
        } else {
            Color colorOrig = this.m_blackBox.getFillColor();
            if (colorOrig == null) {
                this.renderToFlash(context, pDest, this.m_area, this.m_arc2D, path);
            } else {
                double fR = (double)colorOrig.getRed() * this.m_fIntensity;
                double fG = (double)colorOrig.getGreen() * this.m_fIntensity;
                double fB = (double)colorOrig.getBlue() * this.m_fIntensity;
                this.m_blackBox.setFillColor(new Color(FP.round(fR), FP.round(fG), FP.round(fB), colorOrig.getAlpha()));
                this.renderToFlash(context, pDest, this.m_area, this.m_arc2D, path);
                this.m_blackBox.setFillColor(colorOrig);
            }
        }
    }

    public void paint(Graphics g, Polygon p, Area area, Arc2D arc, GeneralPath path) {
        if (arc != null && !this.m_Detectiv.getPerspective().isFunnel()) {
            this.m_blackBox.paint(g, arc);
        } else if (area != null) {
            this.m_blackBox.paint(g, area);
        } else if (this.m_Detectiv.getPerspective().isPie() && path != null) {
            this.m_blackBox.paint(g, path, this.m_clipRect);
        } else if (this.m_Detectiv.getPerspective().isFunnel()) {
            this.m_blackBox.paint(g, arc, this.m_fillArea, this.m_boundingArea);
            if (this.m_ellipse2D != null) {
                this.m_blackBox.paint(g, this.m_ellipse2D);
            }
        } else {
            this.m_blackBox.paint(g, p);
        }
    }

    protected void renderToSVG(Map context, Polygon p, Area area, Arc2D arc, GeneralPath path) throws IOException, Exception {
        boolean bOnMouseOverOutPresent;
        boolean bOnClickPresent;
        GraphSVGWriter writer = (GraphSVGWriter)context.get("svgWriter");
        int mode = (Integer)context.get("svgMode");
        boolean bTooltips = (mode & 2) != 0;
        String[] tooltipsArray = null;
        if (bTooltips) {
            tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
        }
        boolean bShapeAttributes = (mode & 0x10) != 0;
        String clickEventJS = null;
        boolean bl = bOnClickPresent = bShapeAttributes && writer.isOnClickPresent();
        if (bShapeAttributes && !bOnClickPresent) {
            clickEventJS = writer.getClickEventJS();
        }
        boolean bl2 = bOnMouseOverOutPresent = bShapeAttributes && writer.isOnMouseOverOutPresent();
        if (bOnMouseOverOutPresent) {
            bTooltips = false;
        }
        String saAlt = null;
        String saTitle = null;
        String saHRef = null;
        String saTarget = null;
        if (bShapeAttributes) {
            saAlt = writer.getShapeAttributesAlt();
            saTitle = writer.getShapeAttributesTitle();
            if (!bOnClickPresent) {
                saHRef = writer.getShapeAttributesHRef();
            }
            saTarget = writer.getShapeAttributesTarget();
        }
        boolean bDrilling = (mode & 4) != 0;
        bDrilling = bDrilling && !bOnClickPresent && clickEventJS == null;
        String drillJS = null;
        String link = null;
        boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
        if (bLink && ((link = writer.getLink(this)) == null || link.length() < 1)) {
            bLink = false;
        }
        if (bDrilling && ((drillJS = writer.getDrillJS(this)) == null || drillJS.length() < 1)) {
            bDrilling = false;
        }
        if (bTooltips) {
            if (saAlt != null) {
                tooltipsArray = new String[]{saAlt};
            } else if (saTitle != null) {
                tooltipsArray = new String[]{saTitle};
            }
        }
        if (bDrilling && bTooltips && tooltipsArray == null) {
            tooltipsArray = new String[]{writer.getDrillTooltip(this)};
        }
        bTooltips = bTooltips && tooltipsArray != null && tooltipsArray.length > 0;
        boolean bStartA = bDrilling || bOnClickPresent || clickEventJS != null || saHRef != null || bLink;
        boolean bAnchorGroup = false;
        if (bStartA) {
            writer.startElement("a");
            String href = "";
            if (clickEventJS == null && !bDrilling && saHRef != null) {
                href = saHRef;
            } else if (clickEventJS == null && !bDrilling && bLink) {
                href = link;
            }
            writer.writeAttribute("xlink:href", href);
            if (saTarget != null) {
                writer.writeAttribute("target", saTarget);
            }
            String strOnclick = null;
            if (clickEventJS != null) {
                strOnclick = clickEventJS;
            } else if (bDrilling) {
                strOnclick = drillJS;
            }
            if (strOnclick != null) {
                bAnchorGroup = true;
                writer.startElement("g");
                writer.writeAttribute("onclick", strOnclick);
            }
        }
        boolean bElementStarted = false;
        if (arc != null && !this.m_Detectiv.getPerspective().isFunnel()) {
            bElementStarted = writer.startElement(this.m_id, this.m_blackBox, arc);
        } else if (area != null) {
            bElementStarted = writer.startElement(this.m_id, this.m_blackBox, area);
        } else if (this.m_Detectiv.getPerspective().isPie() && path != null) {
            bElementStarted = writer.startElement(this.m_id, this.m_blackBox, path);
        } else if (this.m_Detectiv.getPerspective().isFunnel()) {
            this._writeFunnelSVGElements(arc, writer, bShapeAttributes, bTooltips, saTitle, tooltipsArray);
            bElementStarted = false;
        } else {
            bElementStarted = writer.startElement(this.m_id, this.m_blackBox, p);
        }
        if (bElementStarted) {
            if (this.m_id.getObjectID() == 357) {
                writer.writeAttribute("id", writer.getReferenceObjectId(this.m_id.getMiscID()));
                int graphID = this.m_Detectiv.getPerspective().getReferenceAssociation(this.m_id);
                int display = this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID);
                if (display == 2) {
                    writer.writeAttribute("visibility", "hidden");
                }
                writer.writeAttribute("pointer-events", "none");
            }
            if (bShapeAttributes) {
                writer.writeShapeAttributes();
            }
            if (bTooltips) {
                int rbMode;
                List l;
                String onMouseOverJS = null;
                String onMouseOutJS = null;
                int graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID());
                if (graphID != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2 && (l = writer.getReferenceObjects(this.m_id)) != null) {
                    context.put("svgHasReferenceObj", Boolean.TRUE);
                    StringBuilder strBuf = new StringBuilder("evt,");
                    int i = 0;
                    while (i < l.size() - 1) {
                        strBuf.append("'" + (String)l.get(i) + "',");
                        ++i;
                    }
                    strBuf.append("'" + (String)l.get(l.size() - 1) + "'");
                    onMouseOverJS = "bi_refObj_show_mOver(" + strBuf.toString() + ");";
                    onMouseOutJS = "bi_refObj_hide_mOut(" + strBuf.toString() + ");";
                }
                if ((rbMode = this.m_Detectiv.getPerspective().getIntegerProp(Attr.SeriesRolloverBehavior)) != 0) {
                    String shfOver = new String("bi_rollover(evt, true, '" + writer.getSimpleBeanName() + "');");
                    String shfOut = new String("bi_rollover(evt, false, '" + writer.getSimpleBeanName() + "');");
                    onMouseOverJS = onMouseOverJS != null ? onMouseOverJS + shfOver : shfOver;
                    onMouseOutJS = onMouseOutJS != null ? onMouseOutJS + shfOut : shfOut;
                }
                boolean bTooltipWritten = writer.writeTooltip(tooltipsArray, onMouseOverJS, onMouseOutJS);
            } else {
                List l;
                int graphID;
                String onMouseOverJS = null;
                String onMouseOutJS = null;
                int rbMode = this.m_Detectiv.getPerspective().getIntegerProp(Attr.SeriesRolloverBehavior);
                if (rbMode != 0 && this.m_id.isSeriesRelated()) {
                    String shfOver = new String("bi_rollover(evt, true, '" + writer.getSimpleBeanName() + "');");
                    String shfOut = new String("bi_rollover(evt, false, '" + writer.getSimpleBeanName() + "');");
                    onMouseOverJS = onMouseOverJS != null ? onMouseOverJS + shfOver : shfOver;
                    onMouseOutJS = onMouseOutJS != null ? onMouseOutJS + shfOut : shfOut;
                }
                if ((graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID())) != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2 && (l = writer.getReferenceObjects(this.m_id)) != null) {
                    context.put("svgHasReferenceObj", Boolean.TRUE);
                    StringBuilder strBuf = new StringBuilder("evt,");
                    int i = 0;
                    while (i < l.size() - 1) {
                        strBuf.append("'" + (String)l.get(i) + "',");
                        ++i;
                    }
                    strBuf.append("'" + (String)l.get(l.size() - 1) + "'");
                    onMouseOverJS = onMouseOverJS == null ? "bi_refObj_show_mOver(" + strBuf.toString() + ");" : onMouseOverJS + "bi_refObj_show_mOver(" + strBuf.toString() + ");";
                    onMouseOutJS = onMouseOutJS == null ? "bi_refObj_hide_mOut(" + strBuf.toString() + ");" : "bi_refObj_hide_mOut(" + strBuf.toString() + ");";
                }
                if (onMouseOverJS != null) {
                    writer.writeAttribute("onmouseover", onMouseOverJS);
                }
                if (onMouseOutJS != null) {
                    writer.writeAttribute("onmouseout", onMouseOutJS);
                }
                if (saTitle != null) {
                    writer.writeTitleElement(saTitle);
                }
            }
            writer.endElement();
        }
        if (bStartA) {
            if (bAnchorGroup) {
                writer.endElement();
            }
            writer.endElement();
        }
    }

    public void renderItToXML(Map context) throws IOException, Exception {
        VC vc = (VC)context.get("xmlVC");
        Polygon pDest = null;
        GeneralPath path = null;
        if (this.m_destPolygon != null) {
            pDest = this.m_destPolygon;
        } else if (this.m_area == null && this.m_arc2D == null && this.m_Detectiv.getPerspective().isPie()) {
            path = vc.virtToDestPath(this.m_polygon);
        } else if (!this.m_Detectiv.getPerspective().isFunnel()) {
            pDest = vc.virtToDest(this.m_polygon);
        }
        if (FP.equal(this.m_fIntensity, 1.0) || this.m_blackBox.getFillType() != 1) {
            this.renderToXML(context, pDest, this.m_area, this.m_arc2D, path);
        } else {
            Color colorOrig = this.m_blackBox.getFillColor();
            if (colorOrig == null) {
                this.renderToXML(context, pDest, this.m_area, this.m_arc2D, path);
            } else {
                double fR = (double)colorOrig.getRed() * this.m_fIntensity;
                double fG = (double)colorOrig.getGreen() * this.m_fIntensity;
                double fB = (double)colorOrig.getBlue() * this.m_fIntensity;
                this.m_blackBox.setFillColor(new Color(FP.round(fR), FP.round(fG), FP.round(fB), colorOrig.getAlpha()));
                this.renderToXML(context, pDest, this.m_area, this.m_arc2D, path);
                this.m_blackBox.setFillColor(colorOrig);
            }
        }
    }

    protected void renderToXML(Map context, Polygon p, Area area, Arc2D arc, GeneralPath path) throws IOException, Exception {
        String drillJS;
        boolean bDrilling;
        GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
        String[] tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
        String link = null;
        boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
        if (bLink && ((link = this.m_Detectiv.getPerspective().getLink(this)) == null || link.length() < 1)) {
            bLink = false;
        }
        boolean bl = bDrilling = (drillJS = writer.getDrillJS(this)) != null && drillJS.length() > 0;
        if (bDrilling && tooltipsArray == null) {
            tooltipsArray = new String[]{writer.getDrillTooltip(this)};
        }
        boolean bTooltips = tooltipsArray != null && tooltipsArray.length > 0;
        boolean bElementStarted = false;
        Rectangle gradRect = null;
        if (arc != null && !this.m_Detectiv.getPerspective().isFunnel()) {
            bElementStarted = writer.startElement(this.m_id, this.m_blackBox, arc);
            gradRect = arc.getBounds();
        } else if (area != null) {
            bElementStarted = writer.startElement(this.m_id, this.m_blackBox, area);
            gradRect = this.m_id.getObjectID() == 339 && p != null ? p.getBounds() : area.getBounds();
        } else if (this.m_Detectiv.getPerspective().isPie() && path != null) {
            bElementStarted = writer.startElement(this.m_id, this.m_blackBox, path);
            gradRect = path.getBounds();
        } else if (this.m_Detectiv.getPerspective().isFunnel()) {
            this._writeFunnelXMLElements(arc, writer, bTooltips, tooltipsArray);
            bElementStarted = false;
        } else {
            bElementStarted = writer.startElement(this.m_id, this.m_blackBox, p);
            gradRect = p.getBounds();
        }
        if (bElementStarted) {
            if (this.m_id.getObjectID() == 357) {
                int graphID = this.m_Detectiv.getPerspective().getReferenceAssociation(this.m_id);
                int display = this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID);
                if (display == 2) {
                    writer.writeAttribute("v", "h");
                }
            }
            writer.writeDataZoomAndScrollEventJsAttributes(this);
            if (bDrilling) {
                writer.writeAttribute("drillJs", drillJS);
            }
            if (bLink) {
                writer.writeAttribute("link", link);
            }
            if (!writer.hasAlt() && bTooltips && tooltipsArray != null) {
                writer.writeTooltipAttribute(tooltipsArray);
            }
            writer.writeVisualEffectsAttributes(this.m_visualEffectsMap);
            writer.writeShapeAttributesElement();
            writer.writeFillChildren(this.m_id, this.m_blackBox, gradRect);
            writer.writeBorderChildren(this.m_id, this.m_blackBox, gradRect);
            int graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID());
            if (graphID != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2) {
                writer.writeReferenceObjectsElement(this.m_id);
            }
            writer.endElement();
        }
    }

    private void _writeFunnelSVGElements(Arc2D arc, GraphSVGWriter writer, boolean bShapeAttributes, boolean bTooltips, String saTitle, String[] tooltipsArray) throws IOException, Exception {
        boolean bElementStarted = false;
        writer.setBoundingArea(this.m_boundingArea);
        bElementStarted = writer.startElement(this.m_id, this.m_blackBox, null, this.m_fillArea);
        if (bElementStarted) {
            this._writeShapeAttributes(writer, bShapeAttributes, bTooltips, saTitle, tooltipsArray);
        }
        if (bElementStarted = writer.startElement(this.m_id, this.m_blackBox, arc, null)) {
            this._writeShapeAttributes(writer, bShapeAttributes, false, saTitle, tooltipsArray);
        }
        if (this.m_ellipse2D != null && (bElementStarted = writer.startElement(this.m_id, this.m_blackBox, this.m_ellipse2D))) {
            this._writeShapeAttributes(writer, bShapeAttributes, false, saTitle, tooltipsArray);
        }
    }

    private void _writeFunnelXMLElements(Arc2D arc, GraphExportXMLWriter writer, boolean bTooltips, String[] tooltipsArray) throws IOException, Exception {
        boolean bElementStarted = false;
        if (this.m_fillArea != null && (bElementStarted = writer.startElement(this.m_id, this.m_blackBox, this.m_fillArea))) {
            if (!writer.hasAlt() && bTooltips && tooltipsArray != null) {
                writer.writeTooltipAttribute(tooltipsArray);
            }
            writer.writeShapeAttributesElement();
            writer.writeFillChildren(this.m_id, this.m_blackBox, this.m_fillArea.getBounds());
            writer.writeBorderChildren(this.m_id, this.m_blackBox, this.m_fillArea.getBounds());
            writer.endElement();
        }
        if (arc != null && (bElementStarted = writer.startElement(this.m_id, this.m_blackBox, arc))) {
            writer.writeFillChildren(this.m_id, this.m_blackBox, arc.getBounds2D().getBounds());
            writer.writeBorderChildren(this.m_id, this.m_blackBox, arc.getBounds2D().getBounds());
            writer.writeShapeAttributesElement();
            writer.endElement();
        }
        if (this.m_ellipse2D != null && (bElementStarted = writer.startElement(this.m_id, this.m_blackBox, this.m_ellipse2D))) {
            writer.writeFillChildren(this.m_id, this.m_blackBox, this.m_ellipse2D.getBounds2D().getBounds());
            writer.writeBorderChildren(this.m_id, this.m_blackBox, this.m_ellipse2D.getBounds2D().getBounds());
            writer.writeShapeAttributesElement();
            writer.endElement();
        }
    }

    private void _writeShapeAttributes(GraphSVGWriter writer, boolean bShapeAttributes, boolean bTooltips, String saTitle, String[] tooltipsArray) throws IOException, Exception {
        if (bShapeAttributes) {
            writer.writeShapeAttributes();
        }
        if (bTooltips) {
            boolean bTooltipWritten = writer.writeTooltip(tooltipsArray);
        } else if (saTitle != null) {
            writer.writeTitleElement(saTitle);
        }
        writer.endElement();
    }

    protected void renderToFlash(Map context, Polygon p, Area area, Arc2D arc, GeneralPath path) {
        ChartRenderer chartRenderer = (ChartRenderer)context.get("flashRenderer");
        String[] tooltipArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
        if (this.m_Detectiv.getPerspective().isChartPieRing() && (this.m_id.getObjectID() == 298 || this.m_id.getObjectID() == 332)) {
            Vector rects = this.m_Detectiv.getPerspective().getPieRingBounds();
            if (this.m_id.getGroupID() != -3) {
                chartRenderer.setBoundingRect((Rectangle)rects.get(this.m_id.getGroupID()));
            } else {
                chartRenderer.setBoundingRect((Rectangle)rects.get(0));
            }
        }
        if (arc != null && !this.m_Detectiv.getPerspective().isFunnel()) {
            chartRenderer.drawShape(this.m_blackBox, this.m_id, arc, tooltipArray);
        } else if (area != null) {
            chartRenderer.drawShape(this.m_blackBox, this.m_id, area, tooltipArray);
        } else if (this.m_Detectiv.getPerspective().isPie() && path != null) {
            chartRenderer.drawShape(this.m_blackBox, this.m_id, path, tooltipArray);
        } else if (this.m_Detectiv.getPerspective().isFunnel()) {
            if (this.m_boundingArea != null && this.m_id.getObjectID() == 621) {
                chartRenderer.setBoundingRect(this.m_boundingArea.getBounds());
            }
            if (arc != null) {
                chartRenderer.drawShape(this.m_blackBox, this.m_id, arc, tooltipArray);
            }
            if (this.m_fillArea != null) {
                chartRenderer.drawShape(this.m_blackBox, this.m_id, this.m_fillArea, tooltipArray);
            }
            if (this.m_ellipse2D != null) {
                chartRenderer.drawShape(this.m_blackBox, this.m_id, this.m_ellipse2D, tooltipArray);
            }
        } else {
            chartRenderer.drawShape(this.m_blackBox, this.m_id, p, tooltipArray);
        }
    }

    public void setBounds(Rectangle rBounds) {
        if (this.m_id.getObjectID() == 620) {
            IdentObj id = new IdentObj(this.m_id);
            id.setMiscID(627);
            DetObj detObj = this.m_Detectiv.findNodeOf(id);
            detObj.setBounds(rBounds);
        }
    }

    public Polygon getShape(VC vc) {
        if (this.m_Detectiv.getPerspective().isFunnel()) {
            if (this.m_fillPolygon != null) {
                return vc.destToVirt(this.m_fillPolygon);
            }
            return null;
        }
        if (this.m_destPolygon != null) {
            return vc.destToVirt(this.m_destPolygon);
        }
        return this.m_polygon;
    }

    public boolean isMoveable() {
        if (this.m_id.getObjectID() == 620) {
            return true;
        }
        return super.isMoveable();
    }
}

