/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import java.awt.print.PrinterGraphics;
import java.util.List;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.ColorObj;
import oracle.dss.graph.pfj.draw.ColorPinStripeObj;
import oracle.dss.graph.pfj.draw.FillObj;
import oracle.dss.graph.pfj.draw.FillSfxObj;

public class FillGradientObj
extends FillSfxObj {
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int DOWN = 3;
    public static final int UP = 4;
    public static final int DOWN_LEFT = 5;
    public static final int UP_LEFT = 6;
    public static final int DOWN_RIGHT = 7;
    public static final int UP_RIGHT = 8;
    public static final int RADIAL = 9;
    public static final int RADIAL_TOPLEFT = 10;
    public static final int RADIAL_TOPRIGHT = 11;
    public static final int RADIAL_BOTTOMLEFT = 12;
    public static final int RADIAL_BOTTOMRIGHT = 13;
    public static final int RECTANGULAR = 14;
    private static final int GRADIENT_MAX = 14;
    private int m_nDirection;
    private ColorPinStripeObj m_ColorStripe;
    private Perspective m_Perspective;
    private double m_pos1;
    private double m_pos2;
    private double m_pos3;
    private Color m_leftColor1;
    private Color m_rightColor1;
    private Color m_leftColor2;
    private Color m_rightColor2;
    private Color m_leftColor3;
    private Color m_rightColor3;
    private int m_numPins;

    private void $init$() {
        this.m_pos1 = -1.0;
        this.m_pos2 = -1.0;
        this.m_pos3 = -1.0;
        this.m_numPins = 0;
    }

    public FillGradientObj() {
        this.$init$();
        this.m_ColorStripe = new ColorPinStripeObj();
        this.m_nDirection = 3;
    }

    public FillGradientObj(Perspective p, int nGradientDirection) {
        this.$init$();
        this.m_ColorStripe = new ColorPinStripeObj();
        this.m_nDirection = nGradientDirection;
        this.m_Perspective = p;
    }

    public void copy(FillObj fo) {
        this.m_nDirection = ((FillGradientObj)fo).m_nDirection;
        this.m_ColorStripe.copy(((FillGradientObj)fo).m_ColorStripe);
    }

    public boolean equals(Object obj) {
        boolean bEqual;
        if (obj instanceof FillGradientObj) {
            FillGradientObj fgo = (FillGradientObj)obj;
            bEqual = this.m_nDirection == fgo.m_nDirection && this.m_ColorStripe.equals(fgo.m_ColorStripe);
        } else {
            bEqual = false;
        }
        return bEqual;
    }

    public boolean is2DTech(Graphics g) {
        boolean tech2D = false;
        if (g instanceof PrinterGraphics) {
            if (this.m_Perspective.isSFXPrintingSmooth()) {
                tech2D = true;
            }
        } else if (g instanceof Graphics2D) {
            tech2D = true;
        }
        if (tech2D) {
            tech2D = false;
            if (this.m_nDirection >= 1 && this.m_nDirection <= 8) {
                if (this.m_numPins == 2) {
                    if (this.m_leftColor1.equals(this.m_rightColor1) && this.m_leftColor2.equals(this.m_rightColor2) && this.m_pos1 == 0.0 && this.m_pos2 == 1.0) {
                        tech2D = true;
                    }
                } else if (this.m_numPins == 3 && this.m_leftColor1.equals(this.m_rightColor1) && this.m_leftColor2.equals(this.m_rightColor2) && this.m_leftColor3.equals(this.m_rightColor3) && this.m_leftColor1.equals(this.m_leftColor3) && this.m_pos1 == 0.0 && this.m_pos2 == 0.5 && this.m_pos3 == 1.0) {
                    tech2D = true;
                }
            }
        }
        return tech2D;
    }

    public void fillPolygon(Graphics g, Perspective c, Area area) {
        if (this.is2DTech(g)) {
            this.fill((Graphics2D)g, c, area, false);
        } else {
            super.fillPolygon(g, c, area);
        }
    }

    public void fillPolygon(Graphics g, Perspective c, RectangularShape shape) {
        if (this.is2DTech(g)) {
            this.fill((Graphics2D)g, c, shape, false);
        } else {
            ColorObj color = new ColorObj();
            this.m_ColorStripe.getColorAt(1.0, color);
            g.setColor(color.getColor());
            ((Graphics2D)g).fill(shape);
            super.fillPolygon(g, c, shape);
        }
    }

    public void fillPolygon(Graphics g, Perspective c, Polygon p) {
        if (this.is2DTech(g)) {
            this.fill((Graphics2D)g, c, p, false);
        } else {
            super.fillPolygon(g, c, p);
        }
    }

    public void fillPolygon(Graphics g, Perspective c, GeneralPath p, Rectangle r) {
        if (this.is2DTech(g)) {
            this.fill((Graphics2D)g, c, p, false);
        } else {
            super.fillPolygon(g, c, p, r);
        }
    }

    public void fillRect(Graphics g, Perspective c, Rectangle r) {
        if (this.is2DTech(g)) {
            this.fill((Graphics2D)g, c, r, false);
        } else {
            super.fillRect(g, c, r);
        }
    }

    public void fillOval(Graphics g, Perspective c, Rectangle r) {
        if (this.is2DTech(g)) {
            this.fill((Graphics2D)g, c, r, true);
        } else {
            super.fillOval(g, c, r);
        }
    }

    public void fill(Graphics2D g, Perspective c, Shape shape, boolean oval) {
        Rectangle r = shape instanceof Arc2D || shape instanceof Ellipse2D ? shape.getBounds2D().getBounds() : shape.getBounds();
        if (r.width <= 0 || r.height <= 0) {
            return;
        }
        boolean cyclic = false;
        Color first = this.m_leftColor1;
        Color second = this.m_leftColor2;
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        if (this.m_numPins == 2) {
            switch (this.m_nDirection) {
                case 2: {
                    first = this.m_leftColor2;
                    second = this.m_leftColor1;
                }
                case 1: {
                    x1 = r.x;
                    y1 = r.y;
                    x2 = r.x + r.width;
                    y2 = r.y;
                    break;
                }
                case 4: {
                    first = this.m_leftColor2;
                    second = this.m_leftColor1;
                }
                case 3: {
                    x1 = r.x;
                    y1 = r.y;
                    x2 = r.x;
                    y2 = r.y + r.height;
                    break;
                }
                case 7: {
                    x1 = r.x;
                    y1 = r.y;
                    x2 = r.x + r.width;
                    y2 = r.y + r.height;
                    break;
                }
                case 5: {
                    x1 = r.x + r.width;
                    y1 = r.y;
                    x2 = r.x;
                    y2 = r.y + r.height;
                    break;
                }
                case 6: {
                    x1 = r.x + r.width;
                    y1 = r.y + r.height;
                    x2 = r.x;
                    y2 = r.y;
                    break;
                }
                case 8: {
                    x1 = r.x;
                    y1 = r.y + r.height;
                    x2 = r.x + r.width;
                    y2 = r.y;
                    break;
                }
            }
        } else if (this.m_numPins == 3) {
            cyclic = true;
            switch (this.m_nDirection) {
                case 1: 
                case 2: {
                    x1 = r.x;
                    y1 = r.y;
                    x2 = r.x + r.width / 2;
                    y2 = r.y;
                    break;
                }
                case 3: 
                case 4: {
                    x1 = r.x;
                    y1 = r.y;
                    x2 = r.x;
                    y2 = r.y + r.height / 2;
                    break;
                }
                case 7: {
                    x1 = r.x;
                    y1 = r.y;
                    x2 = r.x + r.width / 2;
                    y2 = r.y + r.height / 2;
                    break;
                }
                case 5: {
                    x1 = r.x + r.width / 2;
                    y1 = r.y;
                    x2 = r.x;
                    y2 = r.y + r.height / 2;
                    break;
                }
                case 6: {
                    x1 = r.x + r.width;
                    y1 = r.y + r.height;
                    x2 = r.x + r.width / 2;
                    y2 = r.y + r.height / 2;
                    break;
                }
                case 8: {
                    x1 = r.x;
                    y1 = r.y + r.height;
                    x2 = r.x + r.width / 2;
                    y2 = r.y + r.height / 2;
                    break;
                }
            }
        }
        GradientPaint paintObj = new GradientPaint(x1, y1, first, x2, y2, second, cyclic);
        g.setPaint(paintObj);
        if (oval) {
            Rectangle rect = (Rectangle)shape;
            g.fillOval(rect.x, rect.y, rect.width, rect.height);
        } else {
            g.fill(shape);
        }
    }

    private void downGradient(Graphics g, int x, int y, int width, int height) {
        ColorObj color = new ColorObj();
        int xmax = x + width;
        int ymax = y + height;
        int i = y;
        while (i < ymax) {
            this.m_ColorStripe.getColorAt((double)(i - y) / (double)height, color);
            g.setColor(color.getColor());
            g.drawLine(x, i, xmax, i);
            ++i;
        }
    }

    private void downLeftGradient(Graphics g, int x, int y, int width, int height) {
        double fExtX = height * height / width + width;
        double fExtY = width * width / height + height;
        int nExtMax = (int)Math.max(fExtX, fExtY);
        ColorObj color = new ColorObj();
        int[] xPoint = new int[4];
        int[] yPoint = new int[4];
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        int i = 0;
        while (i < nExtMax) {
            double fCoef = (double)i / (double)nExtMax;
            this.m_ColorStripe.getColorAt(fCoef, color);
            g2.setColor(color.getColor());
            xPoint[0] = (int)((double)width - fCoef * fExtX) + x;
            yPoint[0] = y;
            xPoint[1] = x + width;
            yPoint[1] = (int)(fCoef * fExtY) + y;
            xPoint[2] = xPoint[1] - 5;
            yPoint[2] = yPoint[1] + 5;
            xPoint[3] = xPoint[0] - 5;
            yPoint[3] = yPoint[0] + 5;
            g2.drawPolygon(xPoint, yPoint, 4);
            ++i;
        }
    }

    private void downRightGradient(Graphics g, int x, int y, int width, int height) {
        double fExtX = height * height / width + width;
        double fExtY = width * width / height + height;
        int nExtMax = (int)Math.max(fExtX, fExtY);
        ColorObj color = new ColorObj();
        int[] xPoint = new int[4];
        int[] yPoint = new int[4];
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        int i = 0;
        while (i < nExtMax) {
            double fCoef = (double)i / (double)nExtMax;
            this.m_ColorStripe.getColorAt(fCoef, color);
            g2.setColor(color.getColor());
            xPoint[0] = (int)(fCoef * fExtX) + x;
            yPoint[0] = y;
            xPoint[1] = x;
            yPoint[1] = (int)(fCoef * fExtY) + y;
            xPoint[2] = xPoint[1] - 5;
            yPoint[2] = yPoint[1] - 5;
            xPoint[3] = xPoint[0] - 5;
            yPoint[3] = yPoint[0] - 5;
            g2.drawPolygon(xPoint, yPoint, 4);
            ++i;
        }
    }

    public void fillSfxRect(Graphics g, Perspective c, int x, int y, int width, int height, RectangularShape shape, Rectangle r) {
        switch (this.m_nDirection) {
            case 1: {
                this.rightGradient(g, x, y, width, height);
                break;
            }
            case 2: {
                this.leftGradient(g, x, y, width, height);
                break;
            }
            case 3: {
                this.downGradient(g, x, y, width, height);
                break;
            }
            case 4: {
                this.upGradient(g, x, y, width, height);
                break;
            }
            case 9: {
                this.radialGradient(g, x, y, width, height, shape, r);
                break;
            }
            case 5: {
                this.downLeftGradient(g, x, y, width, height);
                break;
            }
            case 6: {
                this.upLeftGradient(g, x, y, width, height);
                break;
            }
            case 7: {
                this.downRightGradient(g, x, y, width, height);
                break;
            }
            case 8: {
                this.upRightGradient(g, x, y, width, height);
                break;
            }
            case 10: {
                this.radialTopLeftGradient(g, x, y, width, height);
                break;
            }
            case 11: {
                this.radialTopRightGradient(g, x, y, width, height);
                break;
            }
            case 12: {
                this.radialBottomLeftGradient(g, x, y, width, height);
                break;
            }
            case 13: {
                this.radialBottomRightGradient(g, x, y, width, height);
                break;
            }
            case 14: {
                this.rectangularGradient(g, x, y, width, height);
                break;
            }
        }
    }

    public void insertPin(double fPosition, ColorObj leftColor, ColorObj rightColor) {
        this.m_ColorStripe.insertPin(fPosition, leftColor, rightColor);
        if (this.m_pos1 == -1.0) {
            this.m_pos1 = fPosition;
            this.m_leftColor1 = leftColor.getColor();
            this.m_rightColor1 = rightColor.getColor();
        } else if (this.m_pos2 == -1.0) {
            this.m_pos2 = fPosition;
            this.m_leftColor2 = leftColor.getColor();
            this.m_rightColor2 = rightColor.getColor();
        } else if (this.m_pos3 == -1.0) {
            this.m_pos3 = fPosition;
            this.m_leftColor3 = leftColor.getColor();
            this.m_rightColor3 = rightColor.getColor();
        }
        ++this.m_numPins;
    }

    private void leftGradient(Graphics g, int x, int y, int width, int height) {
        ColorObj color = new ColorObj();
        int xmax = x + width;
        int ymax = y + height;
        int i = xmax - 1;
        while (i >= x) {
            this.m_ColorStripe.getColorAt(1.0 - (double)(i - x) / (double)width, color);
            g.setColor(color.getColor());
            g.drawLine(i, y, i, ymax);
            --i;
        }
    }

    private void radialBottomLeftGradient(Graphics g, int x, int y, int width, int height) {
        int wp = 3 * width;
        int hp = 3 * height;
        int xp = -wp / 2 + x;
        int yp = -hp / 2 + y;
        int nMaxExtent = Math.max(wp, hp) / 2;
        ColorObj color = new ColorObj();
        int nExtent = nMaxExtent - 1;
        while (nExtent >= 0) {
            double fCoef = (double)nExtent / (double)nMaxExtent;
            this.m_ColorStripe.getColorAt(fCoef, color);
            g.setColor(color.getColor());
            g.fillOval((int)((double)xp + (1.0 - fCoef) * (double)wp / 2.0), (int)((double)yp + (1.0 - fCoef) * (double)hp / 2.0 + (double)height), (int)((double)wp * fCoef), (int)((double)hp * fCoef));
            --nExtent;
        }
    }

    private void radialBottomRightGradient(Graphics g, int x, int y, int width, int height) {
        int wp = 3 * width;
        int hp = 3 * height;
        int xp = -wp / 2 + x;
        int yp = -hp / 2 + y;
        int nMaxExtent = Math.max(wp, hp) / 2;
        ColorObj color = new ColorObj();
        int nExtent = nMaxExtent - 1;
        while (nExtent >= 0) {
            double fCoef = (double)nExtent / (double)nMaxExtent;
            this.m_ColorStripe.getColorAt(fCoef, color);
            g.setColor(color.getColor());
            g.fillOval((int)((double)xp + (1.0 - fCoef) * (double)wp / 2.0 + (double)width), (int)((double)yp + (1.0 - fCoef) * (double)hp / 2.0 + (double)height), (int)((double)wp * fCoef), (int)((double)hp * fCoef));
            --nExtent;
        }
    }

    private void radialGradient(Graphics g, int x, int y, int width, int height, RectangularShape shape, Rectangle r) {
        int nMaxExtent;
        int xp = -width / 4 + x;
        int yp = -height / 4 + y;
        int wp = width + width / 2;
        int hp = height + height / 2;
        if (shape != null && r != null) {
            xp = -((int)(r.getX() - shape.getX())) - 2;
            yp = -((int)(r.getY() - shape.getY())) - 2;
            wp = (int)shape.getWidth() + 4;
            hp = (int)shape.getHeight() + 4;
        }
        if (shape != null && shape instanceof Arc2D) {
            Rectangle inner = shape.getBounds2D().getBounds();
            xp = -((int)(inner.getX() - shape.getX())) - 2;
            yp = -((int)(inner.getY() - shape.getY())) - 2;
            wp = (int)shape.getWidth() + 4;
            hp = (int)shape.getHeight() + 4;
        }
        int nExtent = nMaxExtent = Math.max(wp, hp) / 2;
        while (nExtent >= 0) {
            ColorObj color = new ColorObj();
            double fCoef = (double)nExtent / (double)nMaxExtent;
            this.m_ColorStripe.getColorAt(fCoef, color);
            g.setColor(color.getColor());
            Ellipse2D.Double outer = new Ellipse2D.Double((double)(xp + wp / 2) - fCoef * (double)wp / 2.0, (double)(yp + hp / 2) - fCoef * (double)hp / 2.0, 2.0 * (fCoef * (double)wp / 2.0), 2.0 * (fCoef * (double)hp / 2.0));
            double fCoefNext = (double)(nExtent - 1) / (double)nMaxExtent;
            Ellipse2D.Double inner = new Ellipse2D.Double((double)(xp + wp / 2) - fCoefNext * (double)wp / 2.0, (double)(yp + hp / 2) - fCoefNext * (double)hp / 2.0, 2.0 * (fCoefNext * (double)wp / 2.0), 2.0 * (fCoefNext * (double)hp / 2.0));
            Area area = new Area(outer);
            area.subtract(new Area(inner));
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(1.0f, 1, 1));
            g2.fill(area);
            --nExtent;
        }
    }

    private void radialTopLeftGradient(Graphics g, int x, int y, int width, int height) {
        int wp = 3 * width;
        int hp = 3 * height;
        int xp = -wp / 2 + x;
        int yp = -hp / 2 + y;
        int nMaxExtent = Math.max(wp, hp) / 2;
        ColorObj color = new ColorObj();
        int nExtent = nMaxExtent - 1;
        while (nExtent >= 0) {
            double fCoef = (double)nExtent / (double)nMaxExtent;
            this.m_ColorStripe.getColorAt(fCoef, color);
            g.setColor(color.getColor());
            g.fillOval((int)((double)xp + (1.0 - fCoef) * (double)wp / 2.0), (int)((double)yp + (1.0 - fCoef) * (double)hp / 2.0), (int)((double)wp * fCoef), (int)((double)hp * fCoef));
            --nExtent;
        }
    }

    private void radialTopRightGradient(Graphics g, int x, int y, int width, int height) {
        int wp = 3 * width;
        int hp = 3 * height;
        int xp = -wp / 2 + x;
        int yp = -hp / 2 + y;
        int nMaxExtent = Math.max(wp, hp) / 2;
        ColorObj color = new ColorObj();
        int nExtent = nMaxExtent - 1;
        while (nExtent >= 0) {
            double fCoef = (double)nExtent / (double)nMaxExtent;
            this.m_ColorStripe.getColorAt(fCoef, color);
            g.setColor(color.getColor());
            g.fillOval((int)((double)xp + (1.0 - fCoef) * (double)wp / 2.0 + (double)width), (int)((double)yp + (1.0 - fCoef) * (double)hp / 2.0), (int)((double)wp * fCoef), (int)((double)hp * fCoef));
            --nExtent;
        }
    }

    private void rightGradient(Graphics g, int x, int y, int width, int height) {
        ColorObj color = new ColorObj();
        int xmax = x + width;
        int ymax = y + height;
        int i = x;
        while (i < xmax) {
            this.m_ColorStripe.getColorAt((double)(i - x) / (double)width, color);
            g.setColor(color.getColor());
            g.drawLine(i, y, i, ymax);
            ++i;
        }
    }

    public void setDirection(int nDirection) {
        if (nDirection < 1 || nDirection > 14) {
            throw new AssertionException(1, 14, nDirection);
        }
        this.m_nDirection = nDirection;
    }

    public int getDirection() {
        return this.m_nDirection;
    }

    public List getPins() {
        return this.m_ColorStripe.getPins();
    }

    private void upGradient(Graphics g, int x, int y, int width, int height) {
        ColorObj color = new ColorObj();
        int xmax = x + width;
        int ymax = y + height;
        int i = ymax - 1;
        while (i >= y) {
            this.m_ColorStripe.getColorAt(1.0 - (double)(i - y) / (double)height, color);
            g.setColor(color.getColor());
            g.drawLine(x, i, xmax, i);
            --i;
        }
    }

    private void upRightGradient(Graphics g, int x, int y, int width, int height) {
        double fExtX = height * height / width + width;
        double fExtY = width * width / height + height;
        int nExtMax = (int)Math.max(fExtX, fExtY);
        ColorObj color = new ColorObj();
        int[] xPoint = new int[4];
        int[] yPoint = new int[4];
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        int i = nExtMax - 1;
        while (i >= 0) {
            double fCoef = (double)i / (double)nExtMax;
            this.m_ColorStripe.getColorAt(1.0 - fCoef, color);
            g2.setColor(color.getColor());
            xPoint[0] = (int)((double)width - fCoef * fExtX) + x;
            yPoint[0] = y;
            xPoint[1] = x + width;
            yPoint[1] = (int)(fCoef * fExtY) + y;
            xPoint[2] = xPoint[1] - 5;
            yPoint[2] = yPoint[1] + 5;
            xPoint[3] = xPoint[0] - 5;
            yPoint[3] = yPoint[0] + 5;
            g2.drawPolygon(xPoint, yPoint, 4);
            --i;
        }
    }

    private void upLeftGradient(Graphics g, int x, int y, int width, int height) {
        double fExtX = height * height / width + width;
        double fExtY = width * width / height + height;
        int nExtMax = (int)Math.max(fExtX, fExtY);
        ColorObj color = new ColorObj();
        int[] xPoint = new int[4];
        int[] yPoint = new int[4];
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        int i = nExtMax - 1;
        while (i >= 0) {
            double fCoef = (double)i / (double)nExtMax;
            this.m_ColorStripe.getColorAt(1.0 - fCoef, color);
            g2.setColor(color.getColor());
            xPoint[0] = (int)(fCoef * fExtX) + x;
            yPoint[0] = y;
            xPoint[1] = x;
            yPoint[1] = (int)(fCoef * fExtY) + y;
            xPoint[2] = xPoint[1] + 5;
            yPoint[2] = yPoint[1] + 5;
            xPoint[3] = xPoint[0] + 5;
            yPoint[3] = yPoint[0] + 5;
            g2.drawPolygon(xPoint, yPoint, 4);
            --i;
        }
    }

    private void rectangularGradient(Graphics g, int x, int y, int width, int height) {
        int xp = -width / 4 + x;
        int yp = -height / 4 + y;
        int wp = width + width / 2;
        int hp = height + height / 2;
        int nMaxExtent = Math.max(wp, hp) / 2;
        int nExtent = nMaxExtent - 1;
        while (nExtent >= 0) {
            ColorObj color = new ColorObj();
            double fCoef = (double)nExtent / (double)nMaxExtent;
            this.m_ColorStripe.getColorAt(fCoef, color);
            g.setColor(color.getColor());
            g.fillRect((int)((double)(xp + wp / 2) - fCoef * (double)wp / 2.0), (int)((double)(yp + hp / 2) - fCoef * (double)hp / 2.0), (int)(2.0 * (fCoef * (double)wp / 2.0)), (int)(2.0 * (fCoef * (double)hp / 2.0)));
            --nExtent;
        }
    }

    public Color getColorAt(double fValue) {
        ColorObj color = new ColorObj();
        this.m_ColorStripe.getColorAt(fValue, color);
        return color.getColor();
    }
}

