/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.Serializable;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.ImageLoader;
import oracle.dss.graph.pfj.draw.RotateImageFilter;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public abstract class FillObj
implements Serializable {
    public static final int FILL_COLOR = 1;
    public static final int FILL_GRADIENT = 2;
    public static final int FILL_TEXTURE = 3;
    public static final int FILL_PATTERN = 4;

    public void fillOval(Graphics g, Perspective c, Rectangle r) {
        this.fillOval(g, c, r.x, r.y, r.width, r.height);
    }

    public Color getColor() {
        return Color.white;
    }

    public void fillPolygon(Graphics g, Perspective c, Polygon p) {
        this.fillPolygon(g, c, p.xpoints, p.ypoints, p.npoints);
    }

    public abstract void fillPolygon(Graphics var1, Perspective var2, Area var3);

    public abstract void fillPolygon(Graphics var1, Perspective var2, RectangularShape var3);

    public abstract void fillPolygon(Graphics var1, Perspective var2, GeneralPath var3, Rectangle var4);

    public void fillRect(Graphics g, Perspective persp, Rectangle r) {
        this.fillRect(g, persp, r.x, r.y, r.width, r.height);
    }

    protected boolean waitForImage(Perspective c, Image image) {
        boolean loaded = ImageLoader.loadImage(image);
        if (!loaded) {
            c.getErrorHandler().log("InterruptedException caught", this.getClass().getName(), "waitForImage( Perspective c, Image image )");
        }
        return true;
    }

    protected int[] extractPixels(Perspective c, Image img, Rectangle r) {
        int[] pixels = new int[r.width * r.height];
        this.waitForImage(c, img);
        PixelGrabber pg = new PixelGrabber(img, 0, 0, r.width, r.height, pixels, 0, r.width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            c.getErrorHandler().log("extractPixels was interrupted waiting for pixels!", this.getClass().getName(), "extractPixels(Perspective c, Image img, Rectangle r )");
            int[] nArray = null;
            return nArray;
        }
        catch (Throwable e) {
            c.getErrorHandler().error(e, this.getClass().getName(), "extractPixels(Perspective c, Image img, Rectangle r )");
            int[] nArray = null;
            return nArray;
        }
        if ((pg.status() & 0x80) != 0) {
            c.getErrorHandler().log("image fetch aborted or errored", this.getClass().getName(), "extractPixels(Perspective c, Image img, Rectangle r )");
            return null;
        }
        return pixels;
    }

    protected void applyFilter(Graphics g, Perspective c, Image img, Image imgMask, Rectangle rFill, Rectangle rBounds, TextStyleObj textStyle) {
        int[] pixels = this.extractPixels(c, img, rFill);
        int[] pixelsMask = this.extractPixels(c, imgMask, rFill);
        int y = 0;
        while (y < rFill.height) {
            int x = 0;
            while (x < rFill.width) {
                pixels[y * rFill.width + x] = pixels[y * rFill.width + x] & 0xFFFFFF;
                if ((pixelsMask[y * rFill.width + x] & 0xFFFFFF) != 0) {
                    pixels[y * rFill.width + x] = pixels[y * rFill.width + x] | 0xFF000000;
                }
                ++x;
            }
            ++y;
        }
        imgMask.flush();
        Image dest = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(rFill.width, rFill.height, pixels, 0, rFill.width));
        Point pt = new Point(rBounds.x, rBounds.y);
        g.drawImage(dest, pt.x, pt.y, null);
        dest.flush();
    }

    public void fillText(Graphics g, Perspective perspect, String szText, Rectangle rBounds, Rectangle rInnerBounds, Color dropShadowColor, Dimension dropShadowOffset, TextStyleObj textStyle, VC vc, Color backgroundColor, int nBackgroundFillType, boolean bPrintingInProgress) {
        boolean bRotate = textStyle.getRotationAngle() != 0;
        Rectangle rText = new Rectangle(0, 0, rBounds.width, rBounds.height);
        if (rBounds.width <= 0 || rBounds.height <= 0) {
            return;
        }
        if (bRotate) {
            int nTemp = rText.width;
            rText.width = rText.height;
            rText.height = nTemp;
        }
        Dimension textDim = textStyle.preDraw(g, szText, rText, vc, dropShadowOffset, perspect.getFontMetricsResolver());
        rText.width = Math.min(rText.width, textDim.width);
        rText.height = Math.min(rText.height, textDim.height);
        if (rText.width <= 1 || rText.height <= 1) {
            return;
        }
        Image imgMask = perspect.createOffscreenImage(rText.width, rText.height);
        Graphics gos = imgMask.getGraphics();
        Color maskColor = Color.black;
        gos.setColor(maskColor);
        gos.fillRect(0, 0, rText.width, rText.height);
        gos.setColor(Color.white);
        textStyle.draw(gos, perspect, szText, rText, null, dropShadowOffset, vc);
        gos.dispose();
        if (bRotate) {
            imgMask = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(imgMask.getSource(), new RotateImageFilter(textStyle.getRotationAngle())));
        }
        Rectangle rFill = bRotate ? new Rectangle(0, 0, rText.height, rText.width) : new Rectangle(0, 0, rText.width, rText.height);
        Image imgTextColor = perspect.createOffscreenImage(rFill.width, rFill.height);
        gos = imgTextColor.getGraphics();
        this.fillRect(gos, perspect, 0, 0, rFill.width, rFill.height);
        gos.dispose();
        try {
            this.applyFilter(g, perspect, imgTextColor, imgMask, rFill, rBounds, textStyle);
        }
        catch (Throwable e) {
            perspect.getErrorHandler().error(e, this.getClass().getName(), "fillText");
        }
    }

    public abstract void copy(FillObj var1);

    public abstract void fillOval(Graphics var1, Perspective var2, int var3, int var4, int var5, int var6);

    public abstract void fillPolygon(Graphics var1, Perspective var2, int[] var3, int[] var4, int var5);

    public abstract void fillRect(Graphics var1, Perspective var2, int var3, int var4, int var5, int var6);

    public abstract void fillShadedPolygon(Graphics var1, Perspective var2, int[] var3, int[] var4, int var5, int var6);
}

