/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.FillObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public abstract class FillSfxObj
extends FillObj {
    private Area m_boundingArea;

    private void $init$() {
        this.m_boundingArea = null;
    }

    public FillSfxObj() {
        this.$init$();
    }

    public Image createOvalMask(Perspective persp, Rectangle r) {
        Image img = persp.createOffscreenImage(r.width, r.height);
        Graphics gos = img.getGraphics();
        gos.setColor(new Color(0, 0, 0));
        gos.fillRect(0, 0, r.width, r.height);
        gos.setColor(new Color(255, 255, 255));
        gos.fillOval(0, 0, r.width, r.height);
        gos.dispose();
        return img;
    }

    protected Image createPolygonMask(Perspective persp, Polygon poly) {
        Rectangle r = poly.getBounds();
        Image img = persp.createOffscreenImage(r.width, r.height);
        Graphics gos = img.getGraphics();
        gos.setColor(new Color(0, 0, 0));
        gos.fillRect(0, 0, r.width, r.height);
        gos.setColor(new Color(255, 255, 255));
        int[] xxpoints = new int[poly.npoints];
        int[] yypoints = new int[poly.npoints];
        int i = 0;
        while (i < poly.npoints) {
            xxpoints[i] = poly.xpoints[i] - r.x;
            yypoints[i] = poly.ypoints[i] - r.y;
            ++i;
        }
        gos.fillPolygon(xxpoints, yypoints, poly.npoints);
        gos.dispose();
        return img;
    }

    protected Image createAreaMask(Perspective persp, Area area) {
        Rectangle r = this.m_boundingArea != null ? this.m_boundingArea.getBounds() : area.getBounds();
        BufferedImage img = (BufferedImage)persp.createOffscreenImage(r.width, r.height);
        Graphics2D gos = (Graphics2D)img.getGraphics();
        gos.setColor(new Color(0, 0, 0));
        gos.fillRect(0, 0, r.width, r.height);
        gos.setColor(new Color(255, 255, 255));
        AffineTransform transform = new AffineTransform();
        transform.translate(-r.x, -r.y);
        area = area.createTransformedArea(transform);
        gos.fill(area);
        gos.dispose();
        return img;
    }

    protected Image createArc2DMask(Perspective persp, RectangularShape shape2D) {
        Rectangle r = shape2D.getBounds2D().getBounds();
        BufferedImage img = (BufferedImage)persp.createOffscreenImage(r.width, r.height);
        Graphics2D gos = (Graphics2D)img.getGraphics();
        gos.setColor(new Color(0, 0, 0));
        gos.fillRect(0, 0, r.width, r.height);
        gos.setColor(new Color(255, 255, 255));
        AffineTransform transform = new AffineTransform();
        transform.translate(-r.x, -r.y);
        Shape shape = transform.createTransformedShape(shape2D);
        gos.fill(shape);
        gos.dispose();
        return img;
    }

    protected Image createGeneralPathMask(Perspective persp, GeneralPath path) {
        Rectangle r = path.getBounds();
        BufferedImage img = (BufferedImage)persp.createOffscreenImage(r.width, r.height);
        Graphics2D gos = (Graphics2D)img.getGraphics();
        gos.setColor(new Color(0, 0, 0));
        gos.fillRect(0, 0, r.width, r.height);
        gos.setColor(new Color(255, 255, 255));
        AffineTransform transform = new AffineTransform();
        transform.translate(-r.x, -r.y);
        path.transform(transform);
        gos.fill(path);
        gos.dispose();
        transform = new AffineTransform();
        transform.translate(r.x, r.y);
        path.transform(transform);
        return img;
    }

    public Image createTextMask(Perspective persp, String szText, Rectangle rBounds, TextStyleObj textStyle, VC vc) {
        Image img = persp.createOffscreenImage(rBounds.width, rBounds.height);
        return img;
    }

    private void fillClip(Graphics g, Perspective c, Image img, Image imgMask, Rectangle r) {
        this.applyFilter(g, c, img, imgMask, r, r, null);
    }

    public void fillOval(Graphics g, Perspective c, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        Rectangle r = new Rectangle(x, y, width, height);
        Image img = c.createOffscreenImage(r.width, r.height);
        Graphics gos = img.getGraphics();
        this.fillSfxRect(gos, c, 0, 0, r.width, r.height, null, null);
        gos.dispose();
        this.applyFilter(g, c, img, this.createOvalMask(c, r), r, r, null);
        img.flush();
    }

    public void fillPolygon(Graphics g, Perspective c, Polygon p) {
        this.fillPolygon(g, c, p.xpoints, p.ypoints, p.npoints);
    }

    public void fillPolygon(Graphics g, Perspective c, GeneralPath p, Rectangle rect) {
        Rectangle r = p.getBounds();
        if (r.width <= 0 || r.height <= 0) {
            return;
        }
        Image img = c.createOffscreenImage(r.width, r.height);
        Graphics gos = img.getGraphics();
        this.fillSfxRect(gos, c, 0, 0, r.width, r.height, rect, r);
        gos.dispose();
        this.applyFilter(g, c, img, this.createGeneralPathMask(c, p), r, r, null);
        img.flush();
    }

    public void fillPolygon(Graphics g, Perspective c, Area area) {
        Rectangle r = area.getBounds();
        if (this.m_boundingArea != null) {
            r = this.m_boundingArea.getBounds();
        }
        if (r.width <= 0 || r.height <= 0) {
            return;
        }
        Image img = c.createOffscreenImage(r.width, r.height);
        Graphics gos = img.getGraphics();
        this.fillSfxRect(gos, c, 0, 0, r.width, r.height, null, null);
        gos.dispose();
        this.applyFilter(g, c, img, this.createAreaMask(c, area), r, r, null);
        img.flush();
    }

    public void fillPolygon(Graphics g, Perspective c, RectangularShape shape) {
        Rectangle r = shape.getBounds2D().getBounds();
        if (r.width <= 0 || r.height <= 0) {
            return;
        }
        Image img = c.createOffscreenImage(r.width, r.height);
        Graphics gos = img.getGraphics();
        this.fillSfxRect(gos, c, 0, 0, r.width, r.height, shape, null);
        gos.dispose();
        this.applyFilter(g, c, img, this.createArc2DMask(c, shape), r, r, null);
        img.flush();
    }

    public void fillPolygon(Graphics g, Perspective c, int[] nXPoints, int[] nYPoints, int nPoints) {
        Polygon poly = new Polygon(nXPoints, nYPoints, nPoints);
        Rectangle r = poly.getBounds();
        if (r.width <= 0 || r.height <= 0) {
            return;
        }
        Image img = c.createOffscreenImage(r.width, r.height);
        Graphics gos = img.getGraphics();
        this.fillSfxRect(gos, c, 0, 0, r.width, r.height, null, null);
        gos.dispose();
        this.applyFilter(g, c, img, this.createPolygonMask(c, poly), r, r, null);
        img.flush();
    }

    public void fillRect(Graphics g, Perspective c, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        Image img = c.createOffscreenImage(width, height);
        Graphics gos = img.getGraphics();
        this.fillSfxRect(gos, c, 0, 0, width, height, null, null);
        gos.dispose();
        g.drawImage(img, x, y, null);
        img.flush();
    }

    public void fillShadedPolygon(Graphics g, Perspective c, int[] nXPoints, int[] nYPoints, int nPoints, int nShading) {
        this.fillPolygon(g, c, nXPoints, nYPoints, nPoints);
    }

    public void setBoundingArea(Area boundingArea) {
        this.m_boundingArea = boundingArea;
    }

    public abstract void copy(FillObj var1);

    protected abstract void fillSfxRect(Graphics var1, Perspective var2, int var3, int var4, int var5, int var6, RectangularShape var7, Rectangle var8);
}

