/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.io.Serializable;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.ObjClassID;

public class IdentObj
implements Serializable {
    public static final int OBJECT_NA = -3;
    public static final int SERIES_OTHER = -1;
    public static final int SERIES_NEG_OTHER = -2;
    public static final int SERIES_NA = -3;
    public static final int GROUP_NA = -3;
    public static final int STACK_NA = -3;
    public static final int MISC_NA = -3;
    public static final IdentObj GLOBAL = new IdentObj(-3);
    int m_objectID;
    int m_seriesID;
    int m_groupID;
    int m_stackID;
    int m_miscID;

    public IdentObj(int objectID) {
        this(objectID, -3, -3, -3, -3);
    }

    public IdentObj(int objectID, boolean bZeroMisc) {
        this(objectID, -3, -3, -3, -3);
    }

    public IdentObj(int objectID, int seriesID) {
        this(objectID, seriesID, -3, -3, -3);
    }

    public IdentObj(int objectID, int seriesID, int groupID) {
        this(objectID, seriesID, groupID, -3, -3);
    }

    public IdentObj(int objectID, int seriesID, int groupID, int stackID, int miscID) {
        this.m_objectID = objectID;
        this.m_seriesID = seriesID;
        this.m_groupID = groupID;
        this.m_stackID = stackID;
        this.m_miscID = miscID;
    }

    public void init(int objectID) {
        this.init(objectID, -3);
    }

    public void init(int objectID, int seriesID) {
        this.m_objectID = objectID;
        this.m_seriesID = seriesID;
        this.m_groupID = -3;
        this.m_stackID = -3;
        this.m_miscID = -3;
    }

    public IdentObj(IdentObj id) {
        this.copy(id);
    }

    public void copy(IdentObj id) {
        this.m_objectID = id.m_objectID;
        this.m_seriesID = id.m_seriesID;
        this.m_groupID = id.m_groupID;
        this.m_stackID = id.m_stackID;
        this.m_miscID = id.m_miscID;
    }

    public int hashCode() {
        return this.m_objectID + this.m_seriesID + this.m_groupID + this.m_stackID + this.m_miscID;
    }

    public boolean equals(Object x) {
        if (!(x instanceof IdentObj)) {
            return false;
        }
        IdentObj xID = (IdentObj)x;
        if (this.m_objectID != xID.m_objectID) {
            return false;
        }
        if (this.m_seriesID != xID.m_seriesID) {
            return false;
        }
        if (this.m_groupID != xID.m_groupID) {
            return false;
        }
        if (this.m_stackID != xID.m_stackID) {
            return false;
        }
        return this.m_miscID == xID.m_miscID;
    }

    public int getGroupID() {
        return this.m_groupID;
    }

    public int getMiscID() {
        return this.m_miscID;
    }

    public int getObjectID() {
        return this.m_objectID;
    }

    public int getSeriesID() {
        return this.m_seriesID;
    }

    public int getStackID() {
        return this.m_stackID;
    }

    public void incrMiscID(int increment) {
        this.m_miscID += increment;
    }

    public boolean isGROUP_NA() {
        return this.m_groupID == -3;
    }

    public boolean isExceptional() {
        return ObjClassID.isExceptional(this.m_objectID);
    }

    public boolean isMISC_NA() {
        return this.m_miscID == -3;
    }

    public boolean isSTACK_NA() {
        return this.m_stackID == -3;
    }

    public boolean isOBJECT_NA() {
        return this.m_objectID == -3;
    }

    public boolean isPartOf3DCube() {
        boolean bCube;
        switch (this.m_objectID) {
            case 603: 
            case 604: 
            case 605: {
                bCube = true;
                break;
            }
            default: {
                bCube = false;
                break;
            }
        }
        return bCube;
    }

    public boolean isLegend() {
        boolean bLegend;
        switch (this.m_objectID) {
            case 12: {
                bLegend = true;
                break;
            }
            default: {
                bLegend = false;
                break;
            }
        }
        return bLegend;
    }

    public boolean isScrollerThumb() {
        boolean bScrollerThumb;
        switch (this.m_objectID) {
            case 20: 
            case 26: {
                bScrollerThumb = true;
                break;
            }
            default: {
                bScrollerThumb = false;
                break;
            }
        }
        return bScrollerThumb;
    }

    public boolean isLegendScrollerThumb() {
        boolean bScrollerThumb;
        switch (this.m_objectID) {
            case 66: {
                bScrollerThumb = true;
                break;
            }
            default: {
                bScrollerThumb = false;
                break;
            }
        }
        return bScrollerThumb;
    }

    public boolean isParetoRelated() {
        boolean bPareto = false;
        switch (this.m_objectID) {
            case 473: 
            case 474: 
            case 475: 
            case 476: 
            case 477: 
            case 491: 
            case 492: 
            case 493: 
            case 494: 
            case 495: 
            case 496: 
            case 497: 
            case 498: 
            case 499: 
            case 500: {
                bPareto = true;
                break;
            }
        }
        return bPareto;
    }

    public boolean isReferenceLineRelated() {
        boolean bRefLine = false;
        switch (this.m_objectID) {
            case 358: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 507: {
                bRefLine = true;
                break;
            }
        }
        return bRefLine;
    }

    public boolean isSERIES_NA() {
        return this.m_seriesID == -3;
    }

    public boolean isColorByHeightRelated() {
        boolean bByHeight;
        switch (this.m_objectID) {
            case 18: 
            case 330: 
            case 606: {
                bByHeight = true;
                break;
            }
            default: {
                bByHeight = false;
                break;
            }
        }
        return bByHeight;
    }

    public boolean isGroupRelated() {
        boolean bGroup;
        switch (this.m_objectID) {
            case 331: 
            case 334: 
            case 335: 
            case 621: {
                bGroup = true;
                break;
            }
            default: {
                bGroup = false;
                break;
            }
        }
        return bGroup;
    }

    public boolean canBeExceptional() {
        boolean bCanBeExceptional;
        switch (this.m_objectID) {
            case -3: 
            case 13: 
            case 256: 
            case 258: 
            case 259: 
            case 277: 
            case 298: 
            case 299: 
            case 303: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 331: 
            case 334: 
            case 335: 
            case 473: 
            case 474: 
            case 475: 
            case 476: 
            case 602: 
            case 606: 
            case 621: {
                bCanBeExceptional = true;
                break;
            }
            default: {
                bCanBeExceptional = false;
                break;
            }
        }
        return bCanBeExceptional;
    }

    public boolean isSeriesRelated() {
        boolean bSeries;
        switch (this.m_objectID) {
            case -3: 
            case 13: 
            case 14: 
            case 256: 
            case 258: 
            case 259: 
            case 277: 
            case 298: 
            case 299: 
            case 303: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 332: 
            case 354: 
            case 473: 
            case 474: 
            case 475: 
            case 476: 
            case 602: 
            case 606: {
                bSeries = true;
                break;
            }
            default: {
                bSeries = false;
                break;
            }
        }
        return bSeries;
    }

    public boolean isText() {
        boolean bText = false;
        switch (this.m_objectID) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 42: 
            case 232: 
            case 233: 
            case 235: 
            case 260: 
            case 266: 
            case 270: 
            case 274: 
            case 280: 
            case 284: 
            case 288: 
            case 295: 
            case 356: 
            case 503: 
            case 601: 
            case 622: {
                bText = true;
                break;
            }
        }
        return bText;
    }

    public boolean isLine() {
        boolean bLine = false;
        switch (this.m_objectID) {
            case 17: 
            case 40: 
            case 41: 
            case 258: 
            case 262: 
            case 267: 
            case 268: 
            case 269: 
            case 271: 
            case 272: 
            case 275: 
            case 276: 
            case 278: 
            case 279: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 301: 
            case 304: 
            case 305: 
            case 307: 
            case 308: 
            case 309: 
            case 321: 
            case 322: 
            case 327: 
            case 328: 
            case 358: 
            case 439: 
            case 473: 
            case 610: 
            case 611: 
            case 612: 
            case 613: {
                bLine = true;
                break;
            }
        }
        return bLine;
    }

    public boolean isRiser() {
        boolean bRiser = false;
        switch (this.m_objectID) {
            case 256: 
            case 277: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 316: 
            case 319: 
            case 320: 
            case 354: 
            case 606: {
                bRiser = true;
                break;
            }
        }
        return bRiser;
    }

    public boolean isDataLabel() {
        boolean bDataLabel = false;
        switch (this.m_objectID) {
            case 601: {
                bDataLabel = true;
                break;
            }
        }
        return bDataLabel;
    }

    public boolean isGridLine() {
        boolean bGridLine = false;
        switch (this.m_objectID) {
            case 271: 
            case 272: 
            case 275: 
            case 276: 
            case 281: 
            case 282: 
            case 285: 
            case 286: 
            case 289: 
            case 290: 
            case 607: 
            case 608: 
            case 609: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: {
                bGridLine = true;
                break;
            }
        }
        return bGridLine;
    }

    public boolean matches(IdentObj id) {
        boolean bMatches = true;
        if (this.m_objectID != id.m_objectID && this.m_objectID != -3 && id.m_objectID != -3) {
            bMatches = false;
        }
        if (this.m_seriesID != id.m_seriesID && this.m_seriesID != -3 && id.m_seriesID != -3) {
            bMatches = false;
        }
        if (this.m_groupID != id.m_groupID && this.m_groupID != -3 && id.m_groupID != -3) {
            bMatches = false;
        }
        if (this.m_stackID != id.m_stackID && this.m_stackID != -3 && id.m_stackID != -3) {
            bMatches = false;
        }
        if (this.m_miscID != id.m_miscID && this.m_miscID != -3 && id.m_miscID != -3) {
            bMatches = false;
        }
        return bMatches;
    }

    public boolean matches(IdentObj id, boolean bObjectMustMatch, boolean bSeriesMustMatch, boolean bGroupMustMatch, boolean bStackMustMatch, boolean bMiscMustMatch) {
        boolean bMatches = true;
        if (bObjectMustMatch && this.m_objectID != id.m_objectID) {
            bMatches = false;
        }
        if (bSeriesMustMatch && this.m_seriesID != id.m_seriesID) {
            bMatches = false;
        }
        if (bGroupMustMatch && this.m_groupID != id.m_groupID) {
            bMatches = false;
        }
        if (bStackMustMatch && this.m_stackID != id.m_stackID) {
            bMatches = false;
        }
        if (bMiscMustMatch && this.m_miscID != id.m_miscID) {
            bMatches = false;
        }
        return bMatches;
    }

    public boolean needsStripping() {
        boolean bNeedsStripping = false;
        switch (this.m_objectID) {
            case 14: 
            case 294: 
            case 297: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 319: 
            case 320: 
            case 503: {
                bNeedsStripping = true;
                break;
            }
        }
        return bNeedsStripping;
    }

    public void setGroupID(int groupID) {
        this.m_groupID = groupID;
    }

    public void setMiscID(int miscID) {
        this.m_miscID = miscID;
    }

    public void setObjectID(int objectID) {
        this.m_objectID = objectID;
    }

    public void setSeriesID(int seriesID) {
        this.m_seriesID = seriesID;
    }

    public void setStackID(int stackID) {
        this.m_stackID = stackID;
    }

    public IdentObj stripExceptional() {
        IdentObj newID = new IdentObj(this);
        newID.setObjectID(ObjClassID.stripExceptionalOffset(this.m_objectID));
        return newID;
    }

    public String toString() {
        return "+1.0+" + this.m_objectID + "+" + this.m_seriesID + "+" + this.m_groupID + "+" + this.m_stackID + "+" + this.m_miscID + "+";
    }

    public String getIdentObjMethod() {
        String szMethod = "";
        boolean bNeedComma = false;
        Integer series = new Integer(this.m_seriesID);
        Integer group = new Integer(this.m_groupID);
        Integer stack = new Integer(this.m_stackID);
        Integer misc = new Integer(this.m_miscID);
        if (this.isOBJECT_NA() && this.isSTACK_NA()) {
            szMethod = !this.isSERIES_NA() && this.isGROUP_NA() ? "getSeries(" + series.toString() : (this.isSERIES_NA() && !this.isGROUP_NA() ? "getGroup(" + group.toString() : "getSeriesGroup(" + series.toString() + "," + group.toString());
        } else {
            if (!this.isOBJECT_NA()) {
                szMethod = ObjClassID.getObjMethodName(this.m_objectID) + "(";
            }
            if (!(this.isSERIES_NA() && this.isGROUP_NA() && this.isSTACK_NA())) {
                if (bNeedComma) {
                    szMethod = szMethod + ",";
                }
                szMethod = szMethod + series.toString();
                if (!this.isGROUP_NA() || !this.isSTACK_NA()) {
                    szMethod = szMethod + "," + group.toString();
                    if (this.m_stackID != -3) {
                        szMethod = szMethod + "," + stack.toString();
                    }
                }
            }
        }
        szMethod = szMethod + ")";
        if (this.m_objectID == 2000) {
            szMethod = "GLOBAL_SCALAR_PROPERTY";
        }
        return szMethod;
    }

    public boolean useFillColor() {
        boolean bFillColor = true;
        switch (this.m_objectID) {
            case 41: 
            case 257: 
            case 261: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 267: 
            case 268: 
            case 269: 
            case 271: 
            case 272: 
            case 273: 
            case 275: 
            case 276: 
            case 278: 
            case 279: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 304: 
            case 305: 
            case 307: 
            case 308: 
            case 309: 
            case 321: 
            case 322: 
            case 607: 
            case 608: 
            case 609: 
            case 610: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: {
                bFillColor = false;
            }
        }
        return bFillColor;
    }

    public boolean useBorderColor() {
        boolean bBorderColor = true;
        switch (this.m_objectID) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 232: 
            case 233: 
            case 258: 
            case 260: 
            case 266: 
            case 270: 
            case 274: 
            case 280: 
            case 284: 
            case 288: 
            case 295: 
            case 296: 
            case 297: 
            case 473: 
            case 503: 
            case 601: 
            case 622: {
                bBorderColor = false;
            }
        }
        return bBorderColor;
    }

    public boolean useLineWidth() {
        return this.isLine();
    }

    public boolean isDeadZoneObj(JGraphType gt) {
        boolean bIsDeadZoneObj;
        switch (this.m_objectID) {
            case 256: 
            case 258: 
            case 314: 
            case 318: 
            case 473: 
            case 475: {
                bIsDeadZoneObj = true;
                break;
            }
            case 606: {
                if (gt.is3DRiser() || gt.isRiserUnspecified()) {
                    bIsDeadZoneObj = false;
                    break;
                }
                bIsDeadZoneObj = true;
                break;
            }
            default: {
                bIsDeadZoneObj = false;
                break;
            }
        }
        return bIsDeadZoneObj;
    }
}

