/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.image.PixelGrabber;

class JpegInfo {
    String Comment;
    public Image imageobj;
    public int imageHeight;
    public int imageWidth;
    public int[] BlockWidth;
    public int[] BlockHeight;
    public int Precision;
    public int NumberOfComponents;
    public Object[] Components;
    public int[] CompID;
    public int[] HsampFactor;
    public int[] VsampFactor;
    public int[] QtableNumber;
    public int[] DCtableNumber;
    public int[] ACtableNumber;
    public boolean[] lastColumnIsDummy;
    public boolean[] lastRowIsDummy;
    public int Ss;
    public int Se;
    public int Ah;
    public int Al;
    public int[] compWidth;
    public int[] compHeight;
    public int MaxHsampFactor;
    public int MaxVsampFactor;

    private void $init$() {
        this.Precision = 8;
        this.NumberOfComponents = 3;
        this.CompID = new int[]{1, 2, 3};
        this.HsampFactor = new int[]{1, 1, 1};
        this.VsampFactor = new int[]{1, 1, 1};
        this.QtableNumber = new int[]{0, 1, 1};
        this.DCtableNumber = new int[]{0, 1, 1};
        this.ACtableNumber = new int[]{0, 1, 1};
        this.lastColumnIsDummy = new boolean[]{false, false, false};
        this.lastRowIsDummy = new boolean[]{false, false, false};
        this.Ss = 0;
        this.Se = 63;
        this.Ah = 0;
        this.Al = 0;
    }

    public JpegInfo(Image image) {
        this.$init$();
        this.Components = new Object[this.NumberOfComponents];
        this.compWidth = new int[this.NumberOfComponents];
        this.compHeight = new int[this.NumberOfComponents];
        this.BlockWidth = new int[this.NumberOfComponents];
        this.BlockHeight = new int[this.NumberOfComponents];
        this.imageobj = image;
        this.imageWidth = image.getWidth(null);
        this.imageHeight = image.getHeight(null);
        this.Comment = "JPEG Encoder Copyright 1998, James R. Weeks and BioElectroMech.  ";
        this.getYCCArray();
    }

    public void setComment(String comment) {
        this.Comment.concat(comment);
    }

    public String getComment() {
        return this.Comment;
    }

    private void getYCCArray() {
        int[] values = new int[this.imageWidth * this.imageHeight];
        PixelGrabber grabber = new PixelGrabber(this.imageobj.getSource(), 0, 0, this.imageWidth, this.imageHeight, values, 0, this.imageWidth);
        this.MaxHsampFactor = 1;
        this.MaxVsampFactor = 1;
        int y = 0;
        while (y < this.NumberOfComponents) {
            this.MaxHsampFactor = Math.max(this.MaxHsampFactor, this.HsampFactor[y]);
            this.MaxVsampFactor = Math.max(this.MaxVsampFactor, this.VsampFactor[y]);
            ++y;
        }
        y = 0;
        while (y < this.NumberOfComponents) {
            this.compWidth[y] = (this.imageWidth % 8 != 0 ? (int)Math.ceil((double)this.imageWidth / 8.0) * 8 : this.imageWidth) / this.MaxHsampFactor * this.HsampFactor[y];
            if (this.compWidth[y] != this.imageWidth / this.MaxHsampFactor * this.HsampFactor[y]) {
                this.lastColumnIsDummy[y] = true;
            }
            this.BlockWidth[y] = (int)Math.ceil((double)this.compWidth[y] / 8.0);
            this.compHeight[y] = (this.imageHeight % 8 != 0 ? (int)Math.ceil((double)this.imageHeight / 8.0) * 8 : this.imageHeight) / this.MaxVsampFactor * this.VsampFactor[y];
            if (this.compHeight[y] != this.imageHeight / this.MaxVsampFactor * this.VsampFactor[y]) {
                this.lastRowIsDummy[y] = true;
            }
            this.BlockHeight[y] = (int)Math.ceil((double)this.compHeight[y] / 8.0);
            ++y;
        }
        try {
            if (!grabber.grabPixels()) {
                try {
                    throw new AWTException("Grabber returned false: " + grabber.status());
                }
                catch (Exception e) {}
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        float[][] Y = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] Cr1 = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] Cb1 = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] Cb2 = new float[this.compHeight[1]][this.compWidth[1]];
        float[][] Cr2 = new float[this.compHeight[2]][this.compWidth[2]];
        int index = 0;
        y = 0;
        while (y < this.imageHeight) {
            int x = 0;
            while (x < this.imageWidth) {
                int r = values[index] >> 16 & 0xFF;
                int g = values[index] >> 8 & 0xFF;
                int b = values[index] & 0xFF;
                Y[y][x] = (float)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
                Cb1[y][x] = 128.0f + (float)(-0.16874 * (double)r - 0.33126 * (double)g + 0.5 * (double)b);
                Cr1[y][x] = 128.0f + (float)(0.5 * (double)r - 0.41869 * (double)g - 0.08131 * (double)b);
                ++index;
                ++x;
            }
            ++y;
        }
        this.Components[0] = Y;
        this.Components[1] = Cb1;
        this.Components[2] = Cr1;
    }

    float[][] DownSample(float[][] C, int comp) {
        int inrow = 0;
        int incol = 0;
        float[][] output = new float[this.compHeight[comp]][this.compWidth[comp]];
        int outrow = 0;
        while (outrow < this.compHeight[comp]) {
            int bias = 1;
            int outcol = 0;
            while (outcol < this.compWidth[comp]) {
                output[outrow][outcol] = (C[inrow][incol++] + C[inrow++][incol--] + C[inrow][incol++] + C[inrow--][incol++] + (float)bias) / 4.0f;
                bias ^= 3;
                ++outcol;
            }
            inrow += 2;
            incol = 0;
            ++outrow;
        }
        return output;
    }
}

