/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.math;

import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.math.CurveFitIF;

public class FitExponential
implements CurveFitIF {
    private static int NUM_COEFFS = 2;

    public double compute(double x, double[] a) throws AssertionException {
        PfjAssert.pfjAssert(a.length >= NUM_COEFFS + 1);
        double y = a[1] * Math.pow(a[2], x);
        return y;
    }

    public void eval(double x, double[] a) throws AssertionException {
        PfjAssert.pfjAssert(a.length >= NUM_COEFFS + 1);
        a[1] = 1.0;
        a[2] = x;
    }

    public int numCoeffs() {
        return NUM_COEFFS;
    }

    public double transformY(double y) throws AssertionException {
        PfjAssert.pfjAssert(y > 0.0);
        return Math.log(y);
    }

    public double invTransformCoeff(int ia, double a) {
        return Math.exp(a);
    }

    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) throws AssertionException {
        PfjAssert.pfjAssert(strCoeffs.length >= NUM_COEFFS + 1);
        String strTerm1 = strCoeffs[1];
        String strTerm2 = strCoeffs[2] + "^x";
        return "y = " + strTerm1 + " * " + strTerm2;
    }
}

