/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.math;

import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.math.CurveFitIF;

public class FitLogarithmic
implements CurveFitIF {
    private static int NUM_COEFFS = 2;

    public double compute(double x, double[] a) throws AssertionException {
        PfjAssert.pfjAssert(a.length >= NUM_COEFFS + 1);
        PfjAssert.pfjAssert(x > 0.0);
        double y = a[1] + a[2] * Math.log(x);
        return y;
    }

    public void eval(double x, double[] a) throws AssertionException {
        PfjAssert.pfjAssert(a.length >= NUM_COEFFS + 1);
        PfjAssert.pfjAssert(x > 0.0);
        a[1] = 1.0;
        a[2] = Math.log(x);
    }

    public int numCoeffs() {
        return NUM_COEFFS;
    }

    public double transformY(double y) {
        return y;
    }

    public double invTransformCoeff(int ia, double a) {
        return a;
    }

    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) throws AssertionException {
        PfjAssert.pfjAssert(strCoeffs.length >= NUM_COEFFS + 1);
        String strTerm1 = strCoeffs[1];
        String strTerm2 = strCoeffs[2] + " * log(x)";
        if (bHighOrderFirst) {
            return "y = " + strTerm2 + " + " + strTerm1;
        }
        return "y = " + strTerm1 + " + " + strTerm2;
    }
}

