/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.math;

import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.math.CurveFitIF;
import oracle.dss.graph.pfj.math.FP;

public class FitRational
implements CurveFitIF {
    private static int NUM_COEFFS = 2;

    public double compute(double x, double[] a) throws AssertionException {
        PfjAssert.pfjAssert(a.length >= NUM_COEFFS + 1);
        double y = x / (a[2] + a[1] * x);
        if (Double.isNaN(y)) {
            throw new AssertionException();
        }
        return y;
    }

    public void eval(double x, double[] a) throws AssertionException {
        PfjAssert.pfjAssert(a.length >= NUM_COEFFS + 1);
        PfjAssert.pfjAssert(FP.nonzero(x));
        a[1] = 1.0;
        a[2] = 1.0 / x;
    }

    public int numCoeffs() {
        return NUM_COEFFS;
    }

    public double transformY(double y) throws AssertionException {
        PfjAssert.pfjAssert(FP.nonzero(y));
        return 1.0 / y;
    }

    public double invTransformCoeff(int ia, double a) {
        return a;
    }

    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) throws AssertionException {
        PfjAssert.pfjAssert(strCoeffs.length >= NUM_COEFFS + 1);
        String strTerm1 = strCoeffs[2];
        String strTerm2 = strCoeffs[1] + " * x";
        if (bHighOrderFirst) {
            return "y = x / (" + strTerm2 + " + " + strTerm1 + ")";
        }
        return "y = x / (" + strTerm1 + " + " + strTerm2 + ")";
    }
}

