/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import java.io.Serializable;

public final class Matrix3d
implements Serializable {
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;

    public Matrix3d() {
        this(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    }

    public Matrix3d(double mm00, double mm01, double mm02, double mm10, double mm11, double mm12, double mm20, double mm21, double mm22) {
        this.m00 = mm00;
        this.m01 = mm01;
        this.m02 = mm02;
        this.m10 = mm10;
        this.m11 = mm11;
        this.m12 = mm12;
        this.m20 = mm20;
        this.m21 = mm21;
        this.m22 = mm22;
    }

    public Matrix3d(Matrix3d m) {
        this(m.m00, m.m01, m.m02, m.m10, m.m11, m.m12, m.m20, m.m21, m.m22);
    }

    public void identity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public void mult(Matrix3d m2) {
        double t00 = this.m00 * m2.m00 + this.m01 * m2.m10 + this.m02 * m2.m20;
        double t01 = this.m00 * m2.m01 + this.m01 * m2.m11 + this.m02 * m2.m21;
        double t02 = this.m00 * m2.m02 + this.m01 * m2.m12 + this.m02 * m2.m22;
        double t10 = this.m10 * m2.m00 + this.m11 * m2.m10 + this.m12 * m2.m20;
        double t11 = this.m10 * m2.m01 + this.m11 * m2.m11 + this.m12 * m2.m21;
        double t12 = this.m10 * m2.m02 + this.m11 * m2.m12 + this.m12 * m2.m22;
        double t20 = this.m20 * m2.m00 + this.m21 * m2.m10 + this.m22 * m2.m20;
        double t21 = this.m20 * m2.m01 + this.m21 * m2.m11 + this.m22 * m2.m21;
        double t22 = this.m20 * m2.m02 + this.m21 * m2.m12 + this.m22 * m2.m22;
        this.m00 = t00;
        this.m01 = t01;
        this.m02 = t02;
        this.m10 = t10;
        this.m11 = t11;
        this.m12 = t12;
        this.m20 = t20;
        this.m21 = t21;
        this.m22 = t22;
    }

    public Matrix3d multBy(Matrix3d m2) {
        Matrix3d m3 = new Matrix3d(this.m00 * m2.m00 + this.m01 * m2.m10 + this.m02 * m2.m20, this.m00 * m2.m01 + this.m01 * m2.m11 + this.m02 * m2.m21, this.m00 * m2.m02 + this.m01 * m2.m12 + this.m02 * m2.m22, this.m10 * m2.m00 + this.m11 * m2.m10 + this.m12 * m2.m20, this.m10 * m2.m01 + this.m11 * m2.m11 + this.m12 * m2.m21, this.m10 * m2.m02 + this.m11 * m2.m12 + this.m12 * m2.m22, this.m20 * m2.m00 + this.m21 * m2.m10 + this.m22 * m2.m20, this.m20 * m2.m01 + this.m21 * m2.m11 + this.m22 * m2.m21, this.m20 * m2.m02 + this.m21 * m2.m12 + this.m22 * m2.m22);
        return m3;
    }

    public void rotX(double radiansX) {
        double cosX = Math.cos(radiansX);
        double sinX = Math.sin(radiansX);
        double t01 = this.m01 * cosX + this.m02 * -sinX;
        double t02 = this.m01 * sinX + this.m02 * cosX;
        double t11 = this.m11 * cosX + this.m12 * -sinX;
        double t12 = this.m11 * sinX + this.m12 * cosX;
        double t21 = this.m21 * cosX + this.m22 * -sinX;
        double t22 = this.m21 * sinX + this.m22 * cosX;
        this.m01 = t01;
        this.m02 = t02;
        this.m11 = t11;
        this.m12 = t12;
        this.m21 = t21;
        this.m22 = t22;
    }

    public void rotY(double radiansY) {
        double cosY = Math.cos(radiansY);
        double sinY = Math.sin(radiansY);
        double t00 = this.m00 * cosY + this.m02 * sinY;
        double t02 = this.m00 * -sinY + this.m02 * cosY;
        double t10 = this.m10 * cosY + this.m12 * sinY;
        double t12 = this.m10 * -sinY + this.m12 * cosY;
        double t20 = this.m20 * cosY + this.m22 * sinY;
        double t22 = this.m20 * -sinY + this.m22 * cosY;
        this.m00 = t00;
        this.m02 = t02;
        this.m10 = t10;
        this.m12 = t12;
        this.m20 = t20;
        this.m22 = t22;
    }

    public void rotZ(double radiansZ) {
        double cosZ = Math.cos(radiansZ);
        double sinZ = Math.sin(radiansZ);
        double t00 = this.m00 * cosZ + this.m01 * -sinZ;
        double t01 = this.m00 * sinZ + this.m01 * cosZ;
        double t10 = this.m10 * cosZ + this.m11 * -sinZ;
        double t11 = this.m10 * sinZ + this.m11 * cosZ;
        double t20 = this.m20 * cosZ + this.m21 * -sinZ;
        double t21 = this.m20 * sinZ + this.m21 * cosZ;
        this.m00 = t00;
        this.m01 = t01;
        this.m10 = t10;
        this.m11 = t11;
        this.m20 = t20;
        this.m21 = t21;
    }

    public void scale(double fx, double fy, double fz) {
        this.m00 *= fx;
        this.m01 *= fx;
        this.m02 *= fx;
        this.m10 *= fy;
        this.m11 *= fy;
        this.m12 *= fy;
        this.m20 *= fz;
        this.m21 *= fz;
        this.m22 *= fz;
    }

    public void scale(double s) {
        this.m00 *= s;
        this.m01 *= s;
        this.m02 *= s;
        this.m10 *= s;
        this.m11 *= s;
        this.m12 *= s;
        this.m20 *= s;
        this.m21 *= s;
        this.m22 *= s;
    }

    public Matrix3d transpose() {
        Matrix3d m = new Matrix3d(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
        return m;
    }
}

