/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import java.io.Serializable;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.model3d.Matrix3d;

public final class Matrix4d
implements Serializable {
    public static final int ROT_X = 0;
    public static final int ROT_Y = 1;
    public static final int ROT_Z = 2;
    public double m00;
    public double m01;
    public double m02;
    public double m03;
    public double m10;
    public double m11;
    public double m12;
    public double m13;
    public double m20;
    public double m21;
    public double m22;
    public double m23;
    public double m30;
    public double m31;
    public double m32;
    public double m33;

    public Matrix4d() {
        this(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public Matrix4d(double mm00, double mm01, double mm02, double mm03, double mm10, double mm11, double mm12, double mm13, double mm20, double mm21, double mm22, double mm23, double mm30, double mm31, double mm32, double mm33) {
        this.m00 = mm00;
        this.m01 = mm01;
        this.m02 = mm02;
        this.m03 = mm03;
        this.m10 = mm10;
        this.m11 = mm11;
        this.m12 = mm12;
        this.m13 = mm13;
        this.m20 = mm20;
        this.m21 = mm21;
        this.m22 = mm22;
        this.m23 = mm23;
        this.m30 = mm30;
        this.m31 = mm31;
        this.m32 = mm32;
        this.m33 = mm33;
    }

    public Matrix4d(int axis, double radians) {
        this();
        double cosA = Math.cos(radians);
        double sinA = Math.sin(radians);
        switch (axis) {
            case 0: {
                this.m11 = cosA;
                this.m12 = sinA;
                this.m21 = -sinA;
                this.m22 = cosA;
                break;
            }
            case 1: {
                this.m00 = cosA;
                this.m02 = -sinA;
                this.m20 = sinA;
                this.m22 = cosA;
                break;
            }
            case 2: {
                this.m00 = cosA;
                this.m01 = sinA;
                this.m10 = -sinA;
                this.m11 = cosA;
                break;
            }
            default: {
                throw new AssertionException("unknown type of rotation matrix" + axis);
            }
        }
    }

    public Matrix4d(Matrix3d m) {
        this(m.m00, m.m01, m.m02, 0.0, m.m10, m.m11, m.m12, 0.0, m.m20, m.m21, m.m22, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public Matrix4d(Matrix4d m) {
        this(m.m00, m.m01, m.m02, m.m03, m.m10, m.m11, m.m12, m.m13, m.m20, m.m21, m.m22, m.m23, m.m30, m.m31, m.m32, m.m33);
    }

    public Matrix3d getMatrix3d() {
        Matrix3d m3 = new Matrix3d(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
        return m3;
    }

    public void identity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public void mult(Matrix3d m2) {
        double t00 = this.m00 * m2.m00 + this.m01 * m2.m10 + this.m02 * m2.m20;
        double t01 = this.m00 * m2.m01 + this.m01 * m2.m11 + this.m02 * m2.m21;
        double t02 = this.m00 * m2.m02 + this.m01 * m2.m12 + this.m02 * m2.m22;
        double t10 = this.m10 * m2.m00 + this.m11 * m2.m10 + this.m12 * m2.m20;
        double t11 = this.m10 * m2.m01 + this.m11 * m2.m11 + this.m12 * m2.m21;
        double t12 = this.m10 * m2.m02 + this.m11 * m2.m12 + this.m12 * m2.m22;
        double t20 = this.m20 * m2.m00 + this.m21 * m2.m10 + this.m22 * m2.m20;
        double t21 = this.m20 * m2.m01 + this.m21 * m2.m11 + this.m22 * m2.m21;
        double t22 = this.m20 * m2.m02 + this.m21 * m2.m12 + this.m22 * m2.m22;
        double t30 = this.m30 * m2.m00 + this.m31 * m2.m10 + this.m32 * m2.m20;
        double t31 = this.m30 * m2.m01 + this.m31 * m2.m11 + this.m32 * m2.m21;
        double t32 = this.m30 * m2.m02 + this.m31 * m2.m12 + this.m32 * m2.m22;
        this.m00 = t00;
        this.m01 = t01;
        this.m02 = t02;
        this.m10 = t10;
        this.m11 = t11;
        this.m12 = t12;
        this.m20 = t20;
        this.m21 = t21;
        this.m22 = t22;
        this.m30 = t30;
        this.m31 = t31;
        this.m32 = t32;
    }

    public void mult(Matrix4d m2) {
        double t00 = this.m00 * m2.m00 + this.m01 * m2.m10 + this.m02 * m2.m20 + this.m03 * m2.m30;
        double t01 = this.m00 * m2.m01 + this.m01 * m2.m11 + this.m02 * m2.m21 + this.m03 * m2.m31;
        double t02 = this.m00 * m2.m02 + this.m01 * m2.m12 + this.m02 * m2.m22 + this.m03 * m2.m32;
        double t03 = this.m00 * m2.m03 + this.m01 * m2.m13 + this.m02 * m2.m23 + this.m03 * m2.m33;
        double t10 = this.m10 * m2.m00 + this.m11 * m2.m10 + this.m12 * m2.m20 + this.m13 * m2.m30;
        double t11 = this.m10 * m2.m01 + this.m11 * m2.m11 + this.m12 * m2.m21 + this.m13 * m2.m31;
        double t12 = this.m10 * m2.m02 + this.m11 * m2.m12 + this.m12 * m2.m22 + this.m13 * m2.m32;
        double t13 = this.m10 * m2.m03 + this.m11 * m2.m13 + this.m12 * m2.m23 + this.m13 * m2.m33;
        double t20 = this.m20 * m2.m00 + this.m21 * m2.m10 + this.m22 * m2.m20 + this.m23 * m2.m30;
        double t21 = this.m20 * m2.m01 + this.m21 * m2.m11 + this.m22 * m2.m21 + this.m23 * m2.m31;
        double t22 = this.m20 * m2.m02 + this.m21 * m2.m12 + this.m22 * m2.m22 + this.m23 * m2.m32;
        double t23 = this.m20 * m2.m03 + this.m21 * m2.m13 + this.m22 * m2.m23 + this.m23 * m2.m33;
        double t30 = this.m30 * m2.m00 + this.m31 * m2.m10 + this.m32 * m2.m20 + this.m33 * m2.m30;
        double t31 = this.m30 * m2.m01 + this.m31 * m2.m11 + this.m32 * m2.m21 + this.m33 * m2.m31;
        double t32 = this.m30 * m2.m02 + this.m31 * m2.m12 + this.m32 * m2.m22 + this.m33 * m2.m32;
        double t33 = this.m30 * m2.m03 + this.m31 * m2.m13 + this.m32 * m2.m23 + this.m33 * m2.m33;
        this.m00 = t00;
        this.m01 = t01;
        this.m02 = t02;
        this.m03 = t03;
        this.m10 = t10;
        this.m11 = t11;
        this.m12 = t12;
        this.m13 = t13;
        this.m20 = t20;
        this.m21 = t21;
        this.m22 = t22;
        this.m23 = t23;
        this.m30 = t30;
        this.m31 = t31;
        this.m32 = t32;
        this.m33 = t33;
    }

    public Matrix4d multBy(Matrix4d m2) {
        Matrix4d m3 = new Matrix4d(this.m00 * m2.m00 + this.m01 * m2.m10 + this.m02 * m2.m20 + this.m03 * m2.m30, this.m00 * m2.m01 + this.m01 * m2.m11 + this.m02 * m2.m21 + this.m03 * m2.m31, this.m00 * m2.m02 + this.m01 * m2.m12 + this.m02 * m2.m22 + this.m03 * m2.m32, this.m00 * m2.m03 + this.m01 * m2.m13 + this.m02 * m2.m23 + this.m03 * m2.m33, this.m10 * m2.m00 + this.m11 * m2.m10 + this.m12 * m2.m20 + this.m13 * m2.m30, this.m10 * m2.m01 + this.m11 * m2.m11 + this.m12 * m2.m21 + this.m13 * m2.m31, this.m10 * m2.m02 + this.m11 * m2.m12 + this.m12 * m2.m22 + this.m13 * m2.m32, this.m10 * m2.m03 + this.m11 * m2.m13 + this.m12 * m2.m23 + this.m13 * m2.m33, this.m20 * m2.m00 + this.m21 * m2.m10 + this.m22 * m2.m20 + this.m23 * m2.m30, this.m20 * m2.m01 + this.m21 * m2.m11 + this.m22 * m2.m21 + this.m23 * m2.m31, this.m20 * m2.m02 + this.m21 * m2.m12 + this.m22 * m2.m22 + this.m23 * m2.m32, this.m20 * m2.m03 + this.m21 * m2.m13 + this.m22 * m2.m23 + this.m23 * m2.m33, this.m30 * m2.m00 + this.m31 * m2.m10 + this.m32 * m2.m20 + this.m33 * m2.m30, this.m30 * m2.m01 + this.m31 * m2.m11 + this.m32 * m2.m21 + this.m33 * m2.m31, this.m30 * m2.m02 + this.m31 * m2.m12 + this.m32 * m2.m22 + this.m33 * m2.m32, this.m30 * m2.m03 + this.m31 * m2.m13 + this.m32 * m2.m23 + this.m33 * m2.m33);
        return m3;
    }

    public void rotate(Matrix3d mRot) {
        this.mult(mRot);
    }

    public void scale(double s) {
        this.m00 *= s;
        this.m01 *= s;
        this.m02 *= s;
        this.m10 *= s;
        this.m11 *= s;
        this.m12 *= s;
        this.m20 *= s;
        this.m21 *= s;
        this.m22 *= s;
    }

    public void translate(double fx, double fy, double fz) {
        this.m30 += fx;
        this.m31 += fy;
        this.m32 += fz;
    }

    public Matrix4d transpose() {
        Matrix4d m = new Matrix4d(this.m00, this.m10, this.m20, this.m30, this.m01, this.m11, this.m21, this.m31, this.m02, this.m12, this.m22, this.m32, this.m03, this.m13, this.m23, this.m33);
        return m;
    }
}

