/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.math.FP;
import oracle.dss.graph.pfj.model3d.Model3DRectSolid;
import oracle.dss.graph.pfj.model3d.Point3d;

public class Model3DModRectSolid
extends Model3DRectSolid {
    public Model3DModRectSolid(JChart_3D chart, IdentObj id, BlackBoxIF bb, Point3d origin, Point3d size, boolean[][] bGridStatus, boolean bAutoshading) {
        super(chart, id, bb, origin, size, bGridStatus, bAutoshading, false);
    }

    public Model3DModRectSolid(Model3DRectSolid model) {
        super(model);
    }

    public void modBackFace(double newTop, double newBottom) {
        this.m_vertices[4].y = newBottom;
        this.m_vertices[5].y = newBottom;
        this.m_vertices[6].y = newTop;
        this.m_vertices[7].y = newTop;
        this.m_bIsTransformed = false;
    }

    public void modBackFace(double newTop, double newBottom, boolean bDisplayFloor, double floorTop) {
        if (bDisplayFloor && newTop < floorTop) {
            double ratioTop = (this.m_vertices[2].y - floorTop) / (this.m_vertices[2].y - newTop);
            double ratioBot = (this.m_vertices[0].y - floorTop) / (this.m_vertices[0].y - newBottom);
            double zTop = this.m_size.z * ratioTop;
            double zBot = this.m_size.z * ratioBot;
            this.m_vertices[4].y = floorTop;
            this.m_vertices[5].y = floorTop;
            this.m_vertices[6].y = floorTop;
            this.m_vertices[7].y = floorTop;
            this.m_vertices[4].z = zBot;
            this.m_vertices[5].z = zBot;
            this.m_vertices[6].z = zTop;
            this.m_vertices[7].z = zTop;
            this.m_bIsTransformed = false;
        } else {
            this.modBackFace(newTop, newBottom);
        }
    }

    public void modFrontFace(double newTop, double newBottom) {
        this.m_vertices[0].y = newBottom;
        this.m_vertices[1].y = newBottom;
        this.m_vertices[2].y = newTop;
        this.m_vertices[3].y = newTop;
        this.m_bIsTransformed = false;
    }

    public void modFrontFace(double newTop, double newBottom, boolean bDisplayFloor, double floorTop) {
        if (bDisplayFloor && newTop < floorTop) {
            double ratioTop = (this.m_vertices[6].y - floorTop) / (this.m_vertices[6].y - newTop);
            double ratioBot = (this.m_vertices[4].y - floorTop) / (this.m_vertices[4].y - newBottom);
            double zTop = this.m_size.z * ratioTop;
            double zBot = this.m_size.z * ratioBot;
            this.m_vertices[0].y = floorTop;
            this.m_vertices[1].y = floorTop;
            this.m_vertices[2].y = floorTop;
            this.m_vertices[3].y = floorTop;
            this.m_vertices[0].z = zBot;
            this.m_vertices[1].z = zBot;
            this.m_vertices[2].z = zTop;
            this.m_vertices[3].z = zTop;
            this.m_bIsTransformed = false;
        } else {
            this.modFrontFace(newTop, newBottom);
        }
    }

    public void modLeftFace(double newTop, double newBottom) {
        this.m_vertices[0].y = newBottom;
        this.m_vertices[4].y = newBottom;
        this.m_vertices[3].y = newTop;
        this.m_vertices[7].y = newTop;
        this.m_bIsTransformed = false;
    }

    public void modLeftFace(double newTop, double newBottom, boolean bDisplayFloor, double floorTop) {
        if (bDisplayFloor && newTop < floorTop) {
            double ratioTop = (this.m_vertices[6].y - floorTop) / (this.m_vertices[6].y - newTop);
            double ratioBot = (this.m_vertices[4].y - floorTop) / (this.m_vertices[4].y - newBottom);
            double zTop = this.m_size.z * ratioTop;
            double zBot = this.m_size.z * ratioBot;
            this.m_vertices[0].y = floorTop;
            this.m_vertices[3].y = floorTop;
            this.m_vertices[4].y = floorTop;
            this.m_vertices[7].y = floorTop;
            this.m_vertices[0].z = zBot;
            this.m_vertices[4].z = zBot;
            this.m_vertices[3].z = zTop;
            this.m_vertices[7].z = zTop;
            this.m_bIsTransformed = false;
        } else {
            this.modLeftFace(newTop, newBottom);
        }
    }

    public void modRightFace(double newTop, double newBottom) {
        this.m_vertices[1].y = newBottom;
        this.m_vertices[5].y = newBottom;
        this.m_vertices[2].y = newTop;
        this.m_vertices[6].y = newTop;
        this.m_bIsTransformed = false;
    }

    public void modRightFace(double newTop, double newBottom, boolean bDisplayFloor, double floorTop) {
        if (bDisplayFloor && newTop < floorTop) {
            double ratioTop = (this.m_vertices[6].y - floorTop) / (this.m_vertices[6].y - newTop);
            double ratioBot = (this.m_vertices[4].y - floorTop) / (this.m_vertices[4].y - newBottom);
            double zTop = this.m_size.z * ratioTop;
            double zBot = this.m_size.z * ratioBot;
            this.m_vertices[1].y = floorTop;
            this.m_vertices[2].y = floorTop;
            this.m_vertices[5].y = floorTop;
            this.m_vertices[6].y = floorTop;
            this.m_vertices[1].z = zBot;
            this.m_vertices[5].z = zBot;
            this.m_vertices[2].z = zTop;
            this.m_vertices[6].z = zTop;
            this.m_bIsTransformed = false;
        } else {
            this.modRightFace(newTop, newBottom);
        }
    }

    protected Point3d getGridLineEnd(int nAxis, int nFace, double d) {
        block0 : switch (nAxis) {
            case 0: {
                break;
            }
            case 1: {
                switch (nFace) {
                    case 0: {
                        if (d > this.m_vertices[1].y) {
                            if (d < this.m_vertices[2].y) {
                                return new Point3d(this.m_vertices[1].x, d, this.m_vertices[1].z);
                            }
                            if (!(d < this.m_vertices[3].y)) break block0;
                            double dy = (d - this.m_vertices[2].y) / (this.m_vertices[3].y - this.m_vertices[2].y);
                            return new Point3d(this.m_vertices[2].x - dy * (this.m_vertices[2].x - this.m_vertices[3].x), d, this.m_vertices[0].z);
                        }
                        if (!(d > this.m_vertices[0].y)) break block0;
                        double dy = (d - this.m_vertices[0].y) / (this.m_vertices[1].y - this.m_vertices[0].y);
                        return new Point3d(this.m_vertices[0].x + dy * (this.m_vertices[1].x - this.m_vertices[0].x), d, this.m_vertices[0].z);
                    }
                    case 1: {
                        if (d > this.m_vertices[0].y) {
                            if (d < this.m_vertices[3].y) {
                                return new Point3d(this.m_vertices[0].x, d, this.m_vertices[0].z);
                            }
                            if (!(d < this.m_vertices[7].y)) break block0;
                            double dy = (d - this.m_vertices[3].y) / (this.m_vertices[7].y - this.m_vertices[2].y);
                            return new Point3d(this.m_vertices[4].x, d, this.m_vertices[7].z + (1.0 - dy) * (this.m_vertices[3].z - this.m_vertices[7].z));
                        }
                        if (!(d > this.m_vertices[4].y)) break block0;
                        double dy = (d - this.m_vertices[0].y) / (this.m_vertices[4].y - this.m_vertices[0].y);
                        return new Point3d(this.m_vertices[4].x, d, this.m_vertices[0].z + dy * (this.m_vertices[4].z - this.m_vertices[0].z));
                    }
                    case 2: {
                        if (!FP.between(d, Math.min(this.m_vertices[2].y, this.m_vertices[7].y), Math.max(this.m_vertices[2].y, this.m_vertices[7].y))) break block0;
                        double dyx = !FP.equal(this.m_vertices[3].y, this.m_vertices[2].y) ? (d - this.m_vertices[3].y) / (this.m_vertices[2].y - this.m_vertices[3].y) : 1.0;
                        double dyz = !FP.equal(this.m_vertices[2].y, this.m_vertices[6].y) ? (d - this.m_vertices[6].y) / (this.m_vertices[2].y - this.m_vertices[6].y) : 1.0;
                        return new Point3d(this.m_vertices[3].x + dyx * (this.m_vertices[2].x - this.m_vertices[3].x), d, this.m_vertices[6].z + dyz * (this.m_vertices[2].z - this.m_vertices[6].z));
                    }
                    case 3: {
                        if (d > this.m_vertices[4].y) {
                            if (d < this.m_vertices[7].y) {
                                return new Point3d(this.m_vertices[4].x, d, this.m_vertices[4].z);
                            }
                            if (!(d < this.m_vertices[6].y)) break block0;
                            double dy = (d - this.m_vertices[7].y) / (this.m_vertices[6].y - this.m_vertices[7].y);
                            return new Point3d(this.m_vertices[7].x + dy * (this.m_vertices[6].x - this.m_vertices[7].x), d, this.m_vertices[4].z);
                        }
                        if (!(d > this.m_vertices[5].y)) break block0;
                        double dy = (d - this.m_vertices[5].y) / (this.m_vertices[4].y - this.m_vertices[5].y);
                        return new Point3d(this.m_vertices[4].x + (1.0 - dy) * (this.m_vertices[5].x - this.m_vertices[4].x), d, this.m_vertices[0].z);
                    }
                    case 4: {
                        if (d > this.m_vertices[1].y) {
                            if (d < this.m_vertices[2].y) {
                                return new Point3d(this.m_vertices[1].x, d, this.m_vertices[1].z);
                            }
                            if (!(d < this.m_vertices[6].y)) break block0;
                            double dy = (d - this.m_vertices[2].y) / (this.m_vertices[6].y - this.m_vertices[2].y);
                            return new Point3d(this.m_vertices[1].x, d, this.m_vertices[6].z + (1.0 - dy) * (this.m_vertices[2].z - this.m_vertices[6].z));
                        }
                        if (!(d > this.m_vertices[5].y)) break block0;
                        double dy = (d - this.m_vertices[5].y) / (this.m_vertices[1].y - this.m_vertices[5].y);
                        return new Point3d(this.m_vertices[1].x, d, this.m_vertices[5].z + dy * (this.m_vertices[1].z - this.m_vertices[5].z));
                    }
                    case 5: {
                        if (!FP.between(d, Math.min(this.m_vertices[1].y, this.m_vertices[4].y), Math.max(this.m_vertices[1].y, this.m_vertices[4].y))) break block0;
                        double dyx = !FP.equal(this.m_vertices[0].y, this.m_vertices[1].y) ? (d - this.m_vertices[0].y) / (this.m_vertices[1].y - this.m_vertices[0].y) : 1.0;
                        double dyz = !FP.equal(this.m_vertices[1].y, this.m_vertices[5].y) ? (d - this.m_vertices[5].y) / (this.m_vertices[1].y - this.m_vertices[5].y) : 1.0;
                        return new Point3d(this.m_vertices[3].x + dyx * (this.m_vertices[1].x - this.m_vertices[3].x), d, this.m_vertices[5].z + dyz * (this.m_vertices[1].z - this.m_vertices[5].z));
                    }
                }
                break;
            }
            case 2: {
                break;
            }
        }
        return null;
    }

    protected Point3d getGridLineStart(int nAxis, int nFace, double d) {
        block0 : switch (nAxis) {
            case 0: {
                break;
            }
            case 1: {
                switch (nFace) {
                    case 0: {
                        if (d > this.m_vertices[0].y) {
                            if (d < this.m_vertices[3].y) {
                                return new Point3d(this.m_vertices[0].x, d, this.m_vertices[0].z);
                            }
                            if (!(d < this.m_vertices[2].y)) break block0;
                            double dy = (d - this.m_vertices[3].y) / (this.m_vertices[2].y - this.m_vertices[3].y);
                            return new Point3d(this.m_vertices[3].x + dy * (this.m_vertices[2].x - this.m_vertices[3].x), d, this.m_vertices[3].z);
                        }
                        if (!(d > this.m_vertices[1].y)) break block0;
                        double dy = (d - this.m_vertices[0].y) / (this.m_vertices[1].y - this.m_vertices[0].y);
                        return new Point3d(this.m_vertices[0].x + dy * (this.m_vertices[1].x - this.m_vertices[0].x), d, this.m_vertices[0].z);
                    }
                    case 1: {
                        if (d > this.m_vertices[4].y) {
                            if (d < this.m_vertices[7].y) {
                                return new Point3d(this.m_vertices[4].x, d, this.m_vertices[4].z);
                            }
                            if (!(d < this.m_vertices[3].y)) break block0;
                            double dy = (d - this.m_vertices[7].y) / (this.m_vertices[3].y - this.m_vertices[7].y);
                            return new Point3d(this.m_vertices[4].x, d, this.m_vertices[7].z + dy * (this.m_vertices[3].z - this.m_vertices[7].z));
                        }
                        if (!(d > this.m_vertices[0].y)) break block0;
                        double dy = (d - this.m_vertices[0].y) / (this.m_vertices[4].y - this.m_vertices[0].y);
                        return new Point3d(this.m_vertices[4].x, d, this.m_vertices[4].z + (1.0 - dy) * (this.m_vertices[0].z - this.m_vertices[4].z));
                    }
                    case 2: {
                        if (!FP.between(d, Math.min(this.m_vertices[2].y, this.m_vertices[7].y), Math.max(this.m_vertices[2].y, this.m_vertices[7].y))) break block0;
                        double dyx = !FP.equal(this.m_vertices[6].y, this.m_vertices[7].y) ? (d - this.m_vertices[7].y) / (this.m_vertices[6].y - this.m_vertices[7].y) : 0.0;
                        double dyz = !FP.equal(this.m_vertices[3].y, this.m_vertices[7].y) ? (d - this.m_vertices[7].y) / (this.m_vertices[3].y - this.m_vertices[7].y) : 0.0;
                        return new Point3d(this.m_vertices[7].x + dyx * (this.m_vertices[6].x - this.m_vertices[7].x), d, this.m_vertices[7].z + dyz * (this.m_vertices[3].z - this.m_vertices[7].z));
                    }
                    case 3: {
                        if (d > this.m_vertices[5].y) {
                            if (d < this.m_vertices[6].y) {
                                return new Point3d(this.m_vertices[5].x, d, this.m_vertices[5].z);
                            }
                            if (!(d < this.m_vertices[7].y)) break block0;
                            double dy = (d - this.m_vertices[6].y) / (this.m_vertices[7].y - this.m_vertices[6].y);
                            return new Point3d(this.m_vertices[7].x + (1.0 - dy) * (this.m_vertices[6].x - this.m_vertices[7].x), d, this.m_vertices[6].z);
                        }
                        if (!(d > this.m_vertices[4].y)) break block0;
                        double dy = (d - this.m_vertices[4].y) / (this.m_vertices[5].y - this.m_vertices[4].y);
                        return new Point3d(this.m_vertices[4].x + dy * (this.m_vertices[5].x - this.m_vertices[4].x), d, this.m_vertices[0].z);
                    }
                    case 4: {
                        if (d > this.m_vertices[5].y) {
                            if (d < this.m_vertices[6].y) {
                                return new Point3d(this.m_vertices[5].x, d, this.m_vertices[5].z);
                            }
                            if (!(d < this.m_vertices[2].y)) break block0;
                            double dy = (d - this.m_vertices[6].y) / (this.m_vertices[2].y - this.m_vertices[6].y);
                            return new Point3d(this.m_vertices[5].x, d, this.m_vertices[6].z + dy * (this.m_vertices[2].z - this.m_vertices[6].z));
                        }
                        if (!(d > this.m_vertices[1].y)) break block0;
                        double dy = (d - this.m_vertices[1].y) / (this.m_vertices[5].y - this.m_vertices[1].y);
                        return new Point3d(this.m_vertices[5].x, d, this.m_vertices[5].z + (1.0 - dy) * (this.m_vertices[1].z - this.m_vertices[5].z));
                    }
                    case 5: {
                        if (!FP.between(d, Math.min(this.m_vertices[1].y, this.m_vertices[4].y), Math.max(this.m_vertices[1].y, this.m_vertices[4].y))) break block0;
                        double dyx = !FP.equal(this.m_vertices[5].y, this.m_vertices[4].y) ? (d - this.m_vertices[4].y) / (this.m_vertices[5].y - this.m_vertices[4].y) : 0.0;
                        double dyz = !FP.equal(this.m_vertices[0].y, this.m_vertices[4].y) ? (d - this.m_vertices[4].y) / (this.m_vertices[0].y - this.m_vertices[4].y) : 0.0;
                        return new Point3d(this.m_vertices[4].x + dyx * (this.m_vertices[5].x - this.m_vertices[4].x), d, this.m_vertices[4].z + dyz * (this.m_vertices[0].z - this.m_vertices[4].z));
                    }
                }
                break;
            }
            case 2: {
                break;
            }
        }
        return null;
    }

    public boolean isVisibleIpsoFacto(int f) {
        throw new AssertionException("Simple visiblity is not available for modified rectangular solids");
    }
}

