/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.model3d.Model3DFlatFace;
import oracle.dss.graph.pfj.model3d.Point3d;

public class Model3DOctagonSolid
extends Model3DFlatFace {
    public static final int LEFT = 0;
    public static final int LEFT_FRONT = 1;
    public static final int FRONT = 2;
    public static final int RIGHT_FRONT = 3;
    public static final int RIGHT = 4;
    public static final int RIGHT_BACK = 5;
    public static final int BACK = 6;
    public static final int LEFT_BACK = 7;
    public static final int TOP = 8;
    public static final int BOTTOM = 9;
    public static final int MIN_POINTS = 3;
    public static final double BY_ANGLE_SCALE = 1.0;
    protected Point3d m_origin;
    protected Point3d m_size;
    private static int[][] m_myfaces = new int[][]{{0, 1, 9, 8}, {1, 2, 10, 9}, {2, 3, 11, 10}, {3, 4, 12, 11}, {4, 5, 13, 12}, {5, 6, 14, 13}, {6, 7, 15, 14}, {7, 0, 8, 15}, {8, 9, 10, 11, 12, 13, 14, 15}, {7, 6, 5, 4, 3, 2, 1, 0}};

    public Model3DOctagonSolid(JChart_3D chart, IdentObj id, BlackBoxIF bb, Point3d origin, Point3d size, boolean[][] bGridStatus, boolean bAutoshading) {
        super(chart, id, bb, 10, 16, bGridStatus, bAutoshading);
        double nearX = size.x * 0.2928932;
        double nearZ = size.z * 0.2928932;
        double farX = size.x * 0.7071068;
        double farZ = size.z * 0.7071068;
        this.m_origin = new Point3d(origin);
        this.m_size = new Point3d(size);
        this.m_faces = m_myfaces;
        int i = 0;
        while (i < this.m_nVertices) {
            this.m_vertices[i] = new Point3d(origin);
            if (i > 7) {
                this.m_vertices[i].y += this.m_size.y;
            }
            ++i;
        }
        this.m_vertices[0].z += nearZ;
        this.m_vertices[1].z += farZ;
        this.m_vertices[2].x += nearX;
        this.m_vertices[2].z += this.m_size.z;
        this.m_vertices[3].x += farX;
        this.m_vertices[3].z += this.m_size.z;
        this.m_vertices[4].x += this.m_size.x;
        this.m_vertices[4].z += farZ;
        this.m_vertices[5].x += this.m_size.x;
        this.m_vertices[5].z += nearZ;
        this.m_vertices[6].x += farX;
        this.m_vertices[7].x += nearX;
        this.m_vertices[8].z += nearZ;
        this.m_vertices[9].z += farZ;
        this.m_vertices[10].x += nearX;
        this.m_vertices[10].z += this.m_size.z;
        this.m_vertices[11].x += farX;
        this.m_vertices[11].z += this.m_size.z;
        this.m_vertices[12].x += this.m_size.x;
        this.m_vertices[12].z += farZ;
        this.m_vertices[13].x += this.m_size.x;
        this.m_vertices[13].z += nearZ;
        this.m_vertices[14].x += farX;
        this.m_vertices[15].x += nearX;
    }

    public Model3DOctagonSolid(Model3DOctagonSolid model) {
        this(model.m_chart, model.m_id, model.m_bb, model.m_origin, model.m_size, model.m_bGridStatus, model.m_bAutoshading);
        this.m_distance = model.m_distance;
    }

    protected Point3d getCenter() {
        return new Point3d(this.m_origin.x + this.m_size.x / 2.0, this.m_origin.y + this.m_size.y / 2.0, this.m_origin.z + this.m_size.z / 2.0);
    }

    public Point3d getGridLineEnd(int nAxis, int nFace, double d) {
        switch (nAxis) {
            case 1: {
                switch (nFace) {
                    case 0: {
                        return new Point3d(this.m_vertices[1].x, d, this.m_vertices[1].z);
                    }
                    case 1: {
                        return new Point3d(this.m_vertices[2].x, d, this.m_vertices[2].z);
                    }
                    case 2: {
                        return new Point3d(this.m_vertices[3].x, d, this.m_vertices[3].z);
                    }
                    case 3: {
                        return new Point3d(this.m_vertices[4].x, d, this.m_vertices[4].z);
                    }
                    case 4: {
                        return new Point3d(this.m_vertices[5].x, d, this.m_vertices[5].z);
                    }
                    case 5: {
                        return new Point3d(this.m_vertices[6].x, d, this.m_vertices[6].z);
                    }
                    case 6: {
                        return new Point3d(this.m_vertices[7].x, d, this.m_vertices[7].z);
                    }
                    case 7: {
                        return new Point3d(this.m_vertices[8].x, d, this.m_vertices[8].z);
                    }
                }
                break;
            }
        }
        return null;
    }

    public Point3d getGridLineStart(int nAxis, int nFace, double d) {
        switch (nAxis) {
            case 1: {
                switch (nFace) {
                    case 0: {
                        return new Point3d(this.m_vertices[0].x, d, this.m_vertices[0].z);
                    }
                    case 1: {
                        return new Point3d(this.m_vertices[1].x, d, this.m_vertices[1].z);
                    }
                    case 2: {
                        return new Point3d(this.m_vertices[2].x, d, this.m_vertices[2].z);
                    }
                    case 3: {
                        return new Point3d(this.m_vertices[3].x, d, this.m_vertices[3].z);
                    }
                    case 4: {
                        return new Point3d(this.m_vertices[4].x, d, this.m_vertices[4].z);
                    }
                    case 5: {
                        return new Point3d(this.m_vertices[5].x, d, this.m_vertices[5].z);
                    }
                    case 6: {
                        return new Point3d(this.m_vertices[6].x, d, this.m_vertices[6].z);
                    }
                    case 7: {
                        return new Point3d(this.m_vertices[7].x, d, this.m_vertices[7].z);
                    }
                }
                break;
            }
        }
        return null;
    }

    public int getNumPtsPerFace(int f) {
        if (f == 8 || f == 9) {
            return 8;
        }
        return 4;
    }
}

