/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.MathExt;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.model3d.Model3DFlatFace;
import oracle.dss.graph.pfj.model3d.Point3d;

public class Model3DRibbonGroupSolid
extends Model3DFlatFace {
    public static final int FRONT = 0;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int BACK = 3;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 5;
    public static final int BEVEL = 6;
    protected Point3d m_origin;
    protected Point3d m_size;
    protected Point3d[] m_points;
    private static int[][] m_myfaces = new int[][]{{0, 1, 3, 2}, {0, 2, 8, 6, 4}, {2, 3, 9, 8}, {6, 8, 9, 7}, {1, 5, 7, 9, 3}, {0, 4, 5, 1}, {4, 6, 7, 5}};

    public Model3DRibbonGroupSolid(JChart_3D chart, IdentObj id, BlackBoxIF bb, Point3d origin, Point3d size, Point3d[] points, boolean[][] bGridStatus, boolean bAutoshading) {
        super(chart, id, bb, 7, 10, bGridStatus, bAutoshading);
        this.m_origin = new Point3d(origin);
        this.m_size = new Point3d(size);
        this.m_points = points;
        this.m_faces = m_myfaces;
        int i = 0;
        while (i < this.m_nVertices) {
            this.m_vertices[i] = new Point3d(this.m_points[i]);
            ++i;
        }
    }

    public Model3DRibbonGroupSolid(Model3DRibbonGroupSolid model) {
        this(model.m_chart, model.m_id, model.m_bb, model.m_origin, model.m_size, model.m_points, model.m_bGridStatus, model.m_bAutoshading);
        this.m_distance = model.m_distance;
    }

    protected Point3d getCenter() {
        return new Point3d(this.m_origin.x + this.m_size.x / 2.0, this.m_origin.y, this.m_origin.z + this.m_size.z / 2.0);
    }

    public int getNumPtsPerFace(int f) {
        if (f == 1 || f == 4) {
            return 5;
        }
        return 4;
    }

    protected Point3d getGridLineStart(int nAxis, int nFace, double fGridValue) {
        Point3d pt3DGridLineStart = null;
        block0 : switch (nAxis) {
            case 2: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                switch (nFace) {
                    case 2: {
                        pt3DGridLineStart = this.getGridLineStartAxisYTop(fGridValue);
                        break block0;
                    }
                    case 3: {
                        pt3DGridLineStart = this.getGridLineStartAxisYRight(fGridValue);
                        break block0;
                    }
                    case 4: {
                        pt3DGridLineStart = this.getGridLineStartAxisYFront(fGridValue);
                        break block0;
                    }
                }
                break;
            }
        }
        return pt3DGridLineStart;
    }

    protected Point3d getGridLineEnd(int nAxis, int nFace, double fGridValue) {
        Point3d pt3DGridLineEnd = null;
        block0 : switch (nAxis) {
            case 2: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                switch (nFace) {
                    case 2: {
                        pt3DGridLineEnd = this.getGridLineEndAxisYTop(fGridValue);
                        break block0;
                    }
                    case 3: {
                        pt3DGridLineEnd = this.getGridLineEndAxisYRight(fGridValue);
                        break block0;
                    }
                    case 4: {
                        pt3DGridLineEnd = this.getGridLineEndAxisYFront(fGridValue);
                        break block0;
                    }
                }
                break;
            }
        }
        return pt3DGridLineEnd;
    }

    protected Point3d getGridLineStartAxisYTop(double fGridValue) {
        double fBotLeftX = this.m_vertices[9].x;
        double fBotLeftY = this.m_vertices[9].y;
        double fBotLeftZ = this.m_vertices[9].z;
        double fBotRightX = this.m_vertices[8].x;
        double fBotRightY = this.m_vertices[8].y;
        double fBotRightZ = this.m_vertices[8].z;
        double fTopRightX = this.m_vertices[2].x;
        double fTopRightY = this.m_vertices[2].y;
        double fTopRightZ = this.m_vertices[2].z;
        Point3d pt3DGridLineStart = null;
        if (fGridValue > fBotLeftY && fGridValue < fTopRightY) {
            double fXIntercept = MathExt.getIntercept(fBotLeftX, fBotLeftY, fTopRightX, fTopRightY, fGridValue);
            pt3DGridLineStart = new Point3d(fXIntercept, fGridValue, fBotLeftZ);
        } else if (fGridValue > fBotLeftY) {
            pt3DGridLineStart = new Point3d(fBotLeftX, fGridValue, fBotLeftZ);
        } else {
            double fXIntercept = MathExt.getIntercept(fBotLeftX, fBotLeftY, fTopRightX, fTopRightY, fGridValue);
            pt3DGridLineStart = new Point3d(fXIntercept, fGridValue, fBotLeftZ);
        }
        return pt3DGridLineStart;
    }

    protected Point3d getGridLineEndAxisYTop(double fGridValue) {
        Point3d pt3DGridLineEnd = null;
        double fBotLeftX = this.m_vertices[9].x;
        double fBotLeftY = this.m_vertices[9].y;
        double fBotLeftZ = this.m_vertices[9].z;
        double fBotRightX = this.m_vertices[8].x;
        double fBotRightY = this.m_vertices[8].y;
        double fBotRightZ = this.m_vertices[8].z;
        double fTopRightX = this.m_vertices[2].x;
        double fTopRightY = this.m_vertices[2].y;
        double fTopRightZ = this.m_vertices[2].z;
        if (fGridValue > fBotRightY && fGridValue < fTopRightY) {
            double fXIntercept = MathExt.getIntercept(fBotRightX, fBotRightY, fTopRightX, fTopRightY, fGridValue);
            pt3DGridLineEnd = new Point3d(fXIntercept, fGridValue, fBotRightZ);
        } else if (fGridValue < fBotLeftY && fGridValue > fTopRightY) {
            double fXIntercept = MathExt.getIntercept(fBotLeftX, fBotLeftY, fTopRightX, fTopRightY, fGridValue);
            pt3DGridLineEnd = new Point3d(fXIntercept, fGridValue, fBotRightZ);
        }
        return pt3DGridLineEnd;
    }

    protected Point3d getGridLineStartAxisYRight(double fGridValue) {
        double fBotLeftX = this.m_vertices[7].x;
        double fBotLeftY = this.m_vertices[7].y;
        double fBotLeftZ = this.m_vertices[7].z;
        double fTopRightX = this.m_vertices[8].x;
        double fTopRightY = this.m_vertices[8].y;
        Point3d pt3DGridLineStart = null;
        if (fGridValue > fBotLeftY && fGridValue < fTopRightY) {
            pt3DGridLineStart = new Point3d(fBotLeftX, fGridValue, fBotLeftZ);
        }
        return pt3DGridLineStart;
    }

    protected Point3d getGridLineEndAxisYRight(double fGridValue) {
        Point3d pt3DGridLineEnd = null;
        double fBotRightX = this.m_vertices[6].x;
        double fBotRightZ = this.m_vertices[6].z;
        pt3DGridLineEnd = new Point3d(fBotRightX, fGridValue, fBotRightZ);
        return pt3DGridLineEnd;
    }

    protected Point3d getGridLineStartAxisYFront(double fGridValue) {
        Point3d pt3DGridLineStart = null;
        double fBotLeftX = this.m_vertices[1].x;
        double fBotLeftY = this.m_vertices[1].y;
        double fBotLeftZ = this.m_vertices[1].z;
        double fTopLeftX = this.m_vertices[3].x;
        double fTopLeftY = this.m_vertices[3].y;
        double fTopLeftZ = this.m_vertices[3].z;
        double fBotRightX = this.m_vertices[7].x;
        double fBotRightY = this.m_vertices[7].y;
        double fBotRightZ = this.m_vertices[7].z;
        double fTopRightX = this.m_vertices[9].x;
        double fTopRightY = this.m_vertices[9].y;
        double fTopRightZ = this.m_vertices[9].z;
        double fBotLeftFlrX = this.m_vertices[5].x;
        double fBotLeftFlrY = this.m_vertices[5].y;
        if (fGridValue > fBotLeftY && fGridValue < fTopLeftY && fGridValue > fBotLeftFlrY) {
            double fXIntercept = MathExt.getIntercept(fBotLeftX, fBotLeftY, fTopLeftX, fTopLeftY, fGridValue);
            pt3DGridLineStart = new Point3d(fXIntercept, fGridValue, fBotLeftZ);
        } else if (fGridValue > fBotRightY && fGridValue < fBotLeftY) {
            double fXIntercept = MathExt.getIntercept(fBotLeftX, fBotLeftY, fBotLeftFlrX, fBotLeftFlrY, fGridValue);
            pt3DGridLineStart = new Point3d(fXIntercept, fGridValue, fBotLeftZ);
        } else if (fGridValue > fTopLeftY && fGridValue < fTopRightY) {
            double fXIntercept = MathExt.getIntercept(fTopLeftX, fTopLeftY, fTopRightX, fTopRightY, fGridValue);
            pt3DGridLineStart = new Point3d(fXIntercept, fGridValue, fBotLeftZ);
        } else {
            pt3DGridLineStart = new Point3d(fBotLeftX, fGridValue, fBotLeftZ);
        }
        return pt3DGridLineStart;
    }

    protected Point3d getGridLineEndAxisYFront(double fGridValue) {
        Point3d pt3DGridLineEnd = null;
        double fBotRightX = this.m_vertices[7].x;
        double fBotRightY = this.m_vertices[7].y;
        double fBotRightZ = this.m_vertices[7].z;
        double fBotLeftFlrX = this.m_vertices[5].x;
        double fBotLeftFlrY = this.m_vertices[5].y;
        double fTopRightX = this.m_vertices[9].x;
        double fTopRightY = this.m_vertices[9].y;
        double fTopRightZ = this.m_vertices[9].z;
        double fTopLeftX = this.m_vertices[3].x;
        double fTopLeftY = this.m_vertices[3].y;
        double fTopLeftZ = this.m_vertices[3].z;
        double fBotLeftX = this.m_vertices[1].x;
        double fBotLeftY = this.m_vertices[1].y;
        double fBotLeftZ = this.m_vertices[1].z;
        if (fGridValue < fTopLeftY && fGridValue > fTopRightY) {
            double fXIntercept = MathExt.getIntercept(fTopLeftX, fTopLeftY, fTopRightX, fTopRightY, fGridValue);
            pt3DGridLineEnd = new Point3d(fXIntercept, fGridValue, fBotLeftZ);
        } else if (fGridValue > fBotLeftY && fGridValue > fBotRightY && fGridValue < fTopRightY) {
            pt3DGridLineEnd = new Point3d(fBotRightX, fGridValue, fBotRightZ);
        } else if (fGridValue > fBotLeftY && fGridValue < fBotRightY && fGridValue < fTopRightY && fGridValue < fBotLeftFlrY) {
            double fXIntercept = MathExt.getIntercept(fBotLeftX, fBotLeftY, fBotRightX, fBotRightY, fGridValue);
            pt3DGridLineEnd = new Point3d(fXIntercept, fGridValue, fBotLeftZ);
        } else if (fGridValue > fBotLeftY && fGridValue < fBotRightY && fGridValue < fTopRightY) {
            double fXIntercept = MathExt.getIntercept(fBotLeftFlrX, fBotLeftFlrY, fBotRightX, fBotRightY, fGridValue);
            pt3DGridLineEnd = new Point3d(fXIntercept, fGridValue, fBotLeftZ);
        } else {
            pt3DGridLineEnd = new Point3d(fBotRightX, fGridValue, fBotRightZ);
        }
        return pt3DGridLineEnd;
    }
}

