/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.png;

import oracle.dss.graph.pfj.png.PNGErrorCodes;

public class PNGException
extends Exception {
    private String errorMessage;
    private int errorCode;
    private Exception nestedException;

    public PNGException(Object source, int errCode, String methodName, String errMsg) {
        this(source, errCode, methodName, errMsg, null);
    }

    public PNGException(Object source, int errCode, String methodName, String errMsg, Exception nested) {
        this.errorCode = errCode;
        this.nestedException = nested;
        String basicError = "Undefined Error Code";
        if (this.errorCode < PNGErrorCodes.PNG_ERROR_STRINGS.length) {
            basicError = PNGErrorCodes.PNG_ERROR_STRINGS[this.errorCode];
        }
        String sourceClass = "Null Source Class";
        if (source != null) {
            sourceClass = source.getClass().getName();
        }
        this.errorMessage = basicError + " * Source: " + sourceClass + " * Method: " + methodName + " * Message: " + errMsg;
        if (this.nestedException != null) {
            String nestedMessage = this.nestedException.getClass().getName() + " * Nested Message: " + this.nestedException.getMessage();
            this.errorMessage = this.errorMessage + " * Nested Exception: " + nestedMessage;
        }
    }

    public String toString() {
        return this.errorMessage;
    }

    public String getMessage() {
        return this.errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Exception getNestedException() {
        return this.nestedException;
    }
}

