/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.FormatModel;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.GridViewDatabodyStyleManager;
import oracle.dss.gridView.GridViewFormatManager;
import oracle.dss.gridView.GridViewHeaderStyleManager;
import oracle.dss.gridView.UIFormat;
import oracle.dss.rules.DiscriminatorRule;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.Rule;
import oracle.dss.rules.RuleBundle;
import oracle.dss.rules.discriminator.CompositeDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.NumberValueDiscriminator;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;

public class ASFormatModel
extends FormatModel {
    List m_headerBaseState;
    List m_headerCheckpointState;
    List m_dataBaseState;
    List m_dataCheckpointState;
    List m_stoplightBaseState;
    List m_stoplightCheckpointState;
    public static final String s_ASFormatModel = "AS";
    private ArrayList m_stoplightFormats;
    private ArrayList m_dataFormats;
    private ArrayList m_headerFormats;
    private ArrayList m_dataToolbarFormats;
    private ArrayList m_headerToolbarFormats;
    private boolean _isDirty;

    public ASFormatModel(GridViewCommon gridView) {
        super(gridView);
        this.$init$();
    }

    protected void initFormats(GridViewCommon gridView) {
        this.clearAll();
        Vector allFormats = gridView.getUIFormats();
        if (allFormats == null) {
            return;
        }
        GridViewDatabodyStyleManager databodyStyleManager = gridView.getGridViewDatabodyStyleManager();
        GridViewHeaderStyleManager headerStyleManager = gridView.getGridViewHeaderStyleManager();
        GridViewFormatManager formatManager = gridView.getGridViewFormatManager();
        RuleBundle databodyStyleBundle = databodyStyleManager != null ? databodyStyleManager.getUIBundle() : null;
        RuleBundle headerStyleBundle = headerStyleManager != null ? headerStyleManager.getUIBundle() : null;
        RuleBundle formatBundle = formatManager != null ? formatManager.getUIBundle() : null;
        int i = 0;
        while (i < allFormats.size()) {
            UIFormat uiFormat = (UIFormat)allFormats.elementAt(i);
            if (uiFormat.getFormatType() != 1) {
                long id = uiFormat.getID();
                if (uiFormat.getDiscriminator() != null || !uiFormat.isSelected()) {
                    switch (uiFormat.getGroup()) {
                        case 1: {
                            this.m_headerToolbarFormats.add(uiFormat);
                            break;
                        }
                        case 3: {
                            this.m_headerFormats.add(uiFormat);
                            break;
                        }
                        case 2: {
                            this.m_dataToolbarFormats.add(uiFormat);
                            break;
                        }
                        case 4: {
                            this.m_dataFormats.add(uiFormat);
                            break;
                        }
                        case 5: {
                            this.m_stoplightFormats.add(uiFormat);
                            break;
                        }
                    }
                } else {
                    block7 : switch (uiFormat.getMergeableType()) {
                        case 0: {
                            if (uiFormat.getGroup() == 1) {
                                this.addViewStyle(this.m_headerToolbarFormats, headerStyleBundle, uiFormat);
                                break;
                            }
                            this.addViewStyle(this.m_headerFormats, headerStyleBundle, uiFormat);
                            break;
                        }
                        case 1: {
                            switch (uiFormat.getGroup()) {
                                case 5: {
                                    this.addStoplight(this.m_stoplightFormats, databodyStyleBundle, uiFormat);
                                    break block7;
                                }
                                case 2: {
                                    this.addViewStyle(this.m_dataToolbarFormats, databodyStyleBundle, uiFormat);
                                    break block7;
                                }
                            }
                            this.addViewStyle(this.m_dataFormats, databodyStyleBundle, uiFormat);
                            break;
                        }
                        case 2: {
                            if (uiFormat.getGroup() == 2) {
                                this.addViewFormat(this.m_dataToolbarFormats, formatBundle, uiFormat);
                                break;
                            }
                            this.addViewFormat(this.m_dataFormats, formatBundle, uiFormat);
                            break;
                        }
                        case 3: {
                            boolean hasAdded = false;
                            if (databodyStyleBundle != null) {
                                hasAdded = uiFormat.getGroup() == 2 ? this.addViewStyle(this.m_dataToolbarFormats, databodyStyleBundle, uiFormat) : this.addViewStyle(this.m_dataFormats, databodyStyleBundle, uiFormat);
                            }
                            if (formatBundle == null) break;
                            if (hasAdded) {
                                int count = formatBundle.getCount();
                                int j = 0;
                                while (j < count) {
                                    if (formatBundle.getRule(j).getID() == id) {
                                        DiscriminatorRule styleRule = (DiscriminatorRule)formatBundle.getRule(j);
                                        uiFormat.setViewFormat((ViewFormat)styleRule.getFixedMergeable());
                                        break block7;
                                    }
                                    ++j;
                                }
                                break;
                            }
                            if (uiFormat.getGroup() == 2) {
                                this.addViewFormat(this.m_dataToolbarFormats, formatBundle, uiFormat);
                                break;
                            }
                            this.addViewFormat(this.m_dataFormats, formatBundle, uiFormat);
                            break;
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void setUIFormats(boolean doApply) {
        this.initFormats(this.getGridView());
        if (doApply) {
            this.setDirty(true);
            this.apply();
        }
    }

    public void clearAllFormats() {
        if (this.m_dataToolbarFormats == null) {
            this.m_dataToolbarFormats = new ArrayList();
        } else {
            this.m_dataToolbarFormats.clear();
        }
        if (this.m_headerToolbarFormats == null) {
            this.m_headerToolbarFormats = new ArrayList();
        } else {
            this.m_headerToolbarFormats.clear();
        }
        this.deSelectFormats(this.m_stoplightFormats);
        this.deSelectFormats(this.m_dataFormats);
        this.deSelectFormats(this.m_headerFormats);
        this.setDirty(true);
        this.apply();
    }

    private void deSelectFormats(List list) {
        UIFormat format = null;
        int i = 0;
        while (i < list.size()) {
            format = (UIFormat)list.get(i);
            format.setSelected(false);
            ++i;
        }
    }

    private void clearAll() {
        if (this.m_stoplightFormats == null) {
            this.m_stoplightFormats = new ArrayList();
        } else {
            this.m_stoplightFormats.clear();
        }
        if (this.m_dataFormats == null) {
            this.m_dataFormats = new ArrayList();
        } else {
            this.m_dataFormats.clear();
        }
        if (this.m_headerFormats == null) {
            this.m_headerFormats = new ArrayList();
        } else {
            this.m_headerFormats.clear();
        }
        if (this.m_dataToolbarFormats == null) {
            this.m_dataToolbarFormats = new ArrayList();
        } else {
            this.m_dataToolbarFormats.clear();
        }
        if (this.m_headerToolbarFormats == null) {
            this.m_headerToolbarFormats = new ArrayList();
        } else {
            this.m_headerToolbarFormats.clear();
        }
        this.setDirty(false);
    }

    public void dataChanged() {
        super.dataChanged();
        this.clearMetadataLabels(this.m_headerFormats);
        this.clearMetadataLabels(this.m_dataToolbarFormats);
        this.clearMetadataLabels(this.m_dataFormats);
        this.clearMetadataLabels(this.m_stoplightFormats);
    }

    public List getFormatList(int formatType) {
        ArrayList list;
        switch (formatType) {
            case 16: {
                list = this.m_stoplightFormats;
                break;
            }
            case 8: {
                list = this.m_dataFormats;
                break;
            }
            case 2: {
                list = this.m_headerFormats;
                break;
            }
            case 1: {
                list = this.m_headerToolbarFormats;
                break;
            }
            case 4: {
                list = this.m_dataToolbarFormats;
                break;
            }
            case 28: {
                list = new ArrayList(this.m_stoplightFormats);
                list.addAll(this.m_dataFormats);
                list.addAll(this.m_dataToolbarFormats);
                break;
            }
            case 3: {
                list = new ArrayList(this.m_headerFormats);
                list.addAll(this.m_headerToolbarFormats);
                break;
            }
            default: {
                list = new ArrayList(this.m_stoplightFormats);
                list.addAll(this.m_dataFormats);
                list.addAll(this.m_dataToolbarFormats);
                list.addAll(this.m_headerFormats);
                list.addAll(this.m_headerToolbarFormats);
                break;
            }
        }
        return list;
    }

    public List getFormatListByGroup(int group) {
        ArrayList list;
        switch (group) {
            case 5: {
                list = this.m_stoplightFormats;
                break;
            }
            case 4: {
                list = this.m_dataFormats;
                break;
            }
            case 3: {
                list = this.m_headerFormats;
                break;
            }
            case 2: {
                list = this.m_dataToolbarFormats;
                break;
            }
            case 1: {
                list = this.m_headerToolbarFormats;
                break;
            }
            default: {
                list = new ArrayList(this.m_stoplightFormats);
                list.addAll(this.m_dataFormats);
                list.addAll(this.m_dataToolbarFormats);
                list.addAll(this.m_headerFormats);
                list.addAll(this.m_headerToolbarFormats);
                break;
            }
        }
        return list;
    }

    public void setFormat(List list, int index, UIFormat format) {
        this.RangeCheck(list, index);
        UIFormat old = (UIFormat)list.get(index);
        if (old.getID() != format.getID() || old.equals(format)) {
            return;
        }
        list.set(index, format);
        this.setDirty(true);
    }

    public void addFormat(List list, UIFormat format) {
        list.add(format);
        this.setDirty(true);
    }

    public void addFormat(UIFormat format) {
        List list = this.getFormatListByGroup(format.getGroup());
        this.addFormat(list, format);
    }

    public UIFormat getLastFormat(int formatType) {
        List formatList = this.getFormatList(formatType);
        int count = formatList.size();
        if (count > 0) {
            return (UIFormat)formatList.get(count - 1);
        }
        return null;
    }

    public void applyFormat(UIFormat format) {
        if (format != null) {
            List list = this.getFormatListByGroup(format.getGroup());
            this.addFormat(list, format);
        } else {
            this.setDirty(true);
        }
        this.apply();
    }

    public void removeFormat(List list, int index) {
        this.RangeCheck(list, index);
        list.remove(index);
        this.setDirty(true);
    }

    public boolean hasPrevious(List list, int index, boolean skipToolbarSelection) {
        this.RangeCheck(list, index);
        return index < list.size() - 1;
    }

    public boolean hasNext(List list, int index, boolean skipToolbarSelection) {
        this.RangeCheck(list, index);
        return index > 0;
    }

    public void moveUp(List list, int index, boolean skipToolbarSelection) {
        if (this.hasPrevious(list, index, skipToolbarSelection)) {
            Object obj = list.get(index);
            list.set(index, list.get(index + 1));
            list.set(index + 1, obj);
            this.setDirty(true);
        }
    }

    public void moveDown(List list, int index, boolean skipToolbarSelection) {
        if (this.hasNext(list, index, skipToolbarSelection)) {
            Object obj = list.get(index);
            list.set(index, list.get(index - 1));
            list.set(index - 1, obj);
            this.setDirty(true);
        }
    }

    public boolean apply() {
        GridViewDatabodyStyleManager databodyStyleManager = this.m_gridView.getGridViewDatabodyStyleManager();
        GridViewHeaderStyleManager headerStyleManager = this.m_gridView.getGridViewHeaderStyleManager();
        GridViewFormatManager formatManager = this.m_gridView.getGridViewFormatManager();
        RuleBundle databodyRules = new RuleBundle();
        RuleBundle headerRules = new RuleBundle();
        RuleBundle formatRules = new RuleBundle();
        Vector allFormats = new Vector(this.m_headerToolbarFormats);
        allFormats.addAll(this.m_headerFormats);
        allFormats.addAll(this.m_dataToolbarFormats);
        allFormats.addAll(this.m_dataFormats);
        allFormats.addAll(this.m_stoplightFormats);
        int i = 0;
        while (i < allFormats.size()) {
            UIFormat uiFormat = (UIFormat)allFormats.elementAt(i);
            uiFormat.setDirty(false);
            boolean selected = uiFormat.isSelected();
            int group = uiFormat.getGroup();
            ViewStyle viewStyle = null;
            ViewFormat viewFormat = null;
            DiscriminatorRule rule = null;
            if (group == 5) {
                if (selected) {
                    this.addStoplightRules(databodyRules, uiFormat);
                }
            } else if (group == 2 || group == 4) {
                viewStyle = uiFormat.getViewStyle();
                viewFormat = uiFormat.getViewFormat();
                if (viewStyle != null || viewFormat != null) {
                    if (viewStyle != null && viewStyle.isAnythingOverridden()) {
                        rule = new DiscriminatorRule(uiFormat.getDiscriminator(), (Mergeable)viewStyle);
                        rule.setID(uiFormat.getID());
                        if (selected) {
                            databodyRules.addRule((Rule)rule);
                        }
                    }
                    if (viewFormat != null && viewFormat.isAnythingOverridden()) {
                        rule = new DiscriminatorRule(uiFormat.getDiscriminator(), (Mergeable)viewFormat);
                        rule.setID(uiFormat.getID());
                        if (selected) {
                            formatRules.addRule((Rule)rule);
                        }
                        uiFormat.setMergeableType(3);
                    }
                    if (selected && uiFormat.isNegativeRed()) {
                        NumberValueDiscriminator numberValueDiscriminator = new NumberValueDiscriminator(0.0, 1);
                        CompositeDiscriminator compositeDiscriminator = new CompositeDiscriminator((Discriminator)numberValueDiscriminator, uiFormat.getDiscriminator(), 0);
                        viewStyle = new ViewStyle();
                        viewStyle.setForeground(Color.red);
                        DiscriminatorRule discriminatorRule = new DiscriminatorRule((Discriminator)compositeDiscriminator, (Mergeable)viewStyle);
                        databodyRules.addRule((Rule)discriminatorRule);
                    }
                }
            } else {
                viewStyle = uiFormat.getViewStyle();
                rule = new DiscriminatorRule(uiFormat.getDiscriminator(), (Mergeable)viewStyle);
                rule.setID(uiFormat.getID());
                if (selected) {
                    headerRules.addRule((Rule)rule);
                }
            }
            ++i;
        }
        if (allFormats.size() == 0) {
            this.m_gridView.setUIFormats(null);
        } else {
            this.m_gridView.setUIFormats(allFormats);
        }
        if (databodyStyleManager != null) {
            if (databodyRules.getCount() > 0) {
                databodyStyleManager.setUIBundle(this.m_gridView, databodyRules);
            } else {
                databodyStyleManager.setUIBundle(this.m_gridView, null);
            }
        }
        if (headerStyleManager != null) {
            if (headerRules.getCount() > 0) {
                headerStyleManager.setUIBundle(this.m_gridView, headerRules);
            } else {
                headerStyleManager.setUIBundle(this.m_gridView, null);
            }
        }
        if (formatManager != null) {
            if (formatRules.getCount() > 0) {
                formatManager.setUIBundle(this.m_gridView, formatRules);
            } else {
                formatManager.setUIBundle(this.m_gridView, null);
            }
        }
        this.setDirty(false);
        return true;
    }

    private boolean isDataExceptionFormat(List list, int index) {
        if (index >= 0 && index < list.size()) {
            UIFormat format = (UIFormat)list.get(index);
            return this.isDataExceptionFormat(format);
        }
        return false;
    }

    private boolean isDataExceptionFormat(UIFormat format) {
        return format.getGroup() == 4;
    }

    private boolean isStoplightFormat(List list, int index) {
        UIFormat format = (UIFormat)list.get(index);
        return format.getGroup() == 5;
    }

    private void RangeCheck(List list, int index) {
        if (index >= list.size() || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + list.size());
        }
    }

    public void establishBaseState() {
        this.m_headerBaseState = UIFormat.deepCloneFormats(this.m_headerFormats);
        this.m_dataBaseState = UIFormat.deepCloneFormats(this.m_dataFormats);
        this.m_stoplightBaseState = UIFormat.deepCloneFormats(this.m_stoplightFormats);
    }

    public void establishCheckpointState() {
        this.m_headerCheckpointState = UIFormat.deepCloneFormats(this.m_headerFormats);
        this.m_dataCheckpointState = UIFormat.deepCloneFormats(this.m_dataFormats);
        this.m_stoplightCheckpointState = UIFormat.deepCloneFormats(this.m_stoplightFormats);
    }

    public void setStateAsObjectNode(List memberContext, ObjectNode node, boolean isCheckpoint) {
        ContainerNode formatsNode;
        Object pNode = null;
        ContainerNode containerNode = formatsNode = node == null ? null : node.getContainer(s_ASFormatModel);
        if (formatsNode == null) {
            this.setUIFormats(true);
        } else {
            ArrayList stoplightFormats = new ArrayList(this.m_stoplightFormats);
            this.m_stoplightFormats.clear();
            if (isCheckpoint) {
                this.m_stoplightFormats.addAll(this.m_stoplightCheckpointState);
            } else {
                this.m_stoplightFormats.addAll(this.m_stoplightBaseState);
            }
            ArrayList dataFormats = new ArrayList(this.m_dataFormats);
            this.m_dataFormats.clear();
            if (isCheckpoint) {
                this.m_dataFormats.addAll(this.m_dataCheckpointState);
            } else {
                this.m_dataFormats.addAll(this.m_dataBaseState);
            }
            ArrayList headerFormats = new ArrayList(this.m_headerFormats);
            this.m_headerFormats.clear();
            if (isCheckpoint) {
                this.m_headerFormats.addAll(this.m_headerCheckpointState);
            } else {
                this.m_headerFormats.addAll(this.m_headerBaseState);
            }
            Enumeration e = formatsNode.getContainedObject();
            while (e.hasMoreElements()) {
                ObjectNode formatNode = (ObjectNode)e.nextElement();
                String stateName = formatNode.getName();
                if (stateName.equals("S5")) {
                    UIFormat.setFormatState(this.m_localStrings, memberContext, formatNode, this.m_stoplightFormats, stoplightFormats);
                    this.setDirty(true);
                    continue;
                }
                if (stateName.equals("C4")) {
                    UIFormat.setFormatState(this.m_localStrings, memberContext, formatNode, this.m_dataFormats, dataFormats);
                    this.setDirty(true);
                    continue;
                }
                if (!stateName.equals("H3")) continue;
                UIFormat.setFormatState(this.m_localStrings, memberContext, formatNode, this.m_headerFormats, headerFormats);
                this.setDirty(true);
            }
        }
    }

    public ContainerNode getStateAsObjectNode(List memberContext, boolean isCheckpoint) {
        ContainerNode formatsNode = new ContainerNode(s_ASFormatModel);
        boolean hasState = false;
        List baseState = isCheckpoint ? this.m_headerCheckpointState : this.m_headerBaseState;
        List sourceList = UIFormat.shallowCloneFormats(baseState);
        if (UIFormat.getFormatListState(this.m_localStrings, memberContext, formatsNode, sourceList, this.m_headerFormats)) {
            hasState = true;
        }
        if (UIFormat.getFormatListState(this.m_localStrings, memberContext, formatsNode, sourceList = UIFormat.shallowCloneFormats(baseState = isCheckpoint ? this.m_dataCheckpointState : this.m_dataBaseState), this.m_dataFormats)) {
            hasState = true;
        }
        if (UIFormat.getFormatListState(this.m_localStrings, memberContext, formatsNode, sourceList = UIFormat.shallowCloneFormats(baseState = isCheckpoint ? this.m_stoplightCheckpointState : this.m_stoplightBaseState), this.m_stoplightFormats)) {
            hasState = true;
        }
        return hasState ? formatsNode : null;
    }

    public void setDirty(boolean flag) {
        this._isDirty = flag;
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    private void $init$() {
        this._isDirty = false;
    }
}

