/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.event.EventListenerList;
import oracle.bali.share.nls.LocaleUtils;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.EdgeComponentHandle;
import oracle.dss.dataView.ExportableGraph;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.CSSStyle;
import oracle.dss.gridView.ExportProgressEvent;
import oracle.dss.gridView.ExportProgressListener;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.GridViewDatabodyStyleManager;
import oracle.dss.gridView.GridViewExcelHTMLExportProvider;
import oracle.dss.gridView.GridViewFormatManager;
import oracle.dss.gridView.GridViewHeaderStyleManager;
import oracle.dss.gridView.GridViewUtils;
import oracle.dss.gridView.Storage;
import oracle.dss.gridView.StorageCallback;
import oracle.dss.gridView.StorageGroup;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.FormattedText;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.WaitData;

public abstract class GridViewExcelHTMLExport {
    public static final int RANGE_ALL = 0;
    public static final int RANGE_CURRENT = 1;
    public static final int RANGE_LIST = 2;
    public static final int PAGES_SINGLE = 1;
    public static final int PAGES_ALL = 0;
    public static final int OUTPUT_FILE_SYSTEM = 1;
    public static final int OUTPUT_ZIP_FILE = 2;
    public static final int OUTPUT_STORAGE_CALLBACK = 3;
    public static final int GRIDVIEW_ONLY = 3;
    public static final int GRAPH_ONLY = 4;
    public static final int ALL_VIEWS = 255;
    public static final String DEPENDENT_EXPORT_INDEX = "D_E_I";
    protected static final int COL_FETCH_BLOCK = 20;
    private EventListenerList m_listenerList;
    protected GridViewCommon m_gridView;
    protected ErrorHandler m_eh;
    private Locale m_locale;
    private boolean m_bCanceled;
    private int m_pagesPerSheet;
    private int m_exportPageRange;
    private List m_exportPageList;
    private String m_path;
    private String m_fileName;
    private PrintWriter m_printWriter;
    private String m_characterEncoding;
    private String m_baseURI;
    private int m_outputMode;
    private int m_tempFileOutputMode;
    private OutputStream m_outputStream;
    private GridViewExcelHTMLExportProvider[] m_dependentExports;
    private GridViewExcelHTMLExport m_currentDependentExport;
    private int m_viewIndex;
    private String[] m_worksheetLabels;
    private int m_viewTypeExported;
    private int m_oldViewTypeExported;
    private ExportableGraph m_exportableGraph;
    private boolean m_bViewsLinked;
    protected GridViewFormatManager m_formatMgr;
    protected GridViewDatabodyStyleManager m_databodyStyleMgr;
    protected GridViewHeaderStyleManager m_headerStyleMgr;
    private ViewStyle m_clearDatabodyViewStyle;
    private ViewStyle m_clearColHeaderViewStyle;
    private ViewStyle m_clearRowHeaderViewStyle;
    private ViewStyle m_clearPagingControlViewStyle;
    private ViewStyle m_clearGraphPagingControlViewStyle;
    private ResourceBundle m_resourceBundle;
    private StorageCallback m_storageCallback;
    protected HashMap m_viewStyleMap;
    protected ArrayList m_styleList;
    private HashMap m_colorHashMap;
    private int[] m_colorPalette;
    private boolean[] m_paletteIndexUsed;
    private static int[] m_paletteIndexes = new int[]{1, 53, 52, 51, 49, 11, 55, 56, 9, 46, 12, 10, 14, 5, 47, 16, 3, 45, 43, 50, 42, 41, 13, 48, 7, 44, 6, 4, 8, 33, 54, 15, 38, 40, 36, 35, 34, 37, 39, 2, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32};
    private static int[] DEFAULT_PALETTE = new int[]{0, 0xFFFFFF, 0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535, 0x800000, 32768, 128, 0x808000, 0x800080, 32896, 0xC0C0C0, 0x808080, 0x9999FF, 0x993366, 0xFFFFCC, 0xCCFFFF, 0x660066, 0xFF8080, 26316, 0xCCCCFF, 128, 0xFF00FF, 0xFFFF00, 65535, 0x800080, 0x800000, 32896, 255, 52479, 0xCCFFFF, 0xCCFFCC, 0xFFFF99, 0x99CCFF, 0xFF99CC, 0xCC99FF, 0xFFCC99, 0x3366FF, 0x33CCCC, 0x99CC00, 0xFFCC00, 0xFF9900, 0xFF6600, 0x666699, 0x969696, 13158, 0x339966, 13056, 0x333300, 0x993300, 0x993366, 0x333399, 0x333333};
    protected static final String DATABODY_STYLE_CLASS = "bibdb";
    protected static final String COLUMN_HEADER_STYLE_CLASS = "bibch";
    protected static final String ROW_HEADER_STYLE_CLASS = "bibrh";
    protected static final String PAGE_HEADER_STYLE_CLASS = "bibph";
    protected static final String TITLE_STYLE_CLASS = "bibts";
    protected static final String SUBTITLE_STYLE_CLASS = "bibss";
    protected static final String FOOTNOTE_STYLE_CLASS = "bibfs";
    protected static final String GRAPH_PAGE_HEADER_STYLE_CLASS = "bibgph";
    protected static final String GRAPH_TITLE_STYLE_CLASS = "bibgts";
    protected static final String GRAPH_SUBTITLE_STYLE_CLASS = "bibgss";
    protected static final String GRAPH_FOOTNOTE_STYLE_CLASS = "bibgfs";
    public static final int FT_TOP = 0;
    public static final int FT_BOTTOM = 1;
    public static final int GRAPHPOS_ABOVE = 0;
    public static final int GRAPHPOS_BELOW = 1;
    private static Hashtable m_dirExt = new Hashtable();
    private static final int m_maxCellLength = Short.MAX_VALUE;
    private static final int m_maxRows = 65536;
    private static final int m_maxColumns = 256;
    private static final int m_maxStyles = 4000;
    private static final int m_maxSheets = 999;
    private static final int m_maxColorPaletteSize = 56;
    private static final double m_defColWidth = 48.0;
    private static final double m_defRowHeight = 13.0;
    private int[] m_pageHPos;
    private int m_pageSlice;
    private int m_exportPage;
    private int m_totalExportPages;
    private int m_rowsOnSheet;
    private int m_currPage;
    private int m_currGraph;
    private String m_OracleHTMLGenerator;
    private String m_mainPath;
    private String m_mainExportName;
    private String m_mainHtmlFile;
    private String m_mainDirExt;
    private String m_mainDirFile;
    private String m_mainDirName;
    private String m_mainTempName;
    private static final String MAIN_TEMP_EXTENSION = "mainTmp";
    private String m_relativeMainFile;
    private String m_relativeDirFile;
    private String m_decSeparator;
    private String m_grpSeparator;
    private Vector m_pages;
    private Vector m_pageTitles;
    private Vector m_pageViewTypes;
    private Vector m_pageDims;
    private boolean m_genTOC;
    private boolean m_combineOutput;
    private String m_currBaseURI;
    private boolean m_bMainJSP;
    private String m_mainURL;
    private StorageGroup m_storageGroup;
    private Storage m_storage;
    private Storage m_tempStorage;
    private Vector m_storages;
    private FormattedText[] m_ft;
    private int m_graphPos;
    private CSSStyle m_databodyCSSStyle;
    private FileOutputStream m_fos;
    private PrintWriter m_prwriter;
    private OutputStream m_ostream;
    private ZipOutputStream m_zipOutputStream;
    private ZipOutputStream m_tempZipOutputStream;
    private ZipInputStream m_tempZipInputStream;
    private String m_mainZipName;
    private boolean m_bTempFile;
    private byte[] m_tempByteArray;
    private ByteArrayOutputStream m_tempByteArrayOutputStream;
    private int m_totalExportRows;
    private int m_currExportRows;
    private static final String INSERT_STYLELIST = "$INSERT_STYLELIST$";
    private static final String INSERT_PALETTE = "$INSERT_PALETTE$";
    private static final char EMPTY_CHAR = '\u0000';
    private static final String m_method__updateResourceBundle = "_updateResourceBundle";
    private static final String m_method_setExportPageRange = "setExportPageRange";
    private static final String m_method_setFileName = "setFileName";
    private static final String m_method_setPagesPerSheet = "setPagesPerSheet";
    private static final String m_method_fetchRowData = "fetchRowData";
    private static final String m_method__zeroFillNumber = "_zeroFillNumber";
    private static final String m_method_term = "term";
    private static final String m_method_doExport = "doExport";
    private static final String m_method_exportPage2 = "exportPage(int, int, int, int)";
    private static final String m_method_exportGridView = "exportGridView";
    private static final String m_method_exportDatabodyRow = "exportDatabodyRow";
    private static final String m_method_exportFT = "exportFT";
    private static final String m_method_handleLabel = "handleLabel";
    private static final String m_method_makeOutputStream = "makeOutputStream";
    private static final String m_method_out = "out";
    protected static final String m_method_exportColumnHeaderRow = "exportColumnHeaderRow";
    protected static final String m_method_exportRowHeaderRow = "exportRowHeaderRow";
    protected static final String FILE_FILELIST = "filelist.xml";
    protected static final String FILE_TABSTRIP = "tabstrip.htm";
    protected static final String FILE_STYLESHEET = "stylesheet.css";
    protected static final String FILE_TOPSHEET = "sheet000.htm";
    public static final String FILE_ENCODING = "export.encoding.file";
    protected static final String SHEET_PREFIX = "sheet";
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GridViewExcelHTMLExport(Locale locale, ErrorHandler eh) {
        this.$init$();
        this.m_gridView = null;
        this.m_eh = eh;
        this.m_listenerList = new EventListenerList();
        this._setLocale(locale);
        Hashtable hashtable = m_dirExt;
        synchronized (hashtable) {
            if (m_dirExt.isEmpty()) {
                GridViewExcelHTMLExport._createDirectoryExtensions(m_dirExt);
            }
        }
        this.m_OracleHTMLGenerator = this.m_resourceBundle.getString("generator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridViewExcelHTMLExport(GridViewCommon gridView) {
        this.$init$();
        this.m_gridView = gridView;
        this.m_eh = this.m_gridView.getErrorHandler();
        this.m_listenerList = new EventListenerList();
        this._setLocale(this.m_gridView.getLocale());
        Hashtable hashtable = m_dirExt;
        synchronized (hashtable) {
            if (m_dirExt.isEmpty()) {
                GridViewExcelHTMLExport._createDirectoryExtensions(m_dirExt);
            }
        }
        this.m_OracleHTMLGenerator = this.m_resourceBundle.getString("generator");
    }

    private void _setLocale(Locale loc) {
        this.m_locale = loc == null ? Locale.getDefault() : loc;
        this._updateResourceBundle(this.m_locale);
    }

    private void _updateResourceBundle(Locale loc) {
        try {
            this.m_resourceBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle");
        }
        catch (MissingResourceException e) {
            this.m_eh.log("missing resource exception", this.getClass().getName(), m_method__updateResourceBundle);
            this.m_resourceBundle = null;
        }
    }

    private static void _createDirectoryExtensions(Hashtable dirExt) {
        dirExt.put("ar", ".files");
        dirExt.put("cs", "_soubory");
        dirExt.put("da", "-filer");
        dirExt.put("de", "-Dateien");
        dirExt.put("el", ".files");
        dirExt.put("en", "_files");
        dirExt.put("es", "_archivos");
        dirExt.put("fi", "_tiedostot");
        dirExt.put("fr", "_fichiers");
        dirExt.put("he", ".files");
        dirExt.put("hu", "_elemei");
        dirExt.put("it", "-file");
        dirExt.put("iw", ".files");
        dirExt.put("ja", ".files");
        dirExt.put("ko", ".files");
        dirExt.put("nl", "_bestanden");
        dirExt.put("no", "-filer");
        dirExt.put("pl", "_pliki");
        dirExt.put("pt", "_ficheiros");
        dirExt.put("pt_BR", "_arquivos");
        dirExt.put("ro", ".files");
        dirExt.put("ru", ".files");
        dirExt.put("sk", ".files");
        dirExt.put("sv", "-filer");
        dirExt.put("th", ".files");
        dirExt.put("tr", "_dosyalar");
        dirExt.put("zh", ".files");
        dirExt.put("eu", "_fitxategiak");
        dirExt.put("bg", ".files");
        dirExt.put("ca", "_fitxers");
        dirExt.put("hr", "_datoteke");
        dirExt.put("et", "_failid");
        dirExt.put("lv", "_fails");
        dirExt.put("lt", "_bylos");
        dirExt.put("sr", ".files");
        dirExt.put("sl", "_datoteke");
        dirExt.put("uk", ".files");
        dirExt.put("vi", ".files");
    }

    private String _getDirectoryExtension(Locale loc) {
        String extension;
        String country;
        String language = null;
        language = loc == null ? Locale.getDefault().getLanguage() : loc.getLanguage();
        String lookup = language;
        if (language.equals("pt") && (country = loc.getCountry()).equals("BR")) {
            lookup = language + "_" + country;
        }
        if ((extension = (String)m_dirExt.get(lookup)) == null) {
            extension = ".files";
        }
        return extension;
    }

    public void export() throws Exception {
        this.doExport();
    }

    public synchronized void cancel() {
        this.m_bCanceled = true;
        if (this.m_currentDependentExport != null) {
            this.m_currentDependentExport.cancel();
        }
    }

    protected boolean isCanceled() {
        return this.m_bCanceled;
    }

    public void addExportProgressListener(ExportProgressListener l) {
        this.m_listenerList.add(ExportProgressListener.class, l);
    }

    public void removeExportProgressListener(ExportProgressListener l) {
        this.m_listenerList.remove(ExportProgressListener.class, l);
    }

    private void _fireExportProgressEvent(int totalPages, int pagesComplete, int percentCurrPageComplete) {
        Object[] listeners = this.m_listenerList.getListenerList();
        if (listeners.length < 1) {
            return;
        }
        ExportProgressEvent e = new ExportProgressEvent(this, totalPages, pagesComplete, percentCurrPageComplete);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ExportProgressListener.class) {
                ExportProgressListener l = (ExportProgressListener)listeners[i + 1];
                l.exportProgress(e);
            }
            i -= 2;
        }
    }

    public void setExportPageRange(int range) {
        if (range != 0 && range != 1 && range != 2) {
            this.m_eh.log("invalid range", this.getClass().getName(), m_method_setExportPageRange);
            return;
        }
        this.m_exportPageRange = range;
    }

    public int getExportPageRange() {
        return this.m_exportPageRange;
    }

    public void setExportPageList(List list) {
        this.m_exportPageList = list;
    }

    public List getExportPageList() {
        return this.m_exportPageList;
    }

    public void setFileName(String name) {
        if (name == null) {
            this.m_eh.log("null file name", this.getClass().getName(), m_method_setFileName);
            return;
        }
        if (name.length() < 1) {
            this.m_eh.log("file name is empty string", this.getClass().getName(), m_method_setFileName);
            return;
        }
        this.m_fileName = name;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public String getPath() {
        return this.m_path;
    }

    public void setPrintWriter(PrintWriter writer) {
        this.m_printWriter = writer;
    }

    public PrintWriter getPrintWriter() {
        return this.m_printWriter;
    }

    public void setPagesPerSheet(int pages) {
        if (pages != 0 && pages != 1) {
            this.m_eh.log("invalid value for PagesPerSheet", this.getClass().getName(), m_method_setPagesPerSheet);
            return;
        }
        this.m_pagesPerSheet = pages;
    }

    public int getPagesPerSheet() {
        return this.m_pagesPerSheet;
    }

    public void setCharacterEncoding(String encoding) {
        this.m_characterEncoding = encoding;
    }

    public String getCharacterEncoding() {
        if (this.m_characterEncoding == null) {
            return DEFAULT_CHARACTER_ENCODING;
        }
        return this.m_characterEncoding;
    }

    public void setBaseURI(String baseURI) {
        this.m_baseURI = baseURI;
    }

    public String getBaseURI() {
        return this.m_baseURI;
    }

    public void setOutputMode(int mode) {
        if (mode != 1 && mode != 2 && mode != 3) {
            this.m_eh.log("invalid value for OutputMode", this.getClass().getName(), "public void setOutputMode(int mode)");
            return;
        }
        this.m_outputMode = mode;
    }

    public int getOutputMode() {
        return this.m_outputMode;
    }

    private int _getOutputMode() {
        if (this.getOutputMode() == 3 && this.getStorageCallback() == null) {
            return 1;
        }
        return this.getOutputMode();
    }

    public void setTempFileOutputMode(int mode) {
        if (mode != 1 && mode != 2 && mode != 3) {
            this.m_eh.log("invalid value for TempFileOutputMode", this.getClass().getName(), "public void setTempFileOutputMode(int mode)");
            return;
        }
        this.m_tempFileOutputMode = mode;
    }

    public int getTempFileOutputMode() {
        return this.m_tempFileOutputMode;
    }

    private int _getTempFileOutputMode() {
        if (this.getTempFileOutputMode() == 3 && this.getStorageCallback() == null) {
            return 1;
        }
        return this.getTempFileOutputMode();
    }

    public void setStorageCallback(StorageCallback callback) {
        this.m_storageCallback = callback;
    }

    public StorageCallback getStorageCallback() {
        return this.m_storageCallback;
    }

    public void setOutputStream(OutputStream os) {
        this.m_outputStream = os;
    }

    public OutputStream getOutputStream() {
        return this.m_outputStream;
    }

    public String getMainURL() {
        return this.m_mainURL;
    }

    public String getSubdirectoryName() {
        return this.m_mainDirName;
    }

    public void setDependentExports(GridViewExcelHTMLExportProvider[] providers) {
        this.m_dependentExports = providers;
    }

    public GridViewExcelHTMLExportProvider[] getDependentExports() {
        return this.m_dependentExports;
    }

    public void setViewTypeExported(int type) {
        this.m_viewTypeExported = type;
    }

    public int getViewTypeExported() {
        return this.m_viewTypeExported;
    }

    public void setWorksheetLabels(String[] labels) {
        this.m_worksheetLabels = labels;
    }

    public String[] getWorksheetLabels() {
        return this.m_worksheetLabels;
    }

    public FormattedText getFormattedText(int ftLocation) {
        return this.m_ft[ftLocation];
    }

    public void setFormattedText(int ftLocation, FormattedText ft) {
        this.m_ft[ftLocation] = ft;
    }

    public int getGraphPositionOnPage() {
        return this.m_graphPos;
    }

    public void setGraphPositionOnPage(int pos) {
        this.m_graphPos = pos;
    }

    protected boolean exportFT(int ftLocation, int cols) {
        boolean exists = false;
        FormattedText ft = this.m_ft[ftLocation];
        String ftText = null;
        if (ft != null) {
            ftText = ft.getParsedHTMLText();
        }
        StringBuffer sb_out = new StringBuffer(512);
        if (ftText != null && sb_out != null) {
            sb_out.append("<table x:str border=0 cellspacing=0 cellpadding=0 width=\"100%\" style='border-collapse:collapse;'>\n");
            sb_out.append("  <tr>\n");
            sb_out.append("    <td");
            sb_out.append(" colspan=");
            sb_out.append(cols);
            sb_out.append(">");
            if (ftText.length() > GridViewExcelHTMLExport.getMaxCellContentLength()) {
                ftText = ftText.substring(0, GridViewExcelHTMLExport.getMaxCellContentLength());
                this.m_eh.log("maximum cell content length exceeded - truncating", this.getClass().getName(), m_method_exportFT);
            }
            sb_out.append(ftText);
            sb_out.append("</td>\n");
            sb_out.append("  </tr>\n");
            sb_out.append("</table>\n");
            this.out(sb_out.toString());
            sb_out = null;
            exists = true;
        }
        return exists;
    }

    public void setExportableGraph(ExportableGraph graph) {
        this.m_exportableGraph = graph;
    }

    public ExportableGraph getExportableGraph() {
        return this.m_exportableGraph;
    }

    public void setViewsLinked(boolean bLinked) {
        this.m_bViewsLinked = bLinked;
    }

    public boolean isViewsLinked() {
        return this.m_bViewsLinked;
    }

    protected boolean isExportingUnlinkedViews() {
        return this.m_gridView != null && (this.m_oldViewTypeExported & 3) != 0 && this.getExportableGraph() != null && (this.m_oldViewTypeExported & 4) != 0 && !this.isViewsLinked() && this.getExportPageRange() == 0;
    }

    protected DataviewCommon getDataviewCommon() {
        if (this.m_gridView != null && (this.getViewTypeExported() & 3) != 0) {
            return this.m_gridView;
        }
        if (this.getExportableGraph() != null && (this.getViewTypeExported() & 4) != 0) {
            return this.getExportableGraph().getDataviewCommon();
        }
        return null;
    }

    protected static int getMaxAllowedStyles() {
        return 4000;
    }

    protected static int getMaxAllowedSheets() {
        return 999;
    }

    protected static int getMaxAllowedColumns() {
        return 256;
    }

    protected static int getMaxAllowedRows() {
        return 65536;
    }

    protected static int getMaxCellContentLength() {
        return Short.MAX_VALUE;
    }

    protected static int getMaxColorPaletteSize() {
        return 56;
    }

    protected int[] getPageHPos(DataAccess dataAccess) throws EdgeOutOfRangeException {
        if (this.m_pageHPos == null) {
            this.m_pageHPos = dataAccess.getEdgeCurrentHPos(2);
        }
        return this.m_pageHPos;
    }

    protected int getPageSlice(DataAccess dataAccess) throws EdgeOutOfRangeException {
        if (this.m_pageSlice == -1) {
            this.m_pageSlice = dataAccess.getEdgeCurrentSlice(2);
        }
        return this.m_pageSlice;
    }

    protected int getTotalExportPages() throws EdgeOutOfRangeException {
        if (this.m_totalExportPages < 0) {
            this.m_totalExportPages = this._calcTotalExportPages();
        }
        return this.m_totalExportPages;
    }

    private int _calcTotalExportPages() throws EdgeOutOfRangeException {
        int pages = 0;
        switch (this.getExportPageRange()) {
            case 0: {
                if (this.isExportingUnlinkedViews()) {
                    DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
                    pages = dataAccess.getEdgeExtent(2);
                    dataAccess = this.getExportableGraph().getDataviewCommon().getModel().getDataAccess();
                    pages += dataAccess.getEdgeExtent(2);
                    break;
                }
                DataAccess dataAccess = this.getDataviewCommon().getModel().getDataAccess();
                pages = dataAccess.getEdgeExtent(2);
                break;
            }
            case 2: {
                List list = this.getExportPageList();
                if (list == null) {
                    pages = 0;
                    break;
                }
                pages = list.size();
                break;
            }
            case 1: {
                if (this.getDependentExports() != null) {
                    pages = 1 + this.getDependentExports().length;
                    break;
                }
                pages = 1;
                break;
            }
            default: {
                pages = 1;
                break;
            }
        }
        return pages;
    }

    private int _calcTotalExportSheets() throws EdgeOutOfRangeException {
        if (this.getPagesPerSheet() == 0) {
            return 1;
        }
        int totalSheets = this.getTotalExportPages();
        if (this.m_genTOC) {
            ++totalSheets;
        }
        return totalSheets;
    }

    private int _calcTotalExportPageSheets() throws EdgeOutOfRangeException {
        if (this.getPagesPerSheet() == 0) {
            return 1;
        }
        int totalSheets = this.getTotalExportPages();
        return totalSheets;
    }

    private Number _calcOutputValueForPercents(Number data) {
        if (data != null && data instanceof Number) {
            if (data instanceof Integer) {
                int num = (Integer)data / 100;
                data = new Integer(num);
            } else if (data instanceof Short) {
                short num = (short)((Short)data / 100);
                data = new Short(num);
            } else if (data instanceof Long) {
                long num = (Long)data / (long)100;
                data = new Long(num);
            } else if (data instanceof Double) {
                double num = (Double)data / 100.0;
                data = new Double(num);
            } else if (data instanceof Float) {
                float num = ((Float)data).floatValue() / 100.0f;
                data = new Float(num);
            }
        }
        return data;
    }

    protected int fetchRowData(DataAccess dataAccess, int row, int firstCol, int lastCol) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        int[] startSlice = new int[2];
        int[] endSlice = new int[2];
        int colCount = dataAccess.getEdgeExtent(0);
        int rowCount = dataAccess.getEdgeExtent(1);
        startSlice[0] = firstCol == 0 ? firstCol : firstCol - 1;
        endSlice[0] = lastCol >= colCount - 1 ? lastCol : ++lastCol;
        startSlice[1] = row == 0 ? row : row - 1;
        int n = endSlice[1] = row >= rowCount - 1 ? row : row + 1;
        if (!dataAccess.isFetched(startSlice, endSlice, 1) && !dataAccess.forceFetch(startSlice, endSlice, 1)) {
            this.m_eh.log("could not fetch data", this.getClass().getName(), m_method_fetchRowData);
            return -1;
        }
        return lastCol;
    }

    protected String convertViewFormatToExcelNumberFormat(ViewFormat viewFormat, ComponentHandle handle, Object data) {
        StringBuffer negNumFmt;
        StringBuffer posNumFmt;
        block80: {
            block81: {
                block79: {
                    if (viewFormat == null || data == null) {
                        return null;
                    }
                    posNumFmt = new StringBuffer();
                    negNumFmt = new StringBuffer();
                    if (viewFormat.isLeadingZero()) {
                        posNumFmt.append("0");
                        negNumFmt.append("0");
                    } else {
                        posNumFmt.append("#");
                        negNumFmt.append("#");
                    }
                    if (viewFormat.getThousandSeparator() != '\u0000') {
                        posNumFmt.insert(0, "#\\" + viewFormat.getThousandSeparatorSymbol() + "##");
                        negNumFmt.insert(0, "#\\" + viewFormat.getThousandSeparatorSymbol() + "##");
                    } else {
                        posNumFmt.insert(0, "###");
                        negNumFmt.insert(0, "###");
                    }
                    if (viewFormat.getDecimalDigit() > 0 && viewFormat.getDecimalSeparator() != '\u0000') {
                        posNumFmt.append("\\" + viewFormat.getDecimalSeparatorSymbol());
                        negNumFmt.append("\\" + viewFormat.getDecimalSeparatorSymbol());
                        int i = 0;
                        while (i < viewFormat.getDecimalDigit()) {
                            posNumFmt.append("0");
                            negNumFmt.append("0");
                            ++i;
                        }
                    }
                    switch (viewFormat.getScaleFactor()) {
                        case 1: {
                            posNumFmt.append(",");
                            negNumFmt.append(",");
                            if (viewFormat.getScaleDownThousands() == null || viewFormat.getScaleDownThousands().length() <= 0) break;
                            posNumFmt.append("\\\"" + viewFormat.getScaleDownThousandsSymbol() + "\\\"");
                            negNumFmt.append("\\\"" + viewFormat.getScaleDownThousandsSymbol() + "\\\"");
                            break;
                        }
                        case 2: {
                            posNumFmt.append(",,");
                            negNumFmt.append(",,");
                            if (viewFormat.getScaleDownMillions() == null || viewFormat.getScaleDownMillions().length() <= 0) break;
                            posNumFmt.append("\\\"" + viewFormat.getScaleDownMillionsSymbol() + "\\\"");
                            negNumFmt.append("\\\"" + viewFormat.getScaleDownMillionsSymbol() + "\\\"");
                            break;
                        }
                        case 3: {
                            posNumFmt.append(",,,");
                            negNumFmt.append(",,,");
                            if (viewFormat.getScaleDownBillions() == null || viewFormat.getScaleDownBillions().length() <= 0) break;
                            posNumFmt.append("\\\"" + viewFormat.getScaleDownBillionsSymbol() + "\\\"");
                            negNumFmt.append("\\\"" + viewFormat.getScaleDownBillionsSymbol() + "\\\"");
                            break;
                        }
                        case 4: {
                            posNumFmt.append(",,,,");
                            negNumFmt.append(",,,,");
                            if (viewFormat.getScaleDownTrillions() == null || viewFormat.getScaleDownTrillions().length() <= 0) break;
                            posNumFmt.append("\\\"" + viewFormat.getScaleDownTrillionsSymbol() + "\\\"");
                            negNumFmt.append("\\\"" + viewFormat.getScaleDownTrillionsSymbol() + "\\\"");
                            break;
                        }
                        case 5: {
                            posNumFmt.append(",,,,,");
                            negNumFmt.append(",,,,,");
                            if (viewFormat.getScaleDownQuadrillions() == null || viewFormat.getScaleDownQuadrillions().length() <= 0) break;
                            posNumFmt.append("\\\"" + viewFormat.getScaleDownQuadrillionsSymbol() + "\\\"");
                            negNumFmt.append("\\\"" + viewFormat.getScaleDownQuadrillionsSymbol() + "\\\"");
                            break;
                        }
                    }
                    if (viewFormat.getNumberType() != 2 && viewFormat.getNumberType() != 3) break block79;
                    posNumFmt.append("%");
                    negNumFmt.append("%");
                    switch (viewFormat.getNegPctFmt()) {
                        case 0: {
                            negNumFmt.insert(0, "-");
                            break;
                        }
                        case 1: {
                            negNumFmt.insert(0, "(");
                            negNumFmt.append(")");
                            break;
                        }
                    }
                    break block80;
                }
                if (viewFormat.getNumberType() != 1) break block81;
                NumberFormat defNumberFormat = NumberFormat.getCurrencyInstance(this.m_locale);
                DecimalFormat defDecimalFormat = null;
                if (defNumberFormat instanceof DecimalFormat) {
                    // empty if block
                }
                String currSym = viewFormat.getCurrencySymbol();
                if (!viewFormat.isCurrencySymbolUsed() && defDecimalFormat != null) {
                    currSym = defDecimalFormat.getDecimalFormatSymbols().getCurrencySymbol();
                }
                switch (viewFormat.getPosCurFmtValue()) {
                    case 0: {
                        if (currSym == null || currSym.length() <= 0) break;
                        posNumFmt.insert(0, "\\\"" + currSym + "\\\"");
                        break;
                    }
                    case 5: {
                        if (currSym != null && currSym.length() > 0) {
                            posNumFmt.insert(0, "\\\"" + currSym + "\\\"");
                        }
                        posNumFmt.append("+");
                        break;
                    }
                    case 2: {
                        posNumFmt.insert(0, " ");
                        if (currSym == null || currSym.length() <= 0) break;
                        posNumFmt.insert(0, "\\\"" + currSym + "\\\"");
                        break;
                    }
                    case 1: {
                        if (currSym == null || currSym.length() <= 0) break;
                        posNumFmt.append("\\\"" + currSym + "\\\"");
                        break;
                    }
                    case 8: {
                        if (currSym != null && currSym.length() > 0) {
                            posNumFmt.append("\\\"" + currSym + "\\\"");
                        }
                        posNumFmt.append("+");
                        break;
                    }
                    case 7: {
                        posNumFmt.append("+");
                        if (currSym == null || currSym.length() <= 0) break;
                        posNumFmt.append("\\\"" + currSym + "\\\"");
                        break;
                    }
                    case 3: {
                        posNumFmt.append(" ");
                        if (currSym == null || currSym.length() <= 0) break;
                        posNumFmt.append("\\\"" + currSym + "\\\"");
                        break;
                    }
                    case 11: {
                        posNumFmt.append(" ");
                        if (currSym != null && currSym.length() > 0) {
                            posNumFmt.append("\\\"" + currSym + "\\\"");
                        }
                        posNumFmt.append("+");
                        break;
                    }
                    case 4: {
                        if (currSym != null && currSym.length() > 0) {
                            posNumFmt.insert(0, "\\\"" + currSym + "\\\"");
                        }
                        posNumFmt.insert(0, "+");
                        break;
                    }
                    case 10: {
                        posNumFmt.insert(0, " ");
                        if (currSym != null && currSym.length() > 0) {
                            posNumFmt.insert(0, "\\\"" + currSym + "\\\"");
                        }
                        posNumFmt.insert(0, "+");
                        break;
                    }
                    case 6: {
                        posNumFmt.insert(0, "+");
                        if (currSym == null || currSym.length() <= 0) break;
                        posNumFmt.append("\\\"" + currSym + "\\\"");
                        break;
                    }
                    case 9: {
                        posNumFmt.insert(0, "+");
                        posNumFmt.append(" ");
                        if (currSym == null || currSym.length() <= 0) break;
                        posNumFmt.append("\\\"" + currSym + "\\\"");
                        break;
                    }
                }
                switch (viewFormat.getNegCurFmtValue()) {
                    case 2: {
                        negNumFmt.insert(0, "-");
                        if (currSym != null && currSym.length() > 0) {
                            negNumFmt.insert(0, "\\\"" + currSym + "\\\"");
                            break;
                        }
                        break block80;
                    }
                    case 3: {
                        if (currSym != null && currSym.length() > 0) {
                            negNumFmt.insert(0, "\\\"" + currSym + "\\\"");
                        }
                        negNumFmt.append("-");
                        break;
                    }
                    case 1: {
                        if (currSym != null && currSym.length() > 0) {
                            negNumFmt.insert(0, "\\\"" + currSym + "\\\"");
                        }
                        negNumFmt.insert(0, "-");
                        break;
                    }
                    case 9: {
                        negNumFmt.insert(0, " ");
                        if (currSym != null && currSym.length() > 0) {
                            negNumFmt.insert(0, "\\\"" + currSym + "\\\"");
                        }
                        negNumFmt.insert(0, "-");
                        break;
                    }
                    case 5: {
                        negNumFmt.insert(0, "-");
                        if (currSym != null && currSym.length() > 0) {
                            negNumFmt.append("\\\"" + currSym + "\\\"");
                            break;
                        }
                        break block80;
                    }
                    case 8: {
                        negNumFmt.insert(0, "-");
                        negNumFmt.append(" ");
                        if (currSym != null && currSym.length() > 0) {
                            negNumFmt.append("\\\"" + currSym + "\\\"");
                            break;
                        }
                        break block80;
                    }
                    case 7: {
                        if (currSym != null && currSym.length() > 0) {
                            negNumFmt.append("\\\"" + currSym + "\\\"");
                        }
                        negNumFmt.append("-");
                        break;
                    }
                    case 6: {
                        negNumFmt.append("-");
                        if (currSym != null && currSym.length() > 0) {
                            negNumFmt.append("\\\"" + currSym + "\\\"");
                            break;
                        }
                        break block80;
                    }
                    case 10: {
                        negNumFmt.append(" ");
                        if (currSym != null && currSym.length() > 0) {
                            negNumFmt.append("\\\"" + currSym + "\\\"");
                        }
                        negNumFmt.append("-");
                        break;
                    }
                    case 0: {
                        if (currSym != null && currSym.length() > 0) {
                            negNumFmt.insert(0, "\\\"" + currSym + "\\\"");
                        }
                        negNumFmt.insert(0, "(");
                        negNumFmt.append(")");
                        break;
                    }
                    case 4: {
                        negNumFmt.insert(0, "(");
                        if (currSym != null && currSym.length() > 0) {
                            negNumFmt.append("\\\"" + currSym + "\\\"");
                        }
                        negNumFmt.append(")");
                        break;
                    }
                    case 12: {
                        negNumFmt.insert(0, " ");
                        if (currSym != null && currSym.length() > 0) {
                            negNumFmt.insert(0, "\\\"" + currSym + "\\\"");
                        }
                        negNumFmt.append("-");
                        break;
                    }
                    case 13: {
                        negNumFmt.insert(0, "-");
                        negNumFmt.insert(0, " ");
                        if (currSym != null && currSym.length() > 0) {
                            negNumFmt.insert(0, "\\\"" + currSym + "\\\"");
                            break;
                        }
                        break block80;
                    }
                }
                break block80;
            }
            if (viewFormat.getNumberType() == 0) {
                switch (viewFormat.getPosNumFmtValue()) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        posNumFmt.append("+");
                        break;
                    }
                    case 1: {
                        posNumFmt.insert(0, "+");
                        break;
                    }
                }
                switch (viewFormat.getNegNumFmtValue()) {
                    case 1: {
                        negNumFmt.insert(0, "-");
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 2: {
                        negNumFmt.append("-");
                        break;
                    }
                    case 0: {
                        negNumFmt.insert(0, "(");
                        negNumFmt.append(")");
                        break;
                    }
                }
            }
        }
        String numFmt = posNumFmt.toString() + ";" + negNumFmt.toString();
        return numFmt;
    }

    protected String convertViewFormatToExcelDateFormat(ViewFormat viewFormat, ComponentHandle handle, Object data) {
        DateFormat fmt;
        if (viewFormat.getOracleDateFormat() != null && !viewFormat.getOracleDateFormat().equals("")) {
            return this.convertOracleDateFormatToExcelFormat(viewFormat.getOracleDateFormat());
        }
        if (viewFormat.getJavaDateFormat() != null && !viewFormat.getJavaDateFormat().equals("")) {
            return this.convertJavaDateFormatToExcelFormat(viewFormat.getJavaDateFormat());
        }
        Locale locale = viewFormat.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        SimpleDateFormat ret = (fmt = DateFormat.getDateInstance(3, locale)) instanceof SimpleDateFormat ? (SimpleDateFormat)fmt : new SimpleDateFormat();
        if (locale.getLanguage().compareTo("th") == 0 && locale.getCountry().compareTo("TH") == 0) {
            ret.setCalendar(new GregorianCalendar(locale));
        }
        return this.convertJavaDateFormatToExcelFormat(ret.toPattern());
    }

    protected CSSStyle convertViewStyleToCSSStyle(ViewStyle viewStyle, ComponentHandle handle) {
        CSSStyle style = new CSSStyle();
        boolean bModified = this.convertViewStyleToCSSStyle(style, viewStyle, handle);
        if (bModified) {
            return style;
        }
        return null;
    }

    protected boolean convertViewStyleToCSSStyle(CSSStyle style, ViewStyle viewStyle, ComponentHandle handle) {
        StringBuffer borderSpec;
        if (viewStyle == null) {
            return false;
        }
        boolean styleExists = false;
        if (this.convertFontFamily(style, viewStyle, handle)) {
            styleExists = true;
        }
        if (this.convertFontSize(style, viewStyle, handle)) {
            styleExists = true;
        }
        if (viewStyle.isFontItalicUsed()) {
            styleExists = true;
            if (viewStyle.isFontItalic()) {
                style.setProperty("font-style", "italic");
            } else {
                style.setProperty("font-style", "normal");
            }
        }
        if (viewStyle.isFontBoldUsed()) {
            styleExists = true;
            if (viewStyle.isFontBold()) {
                style.setProperty("font-weight", "bold");
            } else {
                style.setProperty("font-weight", "normal");
            }
        }
        if (viewStyle.isUnderlineUsed() || viewStyle.isStrikeThroughUsed() || viewStyle.isDoubleUnderlineUsed()) {
            boolean underline = false;
            boolean strikethrough = false;
            boolean doubleUnderline = false;
            if (viewStyle.isUnderlineUsed() && viewStyle.isUnderline()) {
                underline = true;
            }
            if (viewStyle.isStrikeThroughUsed() && viewStyle.isStrikeThrough()) {
                strikethrough = true;
            }
            if (viewStyle.isDoubleUnderlineUsed() && viewStyle.isDoubleUnderline()) {
                doubleUnderline = true;
            }
            styleExists = true;
            if ((underline || doubleUnderline) && strikethrough) {
                style.setProperty("text-decoration", "underline line-through");
            } else if (underline || doubleUnderline) {
                style.setProperty("text-decoration", "underline");
            } else if (strikethrough) {
                style.setProperty("text-decoration", "line-through");
            } else {
                style.setProperty("text-decoration", "none");
            }
            if (underline) {
                style.setProperty("text-underline-style", "single");
            } else if (doubleUnderline) {
                style.setProperty("text-underline-style", "double");
            }
        }
        if (viewStyle.isHorizontalAlignmentUsed()) {
            switch (viewStyle.getHorizontalAlignment()) {
                case 0: {
                    styleExists = true;
                    style.setProperty("text-align", "center");
                    break;
                }
                case 4: {
                    styleExists = true;
                    style.setProperty("text-align", "right");
                    break;
                }
                case 2: {
                    styleExists = true;
                    style.setProperty("text-align", "left");
                    break;
                }
                case 10: {
                    styleExists = true;
                    if (LocaleUtils.getReadingDirectionForLocale((Locale)this.m_locale) == 2) {
                        style.setProperty("text-align", "right");
                        break;
                    }
                    style.setProperty("text-align", "left");
                    break;
                }
            }
        }
        DataComponentHandle dataHandle = null;
        if (handle instanceof DataComponentHandle) {
            dataHandle = (DataComponentHandle)handle;
        }
        if (dataHandle != null && this.isEditableColorShown() && this.isCellEditable(viewStyle, dataHandle)) {
            Color color = null;
            if (viewStyle.isEditForegroundUsed()) {
                color = viewStyle.getEditForeground();
            }
            if (color == null && viewStyle.isForegroundUsed()) {
                color = viewStyle.getForeground();
            }
            if (color != null) {
                styleExists = true;
                style.setProperty("color", this.colorToHexString(color.getRGB()));
            }
        } else {
            Color color = null;
            if (viewStyle.isForegroundUsed()) {
                color = viewStyle.getForeground();
            }
            if (color != null) {
                styleExists = true;
                style.setProperty("color", this.colorToHexString(color.getRGB()));
            }
        }
        if (this.convertBackgroundColor(style, viewStyle, handle)) {
            styleExists = true;
        }
        if (viewStyle.isVerticalAlignmentUsed()) {
            switch (viewStyle.getVerticalAlignment()) {
                case 1: {
                    styleExists = true;
                    style.setProperty("vertical-align", "top");
                    break;
                }
                case 0: {
                    styleExists = true;
                    style.setProperty("vertical-align", "middle");
                    break;
                }
                case 3: {
                    styleExists = true;
                    style.setProperty("vertical-align", "bottom");
                    break;
                }
            }
        }
        if (viewStyle.isBorderStyleUsed(2)) {
            Color color;
            styleExists = true;
            borderSpec = new StringBuffer();
            if (viewStyle.isBorderWidthUsed(2)) {
                String s = this.convertBorderWidthPixelsToPoints(viewStyle.getBorderWidth(2)) + "pt";
                borderSpec.append(" " + s);
            }
            int borderStyle = viewStyle.getBorderStyle(2);
            borderSpec.append(" " + this._getBorderStyle(borderStyle));
            if (viewStyle.isBorderColorUsed(2) && (color = viewStyle.getBorderColor(2)) != null) {
                borderSpec.append(" " + this.colorToHexString(color.getRGB()));
            }
            style.setProperty("border-left", borderSpec.toString());
        }
        if (viewStyle.isBorderStyleUsed(8)) {
            Color color;
            styleExists = true;
            borderSpec = new StringBuffer();
            if (viewStyle.isBorderWidthUsed(8)) {
                String s = this.convertBorderWidthPixelsToPoints(viewStyle.getBorderWidth(8)) + "pt";
                borderSpec.append(" " + s);
            }
            int borderStyle = viewStyle.getBorderStyle(8);
            borderSpec.append(" " + this._getBorderStyle(borderStyle));
            if (viewStyle.isBorderColorUsed(8) && (color = viewStyle.getBorderColor(8)) != null) {
                borderSpec.append(" " + this.colorToHexString(color.getRGB()));
            }
            style.setProperty("border-right", borderSpec.toString());
        }
        if (viewStyle.isBorderStyleUsed(1)) {
            Color color;
            styleExists = true;
            borderSpec = new StringBuffer();
            if (viewStyle.isBorderWidthUsed(1)) {
                String s = this.convertBorderWidthPixelsToPoints(viewStyle.getBorderWidth(1)) + "pt";
                borderSpec.append(" " + s);
            }
            int borderStyle = viewStyle.getBorderStyle(1);
            borderSpec.append(" " + this._getBorderStyle(borderStyle));
            if (viewStyle.isBorderColorUsed(1) && (color = viewStyle.getBorderColor(1)) != null) {
                borderSpec.append(" " + this.colorToHexString(color.getRGB()));
            }
            style.setProperty("border-top", borderSpec.toString());
        }
        if (viewStyle.isBorderStyleUsed(4)) {
            Color color;
            styleExists = true;
            borderSpec = new StringBuffer();
            if (viewStyle.isBorderWidthUsed(4)) {
                String s = this.convertBorderWidthPixelsToPoints(viewStyle.getBorderWidth(4)) + "pt";
                borderSpec.append(" " + s);
            }
            int borderStyle = viewStyle.getBorderStyle(4);
            borderSpec.append(" " + this._getBorderStyle(borderStyle));
            if (viewStyle.isBorderColorUsed(4) && (color = viewStyle.getBorderColor(4)) != null) {
                borderSpec.append(" " + this.colorToHexString(color.getRGB()));
            }
            style.setProperty("border-bottom", borderSpec.toString());
        }
        return styleExists;
    }

    protected double convertBorderWidthPixelsToPoints(int width) {
        if (width == 0) {
            return 0.0;
        }
        if (width == 1) {
            return 0.5;
        }
        if (width == 2) {
            return 1.2;
        }
        if (width == 3) {
            return 2.0;
        }
        if (width == 4) {
            return 3.0;
        }
        return width - 1;
    }

    protected String convertOracleDateFormatToExcelFormat(String fmtString) {
        String srcFmtString = fmtString;
        String strTokens = "- / , % @ # & * . ; : \" fmmm mm month mon day fmdd dd dy sy,yyy syyyy y,yyy yyyy yy fmhh24 hh24 fmhh12 hh12 fmhh hh fmmi mi fmss.ff ss.ff fmss sssss ss am pm a.m. p.m.";
        String dstFmtString = "";
        boolean hour12Format = false;
        int lastTimeIndex = -1;
        int oldLength = 0;
        block0: while (srcFmtString.length() > 0) {
            StringTokenizer st = new StringTokenizer(strTokens);
            while (srcFmtString.length() > 0 && srcFmtString.substring(0, 1).equals(" ")) {
                dstFmtString = dstFmtString + " ";
                srcFmtString = srcFmtString.substring(1);
                --oldLength;
            }
            if (srcFmtString.length() == oldLength) {
                srcFmtString = srcFmtString.substring(1);
            } else {
                oldLength = srcFmtString.length();
            }
            while (st.hasMoreTokens()) {
                String tmpString;
                String tokenString = st.nextToken();
                if (tokenString.equals("-") || tokenString.equals("/") || tokenString.equals(",") || tokenString.equals(".") || tokenString.equals(";") || tokenString.equals(":") || tokenString.equals("%") || tokenString.equals("@") || tokenString.equals("#") || tokenString.equals("&") || tokenString.equals("*")) {
                    if (srcFmtString.length() <= 0) continue block0;
                    tmpString = srcFmtString.substring(0, 1);
                    if (!tmpString.equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + tokenString;
                    srcFmtString = srcFmtString.substring(1);
                    continue block0;
                }
                if (tokenString.equals("\"")) {
                    tmpString = srcFmtString.substring(0, 1);
                    if (!tmpString.equals(tokenString) || (srcFmtString = srcFmtString.substring(1)).indexOf("\"") == -1) continue;
                    dstFmtString = srcFmtString.indexOf("\"") != 0 ? dstFmtString + srcFmtString.substring(0, srcFmtString.indexOf("\"")) : dstFmtString + "\"";
                    srcFmtString = srcFmtString.substring(srcFmtString.indexOf("\""));
                    continue block0;
                }
                if (tokenString.equals("fmmm")) {
                    if (srcFmtString.length() < 4 || !(tmpString = srcFmtString.substring(0, 4)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "M";
                    srcFmtString = srcFmtString.substring(4);
                    continue block0;
                }
                if (tokenString.equals("mm")) {
                    if (srcFmtString.length() < 2 || !(tmpString = srcFmtString.substring(0, 2)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Mm";
                    srcFmtString = srcFmtString.substring(2);
                    continue block0;
                }
                if (tokenString.equals("month")) {
                    if (srcFmtString.length() < 5 || !(tmpString = srcFmtString.substring(0, 5)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Mmmm";
                    srcFmtString = srcFmtString.substring(5);
                    continue block0;
                }
                if (tokenString.equals("mon")) {
                    if (srcFmtString.length() < 3 || !(tmpString = srcFmtString.substring(0, 3)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Mmm";
                    srcFmtString = srcFmtString.substring(3);
                    continue block0;
                }
                if (tokenString.equals("day")) {
                    if (srcFmtString.length() < 3 || !(tmpString = srcFmtString.substring(0, 3)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Dddd";
                    srcFmtString = srcFmtString.substring(3);
                    continue block0;
                }
                if (tokenString.equals("fmdd")) {
                    if (srcFmtString.length() < 4 || !(tmpString = srcFmtString.substring(0, 4)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "D";
                    srcFmtString = srcFmtString.substring(4);
                    continue block0;
                }
                if (tokenString.equals("dd")) {
                    if (srcFmtString.length() < 2 || !(tmpString = srcFmtString.substring(0, 2)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Dd";
                    srcFmtString = srcFmtString.substring(2);
                    continue block0;
                }
                if (tokenString.equals("dy")) {
                    if (srcFmtString.length() < 2 || !(tmpString = srcFmtString.substring(0, 2)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Ddd";
                    srcFmtString = srcFmtString.substring(2);
                    continue block0;
                }
                if (tokenString.equals("sy,yyy")) {
                    if (srcFmtString.length() < 6 || !(tmpString = srcFmtString.substring(0, 6)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Yyyy";
                    srcFmtString = srcFmtString.substring(6);
                    continue block0;
                }
                if (tokenString.equals("y,yyy")) {
                    if (srcFmtString.length() < 5 || !(tmpString = srcFmtString.substring(0, 5)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Yyyy";
                    srcFmtString = srcFmtString.substring(5);
                    continue block0;
                }
                if (tokenString.equals("syyyy")) {
                    if (srcFmtString.length() < 5 || !(tmpString = srcFmtString.substring(0, 5)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Yyyy";
                    srcFmtString = srcFmtString.substring(5);
                    continue block0;
                }
                if (tokenString.equals("yyyy")) {
                    if (srcFmtString.length() < 4 || !(tmpString = srcFmtString.substring(0, 4)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Yyyy";
                    srcFmtString = srcFmtString.substring(4);
                    continue block0;
                }
                if (tokenString.equals("yy")) {
                    if (srcFmtString.length() < 2 || !(tmpString = srcFmtString.substring(0, 2)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Yy";
                    srcFmtString = srcFmtString.substring(2);
                    continue block0;
                }
                if (tokenString.equals("fmhh24")) {
                    if (srcFmtString.length() < 6 || !(tmpString = srcFmtString.substring(0, 6)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "H";
                    srcFmtString = srcFmtString.substring(6);
                    continue block0;
                }
                if (tokenString.equals("hh24")) {
                    if (srcFmtString.length() < 4 || !(tmpString = srcFmtString.substring(0, 4)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Hh";
                    srcFmtString = srcFmtString.substring(4);
                    continue block0;
                }
                if (tokenString.equals("fmhh")) {
                    if (srcFmtString.length() < 4 || !(tmpString = srcFmtString.substring(0, 4)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "h";
                    srcFmtString = srcFmtString.substring(4);
                    hour12Format = true;
                    lastTimeIndex = dstFmtString.length();
                    continue block0;
                }
                if (tokenString.equals("hh")) {
                    if (srcFmtString.length() < 2 || !(tmpString = srcFmtString.substring(0, 2)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Hh";
                    srcFmtString = srcFmtString.substring(2);
                    hour12Format = true;
                    lastTimeIndex = dstFmtString.length();
                    continue block0;
                }
                if (tokenString.equals("fmmi")) {
                    if (srcFmtString.length() < 4 || !(tmpString = srcFmtString.substring(0, 4)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "M";
                    srcFmtString = srcFmtString.substring(4);
                    lastTimeIndex = dstFmtString.length();
                    continue block0;
                }
                if (tokenString.equals("mi")) {
                    if (srcFmtString.length() < 2 || !(tmpString = srcFmtString.substring(0, 2)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Mm";
                    srcFmtString = srcFmtString.substring(2);
                    lastTimeIndex = dstFmtString.length();
                    continue block0;
                }
                if (tokenString.equals("fmss.ff")) {
                    if (srcFmtString.length() < 7 || !(tmpString = srcFmtString.substring(0, 7)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "S.00";
                    srcFmtString = srcFmtString.substring(7);
                    lastTimeIndex = dstFmtString.length();
                    continue block0;
                }
                if (tokenString.equals("ss.ff")) {
                    if (srcFmtString.length() < 2 || !(tmpString = srcFmtString.substring(0, 2)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "ss.00";
                    srcFmtString = srcFmtString.substring(2);
                    lastTimeIndex = dstFmtString.length();
                    continue block0;
                }
                if (tokenString.equals("sssss")) {
                    if (srcFmtString.length() < 5 || !(tmpString = srcFmtString.substring(0, 5)).equalsIgnoreCase(tokenString)) continue;
                    srcFmtString = srcFmtString.substring(5);
                    lastTimeIndex = dstFmtString.length();
                    continue block0;
                }
                if (tokenString.equals("fmss")) {
                    if (srcFmtString.length() < 4 || !(tmpString = srcFmtString.substring(0, 4)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "S";
                    srcFmtString = srcFmtString.substring(4);
                    lastTimeIndex = dstFmtString.length();
                    continue block0;
                }
                if (tokenString.equals("ss")) {
                    if (srcFmtString.length() < 2 || !(tmpString = srcFmtString.substring(0, 2)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Ss";
                    srcFmtString = srcFmtString.substring(2);
                    lastTimeIndex = dstFmtString.length();
                    continue block0;
                }
                if (tokenString.equals("am")) {
                    if (srcFmtString.length() < 2 || !(tmpString = srcFmtString.substring(0, 2)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "AM/PM";
                    srcFmtString = srcFmtString.substring(2);
                    lastTimeIndex = -1;
                    continue block0;
                }
                if (tokenString.equals("pm")) {
                    if (srcFmtString.length() < 2 || !(tmpString = srcFmtString.substring(0, 2)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "AM/PM";
                    srcFmtString = srcFmtString.substring(2);
                    lastTimeIndex = -1;
                    continue block0;
                }
                if (tokenString.equals("a.m.")) {
                    if (srcFmtString.length() < 4 || !(tmpString = srcFmtString.substring(0, 4)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "AM/PM";
                    srcFmtString = srcFmtString.substring(4);
                    lastTimeIndex = -1;
                    continue block0;
                }
                if (!tokenString.equals("p.m.") || srcFmtString.length() < 4 || !(tmpString = srcFmtString.substring(0, 4)).equalsIgnoreCase(tokenString)) continue;
                dstFmtString = dstFmtString + "AM/PM";
                srcFmtString = srcFmtString.substring(4);
                lastTimeIndex = -1;
                continue block0;
            }
        }
        if (hour12Format && lastTimeIndex != -1) {
            StringBuffer buffer = new StringBuffer(dstFmtString);
            buffer.insert(lastTimeIndex, " AM/PM");
            dstFmtString = buffer.toString();
        }
        return dstFmtString;
    }

    protected String convertJavaDateFormatToExcelFormat(String fmtString) {
        String srcFmtString = fmtString;
        String strTokens = "- / , . ; : ' MMMM MMM MM M d dd EEE EEEE yyyy yy HH H mm m ss s a";
        String dstFmtString = "";
        int oldLength = 0;
        block0: while (srcFmtString.length() > 0) {
            StringTokenizer st = new StringTokenizer(strTokens);
            while (srcFmtString.length() > 0 && srcFmtString.substring(0, 1).equals(" ")) {
                dstFmtString = dstFmtString + " ";
                srcFmtString = srcFmtString.substring(1);
                --oldLength;
            }
            if (srcFmtString.length() == oldLength) {
                srcFmtString = srcFmtString.substring(1);
            } else {
                oldLength = srcFmtString.length();
            }
            while (st.hasMoreTokens()) {
                String tmpString;
                String tokenString = st.nextToken();
                if (tokenString.equals("-") || tokenString.equals("/") || tokenString.equals(",") || tokenString.equals(".") || tokenString.equals(";") || tokenString.equals(":")) {
                    if (srcFmtString.length() <= 0) continue block0;
                    tmpString = srcFmtString.substring(0, 1);
                    if (!tmpString.equals(tokenString)) continue;
                    dstFmtString = dstFmtString + tokenString;
                    srcFmtString = srcFmtString.substring(1);
                    continue block0;
                }
                if (tokenString.equals("'")) {
                    tmpString = srcFmtString.substring(0, 1);
                    if (!tmpString.equals(tokenString) || (srcFmtString = srcFmtString.substring(1)).indexOf("'") == -1) continue;
                    dstFmtString = srcFmtString.indexOf("'") != 0 ? dstFmtString + srcFmtString.substring(0, srcFmtString.indexOf("'")) : dstFmtString + "'";
                    srcFmtString = srcFmtString.substring(srcFmtString.indexOf("'"));
                    continue block0;
                }
                if (tokenString.equals("MMMM")) {
                    if (srcFmtString.length() < 4 || !(tmpString = srcFmtString.substring(0, 4)).equals(tokenString)) continue;
                    dstFmtString = dstFmtString + "Mmmm";
                    srcFmtString = srcFmtString.substring(4);
                    while (srcFmtString.length() >= 1 && srcFmtString.substring(0, 1).equals("M")) {
                        srcFmtString = srcFmtString.substring(1);
                    }
                    continue block0;
                }
                if (tokenString.equals("MMM")) {
                    if (srcFmtString.length() < 3 || !(tmpString = srcFmtString.substring(0, 3)).equals(tokenString)) continue;
                    dstFmtString = dstFmtString + "Mmm";
                    srcFmtString = srcFmtString.substring(3);
                    continue block0;
                }
                if (tokenString.equals("MM")) {
                    if (srcFmtString.length() < 2 || !(tmpString = srcFmtString.substring(0, 2)).equals(tokenString)) continue;
                    dstFmtString = dstFmtString + "Mm";
                    srcFmtString = srcFmtString.substring(2);
                    continue block0;
                }
                if (tokenString.equals("M")) {
                    if (srcFmtString.length() < 1 || !(tmpString = srcFmtString.substring(0, 1)).equals(tokenString)) continue;
                    dstFmtString = dstFmtString + "M";
                    srcFmtString = srcFmtString.substring(1);
                    continue block0;
                }
                if (tokenString.equals("dd")) {
                    if (srcFmtString.length() < 2 || !(tmpString = srcFmtString.substring(0, 2)).equals(tokenString)) continue;
                    dstFmtString = dstFmtString + "Dd";
                    srcFmtString = srcFmtString.substring(2);
                    while (srcFmtString.length() >= 1 && srcFmtString.substring(0, 1).equals("d")) {
                        srcFmtString = srcFmtString.substring(1);
                    }
                    continue block0;
                }
                if (tokenString.equals("d")) {
                    if (srcFmtString.length() < 1 || !(tmpString = srcFmtString.substring(0, 1)).equals(tokenString)) continue;
                    dstFmtString = dstFmtString + "D";
                    srcFmtString = srcFmtString.substring(1);
                    continue block0;
                }
                if (tokenString.equals("EEEE")) {
                    if (srcFmtString.length() < 4 || !(tmpString = srcFmtString.substring(0, 4)).equals(tokenString)) continue;
                    dstFmtString = dstFmtString + "Dddd";
                    srcFmtString = srcFmtString.substring(4);
                    while (srcFmtString.length() >= 1 && srcFmtString.substring(0, 1).equals("E")) {
                        srcFmtString = srcFmtString.substring(1);
                    }
                    continue block0;
                }
                if (tokenString.equals("EEE")) {
                    if (srcFmtString.length() < 3 || !(tmpString = srcFmtString.substring(0, 3)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Ddd";
                    srcFmtString = srcFmtString.substring(3);
                    continue block0;
                }
                if (tokenString.equals("yyyy")) {
                    if (srcFmtString.length() < 4 || !(tmpString = srcFmtString.substring(0, 4)).equals(tokenString)) continue;
                    dstFmtString = dstFmtString + "Yyyy";
                    srcFmtString = srcFmtString.substring(4);
                    while (srcFmtString.length() >= 1 && srcFmtString.substring(0, 1).equals("y")) {
                        srcFmtString = srcFmtString.substring(1);
                    }
                    continue block0;
                }
                if (tokenString.equals("yy")) {
                    if (srcFmtString.length() < 2 || !(tmpString = srcFmtString.substring(0, 2)).equals(tokenString)) continue;
                    dstFmtString = dstFmtString + "Yy";
                    srcFmtString = srcFmtString.substring(2);
                    continue block0;
                }
                if (tokenString.equals("HH")) {
                    if (srcFmtString.length() < 2 || !(tmpString = srcFmtString.substring(0, 2)).equals(tokenString)) continue;
                    dstFmtString = dstFmtString + "Hh";
                    srcFmtString = srcFmtString.substring(2);
                    while (srcFmtString.length() >= 1 && srcFmtString.substring(0, 1).equals("H")) {
                        srcFmtString = srcFmtString.substring(1);
                    }
                    continue block0;
                }
                if (tokenString.equals("H")) {
                    if (srcFmtString.length() < 1 || !(tmpString = srcFmtString.substring(0, 1)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "H";
                    srcFmtString = srcFmtString.substring(1);
                    continue block0;
                }
                if (tokenString.equals("mm")) {
                    if (srcFmtString.length() < 2 || !(tmpString = srcFmtString.substring(0, 2)).equalsIgnoreCase(tokenString)) continue;
                    dstFmtString = dstFmtString + "Mm";
                    srcFmtString = srcFmtString.substring(2);
                    while (srcFmtString.length() >= 1 && srcFmtString.substring(0, 1).equals("m")) {
                        srcFmtString = srcFmtString.substring(1);
                    }
                    continue block0;
                }
                if (tokenString.equals("m")) {
                    if (srcFmtString.length() < 1 || !(tmpString = srcFmtString.substring(0, 1)).equals(tokenString)) continue;
                    dstFmtString = dstFmtString + "M";
                    srcFmtString = srcFmtString.substring(1);
                    continue block0;
                }
                if (tokenString.equals("ss")) {
                    if (srcFmtString.length() < 2 || !(tmpString = srcFmtString.substring(0, 2)).equals(tokenString)) continue;
                    dstFmtString = dstFmtString + "Ss";
                    srcFmtString = srcFmtString.substring(2);
                    while (srcFmtString.length() >= 1 && srcFmtString.substring(0, 1).equals("s")) {
                        srcFmtString = srcFmtString.substring(1);
                    }
                    continue block0;
                }
                if (tokenString.equals("s")) {
                    if (srcFmtString.length() < 1 || !(tmpString = srcFmtString.substring(0, 1)).equals(tokenString)) continue;
                    dstFmtString = dstFmtString + "s";
                    srcFmtString = srcFmtString.substring(1);
                    continue block0;
                }
                if (!tokenString.equals("a") || srcFmtString.length() < 1 || !(tmpString = srcFmtString.substring(0, 1)).equals(tokenString)) continue;
                dstFmtString = dstFmtString + "AM/PM";
                srcFmtString = srcFmtString.substring(1);
                while (srcFmtString.length() >= 1 && srcFmtString.substring(0, 1).equals("a")) {
                    srcFmtString = srcFmtString.substring(1);
                }
                continue block0;
            }
        }
        return dstFmtString;
    }

    protected static String mapJavaFontToHTMLFont(String fontName) {
        if (fontName.equalsIgnoreCase("serif")) {
            fontName = "serif";
        } else if (fontName.equalsIgnoreCase("dialog")) {
            fontName = "sans-serif";
        } else if (fontName.equalsIgnoreCase("dialoginput")) {
            fontName = "monospace";
        } else if (fontName.equalsIgnoreCase("sansserif")) {
            fontName = "sans-serif";
        } else if (fontName.equalsIgnoreCase("monospaced")) {
            fontName = "monospace";
        }
        return fontName;
    }

    protected boolean convertFontFamily(CSSStyle style, ViewStyle viewStyle, ComponentHandle handle) {
        String fontFamily;
        boolean styleExists = false;
        if (viewStyle.isFontNameUsed() && (fontFamily = viewStyle.getFontName()) != null) {
            fontFamily = GridViewExcelHTMLExport.mapJavaFontToHTMLFont(fontFamily);
            styleExists = true;
            style.setProperty("font-family", fontFamily);
        }
        return styleExists;
    }

    protected boolean convertFontSize(CSSStyle style, ViewStyle viewStyle, ComponentHandle handle) {
        int size;
        boolean styleExists = false;
        if (viewStyle.isFontSizeUsed() && (size = viewStyle.getFontSize()) > 0) {
            styleExists = true;
            style.setProperty("font-size", Integer.toString(viewStyle.getFontSize()) + "pt");
        }
        return styleExists;
    }

    protected boolean convertBackgroundColor(CSSStyle style, ViewStyle viewStyle, ComponentHandle handle) {
        boolean styleExists = false;
        DataComponentHandle dataHandle = null;
        if (handle instanceof DataComponentHandle) {
            dataHandle = (DataComponentHandle)handle;
        }
        if (dataHandle != null && this.isEditableColorShown() && this.isCellEditable(viewStyle, dataHandle)) {
            Color color = null;
            if (viewStyle.isEditBackgroundUsed()) {
                color = viewStyle.getEditBackground();
            }
            if (color == null && viewStyle.isBackgroundUsed()) {
                color = viewStyle.getBackground();
            }
            if (color != null) {
                styleExists = true;
                style.setProperty("background-color", this.colorToHexString(color.getRGB()));
            }
        } else {
            Color color = null;
            if (viewStyle.isBackgroundUsed()) {
                color = viewStyle.getBackground();
            }
            if (color != null) {
                styleExists = true;
                style.setProperty("background-color", this.colorToHexString(color.getRGB()));
            }
        }
        return styleExists;
    }

    protected boolean isCellEditable(ViewStyle viewStyle, ComponentHandle handle) {
        if (handle != null && handle instanceof DataComponentHandle) {
            return this.m_gridView.isCellEditingAllowed();
        }
        return false;
    }

    protected boolean isEditableColorShown() {
        return true;
    }

    protected int getNearestUnusedExcelPaletteColorIndex(int rgb) {
        int retIndex = -1;
        int smallest = 0x1000000;
        int r1 = 0xFF & rgb >>> 16;
        int g1 = 0xFF & rgb >>> 8;
        int b1 = 0xFF & rgb >>> 0;
        boolean bToolbarIndexAvailable = false;
        int i = 0;
        while (i < m_paletteIndexes.length) {
            if (i >= 40 && bToolbarIndexAvailable) break;
            int index = m_paletteIndexes[i] - 1;
            if (!this.m_paletteIndexUsed[index]) {
                int b2;
                int g2;
                int r2;
                int distsqr;
                if (i < 40) {
                    bToolbarIndexAvailable = true;
                }
                if ((distsqr = (r1 - (r2 = 0xFF & DEFAULT_PALETTE[index] >>> 16)) * (r1 - r2) + (g1 - (g2 = 0xFF & DEFAULT_PALETTE[index] >>> 8)) * (g1 - g2) + (b1 - (b2 = 0xFF & DEFAULT_PALETTE[index] >>> 0)) * (b1 - b2)) < smallest) {
                    retIndex = index;
                    smallest = distsqr;
                }
            }
            ++i;
        }
        return retIndex;
    }

    protected int getExcelPaletteColorIndex(int rgb) {
        int color = 0xFFFFFF & rgb;
        int i = 0;
        while (i < this.m_colorPalette.length) {
            if (color == this.m_colorPalette[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected String colorToHexString(int colorRGB) {
        String hexString = GridViewExcelHTMLExport.toHexString(colorRGB);
        int existingIndex = this.getExcelPaletteColorIndex(colorRGB);
        if (existingIndex > -1) {
            this.m_paletteIndexUsed[existingIndex] = true;
        } else if (!this.m_colorHashMap.containsKey(hexString)) {
            int size = this.m_colorHashMap.size();
            if (size < GridViewExcelHTMLExport.getMaxColorPaletteSize()) {
                int index = this.getNearestUnusedExcelPaletteColorIndex(colorRGB);
                if (index > -1) {
                    this.m_colorHashMap.put(hexString, new Integer(index));
                    this.m_paletteIndexUsed[index] = true;
                    this.m_colorPalette[index] = 0xFFFFFF & colorRGB;
                }
            } else {
                this.m_eh.log("too many custom colors in palette", this.getClass().getName(), "protected String colorToHexString(int colorRGB)");
            }
        }
        return hexString;
    }

    protected static String toHexString(int value) {
        String hexStr = Integer.toHexString(value & 0xFFFFFF);
        String poundStr = "#";
        StringBuffer buff = new StringBuffer(poundStr);
        int pad0 = 6 - hexStr.length();
        while (pad0-- > 0) {
            buff.append("0");
        }
        buff.append(hexStr);
        return buff.toString();
    }

    private String _getBorderStyle(int borderStyle) {
        switch (borderStyle) {
            case 0: {
                return "none";
            }
            case 1: {
                return "solid";
            }
            case 2: {
                return "dashed";
            }
            case 3: {
                return "dotted";
            }
            case 4: {
                return "dotted";
            }
            case 5: {
                return "dotted";
            }
            case 6: {
                return "double";
            }
            case 7: {
                return "none";
            }
        }
        return "none";
    }

    private String _zeroFillNumber(int n) {
        String ns = null;
        if (n < 10) {
            ns = "00" + n;
        } else if (n < 100) {
            ns = "0" + n;
        } else if (n < 1000) {
            ns = "" + n;
        } else {
            this.m_eh.log("Error: logic only accomodates 999 sheets!", this.getClass().getName(), m_method__zeroFillNumber);
            ns = "#" + n;
        }
        return ns;
    }

    protected void init() throws EdgeOutOfRangeException, FileNotFoundException, Exception {
        int pos;
        String extension;
        String fullPath;
        this.m_oldViewTypeExported = this.getViewTypeExported();
        this.m_prwriter = null;
        this.m_ostream = null;
        this.m_mainZipName = null;
        this.m_zipOutputStream = null;
        this.m_tempZipOutputStream = null;
        this.m_tempByteArrayOutputStream = null;
        this.m_tempByteArray = null;
        this.m_mainURL = null;
        this.m_storageGroup = null;
        this.m_storage = null;
        this.m_tempStorage = null;
        this.m_pages = new Vector();
        this.m_storages = new Vector();
        this.m_pageTitles = new Vector();
        this.m_pageViewTypes = new Vector();
        this.m_pageDims = new Vector();
        this.m_exportPage = 1;
        this.m_totalExportPages = this.getTotalExportPages();
        this.m_rowsOnSheet = 0;
        this.m_styleList = new ArrayList();
        this.m_colorHashMap = new HashMap();
        this.m_paletteIndexUsed = new boolean[GridViewExcelHTMLExport.getMaxColorPaletteSize()];
        int c = 0;
        while (c < this.m_paletteIndexUsed.length) {
            this.m_paletteIndexUsed[c] = c == 0 || c == 1;
            ++c;
        }
        this.m_colorPalette = new int[GridViewExcelHTMLExport.getMaxColorPaletteSize()];
        int c2 = 0;
        while (c2 < this.m_colorPalette.length) {
            this.m_colorPalette[c2] = DEFAULT_PALETTE[c2];
            ++c2;
        }
        this.initCommon();
        this.m_currPage = 1;
        this.m_currGraph = 1;
        if (this._getOutputMode() == 3 || this.m_combineOutput && this._getTempFileOutputMode() == 3) {
            this.m_storageGroup = this.m_storageCallback.createStorageGroup();
        }
        if ((fullPath = this.getPath()) == null) {
            fullPath = "";
        }
        if (fullPath.length() > 0 && !fullPath.endsWith(File.separator)) {
            fullPath = fullPath + File.separator;
        }
        this.m_mainPath = this._getOutputMode() == 1 ? fullPath : "";
        this.m_mainExportName = this.getFileName();
        if (this._getOutputMode() == 2 && this.m_mainExportName.endsWith(".zip")) {
            this.m_mainExportName = this.m_mainExportName.substring(0, this.m_mainExportName.length() - 4) + ".htm";
        }
        this.m_bMainJSP = (extension = this.m_mainExportName.substring(this.m_mainExportName.length() - 4, this.m_mainExportName.length())).equalsIgnoreCase(".jsp");
        this.m_mainDirExt = this._getDirectoryExtension(this.m_locale);
        this.m_mainHtmlFile = this.m_mainPath + this.m_mainExportName;
        String fullHtmlFile = fullPath + this.m_mainExportName;
        this.m_currBaseURI = this.getBaseURI();
        if (this.m_currBaseURI != null && !this.m_currBaseURI.endsWith("/")) {
            this.m_currBaseURI = this.m_currBaseURI + "/";
        }
        if (this._getOutputMode() == 3 && this.m_currBaseURI != null) {
            String groupName;
            String connString = this.m_storageGroup.getConnectionString();
            if (connString != null && connString.length() > 0) {
                this.m_currBaseURI = this.m_currBaseURI + URLEncoder.encode(connString) + "/";
            }
            if ((groupName = this.m_storageGroup.getGroupName()) != null && groupName.length() > 0) {
                this.m_currBaseURI = this.m_currBaseURI + URLEncoder.encode(groupName) + "/";
            }
        }
        this.m_mainDirName = (pos = this.m_mainExportName.lastIndexOf(46)) > -1 ? this.m_mainExportName.substring(0, pos) + this.m_mainDirExt : this.m_mainExportName + this.m_mainDirExt;
        this.m_mainDirFile = this.m_mainPath + this.m_mainDirName;
        pos = this.m_mainHtmlFile.lastIndexOf(File.separator);
        this.m_relativeMainFile = pos != -1 ? this.m_mainHtmlFile.substring(pos + 1) : this.m_mainHtmlFile;
        if (this.m_currBaseURI != null) {
            this.m_mainURL = this.m_relativeMainFile = this.m_currBaseURI + this.m_relativeMainFile;
        } else {
            this.m_relativeMainFile = "../" + this.m_relativeMainFile;
        }
        pos = this.m_mainDirFile.lastIndexOf(File.separator);
        this.m_relativeDirFile = pos != -1 ? this.m_mainDirFile.substring(pos + 1) : this.m_mainDirFile;
        if (this.m_currBaseURI != null) {
            this.m_relativeDirFile = this.m_currBaseURI + this.m_relativeDirFile;
        }
        this.m_mainTempName = this._getTempFileOutputMode() == 1 ? this.makeTempFileName(fullPath, MAIN_TEMP_EXTENSION) : this.makeTempFileName("", MAIN_TEMP_EXTENSION);
        if (!(this._getOutputMode() != 1 && this._getTempFileOutputMode() != 1 || this.checkForExistence())) {
            if (this._getOutputMode() == 1 && !this.m_combineOutput) {
                this.makeOutputFolder(this.m_mainDirFile);
            } else if (this._getTempFileOutputMode() == 1) {
                File mainTempFile = new File(this.m_mainTempName);
                mainTempFile.deleteOnExit();
            }
        }
        if (this._getOutputMode() == 2) {
            OutputStream os = this.getOutputStream();
            if (os == null) {
                this.m_mainZipName = fullHtmlFile;
                int extIndex = this.m_mainZipName.lastIndexOf(".");
                if (extIndex > -1) {
                    this.m_mainZipName = this.m_mainZipName.substring(0, extIndex);
                }
                this.m_mainZipName = this.m_mainZipName + ".zip";
                os = new FileOutputStream(this.m_mainZipName);
            }
            this.m_zipOutputStream = new ZipOutputStream(os);
            this.m_zipOutputStream.setMethod(8);
            this.m_zipOutputStream.setLevel(9);
        }
        if (this.m_combineOutput && this._getTempFileOutputMode() == 2) {
            this.m_tempByteArrayOutputStream = new ByteArrayOutputStream();
            this.m_tempZipOutputStream = new ZipOutputStream(this.m_tempByteArrayOutputStream);
            this.m_tempZipOutputStream.setMethod(8);
            this.m_tempZipOutputStream.setLevel(9);
        }
    }

    protected void initCommon() {
        this.m_bCanceled = false;
        this.m_pageHPos = null;
        this.m_pageSlice = -1;
        if (this.m_gridView != null && (this.getViewTypeExported() & 3) != 0) {
            this.m_decSeparator = String.valueOf(this.m_gridView.getViewFormat().getDecimalSeparatorSymbol());
            this.m_grpSeparator = String.valueOf(this.m_gridView.getViewFormat().getThousandSeparatorSymbol());
            this.m_formatMgr = this.m_gridView.getGridViewFormatManager();
            this.m_databodyStyleMgr = this.m_gridView.getGridViewDatabodyStyleManager();
            this.m_headerStyleMgr = this.m_gridView.getGridViewHeaderStyleManager();
            this.m_clearDatabodyViewStyle = (ViewStyle)this.m_gridView.getDatabodyViewStyle().clone();
            boolean bEditBackgroundUsed = this.m_clearDatabodyViewStyle.isEditBackgroundUsed();
            boolean bEditForegroundUsed = this.m_clearDatabodyViewStyle.isEditForegroundUsed();
            this.m_clearDatabodyViewStyle.clearUsedBits();
            this.m_clearDatabodyViewStyle.setEditBackgroundUsed(bEditBackgroundUsed);
            this.m_clearDatabodyViewStyle.setEditForegroundUsed(bEditForegroundUsed);
            this.m_clearColHeaderViewStyle = (ViewStyle)this.m_gridView.getColumnHeaderViewStyle().clone();
            this.m_clearColHeaderViewStyle.clearUsedBits();
            this.m_clearRowHeaderViewStyle = (ViewStyle)this.m_gridView.getRowHeaderViewStyle().clone();
            this.m_clearRowHeaderViewStyle.clearUsedBits();
            this.m_clearPagingControlViewStyle = (ViewStyle)this.m_gridView.getPagingControlViewStyle().clone();
            this.m_clearPagingControlViewStyle.clearUsedBits();
            this.m_databodyCSSStyle = this.createDatabodyCSSStyle();
            this.populateStyleList(this.m_gridView);
        }
        if (this.getExportableGraph() != null && (this.getViewTypeExported() & 4) != 0) {
            this.m_clearGraphPagingControlViewStyle = (ViewStyle)this.getExportableGraph().getPagingControlViewStyle().clone();
            this.m_clearGraphPagingControlViewStyle.clearUsedBits();
            this.populateStyleList(this.getExportableGraph());
        }
        this.m_combineOutput = this.getPagesPerSheet() == 0;
        this.m_genTOC = this.m_combineOutput ^ true;
    }

    protected void term(boolean abort) throws IOException, Exception {
        if (this.m_combineOutput) {
            this.genSheetFooter();
        }
        this.makeOutputStream(null, false);
        if (!abort && !this.isCanceled()) {
            if (!this.m_combineOutput) {
                if (this.m_genTOC && this.makeOutputStreamInFolder(FILE_TOPSHEET, false)) {
                    this.genTOC();
                    this.makeOutputStream(null, false);
                }
                if (this.makeOutputStreamInFolder(FILE_TABSTRIP, false) && !this.isCanceled()) {
                    this.genTabStrip(this.m_currPage);
                    this.makeOutputStream(null, false);
                }
                if (this.makeOutputStreamInFolder(FILE_STYLESHEET, false) && !this.isCanceled()) {
                    this.genStyleSheet();
                    this.makeOutputStream(null, false);
                }
                if (this.makeOutputStreamInFolder(FILE_FILELIST, false) && !this.isCanceled()) {
                    this.genFileList(this.m_currPage);
                    this.makeOutputStream(null, false);
                }
                if (this.makeOutputStream(this.m_mainHtmlFile, false) && !this.isCanceled()) {
                    this.genBaseExport();
                    this.makeOutputStream(null, false);
                }
            } else {
                BufferedReader in = this.openInputStream(this.m_mainTempName);
                if (in != null) {
                    boolean finished = false;
                    if (this.makeOutputStream(this.m_mainHtmlFile, false)) {
                        String _line;
                        boolean _checkForStyleListInsertion = true;
                        boolean _checkForPaletteInsertion = true;
                        while (!this.isCanceled() && (_line = in.readLine()) != null) {
                            if (_checkForStyleListInsertion && _line.equals(INSERT_STYLELIST)) {
                                this.genStyleSheet();
                                _checkForStyleListInsertion = false;
                                continue;
                            }
                            if (_checkForPaletteInsertion && _line.equals(INSERT_PALETTE)) {
                                String colorPalette = this._createColorPaletteXML();
                                if (colorPalette != null) {
                                    this.out(colorPalette + "\n");
                                }
                                _checkForPaletteInsertion = false;
                                continue;
                            }
                            this.out(new String(_line + "\n"));
                        }
                        this.makeOutputStream(null, false);
                        finished = true;
                    } else {
                        this.m_eh.log("error creating export file " + this.m_mainHtmlFile, this.getClass().getName(), m_method_term);
                    }
                    this._closeInputStream(in);
                    in = null;
                    if (finished && this._getTempFileOutputMode() == 1) {
                        this.deleteFile(this.m_mainTempName);
                    }
                } else {
                    this.m_eh.log("error opening input stream to temp file", this.getClass().getName(), m_method_term);
                }
            }
            if (this._getOutputMode() == 3) {
                String currEncoding = this.getCharacterEncoding();
                this.setCharacterEncoding(DEFAULT_CHARACTER_ENCODING);
                if (this.makeOutputStream(FILE_ENCODING, false) && !this.isCanceled()) {
                    this.out(currEncoding);
                    this.makeOutputStream(null, false);
                }
                this.setCharacterEncoding(currEncoding);
            }
        }
        if (this.m_zipOutputStream != null) {
            this.m_zipOutputStream.finish();
        }
        if (this._getOutputMode() == 2 && this.getOutputStream() == null) {
            this.m_zipOutputStream.close();
        }
        this.m_zipOutputStream = null;
        if (this.m_tempZipOutputStream != null) {
            this.m_tempZipOutputStream.finish();
            this.m_tempZipOutputStream.close();
        }
        this.m_tempZipOutputStream = null;
        if (this.isCanceled() || abort) {
            if (this.m_pages != null) {
                int i = 0;
                while (i < this.m_pages.size()) {
                    this.deleteFile((String)this.m_pages.elementAt(i));
                    ++i;
                }
                this.deleteFile(this.m_mainDirFile);
            }
            if (this._getOutputMode() == 2 && this.m_mainZipName != null) {
                this.deleteFile(this.m_mainZipName);
            }
            if (this.m_storages != null) {
                int i = 0;
                while (i < this.m_storages.size()) {
                    ((Storage)this.m_storages.elementAt(i)).delete();
                    ++i;
                }
            }
        }
        if (this.m_tempStorage != null) {
            this.m_tempStorage.delete();
            this.m_tempStorage = null;
        }
        if (this.m_storageGroup != null) {
            this.m_storageGroup.close();
            this.m_storageGroup = null;
        }
        this.m_storage = null;
        if (this.m_pages != null) {
            int i = 0;
            while (i < this.m_pages.size()) {
                this.m_pages.set(i, null);
                ++i;
            }
        }
        if (this.m_storages != null) {
            int i = 0;
            while (i < this.m_storages.size()) {
                this.m_storages.set(i, null);
                ++i;
            }
        }
        this.m_pages = null;
        this.m_storages = null;
        this.m_totalExportPages = -1;
    }

    protected void termDependentExport(boolean abort) throws IOException, Exception {
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExport() throws Exception {
        block36: {
            block34: {
                block35: {
                    exception = null;
                    if (this.m_gridView != null && (this.getViewTypeExported() & 3) != 0 && !this.m_gridView.startExport()) {
                        this.m_eh.log("GridViewCommon.startExport() returned false - unable to export", this.getClass().getName(), "doExport");
                        return;
                    }
                    if (this.getExportableGraph() != null && (this.getViewTypeExported() & 4) != 0 && !this.m_exportableGraph.startExport()) {
                        this.m_eh.log("ExportableGraph.startExport() returned false - unable to export", this.getClass().getName(), "doExport");
                        return;
                    }
                    try {
                        block38: {
                            block37: {
                                this.init();
                                if (this.getExportPageRange() != 1) break block37;
                                this.exportPage(false);
                                if (this.getDependentExports() == null) break block34;
                                i = 0;
                                ** GOTO lbl111
                            }
                            if (this.getExportPageRange() != 0) break block38;
                            view = null;
                            view = this.isExportingUnlinkedViews() == false ? this.getDataviewCommon() : (this.getGraphPositionOnPage() == 0 ? this.getExportableGraph().getDataviewCommon() : this.m_gridView);
                            da = view.getModel().getDataAccess();
                            dd = view.getModel().getDataDirector();
                            currHPos = da.getEdgeCurrentHPos(2);
                            firstHPos = da.getFirstHPos(2);
                            totalSheets = this._calcTotalExportSheets();
                            maxPageSheets = this._calcTotalExportPageSheets();
                            v0 = bTooManySheets = totalSheets > GridViewExcelHTMLExport.getMaxAllowedSheets();
                            if (bTooManySheets) {
                                maxPageSheets -= totalSheets - GridViewExcelHTMLExport.getMaxAllowedSheets();
                                this.m_eh.log("too many sheets - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedSheets(), this.getClass().getName(), "doExport");
                            }
                            bSuccess = true;
                            if (!GridViewUtils.equalsHPos(currHPos, firstHPos)) {
                                bSuccess = this._setLogicalPage(firstHPos, view);
                            }
                            sheetsDone = 0;
                            if (this.isExportingUnlinkedViews()) {
                                if (this.getGraphPositionOnPage() == 0) {
                                    this.setViewTypeExported(4);
                                } else {
                                    this.setViewTypeExported(3);
                                }
                            }
                            if (!bSuccess || this.isCanceled()) break block35;
                            this.exportPage(false);
                            ++sheetsDone;
                            hPos = firstHPos;
                            ** GOTO lbl118
                        }
                        if (this.getExportPageList() == null) {
                            this.m_eh.log("null ExportPageList", this.getClass().getName(), "doExport");
                            break block34;
                        }
                        if (this.getExportPageList().isEmpty()) {
                            this.m_eh.log("empty ExportPageList", this.getClass().getName(), "doExport");
                            break block34;
                        }
                        da = this.getDataviewCommon().getModel().getDataAccess();
                        iterator = this.getExportPageList().iterator();
                        bFirst = true;
                        totalSheets = this._calcTotalExportSheets();
                        maxPageSheets = this._calcTotalExportPageSheets();
                        v1 = bTooManySheets = totalSheets > GridViewExcelHTMLExport.getMaxAllowedSheets();
                        if (bTooManySheets) {
                            maxPageSheets -= totalSheets - GridViewExcelHTMLExport.getMaxAllowedSheets();
                            this.m_eh.log("too many sheets - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedSheets(), this.getClass().getName(), "doExport");
                        }
                        sheetsDone = 0;
                        while (!(!iterator.hasNext() || this.isCanceled() || bTooManySheets && sheetsDone >= maxPageSheets)) {
                            block42: {
                                block40: {
                                    block41: {
                                        block39: {
                                            hPos = null;
                                            obj = iterator.next();
                                            if (!(obj instanceof int[])) break block39;
                                            hPos = (int[])obj;
                                            bSuccess = true;
                                            if (!bFirst) break block40;
                                            break block41;
                                        }
                                        this.m_eh.log("non-hPos element of ExportPageList", this.getClass().getName(), "doExport");
                                        continue;
                                    }
                                    currHPos = da.getEdgeCurrentHPos(2);
                                    if (!GridViewUtils.equalsHPos(currHPos, hPos)) {
                                        bSuccess = this._setLogicalPage(hPos);
                                    }
                                    bFirst = false;
                                    break block42;
                                }
                                bSuccess = this._setLogicalPage(hPos);
                            }
                            if (!bSuccess) continue;
                            this.exportPage(false);
                            ++sheetsDone;
                        }
                        break block34;
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                    break block34;
                    finally {
                        if (this.m_oldViewTypeExported != this.getViewTypeExported()) {
                            this.setViewTypeExported(this.m_oldViewTypeExported);
                        }
                    }
                    while (!this.isCanceled()) {
                        if (this.getDependentExports()[i] == null) {
                            this.m_eh.log("unable to export - null export engine provider", this.getClass().getName(), "doExport");
                        } else {
                            map = new HashMap<String, Integer>();
                            map.put("D_E_I", new Integer(i));
                            this.m_currentDependentExport = this.getDependentExports()[i].getGridViewExcelHTMLExport(map);
                            if (this.m_currentDependentExport == null) {
                                this.m_eh.log("unable to export - null dependent export engine returned", this.getClass().getName(), "doExport");
                            } else {
                                GridViewExcelHTMLExport.copyState(this, this.m_currentDependentExport);
                                this.m_currentDependentExport.setViewIndex(i + 1);
                                this.m_currentDependentExport.doDependentExport();
                                GridViewExcelHTMLExport.copyState(this.m_currentDependentExport, this);
                                this.getDependentExports()[i].releaseGridViewExcelHTMLExport(this.m_currentDependentExport);
                                this.m_currentDependentExport = null;
                            }
                        }
                        ++i;
lbl111:
                        // 2 sources

                        if (i < this.getDependentExports().length) continue;
                        break block34;
                    }
                    break block34;
                    while (!bTooManySheets || sheetsDone < maxPageSheets) {
                        if (this._setLogicalPage(hPos, view)) {
                            this.exportPage(false);
                            ++sheetsDone;
                        }
lbl118:
                        // 4 sources

                        if ((hPos = da.getNextHPos(2, hPos)) != null && !this.isCanceled()) continue;
                    }
                    this._setLogicalPage(currHPos, view);
                }
                if (!this.isExportingUnlinkedViews() || !bSuccess || this.isCanceled()) break block34;
                if (this.getGraphPositionOnPage() == 0) {
                    this.setViewTypeExported(3);
                    view = this.m_gridView;
                } else {
                    this.setViewTypeExported(4);
                    view = this.getExportableGraph().getDataviewCommon();
                }
                da = view.getModel().getDataAccess();
                dd = view.getModel().getDataDirector();
                currHPos = da.getEdgeCurrentHPos(2);
                firstHPos = da.getFirstHPos(2);
                if (!GridViewUtils.equalsHPos(currHPos, firstHPos)) {
                    bSuccess = this._setLogicalPage(firstHPos, view);
                }
                if (!bSuccess || this.isCanceled()) break block34;
                this.exportPage(false);
                ++sheetsDone;
                hPos = firstHPos;
                while ((hPos = da.getNextHPos(2, hPos)) != null && !this.isCanceled()) {
                    if (bTooManySheets && sheetsDone >= maxPageSheets) break;
                    if (!this._setLogicalPage(hPos, view)) continue;
                    this.exportPage(false);
                    ++sheetsDone;
                }
                this._setLogicalPage(currHPos, view);
            }
            try {
                bAbort = exception != null;
                this.term(bAbort);
            }
            catch (Exception e) {
                if (exception != null) break block36;
                exception = e;
            }
        }
        if (this.m_gridView != null && (this.getViewTypeExported() & 3) != 0) {
            this.m_gridView.endExport();
        }
        if (this.getExportableGraph() != null && (this.getViewTypeExported() & 4) != 0) {
            this.m_exportableGraph.endExport();
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void doDependentExport() throws Exception {
        Exception exception;
        block9: {
            exception = null;
            if (this.m_gridView != null && (this.getViewTypeExported() & 3) != 0 && !this.m_gridView.startExport()) {
                this.m_eh.log("GridViewCommon.startExport() returned false - unable to export", this.getClass().getName(), "doDependentExport");
                return;
            }
            if (this.getExportableGraph() != null && (this.getViewTypeExported() & 4) != 0 && !this.m_exportableGraph.startExport()) {
                this.m_eh.log("ExportableGraph.startExport() returned false - unable to export", this.getClass().getName(), m_method_doExport);
                return;
            }
            try {
                this.initCommon();
                this.exportPage(true);
            }
            catch (Exception e) {
                exception = e;
            }
            try {
                boolean bAbort = exception != null;
                this.termDependentExport(bAbort);
            }
            catch (Exception e) {
                if (exception != null) break block9;
                exception = e;
            }
        }
        if (this.m_gridView != null && (this.getViewTypeExported() & 3) != 0) {
            this.m_gridView.endExport();
        }
        if (this.getExportableGraph() != null && (this.getViewTypeExported() & 4) != 0) {
            this.m_exportableGraph.endExport();
        }
        if (exception != null) {
            throw exception;
        }
    }

    private boolean _setLogicalPage(int[] hPos) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        return this._setLogicalPage(hPos, this.getDataviewCommon());
    }

    private boolean _setLogicalPage(int[] hPos, DataviewCommon view) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        int maxLayerSpecified = -1;
        if (hPos != null) {
            maxLayerSpecified = hPos.length - 1;
        }
        boolean bSuccess = true;
        DataDirector dd = view.getModel().getDataDirector();
        bSuccess = dd.changeEdgeCurrentHPos(2, hPos, maxLayerSpecified);
        this.m_pageHPos = hPos;
        this.m_pageSlice = -1;
        return bSuccess;
    }

    protected void exportPage(boolean bDependentExport) throws IOException, EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, RowOutOfRangeException, ColumnOutOfRangeException, Exception {
        int startCol = 0;
        int endCol = 0;
        int startRow = 0;
        int endRow = 0;
        if (this.m_gridView != null && (this.getViewTypeExported() & 3) != 0) {
            DataAccess da = this.m_gridView.getModel().getDataAccess();
            endCol = da.getEdgeExtent(0) - 1;
            endRow = da.getEdgeExtent(1) - 1;
        }
        this.exportPage(startCol, endCol, startRow, endRow, bDependentExport);
    }

    protected void exportPage(int startColSlice, int endColSlice, int startRowSlice, int endRowSlice, boolean bDependentExport) throws IOException, EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, RowOutOfRangeException, ColumnOutOfRangeException, Exception {
        boolean bExportBottomFT;
        boolean bTooManyColumns;
        if (this.isCanceled()) {
            return;
        }
        if (!bDependentExport && this.getPagesPerSheet() == 1) {
            this.m_rowsOnSheet = 0;
        } else if (this.m_rowsOnSheet >= GridViewExcelHTMLExport.getMaxAllowedRows()) {
            this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), m_method_exportPage2);
            return;
        }
        if (this.getWorksheetLabels() != null) {
            if (this.m_currPage == 1) {
                this.m_pageDims.addElement(this.m_resourceBundle.getString("Worksheet"));
            }
            String name = null;
            if (this.m_viewIndex < this.getWorksheetLabels().length) {
                name = this.getWorksheetLabels()[this.m_viewIndex];
            }
            if (name == null) {
                name = this.m_resourceBundle.getString("Unknown");
            }
            this.m_pageTitles.addElement(name);
        }
        int colCount = 0;
        int rowCount = 0;
        int colHeaderRowCount = 0;
        int rowHeaderColCount = 0;
        int pageLayerCount = 0;
        int startCol = -1;
        int endCol = -1;
        int startRow = -1;
        int endRow = -1;
        boolean bExportGridView = this.m_gridView != null && (this.getViewTypeExported() & 3) != 0;
        boolean bExportGraph = this.getExportableGraph() != null && (this.getViewTypeExported() & 4) != 0;
        int graphPageLayerCount = 0;
        if (bExportGridView) {
            DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
            colCount = dataAccess.getEdgeExtent(0);
            rowCount = dataAccess.getEdgeExtent(1);
            pageLayerCount = dataAccess.getLayerCount(2);
            colHeaderRowCount = this.getColumnHeaderRowCount();
            rowHeaderColCount = this.getRowHeaderColumnCount();
            startCol = startColSlice;
            endCol = endColSlice;
            startRow = startRowSlice;
            endRow = endRowSlice;
            if (startCol < 0) {
                startCol = 0;
            }
            if (endCol >= colCount) {
                endCol = colCount - 1;
            }
            if (startRow < 0) {
                startRow = 0;
            }
            if (endRow >= rowCount) {
                endRow = rowCount - 1;
            }
            colCount = endCol - startCol + 1;
            rowCount = endRow - startRow + 1;
            if (bExportGraph) {
                DataAccess graphDA = this.getExportableGraph().getDataviewCommon().getModel().getDataAccess();
                graphPageLayerCount = graphDA.getLayerCount(2);
            }
        } else if (bExportGraph) {
            DataAccess dataAccess = this.getExportableGraph().getDataviewCommon().getModel().getDataAccess();
            graphPageLayerCount = pageLayerCount = dataAccess.getLayerCount(2);
            Dimension size = this.getExportableGraph().getImageSize();
            colCount = Math.round((float)((double)(size.width / 96 * 72) / 48.0));
            rowCount = Math.round((float)((double)(size.height / 96 * 72) / 13.0));
        }
        boolean bl = bTooManyColumns = rowHeaderColCount + colCount > GridViewExcelHTMLExport.getMaxAllowedColumns();
        if (bTooManyColumns) {
            this.m_eh.log("too many columns on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedColumns(), this.getClass().getName(), m_method_exportPage2);
            colCount = GridViewExcelHTMLExport.getMaxAllowedColumns() - rowHeaderColCount;
            endCol = startCol + colCount - 1;
        }
        if (!this.m_combineOutput) {
            String s = this.makeSheetName(this.m_currPage);
            if (s.indexOf(35) != -1) {
                this.m_eh.log("too many sheets - error making sheet name", this.getClass().getName(), m_method_exportPage2);
                return;
            }
            this.makeOutputStreamInFolder(s, false);
            this.genSheetHeader(this.m_currPage);
        } else if (!bDependentExport && this.m_prwriter == null) {
            this.makeOutputStream(this.m_mainTempName, true);
            this.genSingleSheetHeader();
        }
        this.m_totalExportRows = 0;
        this.m_currExportRows = 0;
        if (bExportGridView) {
            if (this.m_gridView.isColumnHeaderVisible() && colHeaderRowCount > 0 && colCount > 0) {
                this.m_totalExportRows += colHeaderRowCount;
            }
            if (this.m_gridView.isRowHeaderVisible() && rowHeaderColCount > 0 && rowCount > 0) {
                this.m_totalExportRows += rowCount;
            }
        }
        if (bExportGraph) {
            this.m_totalExportRows += this.m_exportableGraph.getDataviewCommon().getModel().getDataAccess().getEdgeExtent(1);
            if (this.getOutputMode() == 1) {
                if (this.getPagesPerSheet() == 1) {
                    this.makeOutputFolder(this.makeGraphDirectoryName());
                } else {
                    this.makeOutputFolder(this.m_mainDirFile);
                }
            }
        }
        this._fireExportProgressEvent(this.getTotalExportPages(), this.m_exportPage - 1, 0);
        boolean bExportTopFT = this.m_ft[0] != null && this.m_ft[0].getParsedHTMLText() != null && this.m_ft[0].getParsedHTMLText().length() > 0;
        boolean bl2 = bExportBottomFT = this.m_ft[1] != null && this.m_ft[1].getParsedHTMLText() != null && this.m_ft[1].getParsedHTMLText().length() > 0;
        if (this.isCanceled()) {
            return;
        }
        if (bExportTopFT) {
            if (this.m_rowsOnSheet + 1 > GridViewExcelHTMLExport.getMaxAllowedRows()) {
                this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), m_method_exportPage2);
                return;
            }
            this.exportFT(0, colCount + rowHeaderColCount);
            this.exportBlankRow();
            this.m_rowsOnSheet += 2;
        }
        boolean bSuccess = true;
        if (bExportGraph && this.getGraphPositionOnPage() == 0) {
            bSuccess = this.exportPageHeaderAndTitles(this.m_exportableGraph, graphPageLayerCount, this.m_exportableGraph.isPagingControlVisible(), this.m_exportableGraph.getPagingControlPosition(), colCount + rowHeaderColCount);
            if (!bSuccess) {
                return;
            }
            bSuccess = this.exportGraphTag(this.makeGraphDirectoryName());
            if (this.isCanceled()) {
                return;
            }
            if (!bSuccess) {
                return;
            }
            bSuccess = this.exportFootnote(this.m_exportableGraph.getDataviewCommon(), colCount + rowHeaderColCount);
            if (!bSuccess) {
                return;
            }
            if (this.m_gridView != null && (this.getViewTypeExported() & 3) != 0) {
                this.exportBlankRow();
            }
        }
        if (bExportGridView) {
            bSuccess = this.exportPageHeaderAndTitles(this.m_gridView, pageLayerCount, this.m_gridView.isPagingControlVisible(), this.m_gridView.getPagingControlPosition(), colCount + rowHeaderColCount);
        }
        if (!bSuccess) {
            return;
        }
        if (bExportGridView) {
            this.exportGridView(startCol, endCol, startRow, endRow, colHeaderRowCount, rowHeaderColCount);
        }
        if (this.isCanceled()) {
            return;
        }
        bSuccess = true;
        if (bExportGridView) {
            bSuccess = this.exportFootnote(this.m_gridView, colCount + rowHeaderColCount);
        }
        if (!bSuccess) {
            return;
        }
        if (this.isCanceled()) {
            return;
        }
        if (bExportGraph && this.getGraphPositionOnPage() == 1) {
            this.exportBlankRow();
            bSuccess = this.exportPageHeaderAndTitles(this.m_exportableGraph, graphPageLayerCount, this.m_exportableGraph.isPagingControlVisible(), this.m_exportableGraph.getPagingControlPosition(), colCount + rowHeaderColCount);
            if (!bSuccess) {
                return;
            }
            bSuccess = this.exportGraphTag(this.makeGraphDirectoryName());
            if (this.isCanceled()) {
                return;
            }
            if (!bSuccess) {
                return;
            }
            bSuccess = this.exportFootnote(this.m_exportableGraph.getDataviewCommon(), colCount + rowHeaderColCount);
            if (!bSuccess) {
                return;
            }
        }
        if (this.isCanceled()) {
            return;
        }
        if (bExportBottomFT) {
            if (this.m_rowsOnSheet + 1 > GridViewExcelHTMLExport.getMaxAllowedRows()) {
                this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), m_method_exportPage2);
                return;
            }
            this.exportBlankRow();
            this.exportFT(1, colCount + rowHeaderColCount);
            this.m_rowsOnSheet += 2;
        }
        if (!this.m_combineOutput) {
            this.genSheetFooter();
        } else {
            if (this.m_rowsOnSheet + 1 > GridViewExcelHTMLExport.getMaxAllowedRows()) {
                this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), m_method_exportPage2);
                return;
            }
            this.exportBlankRow();
            ++this.m_rowsOnSheet;
            if (this.m_rowsOnSheet + 1 > GridViewExcelHTMLExport.getMaxAllowedRows()) {
                this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), m_method_exportPage2);
                return;
            }
            this.exportBlankRow();
            ++this.m_rowsOnSheet;
        }
        if (bExportGraph) {
            String dirName = this.makeGraphDirectoryName();
            this.exportGraphFile(dirName);
            if (this.getPagesPerSheet() == 1 || this.m_currPage == this.m_totalExportPages) {
                this.m_pages.addElement(dirName);
            }
            ++this.m_currGraph;
        }
        ++this.m_exportPage;
        ++this.m_currPage;
    }

    protected boolean exportPageHeaderAndTitles(Object exportedObj, int pageLayerCount, boolean bPagingControlVisible, int pagingControlPosition, int columns) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        DataviewCommon view = null;
        if (exportedObj instanceof GridViewCommon) {
            view = (GridViewCommon)exportedObj;
        } else if (exportedObj instanceof ExportableGraph) {
            view = ((ExportableGraph)exportedObj).getDataviewCommon();
        }
        boolean isGridView = view instanceof GridViewCommon;
        boolean bExportPageHeader = pageLayerCount > 0 && bPagingControlVisible;
        boolean bGetPageMetadata = bExportPageHeader || this.m_genTOC;
        boolean bExportTitle = view.getDataviewTitle().isVisible() && view.getDataviewTitle().getText() != null && view.getDataviewTitle().getText().length() > 0;
        boolean bExportSubtitle = view.getDataviewSubtitle().isVisible() && view.getDataviewSubtitle().getText() != null && view.getDataviewSubtitle().getText().length() > 0;
        boolean bTooManyRows = false;
        if (pagingControlPosition == 0) {
            if (bExportPageHeader) {
                if (this.m_rowsOnSheet + pageLayerCount > GridViewExcelHTMLExport.getMaxAllowedRows()) {
                    bTooManyRows = true;
                    pageLayerCount = GridViewExcelHTMLExport.getMaxAllowedRows() - this.m_rowsOnSheet;
                }
                this.exportPageHeader(exportedObj, pageLayerCount, columns, true);
                this.m_rowsOnSheet += pageLayerCount;
                if (bTooManyRows) {
                    this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), "exportPageHeaderAndTitles");
                    return false;
                }
            } else if (bGetPageMetadata) {
                this.exportPageHeader(exportedObj, pageLayerCount, columns, false);
            }
            if (bExportPageHeader && (bExportTitle || bExportSubtitle)) {
                if (this.m_rowsOnSheet + 1 > GridViewExcelHTMLExport.getMaxAllowedRows()) {
                    this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), "exportPageHeaderAndTitles");
                    return false;
                }
                this.exportBlankRow();
                ++this.m_rowsOnSheet;
            }
            if (bExportTitle) {
                if (this.m_rowsOnSheet + 1 > GridViewExcelHTMLExport.getMaxAllowedRows()) {
                    this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), "exportPageHeaderAndTitles");
                    return false;
                }
                this.handleLabel(view.getDataviewTitle().getText(), this.getStyleClass(isGridView ? TITLE_STYLE_CLASS : GRAPH_TITLE_STYLE_CLASS), columns);
                ++this.m_rowsOnSheet;
            }
            if (bExportSubtitle) {
                if (this.m_rowsOnSheet + 1 > GridViewExcelHTMLExport.getMaxAllowedRows()) {
                    this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), "exportPageHeaderAndTitles");
                    return false;
                }
                this.handleLabel(view.getDataviewSubtitle().getText(), this.getStyleClass(isGridView ? SUBTITLE_STYLE_CLASS : GRAPH_SUBTITLE_STYLE_CLASS), columns);
                ++this.m_rowsOnSheet;
            }
        } else {
            if (bExportTitle) {
                if (this.m_rowsOnSheet + 1 > GridViewExcelHTMLExport.getMaxAllowedRows()) {
                    this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), "exportPageHeaderAndTitles");
                    return false;
                }
                this.handleLabel(view.getDataviewTitle().getText(), this.getStyleClass(isGridView ? TITLE_STYLE_CLASS : GRAPH_TITLE_STYLE_CLASS), columns);
                ++this.m_rowsOnSheet;
            }
            if (bExportSubtitle) {
                if (this.m_rowsOnSheet + 1 > GridViewExcelHTMLExport.getMaxAllowedRows()) {
                    this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), "exportPageHeaderAndTitles");
                    return false;
                }
                this.handleLabel(view.getDataviewSubtitle().getText(), this.getStyleClass(isGridView ? SUBTITLE_STYLE_CLASS : GRAPH_SUBTITLE_STYLE_CLASS), columns);
                ++this.m_rowsOnSheet;
            }
            if (bExportPageHeader && (bExportTitle || bExportSubtitle)) {
                if (this.m_rowsOnSheet + 1 > GridViewExcelHTMLExport.getMaxAllowedRows()) {
                    this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), "exportPageHeaderAndTitles");
                    return false;
                }
                this.exportBlankRow();
                ++this.m_rowsOnSheet;
            }
            if (bExportPageHeader) {
                if (this.m_rowsOnSheet + pageLayerCount > GridViewExcelHTMLExport.getMaxAllowedRows()) {
                    bTooManyRows = true;
                    pageLayerCount = GridViewExcelHTMLExport.getMaxAllowedRows() - this.m_rowsOnSheet;
                }
                this.exportPageHeader(exportedObj, pageLayerCount, columns, true);
                this.m_rowsOnSheet += pageLayerCount;
                if (bTooManyRows) {
                    this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), "exportPageHeaderAndTitles");
                    return false;
                }
            } else if (bGetPageMetadata) {
                this.exportPageHeader(exportedObj, pageLayerCount, columns, false);
            }
        }
        if (this.isCanceled()) {
            return false;
        }
        if (bExportPageHeader || bExportTitle || bExportSubtitle) {
            if (this.m_rowsOnSheet + 1 > GridViewExcelHTMLExport.getMaxAllowedRows()) {
                this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), "exportPageHeaderAndTitles");
                return false;
            }
            this.exportBlankRow();
            ++this.m_rowsOnSheet;
        }
        return true;
    }

    protected boolean exportFootnote(DataviewCommon view, int columns) {
        boolean bExportFootnote;
        boolean bl = bExportFootnote = view.getDataviewFootnote().isVisible() && view.getDataviewFootnote().getText() != null && view.getDataviewFootnote().getText().length() > 0;
        if (bExportFootnote) {
            if (this.m_rowsOnSheet + 2 > GridViewExcelHTMLExport.getMaxAllowedRows()) {
                this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), "exportFootnote");
                return false;
            }
            this.exportBlankRow();
            this.handleLabel(view.getDataviewFootnote().getText(), this.getStyleClass(view instanceof GridViewCommon ? FOOTNOTE_STYLE_CLASS : GRAPH_FOOTNOTE_STYLE_CLASS), columns);
            this.m_rowsOnSheet += 2;
        }
        return true;
    }

    protected void exportPageHeader(Object exportedObj, int pageLayerCount, int columns, boolean bVisible) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        DataviewCommon view = null;
        if (exportedObj instanceof GridViewCommon) {
            view = (GridViewCommon)exportedObj;
        } else if (exportedObj instanceof ExportableGraph) {
            view = ((ExportableGraph)exportedObj).getDataviewCommon();
        }
        DataAccess dataAccess = view.getModel().getDataAccess();
        String sName = "";
        int i = 0;
        while (i < pageLayerCount) {
            String memberLabelType;
            if (this.isCanceled()) {
                return;
            }
            Object layerLabel = null;
            Object memberLabel = null;
            String label = null;
            int[] hPos = dataAccess.getEdgeCurrentHPos(2);
            String layerLabelType = view.getLayerMetadataLabelType(2);
            if (view.isLayerMetadataLabelTypeSupported(layerLabelType)) {
                layerLabel = dataAccess.getLayerMetadata(2, i, layerLabelType);
            }
            if (i < hPos.length && hPos[i] > -1 && view.isMemberMetadataLabelTypeSupported(memberLabelType = view.getMemberMetadataLabelType(2))) {
                memberLabel = dataAccess.getMemberMetadata(2, hPos, i, hPos[i], memberLabelType);
            }
            if (layerLabel != null) {
                label = layerLabel.toString();
                label = label + ":";
            }
            if (memberLabel != null) {
                label = label != null ? label + memberLabel.toString() : ":" + memberLabel.toString();
            }
            if (bVisible) {
                ViewStyle initStyle = null;
                ViewStyle viewStyle = null;
                if (exportedObj instanceof GridViewCommon) {
                    initStyle = this.getClearPagingControlViewStyle();
                    viewStyle = this.m_headerStyleMgr.getMetadataStyle((GridViewCommon)view, memberLabel, initStyle, 2, i, this.getPageSlice(dataAccess));
                } else if (exportedObj instanceof ExportableGraph) {
                    initStyle = this.getClearGraphPagingControlViewStyle();
                    viewStyle = ((ExportableGraph)exportedObj).getMetadataStyle(memberLabel, initStyle, 2, i, this.getPageSlice(dataAccess));
                }
                CSSStyle style = null;
                if (viewStyle != null && viewStyle.isAnythingOverridden()) {
                    EdgeComponentHandle handle = new EdgeComponentHandle(4, "PageItem", view, 2, i, this.getPageSlice(dataAccess));
                    style = this.convertViewStyleToCSSStyle(viewStyle, handle);
                }
                this.handleLabel(label, this.getStyleClass(view instanceof GridViewCommon ? PAGE_HEADER_STYLE_CLASS : GRAPH_PAGE_HEADER_STYLE_CLASS), style, columns);
            }
            if (this.getWorksheetLabels() == null && label != null) {
                String s2;
                int pos;
                String sText = label;
                if ((this.m_currPage == 1 || this.isExportingUnlinkedViews()) && (pos = sText.indexOf(58)) > -1 && !this.m_pageDims.contains(s2 = sText.substring(0, pos))) {
                    this.m_pageDims.addElement(s2);
                }
                sName = i == 0 && sName.equals("") ? sText : sName + "\n" + sText;
            }
            ++i;
        }
        if (this.getWorksheetLabels() == null) {
            if (sName == null) {
                sName = this.m_resourceBundle.getString("Unknown");
            }
            if (!this.isExportingUnlinkedViews()) {
                if (!this.m_pageTitles.contains(sName)) {
                    this.m_pageTitles.addElement(sName);
                }
            } else {
                this.m_pageTitles.addElement(sName);
                this.m_pageViewTypes.addElement(new Integer(view.getViewType()));
            }
        }
    }

    protected void exportGridView(int startCol, int endCol, int startRow, int endRow, int colHeaderRowCount, int rowHeaderColCount) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, RowOutOfRangeException, ColumnOutOfRangeException {
        this.exportGridViewOpen();
        int colCount = endCol - startCol + 1;
        int rowCount = endRow - startRow + 1;
        boolean bExportColumnHeader = this.m_gridView.isColumnHeaderVisible() && colHeaderRowCount > 0 && colCount > 0;
        boolean bExportRowHeader = this.m_gridView.isRowHeaderVisible() && rowHeaderColCount > 0 && rowCount > 0;
        boolean bExportCornerComponent = bExportColumnHeader && bExportRowHeader;
        boolean bExportDatabody = colCount > 0 && rowCount > 0;
        boolean bTooManyRows = false;
        if (bExportColumnHeader) {
            boolean bl = bTooManyRows = this.m_rowsOnSheet + colHeaderRowCount > GridViewExcelHTMLExport.getMaxAllowedRows();
            if (bTooManyRows) {
                this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), m_method_exportGridView);
                colHeaderRowCount = GridViewExcelHTMLExport.getMaxAllowedRows() - this.m_rowsOnSheet;
            }
            int row = 0;
            while (row < colHeaderRowCount) {
                if (this.isCanceled()) {
                    return;
                }
                this.out("  <tr>\n");
                if (row == 0 && bExportCornerComponent) {
                    this.exportCornerComponent(rowHeaderColCount, colHeaderRowCount);
                }
                this.exportColumnHeaderRow(row, startCol, endCol);
                this.out("  </tr>\n");
                ++this.m_rowsOnSheet;
                int percentCurrPageComplete = (int)Math.floor((double)(++this.m_currExportRows) * 100.0 / (double)this.m_totalExportRows);
                this._fireExportProgressEvent(this.getTotalExportPages(), this.m_exportPage - 1, percentCurrPageComplete);
                ++row;
            }
        }
        boolean bl = bTooManyRows = bTooManyRows || this.m_rowsOnSheet + rowCount > GridViewExcelHTMLExport.getMaxAllowedRows();
        if (bTooManyRows) {
            this.m_eh.log("too many rows on a sheet - only exporting first " + GridViewExcelHTMLExport.getMaxAllowedRows(), this.getClass().getName(), m_method_exportGridView);
            rowCount = GridViewExcelHTMLExport.getMaxAllowedRows() - this.m_rowsOnSheet;
            endRow = startRow + rowCount - 1;
        }
        int row = startRow;
        while (row <= endRow) {
            if (this.isCanceled()) {
                return;
            }
            this.out("  <tr>\n");
            if (bExportRowHeader) {
                this.exportRowHeaderRow(row, startRow, endRow, rowHeaderColCount);
            }
            if (bExportDatabody) {
                this.exportDatabodyRow(row, startCol, endCol);
            }
            this.out("  </tr>\n");
            ++this.m_rowsOnSheet;
            int percentCurrPageComplete = (int)Math.floor((double)(++this.m_currExportRows) * 100.0 / (double)this.m_totalExportRows);
            this._fireExportProgressEvent(this.getTotalExportPages(), this.m_exportPage - 1, percentCurrPageComplete);
            ++row;
        }
        this.exportGridViewClose();
        if (this.m_viewStyleMap != null) {
            this.m_viewStyleMap.clear();
            this.m_viewStyleMap = null;
        }
    }

    protected void exportCornerComponent(int colSpan, int rowSpan) {
        StringBuffer rowSB = new StringBuffer();
        rowSB.append("    <td");
        if (this.m_gridView.getCornerComponentColor() != null) {
            String hex = this.colorToHexString(this.m_gridView.getCornerComponentColor().getRGB());
            rowSB.append(" style='background-color:" + hex + "'");
        }
        if (colSpan > 1) {
            rowSB.append(" colspan=");
            rowSB.append(colSpan);
        }
        if (rowSpan > 1) {
            rowSB.append(" rowspan=");
            rowSB.append(rowSpan);
        }
        rowSB.append(">");
        rowSB.append("</td>\n");
        this.out(rowSB.toString());
    }

    public boolean exportGraphTag(String dirName) throws EdgeOutOfRangeException, Exception, FileNotFoundException, IOException, LayerOutOfRangeException, SliceOutOfRangeException {
        String imgFileName = new String(dirName + this.makeGraphFileName(this.m_currGraph));
        if (this.getPagesPerSheet() == 1) {
            imgFileName = "." + imgFileName.substring(this.m_mainDirFile.length());
        } else if (this.getPath() == null) {
            imgFileName = "." + File.separator + imgFileName;
        }
        int colonLoc = imgFileName.indexOf(58);
        if (colonLoc > -1) {
            imgFileName = this.getPath() == null ? "." + imgFileName.substring(colonLoc + 1) : "." + imgFileName.substring(this.getPath().length());
        }
        this.handleGraphTag(imgFileName);
        this.m_rowsOnSheet = (int)((double)this.m_rowsOnSheet + (Math.floor((float)((double)(this.getExportableGraph().getImageSize().height / 96 * 72) / 13.0)) + 1.0));
        return true;
    }

    protected boolean exportGraphFile(String dirName) throws Exception {
        boolean success = false;
        String graphName = new String(dirName + this.makeGraphFileName(this.m_currGraph));
        int outMode = this.getOutputMode();
        OutputStream outStream = null;
        if (outMode == 1) {
            outStream = new FileOutputStream(graphName);
        } else if (outMode == 2) {
            ZipEntry ze = new ZipEntry(graphName);
            this.m_zipOutputStream.putNextEntry(ze);
            outStream = this.m_zipOutputStream;
        } else if (outMode == 3) {
            String filename = graphName.replace(File.separatorChar, '/');
            Storage storage = this.m_storageGroup.createStorage(filename);
            this.m_storages.add(storage);
            outStream = storage.openOutputStream();
        }
        this.m_exportableGraph.exportGraphToStream(outStream);
        if (outMode == 1) {
            outStream.close();
        } else if (outMode == 2) {
            this.m_zipOutputStream.closeEntry();
        } else if (outMode == 3) {
            outStream.close();
        }
        this.m_pages.addElement(graphName);
        int rowCount = this.m_exportableGraph.getDataviewCommon().getModel().getDataAccess().getEdgeExtent(1);
        this.m_currExportRows += rowCount;
        int percentCurrPageComplete = (int)Math.floor((double)this.m_currExportRows * 100.0 / (double)this.m_totalExportRows);
        this._fireExportProgressEvent(this.getTotalExportPages(), this.m_exportPage - 1, percentCurrPageComplete);
        return success;
    }

    protected abstract int getColumnHeaderRowCount() throws EdgeOutOfRangeException;

    protected abstract int getRowHeaderColumnCount() throws EdgeOutOfRangeException;

    protected abstract void exportColumnHeaderRow(int var1, int var2, int var3) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException;

    protected abstract void exportRowHeaderRow(int var1, int var2, int var3, int var4) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException;

    protected void exportDatabodyRow(int row, int startCol, int endCol) throws SliceOutOfRangeException, RowOutOfRangeException, ColumnOutOfRangeException, EdgeOutOfRangeException {
        DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
        StringBuffer rowSB = new StringBuffer(2048);
        int lastFetchedCol = startCol - 1;
        int col = startCol;
        while (col <= endCol) {
            boolean bWaitData;
            if (col > lastFetchedCol) {
                int colBlock = 20;
                if (col + colBlock > endCol) {
                    colBlock = endCol - col;
                }
                lastFetchedCol = this.fetchRowData(dataAccess, row, col, col + colBlock);
            }
            rowSB.append("    <td");
            String styleClass = this.getDatabodyStyleClass(row, col);
            rowSB.append(" class=\"" + styleClass + "\"");
            Object data = null;
            Object rawData = null;
            boolean bDataSuppressed = this.isDataSuppressed(col, row);
            boolean bFormatted = false;
            if (this.m_gridView.isDataUnformattedSupported()) {
                rawData = dataAccess.getValue(row, col, "dataValue");
            }
            if (this.m_gridView.isDataFormattedSupported() && !bDataSuppressed && (data = dataAccess.getValue(row, col, "dataFormattedValue")) != null) {
                bFormatted = true;
            }
            if (!bFormatted) {
                data = rawData;
            }
            ViewFormat viewFormat = null;
            boolean bl = bWaitData = data != null && data instanceof WaitData;
            if (!bWaitData) {
                ViewStyle initStyle = this.getClearDatabodyViewStyle();
                ViewStyle viewStyle = this.m_databodyStyleMgr.getDataStyle(this.m_gridView, rawData, initStyle, row, col, this.getPageHPos(dataAccess));
                DataComponentHandle handle = new DataComponentHandle(12, "DataCell", (Object)this.m_gridView, row, col);
                if (this.m_viewStyleMap == null) {
                    this.m_viewStyleMap = new HashMap(10);
                }
                this.m_viewStyleMap.put(handle.getComponentInfo(), viewStyle);
                boolean bStyleExists = false;
                CSSStyle style = null;
                if (viewStyle != null && (style = this.createDatabodyCSSStyleForExcel(viewStyle, row, col, handle, initStyle, this.getPageHPos(dataAccess))) != null) {
                    bStyleExists = true;
                }
                boolean bFormatExists = false;
                String formatString = null;
                if (!bFormatted && data != null && !bDataSuppressed) {
                    viewFormat = this.m_formatMgr.getDataCellViewFormat(this.m_gridView, row, col);
                    if (viewFormat != null) {
                        if (data instanceof Number && !this.m_gridView.getViewFormat().equals((Object)viewFormat)) {
                            formatString = this.convertViewFormatToExcelNumberFormat(viewFormat, handle, data);
                            if (formatString != null) {
                                formatString = "\"" + formatString + "\"";
                            }
                            if (formatString != null && formatString.equals(this.m_databodyCSSStyle.getProperty("mso-number-format"))) {
                                formatString = null;
                            }
                        } else if (data instanceof Date && (formatString = this.convertViewFormatToExcelDateFormat(viewFormat, handle, data)) != null) {
                            formatString = "\"" + formatString + "\"";
                        }
                    }
                    if (formatString != null) {
                        bFormatExists = true;
                    }
                }
                if (bStyleExists || bFormatExists) {
                    rowSB.append(" style='");
                    if (bStyleExists) {
                        rowSB.append(style.toInlineString());
                    }
                    if (bFormatExists) {
                        if (bStyleExists) {
                            rowSB.append(";");
                        }
                        rowSB.append("mso-number-format:" + formatString);
                    }
                    rowSB.append("'");
                }
                if (!bFormatted && data != null && !bDataSuppressed) {
                    if (data instanceof Number) {
                        Object modData = null;
                        if (viewFormat != null && viewFormat.getNumberType() == 3 && (viewFormat.getScaleFactor() == 0 || viewFormat.getScaleFactor() == 6 && viewFormat.getScaleFactorExponent() == 0)) {
                            modData = this._calcOutputValueForPercents((Number)data);
                        }
                        rowSB.append(" x:num=\"" + (modData != null ? modData.toString() : data.toString()) + "\"");
                    } else if (data instanceof Date) {
                        rowSB.append(" x:num");
                    }
                }
            }
            rowSB.append(">");
            if (data != null && !bDataSuppressed) {
                String s = null;
                s = bWaitData ? ((WaitData)data).getCellMessage() : (data instanceof Date ? data.toString() : (data instanceof Number ? (viewFormat != null ? viewFormat.ObjectToString(data) : data.toString()) : data.toString()));
                if (s != null) {
                    if ((s = this.filterChars(s)).length() > GridViewExcelHTMLExport.getMaxCellContentLength()) {
                        s = s.substring(0, GridViewExcelHTMLExport.getMaxCellContentLength());
                        this.m_eh.log("maximum cell content length exceeded - truncating", this.getClass().getName(), m_method_exportDatabodyRow);
                    }
                    rowSB.append(s);
                }
            }
            rowSB.append("</td>\n");
            ++col;
        }
        this.out(rowSB.toString());
    }

    protected boolean isDataSuppressed(int col, int row) {
        return false;
    }

    protected CSSStyle createDatabodyCSSStyleForExcel(ViewStyle viewStyle, int row, int col, DataComponentHandle handle, ViewStyle initStyle, int[] pageHPos) throws ColumnOutOfRangeException, EdgeOutOfRangeException, RowOutOfRangeException {
        boolean useStyle = false;
        CSSStyle cssStyle = this.convertViewStyleToCSSStyle(viewStyle, handle);
        if (cssStyle == null) {
            cssStyle = (CSSStyle)this.m_databodyCSSStyle.clone();
        } else {
            useStyle = true;
        }
        DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
        DataComponentHandle sideHandle = null;
        Object data = null;
        if (row > 0 && !viewStyle.isBorderStyleUsed(1)) {
            sideHandle = new DataComponentHandle(12, "DataCell", (Object)this.m_gridView, row - 1, col);
            ViewStyle aboveCellStyle = (ViewStyle)this.m_viewStyleMap.get(sideHandle.getComponentInfo());
            if (aboveCellStyle == null) {
                data = dataAccess.getValue(row - 1, col, "dataValue");
                aboveCellStyle = this.m_databodyStyleMgr.getDataStyle(this.m_gridView, data, initStyle, row - 1, col, pageHPos);
            }
            if (aboveCellStyle != null && aboveCellStyle.isBorderStyleUsed(4)) {
                cssStyle.setProperty("border-top", "none");
                useStyle = true;
            }
        }
        if (col > 0 && !viewStyle.isBorderStyleUsed(2)) {
            sideHandle = new DataComponentHandle(12, "DataCell", (Object)this.m_gridView, row, col - 1);
            ViewStyle leftCellStyle = (ViewStyle)this.m_viewStyleMap.get(sideHandle.getComponentInfo());
            if (leftCellStyle == null) {
                data = dataAccess.getValue(row, col - 1, "dataValue");
                leftCellStyle = this.m_databodyStyleMgr.getDataStyle(this.m_gridView, data, initStyle, row, col - 1, pageHPos);
            }
            if (leftCellStyle != null && leftCellStyle.isBorderStyleUsed(8)) {
                cssStyle.setProperty("border-left", "none");
                useStyle = true;
            }
        }
        if (row < dataAccess.getEdgeExtent(1) - 1 && !viewStyle.isBorderStyleUsed(4)) {
            sideHandle = new DataComponentHandle(12, "DataCell", (Object)this.m_gridView, row + 1, col);
            ViewStyle belowCellStyle = (ViewStyle)this.m_viewStyleMap.get(sideHandle.getComponentInfo());
            if (belowCellStyle == null) {
                data = dataAccess.getValue(row + 1, col, "dataValue");
                belowCellStyle = this.m_databodyStyleMgr.getDataStyle(this.m_gridView, data, initStyle, row + 1, col, pageHPos);
            }
            if (belowCellStyle != null && belowCellStyle.isBorderStyleUsed(1)) {
                cssStyle.setProperty("border-bottom", "none");
                useStyle = true;
            }
        }
        if (col < dataAccess.getEdgeExtent(0) - 1 && !viewStyle.isBorderStyleUsed(8)) {
            sideHandle = new DataComponentHandle(12, "DataCell", (Object)this.m_gridView, row, col + 1);
            ViewStyle rightCellStyle = (ViewStyle)this.m_viewStyleMap.get(sideHandle.getComponentInfo());
            if (rightCellStyle == null) {
                data = dataAccess.getValue(row, col + 1, "dataValue");
                rightCellStyle = this.m_databodyStyleMgr.getDataStyle(this.m_gridView, data, initStyle, row, col + 1, pageHPos);
            }
            if (rightCellStyle != null && rightCellStyle.isBorderStyleUsed(2)) {
                cssStyle.setProperty("border-right", "none");
                useStyle = true;
            }
        }
        return useStyle ? cssStyle : null;
    }

    protected String getDatabodyStyleClass(int row, int col) {
        return this.getStyleClass(DATABODY_STYLE_CLASS);
    }

    protected void exportGridViewOpen() {
        StringBuffer tableSB = new StringBuffer(128);
        tableSB.append("\n");
        tableSB.append("<table x:str border=0 cellpadding=0 cellspacing=0");
        tableSB.append(" style='border-collapse:collapse'");
        tableSB.append(">\n");
        this.out(tableSB.toString());
    }

    protected void exportGridViewClose() {
        this.out("</table>\n");
    }

    protected void exportBlankRow() {
        this.out("<br>\n");
    }

    protected ViewStyle getClearDatabodyViewStyle() {
        return this.m_clearDatabodyViewStyle;
    }

    protected ViewStyle getClearColumnHeaderViewStyle() {
        return this.m_clearColHeaderViewStyle;
    }

    protected ViewStyle getClearRowHeaderViewStyle() {
        return this.m_clearRowHeaderViewStyle;
    }

    protected ViewStyle getClearPagingControlViewStyle() {
        return this.m_clearPagingControlViewStyle;
    }

    protected ViewStyle getClearGraphPagingControlViewStyle() {
        return this.m_clearGraphPagingControlViewStyle;
    }

    protected boolean handleLabel(String label, String styleName, int cols) {
        return this.handleLabel(label, styleName, null, cols);
    }

    protected boolean handleLabel(String label, String styleName, CSSStyle style, int cols) {
        boolean exists = false;
        StringBuffer sb_out = new StringBuffer(512);
        if (label != null && sb_out != null) {
            sb_out.append("<table x:str border=0 cellspacing=0 cellpadding=0 width=\"100%\" style='border-collapse:collapse;'>\n");
            sb_out.append("  <tr>\n");
            sb_out.append("    <td");
            if (styleName != null) {
                sb_out.append(" class=\"");
                sb_out.append(styleName);
                sb_out.append("\"");
            }
            if (style != null) {
                sb_out.append(" style='" + style.toInlineString() + "'");
            }
            sb_out.append(" colspan=");
            sb_out.append(cols);
            sb_out.append(">");
            String s = label;
            if (s != null) {
                if ((s = this.filterChars(s)).length() > GridViewExcelHTMLExport.getMaxCellContentLength()) {
                    s = s.substring(0, GridViewExcelHTMLExport.getMaxCellContentLength());
                    this.m_eh.log("maximum cell content length exceeded - truncating", this.getClass().getName(), m_method_handleLabel);
                }
                sb_out.append(s);
            }
            sb_out.append("</td>\n");
            sb_out.append("  </tr>\n");
            sb_out.append("</table>\n");
            this.out(sb_out.toString());
            sb_out = null;
            exists = true;
        }
        return exists;
    }

    protected boolean handleGraphTag(String srcName) {
        boolean success = true;
        Dimension graphSize = this.m_exportableGraph.getImageSize();
        String imgTag = new String("<img height=" + graphSize.height + " src=\"" + srcName + "\">");
        String scrBegin = new String("<script language=\"JavaScript\">");
        String scrEnd = new String("</script>");
        this.out(scrBegin);
        this.out("<!--");
        this.out(scrEnd);
        this.out(imgTag);
        this.out(scrBegin);
        this.out("//-->");
        this.out(scrEnd);
        StringBuffer sbTblTag = new StringBuffer("<table width=100% height=" + graphSize.height + "><tr><td>");
        sbTblTag.append(scrBegin);
        sbTblTag.append("document.write('" + imgTag.replace('\\', '/') + "');");
        sbTblTag.append(scrEnd);
        sbTblTag.append("</td></tr></table>");
        this.out(sbTblTag.toString());
        return success;
    }

    protected String filterChars(String src) {
        String s = null;
        if (src != null) {
            StringBuffer sb = new StringBuffer(512);
            int len = src.length();
            int i = 0;
            while (i < len) {
                char c;
                if ((c = src.charAt(i++)) == '\n') {
                    sb.append("<br>");
                    continue;
                }
                if (c == '<') {
                    sb.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    sb.append("&gt;");
                    continue;
                }
                if (c == '&') {
                    sb.append("&amp;");
                    continue;
                }
                sb.append(c);
            }
            s = sb.toString();
        }
        return s;
    }

    protected boolean checkForExistence() {
        int count = 0;
        boolean rc = false;
        File f = new File(this.m_mainHtmlFile);
        if (f.exists()) {
            ++count;
        }
        if ((f = new File(this.m_mainDirFile)).exists()) {
            ++count;
        }
        if (count > 0 && !rc) {
            f = new File(this.m_mainDirFile);
            if (f.exists() && f.isDirectory()) {
                int unknownFile = 0;
                boolean delFile = false;
                String[] files = f.list();
                int i = 0;
                while (i < files.length) {
                    String sfile = files[i];
                    delFile = false;
                    if (sfile.indexOf(SHEET_PREFIX) > -1 && sfile.lastIndexOf(".htm") > -1) {
                        delFile = true;
                    } else if (sfile.equals(FILE_TABSTRIP)) {
                        delFile = true;
                    } else if (sfile.equals(FILE_STYLESHEET)) {
                        delFile = true;
                    } else if (sfile.equals(FILE_FILELIST)) {
                        delFile = true;
                    }
                    if (delFile) {
                        String filename = new String(this.m_mainDirFile + File.separator + sfile);
                        File fdel = new File(filename);
                        fdel.delete();
                    } else {
                        ++unknownFile;
                    }
                    ++i;
                }
                if (unknownFile == 0) {
                    f.delete();
                }
            }
            if ((f = new File(this.m_mainHtmlFile)).exists() && !f.isDirectory()) {
                f.delete();
            }
        }
        f = null;
        return rc;
    }

    protected String makeTempFileName(String dir, String base) {
        String fname = null;
        boolean ok = false;
        int count = 0;
        while (!ok) {
            String mainName = null;
            int pos = this.m_mainExportName.lastIndexOf(46);
            mainName = pos > -1 ? this.m_mainExportName.substring(0, pos) : this.m_mainExportName;
            String name = dir + mainName + "_" + base + String.valueOf(count) + ".$";
            File f = new File(name);
            if (!f.exists()) {
                fname = name;
                ok = true;
            }
            f = null;
            ++count;
        }
        return fname;
    }

    protected boolean makeOutputFolder(String dirName) {
        boolean rc = false;
        File fdir = new File(dirName);
        fdir.mkdir();
        fdir = null;
        rc = true;
        return rc;
    }

    protected boolean makeOutputStreamInFolder(String name, boolean bTempFile) throws IOException, Exception {
        boolean rc = false;
        String outFile = this.m_mainDirFile + File.separator + name;
        rc = this.makeOutputStream(outFile, bTempFile);
        return rc;
    }

    protected boolean closeCurrentOutputStream() throws IOException, Exception {
        boolean rc = false;
        if (this.m_prwriter != null) {
            this.m_prwriter.flush();
            int outputMode = -1;
            outputMode = this.m_bTempFile ? this._getTempFileOutputMode() : this._getOutputMode();
            if (outputMode == 1) {
                if (this.m_prwriter != this.getPrintWriter() && this.m_ostream == null) {
                    this.m_prwriter.close();
                }
            } else if (outputMode == 2) {
                ZipOutputStream zos = null;
                zos = this.m_bTempFile ? this.m_tempZipOutputStream : this.m_zipOutputStream;
                zos.closeEntry();
                if (this.m_bTempFile) {
                    if (this.m_tempZipOutputStream != null) {
                        this.m_tempZipOutputStream.finish();
                        this.m_tempZipOutputStream.close();
                    }
                    if (this.m_tempByteArrayOutputStream != null) {
                        this.m_tempByteArray = this.m_tempByteArrayOutputStream.toByteArray();
                    }
                    this.m_tempZipOutputStream = null;
                    this.m_tempByteArrayOutputStream = null;
                }
            } else if (outputMode == 3) {
                if (this.m_bTempFile) {
                    this.m_tempStorage.closeWriter();
                } else {
                    this.m_storage.closeWriter();
                }
            }
            this.m_prwriter = null;
        }
        this.m_storage = null;
        this.m_ostream = null;
        if (this.m_fos != null) {
            this.m_fos.close();
            this.m_fos = null;
        }
        rc = true;
        this.m_bTempFile = false;
        return rc;
    }

    protected boolean makeOutputStream(String outFile, boolean bTempFile) throws IOException, FileNotFoundException, Exception {
        boolean rc = false;
        this.closeCurrentOutputStream();
        this.m_bTempFile = bTempFile;
        if (outFile != null) {
            if (outFile == this.m_mainHtmlFile && this._getOutputMode() == 1) {
                if (this.getPrintWriter() != null) {
                    this.m_prwriter = this.getPrintWriter();
                    rc = true;
                } else if (this.getOutputStream() != null) {
                    this.m_ostream = this.getOutputStream();
                    OutputStreamWriter outWriter = new OutputStreamWriter(this.m_ostream, this.getCharacterEncoding());
                    this.m_prwriter = new PrintWriter((Writer)new BufferedWriter(outWriter), false);
                    rc = true;
                }
            }
            if (!rc) {
                int outputMode = -1;
                outputMode = bTempFile ? this._getTempFileOutputMode() : this._getOutputMode();
                if (outputMode == 1) {
                    this.m_fos = new FileOutputStream(outFile);
                    if (this.m_fos != null) {
                        OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)this.m_fos, this.getCharacterEncoding());
                        this.m_prwriter = new PrintWriter((Writer)new BufferedWriter(outWriter), false);
                        if (this.m_prwriter != null) {
                            this.m_pages.addElement(outFile);
                            rc = true;
                        } else {
                            this.m_fos.close();
                            this.m_fos = null;
                            this.deleteFile(outFile);
                            this.m_eh.log("could not create PrintWriter for file: " + outFile, this.getClass().getName(), m_method_makeOutputStream);
                        }
                    }
                } else if (outputMode == 2) {
                    ZipOutputStream zos = null;
                    zos = bTempFile ? this.m_tempZipOutputStream : this.m_zipOutputStream;
                    ZipEntry ze = new ZipEntry(outFile);
                    zos.putNextEntry(ze);
                    OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)zos, this.getCharacterEncoding());
                    this.m_prwriter = new PrintWriter((Writer)new BufferedWriter(outWriter), false);
                    if (this.m_prwriter != null) {
                        rc = true;
                    } else {
                        this.m_eh.log("could not create PrintWriter to zip file for file: " + outFile, this.getClass().getName(), m_method_makeOutputStream);
                    }
                } else if (outputMode == 3) {
                    String filename = outFile.replace(File.separatorChar, '/');
                    Storage storage = this.m_storageGroup.createStorage(filename);
                    storage.setCharacterEncoding(this.getCharacterEncoding());
                    if (bTempFile) {
                        this.m_tempStorage = storage;
                    } else {
                        this.m_storage = storage;
                        this.m_storages.add(storage);
                    }
                    this.m_prwriter = new PrintWriter(new BufferedWriter(storage.openWriter()));
                    if (this.m_prwriter != null) {
                        rc = true;
                    } else {
                        this.m_eh.log("could not create PrintWriter to Storage for file: " + outFile, this.getClass().getName(), m_method_makeOutputStream);
                    }
                }
            }
        }
        return rc;
    }

    protected void out(String data) {
        if (this.m_prwriter != null && !this.isCanceled()) {
            this.m_prwriter.write(data);
            if (this.m_prwriter.checkError()) {
                this.m_eh.log("problem writing data to output stream", this.getClass().getName(), m_method_out);
            }
        }
    }

    protected BufferedReader openInputStream(String inFile) throws IOException, Exception {
        BufferedReader reader = null;
        if (inFile != null) {
            if (this._getTempFileOutputMode() == 1) {
                FileInputStream fis = new FileInputStream(inFile);
                InputStreamReader inReader = new InputStreamReader((InputStream)fis, this.getCharacterEncoding());
                reader = new BufferedReader(inReader, 8192);
            } else if (this._getTempFileOutputMode() == 2 && this.m_tempByteArray != null) {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.m_tempByteArray);
                this.m_tempZipInputStream = new ZipInputStream(bais);
                ZipEntry ze = this.m_tempZipInputStream.getNextEntry();
                if (ze != null) {
                    reader = new BufferedReader(new InputStreamReader((InputStream)this.m_tempZipInputStream, this.getCharacterEncoding()));
                }
            } else if (this._getTempFileOutputMode() == 3) {
                reader = new BufferedReader(this.m_tempStorage.openReader());
            }
        }
        return reader;
    }

    private void _closeInputStream(BufferedReader reader) throws IOException, Exception {
        if (this._getTempFileOutputMode() == 1 && reader != null) {
            reader.close();
        } else if (this._getTempFileOutputMode() == 2 && this.m_tempZipInputStream != null) {
            this.m_tempZipInputStream.closeEntry();
            this.m_tempZipInputStream.close();
            this.m_tempZipInputStream = null;
        } else if (this._getTempFileOutputMode() == 3 && this.m_tempStorage != null) {
            this.m_tempStorage.closeReader();
        }
    }

    protected void deleteFile(String fileName) {
        File f;
        if (fileName != null && (f = new File(fileName)) != null) {
            f.delete();
            Object var2_2 = null;
        }
    }

    protected String makeSheetName(int num) {
        String sname = null;
        sname = SHEET_PREFIX + this._zeroFillNumber(num) + ".htm";
        return sname;
    }

    protected String makeGraphDirectoryName() {
        String dirName = new String(this.m_mainDirFile + File.separator);
        if (this.getPagesPerSheet() == 1) {
            String sheetName = SHEET_PREFIX + this._zeroFillNumber(this.m_currPage);
            dirName = dirName + sheetName + this._getDirectoryExtension(this.m_locale) + File.separator;
        }
        return dirName;
    }

    protected String makeGraphFileName(int num) {
        String sname = null;
        sname = "image" + this._zeroFillNumber(num) + ".png";
        return sname;
    }

    protected String makeTabName(int num) {
        String sname = null;
        Integer integer = new Integer(num);
        sname = MessageFormat.format(this.m_resourceBundle.getString("Sheet"), integer.toString());
        return sname;
    }

    protected String replace(String in, String find, String mod) {
        StringBuffer sb = new StringBuffer(1024);
        int pos = 0;
        int len = in.length();
        int skiplen = find.length();
        if (len > 0) {
            pos = in.indexOf(find);
            if (pos > -1) {
                while (pos > -1 && in != null) {
                    sb.append(in.substring(0, pos));
                    sb.append(mod);
                    if (pos + skiplen >= len) {
                        in = null;
                        break;
                    }
                    in = in.substring(pos + skiplen);
                    pos = in.indexOf(find);
                }
            }
            if (in != null) {
                sb.append(in);
            }
        } else {
            sb.append("");
        }
        return sb.toString();
    }

    private String _getCharSet() {
        String charSet = "";
        if (this.getCharacterEncoding() != null) {
            charSet = "; charset=" + this.getCharacterEncoding();
        }
        return charSet;
    }

    protected void genTabStrip(int sheets) {
        String openHTML = "<html>\n";
        if (LocaleUtils.getReadingDirectionForLocale((Locale)this.m_locale) == 2) {
            openHTML = "<html dir=\"rtl\">\n";
        }
        String[] tsPart1 = new String[]{openHTML, "<head>\n", "<meta http-equiv=Content-Type content=\"text/html", this._getCharSet(), "\">\n", "<meta name=ProgId content=Excel.Sheet>\n", "<meta name=Generator content=\"", this.m_OracleHTMLGenerator, "\">\n", "<link id=Main-File rel=Main-File href=\"", this.m_relativeMainFile, "\">\n", "\n", "<script language=\"JavaScript\">\n", "<!--\n", "if (window.name!=\"frTabs\")\n", " window.location.replace(document.all.item(\"Main-File\").href);\n", "//-->\n", "</script>\n", "<style>\n", "<!--\n", "A { text-decoration:none; color:#000000; font-size:9pt; }\n", "-->\n", "</style>\n", "</head>\n", "<body topmargin=0 leftmargin=0 bgcolor=\"#808080\">\n", "<table border=0 cellspacing=1>\n", " <tr>\n"};
        String[] tsPart2 = new String[]{" </tr>\n", "</table>\n", "</body>\n", "</html>\n"};
        String sheetName = "";
        String sheetTab = "";
        int i = 0;
        while (i < tsPart1.length) {
            this.out(tsPart1[i]);
            ++i;
        }
        if (this.m_genTOC) {
            sheetName = this.makeSheetName(0);
            sheetTab = this.m_resourceBundle.getString("TOC");
            if (this.m_currBaseURI != null) {
                sheetName = this.m_relativeDirFile + "/" + sheetName;
            }
            this.out("  <td bgcolor=\"#FFFFFF\" nowrap><b><small><small>&nbsp;<a href=\"" + sheetName + "\" target=\"frSheet\"><font face=\"Arial\" color=\"#000000\">" + sheetTab + "</font></a>&nbsp;</small></small></b></td>\n");
        }
        int sheet = 1;
        while (sheet < sheets) {
            sheetName = this.makeSheetName(sheet);
            sheetTab = this.makeTabName(sheet);
            if (this.m_currBaseURI != null) {
                sheetName = this.m_relativeDirFile + "/" + sheetName;
            }
            this.out("  <td bgcolor=\"#FFFFFF\" nowrap><b><small><small>&nbsp;<a href=\"" + sheetName + "\" target=\"frSheet\"><font face=\"Arial\" color=\"#000000\">" + sheetTab + "</font></a>&nbsp;</small></small></b></td>\n");
            ++sheet;
        }
        i = 0;
        while (i < tsPart2.length) {
            this.out(tsPart2[i]);
            ++i;
        }
    }

    protected void genFileList(int sheets) {
        String stylesheetFile = FILE_STYLESHEET;
        String tabstripFile = FILE_TABSTRIP;
        String filelistFile = FILE_FILELIST;
        if (this.m_currBaseURI != null) {
            stylesheetFile = this.m_relativeDirFile + "/" + stylesheetFile;
            tabstripFile = this.m_relativeDirFile + "/" + tabstripFile;
            filelistFile = this.m_relativeDirFile + "/" + filelistFile;
        }
        String[] flPart1 = new String[]{"<xml xmlns:o=\"urn:schemas-microsoft-com:office:office\">\n", " <o:MainFile HRef=\"", this.m_relativeMainFile, "\"/>\n", " <o:File HRef=\"" + stylesheetFile + "\"/>\n", " <o:File HRef=\"" + tabstripFile + "\"/>\n"};
        String[] flPart2 = new String[]{" <o:File HRef=\"" + filelistFile + "\"/>\n", "</xml>\n"};
        String sheetName = "";
        int i = 0;
        while (i < flPart1.length) {
            this.out(flPart1[i]);
            ++i;
        }
        if (this.m_genTOC) {
            String sheetFile = FILE_TOPSHEET;
            if (this.m_currBaseURI != null) {
                sheetFile = this.m_relativeDirFile + "/" + sheetFile;
            }
            this.out(" <o:File HRef=\"" + sheetFile + "\"/>\n");
        }
        int sheet = 1;
        while (sheet < sheets) {
            sheetName = this.makeSheetName(sheet);
            if (this.m_currBaseURI != null) {
                sheetName = this.m_relativeDirFile + "/" + sheetName;
            }
            this.out(" <o:File HRef=\"" + sheetName + "\"/>\n");
            ++sheet;
        }
        i = 0;
        while (i < flPart2.length) {
            this.out(flPart2[i]);
            ++i;
        }
    }

    protected void genTOC() {
        StringTokenizer st = null;
        String sheetName = "";
        String sheetTab = "";
        String sTOCText = "";
        String sPageDims = "";
        String s = null;
        int nPageDims = this.m_pageDims.size();
        sPageDims = String.valueOf(nPageDims);
        this.genSheetHeader(0);
        this.out("<table x:str border=0 cellpadding=4 cellspacing=4 style='border-collapse:collapse;border:none'>\n");
        this.out(" <col width=72 span=1 style='width:54pt'>\n");
        this.out(" <col>\n");
        int j = 0;
        while (j < nPageDims) {
            this.out(" <col>\n");
            ++j;
        }
        this.out(" <tr height=17 style='height:12.75pt;border:none'>\n");
        this.out("  <td height=17 width=72 colspan=1 style='height:12.75pt;width:54pt;border:none'></td>\n");
        this.out("  <td colspan=" + String.valueOf(nPageDims + 1) + " style='mso-ignore:colspan;border:none;font-size:14pt'>");
        this.out("<b>");
        this.out(this.m_resourceBundle.getString("TOContents"));
        this.out("</b>");
        this.out("</td>\n");
        this.out(" </tr>\n");
        int colspan = 2;
        if (this.isExportingUnlinkedViews()) {
            ++colspan;
        }
        this.out(" <tr height=17 style='height:12.75pt;border:none'>\n");
        this.out("  <td height=17 colspan=" + String.valueOf(colspan) + " style='height:12.75pt;mso-ignore:colspan;border:none'></td>\n");
        j = 0;
        while (j < nPageDims) {
            s = (String)this.m_pageDims.elementAt(j);
            this.out("  <td style='mso-ignore:colspan;border:none'><i><b>" + s + "</b></i></td>\n");
            ++j;
        }
        this.out(" </tr>\n");
        int i = 1;
        while (i < this.m_currPage) {
            sheetName = this.makeSheetName(i);
            this.out(" <tr height=17 style='height:12.75pt;border:none'>\n");
            this.out("  <td height=17 style='height:12.75pt;border:none'></td>\n");
            this.out("  <td class=xl34 style='vertical-align:top;border:none'>");
            this.out("<a href=\"");
            if (this.m_currBaseURI != null) {
                this.out(this.m_relativeDirFile + "/" + sheetName);
            } else {
                this.out(sheetName);
            }
            this.out("#RANGE!A1");
            this.out("\">");
            this.out(this.makeTabName(i));
            this.out("</a>");
            this.out("</td>\n");
            if (this.isExportingUnlinkedViews()) {
                Object intObj;
                this.out("  <td class=xl34 style='vertical-align:top;border:none'>");
                if (this.m_pageViewTypes != null && this.m_pageViewTypes.size() >= i && (intObj = this.m_pageViewTypes.get(i - 1)) != null && intObj instanceof Integer) {
                    int viewType = (Integer)intObj;
                    switch (viewType) {
                        case 0: {
                            this.out(this.m_resourceBundle.getString("Crosstab"));
                            break;
                        }
                        case 2: {
                            this.out(this.m_resourceBundle.getString("Table"));
                            break;
                        }
                        case 1: {
                            this.out(this.m_resourceBundle.getString("Graph"));
                            break;
                        }
                    }
                }
                this.out("</td>\n");
            }
            if (this.m_pageTitles != null && this.m_pageTitles.size() >= i) {
                int pos;
                int len;
                s = (String)this.m_pageTitles.elementAt(i - 1);
                st = new StringTokenizer(s, "\n");
                if (!this.isExportingUnlinkedViews()) {
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        len = s.length();
                        pos = s.indexOf(58);
                        sTOCText = pos > -1 ? s.substring(pos + 1, len) : s;
                        sTOCText = sTOCText.trim();
                        this.out("  <td style='mso-ignore:colspan;vertical-align:top;border:none'>");
                        this.out(this.filterChars(sTOCText));
                        this.out("</td>\n");
                    }
                } else {
                    HashMap<String, String> map = new HashMap<String, String>();
                    String dim = null;
                    String mem = null;
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        len = s.length();
                        pos = s.indexOf(58);
                        if (pos > -1) {
                            mem = s.substring(pos + 1, len);
                            dim = s.substring(0, pos);
                        } else {
                            mem = s;
                            dim = null;
                        }
                        if (mem == null) {
                            mem = "";
                        }
                        if (dim == null) continue;
                        map.put(dim, mem);
                    }
                    j = 0;
                    while (j < this.m_pageDims.size()) {
                        dim = (String)this.m_pageDims.elementAt(j);
                        mem = (String)map.get(dim);
                        if (mem == null) {
                            mem = "";
                        }
                        sTOCText = mem.trim();
                        this.out("  <td style='mso-ignore:colspan;vertical-align:top;border:none'>");
                        this.out(this.filterChars(sTOCText));
                        this.out("</td>\n");
                        ++j;
                    }
                }
            }
            this.out(" </tr>\n");
            ++i;
        }
        this.out("</table>\n");
        this.genSheetFooter();
    }

    protected void genSingleSheetHeader() {
        StringBuffer ssheetHeader = new StringBuffer();
        if (this.m_bMainJSP) {
            ssheetHeader.append(this._createJSPHeader());
        }
        String openHTML = "<html ";
        if (LocaleUtils.getReadingDirectionForLocale((Locale)this.m_locale) == 2) {
            openHTML = "<html dir=\"rtl\" ";
        }
        ssheetHeader.append(openHTML);
        ssheetHeader.append("xmlns:o=\"urn:schemas-microsoft-com:office:office\"\n");
        ssheetHeader.append("xmlns:x=\"urn:schemas-microsoft-com:office:excel\"\n");
        ssheetHeader.append("xmlns=\"http://www.w3.org/TR/REC-html40\">\n");
        ssheetHeader.append("\n");
        ssheetHeader.append("<head>\n");
        ssheetHeader.append("<title>");
        ssheetHeader.append(this.m_mainExportName);
        ssheetHeader.append("</title>\n");
        ssheetHeader.append("<meta http-equiv=Content-Type content=\"text/html");
        ssheetHeader.append(this._getCharSet());
        ssheetHeader.append("\">\n");
        ssheetHeader.append("<meta name=ProgId content=Excel.Sheet>\n");
        ssheetHeader.append("<meta name=Generator content=\"");
        ssheetHeader.append(this.m_OracleHTMLGenerator);
        ssheetHeader.append("\">\n");
        ssheetHeader.append("<style id=\"Book2_27152_Styles\">\n");
        ssheetHeader.append("<!--table\n");
        ssheetHeader.append("{mso-displayed-decimal-separator:\"\\");
        ssheetHeader.append(this.m_decSeparator);
        ssheetHeader.append("\";\n");
        ssheetHeader.append("mso-displayed-thousand-separator:\"\\");
        ssheetHeader.append(this.m_grpSeparator);
        ssheetHeader.append("\";}\n");
        ssheetHeader.append("@page\n");
        ssheetHeader.append("{margin:1.0in .75in 1.0in .75in;\n");
        ssheetHeader.append("mso-header-margin:.5in;\n");
        ssheetHeader.append("mso-footer-margin:.5in;}\n");
        ssheetHeader.append("$INSERT_STYLELIST$\n");
        ssheetHeader.append("-->\n");
        ssheetHeader.append("</style>\n");
        ssheetHeader.append("<!--[if gte mso 9]><xml>\n");
        ssheetHeader.append(" <x:ExcelWorkbook>\n");
        ssheetHeader.append("  <x:ExcelWorksheets>\n");
        ssheetHeader.append("   <x:ExcelWorksheet>\n");
        ssheetHeader.append("    <x:Name>Sheet1</x:Name>\n");
        ssheetHeader.append("    <x:WorksheetOptions>\n");
        ssheetHeader.append("     <x:Selected/>\n");
        ssheetHeader.append("     <x:ProtectContents>False</x:ProtectContents>\n");
        ssheetHeader.append("     <x:ProtectObjects>False</x:ProtectObjects>\n");
        ssheetHeader.append("     <x:ProtectScenarios>False</x:ProtectScenarios>\n");
        ssheetHeader.append("    </x:WorksheetOptions>\n");
        ssheetHeader.append("   </x:ExcelWorksheet>\n");
        ssheetHeader.append("  </x:ExcelWorksheets>\n");
        ssheetHeader.append("  <x:WindowHeight>9000</x:WindowHeight>\n");
        ssheetHeader.append("  <x:WindowWidth>13800</x:WindowWidth>\n");
        ssheetHeader.append("  <x:WindowTopX>0</x:WindowTopX>\n");
        ssheetHeader.append("  <x:WindowTopY>0</x:WindowTopY>\n");
        ssheetHeader.append("  <x:ProtectStructure>False</x:ProtectStructure>\n");
        ssheetHeader.append("  <x:ProtectWindows>False</x:ProtectWindows>\n");
        ssheetHeader.append(" </x:ExcelWorkbook>\n");
        ssheetHeader.append("$INSERT_PALETTE$\n");
        ssheetHeader.append("</xml><![endif]-->\n");
        ssheetHeader.append("</head>\n");
        ssheetHeader.append("<body link=\"blue\" vlink=\"purple\">\n");
        ssheetHeader.append("<div id=\"Book2_27152\" x:publisher=\"Excel\">\n");
        ssheetHeader.append("\n");
        this.out(ssheetHeader.toString());
    }

    private String _createColorPaletteXML() {
        if (this.m_colorHashMap != null && this.m_colorHashMap.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(" <o:OfficeDocumentSettings>\n");
            sb.append("  <o:Colors>\n");
            Set keySet = this.m_colorHashMap.keySet();
            Object[] colorArray = keySet.toArray();
            Arrays.sort(colorArray, new SetComparator());
            int i = 0;
            while (i < colorArray.length) {
                int index;
                Object colorObj = colorArray[i];
                Object indexObj = this.m_colorHashMap.get(colorObj);
                if (indexObj instanceof Integer && (index = ((Integer)indexObj).intValue()) > -1) {
                    sb.append("   <o:Color>\n");
                    sb.append("    <o:Index>");
                    sb.append(index);
                    sb.append("</o:Index>\n");
                    sb.append("    <o:RGB>");
                    sb.append(colorObj.toString());
                    sb.append("</o:RGB>\n");
                    sb.append("   </o:Color>\n");
                }
                ++i;
            }
            sb.append("  </o:Colors>\n");
            sb.append(" </o:OfficeDocumentSettings>");
            return sb.toString();
        }
        return null;
    }

    protected void genSheetHeader(int n) {
        String filelistFile = FILE_FILELIST;
        String stylesheetFile = FILE_STYLESHEET;
        if (this.m_currBaseURI != null) {
            filelistFile = this.m_relativeDirFile + "/" + filelistFile;
            stylesheetFile = this.m_relativeDirFile + "/" + stylesheetFile;
        }
        String openHTML = "<html ";
        if (LocaleUtils.getReadingDirectionForLocale((Locale)this.m_locale) == 2) {
            openHTML = "<html dir=\"rtl\" ";
        }
        String[] sheetHeader = new String[]{openHTML, "xmlns:o=\"urn:schemas-microsoft-com:office:office\"\n", "xmlns:x=\"urn:schemas-microsoft-com:office:excel\"\n", "xmlns=\"http://www.w3.org/TR/REC-html40\">\n", "\n", "<head>\n", "<title>", this.m_mainExportName, "</title>\n", "<meta http-equiv=Content-Type content=\"text/html", this._getCharSet(), "\">\n", "<meta name=ProgId content=Excel.Sheet>\n", "<meta name=Generator content=\"", this.m_OracleHTMLGenerator, "\">\n", "<link id=Main-File rel=Main-File href=\"", this.m_relativeMainFile, "\">\n", "<link rel=File-List href=" + filelistFile + ">\n", "<link rel=Edit-Time-Data href=editdata.mso>\n", "<link rel=Stylesheet href=" + stylesheetFile + ">\n", "<style>\n", "<!--table\n", "{mso-displayed-decimal-separator:\"\\", this.m_decSeparator, "\";\n", "mso-displayed-thousand-separator:\"\\", this.m_grpSeparator, "\";}\n", "@page\n", "{margin:1.0in .75in 1.0in .75in;\n", "mso-header-margin:.5in;\n", "mso-footer-margin:.5in;}\n", "-->\n", "</style>\n", "<![if !supportTabStrip]><script language=\"JavaScript\">\n", "<!--\n", "function fnUpdateTabs()\n", " {\n", "  if (parent.window.g_iIEVer>=4) {\n", "   if (parent.document.readyState==\"complete\"\n", "    && parent.frames['frTabs'].document.readyState==\"complete\")\n", "   parent.fnSetActiveSheet(", String.valueOf(n), ");\n", "  else\n", "   window.setTimeout(\"fnUpdateTabs();\",150);\n", " }\n", "}\n", "\n", "if (window.name!=\"frSheet\")\n", " window.location.replace(\"", this.m_relativeMainFile, "\");\n", "else\n", " fnUpdateTabs();\n", "//-->\n", "</script>\n", "<![endif]><!--[if gte mso 9]><xml>\n", " <x:WorksheetOptions>\n", "  <x:Print>\n", "   <x:ValidPrinterInfo/>\n", "   <x:HorizontalResolution>600</x:HorizontalResolution>\n", "   <x:VerticalResolution>0</x:VerticalResolution>\n", "  </x:Print>\n", "  <x:Selected/>\n", "  <x:ProtectContents>False</x:ProtectContents>\n", "  <x:ProtectObjects>False</x:ProtectObjects>\n", "  <x:ProtectScenarios>False</x:ProtectScenarios>\n", " </x:WorksheetOptions>\n", "</xml><![endif]-->\n", "\n", "</head>\n", "<body link=\"blue\" vlink=\"purple\">\n", "\n"};
        int i = 0;
        while (i < sheetHeader.length) {
            this.out(sheetHeader[i]);
            ++i;
        }
    }

    protected void genSheetFooter() {
        if (this.m_combineOutput) {
            this.out("\n</div>");
        }
        this.out("\n</body>\n</html>\n");
    }

    protected CSSStyle createDatabodyCSSStyle() {
        CSSStyle style = this.createDatabodyCSSStyle(this.getStyleClass(DATABODY_STYLE_CLASS));
        return style;
    }

    protected CSSStyle createDatabodyCSSStyle(String name) {
        ViewStyle vs = (ViewStyle)this.m_gridView.getDatabodyViewStyle().clone();
        this.setDefaultUsedBits(vs, true);
        CSSStyle style = new CSSStyle("." + name);
        style.setProperty("mso-style-parent", "style0");
        NonDataComponentHandle handle = new NonDataComponentHandle(9, "Databody", this.m_gridView);
        this.convertViewStyleToCSSStyle(style, vs, handle);
        String defNumFmt = this.convertViewFormatToExcelNumberFormat(this.m_gridView.getViewFormat(), handle, new Double(1.0));
        if (defNumFmt != null) {
            style.setProperty("mso-number-format", "\"" + defNumFmt + "\"");
        }
        return style;
    }

    protected CSSStyle createColumnHeaderCSSStyle() {
        ViewStyle vs = (ViewStyle)this.m_gridView.getColumnHeaderViewStyle().clone();
        this.setDefaultUsedBits(vs, true);
        CSSStyle style = new CSSStyle("." + this.getStyleClass(COLUMN_HEADER_STYLE_CLASS));
        style.setProperty("mso-style-parent", "style0");
        NonDataComponentHandle handle = new NonDataComponentHandle(10, "ColumnHeader", this.m_gridView);
        this.convertViewStyleToCSSStyle(style, vs, handle);
        style.setProperty("border-bottom", "none");
        return style;
    }

    protected CSSStyle createRowHeaderCSSStyle() {
        ViewStyle vs = (ViewStyle)this.m_gridView.getRowHeaderViewStyle().clone();
        this.setDefaultUsedBits(vs, true);
        CSSStyle style = new CSSStyle("." + this.getStyleClass(ROW_HEADER_STYLE_CLASS));
        style.setProperty("mso-style-parent", "style0");
        NonDataComponentHandle handle = new NonDataComponentHandle(11, "RowHeader", this.m_gridView);
        this.convertViewStyleToCSSStyle(style, vs, handle);
        style.setProperty("border-right", "none");
        return style;
    }

    protected CSSStyle createPageHeaderCSSStyle(Object exportedObj) {
        ViewStyle vs = null;
        String styleClass = null;
        DataviewCommon view = null;
        if (exportedObj instanceof GridViewCommon) {
            vs = (ViewStyle)((GridViewCommon)exportedObj).getPagingControlViewStyle().clone();
            styleClass = this.getStyleClass(PAGE_HEADER_STYLE_CLASS);
            view = (GridViewCommon)exportedObj;
        } else if (exportedObj instanceof ExportableGraph) {
            vs = (ViewStyle)((ExportableGraph)exportedObj).getPagingControlViewStyle().clone();
            styleClass = this.getStyleClass(GRAPH_PAGE_HEADER_STYLE_CLASS);
            view = ((ExportableGraph)exportedObj).getDataviewCommon();
        }
        this.setDefaultUsedBits(vs, true);
        CSSStyle style = new CSSStyle("." + styleClass);
        style.setProperty("mso-style-parent", "style0");
        NonDataComponentHandle handle = new NonDataComponentHandle(3, "PageHeader", view);
        this.convertViewStyleToCSSStyle(style, vs, handle);
        return style;
    }

    protected CSSStyle createTitleCSSStyle(Object exportedObj) {
        ViewStyle vs = new ViewStyle();
        String styleClass = null;
        DataviewCommon view = null;
        if (exportedObj instanceof GridViewCommon) {
            view = (GridViewCommon)exportedObj;
            styleClass = this.getStyleClass(TITLE_STYLE_CLASS);
        } else if (exportedObj instanceof ExportableGraph) {
            view = ((ExportableGraph)exportedObj).getDataviewCommon();
            styleClass = this.getStyleClass(GRAPH_TITLE_STYLE_CLASS);
        }
        vs.setBackground(view.getDataviewTitle().getBackground());
        vs.setFont(view.getDataviewTitle().getFont());
        vs.setForeground(view.getDataviewTitle().getForeground());
        vs.setHorizontalAlignment(view.getDataviewTitle().getHorizontalAlignment());
        if (view.getDataviewTitle().isUnderline()) {
            vs.setUnderline(view.getDataviewTitle().isUnderline());
        }
        CSSStyle style = new CSSStyle("." + styleClass);
        style.setProperty("mso-style-parent", "style0");
        NonDataComponentHandle handle = new NonDataComponentHandle(6, "DataviewTitle", view);
        this.convertViewStyleToCSSStyle(style, vs, handle);
        return style;
    }

    protected CSSStyle createSubtitleCSSStyle(Object exportedObj) {
        ViewStyle vs = new ViewStyle();
        String styleClass = null;
        DataviewCommon view = null;
        if (exportedObj instanceof GridViewCommon) {
            view = (GridViewCommon)exportedObj;
            styleClass = this.getStyleClass(SUBTITLE_STYLE_CLASS);
        } else if (exportedObj instanceof ExportableGraph) {
            view = ((ExportableGraph)exportedObj).getDataviewCommon();
            styleClass = this.getStyleClass(GRAPH_SUBTITLE_STYLE_CLASS);
        }
        vs.setBackground(view.getDataviewSubtitle().getBackground());
        vs.setFont(view.getDataviewSubtitle().getFont());
        vs.setForeground(view.getDataviewSubtitle().getForeground());
        vs.setHorizontalAlignment(view.getDataviewSubtitle().getHorizontalAlignment());
        if (view.getDataviewSubtitle().isUnderline()) {
            vs.setUnderline(view.getDataviewSubtitle().isUnderline());
        }
        CSSStyle style = new CSSStyle("." + styleClass);
        style.setProperty("mso-style-parent", "style0");
        NonDataComponentHandle handle = new NonDataComponentHandle(7, "DataviewSubtitle", view);
        this.convertViewStyleToCSSStyle(style, vs, handle);
        return style;
    }

    protected CSSStyle createFootnoteCSSStyle(Object exportedObj) {
        ViewStyle vs = new ViewStyle();
        String styleClass = null;
        DataviewCommon view = null;
        if (exportedObj instanceof GridViewCommon) {
            view = (GridViewCommon)exportedObj;
            styleClass = this.getStyleClass(FOOTNOTE_STYLE_CLASS);
        } else if (exportedObj instanceof ExportableGraph) {
            view = ((ExportableGraph)exportedObj).getDataviewCommon();
            styleClass = this.getStyleClass(GRAPH_FOOTNOTE_STYLE_CLASS);
        }
        vs.setBackground(view.getDataviewFootnote().getBackground());
        vs.setFont(view.getDataviewFootnote().getFont());
        vs.setForeground(view.getDataviewFootnote().getForeground());
        vs.setHorizontalAlignment(view.getDataviewFootnote().getHorizontalAlignment());
        if (view.getDataviewFootnote().isUnderline()) {
            vs.setUnderline(view.getDataviewFootnote().isUnderline());
        }
        CSSStyle style = new CSSStyle("." + styleClass);
        style.setProperty("mso-style-parent", "style0");
        NonDataComponentHandle handle = new NonDataComponentHandle(8, "DataviewFootnote", view);
        this.convertViewStyleToCSSStyle(style, vs, handle);
        return style;
    }

    protected void setDefaultUsedBits(ViewStyle viewStyle, boolean bUsed) {
        viewStyle.setBackgroundUsed(bUsed);
        viewStyle.setFontBoldUsed(bUsed);
        viewStyle.setFontItalicUsed(bUsed);
        viewStyle.setFontNameUsed(bUsed);
        viewStyle.setFontSizeUsed(bUsed);
        viewStyle.setForegroundUsed(bUsed);
        viewStyle.setHorizontalAlignmentUsed(bUsed);
        viewStyle.setVerticalAlignmentUsed(bUsed);
    }

    protected void genStyleSheet() {
        this.genBaseStyleSheet();
        if (this.m_styleList != null && !this.m_styleList.isEmpty()) {
            for (Object o : this.m_styleList) {
                if (o == null || !(o instanceof CSSStyle)) continue;
                CSSStyle style = (CSSStyle)o;
                this.out(style.toBlockString());
            }
        }
    }

    protected void populateStyleList(Object view) {
        CSSStyle style = null;
        style = this.createTitleCSSStyle(view);
        if (style != null) {
            this.m_styleList.add(style);
        }
        if ((style = this.createSubtitleCSSStyle(view)) != null) {
            this.m_styleList.add(style);
        }
        if ((style = this.createFootnoteCSSStyle(view)) != null) {
            this.m_styleList.add(style);
        }
        if ((style = this.createPageHeaderCSSStyle(view)) != null) {
            this.m_styleList.add(style);
        }
        if (this.m_gridView != null && view == this.m_gridView && (this.getViewTypeExported() & 3) != 0) {
            style = this.createColumnHeaderCSSStyle();
            if (style != null) {
                this.m_styleList.add(style);
            }
            if ((style = this.createRowHeaderCSSStyle()) != null) {
                this.m_styleList.add(style);
            }
            if ((style = this.m_databodyCSSStyle) != null) {
                this.m_styleList.add(style);
            }
        }
    }

    protected void genBaseStyleSheet() {
        String[] ss = new String[]{"tr {\n", "   mso-height-source:auto;\n", "}\n", "col {\n", "   mso-width-source:auto;\n", "}\n", "br {\n", "   mso-data-placement:same-cell;\n", "}\n", ".style0 {\n", "   mso-number-format:General;\n", "   text-align:general;\n", "   vertical-align:bottom;\n", "   white-space:nowrap;\n", "   mso-rotate:0;\n", "   mso-background-source:auto;\n", "   mso-pattern:auto;\n", "   color:windowtext;\n", "   font-size:10.0pt;\n", "   font-weight:400;\n", "   font-style:normal;\n", "   text-decoration:none;\n", "   font-family:Arial;\n", "   mso-generic-font-family:auto;\n", "   mso-font-charset:0;\n", "   border:none;\n", "   mso-protection:locked visible;\n", "   mso-style-name:Normal;\n", "   mso-style-id:0;\n", "}\n", "td {\n", "   mso-style-parent:style0;\n", "   padding-top:1px;\n", "   padding-right:1px;\n", "   padding-left:1px;\n", "   mso-ignore:padding;\n", "   border:.1pt gray solid;\n", "}\n"};
        int i = 0;
        while (i < ss.length) {
            this.out(ss[i]);
            ++i;
        }
    }

    protected void genBaseExport() {
        StringBuffer sbArray = new StringBuffer(1024);
        String sTOC = this.m_resourceBundle.getString("TOC");
        String sPageFrames = this.m_resourceBundle.getString("pageFrames");
        String s = null;
        int nSheets = this.m_currPage - 1 + (this.m_genTOC ? 1 : 0);
        if (this.m_combineOutput) {
            String singleMainHtml1 = this._createSingleMainHtml1(this.m_relativeDirFile);
            this.out(singleMainHtml1);
            this.genStyleSheet();
            String singleMainHtml2 = this._createSingleMainHtml2();
            this.out(singleMainHtml2);
            String singleMainHtml3 = this._createSingleMainHtml3();
            this.out(singleMainHtml3);
        } else {
            String sheets = String.valueOf(nSheets);
            if (this.m_genTOC) {
                sbArray.append("c_rgszSh[0] = \"" + sTOC + "\";\n");
            }
            int i = 1;
            int j = this.m_genTOC ? 1 : 0;
            while (i < nSheets) {
                s = this.makeTabName(i);
                sbArray.append("c_rgszSh[" + j + "] = \"" + s + "\";\n");
                ++j;
                ++i;
            }
            String tabArray = sbArray.toString();
            sbArray = new StringBuffer(128);
            i = this.m_genTOC ? 0 : 1;
            while (i < nSheets) {
                s = this.m_relativeDirFile + "/" + this.makeSheetName(i);
                sbArray.append("<link id=\"shLink\" href=\"" + s + "\">\n");
                ++i;
            }
            String sheetArray = sbArray.toString();
            sbArray = new StringBuffer(128);
            sbArray.append("  <x:ExcelWorksheets>\n");
            if (this.m_genTOC) {
                s = this.m_relativeDirFile + "/" + this.makeSheetName(0);
                sbArray.append("   <x:ExcelWorksheet>\n");
                sbArray.append("    <x:Name>" + sTOC + "</x:Name>\n");
                sbArray.append("    <x:WorksheetSource HRef=\"" + s + "\"/>\n");
                sbArray.append("   </x:ExcelWorksheet>\n");
            }
            i = 1;
            while (i < nSheets) {
                s = this.m_relativeDirFile + "/" + this.makeSheetName(i);
                sbArray.append("   <x:ExcelWorksheet>\n");
                sbArray.append("    <x:Name>" + this.makeTabName(i) + "</x:Name>\n");
                sbArray.append("    <x:WorksheetSource HRef=\"" + s + "\"/>\n");
                sbArray.append("   </x:ExcelWorksheet>\n");
                ++i;
            }
            sbArray.append("  </x:ExcelWorksheets>\n");
            String excelWorksheets = sbArray.toString();
            String firstSheet = this.m_genTOC ? FILE_TOPSHEET : "sheet001.htm";
            String mainHtml = this._createMainHtml(this.m_relativeDirFile, sheets, sPageFrames, tabArray, sheetArray, excelWorksheets, firstSheet);
            this.out(mainHtml);
        }
    }

    private String _createMainHtml(String relDirFile, String sheets, String pageUsesFrames, String tabArray, String sheetArray, String excelWorksheets, String firstSheet) {
        StringBuffer mainHtmlSB = new StringBuffer();
        if (this.m_bMainJSP) {
            mainHtmlSB.append(this._createJSPHeader());
        }
        String openHTML = "<html ";
        if (LocaleUtils.getReadingDirectionForLocale((Locale)this.m_locale) == 2) {
            openHTML = "<html dir=\"rtl\" ";
        }
        mainHtmlSB.append(openHTML);
        mainHtmlSB.append("xmlns:o=\"urn:schemas-microsoft-com:office:office\"\n");
        mainHtmlSB.append("xmlns:x=\"urn:schemas-microsoft-com:office:excel\"\n");
        mainHtmlSB.append("xmlns=\"http://www.w3.org/TR/REC-html40\">\n");
        mainHtmlSB.append("<head>");
        mainHtmlSB.append("<title>");
        mainHtmlSB.append(this.m_mainExportName);
        mainHtmlSB.append("</title>\n");
        mainHtmlSB.append("<meta name=\"Excel Workbook Frameset\">\n");
        mainHtmlSB.append("<meta http-equiv=Content-Type content=\"text/html");
        mainHtmlSB.append(this._getCharSet());
        mainHtmlSB.append("\">\n");
        mainHtmlSB.append("<meta name=ProgId content=Excel.Sheet>\n");
        mainHtmlSB.append("<meta name=Generator content=\"");
        mainHtmlSB.append(this.m_OracleHTMLGenerator);
        mainHtmlSB.append("\">\n");
        mainHtmlSB.append("<link rel=File-List href=\"");
        mainHtmlSB.append(relDirFile);
        mainHtmlSB.append("/filelist.xml\">\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("<![if !supportTabStrip]>\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append(sheetArray);
        mainHtmlSB.append("\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("<link id=\"shLink\">\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("<script language=\"JavaScript\">\n");
        mainHtmlSB.append("<!--\n");
        mainHtmlSB.append("var c_lTabs = ");
        mainHtmlSB.append(sheets);
        mainHtmlSB.append(";\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("var c_rgszSh=new Array(c_lTabs);\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append(tabArray);
        mainHtmlSB.append("\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append(" var c_rgszClr=new Array(8);\n");
        mainHtmlSB.append(" c_rgszClr[0]=\"window\";\n");
        mainHtmlSB.append(" c_rgszClr[1]=\"buttonface\";\n");
        mainHtmlSB.append(" c_rgszClr[2]=\"windowframe\";\n");
        mainHtmlSB.append(" c_rgszClr[3]=\"windowtext\";\n");
        mainHtmlSB.append(" c_rgszClr[4]=\"threedlightshadow\";\n");
        mainHtmlSB.append(" c_rgszClr[5]=\"threedhighlight\";\n");
        mainHtmlSB.append(" c_rgszClr[6]=\"threeddarkshadow\";\n");
        mainHtmlSB.append(" c_rgszClr[7]=\"threedshadow\";\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append(" var g_iShCur;\n");
        mainHtmlSB.append(" var g_rglTabX=new Array(c_lTabs);\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("function fnGetIEVer()\n");
        mainHtmlSB.append("{\n");
        mainHtmlSB.append(" var ua=window.navigator.userAgent\n");
        mainHtmlSB.append(" var msie=ua.indexOf(\"MSIE\")\n");
        mainHtmlSB.append(" if (msie>0 && window.navigator.platform==\"Win32\")\n");
        mainHtmlSB.append("  return parseInt(ua.substring(msie+5,ua.indexOf(\".\", msie)));\n");
        mainHtmlSB.append(" else\n");
        mainHtmlSB.append("  return 0;\n");
        mainHtmlSB.append("}\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("function fnBuildFrameset()\n");
        mainHtmlSB.append("{\n");
        mainHtmlSB.append(" var szHTML=\"<frameset rows=\\\"*,18\\\" border=0 width=0 frameborder=no framespacing=0>\"+\n");
        mainHtmlSB.append("  \"<frame src=\\\"\"+document.all.item(\"shLink\")[0].href+\"\\\" name=\\\"frSheet\\\" noresize>\"+\n");
        mainHtmlSB.append("  \"<frameset cols=\\\"54,*\\\" border=0 width=0 frameborder=no framespacing=0>\"+\n");
        mainHtmlSB.append("  \"<frame src=\\\"\\\" name=\\\"frScroll\\\" marginwidth=0 marginheight=0 scrolling=no>\"+\n");
        mainHtmlSB.append("  \"<frame src=\\\"\\\" name=\\\"frTabs\\\" marginwidth=0 marginheight=0 scrolling=no>\"+\n");
        mainHtmlSB.append("  \"</frameset></frameset><plaintext>\";\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append(" with (document) {\n");
        mainHtmlSB.append("  open(\"text/html\",\"replace\");\n");
        mainHtmlSB.append("  write(szHTML);\n");
        mainHtmlSB.append("  close();\n");
        mainHtmlSB.append(" }\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append(" fnBuildTabStrip();\n");
        mainHtmlSB.append("}\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("function fnBuildTabStrip()\n");
        mainHtmlSB.append("{\n");
        mainHtmlSB.append(" var szHTML=\n");
        if (LocaleUtils.getReadingDirectionForLocale((Locale)this.m_locale) == 2) {
            mainHtmlSB.append("  \"<html dir=\"rtl\">");
        } else {
            mainHtmlSB.append("  \"<html>");
        }
        mainHtmlSB.append("<head><style>.clScroll {font:8pt Courier New;color:\"+c_rgszClr[6]+\";cursor:default;line-height:10pt;}\"+\n");
        mainHtmlSB.append("  \".clScroll2 {font:10pt Arial;color:\"+c_rgszClr[6]+\";cursor:default;line-height:11pt;}</style></head>\"+\n");
        mainHtmlSB.append("  \"<body onclick=\\\"event.returnValue=false;\\\" ondragstart=\\\"event.returnValue=false;\\\" onselectstart=\\\"event.returnValue=false;\\\" bgcolor=\"+c_rgszClr[4]+\" topmargin=0 leftmargin=0><table cellpadding=0 cellspacing=0 width=100%>\"+\n");
        mainHtmlSB.append("  \"<tr><td colspan=6 height=1 bgcolor=\"+c_rgszClr[2]+\"></td></tr>\"+\n");
        mainHtmlSB.append("  \"<tr><td style=\\\"font:1pt\\\">&nbsp;<td>\"+\n");
        mainHtmlSB.append("  \"<td valign=top id=tdScroll class=\\\"clScroll\\\" onclick=\\\"parent.fnFastScrollTabs(0);\\\" onmouseover=\\\"parent.fnMouseOverScroll(0);\\\" onmouseout=\\\"parent.fnMouseOutScroll(0);\\\"><a>&#171;</a></td>\"+\n");
        mainHtmlSB.append("  \"<td valign=top id=tdScroll class=\\\"clScroll2\\\" onclick=\\\"parent.fnScrollTabs(0);\\\" ondblclick=\\\"parent.fnScrollTabs(0);\\\" onmouseover=\\\"parent.fnMouseOverScroll(1);\\\" onmouseout=\\\"parent.fnMouseOutScroll(1);\\\"><a>&lt</a></td>\"+\n");
        mainHtmlSB.append("  \"<td valign=top id=tdScroll class=\\\"clScroll2\\\" onclick=\\\"parent.fnScrollTabs(1);\\\" ondblclick=\\\"parent.fnScrollTabs(1);\\\" onmouseover=\\\"parent.fnMouseOverScroll(2);\\\" onmouseout=\\\"parent.fnMouseOutScroll(2);\\\"><a>&gt</a></td>\"+\n");
        mainHtmlSB.append("  \"<td valign=top id=tdScroll class=\\\"clScroll\\\" onclick=\\\"parent.fnFastScrollTabs(1);\\\" onmouseover=\\\"parent.fnMouseOverScroll(3);\\\" onmouseout=\\\"parent.fnMouseOutScroll(3);\\\"><a>&#187;</a></td>\"+\n");
        mainHtmlSB.append("  \"<td style=\\\"font:1pt\\\">&nbsp;<td></tr></table></body></html>\";\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append(" with (frames['frScroll'].document) {\n");
        mainHtmlSB.append("  open(\"text/html\",\"replace\");\n");
        mainHtmlSB.append("  write(szHTML);\n");
        mainHtmlSB.append("  close();\n");
        mainHtmlSB.append(" }\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append(" szHTML =\n");
        if (LocaleUtils.getReadingDirectionForLocale((Locale)this.m_locale) == 2) {
            mainHtmlSB.append("  \"<html dir=\"rtl\">");
        } else {
            mainHtmlSB.append("  \"<html>");
        }
        mainHtmlSB.append("<head>\"+\n");
        mainHtmlSB.append("  \"<style>A:link,A:visited,A:active {text-decoration:none;\"+\"color:\"+c_rgszClr[3]+\";}\"+\n");
        mainHtmlSB.append("  \".clTab {cursor:hand;background:\"+c_rgszClr[1]+\";font:9pt Arial;padding-left:3px;padding-right:3px;text-align:center;}\"+\n");
        mainHtmlSB.append("  \".clBorder {background:\"+c_rgszClr[2]+\";font:1pt;}\"+\n");
        mainHtmlSB.append("  \"</style></head><body onload=\\\"parent.fnInit();\\\" onselectstart=\\\"event.returnValue=false;\\\" ondragstart=\\\"event.returnValue=false;\\\" bgcolor=\"+c_rgszClr[4]+\n");
        mainHtmlSB.append("  \" topmargin=0 leftmargin=0><table id=tbTabs cellpadding=0 cellspacing=0>\";\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append(" var iCellCount=(c_lTabs+1)*2;\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append(" var i;\n");
        mainHtmlSB.append(" for (i=0;i<iCellCount;i+=2)\n");
        mainHtmlSB.append("  szHTML+=\"<col width=1><col>\";\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append(" var iRow;\n");
        mainHtmlSB.append(" for (iRow=0;iRow<6;iRow++) {\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("  szHTML+=\"<tr>\";\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("  if (iRow==5)\n");
        mainHtmlSB.append("   szHTML+=\"<td colspan=\"+iCellCount+\"></td>\";\n");
        mainHtmlSB.append("  else {\n");
        mainHtmlSB.append("   if (iRow==0) {\n");
        mainHtmlSB.append("    for(i=0;i<iCellCount;i++)\n");
        mainHtmlSB.append("     szHTML+=\"<td height=1 class=\\\"clBorder\\\"></td>\";\n");
        mainHtmlSB.append("   } else if (iRow==1) {\n");
        mainHtmlSB.append("    for(i=0;i<c_lTabs;i++) {\n");
        mainHtmlSB.append("     szHTML+=\"<td height=1 nowrap class=\\\"clBorder\\\">&nbsp;</td>\";\n");
        mainHtmlSB.append("     szHTML+=\n");
        mainHtmlSB.append("      \"<td id=tdTab height=1 nowrap class=\\\"clTab\\\" onmouseover=\\\"parent.fnMouseOverTab(\"+i+\");\\\" onmouseout=\\\"parent.fnMouseOutTab(\"+i+\");\\\">\"+\n");
        mainHtmlSB.append("      \"<a href=\\\"\"+document.all.item(\"shLink\")[i].href+\"\\\" target=\\\"frSheet\\\" id=aTab>&nbsp;\"+c_rgszSh[i]+\"&nbsp;</a></td>\";\n");
        mainHtmlSB.append("    }\n");
        mainHtmlSB.append("    szHTML+=\"<td id=tdTab height=1 nowrap class=\\\"clBorder\\\"><a id=aTab>&nbsp;</a></td><td width=100%></td>\";\n");
        mainHtmlSB.append("   } else if (iRow==2) {\n");
        mainHtmlSB.append("    for (i=0;i<c_lTabs;i++)\n");
        mainHtmlSB.append("     szHTML+=\"<td height=1></td><td height=1 class=\\\"clBorder\\\"></td>\";\n");
        mainHtmlSB.append("    szHTML+=\"<td height=1></td><td height=1></td>\";\n");
        mainHtmlSB.append("   } else if (iRow==3) {\n");
        mainHtmlSB.append("    for (i=0;i<iCellCount;i++)\n");
        mainHtmlSB.append("     szHTML+=\"<td height=1></td>\";\n");
        mainHtmlSB.append("   } else if (iRow==4) {\n");
        mainHtmlSB.append("    for (i=0;i<c_lTabs;i++)\n");
        mainHtmlSB.append("     szHTML+=\"<td height=1 width=1></td><td height=1></td>\";\n");
        mainHtmlSB.append("    szHTML+=\"<td height=1 width=1></td><td></td>\";\n");
        mainHtmlSB.append("   }\n");
        mainHtmlSB.append("  }\n");
        mainHtmlSB.append("  szHTML+=\"</tr>\";\n");
        mainHtmlSB.append(" }\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append(" szHTML+=\"</table></body></html>\";\n");
        mainHtmlSB.append(" with (frames['frTabs'].document) {\n");
        mainHtmlSB.append("  open(\"text/html\",\"replace\");\n");
        mainHtmlSB.append("  charset=document.charset;\n");
        mainHtmlSB.append("  write(szHTML);\n");
        mainHtmlSB.append("  close();\n");
        mainHtmlSB.append(" }\n");
        mainHtmlSB.append("}\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("function fnInit()\n");
        mainHtmlSB.append("{\n");
        mainHtmlSB.append(" g_rglTabX[0]=0;\n");
        mainHtmlSB.append(" var i;\n");
        mainHtmlSB.append(" for (i=1;i<=c_lTabs;i++)\n");
        mainHtmlSB.append("  with (frames['frTabs'].document.all.tbTabs.rows[1].cells[fnTabToCol(i-1)])\n");
        mainHtmlSB.append("   g_rglTabX[i]=offsetLeft+offsetWidth-6;\n");
        mainHtmlSB.append("}\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("function fnTabToCol(iTab)\n");
        mainHtmlSB.append("{\n");
        mainHtmlSB.append(" return 2*iTab+1;\n");
        mainHtmlSB.append("}\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("function fnNextTab(fDir)\n");
        mainHtmlSB.append("{\n");
        mainHtmlSB.append(" var iNextTab=-1;\n");
        mainHtmlSB.append(" var i;\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append(" with (frames['frTabs'].document.body) {\n");
        mainHtmlSB.append("  if (fDir==0) {\n");
        mainHtmlSB.append("   if (scrollLeft>0) {\n");
        mainHtmlSB.append("    for (i=0;i<c_lTabs&&g_rglTabX[i]<scrollLeft;i++);\n");
        mainHtmlSB.append("    if (i<c_lTabs)\n");
        mainHtmlSB.append("     iNextTab=i-1;\n");
        mainHtmlSB.append("   }\n");
        mainHtmlSB.append("  } else {\n");
        mainHtmlSB.append("   if (g_rglTabX[c_lTabs]+6>offsetWidth+scrollLeft) {\n");
        mainHtmlSB.append("    for (i=0;i<c_lTabs&&g_rglTabX[i]<=scrollLeft;i++);\n");
        mainHtmlSB.append("    if (i<c_lTabs)\n");
        mainHtmlSB.append("     iNextTab=i;\n");
        mainHtmlSB.append("   }\n");
        mainHtmlSB.append("  }\n");
        mainHtmlSB.append(" }\n");
        mainHtmlSB.append(" return iNextTab;\n");
        mainHtmlSB.append("}\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("function fnScrollTabs(fDir)\n");
        mainHtmlSB.append("{\n");
        mainHtmlSB.append(" var iNextTab=fnNextTab(fDir);\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append(" if (iNextTab>=0) {\n");
        mainHtmlSB.append("  frames['frTabs'].scroll(g_rglTabX[iNextTab],0);\n");
        mainHtmlSB.append("  return true;\n");
        mainHtmlSB.append(" } else\n");
        mainHtmlSB.append("  return false;\n");
        mainHtmlSB.append("}\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("function fnFastScrollTabs(fDir)\n");
        mainHtmlSB.append("{\n");
        mainHtmlSB.append(" if (c_lTabs>16)\n");
        mainHtmlSB.append("  frames['frTabs'].scroll(g_rglTabX[fDir?c_lTabs-1:0],0);\n");
        mainHtmlSB.append(" else\n");
        mainHtmlSB.append("  if (fnScrollTabs(fDir)>0) window.setTimeout(\"fnFastScrollTabs(\"+fDir+\");\",5);\n");
        mainHtmlSB.append("}\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("function fnSetTabProps(iTab,fActive)\n");
        mainHtmlSB.append("{\n");
        mainHtmlSB.append(" var iCol=fnTabToCol(iTab);\n");
        mainHtmlSB.append(" var i;\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append(" if (iTab>=0) {\n");
        mainHtmlSB.append("  with (frames['frTabs'].document.all) {\n");
        mainHtmlSB.append("   with (tbTabs) {\n");
        mainHtmlSB.append("    for (i=0;i<= ");
        mainHtmlSB.append(sheets);
        mainHtmlSB.append(";i++) {\n");
        mainHtmlSB.append("     with (rows[i]) {\n");
        mainHtmlSB.append("      if (i==0)\n");
        mainHtmlSB.append("       cells[iCol].style.background=c_rgszClr[fActive?0:2];\n");
        mainHtmlSB.append("      else if (i>0 && i< ");
        mainHtmlSB.append(sheets);
        mainHtmlSB.append(") {\n");
        mainHtmlSB.append("       if (fActive) {\n");
        mainHtmlSB.append("        cells[iCol-1].style.background=c_rgszClr[2];\n");
        mainHtmlSB.append("        cells[iCol].style.background=c_rgszClr[0];\n");
        mainHtmlSB.append("        cells[iCol+1].style.background=c_rgszClr[2];\n");
        mainHtmlSB.append("       } else {\n");
        mainHtmlSB.append("        if (i==1) {\n");
        mainHtmlSB.append("         cells[iCol-1].style.background=c_rgszClr[2];\n");
        mainHtmlSB.append("         cells[iCol].style.background=c_rgszClr[1];\n");
        mainHtmlSB.append("         cells[iCol+1].style.background=c_rgszClr[2];\n");
        mainHtmlSB.append("        } else {\n");
        mainHtmlSB.append("         cells[iCol-1].style.background=c_rgszClr[4];\n");
        mainHtmlSB.append("         cells[iCol].style.background=c_rgszClr[(i==2)?2:4];\n");
        mainHtmlSB.append("         cells[iCol+1].style.background=c_rgszClr[4];\n");
        mainHtmlSB.append("        }\n");
        mainHtmlSB.append("       }\n");
        mainHtmlSB.append("      } else\n");
        mainHtmlSB.append("       cells[iCol].style.background=c_rgszClr[fActive?2:4];\n");
        mainHtmlSB.append("     }\n");
        mainHtmlSB.append("    }\n");
        mainHtmlSB.append("   }\n");
        mainHtmlSB.append("   with (aTab[iTab].style) {\n");
        mainHtmlSB.append("    cursor=(fActive?\"default\":\"hand\");\n");
        mainHtmlSB.append("    color=c_rgszClr[3];\n");
        mainHtmlSB.append("   }\n");
        mainHtmlSB.append("  }\n");
        mainHtmlSB.append(" }\n");
        mainHtmlSB.append("}\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("function fnMouseOverScroll(iCtl)\n");
        mainHtmlSB.append("{\n");
        mainHtmlSB.append(" frames['frScroll'].document.all.tdScroll[iCtl].style.color=c_rgszClr[7];\n");
        mainHtmlSB.append("}\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("function fnMouseOutScroll(iCtl)\n");
        mainHtmlSB.append("{\n");
        mainHtmlSB.append(" frames['frScroll'].document.all.tdScroll[iCtl].style.color=c_rgszClr[6];\n");
        mainHtmlSB.append("}\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("function fnMouseOverTab(iTab)\n");
        mainHtmlSB.append("{\n");
        mainHtmlSB.append(" if (iTab!=g_iShCur) {\n");
        mainHtmlSB.append("  var iCol=fnTabToCol(iTab);\n");
        mainHtmlSB.append("  with (frames['frTabs'].document.all) {\n");
        mainHtmlSB.append("   tdTab[iTab].style.background=c_rgszClr[5];\n");
        mainHtmlSB.append("  }\n");
        mainHtmlSB.append(" }\n");
        mainHtmlSB.append("}\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("function fnMouseOutTab(iTab)\n");
        mainHtmlSB.append("{\n");
        mainHtmlSB.append(" if (iTab>=0) {\n");
        mainHtmlSB.append("  var elFrom=frames['frTabs'].event.srcElement;\n");
        mainHtmlSB.append("  var elTo=frames['frTabs'].event.toElement;\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("  if ((!elTo) ||\n");
        mainHtmlSB.append("   (elFrom.tagName==elTo.tagName) ||\n");
        mainHtmlSB.append("   (elTo.tagName==\"A\" && elTo.parentElement!=elFrom) ||\n");
        mainHtmlSB.append("   (elFrom.tagName==\"A\" && elFrom.parentElement!=elTo)) {\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("   if (iTab!=g_iShCur) {\n");
        mainHtmlSB.append("    with (frames['frTabs'].document.all) {\n");
        mainHtmlSB.append("     tdTab[iTab].style.background=c_rgszClr[1];\n");
        mainHtmlSB.append("    }\n");
        mainHtmlSB.append("   }\n");
        mainHtmlSB.append("  }\n");
        mainHtmlSB.append(" }\n");
        mainHtmlSB.append("}\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("function fnSetActiveSheet(iSh)\n");
        mainHtmlSB.append("{\n");
        mainHtmlSB.append(" if (iSh!=g_iShCur) {\n");
        mainHtmlSB.append("  fnSetTabProps(g_iShCur,false);\n");
        mainHtmlSB.append("  fnSetTabProps(iSh,true);\n");
        mainHtmlSB.append("  g_iShCur=iSh;\n");
        mainHtmlSB.append(" }\n");
        mainHtmlSB.append("}\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append(" window.g_iIEVer=fnGetIEVer();\n");
        mainHtmlSB.append(" if (window.g_iIEVer>=4)\n");
        mainHtmlSB.append("  fnBuildFrameset();\n");
        mainHtmlSB.append("//-->\n");
        mainHtmlSB.append("</script>\n");
        mainHtmlSB.append("<![endif]>\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("<!--[if gte mso 9]><xml>\n");
        mainHtmlSB.append(" <x:ExcelWorkbook>\n");
        mainHtmlSB.append(excelWorksheets);
        mainHtmlSB.append("  <x:Stylesheet HRef=\"");
        mainHtmlSB.append(relDirFile);
        mainHtmlSB.append("/stylesheet.css\"/>\n");
        mainHtmlSB.append("  <x:WindowHeight>9000</x:WindowHeight>\n");
        mainHtmlSB.append("  <x:WindowWidth>13800</x:WindowWidth>\n");
        mainHtmlSB.append("  <x:WindowTopX>0</x:WindowTopX>\n");
        mainHtmlSB.append("  <x:WindowTopY>0</x:WindowTopY>\n");
        mainHtmlSB.append("  <x:ProtectStructure>False</x:ProtectStructure>\n");
        mainHtmlSB.append("  <x:ProtectWindows>False</x:ProtectWindows>\n");
        mainHtmlSB.append(" </x:ExcelWorkbook>\n");
        String colorPalette = this._createColorPaletteXML();
        if (colorPalette != null) {
            mainHtmlSB.append(colorPalette + "\n");
        }
        mainHtmlSB.append("</xml><![endif]-->\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("</head>\n");
        mainHtmlSB.append("\n");
        mainHtmlSB.append("<frameset rows=\"*,39\" border=0 width=0 frameborder=no framespacing=0>\n");
        mainHtmlSB.append(" <frame src=\"");
        mainHtmlSB.append(relDirFile);
        mainHtmlSB.append("/");
        mainHtmlSB.append(firstSheet);
        mainHtmlSB.append("\" name=\"frSheet\">\n");
        mainHtmlSB.append(" <frame src=\"");
        mainHtmlSB.append(relDirFile);
        mainHtmlSB.append("/tabstrip.htm\" name=\"frTabs\" marginwidth=0 marginheight=0>\n");
        mainHtmlSB.append(" <noframes>\n");
        mainHtmlSB.append("  <body>\n");
        mainHtmlSB.append("   <p>");
        mainHtmlSB.append(pageUsesFrames);
        mainHtmlSB.append("</p>\n");
        mainHtmlSB.append("  </body>\n");
        mainHtmlSB.append(" </noframes>\n");
        mainHtmlSB.append("</frameset>\n");
        mainHtmlSB.append("</html>\n");
        String mainHtml = mainHtmlSB.toString();
        return mainHtml;
    }

    private String _createSingleMainHtml1(String relDirFile) {
        StringBuffer singleMainHtml1SB = new StringBuffer();
        if (this.m_bMainJSP) {
            singleMainHtml1SB.append(this._createJSPHeader());
        }
        String openHTML = "<html ";
        if (LocaleUtils.getReadingDirectionForLocale((Locale)this.m_locale) == 2) {
            openHTML = "<html dir=\"rtl\" ";
        }
        singleMainHtml1SB.append(openHTML);
        singleMainHtml1SB.append("xmlns:o=\"urn:schemas-microsoft-com:office:office\"\n");
        singleMainHtml1SB.append("xmlns:x=\"urn:schemas-microsoft-com:office:excel\"\n");
        singleMainHtml1SB.append("xmlns=\"http://www.w3.org/TR/REC-html40\">\n");
        singleMainHtml1SB.append("<head>");
        singleMainHtml1SB.append("<title>");
        singleMainHtml1SB.append(this.m_mainExportName);
        singleMainHtml1SB.append("</title>\n");
        singleMainHtml1SB.append("<meta name=\"Excel Workbook Frameset\">\n");
        singleMainHtml1SB.append("<meta http-equiv=Content-Type content=\"text/html");
        singleMainHtml1SB.append(this._getCharSet());
        singleMainHtml1SB.append("\">\n");
        singleMainHtml1SB.append("<meta name=ProgId content=Excel.Sheet>\n");
        singleMainHtml1SB.append("<meta name=Generator content=\"");
        singleMainHtml1SB.append(this.m_OracleHTMLGenerator);
        singleMainHtml1SB.append("\">\n");
        singleMainHtml1SB.append("<link rel=File-List href=\"");
        singleMainHtml1SB.append(relDirFile);
        singleMainHtml1SB.append("/filelist.xml\">\n");
        singleMainHtml1SB.append("\n");
        singleMainHtml1SB.append("<style id=\"Book2_27152_Styles\">");
        singleMainHtml1SB.append("<!--table\n");
        singleMainHtml1SB.append("{mso-displayed-decimal-separator:\"\\");
        singleMainHtml1SB.append(this.m_decSeparator);
        singleMainHtml1SB.append("\";\n");
        singleMainHtml1SB.append("mso-displayed-thousand-separator:\"\\");
        singleMainHtml1SB.append(this.m_grpSeparator);
        singleMainHtml1SB.append("\";}\n");
        String singleMainHtml1 = singleMainHtml1SB.toString();
        return singleMainHtml1;
    }

    private String _createSingleMainHtml2() {
        StringBuffer singleMainHtml2SB = new StringBuffer();
        singleMainHtml2SB.append("-->\n");
        singleMainHtml2SB.append("</style>\n");
        singleMainHtml2SB.append("</head>\n");
        singleMainHtml2SB.append("<body>\n");
        singleMainHtml2SB.append("<div id=\"Book2_27152\">\n");
        String singleMainHtml2 = singleMainHtml2SB.toString();
        return singleMainHtml2;
    }

    private String _createSingleMainHtml3() {
        StringBuffer singleMainHtml3SB = new StringBuffer();
        singleMainHtml3SB.append("</div>\n");
        singleMainHtml3SB.append("</body>\n");
        singleMainHtml3SB.append("</html>\n");
        String singleMainHtml3 = singleMainHtml3SB.toString();
        return singleMainHtml3;
    }

    private String _createJSPHeader() {
        String header = "<%@ page language=\"java\" %>\n";
        header = header + "<%@ page contentType = \"application/vnd.ms-excel\" %>\n";
        return header;
    }

    protected String getStyleClass(String baseStyleClass) {
        if (this.m_viewIndex > 0) {
            return baseStyleClass + this.m_viewIndex;
        }
        return baseStyleClass;
    }

    protected void setViewIndex(int index) {
        this.m_viewIndex = index;
    }

    protected int getViewIndex() {
        return this.m_viewIndex;
    }

    protected static void copyState(GridViewExcelHTMLExport from, GridViewExcelHTMLExport to) {
        to.m_listenerList = from.m_listenerList;
        to.m_locale = from.m_locale;
        to.m_bCanceled = from.m_bCanceled;
        to.m_pagesPerSheet = from.m_pagesPerSheet;
        to.m_exportPageRange = from.m_exportPageRange;
        to.m_exportPageList = from.m_exportPageList;
        to.m_path = from.m_path;
        to.m_fileName = from.m_fileName;
        to.m_printWriter = from.m_printWriter;
        to.m_characterEncoding = from.m_characterEncoding;
        to.m_baseURI = from.m_baseURI;
        to.m_outputMode = from.m_outputMode;
        to.m_tempFileOutputMode = from.m_tempFileOutputMode;
        to.m_outputStream = from.m_outputStream;
        to.m_storageCallback = from.m_storageCallback;
        to.m_colorHashMap = from.m_colorHashMap;
        to.m_colorPalette = from.m_colorPalette;
        to.m_paletteIndexUsed = from.m_paletteIndexUsed;
        to.m_styleList = from.m_styleList;
        to.m_exportPage = from.m_exportPage;
        to.m_totalExportPages = from.m_totalExportPages;
        to.m_rowsOnSheet = from.m_rowsOnSheet;
        to.m_currPage = from.m_currPage;
        to.m_currGraph = from.m_currGraph;
        to.m_mainPath = from.m_mainPath;
        to.m_mainExportName = from.m_mainExportName;
        to.m_mainHtmlFile = from.m_mainHtmlFile;
        to.m_mainDirExt = from.m_mainDirExt;
        to.m_mainDirFile = from.m_mainDirFile;
        to.m_mainDirName = from.m_mainDirName;
        to.m_mainTempName = from.m_mainTempName;
        to.m_relativeMainFile = from.m_relativeMainFile;
        to.m_relativeDirFile = from.m_relativeDirFile;
        to.m_pages = from.m_pages;
        to.m_pageTitles = from.m_pageTitles;
        to.m_pageDims = from.m_pageDims;
        to.m_worksheetLabels = from.m_worksheetLabels;
        to.m_currBaseURI = from.m_currBaseURI;
        to.m_bMainJSP = from.m_bMainJSP;
        to.m_mainURL = from.m_mainURL;
        to.m_storageGroup = from.m_storageGroup;
        to.m_storage = from.m_storage;
        to.m_tempStorage = from.m_tempStorage;
        to.m_storages = from.m_storages;
        to.m_fos = from.m_fos;
        to.m_prwriter = from.m_prwriter;
        to.m_ostream = from.m_ostream;
        to.m_zipOutputStream = from.m_zipOutputStream;
        to.m_tempZipOutputStream = from.m_tempZipOutputStream;
        to.m_tempZipInputStream = from.m_tempZipInputStream;
        to.m_mainZipName = from.m_mainZipName;
        to.m_bTempFile = from.m_bTempFile;
        to.m_tempByteArray = from.m_tempByteArray;
        to.m_tempByteArrayOutputStream = from.m_tempByteArrayOutputStream;
    }

    private void $init$() {
        this.m_bCanceled = false;
        this.m_pagesPerSheet = 0;
        this.m_exportPageRange = 1;
        this.m_characterEncoding = null;
        this.m_outputMode = 1;
        this.m_tempFileOutputMode = 1;
        this.m_outputStream = null;
        this.m_dependentExports = null;
        this.m_currentDependentExport = null;
        this.m_viewIndex = 0;
        this.m_worksheetLabels = null;
        this.m_viewTypeExported = 255;
        this.m_exportableGraph = null;
        this.m_bViewsLinked = true;
        this.m_storageCallback = null;
        this.m_totalExportPages = -1;
        this.m_rowsOnSheet = 0;
        this.m_currPage = 1;
        this.m_currGraph = 1;
        this.m_OracleHTMLGenerator = null;
        this.m_mainPath = null;
        this.m_mainExportName = null;
        this.m_mainHtmlFile = null;
        this.m_mainDirExt = "_files";
        this.m_mainDirFile = null;
        this.m_mainDirName = null;
        this.m_mainTempName = null;
        this.m_relativeMainFile = this.m_mainHtmlFile;
        this.m_relativeDirFile = this.m_mainDirFile;
        this.m_decSeparator = ".";
        this.m_grpSeparator = ",";
        this.m_pages = null;
        this.m_pageTitles = null;
        this.m_pageViewTypes = null;
        this.m_pageDims = null;
        this.m_genTOC = false;
        this.m_combineOutput = true;
        this.m_currBaseURI = null;
        this.m_bMainJSP = false;
        this.m_mainURL = null;
        this.m_storageGroup = null;
        this.m_storage = null;
        this.m_tempStorage = null;
        this.m_storages = null;
        this.m_ft = new FormattedText[4];
        this.m_graphPos = 1;
        this.m_databodyCSSStyle = null;
        this.m_fos = null;
        this.m_prwriter = null;
        this.m_ostream = null;
        this.m_zipOutputStream = null;
        this.m_tempZipOutputStream = null;
        this.m_tempZipInputStream = null;
        this.m_mainZipName = null;
        this.m_bTempFile = false;
        this.m_tempByteArray = null;
        this.m_tempByteArrayOutputStream = null;
        this.m_totalExportRows = 0;
        this.m_currExportRows = 0;
    }

    static HashMap ra$m_colorHashMap(GridViewExcelHTMLExport gridViewExcelHTMLExport) {
        return gridViewExcelHTMLExport.m_colorHashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SetComparator
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            int index1 = 0;
            int index2 = 0;
            Object indexObj = GridViewExcelHTMLExport.ra$m_colorHashMap(GridViewExcelHTMLExport.this).get(obj1);
            if (indexObj instanceof Integer) {
                index1 = (Integer)indexObj;
            }
            if ((indexObj = GridViewExcelHTMLExport.ra$m_colorHashMap(GridViewExcelHTMLExport.this).get(obj2)) instanceof Integer) {
                index2 = (Integer)indexObj;
            }
            return index1 - index2;
        }

        SetComparator() {
        }
    }
}

