/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.painter.TruncatingTextPainter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.GridView;
import oracle.dss.gridView.GridViewWrappingTextPainter;
import oracle.dss.util.DataException;

public class GridViewTextPainter
extends GridViewWrappingTextPainter
implements Serializable {
    private TruncTextPainter truncPainter;
    private EnhancedTextPainter textPainter;
    private GraphicImagePainter imagePainter;
    private GridView gridView;
    private ImmInsets insets;
    private static final String m_method_getsize = "getSize(PaintContext context, int availableWidth,int availableHeight)";

    public GridViewTextPainter(GridView view) {
        this.gridView = view;
        this.truncPainter = new TruncTextPainter();
        this.textPainter = new EnhancedTextPainter();
        this.imagePainter = new GraphicImagePainter();
        this.insets = new ImmInsets(0, 1, 0, 1);
    }

    protected void drawEnhancedFont(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX) {
        ViewStyle app = (ViewStyle)context.getPaintData((Object)"Appearance");
        boolean underline = app.isUnderline();
        boolean doubleUnderline = app.isDoubleUnderline();
        boolean strikeThrough = app.isStrikeThrough();
        if (underline || doubleUnderline || strikeThrough) {
            String paintText = this.getPaintText(context, text, metrics, availableWidth);
            int stringWidth = metrics.stringWidth(paintText);
            if (alignmentX != 0.0f && stringWidth < availableWidth) {
                x = (int)((float)x + (float)(availableWidth - stringWidth) * alignmentX);
            }
            if (underline) {
                g.drawLine(x, y + 2, x + stringWidth, y + 2);
            } else if (doubleUnderline) {
                g.drawLine(x, y + 2, x + stringWidth, y + 2);
                g.drawLine(x, y + 4, x + stringWidth, y + 4);
            }
            if (strikeThrough) {
                g.drawLine(x, y - metrics.getAscent() / 2 + 1, x + stringWidth, y - metrics.getAscent() / 2 + 1);
            }
        }
    }

    public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
        if (context == null) {
            this.gridView.getErrorHandler().log("invalid paint context", this.getClass().getName(), m_method_getsize);
            return new Dimension(0, 0);
        }
        ViewStyle app = (ViewStyle)context.getPaintData((Object)"Appearance");
        if (app.isWordWrapEnabled()) {
            return super.getSize(context, availableWidth, availableHeight);
        }
        return this.textPainter.getSize(context, availableWidth, availableHeight);
    }

    protected int paintText(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX, int mnemonicIndex) {
        ViewStyle app = (ViewStyle)context.getPaintData((Object)"Appearance");
        int retVal = app.isWordWrapEnabled() ? super.paintText(context, g, metrics, text, x, y, availableWidth, alignmentX, mnemonicIndex) : this.textPainter.paintText(context, g, metrics, text, x, y, availableWidth, alignmentX, mnemonicIndex);
        if (text.trim().length() == 0) {
            return retVal;
        }
        this.drawEnhancedFont(context, g, metrics, text, x, y, availableWidth, alignmentX);
        return retVal;
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        float f;
        ViewStyle app = (ViewStyle)context.getPaintData((Object)"Appearance");
        Cell cell = (Cell)context.getPaintData((Object)"Cell");
        ImmInsets appInsets = app.getInsets();
        Image im = this.gridView.getDatabody().getGraphicImage(cell.column, cell.row);
        if (im != null && !this.gridView.isPrintOrPreviewMode()) {
            this.imagePainter.setImage(im);
            Dimension d = this.imagePainter.getPreferredSize(context);
            int savedY = y;
            float align = context.getInteriorAlignmentY();
            int fontSize = g.getFontMetrics().getHeight();
            int temp = height;
            if (height < fontSize) {
                temp = fontSize;
            }
            y = (int)((float)y + (float)(temp - fontSize) * align + (float)((fontSize - d.height) / 2));
            boolean l2r = true;
            if (l2r) {
                this.imagePainter.paint(context, g, x, y, d.width, height);
                x += d.width;
                width -= d.width;
            } else {
                this.imagePainter.paint(context, g, x + width - d.width, y, d.width, height);
                width -= d.width;
            }
            y = savedY;
            x += this.insets.right;
            width -= this.insets.right;
        }
        if (this.gridView.isAnnotationIconVisible() && (!this.gridView.isPrintOrPreviewMode() || this.gridView.isAnnotationIconPrinted()) && this.gridView.getGridViewModel().getGridViewDataSource().getAnnotation(cell.column, cell.row) != null) {
            im = this.gridView.getAnnotationImage();
            this.imagePainter.setImage(im);
            Dimension d = this.imagePainter.getPreferredSize(context);
            int savedY = y;
            float align = context.getInteriorAlignmentY();
            int fontSize = g.getFontMetrics().getHeight();
            int temp = height;
            if (height < fontSize) {
                temp = fontSize;
            }
            y = (int)((float)y + (float)(temp - fontSize) * align + (float)((fontSize - d.height) / 2));
            boolean l2r = true;
            if (!l2r) {
                this.imagePainter.paint(context, g, x + width - d.width, y, d.width, height);
                width -= d.width + this.insets.right;
            } else {
                this.imagePainter.paint(context, g, x, y, d.width, height);
                x += d.width;
                width -= d.width;
                x += this.insets.right;
                width -= this.insets.right;
            }
            y = savedY;
        }
        if (this.gridView.getZoomFactor() < 60) {
            y -= appInsets.top;
        }
        if (app.isGraphicBarVisible() && (f = this.gridView.getDatabody().getGraphicBarRatio(cell.column, cell.row)) > 0.0f) {
            Color oldColor = g.getColor();
            Color newColor = null;
            newColor = app.isGraphicBarColorUsed() ? app.getGraphicBarColor() : this.calculateDefaultBarColor(context);
            g.setColor(newColor);
            int x1 = x;
            int barWidth = (int)((float)width * f);
            if (app.getHorizontalJustify() == 2) {
                x1 += width - barWidth;
            }
            g.fillRect(x1, y, barWidth, height);
            g.setColor(oldColor);
        }
        FontMetrics metrics = g.getFontMetrics();
        Object data = this.gridView.getGridViewModel().getGridViewDataSource().getRawData(cell.column, cell.row);
        if (data == null) {
            return;
        }
        if (!(!(data instanceof Number) || this.isTotal(cell.column, cell.row) && this.isFormatted(cell.column, cell.row))) {
            Dimension size = this.textPainter.getSize(context, width, height);
            if (size.width > width) {
                if (this.gridView.getTruncatedNumericDataFormat() == 0) {
                    int stringHeight;
                    StringBuffer buffString = new StringBuffer();
                    String hashString = buffString.toString();
                    String oneHash = "#";
                    while (metrics.stringWidth(hashString) + metrics.stringWidth(oneHash) < width) {
                        buffString.append('#');
                        hashString = buffString.toString();
                        if (metrics.stringWidth(hashString) < width) continue;
                    }
                    float alignmentX = context.getInteriorAlignmentX();
                    float alignmentY = context.getInteriorAlignmentY();
                    if (alignmentY != 0.0f && (stringHeight = metrics.getHeight()) < height) {
                        y = (int)((float)y + (float)(height - stringHeight) * alignmentY);
                    }
                    y += metrics.getAscent();
                    int stringWidth = 0;
                    if (alignmentX != 0.0f && (stringWidth = metrics.stringWidth(hashString)) < width) {
                        x = (int)((float)x + (float)(width - stringWidth) * alignmentX);
                    }
                    g.drawString(hashString, x, y);
                    if (app.getVerticalJustify() == 2) {
                        y -= 3;
                    }
                    if (app.isUnderline()) {
                        g.drawLine(x, y + 2, x + stringWidth, y + 2);
                    } else if (app.isDoubleUnderline()) {
                        g.drawLine(x, y + 2, x + stringWidth, y + 2);
                        g.drawLine(x, y + 4, x + stringWidth, y + 4);
                    }
                    if (app.isStrikeThrough()) {
                        g.drawLine(x, y - metrics.getAscent() / 2, x + stringWidth, y - metrics.getAscent() / 2);
                    }
                } else if (this.gridView.getTruncatedNumericDataFormat() == 1) {
                    this.textPainter.paint(context, g, x, y, width, height);
                } else if (this.gridView.getTruncatedNumericDataFormat() == 2) {
                    this.truncPainter.paint(context, g, x, y, width, height);
                }
            } else {
                this.textPainter.paint(context, g, x, y, width, height);
            }
        } else if (app.isWordWrapEnabled()) {
            super.paint(context, g, x, y, width, height);
        } else {
            this.textPainter.paint(context, g, x, y, width, height);
        }
    }

    private boolean isTotal(int column, int row) {
        if (this.gridView.isDataIsTotalSupported()) {
            try {
                Object isTotalObj = this.gridView.getValueFromDataAccess(column, row, "dataIsTotal", this.gridView.getModel().getDataAccess());
                if (isTotalObj != null && isTotalObj instanceof Boolean) {
                    boolean bl = (Boolean)isTotalObj;
                    return bl;
                }
            }
            catch (DataException e) {
                this.gridView.getModel().getErrorHandler().log("could not determine if cell is a total", this.getClass().getName(), "isTotal");
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    private boolean isFormatted(int column, int row) {
        if (this.gridView.isDataFormattedSupported()) {
            try {
                Object formattedObj = this.gridView.getValueFromDataAccess(column, row, "dataFormattedValue", this.gridView.getModel().getDataAccess());
                boolean bl = formattedObj != null;
                return bl;
            }
            catch (DataException e) {
                this.gridView.getModel().getErrorHandler().log("could not get formatted data from data source for cell", this.getClass().getName(), "isFormatted");
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    private Color calculateDefaultBarColor(PaintContext context) {
        Color background = context.getPaintBackground();
        Color foreground = context.getPaintForeground();
        int rValue = (background.getRed() + foreground.getRed()) / 2;
        int gValue = (background.getGreen() + foreground.getGreen()) / 2;
        int bValue = (background.getBlue() + foreground.getBlue()) / 2;
        Color barColor = new Color(rValue, gValue, bValue);
        return barColor;
    }

    private class TruncTextPainter
    extends TruncatingTextPainter {
        protected int paintText(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX, int mnemonicIndex) {
            int retVal = super.paintText(context, g, metrics, text, x, y, availableWidth, alignmentX, mnemonicIndex);
            GridViewTextPainter.this.drawEnhancedFont(context, g, metrics, text, x, y, availableWidth, alignmentX);
            return retVal;
        }
    }

    private class EnhancedTextPainter
    extends TextPainter {
        protected int paintText(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX, int mnemonicIndex) {
            int retVal = super.paintText(context, g, metrics, text, x, y, availableWidth, alignmentX, mnemonicIndex);
            GridViewTextPainter.this.drawEnhancedFont(context, g, metrics, text, x, y, availableWidth, alignmentX);
            return retVal;
        }
    }

    private class GraphicImagePainter
    extends ImagePainter {
        private Image image;

        public GraphicImagePainter() {
            super(0);
        }

        public void setImage(Image ig) {
            this.image = ig;
        }

        protected Image getImageData(PaintContext context) {
            return this.image;
        }
    }
}

