/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.util.ArrayList;
import java.util.Vector;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.share.collection.Range;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataRangeComponentHandle;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.gridView.GridView;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.RowComponentInfo;

public class GridViewUtils
extends DataviewUtils {
    public static String leftTrim(String s) {
        int len = s.length();
        int st = 0;
        char[] val = s.toCharArray();
        while (st < len && val[st] <= ' ') {
            ++st;
        }
        return st > 0 ? s.substring(st, len) : s;
    }

    protected static boolean oneCellOnly(CellRange[] range) {
        if (range == null) {
            return true;
        }
        if (range.length > 1) {
            return false;
        }
        return range[0].getLowerLimit().equals((Object)range[0].getUpperLimit());
    }

    protected static DataComponentInfo[] convertRangesToCells(CellRange[] range) {
        Vector<DataComponentInfo> tempdci = new Vector<DataComponentInfo>();
        int r = 0;
        while (r < range.length) {
            Cell ll = range[r].getLowerLimit();
            Cell ul = range[r].getUpperLimit();
            int row = ll.row;
            while (row <= ul.row) {
                int col = ll.column;
                while (col <= ul.column) {
                    tempdci.addElement(new DataComponentInfo(row, col));
                    ++col;
                }
                ++row;
            }
            ++r;
        }
        DataComponentInfo[] dci = new DataComponentInfo[tempdci.size()];
        r = 0;
        while (r < dci.length) {
            dci[r] = (DataComponentInfo)tempdci.elementAt(r);
            ++r;
        }
        return dci;
    }

    protected static CellRange[] convertCellsToRanges(DataComponentInfo[] cells) {
        ArrayList<CellRange> singleCols = new ArrayList<CellRange>();
        ArrayList<CellRange> singleRows = new ArrayList<CellRange>();
        int minCol = -1;
        int maxCol = -1;
        int minRow = -1;
        int maxRow = -1;
        int cell = 0;
        while (cell < cells.length) {
            int newCol = cells[cell].getColumn();
            int newRow = cells[cell].getRow();
            if (minCol < 0) {
                minCol = newCol;
                maxCol = newCol;
                minRow = newRow;
                maxRow = newRow;
            } else if (minCol == maxCol && newCol == maxCol && (newRow == minRow - 1 || newRow == maxRow + 1)) {
                if (newRow == minRow - 1) {
                    minRow = newRow;
                } else if (newRow == maxRow + 1) {
                    maxRow = newRow;
                }
            } else if (minRow == maxRow && newRow == maxRow && (newCol == minCol - 1 || newCol == maxCol + 1)) {
                if (newCol == minCol - 1) {
                    minCol = newCol;
                } else if (newCol == maxCol + 1) {
                    maxCol = newCol;
                }
            } else {
                CellRange range = new CellRange(minCol, minRow, maxCol, maxRow);
                if (minCol == maxCol) {
                    singleCols.add(range);
                } else {
                    singleRows.add(range);
                }
                minCol = newCol;
                maxCol = newCol;
                minRow = newRow;
                maxRow = newRow;
            }
            ++cell;
        }
        CellRange lastCellRange = new CellRange(minCol, minRow, maxCol, maxRow);
        if (minCol == maxCol) {
            singleCols.add(lastCellRange);
        } else {
            singleRows.add(lastCellRange);
        }
        ArrayList<CellRange> cellRanges = new ArrayList<CellRange>();
        if (singleCols.size() > 1) {
            CellRange range = (CellRange)singleCols.get(0);
            int c = 1;
            while (c < singleCols.size()) {
                CellRange range2 = (CellRange)singleCols.get(c);
                boolean bIncluded = false;
                if (range2.getLowerLimit().column == range.getLowerLimit().column - 1) {
                    if (range2.getLowerLimit().row == range.getLowerLimit().row && range2.getUpperLimit().row == range.getUpperLimit().row) {
                        range = new CellRange(range.getLowerLimit().column - 1, range.getLowerLimit().row, range.getUpperLimit().column, range.getUpperLimit().row);
                        bIncluded = true;
                    }
                } else if (range2.getUpperLimit().column == range.getUpperLimit().column + 1 && range2.getLowerLimit().row == range.getLowerLimit().row && range2.getUpperLimit().row == range.getUpperLimit().row) {
                    range = new CellRange(range.getLowerLimit().column, range.getLowerLimit().row, range.getUpperLimit().column + 1, range.getUpperLimit().row);
                    bIncluded = true;
                }
                if (!bIncluded) {
                    cellRanges.add(range);
                    range = range2;
                }
                ++c;
            }
            cellRanges.add(range);
        } else if (singleCols.size() == 1) {
            cellRanges.add((CellRange)singleCols.get(0));
        }
        if (singleRows.size() > 1) {
            CellRange range = (CellRange)singleRows.get(0);
            int r = 1;
            while (r < singleRows.size()) {
                CellRange range2 = (CellRange)singleRows.get(r);
                boolean bIncluded = false;
                if (range2.getLowerLimit().row == range.getLowerLimit().row - 1) {
                    if (range2.getLowerLimit().column == range.getLowerLimit().column && range2.getUpperLimit().column == range.getUpperLimit().column) {
                        range = new CellRange(range.getLowerLimit().column, range.getLowerLimit().row - 1, range.getUpperLimit().column, range.getUpperLimit().row);
                        bIncluded = true;
                    }
                } else if (range2.getUpperLimit().row == range.getUpperLimit().row + 1 && range2.getLowerLimit().column == range.getLowerLimit().column && range2.getUpperLimit().column == range.getUpperLimit().column) {
                    range = new CellRange(range.getLowerLimit().column, range.getLowerLimit().row, range.getUpperLimit().column, range.getUpperLimit().row + 1);
                    bIncluded = true;
                }
                if (!bIncluded) {
                    cellRanges.add(range);
                    range = range2;
                }
                ++r;
            }
            cellRanges.add(range);
        } else if (singleRows.size() == 1) {
            cellRanges.add((CellRange)singleRows.get(0));
        }
        CellRange[] rangesArray = new CellRange[cellRanges.size()];
        rangesArray = cellRanges.toArray(rangesArray);
        return rangesArray;
    }

    protected static ComponentHandle createDataComponent(GridView gv, int type, String name, Object source, int row, int column, CellRange[] cellList, boolean useSel) {
        if (type == 12 && !GridViewUtils.oneCellOnly(cellList) && useSel) {
            return new DataRangeComponentHandle(16, gv.getNameFromID(16), source, GridViewUtils.convertRangesToCells(cellList));
        }
        if (useSel && cellList != null && cellList.length == 1) {
            return new DataComponentHandle(type, name, source, gv.getGridViewModel().getDataFromTableRow(cellList[0].getLowerLimit().row), gv.getGridViewModel().getDataFromTableCol(cellList[0].getLowerLimit().column));
        }
        return new DataComponentHandle(type, name, source, gv.getGridViewModel().getDataFromTableRow(row), gv.getGridViewModel().getDataFromTableCol(column));
    }

    protected static ColumnComponentInfo[] convertDataColRangesToCells(Range[] range) {
        Vector<ColumnComponentInfo> tempcci = new Vector<ColumnComponentInfo>();
        int r = 0;
        while (r < range.length) {
            int ll = range[r].getLowerLimit();
            int ul = range[r].getUpperLimit();
            int col = ll;
            while (col <= ul) {
                tempcci.addElement(new ColumnComponentInfo(col));
                ++col;
            }
            ++r;
        }
        ColumnComponentInfo[] cci = new ColumnComponentInfo[tempcci.size()];
        r = 0;
        while (r < cci.length) {
            cci[r] = (ColumnComponentInfo)tempcci.elementAt(r);
            ++r;
        }
        return cci;
    }

    protected static RowComponentInfo[] convertDataRowRangesToCells(Range[] range) {
        Vector<RowComponentInfo> temprci = new Vector<RowComponentInfo>();
        int r = 0;
        while (r < range.length) {
            int ll = range[r].getLowerLimit();
            int ul = range[r].getUpperLimit();
            int row = ll;
            while (row <= ul) {
                temprci.addElement(new RowComponentInfo(row));
                ++row;
            }
            ++r;
        }
        RowComponentInfo[] rci = new RowComponentInfo[temprci.size()];
        r = 0;
        while (r < rci.length) {
            rci[r] = (RowComponentInfo)temprci.elementAt(r);
            ++r;
        }
        return rci;
    }

    protected static boolean oneCellOnly(Range[] range) {
        if (range == null) {
            return true;
        }
        if (range.length > 1) {
            return false;
        }
        return range[0].getLowerLimit() == range[0].getUpperLimit();
    }

    public static boolean equalsHPos(int[] a, int[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null ^ b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

