/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.io.Serializable;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.dss.dataView.Model;
import oracle.dss.gridView.GridView;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeComponentInfo;

public abstract class HeaderCell
extends AbstractPivotHeaderCell
implements Serializable {
    protected Model m_model;
    protected GridView m_gridView;
    protected int m_layer;
    protected int m_slice;
    protected int m_extent;
    protected int m_depth;
    protected transient EdgeComponentInfo info;

    public HeaderCell(GridView gridView, int layer, int depth, int slice, int extent) {
        this.$init$();
        this.m_gridView = gridView;
        this.m_model = gridView.getGridViewModel();
        this.m_layer = layer;
        this.m_depth = depth;
        this.m_slice = slice;
        this.m_extent = extent;
    }

    public int getDrillState() {
        try {
            Object value = null;
            if (this.m_gridView.isMetadataDrillSupported()) {
                value = this.m_model.getDataAccess().getMemberMetadata(this.getEdge(), this.m_layer, this.m_slice, "drillState");
            }
            if (value == null) {
                int n = 0;
                return n;
            }
            int n = (Integer)value;
            return n;
        }
        catch (DataException e) {
            this.m_model.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getDrillState");
            int n = 0;
            return n;
        }
    }

    public void setData(Object data) {
    }

    public abstract Object getData();

    protected abstract int getEdge();

    private void $init$() {
        this.m_model = null;
        this.m_gridView = null;
        this.m_layer = 0;
        this.m_slice = 0;
        this.m_extent = 0;
        this.m_depth = 0;
        this.info = new EdgeComponentInfo(0, 0, 0);
    }
}

