/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.awt.Color;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.VetoableChangeListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.painter.Painter;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerActions;
import oracle.dss.dataView.DataListener;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.Model;
import oracle.dss.dataView.ModelListener;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.TokenSubstitutionAdapter;
import oracle.dss.dataView.UIDataviewAdapter;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.FormatModel;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.GridViewData;
import oracle.dss.gridView.GridViewDatabody;
import oracle.dss.gridView.GridViewDatabodyStyleManager;
import oracle.dss.gridView.GridViewDefaultValues;
import oracle.dss.gridView.GridViewExcelHTMLExport;
import oracle.dss.gridView.GridViewFormatManager;
import oracle.dss.gridView.GridViewHeader;
import oracle.dss.gridView.GridViewHeaderStyleManager;
import oracle.dss.gridView.GridViewSizingManager;
import oracle.dss.gridView.UIGridView;
import oracle.dss.pagingControl.ViewPagingControl;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.Rule;
import oracle.dss.rules.RuleBundle;
import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataSource;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;

public abstract class UIGridViewAdapter
extends UIDataviewAdapter
implements UIGridView {
    protected MyDatabody m_databody;
    protected MyPagingControl m_pagingControl;
    protected Image m_image;
    protected boolean m_grid3D;
    protected boolean m_hGridVisible;
    protected boolean m_vGridVisible;
    protected Color m_gridColor;
    protected Color m_vGridColor;
    protected Color m_hGridColor;
    protected TokenSubstitution m_token;
    protected MyHeader m_rowHeader;
    protected MyHeader m_colHeader;
    protected GridViewHeaderStyleManager m_headerStyleManager;
    protected GridViewDatabodyStyleManager m_databodyStyleManager;
    protected GridViewFormatManager m_viewFormatManager;
    protected Model m_model;
    protected ResourceBundle rBundle;
    protected FormatModel m_formatModel;
    protected int m_scope;
    private boolean m_colHeaderVisible;
    private boolean m_rowHeaderVisible;
    private String[] m_layerMetadataLabelTypes;
    private String[] m_memberMetadataLabelTypes;
    protected int m_formatCount;
    protected int m_toolbarFormatCount;
    protected Vector m_UIFormats;
    protected ViewFormat m_viewFormat;
    protected String m_badColor;
    protected String m_warningColor;
    protected String m_goodColor;
    protected boolean m_isHideData;
    private static final String m_method_setLocale = "setLocale (Locale loc)";
    private static final String m_method_getMemberMetadataLabelType = "public String getMemberMetadataLabelType(int edge)";
    private static final String m_method_getLayerMetadataLabelType = "public String getLayerMetadataLabelType(int edge)";

    public UIGridViewAdapter() {
        this.$init$();
        this.initUIGridViewAdapter();
    }

    public UIGridViewAdapter(UIGridView gridView) {
        this();
        this.initFromGridView(gridView);
    }

    protected void initUIGridViewAdapter() {
        this._initDefaults();
        this.m_databody = new MyDatabody();
        this.m_pagingControl = new MyPagingControl();
        this.m_pagingControl.setViewStyle(new ViewStyle());
        this.m_rowHeader = new MyHeader();
        this.m_colHeader = new MyHeader();
        this.m_headerStyleManager = new MyHeaderStyleManager();
        this.m_databodyStyleManager = new MyDatabodyStyleManager();
        this.m_viewFormatManager = new MyViewFormatManager();
        this.m_model = new MyModel();
        this.m_token = new TokenSubstitutionAdapter(this);
        this.m_errorHandler = new DefaultErrorHandler();
    }

    private void _initDefaults() {
        this.m_grid3D = GridViewDefaultValues.isGrid3D();
        this.m_hGridVisible = GridViewDefaultValues.isHGridVisible();
        this.m_vGridVisible = GridViewDefaultValues.isVGridVisible();
        this.m_gridColor = new Color(GridViewDefaultValues.getGridColor());
        this.m_vGridColor = new Color(GridViewDefaultValues.getGridColor());
        this.m_hGridColor = new Color(GridViewDefaultValues.getGridColor());
        this.m_colHeaderVisible = GridViewDefaultValues.isColumnHeaderVisible();
        this.m_rowHeaderVisible = GridViewDefaultValues.isRowHeaderVisible();
        this.m_formatCount = GridViewDefaultValues.getUIFormatCount();
        this.m_toolbarFormatCount = GridViewDefaultValues.getToolbarUIFormatCount();
        this.m_scope = GridViewDefaultValues.getAutoFitScope();
        this.m_memberMetadataLabelTypes = new String[3];
        this.m_layerMetadataLabelTypes = new String[3];
        int edge = 0;
        while (edge < 3) {
            this.m_memberMetadataLabelTypes[edge] = DataviewDefaultValues.getMemberMetadataLabelType(edge);
            this.m_layerMetadataLabelTypes[edge] = DataviewDefaultValues.getLayerMetadataLabelType(edge);
            ++edge;
        }
    }

    public void setAutoFitScope(int scope) {
        this.m_scope = scope;
    }

    public int getAutoFitScope() {
        return this.m_scope;
    }

    public void dataAndMetadataStyleChanged() {
    }

    public void dataStyleAndFormatAndMetadataStyleChanged() {
    }

    public void setBackgroundImage(Image image) {
        this.m_image = image;
    }

    public Image getBackgroundImage() {
        return this.m_image;
    }

    public void setGrid3D(boolean b) {
        this.m_grid3D = b;
    }

    public boolean isGrid3D() {
        return this.m_grid3D;
    }

    public void setGridColor(Color color) {
        this.m_gridColor = color;
    }

    public Color getGridColor() {
        return this.m_gridColor;
    }

    public void setVGridColor(Color color) {
        this.m_vGridColor = color;
    }

    public void setHGridColor(Color color) {
        this.m_hGridColor = color;
    }

    public Color getVGridColor() {
        return this.m_vGridColor;
    }

    public Color getHGridColor() {
        return this.m_hGridColor;
    }

    public void setHGridVisible(boolean b) {
        this.m_hGridVisible = b;
    }

    public boolean isHGridVisible() {
        return this.m_hGridVisible;
    }

    public void setVGridVisible(boolean b) {
        this.m_vGridVisible = b;
    }

    public boolean isVGridVisible() {
        return this.m_vGridVisible;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        try {
            this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle", locale) : ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle");
        }
        catch (MissingResourceException e) {
            this.getErrorHandler().error((Throwable)e, this.getClass().getName(), m_method_setLocale);
            this.rBundle = null;
        }
    }

    public GridViewDatabody getDatabody() {
        return this.m_databody;
    }

    public GridViewHeader getColumnHeader() {
        return this.m_colHeader;
    }

    public GridViewHeader getRowHeader() {
        return this.m_rowHeader;
    }

    public ViewPagingControl getPagingControl() {
        return this.m_pagingControl;
    }

    public void setColumnHeaderVisible(boolean visible) {
        this.m_colHeaderVisible = visible;
    }

    public boolean isColumnHeaderVisible() {
        return this.m_colHeaderVisible;
    }

    public void setRowHeaderVisible(boolean visible) {
        this.m_rowHeaderVisible = visible;
    }

    public boolean isRowHeaderVisible() {
        return this.m_rowHeaderVisible;
    }

    public GridViewHeaderStyleManager getGridViewHeaderStyleManager() {
        return this.m_headerStyleManager;
    }

    public GridViewDatabodyStyleManager getGridViewDatabodyStyleManager() {
        return this.m_databodyStyleManager;
    }

    public GridViewFormatManager getGridViewFormatManager() {
        return this.m_viewFormatManager;
    }

    public Model getModel() {
        return this.m_model;
    }

    public ViewFormat getViewFormat() {
        return this.m_viewFormat;
    }

    public ViewFormat getComponentViewFormat(ComponentHandle componentHandle) {
        return null;
    }

    public ViewStyle getComponentViewStyle(ComponentHandle componentHandle) {
        return null;
    }

    public boolean compareComponentViewStyle(ComponentHandle componentHandle, ViewStyle viewStyle) {
        return false;
    }

    public boolean compareComponentViewFormat(ComponentHandle componentHandle, ViewFormat viewFormat) {
        return false;
    }

    public void applyViewFormat(ComponentHandle componentHandle, ViewFormat viewFormat) {
    }

    public void applyViewStyle(ComponentHandle componentHandle, ViewStyle viewStyle) {
    }

    public void updateSizes(int type) {
    }

    public void doSizing() {
    }

    public int getCellMaxHeight() {
        return 0;
    }

    public int getCellMinHeight() {
        return 0;
    }

    public int getCellMaxWidth() {
        return 0;
    }

    public int getCellMinWidth() {
        return 0;
    }

    public Object getComponentFromID(int ID) {
        return null;
    }

    public void setDefaultCornerComponentColor(Color c) {
    }

    public boolean isDataViewStyleSupported() {
        return true;
    }

    public boolean isDataFormattedSupported() {
        return true;
    }

    public boolean isDataIsTotalSupported() {
        return true;
    }

    public boolean isMetadataLongLabelSupported() {
        return true;
    }

    public boolean isMetadataMediumLabelSupported() {
        return true;
    }

    public boolean isMetadataValueSupported() {
        return true;
    }

    public boolean isLayerMetaLongLabelSupported() {
        return true;
    }

    public boolean isLayerMetaMediumLabelSupported() {
        return true;
    }

    public boolean isLayerMetaNameSupported() {
        return true;
    }

    public void setBanding(int banding) {
    }

    public int getBanding() {
        return -1;
    }

    public void setHTMLColumnSizing(int htmlColumnSizing) {
    }

    public int getHTMLColumnSizing() {
        return -1;
    }

    public void setHTMLRowBlockSize(int size) {
    }

    public int getHTMLRowBlockSize() {
        return -1;
    }

    public Integer getHTMLTableCellPadding() {
        return null;
    }

    public void setHTMLTableCellPadding(Integer padding) {
    }

    public String getHTMLTableWidth() {
        return null;
    }

    public void setHTMLTableWidth(String width) {
    }

    public void setHTMLTextInputSize(int size) {
    }

    public int getHTMLTextInputSize() {
        return -1;
    }

    public int getUIFormatCount() {
        return this.m_formatCount;
    }

    public void setUIFormatCount(int count) {
        this.m_formatCount = count;
    }

    public int getToolbarUIFormatCount() {
        return this.m_toolbarFormatCount;
    }

    public void setToolbarUIFormatCount(int count) {
        this.m_toolbarFormatCount = count;
    }

    public void setUIFormats(Vector formats) {
        this.m_UIFormats = formats;
    }

    public Vector getUIFormats() {
        return this.m_UIFormats;
    }

    public String getBadColor() {
        return this.m_badColor;
    }

    public void setBadColor(String color) {
        this.m_badColor = color;
    }

    public String getWarningColor() {
        return this.m_warningColor;
    }

    public void setWarningColor(String color) {
        this.m_warningColor = color;
    }

    public String getGoodColor() {
        return this.m_goodColor;
    }

    public void setGoodColor(String color) {
        this.m_goodColor = color;
    }

    public boolean isHideData() {
        return this.m_isHideData;
    }

    public void setHideData(boolean hide) {
        this.m_isHideData = hide;
    }

    public FormatModel getFormatModel() {
        return this.m_formatModel;
    }

    public void setFormatModel(FormatModel model) {
        this.m_formatModel = model;
    }

    public String getMemberMetadataLabelType(int edge) {
        if (!this._isEdgeValid(edge)) {
            this.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_getMemberMetadataLabelType);
            return null;
        }
        return this.m_memberMetadataLabelTypes[edge];
    }

    public String getLayerMetadataLabelType(int edge) {
        if (!this._isEdgeValid(edge)) {
            this.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_getLayerMetadataLabelType);
            return null;
        }
        return this.m_layerMetadataLabelTypes[edge];
    }

    public GridViewSizingManager getGridViewSizingManager() {
        return null;
    }

    public Color getCornerComponentColor() {
        return null;
    }

    public GridViewExcelHTMLExport getGridViewExcelHTMLExport() {
        return null;
    }

    public boolean startExport() {
        return false;
    }

    public void endExport() {
    }

    public ViewStyle getDatabodyViewStyle() {
        return this.getDatabody().getViewStyle();
    }

    public ViewStyle getColumnHeaderViewStyle() {
        return this.getColumnHeader().getViewStyle();
    }

    public ViewStyle getRowHeaderViewStyle() {
        return this.getRowHeader().getViewStyle();
    }

    public ViewStyle getPagingControlViewStyle() {
        return this.getPagingControl().getViewStyle();
    }

    public int getPagingControlPosition() {
        return -1;
    }

    public boolean isCellEditingAllowed() {
        return false;
    }

    private boolean _isEdgeValid(int edge) {
        return edge == 0 || edge == 1 || edge == 2;
    }

    public void initFromGridView(UIGridView gridview) {
        super.initFromDataview(gridview);
        this.setHGridVisible(gridview.isHGridVisible());
        this.setVGridVisible(gridview.isVGridVisible());
        this.setGrid3D(gridview.isGrid3D());
        this.setVGridColor(gridview.getVGridColor());
        this.setHGridColor(gridview.getHGridColor());
        this.getDatabody().setViewStyle(gridview.getDatabody().getViewStyle());
        this.setViewFormat(gridview.getViewFormat());
        this.setAutoFitScope(gridview.getAutoFitScope());
        this.setBackgroundImage(gridview.getBackgroundImage());
        this.getPagingControl().setViewStyle(gridview.getPagingControl().getViewStyle());
        this.getRowHeader().setViewStyle(gridview.getRowHeader().getViewStyle());
        this.getColumnHeader().setViewStyle(gridview.getColumnHeader().getViewStyle());
        this.setColumnHeaderVisible(gridview.isColumnHeaderVisible());
        this.setRowHeaderVisible(gridview.isRowHeaderVisible());
        this.m_model.setDataAccess(gridview.getModel().getDataAccess());
        this.m_model.setDataDirector(gridview.getModel().getDataDirector());
        this.m_model.setDataSource(gridview.getModel().getDataSource());
        if (gridview.getGridViewHeaderStyleManager() != null) {
            this.m_headerStyleManager.setUIBundle(this, gridview.getGridViewHeaderStyleManager().getUIBundle());
        }
        if (gridview.getGridViewDatabodyStyleManager() != null) {
            this.m_databodyStyleManager.setUIBundle(this, gridview.getGridViewDatabodyStyleManager().getUIBundle());
        }
        if (gridview.getGridViewFormatManager() != null) {
            this.m_viewFormatManager.setUIBundle(this, gridview.getGridViewFormatManager().getUIBundle());
        }
        this.setFormatModel(gridview.getFormatModel());
        this.setUIFormatCount(gridview.getUIFormatCount());
        this.setToolbarUIFormatCount(gridview.getToolbarUIFormatCount());
        this.setUIFormats(gridview.getUIFormats());
    }

    public void applyToGridView(UIGridView gridview) {
        super.applyToDataview(gridview);
        gridview.setAutoFitScope(0);
        gridview.setHGridVisible(this.isHGridVisible());
        gridview.setVGridVisible(this.isVGridVisible());
        gridview.setGrid3D(this.isGrid3D());
        gridview.setVGridColor(this.getVGridColor());
        gridview.setHGridColor(this.getHGridColor());
        gridview.getDatabody().getViewStyle().merge((Mergeable)this.getDatabody().getViewStyle());
        gridview.getViewFormat().merge((Mergeable)this.getViewFormat());
        gridview.setBackgroundImage(this.getBackgroundImage());
        gridview.getPagingControl().getViewStyle().merge((Mergeable)this.getPagingControl().getViewStyle());
        gridview.getRowHeader().getViewStyle().merge((Mergeable)this.getRowHeader().getViewStyle());
        gridview.getColumnHeader().getViewStyle().merge((Mergeable)this.getColumnHeader().getViewStyle());
        gridview.setColumnHeaderVisible(this.isColumnHeaderVisible());
        gridview.setRowHeaderVisible(this.isRowHeaderVisible());
        gridview.setUIFormatCount(this.getUIFormatCount());
        gridview.setToolbarUIFormatCount(this.getToolbarUIFormatCount());
        gridview.setUIFormats(this.getUIFormats());
        FormatModel model = this.getFormatModel();
        model.setGridView(gridview);
        gridview.setFormatModel(model);
        if (gridview.getGridViewHeaderStyleManager() != null) {
            gridview.getGridViewHeaderStyleManager().setUIBundle(gridview, this.getGridViewHeaderStyleManager().getUIBundle());
        }
        if (gridview.getGridViewDatabodyStyleManager() != null) {
            gridview.getGridViewDatabodyStyleManager().setUIBundle(gridview, this.getGridViewDatabodyStyleManager().getUIBundle());
        }
        if (gridview.getGridViewFormatManager() != null) {
            gridview.getGridViewFormatManager().setUIBundle(gridview, this.getGridViewFormatManager().getUIBundle());
        }
        gridview.setAutoFitScope(this.m_scope);
        gridview.dataAndMetadataStyleChanged();
    }

    protected void setViewFormat(ViewFormat vf) {
        this.m_viewFormat = (ViewFormat)((Object)vf.clone());
    }

    public String getIntlGridViewString(String key) {
        return null;
    }

    private void $init$() {
        this.m_image = null;
        this.m_token = null;
        this.m_model = null;
        this.rBundle = null;
        this.m_formatModel = null;
        this.m_layerMetadataLabelTypes = null;
        this.m_memberMetadataLabelTypes = null;
        this.m_formatCount = 0;
        this.m_toolbarFormatCount = 0;
        this.m_UIFormats = null;
        this.m_viewFormat = null;
        this.m_badColor = GridViewDefaultValues.getBadColor();
        this.m_warningColor = GridViewDefaultValues.getWarningColor();
        this.m_goodColor = GridViewDefaultValues.getGoodColor();
        this.m_isHideData = GridViewDefaultValues.isHideData();
    }

    protected class MyDatabody
    implements GridViewDatabody {
        private ViewStyle defaultViewStyle = new ViewStyle();

        public ViewStyle getViewStyle() {
            return this.defaultViewStyle;
        }

        public void setViewStyle(ViewStyle vs) {
            ViewStyle oldval = this.defaultViewStyle;
            this.defaultViewStyle = new ViewStyle(null, vs);
        }

        public ComponentInfo getCellFocus() {
            return null;
        }

        public void setCellFocus(ComponentInfo focusedCell) {
        }

        public GridViewData getGridViewData() {
            return null;
        }

        public void clearCache() {
        }

        public void addVetoableChangeListener(VetoableChangeListener listener) {
        }

        public void removeVetoableChangeListener(VetoableChangeListener listener) {
        }

        public Image getGraphicImage(int column, int row) {
            return null;
        }

        public boolean isDrillOut(int column, int row, int x, int y) {
            return false;
        }

        public boolean isAnnotation(int column, int row, int x, int y) {
            return false;
        }

        public Appearance getDefaultAppearance() {
            return null;
        }

        public float getGraphicBarRatio(int column, int row) {
            return 0.0f;
        }

        public int getID() {
            return -1;
        }

        public String getComponentName() {
            return null;
        }

        public BeanInfo getBeanInfo() {
            return null;
        }

        public void setHorizontalSeparatorPainter(Painter painter) {
        }

        public Painter getHorizontalSeparatorPainter() {
            return null;
        }

        public void setVerticalSeparatorPainter(Painter painter) {
        }

        public Painter getVerticalSeparatorPainter() {
            return null;
        }
    }

    protected class MyPagingControl
    extends ViewPagingControl {
        private ViewStyle m_viewStyle;

        public MyPagingControl() {
            super((Dataview)null);
        }

        public void setViewStyle(ViewStyle vs) {
            this.m_viewStyle = vs;
        }

        public ViewStyle getViewStyle() {
            return this.m_viewStyle;
        }
    }

    protected class MyHeader
    implements GridViewHeader {
        private ViewStyle defaultViewStyle = new ViewStyle();

        public void clearCache() {
        }

        public void addVetoableChangeListener(VetoableChangeListener listener) {
        }

        public void removeVetoableChangeListener(VetoableChangeListener listener) {
        }

        public int getColumnCount() {
            return 0;
        }

        public int getRowCount() {
            return 0;
        }

        public Appearance getDefaultAppearance() {
            return null;
        }

        public int getID() {
            return -1;
        }

        public String getComponentName() {
            return null;
        }

        public BeanInfo getBeanInfo() {
            return null;
        }

        public ComponentInfo getCellFocus() {
            return null;
        }

        public void setCellFocus(ComponentInfo focusedCell) {
        }

        public void setViewStyle(ViewStyle viewstyle) {
            this.defaultViewStyle = new ViewStyle(null, viewstyle);
        }

        public ViewStyle getViewStyle() {
            return this.defaultViewStyle;
        }
    }

    protected class MyHeaderStyleManager
    implements GridViewHeaderStyleManager {
        private RuleBundle m_UIBundle;

        public Object clone() throws CloneNotSupportedException {
            return null;
        }

        public void addRule(Dataview view, Rule rule) {
        }

        public void setUIBundle(DataviewCommon view, RuleBundle UIBundle2) {
            this.m_UIBundle = UIBundle2;
        }

        public RuleBundle getUIBundle() {
            return this.m_UIBundle;
        }

        public void setBundles(DataviewCommon view, Vector bundles) {
        }

        public Vector getBundles() {
            return null;
        }

        public void metadataStyleChanged() {
        }

        public ViewStyle getMetadataStyle(GridViewCommon view, Object metaData, ViewStyle initStyle, int edge, int depth, int index) {
            return null;
        }

        public void dataSourceChanged() {
        }

        private void $init$() {
            this.m_UIBundle = null;
        }

        protected MyHeaderStyleManager() {
            this.$init$();
        }
    }

    protected class MyDatabodyStyleManager
    implements GridViewDatabodyStyleManager {
        private RuleBundle m_UIBundle;

        public Object clone() throws CloneNotSupportedException {
            return null;
        }

        public void setUIBundle(DataviewCommon view, RuleBundle UIBundle2) {
            this.m_UIBundle = UIBundle2;
        }

        public RuleBundle getUIBundle() {
            return this.m_UIBundle;
        }

        public void setBundles(DataviewCommon view, Vector bundles) {
        }

        public Vector getBundles() {
            return null;
        }

        public void dataStyleChanged() {
        }

        public ViewStyle getDataStyle(GridViewCommon view, Object data, ViewStyle initStyle, int row, int column, int[] pageHPos) {
            return null;
        }

        public void dataSourceChanged() {
        }

        private void $init$() {
            this.m_UIBundle = null;
        }

        protected MyDatabodyStyleManager() {
            this.$init$();
        }
    }

    protected class MyViewFormatManager
    implements GridViewFormatManager {
        private RuleBundle m_UIBundle;

        public void valueFormatChanged() {
        }

        public void metadataFormatChanged() {
        }

        public String formatMetadataValue(GridViewCommon view, Object data, int edge, int depth, int index, ViewFormat vf) {
            return null;
        }

        public Object clone() throws CloneNotSupportedException {
            return null;
        }

        public ViewFormat getDataCellViewFormat(GridViewCommon view, int row, int column) {
            return null;
        }

        public Object formatDataValue(DataviewCommon view, Object data, int column, int row, int[] pageHPos, ViewFormat vf) {
            return null;
        }

        public void setBundles(DataviewCommon view, Vector bundles) {
        }

        public Vector getBundles() {
            return null;
        }

        public RuleBundle getUIBundle() {
            return this.m_UIBundle;
        }

        public void setUIBundle(DataviewCommon view, RuleBundle bundle) {
            this.m_UIBundle = bundle;
        }

        public void dataSourceChanged() {
        }

        protected MyViewFormatManager() {
        }
    }

    protected class MyModel
    implements Model {
        private DataAccess dataAccess;
        private DataDirector dataDirector;
        private DataSource dataSource;

        public void addModelListener(ModelListener l) {
        }

        public void removeModelListener(ModelListener l) {
        }

        public void addDataListener(DataListener l) {
        }

        public void removeDataListener(DataListener l) {
        }

        public boolean pivotGestureHappened(Object source, int fromEdge, int toEdge, int fromLayer, int toLayer, int flags) {
            return false;
        }

        public boolean canPivot(Object source, int fromEdge, int toEdge, int fromLayer, int toLayer, int flags) {
            return false;
        }

        public boolean drillGestureHappened(Object source, int edge, int layer, int slice, int flags) {
            return false;
        }

        public boolean canDrill(Object source, int edge, int layer, int slice, int flags) {
            return false;
        }

        public boolean pageChangeHappened(Object source, int pos) {
            return false;
        }

        public boolean pageChangeHappened(Object source, int[] hPos, int maxLayerSpecified) {
            return false;
        }

        public void setDataSource(DataSource ds) {
            this.dataSource = ds;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public void setDataDirector(DataDirector dd) {
            this.dataDirector = dd;
        }

        public DataDirector getDataDirector() {
            return this.dataDirector;
        }

        public void setDataAccess(DataAccess dp) {
            this.dataAccess = dp;
        }

        public DataAccess getDataAccess() {
            return this.dataAccess;
        }

        public void setDrillingEnabled(boolean b) {
        }

        public boolean isDrillingEnabled() {
            return false;
        }

        public void setErrorHandler(ErrorHandler eh) {
        }

        public ErrorHandler getErrorHandler() {
            return null;
        }

        public ControllerActions getControllerActions() {
            return null;
        }

        public void viewDataChanged(DataChangedEvent e) {
        }

        protected MyModel() {
        }
    }
}

