/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.BorderPainter;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ColumnRangeComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataRangeComponentHandle;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.RowRangeComponentHandle;
import oracle.dss.dataView.gui.DatePanel;
import oracle.dss.dataView.gui.NumberFormatPanel;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.ASFormatModel;
import oracle.dss.gridView.ConditionElement;
import oracle.dss.gridView.GridViewFormatUtils;
import oracle.dss.gridView.UIFormat;
import oracle.dss.gridView.UIGridView;
import oracle.dss.gridView.gui.FontPanel;
import oracle.dss.gridView.gui.FormatGeneralPanel;
import oracle.dss.gridView.gui.HeaderFormatGeneralPanel;
import oracle.dss.gridView.gui.RulesPanel;
import oracle.dss.gridView.gui.SamplePanel;
import oracle.dss.gridView.gui.StoplightColorDialog;
import oracle.dss.gridView.gui.StoplightDialog;
import oracle.dss.gridView.gui.UIFormatNameCallBack;
import oracle.dss.rules.DiscriminatorRule;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.RowComponentInfo;
import oracle.dss.util.gui.ViewLabel;
import oracle.dss.util.help.HelpContext;
import oracle.dss.util.persistence.CustomObjectManager;
import oracle.dss.util.persistence.ObjectBinding;
import oracle.dss.util.persistence.StringXMLizable;

public abstract class FormatsPanel
extends JPanel
implements ItemListener,
ListDataListener,
ActionListener,
HelpContext {
    protected ResourceBundle rBundle;
    private boolean isSetFocus;
    private String m_applicationName;
    private MultiLineLabel m_descriptionLabel;
    private JLabel m_itemLabel;
    private JComboBox m_itemComboBox;
    private JList m_itemList;
    private JButton m_newButton;
    private JButton m_newHeaderButton;
    private JButton m_editButton;
    private JButton m_addButton;
    private JButton m_saveButton;
    private JButton m_deleteButton;
    private JButton m_upButton;
    private JButton m_downButton;
    private JButton m_stopButton;
    private JButton m_stoplightColorButton;
    private JLabel m_sampleLabel;
    private JCheckBox m_hideStoplight;
    private JPanel buttonPanel;
    private JPanel middlePanel;
    protected FormatsTable m_formatsTable;
    protected FormatsTableModel m_formatsTableModel;
    private ASFormatModel m_formatsModel;
    private static int m_formatNumber = 0;
    private JScrollPane m_scrollPane;
    private boolean m_isDialogOpen;
    private CustomObjectManager m_customObjectManager;
    private UIFormatNameCallBack m_formatNameCallBack;
    private long m_oldID;
    private String m_numberFormatString;
    private String m_dateFormatString;
    private boolean m_numberFormatSet;
    private boolean m_dateFormatSet;
    private static String HEAD_CURR_DEFAULT_STR = "L999G999G999";
    private static String TAIL_CURR_DEFAULT_STR = "999G999G999L";
    private JPanel viewFormatsPanel;
    private MouseListener m_mouseListener;
    private KeyListener m_keyListener;
    private RulesPanel m_rulesPanel;
    private JCheckBox m_checkBox;
    private boolean m_bSuperCalled;
    private ActionListener editAction;
    private Color m_badColor;
    private Color m_goodColor;
    private Color m_warningColor;
    private static final int EXCEPTION_ONLY = 0;
    private static final int ALL_FORMATS = 1;
    private static final int DEFAULT_NONE = 15;
    private static final String[] columnNames = new String[]{"FormatsColumn", "AttributesColumn"};
    protected boolean m_ok;
    protected UIGridView m_gridView;
    protected boolean m_bHelpEnabled;
    protected HelpProvider m_helpProvider;
    protected String m_strHelpContextID;
    protected ErrorHandler m_eh;
    protected Vector m_numberCustomList;
    protected Vector m_dateCustomList;
    public static final String DEFAULT_FORMAT_CHANGED = "DefaultFormatChanged";
    public static final int CUSTOM_NUMBER = 0;
    public static final int CUSTOM_DATE = 1;

    protected abstract RulesPanel getRulesPanel(UIGridView var1, boolean var2);

    protected abstract RulesPanel getRulesPanel(UIGridView var1);

    protected abstract RulesPanel getRulesPanel(UIGridView var1, Discriminator var2, ConditionElement var3, boolean var4);

    protected abstract RulesPanel getStoplightRulesPanel(UIGridView var1, Discriminator var2);

    public FormatsPanel(UIGridView gridView) {
        this.$init$();
        this.m_bSuperCalled = true;
        if (gridView == null) {
            return;
        }
        this.m_gridView = gridView;
        this.updateResourceBundle(null);
        this.m_badColor = new Color(DataviewUtils.hexStringToInt(gridView.getBadColor()));
        this.m_warningColor = new Color(DataviewUtils.hexStringToInt(gridView.getWarningColor()));
        this.m_goodColor = new Color(DataviewUtils.hexStringToInt(gridView.getGoodColor()));
        this._initialize(gridView);
    }

    public void setGridView(UIGridView gridView) {
        if (gridView == null) {
            return;
        }
        this.setLocale(gridView.getLocale());
        this.m_gridView = gridView;
        this.m_badColor = new Color(DataviewUtils.hexStringToInt(gridView.getBadColor()));
        this.m_warningColor = new Color(DataviewUtils.hexStringToInt(gridView.getWarningColor()));
        this.m_goodColor = new Color(DataviewUtils.hexStringToInt(gridView.getGoodColor()));
        this._init(gridView);
        this.m_hideStoplight.setSelected(gridView.isHideData());
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.m_eh = eh;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    private void _initialize(UIGridView gridView) {
        this.removeAll();
        super.setLocale(gridView.getLocale());
        this.updateResourceBundle(gridView.getLocale());
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        String translatedText = this.rBundle.getString("CrosstabDescription");
        if (this.m_gridView.getViewType() == 2) {
            translatedText = this.rBundle.getString("TableDescription");
        }
        this.m_descriptionLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), translatedText);
        this.m_descriptionLabel.setAlignmentX(0.0f);
        double textwidth = this.getToolkit().getFontMetrics(this.m_descriptionLabel.getFont()).stringWidth(this.m_descriptionLabel.getText());
        int rows = (int)Math.ceil(textwidth / (double)(this.getPreferredSize().width - 20));
        this.m_descriptionLabel.setPreferredRows(rows);
        this.m_descriptionLabel.setMinimumRows(rows);
        this.m_descriptionLabel.setMaximumRows(rows);
        this.add((Component)this.m_descriptionLabel);
        this.add(Box.createRigidArea(new Dimension(0, 6)));
        this.viewFormatsPanel = new JPanel();
        this.viewFormatsPanel.setLayout(new BoxLayout(this.viewFormatsPanel, 0));
        this.viewFormatsPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Conditional Formats");
        JLabel formatListLabel = new JLabel(StringUtils.stripMnemonic((String)this.rBundle.getString("Conditional Formats")));
        formatListLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        int formatListLabelWidth = this.getToolkit().getFontMetrics(formatListLabel.getFont()).stringWidth(formatListLabel.getText());
        formatListLabel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("View formats for:");
        this.m_itemLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        Object[] itemList = new Object[]{this.rBundle.getString("Cell Formats"), this.rBundle.getString("Header Formats")};
        this.m_itemComboBox = new JComboBox<Object>(itemList);
        this.m_itemComboBox.setName("ViewFormats");
        this.m_itemComboBox.setAlignmentX(0.0f);
        this.m_itemComboBox.addItemListener(this);
        this.m_itemComboBox.setMinimumSize(this.m_itemComboBox.getPreferredSize());
        this.m_itemComboBox.setMaximumSize(this.m_itemComboBox.getPreferredSize());
        this.m_itemComboBox.setSelectedIndex(0);
        this.m_itemLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_itemLabel.setLabelFor(this.m_itemComboBox);
        this.m_itemLabel.setAlignmentX(0.0f);
        this.middlePanel = new JPanel();
        this.middlePanel.setLayout(new BoxLayout(this.middlePanel, 0));
        this.middlePanel.setAlignmentX(0.0f);
        JPanel middleLeftPanel = new JPanel();
        middleLeftPanel.setLayout(new BoxLayout(middleLeftPanel, 1));
        middleLeftPanel.setAlignmentX(0.0f);
        JPanel middleCenterPanel = new JPanel();
        middleCenterPanel.setLayout(new BoxLayout(middleCenterPanel, 1));
        middleCenterPanel.setAlignmentX(0.0f);
        JPanel middleRightPanel = new JPanel();
        middleRightPanel.setLayout(new BoxLayout(middleRightPanel, 1));
        middleRightPanel.setAlignmentX(0.0f);
        this.m_upButton = new JButton(new ImageIcon(ImageUtils.getImageResource(FormatsPanel.class, (String)"images/MoveUp.gif")));
        this.m_upButton.setName("MoveFormatUp");
        this.m_upButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("Up"));
        this.m_upButton.setToolTipText(this.rBundle.getString("Up Disabled"));
        this.m_upButton.addActionListener(this);
        this.m_upButton.setAlignmentX(0.0f);
        this.m_upButton.setMaximumSize(this.m_upButton.getPreferredSize());
        this.m_downButton = new JButton(new ImageIcon(ImageUtils.getImageResource(FormatsPanel.class, (String)"images/MoveDown.gif")));
        this.m_downButton.setName("MoveFormatDown");
        this.m_downButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("Down"));
        this.m_downButton.setToolTipText(this.rBundle.getString("Down Disabled"));
        this.m_downButton.addActionListener(this);
        this.m_downButton.setAlignmentX(0.0f);
        this.m_downButton.setMaximumSize(this.m_downButton.getPreferredSize());
        JPanel upDownPanel = new JPanel();
        upDownPanel.setLayout(new BoxLayout(upDownPanel, 1));
        upDownPanel.setAlignmentX(0.0f);
        this.m_upButton.setEnabled(false);
        this.m_downButton.setEnabled(false);
        upDownPanel.add(this.m_upButton);
        upDownPanel.add(Box.createVerticalStrut(5));
        upDownPanel.add(this.m_downButton);
        upDownPanel.setMinimumSize(upDownPanel.getPreferredSize());
        upDownPanel.setMaximumSize(upDownPanel.getPreferredSize());
        middleLeftPanel.add(upDownPanel);
        JPanel tmpPanel = new JPanel();
        tmpPanel.setPreferredSize(new Dimension(upDownPanel.getPreferredSize().width + 5, this.viewFormatsPanel.getPreferredSize().height));
        tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
        tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
        this.viewFormatsPanel.add(tmpPanel);
        this.viewFormatsPanel.add(formatListLabel);
        this.viewFormatsPanel.add(Box.createHorizontalGlue());
        this.viewFormatsPanel.add(this.m_itemLabel);
        this.viewFormatsPanel.add(Box.createHorizontalStrut(3));
        this.viewFormatsPanel.add(this.m_itemComboBox);
        this.add(this.viewFormatsPanel);
        this.add(Box.createVerticalStrut(3));
        this._init(gridView);
        this.m_formatsTable = new FormatsTable();
        this.m_formatsTable.setName("FormatNameAndAtribute");
        this.m_formatsTable.setBackground(Color.white);
        this.m_formatsTable.setModel(this.m_formatsTableModel);
        this.m_formatsTable.getColumnModel().getColumn(0).setCellRenderer(new FormatTableCellRenderer());
        this.m_formatsTable.getColumnModel().getColumn(1).setCellRenderer(new AttributeCellRenderer());
        this.m_formatsTable.getColumnModel().getColumn(0).setCellEditor(new CheckBoxEditor());
        if (this.m_formatsTable.getRowCount() > 0) {
            this.m_formatsTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.editAction = new 1();
        this.m_formatsTable.registerKeyboardAction(this.editAction, KeyStroke.getKeyStroke(32, 0), 1);
        this.m_formatsTable.registerKeyboardAction(this.editAction, KeyStroke.getKeyStroke(113, 0), 1);
        this.m_scrollPane = new JScrollPane(this.m_formatsTable);
        this.m_scrollPane.setVerticalScrollBarPolicy(20);
        this.m_scrollPane.setHorizontalScrollBarPolicy(30);
        this.m_scrollPane.setAlignmentX(0.0f);
        this.m_scrollPane.getViewport().setBackground(Color.white);
        formatListLabel.setLabelFor(this.m_formatsTable);
        middleCenterPanel.add(this.m_scrollPane);
        translatedText = this.rBundle.getString("Edit");
        this.m_editButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_editButton.setName("FormatEdit");
        this.m_editButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_editButton.addActionListener(this);
        this.m_editButton.setAlignmentX(0.0f);
        this.m_editButton.setEnabled(false);
        translatedText = this.rBundle.getString("Delete");
        this.m_deleteButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_deleteButton.setName("DeleteFormat");
        this.m_deleteButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_deleteButton.addActionListener(this);
        this.m_deleteButton.setAlignmentX(0.0f);
        this.m_deleteButton.setEnabled(false);
        translatedText = this.rBundle.getString("Formats Save As");
        this.m_saveButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_saveButton.setName("SaveFormatAs");
        this.m_saveButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_saveButton.addActionListener(this);
        this.m_saveButton.setEnabled(false);
        this.m_saveButton.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Data New");
        this.m_newButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_newButton.setName("NewCellFormat");
        this.m_newButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_newButton.addActionListener(this);
        this.m_newButton.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Header New");
        this.m_newHeaderButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_newHeaderButton.setName("NewHeaderFormat");
        this.m_newHeaderButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_newHeaderButton.addActionListener(this);
        this.m_newHeaderButton.setAlignmentX(0.0f);
        if (this.m_gridView != null && this.m_gridView.getModel().getDataAccess() != null) {
            this.m_newHeaderButton.setEnabled(true);
        } else {
            this.m_newHeaderButton.setEnabled(false);
        }
        if (this.m_gridView != null && this.m_gridView.getModel().getDataAccess() != null) {
            this.m_newButton.setEnabled(true);
        } else {
            this.m_newButton.setEnabled(false);
        }
        translatedText = this.rBundle.getString("Formats Add");
        this.m_addButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_addButton.setName("AddSavedFormat");
        this.m_addButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_addButton.addActionListener(this);
        this.m_addButton.setEnabled(false);
        this.m_addButton.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Stoplight New");
        this.m_stopButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_stopButton.setName("NewStoplightFormat");
        this.m_stopButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_stopButton.addActionListener(this);
        this.m_stopButton.setAlignmentX(0.0f);
        if (this.m_gridView != null && this.m_gridView.getModel().getDataAccess() != null) {
            this.m_stopButton.setEnabled(true);
        } else {
            this.m_stopButton.setEnabled(false);
        }
        translatedText = this.rBundle.getString("Stoplight Edit");
        this.m_stoplightColorButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_stoplightColorButton.setName("EditStoplightColors");
        this.m_stoplightColorButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_stoplightColorButton.addActionListener(this);
        this.m_stoplightColorButton.setAlignmentX(0.0f);
        int width = this.m_editButton.getPreferredSize().width;
        int height = this.m_editButton.getPreferredSize().height;
        if (this.m_deleteButton.getPreferredSize().width > width) {
            width = this.m_deleteButton.getPreferredSize().width;
        }
        if (this.m_saveButton.getPreferredSize().width > width) {
            width = this.m_saveButton.getPreferredSize().width;
        }
        if (this.m_deleteButton.getPreferredSize().width > width) {
            width = this.m_deleteButton.getPreferredSize().width;
        }
        if (this.m_saveButton.getPreferredSize().height > height) {
            width = this.m_saveButton.getPreferredSize().width;
        }
        if (this.m_newButton.getPreferredSize().width > width) {
            width = this.m_newButton.getPreferredSize().width;
        }
        if (this.m_newButton.getPreferredSize().width > width) {
            width = this.m_newHeaderButton.getPreferredSize().width;
        }
        if (this.m_newButton.getPreferredSize().width > width) {
            width = this.m_addButton.getPreferredSize().width;
        }
        if (this.m_stopButton.getPreferredSize().width > width) {
            width = this.m_stopButton.getPreferredSize().width;
        }
        if (this.m_stoplightColorButton.getPreferredSize().width > width) {
            width = this.m_stoplightColorButton.getPreferredSize().width;
        }
        this.m_editButton.setPreferredSize(new Dimension(width, height));
        this.m_editButton.setMinimumSize(new Dimension(width, height));
        this.m_editButton.setMaximumSize(new Dimension(width, height));
        this.m_deleteButton.setPreferredSize(new Dimension(width, height));
        this.m_deleteButton.setMinimumSize(new Dimension(width, height));
        this.m_deleteButton.setMaximumSize(new Dimension(width, height));
        this.m_saveButton.setPreferredSize(new Dimension(width, height));
        this.m_saveButton.setMinimumSize(new Dimension(width, height));
        this.m_saveButton.setMaximumSize(new Dimension(width, height));
        this.m_newButton.setPreferredSize(new Dimension(width, height));
        this.m_newButton.setMinimumSize(this.m_newButton.getPreferredSize());
        this.m_newButton.setMaximumSize(this.m_newButton.getPreferredSize());
        this.m_newHeaderButton.setPreferredSize(new Dimension(width, height));
        this.m_newHeaderButton.setMinimumSize(this.m_newHeaderButton.getPreferredSize());
        this.m_newHeaderButton.setMaximumSize(this.m_newHeaderButton.getPreferredSize());
        this.m_addButton.setPreferredSize(new Dimension(width, height));
        this.m_addButton.setMinimumSize(this.m_addButton.getPreferredSize());
        this.m_addButton.setMaximumSize(this.m_addButton.getPreferredSize());
        this.m_stopButton.setPreferredSize(new Dimension(width, height));
        this.m_stopButton.setMinimumSize(this.m_stopButton.getPreferredSize());
        this.m_stopButton.setMaximumSize(this.m_stopButton.getPreferredSize());
        this.m_stoplightColorButton.setPreferredSize(new Dimension(width, height));
        this.m_stoplightColorButton.setMinimumSize(this.m_stoplightColorButton.getPreferredSize());
        this.m_stoplightColorButton.setMaximumSize(this.m_stoplightColorButton.getPreferredSize());
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, 1));
        btnPanel.setAlignmentX(0.0f);
        btnPanel.add(this.m_newButton);
        btnPanel.add(Box.createVerticalStrut(5));
        btnPanel.add(this.m_stopButton);
        btnPanel.add(Box.createVerticalStrut(5));
        btnPanel.add(this.m_newHeaderButton);
        btnPanel.add(Box.createVerticalStrut(5));
        btnPanel.add(this.m_addButton);
        btnPanel.add(Box.createVerticalStrut(10));
        btnPanel.add(this.m_editButton);
        btnPanel.add(Box.createVerticalStrut(5));
        btnPanel.add(this.m_deleteButton);
        btnPanel.add(Box.createVerticalStrut(5));
        btnPanel.add(this.m_saveButton);
        btnPanel.add(Box.createVerticalStrut(10));
        btnPanel.add(this.m_stoplightColorButton);
        btnPanel.setMinimumSize(btnPanel.getPreferredSize());
        btnPanel.setMaximumSize(btnPanel.getPreferredSize());
        middleRightPanel.add(btnPanel);
        JPanel tmpPanelR = new JPanel();
        tmpPanelR.setPreferredSize(new Dimension(btnPanel.getPreferredSize().width + 10, this.viewFormatsPanel.getPreferredSize().height));
        tmpPanelR.setMinimumSize(tmpPanelR.getPreferredSize());
        tmpPanelR.setMaximumSize(tmpPanelR.getPreferredSize());
        this.viewFormatsPanel.add(tmpPanelR);
        this.middlePanel.add(middleLeftPanel);
        this.middlePanel.add(Box.createHorizontalStrut(5));
        this.middlePanel.add(middleCenterPanel);
        this.middlePanel.add(Box.createHorizontalStrut(10));
        this.middlePanel.add(middleRightPanel);
        this.add(this.middlePanel);
        translatedText = this.rBundle.getString("Hide Stoplight");
        this.m_hideStoplight = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_hideStoplight.setName("HideDataValuesForStoplightFormats");
        this.m_hideStoplight.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_hideStoplight.setSelected(gridView.isHideData());
        this.m_hideStoplight.addItemListener(this);
        tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        tmpPanel.setAlignmentX(0.0f);
        tmpPanel.add(Box.createHorizontalStrut(upDownPanel.getPreferredSize().width + 3));
        tmpPanel.add(this.m_hideStoplight);
        tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
        tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
        this.add(tmpPanel);
        this.addComponentListener(new 2());
    }

    protected void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
    }

    private void updateTextUsingCorrectLocale() {
        String translatedText = this.rBundle.getString("CrosstabDescription");
        if (this.m_gridView.getViewType() == 2) {
            translatedText = this.rBundle.getString("TableDescription");
        }
        if (this.m_descriptionLabel != null) {
            this.m_descriptionLabel.setText(translatedText);
            double textwidth = this.getToolkit().getFontMetrics(this.m_descriptionLabel.getFont()).stringWidth(this.m_descriptionLabel.getText());
            int rows = (int)Math.ceil(textwidth / (double)(this.getPreferredSize().width - 30));
            this.m_descriptionLabel.setPreferredRows(rows);
            this.m_descriptionLabel.setMaximumRows(rows);
            this.m_descriptionLabel.setMinimumRows(rows);
        }
        if (this.m_itemLabel != null) {
            translatedText = this.rBundle.getString("View formats for:");
            this.m_itemLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        }
        if (this.m_itemComboBox != null) {
            Object[] itemList = new Object[3];
            itemList[0] = this.rBundle.getString("Cell Formats");
            itemList[1] = this.rBundle.getString("Header Formats");
            int index = this.m_itemComboBox.getSelectedIndex();
            this.m_itemComboBox.removeAllItems();
            int i = 0;
            while (i < 2) {
                this.m_itemComboBox.addItem(itemList[i]);
                ++i;
            }
            this.m_itemComboBox.setSelectedIndex(index);
            this.m_itemLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_itemComboBox.setMinimumSize(this.m_itemComboBox.getPreferredSize());
            this.m_itemComboBox.setMaximumSize(this.m_itemComboBox.getPreferredSize());
        }
        if (this.m_newButton != null) {
            translatedText = this.rBundle.getString("Data New");
            this.m_newButton.setText(StringUtils.stripMnemonic((String)translatedText));
            this.m_newButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        }
        if (this.m_newHeaderButton != null) {
            translatedText = this.rBundle.getString("Header New");
            this.m_newHeaderButton.setText(StringUtils.stripMnemonic((String)translatedText));
            this.m_newHeaderButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        }
        if (this.m_editButton != null) {
            translatedText = this.rBundle.getString("Edit");
            this.m_editButton.setText(StringUtils.stripMnemonic((String)translatedText));
            this.m_editButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        }
        if (this.m_deleteButton != null) {
            translatedText = this.rBundle.getString("Delete");
            this.m_deleteButton.setText(StringUtils.stripMnemonic((String)translatedText));
            this.m_deleteButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        }
        if (this.m_addButton != null) {
            translatedText = this.rBundle.getString("Formats Add");
            this.m_addButton.setText(StringUtils.stripMnemonic((String)translatedText));
            this.m_addButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        }
        if (this.m_saveButton != null) {
            translatedText = this.rBundle.getString("Formats Save As");
            this.m_saveButton.setText(StringUtils.stripMnemonic((String)translatedText));
            this.m_saveButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        }
        if (this.m_stopButton != null) {
            translatedText = this.rBundle.getString("Stoplight New");
            this.m_stopButton.setText(StringUtils.stripMnemonic((String)translatedText));
            this.m_stopButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        }
        if (this.m_sampleLabel != null) {
            translatedText = this.rBundle.getString("Sample");
            this.m_sampleLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        }
        this.revalidate();
    }

    private void _init(UIGridView gridView) {
        this.m_formatsModel = new ASFormatModel(gridView);
        this.m_formatsTableModel = new FormatsTableModel();
        if (this.m_formatsTable != null) {
            this.m_formatsTable.setModel(this.m_formatsTableModel);
            this.m_formatsTableModel.setFormatType(this.m_itemComboBox.getSelectedIndex());
            this.m_formatsTable.getColumnModel().getColumn(0).setCellRenderer(new FormatTableCellRenderer());
            this.m_formatsTable.getColumnModel().getColumn(1).setCellRenderer(new AttributeCellRenderer());
            this.m_formatsTable.getColumnModel().getColumn(0).setCellEditor(new CheckBoxEditor());
            this.m_formatsTable.getSelectionModel().setSelectionInterval(0, 0);
            this.m_formatsTable.repaint();
        }
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        this.updateTextUsingCorrectLocale();
        if (this.m_formatsModel != null) {
            this.m_formatsModel.setLocale(loc);
        }
        if (!this.m_numberFormatSet) {
            DecimalFormat numFmt = (DecimalFormat)NumberFormat.getCurrencyInstance(super.getLocale());
            String prefix = numFmt.getPositivePrefix().trim();
            String suffix = numFmt.getPositiveSuffix().trim();
            this.m_numberFormatString = prefix != null && prefix.length() > 0 ? HEAD_CURR_DEFAULT_STR : (suffix != null && suffix.length() > 0 ? TAIL_CURR_DEFAULT_STR : HEAD_CURR_DEFAULT_STR);
        }
        if (!this.m_numberFormatSet) {
            DecimalFormat numFmt = (DecimalFormat)NumberFormat.getCurrencyInstance(super.getLocale());
            String prefix = numFmt.getPositivePrefix().trim();
            String suffix = numFmt.getPositiveSuffix().trim();
            this.m_numberFormatString = prefix != null && prefix.length() > 0 ? HEAD_CURR_DEFAULT_STR : (suffix != null && suffix.length() > 0 ? TAIL_CURR_DEFAULT_STR : HEAD_CURR_DEFAULT_STR);
        }
    }

    public void addHeaderDefaultFormat(String label, DiscriminatorRule rule) {
    }

    public void addDatabodyDefaultFormat(String label, DiscriminatorRule rule, int numberOrData) {
    }

    public void addUIFormat(UIFormat uiFormat, int index) {
        this.m_formatsTableModel.addFormat(uiFormat);
    }

    public void removeUIFormat(int group, int index) {
        this.m_formatsTableModel.deleteFormat(group, index);
    }

    public void removeAllUIFormats() {
        this.m_formatsTableModel.removeAllFormats();
    }

    public int getUIFormatCountInGroup(int group) {
        return this.m_formatsTableModel.getGroupSize(group);
    }

    public void setUIFormatSelected(int group, int index, boolean selected) {
        this.m_formatsTableModel.setSelected(group, index, selected);
    }

    public boolean isUIFormatSelected(int group, int index) {
        return this.m_formatsTableModel.isSelected(group, index);
    }

    public void setUIFormatNameCallBack(UIFormatNameCallBack formatNameCallBack) {
        this.m_formatNameCallBack = formatNameCallBack;
    }

    public UIFormatNameCallBack getUIFormatNameCallBack() {
        return this.m_formatNameCallBack;
    }

    public void addFilterElement(String name, int index) {
        this.m_itemComboBox.insertItemAt(name, index);
    }

    public void removeFilterElement(String name) {
        this.m_itemComboBox.removeItem(name);
    }

    public void removeFilterElementAt(int index) {
        this.m_itemComboBox.removeItemAt(index);
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public boolean apply() {
        return this.apply(this.m_gridView);
    }

    public boolean apply(UIGridView gridView) {
        if (gridView == null) {
            return false;
        }
        gridView.setBadColor(GridViewFormatUtils.getColorValue(this.m_badColor));
        gridView.setWarningColor(GridViewFormatUtils.getColorValue(this.m_warningColor));
        gridView.setGoodColor(GridViewFormatUtils.getColorValue(this.m_goodColor));
        int autoFitScope = this.m_gridView.getAutoFitScope();
        gridView.setAutoFitScope(0);
        gridView.setHideData(this.m_hideStoplight.isSelected());
        this.m_formatsModel.setDirty(true);
        this.m_formatsModel.apply();
        gridView.setFormatModel(this.m_formatsModel);
        gridView.setAutoFitScope(autoFitScope);
        gridView.dataAndMetadataStyleChanged();
        return true;
    }

    public Dimension getPreferredSize() {
        int width = Integer.parseInt(this.rBundle.getString("FormatsPanelWidth"));
        int height = Integer.parseInt(this.rBundle.getString("FormatsPanelHeight"));
        return new Dimension(width, height);
    }

    public void setApplicationName(String name) {
        this.m_applicationName = name;
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    public CustomObjectManager getCustomObjectManager() {
        return this.m_customObjectManager;
    }

    public void setCustomObjectManager(CustomObjectManager customObjectManager) {
        this.m_customObjectManager = customObjectManager;
        if (this.m_customObjectManager != null) {
            this.m_addButton.setEnabled(true);
        } else {
            this.m_addButton.setEnabled(false);
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_itemComboBox) {
            this.m_formatsTableModel.setFormatType(this.m_itemComboBox.getSelectedIndex());
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_newHeaderButton) {
            this.createExceptionBasedHeaderFormat(false);
        } else if (e.getSource() == this.m_newButton) {
            this.invokeConditonalFormat(null);
        } else if (e.getSource() == this.m_editButton) {
            UIFormat format = this.m_formatsTableModel.getFormatAt(this.m_formatsTable.getSelectedRow());
            int type = format.getFormatType();
            boolean selected = format.isSelected();
            String label = format.getName();
            int group = format.getGroup();
            Discriminator discriminator = format.getDiscriminator();
            boolean negativeRed = format.isNegativeRed();
            int numberOrDate = format.getNumberOrDateCategory();
            String patternString = format.getNumberOrDateFormatString();
            ConditionElement valueCondition = format.getValueCondition();
            ViewStyle vs = format.getViewStyle();
            if (vs == null) {
                vs = new ViewStyle();
            }
            ViewFormat vf = format.getViewFormat();
            if (group == 4) {
                this.invokeConditonalFormat(format);
            } else if (group == 3) {
                HeaderFormatGeneralPanel tmpHeaderFormatGeneralPanel = new HeaderFormatGeneralPanel(vs, this.m_gridView);
                tmpHeaderFormatGeneralPanel.setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
                FontPanel tmpFontPanel = new FontPanel(vs);
                tmpFontPanel.setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
                this.m_rulesPanel = this.getRulesPanel(this.m_gridView, discriminator, null, true);
                this.m_rulesPanel.setHelpProvider(this.getHelpProvider());
                tmpHeaderFormatGeneralPanel.setFormatName(label);
                JTabbedPane tmpTabbedPane = new JTabbedPane();
                String tabText = this.rBundle.getString("TabGeneral");
                tmpTabbedPane.add(tabText, tmpHeaderFormatGeneralPanel);
                tabText = this.rBundle.getString("TabFont");
                tmpTabbedPane.add(tabText, tmpFontPanel);
                tabText = this.rBundle.getString("TabMembers");
                tmpTabbedPane.add(tabText, this.m_rulesPanel);
                SamplePanel tmpSamplePanel = new SamplePanel(tmpHeaderFormatGeneralPanel, tmpFontPanel);
                tmpTabbedPane.setLocale(super.getLocale());
                tmpHeaderFormatGeneralPanel.setLocale(super.getLocale());
                tmpFontPanel.setLocale(super.getLocale());
                this.m_rulesPanel.setLocale(super.getLocale());
                tmpSamplePanel.setLocale(super.getLocale());
                tmpFontPanel.addPropertyChangeListener(tmpHeaderFormatGeneralPanel);
                tmpHeaderFormatGeneralPanel.addPropertyChangeListener(tmpFontPanel);
                JPanel tmpPanel = new JPanel();
                if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                    tmpPanel.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
                }
                tmpPanel.setLayout(new BoxLayout(tmpPanel, 1));
                tmpPanel.add(tmpTabbedPane);
                tmpPanel.add(tmpSamplePanel);
                tmpTabbedPane.setAlignmentX(0.0f);
                tmpSamplePanel.setAlignmentX(0.0f);
                PanelDialog tmpDialog = this.createPanelDialog(this.rBundle.getString("Edit Header"), true, tmpPanel, this.m_bHelpEnabled, 1, tmpTabbedPane, this.getHelpProvider());
                this.m_ok = false;
                tmpDialog.show();
                if (this.m_ok) {
                    tmpHeaderFormatGeneralPanel.apply(vs);
                    tmpFontPanel.apply();
                    discriminator = this.m_rulesPanel.getDiscriminator();
                    format.setDiscriminator(discriminator);
                    format.setViewStyle(vs);
                    format.setName(tmpHeaderFormatGeneralPanel.getFormatName());
                    this.m_formatsTableModel.setFormatAt(format, this.m_formatsTable.getSelectedRow());
                }
                tmpTabbedPane.removeAll();
                this.m_rulesPanel.removePropertyChangeListener(tmpSamplePanel);
                tmpDialog.cleanUp();
                tmpDialog.dispose();
                tmpPanel.remove(tmpSamplePanel);
                tmpFontPanel.cleanUp();
                tmpFontPanel = null;
                tmpHeaderFormatGeneralPanel.cleanUp();
                tmpHeaderFormatGeneralPanel = null;
                tmpSamplePanel.cleanUp();
                tmpSamplePanel = null;
            } else if (group == 5) {
                Container owner = this;
                while (owner != null) {
                    if (owner instanceof Dialog || owner instanceof Frame) break;
                    owner = SwingUtilities.getWindowAncestor(owner);
                }
                StoplightDialog dialog = null;
                dialog = owner instanceof Dialog ? new StoplightDialog((Dialog)owner, this.m_gridView, format, this.m_badColor, this.m_warningColor, this.m_goodColor) : new StoplightDialog((Frame)owner, this.m_gridView, format, this.m_badColor, this.m_warningColor, this.m_goodColor);
                dialog.setFormatsPanel(this);
                dialog.setTitle(this.rBundle.getString("STOPLIGHT.EDITTITLE"));
                dialog.setHelpProvider(this.m_helpProvider);
                if (dialog.runDialog()) {
                    format = dialog.getUIFormat();
                    this.m_formatsTableModel.setFormatAt(format, this.m_formatsTable.getSelectedRow());
                    this.m_badColor = dialog.getUnacceptableColor();
                    this.m_goodColor = dialog.getDesirableColor();
                    this.m_warningColor = dialog.getAcceptableColor();
                    this.m_formatsTableModel.refreshStoplightColor();
                    this.m_formatsTable.repaint();
                }
            }
        } else if (e.getSource() == this.m_deleteButton) {
            this.m_formatsTableModel.deleteFormat(this.m_formatsTable.getSelectedRow());
        } else if (e.getSource() == this.m_addButton) {
            ObjectBinding newObj = this.m_customObjectManager.loadObjectByType("Format");
            if (newObj == null) {
                this.m_isDialogOpen = false;
                return;
            }
            StringXMLizable _obj = newObj.getObject();
            if (_obj != null) {
                if (_obj instanceof UIFormat) {
                    UIFormat newFormat = (UIFormat)_obj;
                    this.m_formatsTableModel.addFormat(newFormat);
                } else {
                    String errorMsg = MessageFormat.format(this.rBundle.getString("ErrorFormat"), newObj.getLabelName());
                    JDialog tmpDialog = new JOptionPane(errorMsg, 0, -1, new ImageIcon(ImageUtils.getImageResource(FormatsPanel.class, (String)"images/stop.gif"))).createDialog(this, this.m_applicationName);
                    tmpDialog.show();
                }
            }
        } else if (e.getSource() == this.m_saveButton) {
            UIFormat tmpUIFormats = this.m_formatsTableModel.getFormatAt(this.m_formatsTable.getSelectedRow());
            ObjectBinding newObj = this.m_customObjectManager.saveObjectByType("Format", (StringXMLizable)tmpUIFormats);
        } else if (e.getSource() == this.m_upButton) {
            this.m_formatsTableModel.moveUp(this.m_formatsTable.getSelectedRow());
        } else if (e.getSource() == this.m_downButton) {
            this.m_formatsTableModel.moveDown(this.m_formatsTable.getSelectedRow());
        } else if (e.getSource() == this.m_stoplightColorButton) {
            Container owner = this;
            while (owner != null) {
                if (owner instanceof Dialog || owner instanceof Frame) break;
                owner = SwingUtilities.getWindowAncestor(owner);
            }
            StoplightColorDialog dialog = null;
            dialog = owner instanceof Dialog ? new StoplightColorDialog((Dialog)owner, this.m_gridView, this.m_badColor, this.m_warningColor, this.m_goodColor) : new StoplightColorDialog((Frame)owner, this.m_gridView, this.m_badColor, this.m_warningColor, this.m_goodColor);
            dialog.setHelpProvider(this.m_helpProvider);
            if (dialog.runDialog()) {
                this.m_badColor = dialog.getUnacceptableColor();
                this.m_goodColor = dialog.getDesirableColor();
                this.m_warningColor = dialog.getAcceptableColor();
                this.m_formatsTableModel.refreshStoplightColor();
                this.m_formatsTable.repaint();
            }
        } else if (e.getSource() == this.m_stopButton) {
            Container owner = this;
            while (owner != null) {
                if (owner instanceof Dialog || owner instanceof Frame) break;
                owner = SwingUtilities.getWindowAncestor(owner);
            }
            StoplightDialog dialog = null;
            dialog = owner instanceof Dialog ? new StoplightDialog((Dialog)owner, this.m_gridView, null, this.m_badColor, this.m_warningColor, this.m_goodColor) : new StoplightDialog((Frame)owner, this.m_gridView, null, this.m_badColor, this.m_warningColor, this.m_goodColor);
            dialog.setFormatsPanel(this);
            dialog.setHelpProvider(this.m_helpProvider);
            if (dialog.runDialog()) {
                UIFormat format = dialog.getUIFormat();
                this.m_formatsTableModel.addFormat(format);
                this.m_badColor = dialog.getUnacceptableColor();
                this.m_goodColor = dialog.getDesirableColor();
                this.m_warningColor = dialog.getAcceptableColor();
                this.m_formatsTableModel.refreshStoplightColor();
                this.m_formatsTable.repaint();
            }
        }
    }

    public abstract void invokeConditonalFormat(UIFormat var1);

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void contentsChanged(ListDataEvent e) {
        if (this.m_itemList != null) {
            this.m_itemList.repaint();
        }
    }

    public void intervalRemoved(ListDataEvent e) {
    }

    public void intervalAdded(ListDataEvent e) {
    }

    public static int getFormatNumber() {
        return ++m_formatNumber;
    }

    public void setDefaultNumberFormatString(String numberFormat) {
        this.m_numberFormatString = numberFormat;
        this.m_numberFormatSet = true;
    }

    public String getDefaultNumberFormatString() {
        return this.m_numberFormatString;
    }

    public void setDefaultDateFormatString(String dateFormat) {
        this.m_dateFormatString = dateFormat;
        this.m_dateFormatSet = true;
    }

    public String getDefaultDateFormatString() {
        return this.m_dateFormatString;
    }

    public void setCustomFormatList(Vector list, int type) {
        if (type == 0) {
            this.m_numberCustomList = list;
        } else if (type == 1) {
            this.m_dateCustomList = list;
        }
    }

    public Vector getCustomFormatList(int type) {
        if (type == 0) {
            return this.m_numberCustomList;
        }
        if (type == 1) {
            return this.m_dateCustomList;
        }
        return null;
    }

    public void createExceptionBasedHeaderFormat() {
        this.createExceptionBasedHeaderFormat(true);
    }

    protected void createExceptionBasedHeaderFormat(boolean b) {
        HeaderFormatGeneralPanel tmpHeaderFormatGeneralPanel = new HeaderFormatGeneralPanel(new ViewStyle(), this.m_gridView);
        tmpHeaderFormatGeneralPanel.setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
        ViewStyle tmpViewStyle = new ViewStyle();
        FontPanel tmpFontPanel = new FontPanel(tmpViewStyle);
        tmpFontPanel.setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
        this.m_gridView.setUIFormatCount(this.m_gridView.getUIFormatCount() + 1);
        String translatedText = MessageFormat.format(this.rBundle.getString("HeaderFormat"), String.valueOf(this.m_gridView.getUIFormatCount()));
        tmpHeaderFormatGeneralPanel.setFormatName(translatedText);
        this.m_rulesPanel = this.getRulesPanel(this.m_gridView, true);
        this.m_rulesPanel.setHelpProvider(this.getHelpProvider());
        JTabbedPane tmpTabbedPane = new JTabbedPane();
        String tabText = this.rBundle.getString("TabGeneral");
        tmpTabbedPane.add(tabText, tmpHeaderFormatGeneralPanel);
        tabText = this.rBundle.getString("TabFont");
        tmpTabbedPane.add(tabText, tmpFontPanel);
        tabText = this.rBundle.getString("TabMembers");
        tmpTabbedPane.add(tabText, this.m_rulesPanel);
        SamplePanel tmpSamplePanel = new SamplePanel(tmpHeaderFormatGeneralPanel, tmpFontPanel);
        JPanel tmpPanel = new JPanel();
        if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
            tmpPanel.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
        }
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 1));
        tmpPanel.add(tmpTabbedPane);
        tmpPanel.add(tmpSamplePanel);
        tmpTabbedPane.setAlignmentX(0.0f);
        tmpSamplePanel.setAlignmentX(0.0f);
        tmpFontPanel.addPropertyChangeListener(tmpHeaderFormatGeneralPanel);
        tmpHeaderFormatGeneralPanel.addPropertyChangeListener(tmpFontPanel);
        tmpTabbedPane.setLocale(super.getLocale());
        tmpHeaderFormatGeneralPanel.setLocale(super.getLocale());
        tmpFontPanel.setLocale(super.getLocale());
        this.m_rulesPanel.setLocale(super.getLocale());
        tmpSamplePanel.setLocale(super.getLocale());
        PanelDialog tmpDialog = this.createPanelDialog(this.rBundle.getString("Format Header"), true, tmpPanel, this.m_bHelpEnabled, 1, tmpTabbedPane, this.getHelpProvider());
        this.m_ok = false;
        tmpDialog.show();
        if (this.m_ok) {
            Discriminator discriminator = this.m_rulesPanel.getDiscriminator();
            tmpFontPanel.apply();
            tmpHeaderFormatGeneralPanel.apply(tmpViewStyle);
            UIFormat format = new UIFormat(tmpHeaderFormatGeneralPanel.getFormatName(), 0, 3, 3, discriminator, tmpViewStyle, null, false, 0, "");
            this.m_formatsTableModel.addFormat(format);
            if (b) {
                this.apply();
            }
        }
        tmpDialog.cleanUp();
        tmpDialog.dispose();
        this.m_rulesPanel.removePropertyChangeListener(tmpSamplePanel);
        tmpFontPanel.removePropertyChangeListener(tmpHeaderFormatGeneralPanel);
        tmpHeaderFormatGeneralPanel.removePropertyChangeListener(tmpFontPanel);
        tmpTabbedPane.removeAll();
        tmpFontPanel.cleanUp();
        tmpFontPanel = null;
        tmpHeaderFormatGeneralPanel.cleanUp();
        tmpHeaderFormatGeneralPanel = null;
        tmpSamplePanel.cleanUp();
        tmpSamplePanel = null;
    }

    public void createExceptionBasedDataFormat() {
        this.createExceptionBasedDataFormat(true);
    }

    protected void createExceptionBasedDataFormat(boolean b) {
        NumberFormatPanel tmpNumberFormatPanel = null;
        DatePanel tmpDatePanel = null;
        boolean isDate = false;
        boolean isNumber = false;
        FormatGeneralPanel tmpFormatGeneralPanel = new FormatGeneralPanel(new ViewStyle());
        tmpFormatGeneralPanel.setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
        boolean visible = false;
        if (this.m_gridView.getModel() != null && this.m_gridView.getModel().getDataDirector() != null && this.m_gridView.getModel().getDataDirector().getSupportedDataMap() != null) {
            visible = this.m_gridView.getModel().getDataDirector().getSupportedDataMap().contains((Object)"dataRatio");
        }
        tmpFormatGeneralPanel.setDataBarOptionVisible(visible);
        ViewStyle tmpViewStyle = new ViewStyle();
        FontPanel tmpFontPanel = new FontPanel(tmpViewStyle);
        tmpFontPanel.setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
        this.m_gridView.setUIFormatCount(this.m_gridView.getUIFormatCount() + 1);
        String translatedText = MessageFormat.format(this.rBundle.getString("CellFormat"), String.valueOf(this.m_gridView.getUIFormatCount()));
        tmpFormatGeneralPanel.setFormatName(translatedText);
        ViewFormat tmpViewFormat = new ViewFormat();
        tmpViewFormat.setLocale(this.m_gridView.getLocale());
        tmpNumberFormatPanel = new NumberFormatPanel(tmpViewFormat);
        tmpNumberFormatPanel.setLocale(this.m_gridView.getLocale());
        tmpNumberFormatPanel.setCustomPatternStringList(this.m_numberCustomList);
        tmpDatePanel = new DatePanel(null);
        tmpDatePanel.setLocale(super.getLocale());
        tmpDatePanel.setErrorHandler(this.getErrorHandler());
        tmpDatePanel.setCustomList(this.m_dateCustomList);
        this.m_rulesPanel = this.getRulesPanel(this.m_gridView, false);
        this.m_rulesPanel.setHelpProvider(this.getHelpProvider());
        JTabbedPane tmpTabbedPane = new JTabbedPane();
        String tabText = this.rBundle.getString("TabGeneral");
        tmpTabbedPane.add(tabText, tmpFormatGeneralPanel);
        tabText = this.rBundle.getString("TabFont");
        tmpTabbedPane.add(tabText, tmpFontPanel);
        SamplePanel tmpSamplePanel = null;
        tabText = this.rBundle.getString("TabNumber");
        tmpTabbedPane.add(tabText, tmpNumberFormatPanel);
        tabText = this.rBundle.getString("TabDate");
        tmpTabbedPane.add(tabText, tmpDatePanel);
        tmpSamplePanel = new SamplePanel(tmpFormatGeneralPanel, tmpFontPanel, tmpNumberFormatPanel, tmpDatePanel);
        tabText = this.rBundle.getString("TabRules");
        tmpTabbedPane.add(tabText, this.m_rulesPanel);
        tmpTabbedPane.setMinimumSize(tmpTabbedPane.getPreferredSize());
        tmpFontPanel.addPropertyChangeListener(tmpFormatGeneralPanel);
        tmpFormatGeneralPanel.addPropertyChangeListener(tmpFontPanel);
        JPanel tmpPanel = new JPanel();
        if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
            tmpPanel.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
        }
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 1));
        tmpPanel.add(tmpTabbedPane);
        tmpPanel.add(tmpSamplePanel);
        tmpTabbedPane.setAlignmentX(0.0f);
        tmpSamplePanel.setAlignmentX(0.0f);
        PanelDialog tmpDialog = this.createPanelDialog(this.rBundle.getString("Format Data"), true, tmpPanel, this.m_bHelpEnabled, 1, tmpTabbedPane, this.getHelpProvider());
        tmpTabbedPane.setLocale(super.getLocale());
        tmpFontPanel.setLocale(super.getLocale());
        this.m_rulesPanel.setLocale(super.getLocale());
        tmpSamplePanel.setLocale(super.getLocale());
        tmpFormatGeneralPanel.setLocale(super.getLocale());
        this.m_rulesPanel.addPropertyChangeListener(tmpFormatGeneralPanel);
        this.m_ok = false;
        tmpDialog.show();
        if (this.m_ok) {
            Discriminator discriminator = this.m_rulesPanel.getDiscriminator();
            ViewFormat viewFormat = null;
            if (isNumber && !isDate) {
                viewFormat = tmpNumberFormatPanel.apply();
            } else if (!isNumber && isDate) {
                tmpDatePanel.apply();
                viewFormat = (ViewFormat)((Object)tmpDatePanel.getViewFormat().clone());
            } else {
                ViewFormat v1 = tmpNumberFormatPanel.apply();
                tmpDatePanel.apply();
                if (tmpDatePanel.getViewFormat() != null) {
                    viewFormat = (ViewFormat)((Object)tmpDatePanel.getViewFormat().clone());
                    if (v1 != null) {
                        viewFormat.merge((Mergeable)v1);
                    }
                } else if (v1 != null) {
                    viewFormat = v1;
                }
            }
            String patternString = "";
            tmpFontPanel.apply();
            tmpFormatGeneralPanel.apply(tmpViewStyle);
            boolean negativeRed = false;
            negativeRed = tmpNumberFormatPanel.isNegativeRed();
            int numberOrDate = 0;
            if (tmpNumberFormatPanel != null) {
                if (tmpNumberFormatPanel.getFormatType() == 5) {
                    patternString = tmpNumberFormatPanel.getCurrentCustomPatternString();
                }
                numberOrDate = tmpNumberFormatPanel.getFormatType() << 4;
            } else {
                numberOrDate = 240;
            }
            numberOrDate = tmpDatePanel != null ? (numberOrDate |= tmpDatePanel.getCategoryType()) : (numberOrDate |= 0xF);
            int type = viewFormat == null ? 1 : 3;
            UIFormat format = new UIFormat(tmpFormatGeneralPanel.getFormatName(), type, 3, 4, discriminator, tmpViewStyle, viewFormat, negativeRed, numberOrDate, patternString);
            format.setValueCondition(this.m_rulesPanel.getValueCondition());
            this.m_formatsTableModel.addFormat(format);
            if (b) {
                this.apply();
            }
            this.m_numberCustomList = tmpNumberFormatPanel.getCustomPatternStringList();
            this.m_dateCustomList = tmpDatePanel.getCustomList();
        }
        tmpDialog.cleanUp();
        tmpDialog.dispose();
        this.m_rulesPanel.removePropertyChangeListener(tmpSamplePanel);
        tmpFontPanel.removePropertyChangeListener(tmpFormatGeneralPanel);
        tmpFormatGeneralPanel.removePropertyChangeListener(tmpFontPanel);
        tmpTabbedPane.removeAll();
        tmpPanel.remove(tmpSamplePanel);
        tmpSamplePanel.cleanUp();
        tmpSamplePanel = null;
        tmpFontPanel.cleanUp();
        tmpFontPanel = null;
        if (tmpDatePanel != null) {
            tmpDatePanel.cleanUp();
            tmpDatePanel = null;
        }
        if (tmpNumberFormatPanel != null) {
            tmpNumberFormatPanel.cleanUp();
            tmpNumberFormatPanel = null;
        }
        this.m_rulesPanel.removePropertyChangeListener(tmpFormatGeneralPanel);
        tmpFormatGeneralPanel.cleanUp();
        tmpFormatGeneralPanel = null;
    }

    public void createSelectionBasedFormat() {
        ComponentHandle handle = this.m_gridView.getSelectedObject();
        if (handle != null) {
            FontPanel tmpFontPanel;
            ViewStyle tmpViewStyle;
            JPanel tmpFormatGeneralPanel;
            ViewStyle vs;
            int type = 2;
            type = handle.getID() == 12 || handle.getID() == 13 || handle.getID() == 14 || handle.getID() == 15 || handle.getID() == 16 || handle.getID() == 19 || handle.getID() == 20 ? 2 : 1;
            Discriminator disc = this.getSelectionDisc();
            NumberFormatPanel tmpNumberFormatPanel = null;
            DatePanel tmpDatePanel = null;
            boolean isDate = false;
            boolean isNumber = false;
            if (type == 2) {
                if (handle.getID() == 13) {
                    DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
                    try {
                        int i = 0;
                        while (i < dataAccess.getEdgeExtent(1)) {
                            int j = 0;
                            while (j < dataAccess.getEdgeExtent(0)) {
                                Object value = dataAccess.getValue(i, j, "dataValue");
                                if (value instanceof Date) {
                                    isDate = true;
                                }
                                if (value instanceof Number) {
                                    isNumber = true;
                                }
                                if (isNumber && isDate) break;
                                ++j;
                            }
                            if (!isNumber || !isDate) {
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception eee) {}
                } else if (handle instanceof DataRangeComponentHandle) {
                    DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
                    DataComponentInfo[] ci = ((DataRangeComponentHandle)this.m_gridView.getSelectedObject()).getLocationList();
                    int i = 0;
                    while (i < ci.length) {
                        try {
                            Object value = dataAccess.getValue(ci[i].getRow(), ci[i].getColumn(), "dataValue");
                            if (value instanceof Date) {
                                isDate = true;
                            }
                            if (value instanceof Number) {
                                isNumber = true;
                            }
                        }
                        catch (Exception eee) {
                            // empty catch block
                        }
                        if (!isNumber || !isDate) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                } else if (this.m_gridView.getSelectedObject() instanceof DataComponentHandle) {
                    DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
                    Object value = null;
                    try {
                        value = dataAccess.getValue(((DataComponentHandle)this.m_gridView.getSelectedObject()).getRow(), ((DataComponentHandle)this.m_gridView.getSelectedObject()).getColumn(), "dataValue");
                    }
                    catch (Exception eee) {
                        // empty catch block
                    }
                    if (value instanceof Date) {
                        isDate = true;
                    }
                    if (value instanceof Number) {
                        isNumber = true;
                    }
                } else if (handle instanceof ColumnComponentHandle) {
                    DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
                    int column = ((ColumnComponentInfo)this.m_gridView.getSelectedObject().getComponentInfo()).getColumn();
                    try {
                        int rowNumber = dataAccess.getEdgeExtent(1);
                        int i = 0;
                        while (i < rowNumber) {
                            try {
                                Object value = dataAccess.getValue(i, column, "dataValue");
                                if (value instanceof Date) {
                                    isDate = true;
                                }
                                if (value instanceof Number) {
                                    isNumber = true;
                                }
                            }
                            catch (Exception eee) {
                                // empty catch block
                            }
                            if (!isNumber || !isDate) {
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception data) {}
                } else if (handle instanceof RowComponentHandle) {
                    DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
                    int row = ((RowComponentInfo)this.m_gridView.getSelectedObject().getComponentInfo()).getRow();
                    try {
                        int columnNumber = dataAccess.getEdgeExtent(1);
                        int i = 0;
                        while (i < columnNumber) {
                            try {
                                Object value = dataAccess.getValue(row, i, "dataValue");
                                if (value instanceof Date) {
                                    isDate = true;
                                }
                                if (value instanceof Number) {
                                    isNumber = true;
                                }
                            }
                            catch (Exception eee) {
                                // empty catch block
                            }
                            if (!isNumber || !isDate) {
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception data) {}
                } else if (handle instanceof ColumnRangeComponentHandle) {
                    ColumnComponentInfo[] ci = ((ColumnRangeComponentHandle)this.m_gridView.getSelectedObject()).getLocationList();
                    DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
                    int columnIndex = 0;
                    while (columnIndex < ci.length) {
                        int column = ci[columnIndex].getColumn();
                        try {
                            int rowNumber = dataAccess.getEdgeExtent(1);
                            int i = 0;
                            while (i < rowNumber) {
                                try {
                                    Object value = dataAccess.getValue(i, column, "dataValue");
                                    if (value instanceof Date) {
                                        isDate = true;
                                    }
                                    if (value instanceof Number) {
                                        isNumber = true;
                                    }
                                }
                                catch (Exception eee) {
                                    // empty catch block
                                }
                                if (!isNumber || !isDate) {
                                    ++i;
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception data) {
                            // empty catch block
                        }
                        ++columnIndex;
                    }
                } else if (handle instanceof RowRangeComponentHandle) {
                    RowComponentInfo[] ci = ((RowRangeComponentHandle)this.m_gridView.getSelectedObject()).getLocationList();
                    DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
                    int rowIndex = 0;
                    while (rowIndex < ci.length) {
                        int row = ci[rowIndex].getRow();
                        try {
                            int columnNumber = dataAccess.getEdgeExtent(1);
                            int i = 0;
                            while (i < columnNumber) {
                                try {
                                    Object value = dataAccess.getValue(row, i, "dataValue");
                                    if (value instanceof Date) {
                                        isDate = true;
                                    }
                                    if (value instanceof Number) {
                                        isNumber = true;
                                    }
                                }
                                catch (Exception eee) {
                                    // empty catch block
                                }
                                if (!isNumber || !isDate) {
                                    ++i;
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception data) {
                            // empty catch block
                        }
                        ++rowIndex;
                    }
                }
            }
            if ((vs = ((GridViewAttribute)this.m_gridView).getComponentViewStyle(this.m_gridView.getSelectedObject())) != null) {
                if (type == 2) {
                    tmpFormatGeneralPanel = new FormatGeneralPanel((ViewStyle)vs.clone());
                    ((FormatGeneralPanel)tmpFormatGeneralPanel).setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
                    boolean visible = false;
                    if (this.m_gridView.getModel() != null && this.m_gridView.getModel().getDataDirector() != null && this.m_gridView.getModel().getDataDirector().getSupportedDataMap() != null) {
                        visible = this.m_gridView.getModel().getDataDirector().getSupportedDataMap().contains((Object)"dataRatio");
                    }
                    ((FormatGeneralPanel)tmpFormatGeneralPanel).setDataBarOptionVisible(visible);
                } else {
                    tmpFormatGeneralPanel = new HeaderFormatGeneralPanel((ViewStyle)vs.clone(), this.m_gridView);
                    ((HeaderFormatGeneralPanel)tmpFormatGeneralPanel).setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
                }
                tmpViewStyle = (ViewStyle)vs.clone();
                tmpFontPanel = new FontPanel(tmpViewStyle, 1);
                tmpFontPanel.setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
            } else {
                if (type == 2) {
                    tmpFormatGeneralPanel = new FormatGeneralPanel((ViewStyle)this.m_gridView.getDatabody().getViewStyle().clone());
                    ((FormatGeneralPanel)tmpFormatGeneralPanel).setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
                    boolean visible = false;
                    if (this.m_gridView.getModel() != null && this.m_gridView.getModel().getDataDirector() != null && this.m_gridView.getModel().getDataDirector().getSupportedDataMap() != null) {
                        visible = this.m_gridView.getModel().getDataDirector().getSupportedDataMap().contains((Object)"dataRatio");
                    }
                    ((FormatGeneralPanel)tmpFormatGeneralPanel).setDataBarOptionVisible(visible);
                } else {
                    tmpFormatGeneralPanel = new HeaderFormatGeneralPanel((ViewStyle)this.m_gridView.getDatabody().getViewStyle().clone(), this.m_gridView);
                    ((HeaderFormatGeneralPanel)tmpFormatGeneralPanel).setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
                }
                tmpViewStyle = (ViewStyle)this.m_gridView.getDatabody().getViewStyle().clone();
                tmpFontPanel = new FontPanel(tmpViewStyle, 1);
                tmpFontPanel.setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
            }
            this.m_gridView.setToolbarUIFormatCount(this.m_gridView.getToolbarUIFormatCount() + 1);
            String translatedText = MessageFormat.format(this.rBundle.getString("SelectionFormat"), String.valueOf(this.m_gridView.getToolbarUIFormatCount()));
            if (type == 2) {
                ((FormatGeneralPanel)tmpFormatGeneralPanel).setFormatName(translatedText);
                ViewFormat vf = ((GridViewAttribute)this.m_gridView).getComponentViewFormat(handle);
                if (vf != null) {
                    if (isNumber) {
                        ViewFormat vf1 = (ViewFormat)((Object)vf.clone());
                        vf1.setLocale(this.m_gridView.getLocale());
                        tmpNumberFormatPanel = new NumberFormatPanel(vf1);
                        tmpNumberFormatPanel.setLocale(this.m_gridView.getLocale());
                        if (vf1.getNumberType() == 0) {
                            tmpNumberFormatPanel.setFormatType(2);
                        } else if (vf1.getNumberType() == 1) {
                            tmpNumberFormatPanel.setFormatType(3);
                        } else if (vf1.getNumberType() == 2) {
                            tmpNumberFormatPanel.setFormatType(4);
                        } else {
                            tmpNumberFormatPanel.setFormatType(0);
                        }
                    }
                    if (isDate) {
                        tmpDatePanel = new DatePanel((ViewFormat)((Object)vf.clone()));
                        tmpDatePanel.setLocale(super.getLocale());
                        tmpDatePanel.setErrorHandler(this.getErrorHandler());
                    }
                } else {
                    vf = new ViewFormat();
                    vf.setLocale(this.m_gridView.getLocale());
                    tmpNumberFormatPanel = new NumberFormatPanel(vf);
                    tmpNumberFormatPanel.setLocale(this.m_gridView.getLocale());
                    tmpDatePanel = new DatePanel(null);
                    tmpDatePanel.setLocale(super.getLocale());
                    tmpDatePanel.setErrorHandler(this.getErrorHandler());
                }
                if (tmpNumberFormatPanel != null) {
                    if (this.m_numberFormatSet) {
                        tmpNumberFormatPanel.setDefaultFormat(this.getDefaultNumberFormatString());
                    }
                    tmpNumberFormatPanel.setCustomPatternStringList(this.m_numberCustomList);
                }
                if (tmpDatePanel != null) {
                    if (this.m_dateFormatSet) {
                        tmpDatePanel.setDefaultDateFormatString(this.getDefaultDateFormatString());
                    }
                    tmpDatePanel.setCustomList(this.m_dateCustomList);
                }
            } else {
                ((HeaderFormatGeneralPanel)tmpFormatGeneralPanel).setFormatName(translatedText);
            }
            JTabbedPane tmpTabbedPane = new JTabbedPane();
            String tabText = this.rBundle.getString("TabGeneral");
            tmpTabbedPane.add(tabText, tmpFormatGeneralPanel);
            tabText = this.rBundle.getString("TabFont");
            tmpTabbedPane.add(tabText, tmpFontPanel);
            SamplePanel tmpSamplePanel = null;
            if (type == 2) {
                if (isDate && isNumber) {
                    tabText = this.rBundle.getString("TabNumber");
                    tmpTabbedPane.add(tabText, tmpNumberFormatPanel);
                    tabText = this.rBundle.getString("TabDate");
                    tmpTabbedPane.add(tabText, tmpDatePanel);
                    tmpSamplePanel = new SamplePanel((FormatGeneralPanel)tmpFormatGeneralPanel, tmpFontPanel, tmpNumberFormatPanel, tmpDatePanel);
                } else if (isNumber) {
                    tabText = this.rBundle.getString("TabNumber");
                    tmpTabbedPane.add(tabText, tmpNumberFormatPanel);
                    tmpSamplePanel = new SamplePanel((FormatGeneralPanel)tmpFormatGeneralPanel, tmpFontPanel, tmpNumberFormatPanel);
                } else if (isDate) {
                    tabText = this.rBundle.getString("TabDate");
                    tmpTabbedPane.add(tabText, tmpDatePanel);
                    tmpSamplePanel = new SamplePanel((FormatGeneralPanel)tmpFormatGeneralPanel, tmpFontPanel, tmpDatePanel);
                } else {
                    tabText = this.rBundle.getString("TabNumber");
                    tmpTabbedPane.add(tabText, tmpNumberFormatPanel);
                    tabText = this.rBundle.getString("TabDate");
                    tmpTabbedPane.add(tabText, tmpDatePanel);
                    tmpSamplePanel = new SamplePanel((FormatGeneralPanel)tmpFormatGeneralPanel, tmpFontPanel, tmpNumberFormatPanel, tmpDatePanel);
                }
            } else {
                tmpSamplePanel = new SamplePanel((HeaderFormatGeneralPanel)tmpFormatGeneralPanel, tmpFontPanel);
            }
            tmpTabbedPane.setMinimumSize(tmpTabbedPane.getPreferredSize());
            JPanel tmpPanel = new JPanel();
            if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                tmpPanel.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
            }
            tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
            tmpPanel.add(tmpTabbedPane);
            tmpPanel.add(Box.createHorizontalStrut(10));
            tmpPanel.add(tmpSamplePanel);
            tmpSamplePanel.setMaximumSize(new Dimension(tmpSamplePanel.getPreferredSize().width, tmpSamplePanel.getMaximumSize().height));
            PanelDialog tmpDialog = type == 2 ? this.createPanelDialog(this.rBundle.getString("Format Selection Data"), true, tmpPanel, this.m_bHelpEnabled, 1, tmpTabbedPane, this.getHelpProvider()) : this.createPanelDialog(this.rBundle.getString("Format Selection Header"), true, tmpPanel, this.m_bHelpEnabled, 1, tmpTabbedPane, this.getHelpProvider());
            if (type == 2) {
                tmpFontPanel.addPropertyChangeListener((FormatGeneralPanel)tmpFormatGeneralPanel);
            } else {
                tmpFontPanel.addPropertyChangeListener((HeaderFormatGeneralPanel)tmpFormatGeneralPanel);
            }
            tmpFormatGeneralPanel.addPropertyChangeListener(tmpFontPanel);
            tmpTabbedPane.setLocale(super.getLocale());
            tmpFontPanel.setLocale(super.getLocale());
            tmpSamplePanel.setLocale(super.getLocale());
            tmpFormatGeneralPanel.setLocale(super.getLocale());
            this.m_ok = false;
            tmpDialog.show();
            if (this.m_ok) {
                tmpFontPanel.apply();
                if (type == 2) {
                    ((FormatGeneralPanel)tmpFormatGeneralPanel).apply(tmpViewStyle);
                } else {
                    ((HeaderFormatGeneralPanel)tmpFormatGeneralPanel).apply(tmpViewStyle);
                }
                int numberOrDate = 0;
                String patternString = "";
                boolean negativeRed = false;
                String formatName = type == 2 ? ((FormatGeneralPanel)tmpFormatGeneralPanel).getFormatName() : ((HeaderFormatGeneralPanel)tmpFormatGeneralPanel).getFormatName();
                if (type == 2) {
                    ViewFormat viewFormat = null;
                    if (isNumber && !isDate) {
                        viewFormat = tmpNumberFormatPanel.apply();
                    } else if (!isNumber && isDate) {
                        tmpDatePanel.apply();
                        viewFormat = (ViewFormat)((Object)tmpDatePanel.getViewFormat().clone());
                    } else {
                        ViewFormat v1 = tmpNumberFormatPanel.apply();
                        tmpDatePanel.apply();
                        if (tmpDatePanel.getViewFormat() != null) {
                            viewFormat = (ViewFormat)((Object)tmpDatePanel.getViewFormat().clone());
                            if (v1 != null) {
                                viewFormat.merge((Mergeable)v1);
                            }
                        } else if (v1 != null) {
                            viewFormat = v1;
                        }
                    }
                    if (tmpNumberFormatPanel != null) {
                        negativeRed = tmpNumberFormatPanel.isNegativeRed();
                    }
                    if (tmpNumberFormatPanel != null) {
                        if (tmpNumberFormatPanel.getFormatType() == 5) {
                            patternString = tmpNumberFormatPanel.getCurrentCustomPatternString();
                        }
                        numberOrDate = tmpNumberFormatPanel.getFormatType() << 4;
                        this.m_numberCustomList = tmpNumberFormatPanel.getCustomPatternStringList();
                    } else {
                        numberOrDate = 240;
                    }
                    if (tmpDatePanel != null) {
                        numberOrDate |= tmpDatePanel.getCategoryType();
                        this.m_dateCustomList = tmpDatePanel.getCustomList();
                    } else {
                        numberOrDate |= 0xF;
                    }
                    this.m_formatsTableModel.addFormat(new UIFormat(formatName, 3, 3, type, disc, tmpViewStyle, viewFormat, negativeRed, numberOrDate, patternString));
                } else {
                    this.m_formatsTableModel.addFormat(new UIFormat(formatName, 0, 3, type, disc, tmpViewStyle, null, false, -1, ""));
                }
            }
            tmpDialog.cleanUp();
            tmpDialog.dispose();
            tmpTabbedPane.removeAll();
            tmpPanel.remove(tmpSamplePanel);
            tmpSamplePanel.cleanUp();
            tmpSamplePanel = null;
            if (type == 2) {
                tmpFontPanel.removePropertyChangeListener((FormatGeneralPanel)tmpFormatGeneralPanel);
            } else {
                tmpFontPanel.removePropertyChangeListener((HeaderFormatGeneralPanel)tmpFormatGeneralPanel);
            }
            tmpFormatGeneralPanel.removePropertyChangeListener(tmpFontPanel);
            tmpFontPanel.cleanUp();
            tmpFontPanel = null;
            if (tmpDatePanel != null) {
                tmpDatePanel.cleanUp();
                tmpDatePanel = null;
            }
            if (tmpNumberFormatPanel != null) {
                tmpNumberFormatPanel.cleanUp();
                tmpNumberFormatPanel = null;
            }
            if (type == 2) {
                ((FormatGeneralPanel)tmpFormatGeneralPanel).cleanUp();
            } else {
                ((HeaderFormatGeneralPanel)tmpFormatGeneralPanel).cleanUp();
            }
            tmpFormatGeneralPanel = null;
            this.apply();
        }
    }

    public void cleanUp() {
        this.m_mouseListener = null;
        this.m_keyListener = null;
        this.m_scrollPane.setViewportView(null);
        this.m_rulesPanel = null;
    }

    protected abstract Discriminator getSelectionDisc();

    private boolean _isLeftHeading() {
        String language;
        Locale loc = this.getLocale();
        if (loc == null) {
            loc = Locale.getDefault();
        }
        return !(language = loc.getLanguage()).equals("ar") && !language.equals("he") && !language.equals("iw");
    }

    private void $init$() {
        this.rBundle = null;
        this.isSetFocus = true;
        this.m_isDialogOpen = false;
        this.m_customObjectManager = null;
        this.m_formatNameCallBack = null;
        this.m_oldID = -1;
        this.m_numberFormatString = HEAD_CURR_DEFAULT_STR;
        this.m_dateFormatString = "";
        this.m_numberFormatSet = false;
        this.m_dateFormatSet = false;
        this.m_bSuperCalled = false;
        this.m_eh = null;
        this.m_numberCustomList = null;
        this.m_dateCustomList = null;
    }

    protected PanelDialog createPanelDialog(String title, boolean modal, JPanel p, boolean bHelpEnabled, int action, JTabbedPane tabbedPane, HelpProvider helpProvider) {
        Container owner = this;
        while (owner != null) {
            if (owner instanceof Dialog) {
                return new PanelDialog((Dialog)owner, title, modal, p, bHelpEnabled, action, tabbedPane, helpProvider);
            }
            if (owner instanceof Frame) {
                return new PanelDialog((Frame)owner, title, modal, p, bHelpEnabled, action, tabbedPane, helpProvider);
            }
            owner = SwingUtilities.getWindowAncestor(owner);
        }
        if (owner == null) {
            return new PanelDialog((Frame)null, title, modal, p, bHelpEnabled, action, tabbedPane, helpProvider);
        }
        return null;
    }

    static ASFormatModel ra$m_formatsModel(FormatsPanel formatsPanel) {
        return formatsPanel.m_formatsModel;
    }

    static JButton ra$m_editButton(FormatsPanel formatsPanel) {
        return formatsPanel.m_editButton;
    }

    static JButton ra$m_deleteButton(FormatsPanel formatsPanel) {
        return formatsPanel.m_deleteButton;
    }

    static String[] ra$columnNames() {
        return columnNames;
    }

    static JButton ra$m_saveButton(FormatsPanel formatsPanel) {
        return formatsPanel.m_saveButton;
    }

    static JButton ra$m_upButton(FormatsPanel formatsPanel) {
        return formatsPanel.m_upButton;
    }

    static JButton ra$m_downButton(FormatsPanel formatsPanel) {
        return formatsPanel.m_downButton;
    }

    static Color ra$m_badColor(FormatsPanel formatsPanel) {
        return formatsPanel.m_badColor;
    }

    static Color ra$m_warningColor(FormatsPanel formatsPanel) {
        return formatsPanel.m_warningColor;
    }

    static Color ra$m_goodColor(FormatsPanel formatsPanel) {
        return formatsPanel.m_goodColor;
    }

    static RulesPanel ra$m_rulesPanel(FormatsPanel formatsPanel) {
        return formatsPanel.m_rulesPanel;
    }

    static JPanel ra$viewFormatsPanel(FormatsPanel formatsPanel) {
        return formatsPanel.viewFormatsPanel;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ListSelectionModel rsm = FormatsPanel.this.m_formatsTable.getSelectionModel();
            int anchorRow = rsm.getAnchorSelectionIndex();
            ListSelectionModel csm = FormatsPanel.this.m_formatsTable.getColumnModel().getSelectionModel();
            int anchorColumn = csm.getAnchorSelectionIndex();
            FormatsPanel.this.m_formatsTable.editCellAt(anchorRow, anchorColumn);
            Component editor = FormatsPanel.this.m_formatsTable.getEditorComponent();
            if (editor != null) {
                editor.requestFocus();
            } else {
                FormatsPanel.this.m_formatsTable.requestFocus();
            }
        }
    }

    final class 2
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            FormatsPanel.ra$viewFormatsPanel(FormatsPanel.this).setPreferredSize(new Dimension(FormatsPanel.this.getSize().width - 20, FormatsPanel.ra$viewFormatsPanel((FormatsPanel)FormatsPanel.this).getPreferredSize().height));
            FormatsPanel.ra$viewFormatsPanel(FormatsPanel.this).setMinimumSize(FormatsPanel.ra$viewFormatsPanel(FormatsPanel.this).getPreferredSize());
            FormatsPanel.ra$viewFormatsPanel(FormatsPanel.this).setMaximumSize(FormatsPanel.ra$viewFormatsPanel(FormatsPanel.this).getPreferredSize());
        }
    }

    protected class FormatsTable
    extends JTable {
        public FormatsTable() {
            this.setBackground(Color.white);
            this.getTableHeader().setReorderingAllowed(false);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
        }

        public boolean isCellEditable(int row, int column) {
            if (column == 1) {
                return false;
            }
            return column != 0 || !(this.getValueAt(row, column) instanceof String);
        }

        protected void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 9 && e.getID() == 401 && !e.isControlDown()) {
                int anchorRow = this.getSelectionModel().getAnchorSelectionIndex();
                int anchorColumn = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                if (anchorColumn == this.getColumnCount() - 1 && anchorRow == this.getRowCount() - 1 && !e.isShiftDown()) {
                    if (FocusManager.isFocusManagerEnabled()) {
                        FocusManager.getCurrentManager().focusNextComponent(this);
                        e.consume();
                    }
                    return;
                }
                if (anchorColumn == 0 && anchorRow == 0 && e.isShiftDown()) {
                    if (FocusManager.isFocusManagerEnabled()) {
                        FocusManager.getCurrentManager().focusPreviousComponent(this);
                        e.consume();
                    }
                    return;
                }
            }
            super.processKeyEvent(e);
        }
    }

    protected class FormatsTableModel
    extends DefaultTableModel {
        private int m_formatType;
        private List stopLightSamples;
        private List cellSamples;
        private List headerSamples;
        private static final String Sep = ",";
        private int oldRow;

        public FormatsTableModel() {
            this.$init$();
            this.stopLightSamples = new ArrayList();
            this.cellSamples = new ArrayList();
            this.headerSamples = new ArrayList();
            int i = 0;
            while (i < FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(5).size()) {
                this.stopLightSamples.add(0, this.getAttributeLabel((UIFormat)FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(5).get(i)));
                ++i;
            }
            int i2 = 0;
            while (i2 < FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(4).size()) {
                this.cellSamples.add(0, this.getAttributeLabel((UIFormat)FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(4).get(i2)));
                ++i2;
            }
            int i3 = 0;
            while (i3 < FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(3).size()) {
                this.headerSamples.add(0, this.getAttributeLabel((UIFormat)FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(3).get(i3)));
                ++i3;
            }
        }

        public void refreshStoplightColor() {
            int i = 0;
            while (i < this.stopLightSamples.size()) {
                AttributeLabel label = new AttributeLabel("", 5);
                this.stopLightSamples.set(i, label);
                ++i;
            }
        }

        public AttributeLabel getAttributeLabel(UIFormat format) {
            ViewFormat vf;
            String string = "";
            AttributeLabel a_attribute = new AttributeLabel(string, format.getGroup());
            if (format.getGroup() == 5) {
                return a_attribute;
            }
            ViewStyle vs = format.getViewStyle();
            if (vs != null) {
                if (vs.isFontNameUsed()) {
                    string = string + vs.getFontName() + Sep;
                }
                if (vs.isFontSizeUsed()) {
                    string = string + vs.getFontSize() + FormatsPanel.this.rBundle.getString("pt") + Sep;
                }
                if (vs.isFontBoldUsed() && vs.isFontBold()) {
                    string = string + FormatsPanel.this.rBundle.getString("Bold") + Sep;
                }
                if (vs.isFontItalicUsed() && vs.isFontItalic()) {
                    string = string + FormatsPanel.this.rBundle.getString("Italic") + Sep;
                }
                if (vs.isUnderlineUsed()) {
                    a_attribute.label.setUnderline(vs.isUnderline());
                }
                if (vs.isStrikeThroughUsed()) {
                    a_attribute.label.setStrikeThrough(vs.isStrikeThrough());
                }
                if (vs.isFontUsed()) {
                    a_attribute.label.setFont(vs.getFont());
                } else {
                    Font font = new Font("Dialog", 0, 11);
                    a_attribute.label.setFont(font);
                }
                if (vs.isBackgroundUsed()) {
                    a_attribute.setBackground(vs.getBackground());
                }
                if (vs.isForegroundUsed()) {
                    a_attribute.label.setForeground(vs.getForeground());
                }
                if (vs.isHorizontalAlignmentUsed()) {
                    a_attribute.label.setHorizontalAlignment(vs.getHorizontalAlignment());
                }
                a_attribute.setOutlineStyle(vs.isBorderStyleUsed(1) ? vs.getBorderStyle(1) : -1, vs.isBorderStyleUsed(4) ? vs.getBorderStyle(4) : -1, vs.isBorderStyleUsed(2) ? vs.getBorderStyle(2) : -1, vs.isBorderStyleUsed(8) ? vs.getBorderStyle(8) : -1);
                a_attribute.setOutlineColor(vs.isBorderColorUsed(1) ? vs.getBorderColor(1) : null, vs.isBorderColorUsed(4) ? vs.getBorderColor(4) : null, vs.isBorderColorUsed(2) ? vs.getBorderColor(2) : null, vs.isBorderColorUsed(8) ? vs.getBorderColor(8) : null);
                a_attribute.setOutlineWidth(vs.isBorderWidthUsed(1) ? vs.getBorderWidth(1) : 0, vs.isBorderWidthUsed(4) ? vs.getBorderWidth(4) : 0, vs.isBorderWidthUsed(2) ? vs.getBorderWidth(2) : 0, vs.isBorderWidthUsed(8) ? vs.getBorderWidth(8) : 0);
            }
            if ((vf = format.getViewFormat()) != null) {
                if (vf.isCurrencySymbolUsed() || vf.isDecimalDigitUsed() || vf.isDecimalSeparatorUsed() || vf.isNegCurFmtUsed() || vf.isNegNumFmtUsed() || vf.isNumberTypeUsed() || vf.isPercentUsed() || vf.isPosCurFmtUsed() || vf.isPosNumFmtUsed() || vf.isScaleDownBillionsUsed() || vf.isScaleDownMillionsUsed() || vf.isScaleDownQuadrillionsUsed() || vf.isScaleDownTrillionsUsed() || vf.isScaleDownThousandsUsed() || vf.isScaleFactorUsed()) {
                    String tmp = vf.DoubleToString(1234567.0);
                    string = string + MessageFormat.format(FormatsPanel.this.rBundle.getString("Number:"), tmp) + Sep;
                }
                if (vf.isOracleDateFormatUsed()) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.set(2000, 2, 21, 15, 15);
                    Date date = new Date(cal.getTime().getTime());
                    String tmp = vf.DateToString(date);
                    string = string + MessageFormat.format(FormatsPanel.this.rBundle.getString("Date:"), tmp);
                }
            }
            if (string == "" && vs != null && vs.isForegroundUsed()) {
                string = FormatsPanel.this.rBundle.getString("FontColor");
            }
            if (string.indexOf(Sep) != -1) {
                String subString = string.substring(string.length() - 1, string.length());
                if (subString != "" && subString.equals(Sep)) {
                    a_attribute.label.setText(string.substring(0, string.length() - 1));
                } else {
                    a_attribute.label.setText(string);
                }
            } else {
                a_attribute.label.setText(string);
            }
            return a_attribute;
        }

        public String getColumnName(int columnIndex) {
            return FormatsPanel.this.rBundle.getString(FormatsPanel.ra$columnNames()[columnIndex]);
        }

        public Object getValueAt(int row, int column) {
            if (column == 0) {
                if (this.getFormatType() == 0) {
                    if (row < this.stopLightSamples.size()) {
                        return (UIFormat)FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(5).get(this.stopLightSamples.size() - row - 1);
                    }
                    if (this.stopLightSamples.size() + this.cellSamples.size() == 0) {
                        return FormatsPanel.this.rBundle.getString("NoConditionalCellFormat");
                    }
                    return (UIFormat)FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(4).get(this.cellSamples.size() - row + this.stopLightSamples.size() - 1);
                }
                if (this.headerSamples.size() == 0) {
                    return FormatsPanel.this.rBundle.getString("NoConditionalHeaderFormat");
                }
                return (UIFormat)FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(3).get(this.headerSamples.size() - row - 1);
            }
            if (this.getFormatType() == 0) {
                if (row < this.stopLightSamples.size()) {
                    return (AttributeLabel)this.stopLightSamples.get(row);
                }
                if (this.stopLightSamples.size() + this.cellSamples.size() == 0) {
                    return "";
                }
                return (AttributeLabel)this.cellSamples.get(row - this.stopLightSamples.size());
            }
            if (this.headerSamples.size() == 0) {
                return "";
            }
            return (AttributeLabel)this.headerSamples.get(row);
        }

        public void setValueAt(Object obj, int row, int column) {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            if (this.getFormatType() == 0) {
                if (this.stopLightSamples != null) {
                    return Math.max(this.stopLightSamples.size() + this.cellSamples.size(), 1);
                }
                return 1;
            }
            if (this.headerSamples != null) {
                return Math.max(this.headerSamples.size(), 1);
            }
            return 1;
        }

        public void setFormatType(int type) {
            this.oldRow = FormatsPanel.this.m_formatsTable.getSelectedRow();
            this.m_formatType = type;
            this.fireTableDataChanged();
            if (this.oldRow < 0) {
                this.oldRow = 0;
            }
            FormatsPanel.this.m_formatsTable.getSelectionModel().setSelectionInterval(this.oldRow, this.oldRow);
        }

        public int getFormatType() {
            return this.m_formatType;
        }

        public UIFormat getFormatAt(int index) {
            if (this.getFormatType() == 0) {
                if (index < this.stopLightSamples.size()) {
                    return (UIFormat)FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(5).get(this.stopLightSamples.size() - index - 1);
                }
                return (UIFormat)FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(4).get(this.cellSamples.size() - index + this.stopLightSamples.size() - 1);
            }
            return (UIFormat)FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(3).get(this.headerSamples.size() - index - 1);
        }

        public void setFormatAt(UIFormat format, int index) {
            if (this.getFormatType() == 0) {
                if (format.getGroup() == 5) {
                    if (index < this.stopLightSamples.size()) {
                        FormatsPanel.ra$m_formatsModel(FormatsPanel.this).setFormat(FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(5), this.stopLightSamples.size() - index - 1, format);
                        this.stopLightSamples.set(index, this.getAttributeLabel(format));
                    } else {
                        FormatsPanel.ra$m_formatsModel(FormatsPanel.this).addFormat(format);
                        this.stopLightSamples.add(0, this.getAttributeLabel(format));
                    }
                } else if (format.getGroup() == 4) {
                    if (index - this.stopLightSamples.size() < this.cellSamples.size()) {
                        FormatsPanel.ra$m_formatsModel(FormatsPanel.this).setFormat(FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(4), this.cellSamples.size() - index + this.stopLightSamples.size() - 1, format);
                        this.cellSamples.set(index - this.stopLightSamples.size(), this.getAttributeLabel(format));
                    } else {
                        FormatsPanel.ra$m_formatsModel(FormatsPanel.this).addFormat(format);
                        this.cellSamples.add(this.stopLightSamples.size(), this.getAttributeLabel(format));
                    }
                }
            } else if (format.getGroup() == 3) {
                if (index < this.headerSamples.size()) {
                    FormatsPanel.ra$m_formatsModel(FormatsPanel.this).setFormat(FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(3), this.headerSamples.size() - index - 1, format);
                    this.headerSamples.set(index, this.getAttributeLabel(format));
                } else {
                    FormatsPanel.ra$m_formatsModel(FormatsPanel.this).addFormat(format);
                    this.headerSamples.add(0, this.getAttributeLabel(format));
                }
            }
        }

        public void addFormat(UIFormat format) {
            FormatsPanel.ra$m_formatsModel(FormatsPanel.this).addFormat(format);
            if (format.getGroup() == 5) {
                this.stopLightSamples.add(0, this.getAttributeLabel(format));
            } else if (format.getGroup() == 4) {
                this.cellSamples.add(0, this.getAttributeLabel(format));
            } else if (format.getGroup() == 3) {
                this.headerSamples.add(0, this.getAttributeLabel(format));
            }
            if (this.getFormatType() == 0 && format.getGroup() != 3 || this.getFormatType() == 1 && format.getGroup() == 3) {
                this.fireTableRowsInserted(0, this.getRowCount());
                if (format.getGroup() == 4) {
                    FormatsPanel.this.m_formatsTable.getSelectionModel().setSelectionInterval(this.stopLightSamples.size(), this.stopLightSamples.size());
                } else {
                    FormatsPanel.this.m_formatsTable.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        }

        public void removeAllFormats() {
        }

        public void deleteFormat(int group, int index) {
            if (group == 4) {
                index += this.stopLightSamples.size();
            }
            this.deleteFormat(index);
        }

        public void deleteFormat(int row) {
            if (this.getFormatType() == 0) {
                if (row < this.stopLightSamples.size()) {
                    FormatsPanel.ra$m_formatsModel(FormatsPanel.this).removeFormat(FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(5), this.stopLightSamples.size() - row - 1);
                    this.stopLightSamples.remove(row);
                } else {
                    FormatsPanel.ra$m_formatsModel(FormatsPanel.this).removeFormat(FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(4), this.cellSamples.size() - row + this.stopLightSamples.size() - 1);
                    this.cellSamples.remove(row - this.stopLightSamples.size());
                }
            } else {
                FormatsPanel.ra$m_formatsModel(FormatsPanel.this).removeFormat(FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(3), this.headerSamples.size() - row - 1);
                this.headerSamples.remove(row);
            }
            row = FormatsPanel.this.m_formatsTable.getSelectedRow();
            this.fireTableDataChanged();
            if (row < this.getRowCount()) {
                FormatsPanel.this.m_formatsTable.getSelectionModel().setSelectionInterval(row, row);
            } else {
                FormatsPanel.this.m_formatsTable.getSelectionModel().setSelectionInterval(0, 0);
            }
            if (this.getRowCount() == 0) {
                FormatsPanel.ra$m_editButton(FormatsPanel.this).setEnabled(false);
                FormatsPanel.ra$m_deleteButton(FormatsPanel.this).setEnabled(false);
            }
        }

        public boolean isUp(int index) {
            if (index == 0) {
                return false;
            }
            return this.getFormatType() != 0 || this.stopLightSamples.size() == 0 || index != this.stopLightSamples.size();
        }

        public boolean isDown(int index) {
            return !(this.getFormatType() == 0 ? this.stopLightSamples.size() != 0 && index == this.stopLightSamples.size() - 1 || index == this.stopLightSamples.size() + this.cellSamples.size() - 1 : index == this.headerSamples.size() - 1);
        }

        public void moveUp(int index) {
            List sampleList;
            if (this.getFormatType() == 0) {
                if (index < this.stopLightSamples.size()) {
                    FormatsPanel.ra$m_formatsModel(FormatsPanel.this).moveUp(FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(5), this.stopLightSamples.size() - index - 1, true);
                    sampleList = this.stopLightSamples;
                } else {
                    FormatsPanel.ra$m_formatsModel(FormatsPanel.this).moveUp(FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(4), this.cellSamples.size() - (index -= this.stopLightSamples.size()) - 1, true);
                    sampleList = this.cellSamples;
                }
            } else {
                FormatsPanel.ra$m_formatsModel(FormatsPanel.this).moveUp(FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(3), this.headerSamples.size() - index - 1, true);
                sampleList = this.headerSamples;
            }
            Object sample = sampleList.get(index);
            sampleList.remove(index);
            sampleList.add(index - 1, sample);
            int row = FormatsPanel.this.m_formatsTable.getSelectedRow();
            this.fireTableDataChanged();
            FormatsPanel.this.m_formatsTable.getSelectionModel().setSelectionInterval(row - 1, row - 1);
        }

        public void moveDown(int index) {
            List sampleList;
            if (this.getFormatType() == 0) {
                if (index < this.stopLightSamples.size()) {
                    sampleList = this.stopLightSamples;
                    FormatsPanel.ra$m_formatsModel(FormatsPanel.this).moveDown(FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(5), this.stopLightSamples.size() - index - 1, true);
                } else {
                    sampleList = this.cellSamples;
                    FormatsPanel.ra$m_formatsModel(FormatsPanel.this).moveDown(FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(4), this.cellSamples.size() - (index -= this.stopLightSamples.size()) - 1, true);
                }
            } else {
                sampleList = this.headerSamples;
                FormatsPanel.ra$m_formatsModel(FormatsPanel.this).moveDown(FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(3), this.headerSamples.size() - index - 1, true);
            }
            Object sample = sampleList.get(index);
            sampleList.remove(index);
            sampleList.add(index + 1, sample);
            int row = FormatsPanel.this.m_formatsTable.getSelectedRow();
            this.fireTableDataChanged();
            FormatsPanel.this.m_formatsTable.getSelectionModel().setSelectionInterval(row + 1, row + 1);
        }

        public int getGroupSize(int group) {
            if (group == 5) {
                return this.stopLightSamples.size();
            }
            if (group == 4) {
                return this.cellSamples.size();
            }
            if (group == 3) {
                return this.headerSamples.size();
            }
            return 0;
        }

        public void setSelected(boolean selected, int index) {
            UIFormat format = this.getFormatAt(index);
            format.setSelected(selected);
            this.setFormatAt(format, index);
        }

        public boolean isSelected(int index) {
            return this.getFormatAt(index).isSelected();
        }

        public void setSelected(int group, int index, boolean selected) {
            if (group == 5) {
                ((UIFormat)FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(5).get(this.stopLightSamples.size() - index - 1)).setSelected(selected);
            } else if (group == 4) {
                ((UIFormat)FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(4).get(this.cellSamples.size() - index + this.stopLightSamples.size() - 1)).setSelected(selected);
            } else if (group == 3) {
                ((UIFormat)FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(3).get(this.headerSamples.size() - index - 1)).setSelected(selected);
            }
        }

        public boolean isSelected(int group, int index) {
            if (group == 5) {
                return ((UIFormat)FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(5).get(this.stopLightSamples.size() - index - 1)).isSelected();
            }
            if (group == 4) {
                return ((UIFormat)FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(4).get(this.cellSamples.size() - index + this.stopLightSamples.size() - 1)).isSelected();
            }
            if (group == 3) {
                return ((UIFormat)FormatsPanel.ra$m_formatsModel(FormatsPanel.this).getFormatListByGroup(3).get(this.headerSamples.size() - index - 1)).isSelected();
            }
            return false;
        }

        public void toggleSelection(int index) {
            this.setSelected(this.isSelected(index) ^ true, index);
        }

        private void $init$() {
            this.m_formatType = 0;
            this.oldRow = 0;
        }
    }

    class CheckBoxEditor
    extends JPanel
    implements TableCellEditor,
    ItemListener {
        JCheckBox checkBox;
        JTextField textField;
        Vector listeners;
        UIFormat cell;

        public CheckBoxEditor() {
            this.$init$();
            this.setLayout(new BoxLayout(this, 0));
            this.checkBox.setName("FormatNameCheckbox");
            this.add(this.checkBox);
            this.add(this.textField);
            this.listeners = new Vector();
            this.checkBox.addItemListener(this);
        }

        public Object getCellEditorValue() {
            this.cell.setSelected(this.checkBox.isSelected());
            this.cell.setName(this.textField.getText());
            return this.cell;
        }

        public void itemStateChanged(ItemEvent e) {
            this.fireEditingStopped();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cell = (UIFormat)value;
            boolean selected = this.cell.isSelected();
            String label = this.cell.getName();
            this.checkBox.setSelected(selected);
            this.textField.setText(label);
            return this;
        }

        public void addCellEditorListener(CellEditorListener l) {
            this.listeners.addElement(l);
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                int x = ((MouseEvent)anEvent).getPoint().x;
                if (x > 20) {
                    return ((MouseEvent)anEvent).getClickCount() >= 2;
                }
                return true;
            }
            return true;
        }

        public void removeCellEditorListener(CellEditorListener l) {
            this.listeners.removeElement(l);
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        protected void fireEditingCanceled() {
            ChangeEvent ce = new ChangeEvent(this);
            int i = this.listeners.size();
            while (i >= 0) {
                ((CellEditorListener)this.listeners.elementAt(i)).editingCanceled(ce);
                --i;
            }
        }

        protected void fireEditingStopped() {
            ChangeEvent ce = new ChangeEvent(this);
            int i = this.listeners.size() - 1;
            while (i >= 0) {
                if (this.listeners.elementAt(i) instanceof CellEditorListener) {
                    ((CellEditorListener)this.listeners.elementAt(i)).editingStopped(ce);
                }
                --i;
            }
        }

        private void $init$() {
            this.checkBox = new JCheckBox();
            this.textField = new JTextField();
        }
    }

    private class AttributeCellRenderer
    extends JPanel
    implements TableCellRenderer {
        AttributeLabel tmpLabel;
        JPanel panel;

        public AttributeCellRenderer() {
            this.$init$();
            this.setBackground(Color.white);
            this.setOpaque(true);
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(new EmptyBorder(1, 2, 1, 2));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.removeAll();
            if (value instanceof AttributeLabel) {
                this.tmpLabel = (AttributeLabel)value;
                this.add(this.tmpLabel);
                this.tmpLabel.setPreferredSize(new Dimension(this.getPreferredSize().width - 4, this.tmpLabel.getPreferredSize().height));
                this.tmpLabel.setMinimumSize(this.tmpLabel.getPreferredSize());
                this.tmpLabel.setMaximumSize(this.tmpLabel.getPreferredSize());
                this.setPreferredSize(new Dimension(FormatsPanel.this.m_formatsTable.getColumnModel().getColumn(1).getWidth(), Math.max(18, this.tmpLabel.getPreferredSize().height + 2)));
                if (table.getRowHeight(row) != this.getPreferredSize().height) {
                    table.setRowHeight(row, this.getPreferredSize().height);
                }
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setBackground(table.getBackground());
                }
                if (this.tmpLabel.label != null) {
                    this.getAccessibleContext().setAccessibleName(this.tmpLabel.label.getText());
                }
            }
            return this;
        }

        private void $init$() {
            this.panel = new JPanel();
        }
    }

    private class FormatTableCellRenderer
    extends JPanel
    implements TableCellRenderer {
        JCheckBox tmpCheckBox;
        JLabel tmpLabel;

        public FormatTableCellRenderer() {
            this.$init$();
            this.setLayout(new BoxLayout(this, 0));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.removeAll();
            this.tmpLabel.setFont(new Font(table.getFont().getFontName(), 0, table.getFont().getSize()));
            String label = "";
            if (value instanceof UIFormat) {
                UIFormat format = (UIFormat)value;
                int group = format.getGroup();
                boolean selected = format.isSelected();
                label = format.getName();
                if (FormatsPanel.this.m_formatsTable.getSelectedRow() == -1) {
                    FormatsPanel.ra$m_editButton(FormatsPanel.this).setEnabled(false);
                    FormatsPanel.ra$m_deleteButton(FormatsPanel.this).setEnabled(false);
                } else if (isSelected) {
                    FormatsPanel.ra$m_deleteButton(FormatsPanel.this).setEnabled(true);
                    if (group == 3 || group == 4 || group == 5) {
                        FormatsPanel.ra$m_editButton(FormatsPanel.this).setEnabled(true);
                    } else {
                        FormatsPanel.ra$m_editButton(FormatsPanel.this).setEnabled(false);
                    }
                    if (FormatsPanel.this.getCustomObjectManager() != null) {
                        FormatsPanel.ra$m_saveButton(FormatsPanel.this).setEnabled(true);
                    } else {
                        FormatsPanel.ra$m_saveButton(FormatsPanel.this).setEnabled(false);
                    }
                    if (FormatsPanel.this.m_formatsTableModel.isUp(row)) {
                        if (FormatsPanel.ra$m_upButton(FormatsPanel.this) != null) {
                            FormatsPanel.ra$m_upButton(FormatsPanel.this).setEnabled(true);
                            FormatsPanel.ra$m_upButton(FormatsPanel.this).setToolTipText(FormatsPanel.this.rBundle.getString("Up"));
                        }
                    } else if (FormatsPanel.ra$m_upButton(FormatsPanel.this) != null) {
                        FormatsPanel.ra$m_upButton(FormatsPanel.this).setEnabled(false);
                        FormatsPanel.ra$m_upButton(FormatsPanel.this).setToolTipText(FormatsPanel.this.rBundle.getString("Up Disabled"));
                    }
                    if (FormatsPanel.this.m_formatsTableModel.isDown(row)) {
                        if (FormatsPanel.ra$m_downButton(FormatsPanel.this) != null) {
                            FormatsPanel.ra$m_downButton(FormatsPanel.this).setEnabled(true);
                            FormatsPanel.ra$m_downButton(FormatsPanel.this).setToolTipText(FormatsPanel.this.rBundle.getString("Down"));
                        }
                    } else if (FormatsPanel.ra$m_downButton(FormatsPanel.this) != null) {
                        FormatsPanel.ra$m_downButton(FormatsPanel.this).setEnabled(false);
                        FormatsPanel.ra$m_downButton(FormatsPanel.this).setToolTipText(FormatsPanel.this.rBundle.getString("Down Disabled"));
                    }
                }
                this.tmpCheckBox.setSelected(selected);
                this.add(this.tmpCheckBox);
            } else {
                label = value.toString();
                FormatsPanel.ra$m_editButton(FormatsPanel.this).setEnabled(false);
                FormatsPanel.ra$m_deleteButton(FormatsPanel.this).setEnabled(false);
                FormatsPanel.ra$m_upButton(FormatsPanel.this).setEnabled(false);
                FormatsPanel.ra$m_upButton(FormatsPanel.this).setToolTipText(FormatsPanel.this.rBundle.getString("Up Disabled"));
                FormatsPanel.ra$m_downButton(FormatsPanel.this).setEnabled(false);
                FormatsPanel.ra$m_downButton(FormatsPanel.this).setToolTipText(FormatsPanel.this.rBundle.getString("Down Disabled"));
                FormatsPanel.ra$m_saveButton(FormatsPanel.this).setEnabled(false);
            }
            this.tmpLabel.setText(label);
            if (label != null) {
                this.setToolTipText(label);
            }
            this.add(this.tmpLabel);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.tmpLabel.setForeground(table.getSelectionForeground());
                this.tmpCheckBox.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
                this.tmpCheckBox.setBackground(table.getBackground());
                this.tmpLabel.setForeground(table.getForeground());
            }
            this.getAccessibleContext().setAccessibleName(this.tmpLabel.getText());
            return this;
        }

        private void $init$() {
            this.tmpCheckBox = new JCheckBox();
            this.tmpLabel = new JLabel();
        }
    }

    class AttributeLabel
    extends JPanel {
        private int _sizeLimit;
        private int topLineStyle;
        private int bottomLineStyle;
        private int rightLineStyle;
        private int leftLineStyle;
        private Color topLineColor;
        private Color bottomLineColor;
        private Color rightLineColor;
        private Color leftLineColor;
        private int topLineWidth;
        private int bottomLineWidth;
        private int rightLineWidth;
        private int leftLineWidth;
        ViewLabel label;

        public AttributeLabel(String text, int type) {
            this.$init$();
            this.setLayout(new BoxLayout(this, 0));
            if (type == 5) {
                JPanel label1 = new JPanel();
                label1.setBackground(FormatsPanel.ra$m_badColor(FormatsPanel.this));
                label1.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black));
                JPanel label2 = new JPanel();
                label2.setBackground(FormatsPanel.ra$m_warningColor(FormatsPanel.this));
                label2.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.black));
                JPanel label3 = new JPanel();
                label3.setBackground(FormatsPanel.ra$m_goodColor(FormatsPanel.this));
                label3.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black));
                this.add(label1);
                this.add(label2);
                this.add(label3);
            } else {
                this.add(Box.createHorizontalStrut(5));
                this.label = new ViewLabel(text);
                this.add((Component)this.label);
                this.label.setForeground(Color.black);
            }
            this.setBackground(null);
            this.setOpaque(true);
        }

        public AttributeLabel() {
            this.$init$();
            this.setOpaque(true);
        }

        public void setOutlineStyle(int topStyle, int bottomStyle, int leftStyle, int rightStyle) {
            if (topStyle != -1) {
                this.topLineStyle = topStyle;
            }
            if (bottomStyle != -1) {
                this.bottomLineStyle = bottomStyle;
            }
            if (rightStyle != -1) {
                this.rightLineStyle = rightStyle;
            }
            if (leftStyle != -1) {
                this.leftLineStyle = leftStyle;
            }
        }

        public void setOutlineColor(Color topColor, Color bottomColor, Color leftColor, Color rightColor) {
            this.topLineColor = topColor;
            this.bottomLineColor = bottomColor;
            this.rightLineColor = rightColor;
            this.leftLineColor = leftColor;
        }

        public void setOutlineWidth(int topWidth, int bottomWidth, int leftWidth, int rightWidth) {
            this.topLineWidth = topWidth;
            this.bottomLineWidth = bottomWidth;
            this.rightLineWidth = rightWidth;
            this.leftLineWidth = leftWidth;
        }

        public Dimension getPreferredSize() {
            if (this.label != null) {
                return new Dimension(FormatsPanel.this.m_formatsTable.getColumnModel().getColumn(1).getWidth() - 4, this.label.getPreferredSize().height + this.topLineWidth + this.bottomLineWidth + 1);
            }
            return new Dimension(FormatsPanel.this.m_formatsTable.getColumnModel().getColumn(1).getWidth() - 4, 12);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.label == null) {
                return;
            }
            Border b = this.getBorder();
            Insets insets = b != null ? b.getBorderInsets(this) : new Insets(0, 0, 0, 0);
            int x = insets.left;
            int y = insets.top;
            BorderPainter.paintBorder(g, x, y, this.getPreferredSize().width, this.getPreferredSize().height - 1, 0, Color.black, this.topLineStyle, this.bottomLineStyle, this.leftLineStyle, this.rightLineStyle, this.topLineWidth, this.bottomLineWidth, this.leftLineWidth, this.rightLineWidth, this.topLineColor, this.bottomLineColor, this.leftLineColor, this.rightLineColor);
        }

        private void $init$() {
            this._sizeLimit = 30;
        }
    }

    protected class PanelDialog
    extends JDialog
    implements ActionListener,
    HelpContext {
        private int m_initialWidth;
        private int m_initialHeight;
        private boolean m_bHelpEnabled;
        private JTabbedPane m_tabbedPane;
        private String m_strHelpContextID;
        private JButton okButton;
        private JButton cancelButton;
        private JButton helpButton;
        protected JPanel m_panel;
        protected int m_action;
        private final Border _sBorder;
        private final Border _sBorderButtons;

        public PanelDialog(Frame parentFrame, String title, boolean modal, JPanel p, boolean bHelpEnabled, int action, JTabbedPane tabbedPane, HelpProvider helpProvider) {
            super(parentFrame);
            this.$init$();
            this._initDialog(title, modal, p, bHelpEnabled, action, tabbedPane, helpProvider);
        }

        public PanelDialog(Dialog owner, String title, boolean modal, JPanel p, boolean bHelpEnabled, int action, JTabbedPane tabbedPane, HelpProvider helpProvider) {
            super(owner);
            this.$init$();
            this._initDialog(title, modal, p, bHelpEnabled, action, tabbedPane, helpProvider);
        }

        private void _initDialog(String title, boolean modal, JPanel p, boolean bHelpEnabled, int action, JTabbedPane tabbedPane, HelpProvider helpProvider) {
            this.m_bHelpEnabled = bHelpEnabled;
            this.m_tabbedPane = tabbedPane;
            this.setHelpProvider(helpProvider);
            this.setTitle(title);
            this.setModal(modal);
            this.m_panel = p;
            this.m_action = action;
            this.setHelpEnabled(true);
            this.init();
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.setLocation((screenSize.width - frameSize.height) / 2, (screenSize.height - frameSize.width) / 2);
            this.m_initialWidth = this.getWidth();
            this.m_initialHeight = this.getHeight();
        }

        public String getHelpContextID() {
            String strReturn = "";
            Component tmpComponent = this.m_tabbedPane.getSelectedComponent();
            if (tmpComponent instanceof HelpContext) {
                strReturn = ((HelpContext)tmpComponent).getHelpContextID();
            }
            tmpComponent = null;
            return strReturn;
        }

        public void cleanUp() {
            this.getContentPane().remove(this.m_panel);
            this.m_tabbedPane = null;
            this.m_panel.removeAll();
            this.m_panel = null;
        }

        public void setHelpContextID(String strHelpContextID) {
            this.m_strHelpContextID = strHelpContextID;
        }

        public void setHelpProvider(HelpProvider helpProvider) {
            FormatsPanel.this.m_helpProvider = helpProvider;
        }

        public HelpProvider getHelpProvider() {
            return FormatsPanel.this.m_helpProvider;
        }

        public void setHelpEnabled(boolean bValue) {
            this.m_bHelpEnabled = bValue;
        }

        public boolean isHelpEnabled() {
            return this.m_bHelpEnabled;
        }

        private void init() {
            this.m_initialWidth = -1;
            this.m_initialHeight = -1;
            JComponent content = (JComponent)this.getContentPane();
            content.setLayout(new BoxLayout(content, 1));
            content.setBorder(this._sBorder);
            content.add(this.m_panel);
            if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                content.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
            }
            DialogButtonBar buttonPanel = new DialogButtonBar();
            buttonPanel.setBorder(this._sBorderButtons);
            if (this.m_bHelpEnabled) {
                String translatedText = FormatsPanel.this.rBundle.getString("Help");
                this.helpButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
                this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                buttonPanel.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
                this.helpButton.addActionListener(this);
                this.helpButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(112, 0), 2);
            }
            JPanel buttonPanel_east = new JPanel();
            String translatedText = FormatsPanel.this.rBundle.getString("OK");
            this.okButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.okButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            buttonPanel.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_YES);
            this.okButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.okButton);
            translatedText = FormatsPanel.this.rBundle.getString("Cancel");
            this.cancelButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.cancelButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            buttonPanel.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
            this.cancelButton.addActionListener(this);
            this.cancelButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
            this.getContentPane().add((Component)buttonPanel);
            this.m_panel.setAlignmentX(0.0f);
            buttonPanel.setAlignmentX(0.0f);
            this.setResizable(true);
            this.pack();
            this.addComponentListener(new 1());
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cancelButton) {
                FormatsPanel.this.m_ok = false;
                this.setVisible(false);
                this.dispose();
                this.getParent().repaint();
            } else if (e.getSource() == this.okButton) {
                boolean ret = true;
                if (FormatsPanel.ra$m_rulesPanel(FormatsPanel.this) != null) {
                    ret = FormatsPanel.ra$m_rulesPanel(FormatsPanel.this).showErrorDialog();
                }
                if (ret) {
                    FormatsPanel.this.m_ok = true;
                    this.setVisible(false);
                    this.dispose();
                } else {
                    FormatsPanel.this.m_ok = false;
                }
            } else if (e.getSource() == this.helpButton) {
                try {
                    if (this.getHelpProvider() != null) {
                        this.getHelpProvider().showHelp((Component)this);
                    } else if (HelpUtils.getDefaultHelpProvider() != null) {
                        HelpUtils.getDefaultHelpProvider().showHelp((Component)this);
                    }
                }
                catch (HelpUnavailableException helpUnavailableException) {
                    // empty catch block
                }
            }
        }

        private void $init$() {
            this.m_initialWidth = -1;
            this.m_initialHeight = -1;
            this.m_bHelpEnabled = true;
            this._sBorder = new EmptyBorder(6, 6, 8, 5);
            this._sBorderButtons = new EmptyBorder(8, 10, 0, 10);
        }

        static int ra$m_initialWidth(PanelDialog panelDialog) {
            return panelDialog.m_initialWidth;
        }

        static int ra$m_initialHeight(PanelDialog panelDialog) {
            return panelDialog.m_initialHeight;
        }

        final class 1
        extends ComponentAdapter {
            public void componentResized(ComponentEvent e) {
                int originalHeight;
                int originalWidth;
                int width = originalWidth = PanelDialog.this.getWidth();
                int height = originalHeight = PanelDialog.this.getHeight();
                if (PanelDialog.ra$m_initialWidth(PanelDialog.this) != -1) {
                    width = Math.max(PanelDialog.ra$m_initialWidth(PanelDialog.this), width);
                }
                if (PanelDialog.ra$m_initialHeight(PanelDialog.this) != -1) {
                    height = Math.max(PanelDialog.ra$m_initialHeight(PanelDialog.this), height);
                }
                if (originalWidth != width || originalHeight != height) {
                    PanelDialog.this.setSize(width, height);
                }
                PanelDialog.this.validate();
            }
        }
    }
}

