/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.gridView.UIGridView;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.util.DataAccess;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.dimensionList.DataAccessDimensionModel;
import oracle.dss.util.dimensionList.DimListDataItem;
import oracle.dss.util.dimensionList.DimListDataModel;
import oracle.dss.util.dimensionList.DimensionList;

public class MemberPanel
extends JPanel
implements ItemListener {
    private UIGridView m_gridView;
    private boolean m_bSuperCalled;
    private Locale m_locale;
    private ResourceBundle rBundle;
    private String m_strDimension;
    private boolean m_isTable;
    private Vector m_initVector;
    private Vector m_selectedMembersVector;
    private JComboBox m_dimensionCombo;
    private ButtonGroup m_buttonGroup;
    private JRadioButton m_anyButton;
    private JRadioButton m_selectedButton;
    private JPanel m_buttonPanel;
    private JList m_dimListFrom;
    private JList m_dimListTo;
    private DataAccessDimensionModel m_listModel;
    private ListPicker m_listPicker1;
    private ListPicker m_listPicker2;
    private Shuttle m_shuttle;
    private DimListCellRenderer m_cellRenderer;
    private Vector m_layerVector;
    private String m_strHelpContextID;
    private boolean m_isHeaderFormat;

    public MemberPanel(UIGridView gridView) {
        this.$init$();
        this.m_gridView = gridView;
        this.m_bSuperCalled = true;
        if (this.m_gridView != null) {
            this.m_locale = this.m_gridView.getLocale();
        }
        this.updateResourceBundle(this.m_locale);
        this.m_isTable = gridView.getViewType() != 0;
        this.constructPanel();
    }

    public MemberPanel(UIGridView gridView, QDRDiscriminator qdrDisc, boolean isHeaderFormat) {
        QDR qdr;
        this.$init$();
        this.m_gridView = gridView;
        this.m_isHeaderFormat = isHeaderFormat;
        this.m_bSuperCalled = true;
        if (this.m_gridView != null) {
            this.m_locale = this.m_gridView.getLocale();
        }
        this.updateResourceBundle(this.m_locale);
        this.m_isTable = gridView.getViewType() != 0;
        if (qdrDisc != null && (qdr = qdrDisc.getQDR()).getTarget() != null) {
            this.m_strDimension = qdr.getTarget().getData().toString();
            if (!this.m_isTable || !this.m_isHeaderFormat) {
                this.m_initVector = (Vector)qdr.getDimMember(this.m_strDimension).getData();
            }
        }
        this.constructPanel();
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        this.constructPanel();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_dimensionCombo) {
            this.m_strDimension = this.m_layerVector.elementAt(this.m_dimensionCombo.getSelectedIndex()).toString();
            if (!this.m_isHeaderFormat || !this.m_isTable) {
                Object[] formatArgs = new String[]{this.getLayerLabel(this.m_strDimension, "dimShortName")};
                String translatedText = this.rBundle.getString("AnyProduct");
                this.m_anyButton.setText(MessageFormat.format(StringUtils.stripMnemonic((String)translatedText), formatArgs));
                formatArgs[0] = this.getLayerLabel(this.m_strDimension, "dimShortPluralName");
                translatedText = this.rBundle.getString("SelectedProducts");
                this.m_selectedButton.setText(MessageFormat.format(StringUtils.stripMnemonic((String)translatedText), formatArgs));
                this.m_buttonPanel.setMinimumSize(this.m_buttonPanel.getPreferredSize());
                this.m_buttonPanel.setMaximumSize(this.m_buttonPanel.getPreferredSize());
                this.m_listModel = new DataAccessDimensionModel(this.m_gridView.getModel().getDataAccess(), null, this.m_strDimension, false);
                this.m_listModel.setHierarchical(true);
                this.m_dimListFrom = new MyDimensionList();
                this.m_dimListFrom.setModel(this.m_listModel);
                ((DimensionList)this.m_dimListFrom).setContextIconVisible(true);
                ((DimensionList)this.m_dimListFrom).doExpandAll();
                this.m_dimListFrom.repaint();
                ((DefaultListModel)this.m_dimListTo.getModel()).removeAllElements();
                this.m_dimListTo.repaint();
                this.m_listPicker1 = new ListPicker(this.m_dimListFrom);
                this.m_shuttle.setFromPicker((ItemPicker)this.m_listPicker1);
                this.m_dimListFrom.setEnabled(this.m_selectedButton.isSelected());
                this.m_dimListTo.setEnabled(this.m_selectedButton.isSelected());
                this.m_shuttle.setEnabled(this.m_selectedButton.isSelected());
            }
        } else if (e.getSource() == this.m_anyButton) {
            this.m_dimListFrom.setEnabled(false);
            this.m_dimListTo.setEnabled(false);
            this.m_shuttle.setEnabled(false);
        } else if (e.getSource() == this.m_selectedButton) {
            this.m_dimListFrom.setEnabled(true);
            this.m_dimListTo.setEnabled(true);
            this.m_shuttle.setEnabled(true);
        }
    }

    private void constructPanel() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        String translatedText = null;
        this.add(Box.createVerticalStrut(5));
        Vector<Object> data = new Vector<Object>();
        try {
            DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
            this.m_layerVector = new Vector();
            int i = 0;
            while (i < dataAccess.getEdgeCount()) {
                if (!this.m_isTable || i != 1) {
                    int layerCount = dataAccess.getLayerCount(i);
                    int j = 0;
                    while (j < layerCount) {
                        Object dimObj = dataAccess.getLayerMetadata(i, j, "dimShortName");
                        data.addElement(dimObj);
                        this.m_layerVector.addElement(dataAccess.getLayerMetadata(i, j, "dimName"));
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        JPanel dimensionPanel = new JPanel();
        dimensionPanel.setLayout(new BoxLayout(dimensionPanel, 0));
        dimensionPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Dimension");
        JLabel dimLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        dimLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        dimLabel.setAlignmentX(0.0f);
        dimensionPanel.add(dimLabel);
        dimensionPanel.add(Box.createHorizontalStrut(3));
        this.m_dimensionCombo = new JComboBox(data);
        this.m_dimensionCombo.setName("DimensionCombo");
        this.m_dimensionCombo.setAlignmentX(0.0f);
        dimLabel.setLabelFor(this.m_dimensionCombo);
        dimensionPanel.add(this.m_dimensionCombo);
        if (this.m_strDimension != null) {
            this.m_dimensionCombo.setSelectedIndex(this.m_layerVector.indexOf(this.m_strDimension));
        } else {
            this.m_strDimension = this.m_layerVector.elementAt(this.m_dimensionCombo.getSelectedIndex()).toString();
        }
        dimensionPanel.setMinimumSize(dimensionPanel.getPreferredSize());
        dimensionPanel.setMaximumSize(dimensionPanel.getPreferredSize());
        this.add(dimensionPanel);
        this.add(Box.createVerticalStrut(10));
        if (!this.m_isTable || !this.m_isHeaderFormat) {
            MyListPicker m_listPicker2;
            ListPicker m_listPicker1;
            translatedText = this.rBundle.getString("ApplyFormatTo");
            JLabel label = new JLabel(translatedText);
            label.setAlignmentX(0.0f);
            this.add(label);
            Object[] formatArgs = new String[]{this.getLayerLabel(this.m_strDimension, "dimShortName")};
            translatedText = this.rBundle.getString("AnyProduct");
            this.m_anyButton = new JRadioButton(MessageFormat.format(StringUtils.stripMnemonic((String)translatedText), formatArgs), true);
            this.m_anyButton.setName("AnyDimension/Measure");
            this.m_anyButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_anyButton.setAlignmentX(0.0f);
            formatArgs[0] = this.getLayerLabel(this.m_strDimension, "dimShortPluralName");
            translatedText = this.rBundle.getString("SelectedProducts");
            this.m_selectedButton = new JRadioButton(MessageFormat.format(StringUtils.stripMnemonic((String)translatedText), formatArgs), false);
            this.m_selectedButton.setName("SelectedDimensions/Measures");
            this.m_selectedButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_selectedButton.setAlignmentX(0.0f);
            this.m_buttonGroup = new ButtonGroup();
            this.m_buttonGroup.add(this.m_anyButton);
            this.m_buttonGroup.add(this.m_selectedButton);
            if (this.m_initVector == null) {
                this.m_anyButton.setSelected(true);
            } else {
                this.m_selectedButton.setSelected(true);
            }
            this.m_buttonPanel = new JPanel();
            this.m_buttonPanel.setLayout(new BoxLayout(this.m_buttonPanel, 0));
            this.m_buttonPanel.setAlignmentX(0.0f);
            this.m_buttonPanel.add(Box.createHorizontalStrut(5));
            JPanel buttonRight = new JPanel();
            buttonRight.setLayout(new BoxLayout(buttonRight, 1));
            buttonRight.setAlignmentX(0.0f);
            buttonRight.add(this.m_anyButton);
            buttonRight.add(this.m_selectedButton);
            this.m_buttonPanel.add(buttonRight);
            this.m_buttonPanel.setMinimumSize(this.m_buttonPanel.getPreferredSize());
            this.m_buttonPanel.setMaximumSize(this.m_buttonPanel.getPreferredSize());
            this.add(this.m_buttonPanel);
            this.m_dimListTo = new JList();
            this.m_dimListTo.setName("AvailableList");
            this.m_cellRenderer = new DimListCellRenderer();
            this.m_dimListTo.setCellRenderer(this.m_cellRenderer);
            if (!this.m_isTable) {
                this.m_listModel = new DataAccessDimensionModel(this.m_gridView.getModel().getDataAccess(), null, this.m_strDimension, false);
                this.m_listModel.setHierarchical(true);
                this.m_dimListFrom = new MyDimensionList();
                this.m_dimListFrom.setName("SelectedList");
                this.m_dimListFrom.setModel(this.m_listModel);
                ((DimensionList)this.m_dimListFrom).setContextIconVisible(true);
                ((DimensionList)this.m_dimListFrom).doExpandAll();
                m_listPicker1 = new ListPicker(this.m_dimListFrom);
                m_listPicker2 = new MyListPicker(this.m_dimListTo);
            } else {
                this.m_dimListFrom = new JList();
                this.m_dimListFrom.setName("SelectedList");
                this.m_dimListFrom.setCellRenderer(this.m_cellRenderer);
                this.m_dimListFrom.setListData(data);
                m_listPicker1 = new ListPicker(this.m_dimListFrom);
                m_listPicker2 = new MyListPicker(this.m_dimListTo);
            }
            this.setSelectedMembers(this.m_initVector);
            this.m_shuttle = new Shuttle();
            this.m_shuttle.setBorder((Border)new EmptyBorder(0, 10, 0, 0));
            this.m_shuttle.setMode(1);
            this.m_shuttle.setFromPicker((ItemPicker)m_listPicker1);
            this.m_shuttle.setToPicker((ItemPicker)m_listPicker2);
            translatedText = this.rBundle.getString("Available:");
            this.m_shuttle.add((Component)new JLabel(translatedText), (Object)"FromHeader");
            translatedText = this.rBundle.getString("Selected:");
            this.m_shuttle.add((Component)new JLabel(translatedText), (Object)"ToHeader");
            this.m_shuttle.setAlignmentX(0.0f);
            this.m_shuttle.setPreferredSize(new Dimension(280, this.m_shuttle.getPreferredSize().height));
            this.add((Component)this.m_shuttle);
            this.m_shuttle.setEnabled(false);
            this.m_dimListFrom.setEnabled(false);
            this.m_dimListTo.setEnabled(false);
            this.m_anyButton.addItemListener(this);
            this.m_selectedButton.addItemListener(this);
        }
        this.add(Box.createVerticalGlue());
        this.m_dimensionCombo.addItemListener(this);
    }

    public QDRDiscriminator getDiscriminator() {
        QDR m_qdr = new QDR();
        if (this.m_isTable) {
            if (this.m_isHeaderFormat) {
                m_qdr.setTarget(new QDRMember(0, (Object)this.m_strDimension));
            } else {
                m_qdr.setTarget(new QDRMember(3, (Object)this.getSelectedMembers()));
            }
        } else {
            m_qdr.setTarget(new QDRMember(0, (Object)this.m_strDimension));
            if (this.m_anyButton.isSelected()) {
                m_qdr.addDimMemberPair(this.m_strDimension, (String)null);
            } else {
                m_qdr.addDimMemberPair(this.m_strDimension, new QDRMember(3, (Object)this.getSelectedMembers()));
            }
        }
        return new QDRDiscriminator(m_qdr, 4);
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void cleanUp() {
        this.m_dimListTo.setCellRenderer(null);
        this.m_cellRenderer = null;
        this.m_dimListTo = null;
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
    }

    public void setSelectedMembers(Vector v) {
        this.m_initVector = v;
        if (this.m_initVector == null) {
            return;
        }
        if (this.m_dimListFrom == null) {
            return;
        }
        if (this.m_isTable) {
            int i = 0;
            while (i < this.m_initVector.size()) {
                Object item = ((DefaultListModel)this.m_dimListFrom.getModel()).elementAt(this.m_layerVector.indexOf(this.m_initVector.elementAt(i)));
                ((DefaultListModel)this.m_dimListTo.getModel()).addElement(item);
                ++i;
            }
        } else {
            DimListDataModel dm = (DimListDataModel)this.m_dimListFrom.getModel();
            DimListDataItem dsItem = null;
            int i = 0;
            while (i < dm.getSize()) {
                dsItem = (DimListDataItem)dm.elementAt(i);
                if (this.m_initVector.indexOf(dsItem.getValue()) != -1) {
                    ((DefaultListModel)this.m_dimListTo.getModel()).addElement(dsItem);
                }
                ++i;
            }
        }
    }

    public Vector getSelectedMembers() {
        DimListDataItem dsItem = null;
        if (this.m_dimListTo.getModel().getSize() == 0) {
            return null;
        }
        this.m_selectedMembersVector = new Vector();
        if (this.m_dimListTo.getModel() instanceof DefaultListModel) {
            int i = 0;
            while (i < this.m_dimListTo.getModel().getSize()) {
                if (this.m_isTable) {
                    int index = ((DefaultListModel)this.m_dimListFrom.getModel()).indexOf(this.m_dimListTo.getModel().getElementAt(i));
                    this.m_selectedMembersVector.addElement(this.m_layerVector.elementAt(index));
                } else {
                    dsItem = (DimListDataItem)this.m_dimListTo.getModel().getElementAt(i);
                    this.m_selectedMembersVector.add(dsItem.getValue());
                }
                ++i;
            }
        }
        return this.m_selectedMembersVector;
    }

    boolean showErrorDialog() {
        if (this.m_selectedButton.isSelected() && this.getSelectedMembers() == null) {
            Object[] formatArgs = new String[]{this.getLayerLabel(this.m_strDimension, "dimShortPluralName")};
            String errorMsg = MessageFormat.format(this.rBundle.getString("discardmessage"), formatArgs);
            JOptionPane jpane = new JOptionPane(errorMsg, 0, -1, new ImageIcon(ImageUtils.getImageResource(MemberPanel.class, (String)"images/stop.gif")));
            jpane.getAccessibleContext().setAccessibleName(errorMsg);
            JDialog tmpDialog = jpane.createDialog(this, this.rBundle.getString("confirmdiscard"));
            tmpDialog.show();
            FocusManager.getCurrentManager().focusNextComponent((Component)this.m_shuttle);
            return false;
        }
        return true;
    }

    private Object getDimensionLabel(Object layer) {
        try {
            DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
            int i = 0;
            while (i < dataAccess.getEdgeCount()) {
                if (!this.m_isTable || i != 1) {
                    int layerCount = dataAccess.getLayerCount(i);
                    int j = 0;
                    while (j < layerCount) {
                        Object dimObj = dataAccess.getLayerMetadata(i, j, "dimName");
                        if (dimObj != null && dimObj.equals(layer)) {
                            Object object = dataAccess.getLayerMetadata(i, j, "dimShortName");
                            return object;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            Object var9_9 = null;
            return var9_9;
        }
        return null;
    }

    private String getLayerLabel(String dimension, String type) {
        if (dimension == null) {
            return null;
        }
        try {
            DataAccess m_dataAccess = this.m_gridView.getModel().getDataAccess();
            int i = 0;
            while (i < m_dataAccess.getEdgeCount()) {
                int layerCount = m_dataAccess.getLayerCount(i);
                int j = 0;
                while (j < layerCount) {
                    Object dimVal = m_dataAccess.getLayerMetadata(i, j, "dimName");
                    String dim = null;
                    if (dimVal != null) {
                        dim = dimVal.toString();
                    }
                    if (dim != null && dim.equals(dimension)) {
                        dimVal = m_dataAccess.getLayerMetadata(i, j, type);
                        if (dimVal != null) {
                            dim = dimVal.toString();
                        }
                        if (dim != null) {
                            String string = dim;
                            return string;
                        }
                        String string = dimension;
                        return string;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return dimension;
    }

    private void $init$() {
        this.m_bSuperCalled = false;
        this.m_locale = null;
        this.rBundle = null;
        this.m_isTable = false;
        this.m_initVector = null;
        this.m_selectedMembersVector = new Vector();
        this.m_dimensionCombo = null;
        this.m_buttonGroup = null;
        this.m_anyButton = null;
        this.m_selectedButton = null;
        this.m_buttonPanel = null;
        this.m_dimListFrom = null;
        this.m_dimListTo = null;
        this.m_listModel = null;
        this.m_listPicker1 = null;
        this.m_listPicker2 = null;
        this.m_shuttle = null;
        this.m_cellRenderer = null;
        this.m_layerVector = null;
        this.m_isHeaderFormat = true;
    }

    static boolean ra$m_isTable(MemberPanel memberPanel) {
        return memberPanel.m_isTable;
    }

    static DataAccessDimensionModel ra$m_listModel(MemberPanel memberPanel) {
        return memberPanel.m_listModel;
    }

    class DimListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component renderer = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (MemberPanel.ra$m_isTable(MemberPanel.this)) {
                this.setText(value.toString());
            } else {
                this.setText(((DimListDataItem)value).getText());
            }
            return renderer;
        }

        DimListCellRenderer() {
        }
    }

    class MyDimensionList
    extends DimensionList {
        private boolean _flag;

        public MyDimensionList() {
            this.$init$();
            this._flag = true;
        }

        public ListModel getModel() {
            if (this._flag) {
                return MemberPanel.ra$m_listModel(MemberPanel.this);
            }
            return super.getModel();
        }

        private void $init$() {
            this._flag = false;
        }
    }

    class MyListPicker
    extends ListPicker {
        public MyListPicker(JList list) {
            super(list);
        }

        private Object getObject(Transferable transferable) {
            DataFlavor[] dataFlavors;
            if (transferable != null && (dataFlavors = transferable.getTransferDataFlavors()) != null) {
                int j = 0;
                while (j < dataFlavors.length) {
                    try {
                        Object object = transferable.getTransferData(dataFlavors[j]);
                        return object;
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                    }
                    catch (IOException ioException) {
                        // empty catch block
                    }
                    ++j;
                }
            }
            return null;
        }

        private boolean contains(Object object) {
            if (object != null) {
                ListModel listModel = this.getList().getModel();
                int i = 0;
                while (i < listModel.getSize()) {
                    if (object.equals(listModel.getElementAt(i))) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public boolean addSelectedItems(Transferable[] selectedItems) {
            Vector<Transferable> vector = new Vector<Transferable>();
            if (selectedItems != null) {
                int i = 0;
                while (i < selectedItems.length) {
                    Object object = this.getObject(selectedItems[i]);
                    if (!this.contains(object)) {
                        vector.add(selectedItems[i]);
                    }
                    ++i;
                }
            }
            selectedItems = vector.toArray(new Transferable[vector.size()]);
            return super.addSelectedItems(selectedItems);
        }
    }
}

