/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.Color;
import java.util.Hashtable;
import oracle.dss.gridView.gui.UIComponentStyle;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.BIPersistenceException;
import oracle.dss.util.persistence.Persistable;
import oracle.dss.util.persistence.PersistableAttributes;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.dss.util.xml.XMLObjectReader;
import oracle.dss.util.xml.XMLObjectWriter;

public class UIStyle
implements Persistable {
    private String m_name;
    private String m_id;
    private String m_type;
    private boolean m_isVerticalGridlines;
    private boolean m_isHorizontalGridlines;
    private UIComponentStyle m_rowHeader;
    private UIComponentStyle m_columnHeader;
    private UIComponentStyle m_databody;
    private UIComponentStyle m_title;
    private UIComponentStyle m_subtitle;
    private UIComponentStyle m_footnote;
    private UIComponentStyle m_pageControl;
    private static final int FONT_SIZE = 12;
    private static final String FONT_NAME = "Dialog";
    private static final int FONT_STYLE = 0;
    private static final Color FOREGROUND_COLOR = Color.black;
    private static final Color BACKGROUND_COLOR = Color.white;
    private static final boolean UNDERLINE = false;
    private static final boolean STRIKETHROUGH = false;
    public static final String TYPE = "Style";
    protected transient PersistableAttributes m_attrs;
    private static final String UI_STYLE = "UISTYLE";
    private static final String a_name = "Name";
    private static final String a_ID = "ID";
    private static final String a_type = "Type";
    private static final String a_horizontalGridLine = "HorizontalGridLine";
    private static final String a_verticalGridLine = "VerticalGridLine";
    private static final String TITLE_COMPONENT = "TITLECOMPONENT";
    private static final String SUBTITLE_COMPONENT = "SUBTITLECOMPONENT";
    private static final String FOOTNOTE_COMPONENT = "FOOTNOTECOMPONENT";
    private static final String PAGE_CONTROL_COMPONENT = "PAGECONTROLCOMPONENT";
    private static final String COLUMN_HEADER_COMPONENT = "COLUMNHEADERCOMPONENT";
    private static final String ROW_HEADER_COMPONENT = "ROWHEADERCOMPONENT";
    private static final String DATABODY_COMPONENT = "DATABODYCOMPONENT";

    private void $init$() {
        this.m_attrs = null;
    }

    public UIStyle() {
        this(null, null, null, true, true);
    }

    public UIStyle(String name, String id, String type, boolean isVerticalGridlines, boolean isHorizontalGridlines) {
        this.$init$();
        this.m_name = name;
        this.m_id = id;
        this.m_type = type;
        this.m_isVerticalGridlines = isVerticalGridlines;
        this.m_isHorizontalGridlines = isHorizontalGridlines;
        this.m_rowHeader = new UIComponentStyle("row header", 12, FONT_NAME, 0, FOREGROUND_COLOR, BACKGROUND_COLOR, false, false);
        this.m_columnHeader = new UIComponentStyle("column header", 12, FONT_NAME, 0, FOREGROUND_COLOR, BACKGROUND_COLOR, false, false);
        this.m_databody = new UIComponentStyle("data body", 12, FONT_NAME, 0, FOREGROUND_COLOR, BACKGROUND_COLOR, false, false);
        this.m_title = new UIComponentStyle("title", 12, FONT_NAME, 0, FOREGROUND_COLOR, BACKGROUND_COLOR, false, false);
        this.m_subtitle = new UIComponentStyle("subtitle", 12, FONT_NAME, 0, FOREGROUND_COLOR, BACKGROUND_COLOR, false, false);
        this.m_footnote = new UIComponentStyle("footnote", 12, FONT_NAME, 0, FOREGROUND_COLOR, BACKGROUND_COLOR, false, false);
        this.m_pageControl = new UIComponentStyle("page control", 12, FONT_NAME, 0, FOREGROUND_COLOR, BACKGROUND_COLOR, false, false);
    }

    public UIStyle(String name, String id, String type, boolean isVerticalGridlines, boolean isHorizontalGridlines, UIComponentStyle rowHeader, UIComponentStyle columnHeader, UIComponentStyle databody, UIComponentStyle title, UIComponentStyle subtitle, UIComponentStyle footnote, UIComponentStyle pageControl) {
        this.$init$();
        this.m_name = name;
        this.m_id = id;
        this.m_type = type;
        this.m_isVerticalGridlines = isVerticalGridlines;
        this.m_isHorizontalGridlines = isHorizontalGridlines;
        this.m_rowHeader = rowHeader;
        this.m_columnHeader = columnHeader;
        this.m_databody = databody;
        this.m_title = title;
        this.m_subtitle = subtitle;
        this.m_footnote = footnote;
        this.m_pageControl = pageControl;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setID(String id) {
        this.m_id = id;
    }

    public String getID() {
        return this.m_id;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public String getType() {
        return this.m_type;
    }

    public void setVerticalGridlines(boolean isVerticalGridlines) {
        this.m_isVerticalGridlines = isVerticalGridlines;
    }

    public boolean isVerticalGridlines() {
        return this.m_isVerticalGridlines;
    }

    public void setHorizontalGridlines(boolean isHorizontalGridlines) {
        this.m_isHorizontalGridlines = isHorizontalGridlines;
    }

    public boolean isHorizontalGridlines() {
        return this.m_isHorizontalGridlines;
    }

    public void initialize(Hashtable env) {
    }

    public AggregateInfo[] getPersistableComponents() {
        return null;
    }

    public void setPersistableComponents(AggregateInfo[] persistables) {
    }

    public PersistableAttributes getPersistableAttributes(PersistableAttributes oldAttrs) {
        PersistableAttributes result = null;
        result = this.m_attrs == null ? new PersistableAttributes() : (PersistableAttributes)this.m_attrs.clone();
        if (oldAttrs != null) {
            result.merge(oldAttrs);
        }
        result.setObjectType(TYPE);
        return result;
    }

    public void setPersistableAttributes(PersistableAttributes attrs) {
        this.m_attrs = attrs;
    }

    public void setRowHeaderStyle(UIComponentStyle style) {
        if (style != null) {
            this.m_rowHeader = style;
        }
    }

    public UIComponentStyle getRowHeaderStyle() {
        return this.m_rowHeader;
    }

    public void setColumnHeaderStyle(UIComponentStyle style) {
        if (style != null) {
            this.m_columnHeader = style;
        }
    }

    public UIComponentStyle getColumnHeaderStyle() {
        return this.m_columnHeader;
    }

    public void setDatabodyStyle(UIComponentStyle style) {
        if (style != null) {
            this.m_databody = style;
        }
    }

    public UIComponentStyle getDatabodyStyle() {
        return this.m_databody;
    }

    public void setTitleStyle(UIComponentStyle style) {
        if (style != null) {
            this.m_title = style;
        }
    }

    public UIComponentStyle getTitleStyle() {
        return this.m_title;
    }

    public void setSubtitleStyle(UIComponentStyle style) {
        if (style != null) {
            this.m_subtitle = style;
        }
    }

    public UIComponentStyle getSubtitleStyle() {
        return this.m_subtitle;
    }

    public void setFootnoteStyle(UIComponentStyle style) {
        if (style != null) {
            this.m_footnote = style;
        }
    }

    public UIComponentStyle getFootnoteStyle() {
        return this.m_footnote;
    }

    public void setPageControlStyle(UIComponentStyle style) {
        if (style != null) {
            this.m_pageControl = style;
        }
    }

    public UIComponentStyle getPageControlStyle() {
        return this.m_pageControl;
    }

    public String getXMLAsString() throws BIPersistenceException {
        XMLObjectWriter writer = new XMLObjectWriter();
        try {
            writer.setIndentMode(1);
            writer.writeObjectNode((BaseObjectNode)this.getObjectNode());
            String string = writer.toString();
            return string;
        }
        catch (BIIOException biioe) {
            String string = null;
            return string;
        }
    }

    private ObjectNode getObjectNode() {
        ObjectNode databodyNode;
        ObjectNode rowHeaderNode;
        ObjectNode columnHeaderNode;
        ObjectNode pageControlNode;
        ObjectNode footnoteNode;
        ObjectNode subtitleNode;
        ObjectNode node = new ObjectNode(UI_STYLE);
        node.addProperty(a_name, this.getName());
        node.addProperty(a_ID, this.getID());
        node.addProperty(a_type, this.getType());
        node.addProperty(a_horizontalGridLine, this.isHorizontalGridlines());
        node.addProperty(a_verticalGridLine, this.isVerticalGridlines());
        ObjectNode titleNode = this.getTitleStyle().getXML(TITLE_COMPONENT);
        if (titleNode != null) {
            node.addProperty(titleNode);
        }
        if ((subtitleNode = this.getSubtitleStyle().getXML(SUBTITLE_COMPONENT)) != null) {
            node.addProperty(subtitleNode);
        }
        if ((footnoteNode = this.getFootnoteStyle().getXML(FOOTNOTE_COMPONENT)) != null) {
            node.addProperty(footnoteNode);
        }
        if ((pageControlNode = this.getPageControlStyle().getXML(PAGE_CONTROL_COMPONENT)) != null) {
            node.addProperty(pageControlNode);
        }
        if ((columnHeaderNode = this.getColumnHeaderStyle().getXML(COLUMN_HEADER_COMPONENT)) != null) {
            node.addProperty(columnHeaderNode);
        }
        if ((rowHeaderNode = this.getRowHeaderStyle().getXML(ROW_HEADER_COMPONENT)) != null) {
            node.addProperty(rowHeaderNode);
        }
        if ((databodyNode = this.getDatabodyStyle().getXML(DATABODY_COMPONENT)) != null) {
            node.addProperty(databodyNode);
        }
        return node;
    }

    public boolean setXMLAsString(String xml) throws BIPersistenceException {
        ObjectNode pageControl;
        ObjectNode databody;
        ObjectNode columnHeader;
        ObjectNode rowHeader;
        ObjectNode footnote;
        ObjectNode subtitle;
        ObjectNode title;
        XMLObjectReader reader = new XMLObjectReader(xml);
        ObjectNode node = null;
        try {
            node = reader.readObjectNode();
        }
        catch (Exception XMLException) {
            boolean bl = false;
            return bl;
        }
        PropertyNode pNode = null;
        pNode = node.getProperty(a_name);
        if (pNode != null) {
            this.setName(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_ID)) != null) {
            this.setID(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_type)) != null) {
            this.setType(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_horizontalGridLine)) != null) {
            this.setHorizontalGridlines(pNode.getValueAsBoolean());
        }
        pNode = node.getProperty(a_verticalGridLine);
        if (pNode != null) {
            this.setVerticalGridlines(pNode.getValueAsBoolean());
        }
        if ((title = node.getPropertyValueAsObjectNode(TITLE_COMPONENT, true)) != null) {
            this.getTitleStyle().setXML(title);
        }
        if ((subtitle = node.getPropertyValueAsObjectNode(SUBTITLE_COMPONENT, true)) != null) {
            this.getSubtitleStyle().setXML(subtitle);
        }
        if ((footnote = node.getPropertyValueAsObjectNode(FOOTNOTE_COMPONENT, true)) != null) {
            this.getFootnoteStyle().setXML(footnote);
        }
        if ((rowHeader = node.getPropertyValueAsObjectNode(ROW_HEADER_COMPONENT, true)) != null) {
            this.getRowHeaderStyle().setXML(rowHeader);
        }
        if ((columnHeader = node.getPropertyValueAsObjectNode(COLUMN_HEADER_COMPONENT, true)) != null) {
            this.getColumnHeaderStyle().setXML(columnHeader);
        }
        if ((databody = node.getPropertyValueAsObjectNode(DATABODY_COMPONENT, true)) != null) {
            this.getDatabodyStyle().setXML(databody);
        }
        if ((pageControl = node.getPropertyValueAsObjectNode(PAGE_CONTROL_COMPONENT, true)) != null) {
            this.getPageControlStyle().setXML(pageControl);
        }
        return true;
    }
}

