/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.pagingControl;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.beans.BeanInfo;
import java.text.MessageFormat;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TextPainter;
import oracle.dss.dataView.BorderPainter;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.pagingControl.PagingControl;
import oracle.dss.pagingControl.PagingControlDefaultValues;

public class PageItem
extends oracle.bali.ewt.pivot.PageItem
implements ViewComponent {
    private PagingControl _pagingControl;
    private int _maximumLabelLength;
    private boolean _wordWrapEnabled;
    private ViewStyle _viewStyle;
    private static String _method_updateResourceBundle = "updateResourceBundle()";

    private void $init$() {
        this._maximumLabelLength = PagingControlDefaultValues.getPageItemMaximumLabelLength();
        this._wordWrapEnabled = PagingControlDefaultValues.isPageItemWordWrapEnabled();
    }

    public PageItem(String name, OneDModel model, PagingControl pagingControl) {
        super(name, model);
        this.$init$();
        this.setName("PagingComponent_PageItem");
        this._pagingControl = pagingControl;
        String description = MessageFormat.format(this.getDescription(), this._pagingControl.getLabelText());
        this.getAccessibleContext().setAccessibleDescription(description);
        this.setPainter((Painter)new EnhancedTextPainter());
        this.setSelectedValuePainter((Painter)new EnhancedTextPainter("pageItem.selectedValue"));
        this.setPainter((Painter)new EnhancedTextPainter());
    }

    public void setMaximumLabelLength(int length) {
        this._maximumLabelLength = length;
    }

    public int getMaximumLabelLength() {
        return this._maximumLabelLength;
    }

    public void setWordWrapEnabled(boolean wordWrap) {
        this._wordWrapEnabled = wordWrap;
    }

    public boolean isWordWrapEnabled() {
        return this._wordWrapEnabled;
    }

    public void setViewStyle(ViewStyle vs) {
        this._viewStyle = vs;
    }

    public ViewStyle getViewStyle() {
        return this._viewStyle;
    }

    public int getID() {
        return 4;
    }

    public String getComponentName() {
        return "PageItem";
    }

    public BeanInfo getBeanInfo() {
        return null;
    }

    private String getDescription() {
        return this._pagingControl.getIntlString("Page Item Description");
    }

    private class EnhancedTextPainter
    extends TextPainter {
        public EnhancedTextPainter() {
        }

        public EnhancedTextPainter(String key) {
            super((Object)key);
        }

        public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
            super.paint(context, g, x, y, width, height);
            ViewStyle app = null;
            try {
                app = (ViewStyle)PageItem.this.getAppearance();
            }
            catch (ClassCastException cce) {
                return;
            }
            int _lineWidth = -1;
            Color _color = null;
            int _top = app.getBorderStyle(1);
            int _bottom = app.getBorderStyle(4);
            int _left = app.getBorderStyle(2);
            int _right = app.getBorderStyle(8);
            int _topWidth = -1;
            int _bottomWidth = -1;
            int _leftWidth = -1;
            int _rightWidth = -1;
            Color _topColor = null;
            Color _bottomColor = null;
            Color _leftColor = null;
            Color _rightColor = null;
            if (app.isBorderWidthUsed(15)) {
                _lineWidth = app.getBorderWidth(15);
            }
            if (app.isBorderWidthUsed(2)) {
                _leftWidth = app.getBorderWidth(2);
            }
            if (app.isBorderWidthUsed(8)) {
                _rightWidth = app.getBorderWidth(8);
            }
            if (app.isBorderWidthUsed(1)) {
                _topWidth = app.getBorderWidth(1);
            }
            if (app.isBorderWidthUsed(4)) {
                _bottomWidth = app.getBorderWidth(4);
            }
            if (app.isBorderColorUsed(15)) {
                _color = app.getBorderColor(15);
            }
            if (app.isBorderColorUsed(2)) {
                _leftColor = app.getBorderColor(2);
            }
            if (app.isBorderColorUsed(8)) {
                _rightColor = app.getBorderColor(8);
            }
            if (app.isBorderColorUsed(1)) {
                _topColor = app.getBorderColor(1);
            }
            if (app.isBorderColorUsed(4)) {
                _bottomColor = app.getBorderColor(4);
            }
            BorderPainter.paintBorder(g, x - 3, y - 3, width + 6, height + 6, _lineWidth, _color, _top, _bottom, _left, _right, _topWidth, _bottomWidth, _leftWidth, _rightWidth, _topColor, _bottomColor, _leftColor, _rightColor);
        }

        protected int paintText(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX, int mnemonicIndex) {
            int retVal = super.paintText(context, g, metrics, text, x, --y, availableWidth, alignmentX, mnemonicIndex);
            this.drawEnhancedFont(context, g, metrics, text, x, y, availableWidth, alignmentX);
            return retVal;
        }

        protected void drawEnhancedFont(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX) {
            int stringWidth;
            ViewStyle app = null;
            try {
                app = (ViewStyle)PageItem.this.getAppearance();
            }
            catch (ClassCastException cce) {
                return;
            }
            String paintText = this.getPaintText(context, text, metrics, availableWidth);
            if (alignmentX != 0.0f && (stringWidth = metrics.stringWidth(paintText)) < availableWidth) {
                x = (int)((float)x + (float)(availableWidth - stringWidth) * alignmentX);
            }
            if (app.isUnderline()) {
                g.drawLine(x, y + 2, x + metrics.stringWidth(paintText), y + 2);
            } else if (app.isDoubleUnderline()) {
                g.drawLine(x, y + 2, x + metrics.stringWidth(paintText), y + 2);
                g.drawLine(x, y + 4, x + metrics.stringWidth(paintText), y + 4);
            }
            if (app.isStrikeThrough()) {
                g.drawLine(x, y - metrics.getAscent() / 2 + 1, x + metrics.stringWidth(paintText), y - metrics.getAscent() / 2 + 1);
            }
        }
    }
}

